/*
 * Decompiled with CFR 0.152.
 */
package characterization.shapes;

import java.awt.image.BufferedImage;
import java.util.List;
import mathematics.primitives.pointsTiTi.Coordinates;
import measures.BasicMeasures;

public class FreemanChainCode {
    protected int[] ChainCode = null;
    protected int[] Histogram = new int[8];

    public void Compute(BufferedImage source, boolean EightConnex) {
        BasicMeasures Bbcps = new BasicMeasures();
        Bbcps.Compute(source, EightConnex);
        Bbcps.ComputeClockWiseBoundary();
        this.Compute(Bbcps.ClockWiseBoundary.Points());
    }

    public void Compute(List<Coordinates> Liste) {
        int i2;
        if (Liste == null || Liste.size() < 2) {
            throw new Error("Liste = null ou nombre de points inferieur e 2!");
        }
        int Length = Liste.size();
        this.Histogram = null;
        this.Histogram = new int[8];
        this.ChainCode = null;
        this.ChainCode = new int[Length];
        for (i2 = 0; i2 < Length; ++i2) {
            int dx = Liste.get((int)((i2 + 1) % Liste.size())).X - Liste.get((int)i2).X;
            int dy = Liste.get((int)((i2 + 1) % Liste.size())).Y - Liste.get((int)i2).Y;
            if (dx == 1 && dy == 0) {
                this.ChainCode[i2] = 0;
                continue;
            }
            if (dx == 1 && dy == 1) {
                this.ChainCode[i2] = 1;
                continue;
            }
            if (dx == 0 && dy == 1) {
                this.ChainCode[i2] = 2;
                continue;
            }
            if (dx == -1 && dy == 1) {
                this.ChainCode[i2] = 3;
                continue;
            }
            if (dx == -1 && dy == 0) {
                this.ChainCode[i2] = 4;
                continue;
            }
            if (dx == -1 && dy == -1) {
                this.ChainCode[i2] = 5;
                continue;
            }
            if (dx == 0 && dy == -1) {
                this.ChainCode[i2] = 6;
                continue;
            }
            if (dx == 1 && dy == -1) {
                this.ChainCode[i2] = 7;
                continue;
            }
            throw new Error("Cas impossible : dx=" + dx + ", dy=" + dy);
        }
        for (i2 = 0; i2 < Length; ++i2) {
            int n = this.ChainCode[i2];
            this.Histogram[n] = this.Histogram[n] + 1;
        }
    }

    public int[] getHistogram() {
        return this.Histogram;
    }

    public int[] getChainCode() {
        return this.ChainCode;
    }
}

