/*
 * Decompiled with CFR 0.152.
 */
package characterization;

import characterization.ComputableFeatures;
import dv.DV;
import dv.DvComparator;
import dv.DvIO;
import dv.DvNew;
import filesAndFolders.FileNameFilters;
import filesAndFolders.FilesFolders;
import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleTools;
import imageTiTi.ImageIO;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import utils.LogFile;

public class MasterCharacterizer {
    public LogFile log = new LogFile();
    private int margin = 0;

    public void Characterize(List<File> files, Source type, List<File> masks, List<ComputableFeatures> actions, String name, boolean kill, boolean iterativesave, int nbCPU) {
        int nb;
        if (!this.log.isRunning()) {
            try {
                this.log.StartNewLog(this, "./");
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException("Cannot start the log file.");
            }
        }
        if (masks != null && files.size() != masks.size()) {
            throw new IllegalArgumentException("files.size() != masks.size()");
        }
        int attributes = 0;
        Iterator<ComputableFeatures> iteractions = actions.iterator();
        while (iteractions.hasNext()) {
            attributes += iteractions.next().Features().length;
        }
        int[] coltypes = new int[attributes + 1];
        Arrays.fill(coltypes, 1);
        coltypes[coltypes.length - 1] = 2;
        FichierTabule file = new FichierTabule(files.size(), coltypes, "");
        file.setColumnName(file.Width() - 1, "File");
        coltypes = null;
        int colpos = 0;
        for (ComputableFeatures action : actions) {
            nb = action.Features().length;
            System.out.println(action.getClass().getSimpleName() + " done\n\n\n\n");
            this.Characterize(files, type, masks, action, file, colpos, nbCPU);
            System.arraycopy(action.FeaturesNames(), 0, file.getColumnsNames(), colpos, nb);
            colpos += nb;
            if (iterativesave) {
                file.Write(name, false);
            }
            if (kill) {
                action.Kill();
                System.gc();
            }
            action = null;
        }
        iteractions = null;
        nb = 0;
        Iterator<File> iterfiles = files.iterator();
        while (iterfiles.hasNext()) {
            file.setValue(nb++, colpos, iterfiles.next().getAbsolutePath());
        }
        file.Write(name, false);
        file.Kill();
        try {
            this.log.Stop();
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot stop the log file.");
        }
    }

    public void Characterize(List<File> files, Source type, List<File> masks, ComputableFeatures action, FichierTabule file, int colpos, int nbCPU) {
        Iterator<File> itermasks;
        boolean stop = false;
        if (!this.log.isRunning()) {
            try {
                this.log.StartNewLog(this, "./");
                stop = true;
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException("Cannot start the log file.");
            }
        }
        int pos = 0;
        Iterator<File> iterfiles = files.iterator();
        Iterator<File> iterator = itermasks = masks != null ? masks.iterator() : null;
        while (iterfiles.hasNext()) {
            this.Characterize(iterfiles.next(), type, itermasks != null ? itermasks.next() : null, action, file, pos++, colpos, nbCPU);
        }
        itermasks = null;
        iterfiles = null;
        if (stop) {
            try {
                this.log.Stop();
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot stop the log file.");
            }
        }
    }

    private void Characterize(File srcfile, Source type, File maskfile, ComputableFeatures action, FichierTabule file, int rowpos, int colpos, int nbCPU) {
        try {
            switch (type) {
                case Image: {
                    BufferedImage image = ImageIO.Read(srcfile);
                    BufferedImage mask = maskfile != null ? ImageIO.Read(maskfile) : null;
                    action.Compute(image, mask, action.ForbiddenValue(), nbCPU);
                    image = null;
                    break;
                }
                case DV: {
                    DV dv = DvIO.Read(srcfile.getAbsolutePath());
                    if (maskfile != null) {
                        DV dvmask = DvIO.Read(maskfile.getAbsolutePath());
                        DvComparator.Compare((DV)dvmask, (String)"!=", (int)0, (DV)dv, (int)0, (DV)dv);
                        dvmask.Kill();
                        dvmask = null;
                    }
                    if (0 < this.margin) {
                        DV dvnew = new DV(dv.SizeX + 2 * this.margin, dv.SizeY + 2 * this.margin, dv.SizeZ + 2 * this.margin, dv.Channel, dv.Type);
                        DvNew.CopyIntoBigger((DV)dv, (DV)dvnew, (int)this.margin, (int)this.margin, (int)this.margin);
                        dv.Kill();
                        dv = null;
                        dv = dvnew;
                        dvnew = null;
                    }
                    action.Compute(dv, nbCPU);
                    dv.Kill();
                    dv = null;
                    break;
                }
                case ImageSequence: {
                    DV seq = DvIO.ReadFromStack(srcfile.getAbsolutePath(), FilesFolders.ComparatorLength(), FileNameFilters.ImagesPNGorTIF);
                    if (maskfile != null) {
                        DV dvmask = DvIO.ReadFromStack(maskfile.getAbsolutePath(), FilesFolders.ComparatorLength(), FileNameFilters.ImagesPNGorTIF);
                        DvComparator.Compare((DV)dvmask, (String)"!=", (int)0, (DV)seq, (int)0, (DV)seq);
                        dvmask.Kill();
                        dvmask = null;
                    }
                    action.Compute(seq, nbCPU);
                    seq.Kill();
                    seq = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Must not occur!");
                }
            }
            double[] features = action.Features();
            for (int f = 0; f < features.length; ++f) {
                file.setValue(rowpos, colpos++, features[f]);
            }
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
                this.log.addNewException(ex, new String[0]);
                this.log.addComment("Position " + rowpos + "x" + colpos + ", image '" + srcfile.getAbsolutePath() + "'.\n\n");
            }
            catch (Exception ex1) {
                System.err.println("Impossible to write the exception into the log file.");
                System.exit(0);
            }
        }
    }

    public FichierTabule Characterize(List<File> files, Source type, List<File> masks, List<ComputableFeatures> actions, int nbCPU) throws IOException {
        if (this.log.isRunning()) {
            this.log.Stop();
        }
        this.log.StartNewLog(this, "./");
        if (masks != null && masks.size() != files.size()) {
            throw new IllegalArgumentException("masks.size() != files.size(): " + masks.size() + " vs " + files.size());
        }
        int count = 0;
        Iterator<ComputableFeatures> iteract = actions.iterator();
        while (iteract.hasNext()) {
            count += iteract.next().Features().length;
        }
        String[] colnames = new String[count + 1];
        iteract = actions.iterator();
        int pos = 1;
        while (iteract.hasNext()) {
            ComputableFeatures action = iteract.next();
            String[] featuresnames = action.FeaturesNames();
            System.arraycopy(featuresnames, 0, colnames, pos, featuresnames.length);
            pos += featuresnames.length;
        }
        colnames[0] = "Images";
        int[] types = new int[colnames.length];
        Arrays.fill(types, 1);
        types[0] = 2;
        FichierTabule results = new FichierTabule(files.size(), types, "Results");
        results.setColumnsNames(colnames);
        Iterator<File> iterfiles = files.iterator();
        Iterator<File> itermasks = masks != null ? masks.iterator() : null;
        int row = 0;
        while (iterfiles.hasNext()) {
            File imfile = iterfiles.next();
            File maskfile = itermasks != null ? itermasks.next() : null;
            int col = 0;
            try {
                switch (type) {
                    case Image: {
                        BufferedImage image = ImageIO.Read(imfile);
                        BufferedImage mask = maskfile != null ? ImageIO.Read(maskfile) : null;
                        results.setValue(row, col++, imfile.getName());
                        if (ImageTools.isBlack((BufferedImage)image) || ImageTools.isWhite((BufferedImage)image)) {
                            this.log.addComment("WARNING - Image '" + imfile.getName() + "' is extreme.");
                            System.out.println("WARNING - Image '" + imfile.getName() + "' is extreme.");
                        }
                        if (mask != null && ImageTools.isBlack((BufferedImage)mask)) {
                            this.log.addComment("WARNING - Mask of image '" + imfile.getName() + "' is empty.");
                            System.out.println("WARNING - Mask of image '" + imfile.getName() + "' is empty.");
                        }
                        for (ComputableFeatures action : actions) {
                            action.Compute(image, mask, action.ForbiddenValue(), nbCPU);
                            double[] features = action.Features();
                            for (int f = 0; f < features.length; ++f) {
                                results.setValue(row, col++, features[f]);
                            }
                        }
                        mask = null;
                        image = null;
                        break;
                    }
                    case DV: {
                        throw new IllegalStateException("DV not supported (yet).");
                    }
                    case ImageSequence: {
                        throw new IllegalStateException("Image sequence not supported (yet).");
                    }
                    default: {
                        throw new IllegalArgumentException("Must not occur!");
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.log.addNewException(ex, new String[0]);
                this.log.addComment("Exception: '" + imfile.getAbsolutePath() + "' (row=" + row + "), col=" + col + ".");
            }
            catch (Error err) {
                err.printStackTrace();
                this.log.addNewError(err, new String[0]);
                this.log.addComment("Error: '" + imfile.getAbsolutePath() + "' (row=" + row + "), col=" + col + ".");
            }
            ++row;
        }
        itermasks = null;
        iterfiles = null;
        iteract = null;
        this.log.Stop();
        return results;
    }

    public void SplitAndMatch(FichierTabule file, List<ComputableFeatures> actions, FichierTabule classes) {
        int count = 0;
        classes.setSelectedColumn(0, true);
        classes.ExcludeSelectedColumns();
        for (ComputableFeatures action : actions) {
            file.ClearSelectionColumns();
            Arrays.fill(file.getSelectedColumn(), count, count + action.Features().length, true);
            file.setSelectedColumn(file.getWidth() - 1, true);
            FichierTabule result = FichierTabuleTools.CopySelectedColumns(file);
            result = FichierTabuleTools.MergeSideBySide(result, classes);
            result.Write(action.ID() + ".txt", false);
            count += action.Features().length;
        }
    }

    public void Margin(int margin) {
        if (margin < 0) {
            throw new IllegalArgumentException("margin < 0");
        }
        this.margin = margin;
    }

    public static enum Source {
        Image,
        DV,
        ImageSequence;

    }
}

