/*
 * Decompiled with CFR 0.152.
 */
package characterization;

import characterization.ComputableFeatures;
import characterization.textures.BasicTexturalFeatures;
import characterization.textures.lbp.LocalBinaryPattern;
import characterization.textures.lbp.MultiLBP;
import characterization.textures.statisticalmatrices.com.Haralick;
import characterization.textures.statisticalmatrices.rlm.FuzzyRLMfeatures;
import characterization.textures.statisticalmatrices.rlm.MultiFuzzyRLM;
import characterization.textures.statisticalmatrices.rlm.MultiRLM;
import characterization.textures.statisticalmatrices.rlm.RLMfeatures;
import characterization.textures.statisticalmatrices.thibaultmatrices.szm.FuzzySZMfeatures;
import characterization.textures.statisticalmatrices.thibaultmatrices.szm.MultiFuzzySZM;
import characterization.textures.statisticalmatrices.thibaultmatrices.szm.MultiSZM;
import characterization.textures.statisticalmatrices.thibaultmatrices.szm.SZMfeatures;
import java.util.ArrayList;
import java.util.List;
import mathematics.functions.MembershipFunctions;
import morphee.StructuringElement3D;
import morphee.granulometry.PatternSpectrum;
import processing.reducer.ColorReducer;
import processing.reducer.FuzzyGLR;
import processing.reducer.HistogramGLR;
import processing.reducer.MinMaxLinearGLR;

public final class Features {
    public static List<ComputableFeatures> Full(int ForbiddenValue) {
        ArrayList<ComputableFeatures> characterizers = new ArrayList<ComputableFeatures>(43);
        Features.AddBasics(characterizers, ForbiddenValue);
        Features.AddSZM(characterizers, new MinMaxLinearGLR(), ForbiddenValue, true, 8, 16, 32, 64, 128, 256);
        Features.AddSZM(characterizers, new HistogramGLR(), ForbiddenValue, true, 8, 16, 32, 64, 128, 256);
        Features.AddMultiSZM(characterizers, new MinMaxLinearGLR(), ForbiddenValue, true);
        Features.AddMultiSZM(characterizers, new HistogramGLR(), ForbiddenValue, true);
        Features.AddFuzzySZMlinear(characterizers, -1, ForbiddenValue, true, 1, 2, 3, 5, 7, 11);
        Features.AddFuzzySZMlinear(characterizers, -2, ForbiddenValue, true, 1, 2, 3, 5, 7, 11);
        Features.AddFuzzySZMconvex(characterizers, -1, ForbiddenValue, true, 2, 1, 2, 3, 5, 7, 11);
        Features.AddFuzzySZMconvex(characterizers, -1, ForbiddenValue, true, 3, 1, 2, 3, 5, 7, 11);
        Features.AddFuzzySZMconvex(characterizers, -1, ForbiddenValue, true, 4, 1, 2, 3, 5, 7, 11);
        Features.AddFuzzySZMconvex(characterizers, -2, ForbiddenValue, true, 2, 1, 2, 3, 5, 7, 11);
        Features.AddFuzzySZMconvex(characterizers, -2, ForbiddenValue, true, 3, 1, 2, 3, 5, 7, 11);
        Features.AddFuzzySZMconvex(characterizers, -2, ForbiddenValue, true, 4, 1, 2, 3, 5, 7, 11);
        Features.AddFuzzySZMconcave(characterizers, -1, ForbiddenValue, true, 2, 1, 2, 3, 5, 7, 11);
        Features.AddFuzzySZMconcave(characterizers, -1, ForbiddenValue, true, 3, 1, 2, 3, 5, 7, 11);
        Features.AddFuzzySZMconcave(characterizers, -1, ForbiddenValue, true, 4, 1, 2, 3, 5, 7, 11);
        Features.AddFuzzySZMconcave(characterizers, -2, ForbiddenValue, true, 2, 1, 2, 3, 5, 7, 11);
        Features.AddFuzzySZMconcave(characterizers, -2, ForbiddenValue, true, 3, 1, 2, 3, 5, 7, 11);
        Features.AddFuzzySZMconcave(characterizers, -2, ForbiddenValue, true, 4, 1, 2, 3, 5, 7, 11);
        Features.AddMultiFuzzySZM(characterizers, -1, ForbiddenValue, true);
        Features.AddMultiFuzzySZM(characterizers, -2, ForbiddenValue, true);
        Features.AddHaralick(characterizers, new MinMaxLinearGLR(), ForbiddenValue, 8, 16, 32, 64, 128, 256);
        Features.AddHaralick(characterizers, new HistogramGLR(), ForbiddenValue, 8, 16, 32, 64, 128, 256);
        Features.AddRLM(characterizers, new MinMaxLinearGLR(), ForbiddenValue, 8, 16, 32, 64, 128, 256);
        Features.AddRLM(characterizers, new HistogramGLR(), ForbiddenValue, 8, 16, 32, 64, 128, 256);
        Features.AddMultiRLM(characterizers, new MinMaxLinearGLR(), ForbiddenValue);
        Features.AddMultiRLM(characterizers, new HistogramGLR(), ForbiddenValue);
        Features.AddFuzzyRLMlinear(characterizers, -1, ForbiddenValue, 1, 2, 3, 5, 7, 11);
        Features.AddFuzzyRLMlinear(characterizers, -2, ForbiddenValue, 1, 2, 3, 5, 7, 11);
        Features.AddFuzzyRLMconvex(characterizers, -1, ForbiddenValue, 2, 1, 2, 3, 5, 7, 11);
        Features.AddFuzzyRLMconvex(characterizers, -1, ForbiddenValue, 3, 1, 2, 3, 5, 7, 11);
        Features.AddFuzzyRLMconvex(characterizers, -1, ForbiddenValue, 4, 1, 2, 3, 5, 7, 11);
        Features.AddFuzzyRLMconvex(characterizers, -2, ForbiddenValue, 2, 1, 2, 3, 5, 7, 11);
        Features.AddFuzzyRLMconvex(characterizers, -2, ForbiddenValue, 3, 1, 2, 3, 5, 7, 11);
        Features.AddFuzzyRLMconvex(characterizers, -2, ForbiddenValue, 4, 1, 2, 3, 5, 7, 11);
        Features.AddFuzzyRLMconcave(characterizers, -1, ForbiddenValue, 2, 1, 2, 3, 5, 7, 11);
        Features.AddFuzzyRLMconcave(characterizers, -1, ForbiddenValue, 3, 1, 2, 3, 5, 7, 11);
        Features.AddFuzzyRLMconcave(characterizers, -1, ForbiddenValue, 4, 1, 2, 3, 5, 7, 11);
        Features.AddFuzzyRLMconcave(characterizers, -2, ForbiddenValue, 2, 1, 2, 3, 5, 7, 11);
        Features.AddFuzzyRLMconcave(characterizers, -2, ForbiddenValue, 3, 1, 2, 3, 5, 7, 11);
        Features.AddFuzzyRLMconcave(characterizers, -2, ForbiddenValue, 4, 1, 2, 3, 5, 7, 11);
        Features.AddMultiFuzzyRLM(characterizers, -1, ForbiddenValue);
        Features.AddMultiFuzzyRLM(characterizers, -2, ForbiddenValue);
        Features.AddPatternSpectrum(characterizers, -9);
        return characterizers;
    }

    public static void AddBasics(List<ComputableFeatures> characterizers, int ForbiddenValue) {
        BasicTexturalFeatures btf = new BasicTexturalFeatures();
        btf.Parameters(ForbiddenValue);
        characterizers.add(btf);
    }

    public static void AddSZM(List<ComputableFeatures> characterizers, ColorReducer grl, int ForbiddenValue, boolean Connex, int ... levels) {
        for (int l = 0; l < levels.length; ++l) {
            SZMfeatures szm = new SZMfeatures();
            szm.Parameters(levels[l], 1, grl, ForbiddenValue, Connex);
            characterizers.add(szm);
            szm = null;
        }
    }

    public static void AddMultiSZM(List<ComputableFeatures> characterizers, ColorReducer grl, int ForbiddenValue, boolean Connex) {
        MultiSZM mmlin = new MultiSZM();
        mmlin.Parameters(1, grl, ForbiddenValue, Connex);
        characterizers.add(mmlin);
    }

    public static void AddFuzzySZMlinear(List<ComputableFeatures> characterizers, int mode, int ForbiddenValue, boolean Connex, int ... radii) {
        for (int r = 0; r < radii.length; ++r) {
            FuzzySZMfeatures fszm = new FuzzySZMfeatures();
            fszm.Parameters(mode, new FuzzyGLR(radii[r], 8, MembershipFunctions.Linear(radii[r])), ForbiddenValue, Connex);
            characterizers.add(fszm);
            fszm = null;
        }
    }

    public static void AddFuzzySZMconvex(List<ComputableFeatures> characterizers, int mode, int ForbiddenValue, boolean Connex, int power, int ... radii) {
        for (int r = 0; r < radii.length; ++r) {
            FuzzySZMfeatures fszm = new FuzzySZMfeatures();
            fszm.Parameters(mode, new FuzzyGLR(radii[r], 8, MembershipFunctions.PolynomialConvex(power, radii[r])), ForbiddenValue, Connex);
            characterizers.add(fszm);
            fszm = null;
        }
    }

    public static void AddFuzzySZMconcave(List<ComputableFeatures> characterizers, int mode, int ForbiddenValue, boolean Connex, int power, int ... radii) {
        for (int r = 0; r < radii.length; ++r) {
            FuzzySZMfeatures fszm = new FuzzySZMfeatures();
            fszm.Parameters(mode, new FuzzyGLR(radii[r], 8, MembershipFunctions.PolynomialConcave(power, radii[r])), ForbiddenValue, Connex);
            characterizers.add(fszm);
            fszm = null;
        }
    }

    public static void AddMultiFuzzySZM(List<ComputableFeatures> characterizers, int mode, int ForbiddenValue, boolean Connex) {
        double[] weights = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        MultiFuzzySZM mfszm = new MultiFuzzySZM();
        mfszm.Parameters(1, 11, 2, mode, ForbiddenValue, Connex, weights);
        characterizers.add(mfszm);
        MultiFuzzySZM mfszm3 = new MultiFuzzySZM();
        mfszm3.Parameters(2, 17, 3, mode, ForbiddenValue, Connex, weights);
        characterizers.add(mfszm3);
        MultiFuzzySZM mfszm5 = new MultiFuzzySZM();
        mfszm5.Parameters(5, 30, 5, mode, ForbiddenValue, Connex, weights);
        characterizers.add(mfszm5);
    }

    public static void AddHaralick(List<ComputableFeatures> characterizers, ColorReducer grl, int ForbiddenValue, int ... levels) {
        for (int l = 0; l < levels.length; ++l) {
            Haralick har = new Haralick();
            har.Parameters(grl, levels[l], ForbiddenValue);
            characterizers.add(har);
        }
    }

    public static void AddRLM(List<ComputableFeatures> characterizers, ColorReducer grl, int ForbiddenValue, int ... levels) {
        for (int l = 0; l < levels.length; ++l) {
            RLMfeatures rlm = new RLMfeatures();
            rlm.Parameters(levels[l], grl, ForbiddenValue);
            characterizers.add(rlm);
            rlm = null;
        }
    }

    public static void AddMultiRLM(List<ComputableFeatures> characterizers, ColorReducer grl, int ForbiddenValue) {
        MultiRLM mrlm = new MultiRLM();
        mrlm.Parameters(grl, ForbiddenValue);
        characterizers.add(mrlm);
        mrlm = null;
    }

    public static void AddFuzzyRLMlinear(List<ComputableFeatures> characterizers, int mode, int ForbiddenValue, int ... radii) {
        for (int r = 0; r < radii.length; ++r) {
            FuzzyRLMfeatures frlm = new FuzzyRLMfeatures();
            frlm.Parameters(mode, new FuzzyGLR(radii[r], 8, MembershipFunctions.Linear(radii[r])), ForbiddenValue);
            characterizers.add(frlm);
            frlm = null;
        }
    }

    public static void AddFuzzyRLMconvex(List<ComputableFeatures> characterizers, int mode, int ForbiddenValue, int power, int ... radii) {
        for (int r = 0; r < radii.length; ++r) {
            FuzzyRLMfeatures frlm = new FuzzyRLMfeatures();
            frlm.Parameters(mode, new FuzzyGLR(radii[r], 8, MembershipFunctions.PolynomialConvex(power, radii[r])), ForbiddenValue);
            characterizers.add(frlm);
            frlm = null;
        }
    }

    public static void AddFuzzyRLMconcave(List<ComputableFeatures> characterizers, int mode, int ForbiddenValue, int power, int ... radii) {
        for (int r = 0; r < radii.length; ++r) {
            FuzzyRLMfeatures frlm = new FuzzyRLMfeatures();
            frlm.Parameters(mode, new FuzzyGLR(radii[r], 8, MembershipFunctions.PolynomialConcave(power, radii[r])), ForbiddenValue);
            characterizers.add(frlm);
            frlm = null;
        }
    }

    public static void AddMultiFuzzyRLM(List<ComputableFeatures> characterizers, int mode, int ForbiddenValue) {
        double[] weights = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        MultiFuzzyRLM mfrlm = new MultiFuzzyRLM();
        mfrlm.Parameters(1, 11, 2, mode, ForbiddenValue, weights);
        characterizers.add(mfrlm);
        MultiFuzzyRLM mfrlm3 = new MultiFuzzyRLM();
        mfrlm3.Parameters(2, 17, 3, mode, ForbiddenValue, weights);
        characterizers.add(mfrlm3);
        MultiFuzzyRLM mfrlm5 = new MultiFuzzyRLM();
        mfrlm5.Parameters(5, 30, 5, mode, ForbiddenValue, weights);
        characterizers.add(mfrlm5);
        weights = null;
    }

    public static void AddLBP(List<ComputableFeatures> characterizers) {
        LocalBinaryPattern lbp1 = new LocalBinaryPattern();
        lbp1.Parameters(new StructuringElement3D(new Object[]{1, -13, 8}), 1, 0);
        characterizers.add(lbp1);
        LocalBinaryPattern lbp2 = new LocalBinaryPattern();
        lbp2.Parameters(new StructuringElement3D(new Object[]{2, -13, 8}), 1, 0);
        characterizers.add(lbp2);
        LocalBinaryPattern lbp21 = new LocalBinaryPattern();
        lbp21.Parameters(new StructuringElement3D(new Object[]{1, -13, 8}), 2, 0);
        characterizers.add(lbp21);
        LocalBinaryPattern lbp22 = new LocalBinaryPattern();
        lbp22.Parameters(new StructuringElement3D(new Object[]{2, -13, 8}), 2, 0);
        characterizers.add(lbp22);
    }

    public static void AddMultiLBP(List<ComputableFeatures> characterizers) {
        double[] weights = new double[]{1.0, 1.0, 1.0};
        MultiLBP mlbp1 = new MultiLBP();
        mlbp1.Parameters(1, 3, 1, 0, 1, weights);
        characterizers.add(mlbp1);
        MultiLBP mlbp2 = new MultiLBP();
        mlbp2.Parameters(1, 5, 2, 0, 1, weights);
        characterizers.add(mlbp2);
        MultiLBP mlbp12 = new MultiLBP();
        mlbp12.Parameters(1, 3, 1, 0, 2, weights);
        characterizers.add(mlbp12);
        MultiLBP mlbp22 = new MultiLBP();
        mlbp22.Parameters(1, 5, 2, 0, 2, weights);
        characterizers.add(mlbp22);
        weights = null;
    }

    public static void AddPatternSpectrum(List<ComputableFeatures> characterizers, Object se) {
        PatternSpectrum ps1 = new PatternSpectrum();
        ps1.Parameters(1, 5, 1, 0, se);
        characterizers.add(ps1);
        PatternSpectrum ps2 = new PatternSpectrum();
        ps2.Parameters(1, 11, 2, 0, se);
        characterizers.add(ps2);
    }
}

