/*
 * Decompiled with CFR 0.152.
 */
package characterization;

import characterization.ComputableFeatures;
import filesAndFolders.fichiersTabules.FichierTabule;
import imageTiTi.ImageConverter;
import imageTiTi.ImageDrawer;
import imageTiTi.ImageIO;
import java.awt.image.BufferedImage;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.util.Arrays;
import processing.thresholding.Binary;
import utils.LogFile;

public class Characterizer {
    private DataOutputStream Out = null;
    private boolean binarize = false;
    private final Binary binary = new Binary();
    private boolean blackborder = false;
    private LogFile log = null;
    private int colimage;
    private int colclass;

    public void Characterize(File Folder, FileFilter ff, ComputableFeatures action, FichierTabule file, String result, int nbCPU) throws Exception {
        System.err.println("WARNING - this class hasn't been updated to support a computational value.");
        if (!Folder.isDirectory()) {
            throw new IllegalArgumentException("This file is not a directory.");
        }
        this.colimage = file != null ? file.ColumnNumber("Image") : -1;
        this.colclass = file != null ? file.ColumnNumber("Class") : -1;
        this.log = new LogFile();
        this.log.StartNewLog(this, "./");
        try {
            File res = new File(result);
            File parents = res.getParentFile();
            if (!parents.exists()) {
                parents.mkdirs();
            }
            if (!res.exists() && !res.createNewFile()) {
                throw new Exception("Impossible to create result file.");
            }
            this.Out = new DataOutputStream(new FileOutputStream(result));
            this.WriteColumnNames(action.FeaturesNames(), file != null);
        }
        catch (Exception e) {
            this.log.addNewException(e, new String[0]);
            this.log.Stop();
            System.exit(0);
        }
        this.Characterize(Folder, ff, action, file, nbCPU);
        System.err.println(this.log.Resume());
        this.log.Stop();
    }

    private void Characterize(File Folder, FileFilter ff, ComputableFeatures action, FichierTabule file, int nbCPU) throws Exception {
        File[] listfiles;
        for (File listfile : listfiles = Folder.listFiles(ff)) {
            if (listfile.isFile()) {
                this.Characterizer(listfile, action, file, nbCPU);
                continue;
            }
            this.Characterize(listfile, ff, action, file, nbCPU);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void Characterizer(File imfile, ComputableFeatures action, FichierTabule file, int nbCPU) throws Exception {
        BufferedImage image = null;
        BufferedImage vignette = null;
        try {
            image = ImageIO.Read(imfile.getAbsolutePath());
            if (this.blackborder) {
                ImageDrawer.Border(image, 0, 1);
            }
            if (this.binarize) {
                image = this.binary.Filter(image, 1, 1);
            }
            switch (image.getType()) {
                case 10: 
                case 11: 
                case 12: {
                    vignette = image;
                    break;
                }
                case 5: {
                    vignette = ImageConverter.RGB_To_GrayLevel((BufferedImage)image, (int)1);
                }
            }
            action.Compute(vignette, null, -1, nbCPU);
        }
        catch (Error E) {
            Arrays.fill(action.Features(), Double.NaN);
            this.log.addNewError(E, new String[0]);
            this.log.addComment(imfile.getAbsolutePath() + "\n\n");
        }
        catch (Exception E) {
            Arrays.fill(action.Features(), Double.NaN);
            this.log.addNewException(E, new String[0]);
            this.log.addComment(imfile.getAbsolutePath() + "\n\n");
        }
        finally {
            image = null;
            vignette = null;
        }
        try {
            double[] features = action.Features();
            for (int i2 = 0; i2 < features.length; ++i2) {
                this.Out.write(String.valueOf(features[i2] + " ").getBytes("ASCII"));
            }
            this.Out.write(String.valueOf("\"" + imfile.getParent() + "\" \"" + imfile.getName() + "\"").getBytes("ASCII"));
            if (file != null) {
                file.SelectWhere(this.colimage, 0, imfile.getName());
                int row = file.FirstSelected();
                if (file.nbSelected() != 1) {
                    this.Out.write(" \"?\"".getBytes("ASCII"));
                } else {
                    this.Out.write(String.valueOf(" \"" + file.getValueString(row, this.colclass) + "\"").getBytes("ASCII"));
                }
            }
            this.Out.write(String.valueOf("\n").getBytes("ASCII"));
        }
        catch (Error E) {
            this.log.addNewError(E, new String[0]);
        }
        catch (Exception E) {
            this.log.addNewException(E, new String[0]);
        }
    }

    public void BinarizeBeforeCharacterization(boolean needbinarization) {
        this.binarize = needbinarization;
    }

    public void DrawBlackBorderBeforeCharacterization(boolean DrawBlackBorder) {
        this.blackborder = DrawBlackBorder;
    }

    private void WriteColumnNames(String[] FeaturesNames, boolean addclass) {
        try {
            for (int i2 = 0; i2 < FeaturesNames.length; ++i2) {
                this.Out.write(String.valueOf("\"" + FeaturesNames[i2] + "\" ").getBytes("ASCII"));
            }
            this.Out.write("\"Folder\" \"Image\"".getBytes("ASCII"));
            if (addclass) {
                this.Out.write(" \"Class\"".getBytes("ASCII"));
            }
            this.Out.write(String.valueOf("\n").getBytes("ASCII"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Error e) {
            e.printStackTrace();
        }
    }
}

