/*
 * Decompiled with CFR 0.152.
 */
package characterization;

import characterization.PreComputable;
import characterization.textures.statisticalmatrices.rlm.RLMfeatures;
import characterization.textures.statisticalmatrices.thibaultmatrices.olzm.GlolzmFeatures;
import characterization.textures.statisticalmatrices.thibaultmatrices.szm.SZMfeatures;
import imageTiTi.ImageConverter;
import imageTiTi.ImageIO;
import java.awt.image.BufferedImage;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import measures.hedgehop.Distance;
import morphee.granulometry.AntiGranulometryMultiSE;
import morphee.granulometry.GranulometryMultiSE;
import morphee.granulometry.PatternSpectrumMultiSE;
import morphee.levelings.Leveling;
import processing.reducer.ColorReducer;
import utils.times.Chronometer;

public class CharacterizePC {
    public static final int RGB_TO_CHANNEL0 = 0;
    public static final int RGB_TO_CHANNEL1 = 1;
    public static final int RGB_TO_CHANNEL2 = 2;
    public static final int RGB_TO_GRAY601 = 3;
    public static final int RGB_TO_GRAY709 = 4;
    private PreComputable action = null;
    private int nbErrors = -1;
    private DataOutputStream Out = null;
    private int abscisse;
    private int ordonnee;

    public void Extract(File Folder, BufferedImage source, File Result, int convertion, int nbCPU, Chronometer Chrono) {
        if (this.action == null) {
            throw new Error("Action must be defined before the call to this method.");
        }
        if (!Folder.isDirectory()) {
            throw new IllegalArgumentException("This file is not a directory.");
        }
        File[] listfiles = Folder.listFiles();
        int marker = 0;
        if (Chrono != null) {
            System.out.print("Characteristics extraction with pre-computation: ");
            marker = Chrono.NewMarker();
        }
        try {
            if (!Result.exists()) {
                Result.createNewFile();
            }
            this.Out = new DataOutputStream(new FileOutputStream(Result));
            this.WriteColumnNames();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error(e.getMessage());
        }
        this.action.PreCompute(source, nbCPU);
        this.nbErrors = 0;
        for (int l = 0; l < listfiles.length; ++l) {
            if (!listfiles[l].isFile() || !listfiles[l].getName().contains(".png")) continue;
            this.Characterizer(listfiles[l], convertion, nbCPU);
        }
        if (Chrono != null) {
            System.out.println(Chrono.getTimeSinceMarker(marker));
            Chrono.FreeMarker(marker);
        }
        listfiles = null;
        System.err.println("Program finished with " + this.nbErrors + " error(s)/exception(s).");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void Characterizer(File name, int convertion, int nbCPU) {
        BufferedImage image = null;
        BufferedImage vignette = null;
        try {
            image = ImageIO.Read(name.getAbsolutePath());
            if (!this.FindCoodinates(name.getName())) {
                throw new Error("Image's name does not contain coodinates: " + name.getName());
            }
            block4 : switch (image.getType()) {
                case 10: 
                case 11: 
                case 12: {
                    vignette = image;
                    break;
                }
                case 1: 
                case 4: 
                case 5: {
                    switch (convertion) {
                        case 0: 
                        case 1: 
                        case 2: {
                            vignette = ImageConverter.Channel((BufferedImage)image, (int)convertion);
                            break block4;
                        }
                        case 3: {
                            vignette = ImageConverter.RGB_To_GrayLevel((BufferedImage)image, (int)0);
                            break block4;
                        }
                        case 4: {
                            vignette = ImageConverter.RGB_To_GrayLevel((BufferedImage)image, (int)1);
                            break block4;
                        }
                    }
                    throw new IllegalArgumentException("Conversion mode unknown.");
                }
                default: {
                    throw new IllegalArgumentException("Image type not yet supported.");
                }
            }
            this.action.FastCompute(this.abscisse, this.ordonnee, this.abscisse + vignette.getWidth() - 1, this.ordonnee + vignette.getHeight() - 1);
        }
        catch (Error E) {
            System.err.println("Error " + this.nbErrors++ + "(computation) => ");
            E.printStackTrace();
            Arrays.fill(this.action.Features(), 0.0);
        }
        catch (Exception E) {
            System.err.println("Exception " + this.nbErrors++ + "(computation) => ");
            E.printStackTrace();
            Arrays.fill(this.action.Features(), 0.0);
        }
        finally {
            image = null;
            vignette = null;
        }
        try {
            for (int i2 = 0; i2 < this.action.Features().length; ++i2) {
                this.Out.write(String.valueOf(this.action.Feature(i2) + " ").getBytes("ASCII"));
            }
            this.Out.write(String.valueOf(name.getName() + "\n").getBytes("ASCII"));
        }
        catch (Error E) {
            System.err.println("Error " + this.nbErrors++ + "(writting) => ");
            E.printStackTrace();
        }
        catch (Exception E) {
            System.err.println("Exception " + this.nbErrors++ + "(writting) => ");
            E.printStackTrace();
        }
    }

    private boolean FindCoodinates(String name) {
        int x = name.indexOf(120);
        if ((x = name.indexOf(120, x + 1)) == -1) {
            return false;
        }
        int i2 = x + 1;
        while (name.charAt(i2) != '.') {
            ++i2;
        }
        this.ordonnee = Integer.valueOf(name.substring(x + 1, i2));
        i2 = x - 1;
        while (name.charAt(i2) != '_') {
            --i2;
        }
        this.abscisse = Integer.valueOf(name.substring(i2 + 1, x));
        return true;
    }

    public void setGloaglzm(int nbGrayLevel, int nbLength, int nbOrientation, boolean FixedSize, boolean UseAverageOrientation, boolean UseGapToAO, ColorReducer reducer, Leveling leveling, int ForbidenValue, boolean EightConnex, Distance Montanary, int nbCPU) {
        this.action = new GlolzmFeatures();
        this.action.Parameters(nbGrayLevel, nbLength, nbOrientation, FixedSize, UseAverageOrientation, UseGapToAO, reducer, leveling, ForbidenValue, EightConnex, Montanary, nbCPU);
    }

    public void setGlrlm(int nbGrayLevel, ColorReducer reducer, Leveling leveling, int ForbidenValue, int nbCPU) {
        this.action = new RLMfeatures();
        this.action.Parameters(nbGrayLevel, reducer, leveling, ForbidenValue, nbCPU);
    }

    public void setGlszm(int nbGrayLevel, int nbSizes, boolean FixedSize, ColorReducer reducer, Leveling leveling, int ForbidenValue, boolean EightConnex, int nbCPU) {
        this.action = new SZMfeatures();
        this.action.Parameters(nbGrayLevel, nbSizes, FixedSize, reducer, leveling, ForbidenValue, EightConnex, nbCPU);
    }

    public void setGranulometryMSE(int MinRadius, int MaxRadius, int Step, Leveling leveling, int ForbidenValue, int nbCPU, List<Integer> listse) {
        this.action = new GranulometryMultiSE();
        this.action.Parameters(MinRadius, MaxRadius, Step, leveling, ForbidenValue, nbCPU, listse);
    }

    public void setAntiGranulometryMSE(int MinRadius, int MaxRadius, int Step, Leveling leveling, int ForbidenValue, int nbCPU, List<Integer> listse) {
        this.action = new AntiGranulometryMultiSE();
        this.action.Parameters(MinRadius, MaxRadius, Step, leveling, ForbidenValue, nbCPU, listse);
    }

    public void setPatternSpectrumMultiSE(int MinRadius, int MaxRadius, int Step, Leveling leveling, int ForbidenValue, int nbCPU, List<Integer> listse) {
        this.action = new PatternSpectrumMultiSE();
        this.action.Parameters(MinRadius, MaxRadius, Step, leveling, ForbidenValue, nbCPU, listse);
    }

    private void WriteColumnNames() {
        try {
            for (int i2 = 0; i2 < this.action.FeaturesNames().length; ++i2) {
                this.Out.write(String.valueOf(this.action.FeaturesNames()[i2] + " ").getBytes("ASCII"));
            }
            this.Out.write(String.valueOf("Image\n").getBytes("ASCII"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Error e) {
            e.printStackTrace();
        }
    }
}

