/*
 * Decompiled with CFR 0.152.
 */
package arrayTiTi;

import Jama.Matrix;
import arrayTiTi.ArrayConverter;
import arrayTiTi.ArrayOperations;
import java.util.Arrays;
import mathematics.Interpolations;
import mathematics.matriciel.MatrixArithmetic;
import mathematics.matriciel.MatrixNew;

public class ArrayTransformations {
    public static byte[] Rotation(byte[] array, int width, int height, double theta, Interpolation inter) {
        int max = Math.max(width, height);
        byte[] result = new byte[max * max];
        ArrayTransformations.Rotations(array, width, height, theta, inter, result, max, max);
        return result;
    }

    public static void Rotations(byte[] array, int width, int height, double theta, Interpolation inter, byte[] result, int reswidth, int resheight) {
        double amx = width >> 1;
        double amy = height >> 1;
        int resmx = reswidth >> 1;
        int resmy = resheight >> 1;
        Matrix R = MatrixNew.Rotation(2, -theta, "X");
        Matrix P = new Matrix(2, 1);
        Matrix Prot = new Matrix(2, 1);
        double[][] p = P.getArray();
        double[][] rot = Prot.getArray();
        Arrays.fill(result, (byte)0);
        switch (inter) {
            case None: 
            case Linear: 
            case LinearPlus: {
                break;
            }
            case Cubic: {
                Interpolations.SetCubic();
                break;
            }
            case CubicSmooth: {
                Interpolations.SetCubicSmooth();
                break;
            }
            case CubicCR: {
                Interpolations.SetCubicCR();
                break;
            }
            case Lanczos2: {
                Interpolations.SetLanczosOrder(2);
                break;
            }
            case Lanczos3: {
                Interpolations.SetLanczosOrder(3);
                break;
            }
            case Lanczos4: {
                Interpolations.SetLanczosOrder(4);
                break;
            }
            case Spline: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown interpolation. Must not occur.");
            }
        }
        int pos = 0;
        for (int y = 0; y < resheight; ++y) {
            int x = 0;
            while (x < reswidth) {
                p[0][0] = x - resmx;
                p[1][0] = y - resmy;
                MatrixArithmetic.Multiply(R, P, Prot);
                double px = amx + rot[0][0];
                double py = amy + rot[1][0];
                switch (inter) {
                    case None: {
                        px = rot[0][0] < 0.0 ? (px -= 0.5) : (px += 0.5);
                        if (px < 0.0 || (double)width <= px) break;
                        py = rot[1][0] < 0.0 ? (py -= 0.5) : (py += 0.5);
                        if (py < 0.0 || (double)height <= py) break;
                        result[pos] = array[(int)py * width + (int)px];
                        break;
                    }
                    case Linear: {
                        result[pos] = Interpolations.Bilinear(px, py, array, width, height);
                        break;
                    }
                    case LinearPlus: {
                        result[pos] = Interpolations.BilinearPlus(px, py, array, width, height);
                        break;
                    }
                    case Cubic: 
                    case CubicSmooth: 
                    case CubicCR: {
                        result[pos] = Interpolations.Bicubic(px, py, array, width, height);
                        break;
                    }
                    case Lanczos2: 
                    case Lanczos3: 
                    case Lanczos4: {
                        result[pos] = Interpolations.Lanczos(px, py, array, width, height);
                        break;
                    }
                    case Spline: {
                        result[pos] = Interpolations.Spline(px, py, array, width, height);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown interpolation. Must not occur!!!");
                    }
                }
                ++x;
                ++pos;
            }
        }
        rot = null;
        p = null;
        Prot = null;
        P = null;
        R = null;
    }

    public static short[] Rotation(short[] array, int width, int height, double theta, Interpolation inter) {
        int max = Math.max(width, height);
        short[] result = new short[max * max];
        ArrayTransformations.Rotations(array, width, height, theta, inter, result, max, max);
        return result;
    }

    public static void Rotations(short[] array, int width, int height, double theta, Interpolation inter, short[] result, int reswidth, int resheight) {
        double amx = width >> 1;
        double amy = height >> 1;
        int resmx = reswidth >> 1;
        int resmy = resheight >> 1;
        Matrix R = MatrixNew.Rotation(2, -theta, "X");
        Matrix P = new Matrix(2, 1);
        Matrix Prot = new Matrix(2, 1);
        double[][] p = P.getArray();
        double[][] rot = Prot.getArray();
        Arrays.fill(result, (short)0);
        switch (inter) {
            case None: 
            case Linear: 
            case LinearPlus: {
                break;
            }
            case Cubic: {
                Interpolations.SetCubic();
                break;
            }
            case CubicSmooth: {
                Interpolations.SetCubicSmooth();
                break;
            }
            case CubicCR: {
                Interpolations.SetCubicCR();
                break;
            }
            case Lanczos2: {
                Interpolations.SetLanczosOrder(2);
                break;
            }
            case Lanczos3: {
                Interpolations.SetLanczosOrder(3);
                break;
            }
            case Lanczos4: {
                Interpolations.SetLanczosOrder(4);
                break;
            }
            case Spline: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown interpolation. Must not occur.");
            }
        }
        int pos = 0;
        for (int y = 0; y < resheight; ++y) {
            int x = 0;
            while (x < reswidth) {
                p[0][0] = x - resmx;
                p[1][0] = y - resmy;
                MatrixArithmetic.Multiply(R, P, Prot);
                double px = amx + rot[0][0];
                double py = amy + rot[1][0];
                switch (inter) {
                    case None: {
                        px = rot[0][0] < 0.0 ? (px -= 0.5) : (px += 0.5);
                        if (px < 0.0 || (double)width <= px) break;
                        py = rot[1][0] < 0.0 ? (py -= 0.5) : (py += 0.5);
                        if (py < 0.0 || (double)height <= py) break;
                        result[pos] = array[(int)py * width + (int)px];
                        break;
                    }
                    case Linear: {
                        result[pos] = Interpolations.Bilinear(px, py, array, width, height);
                        break;
                    }
                    case LinearPlus: {
                        result[pos] = Interpolations.BilinearPlus(px, py, array, width, height);
                        break;
                    }
                    case Cubic: 
                    case CubicSmooth: 
                    case CubicCR: {
                        result[pos] = Interpolations.Bicubic(px, py, array, width, height);
                        break;
                    }
                    case Lanczos2: 
                    case Lanczos3: 
                    case Lanczos4: {
                        result[pos] = Interpolations.Lanczos(px, py, array, width, height);
                        break;
                    }
                    case Spline: {
                        result[pos] = Interpolations.Spline(px, py, array, width, height);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown interpolation. Must not occur!!!");
                    }
                }
                ++x;
                ++pos;
            }
        }
        rot = null;
        p = null;
        Prot = null;
        P = null;
        R = null;
    }

    public static int[] Rotation(int[] array, int width, int height, double theta, Interpolation inter) {
        int max = Math.max(width, height);
        int[] result = new int[max * max];
        ArrayTransformations.Rotations(array, width, height, theta, inter, result, max, max);
        return result;
    }

    public static void Rotations(int[] array, int width, int height, double theta, Interpolation inter, int[] result, int reswidth, int resheight) {
        double amx = width >> 1;
        double amy = height >> 1;
        int resmx = reswidth >> 1;
        int resmy = resheight >> 1;
        Matrix R = MatrixNew.Rotation(2, -theta, "X");
        Matrix P = new Matrix(2, 1);
        Matrix Prot = new Matrix(2, 1);
        double[][] p = P.getArray();
        double[][] rot = Prot.getArray();
        Arrays.fill(result, 0);
        switch (inter) {
            case None: 
            case Linear: 
            case LinearPlus: {
                break;
            }
            case Cubic: {
                Interpolations.SetCubic();
                break;
            }
            case CubicSmooth: {
                Interpolations.SetCubicSmooth();
                break;
            }
            case CubicCR: {
                Interpolations.SetCubicCR();
                break;
            }
            case Lanczos2: {
                Interpolations.SetLanczosOrder(2);
                break;
            }
            case Lanczos3: {
                Interpolations.SetLanczosOrder(3);
                break;
            }
            case Lanczos4: {
                Interpolations.SetLanczosOrder(4);
                break;
            }
            case Spline: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown interpolation. Must not occur.");
            }
        }
        int pos = 0;
        for (int y = 0; y < resheight; ++y) {
            int x = 0;
            while (x < reswidth) {
                p[0][0] = x - resmx;
                p[1][0] = y - resmy;
                MatrixArithmetic.Multiply(R, P, Prot);
                double px = amx + rot[0][0];
                double py = amy + rot[1][0];
                switch (inter) {
                    case None: {
                        px = rot[0][0] < 0.0 ? (px -= 0.5) : (px += 0.5);
                        if (px < 0.0 || (double)width <= px) break;
                        py = rot[1][0] < 0.0 ? (py -= 0.5) : (py += 0.5);
                        if (py < 0.0 || (double)height <= py) break;
                        result[pos] = array[(int)py * width + (int)px];
                        break;
                    }
                    case Linear: {
                        result[pos] = Interpolations.Bilinear(px, py, array, width, height);
                        break;
                    }
                    case LinearPlus: {
                        result[pos] = Interpolations.BilinearPlus(px, py, array, width, height);
                        break;
                    }
                    case Cubic: 
                    case CubicSmooth: 
                    case CubicCR: {
                        result[pos] = Interpolations.Bicubic(px, py, array, width, height);
                        break;
                    }
                    case Lanczos2: 
                    case Lanczos3: 
                    case Lanczos4: {
                        result[pos] = Interpolations.Lanczos(px, py, array, width, height);
                        break;
                    }
                    case Spline: {
                        result[pos] = Interpolations.Spline(px, py, array, width, height);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown interpolation. Must not occur!!!");
                    }
                }
                ++x;
                ++pos;
            }
        }
        rot = null;
        p = null;
        Prot = null;
        P = null;
        R = null;
    }

    public static float[] Rotation(float[] array, int width, int height, double theta, Interpolation inter) {
        int max = Math.max(width, height);
        float[] result = new float[max * max];
        ArrayTransformations.Rotations(array, width, height, theta, inter, result, max, max);
        return result;
    }

    public static void Rotations(float[] array, int width, int height, double theta, Interpolation inter, float[] result, int reswidth, int resheight) {
        double amx = width >> 1;
        double amy = height >> 1;
        int resmx = reswidth >> 1;
        int resmy = resheight >> 1;
        Matrix R = MatrixNew.Rotation(2, -theta, "X");
        Matrix P = new Matrix(2, 1);
        Matrix Prot = new Matrix(2, 1);
        double[][] p = P.getArray();
        double[][] rot = Prot.getArray();
        Arrays.fill(result, 0.0f);
        switch (inter) {
            case None: 
            case Linear: 
            case LinearPlus: {
                break;
            }
            case Cubic: {
                Interpolations.SetCubic();
                break;
            }
            case CubicSmooth: {
                Interpolations.SetCubicSmooth();
                break;
            }
            case CubicCR: {
                Interpolations.SetCubicCR();
                break;
            }
            case Lanczos2: {
                Interpolations.SetLanczosOrder(2);
                break;
            }
            case Lanczos3: {
                Interpolations.SetLanczosOrder(3);
                break;
            }
            case Lanczos4: {
                Interpolations.SetLanczosOrder(4);
                break;
            }
            case Spline: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown interpolation. Must not occur.");
            }
        }
        int pos = 0;
        for (int y = 0; y < resheight; ++y) {
            int x = 0;
            while (x < reswidth) {
                p[0][0] = x - resmx;
                p[1][0] = y - resmy;
                MatrixArithmetic.Multiply(R, P, Prot);
                double px = amx + rot[0][0];
                double py = amy + rot[1][0];
                switch (inter) {
                    case None: {
                        px = rot[0][0] < 0.0 ? (px -= 0.5) : (px += 0.5);
                        if (px < 0.0 || (double)width <= px) break;
                        py = rot[1][0] < 0.0 ? (py -= 0.5) : (py += 0.5);
                        if (py < 0.0 || (double)height <= py) break;
                        result[pos] = array[(int)py * width + (int)px];
                        break;
                    }
                    case Linear: {
                        result[pos] = Interpolations.Bilinear(px, py, array, width, height);
                        break;
                    }
                    case LinearPlus: {
                        result[pos] = Interpolations.BilinearPlus(px, py, array, width, height);
                        break;
                    }
                    case Cubic: 
                    case CubicSmooth: 
                    case CubicCR: {
                        result[pos] = Interpolations.Bicubic(px, py, array, width, height);
                        break;
                    }
                    case Lanczos2: 
                    case Lanczos3: 
                    case Lanczos4: {
                        result[pos] = Interpolations.Lanczos(px, py, array, width, height);
                        break;
                    }
                    case Spline: {
                        result[pos] = Interpolations.Spline(px, py, array, width, height);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown interpolation. Must not occur!!!");
                    }
                }
                ++x;
                ++pos;
            }
        }
        rot = null;
        p = null;
        Prot = null;
        P = null;
        R = null;
    }

    public static double[] Rotation(double[] array, int width, int height, double theta, Interpolation inter) {
        int max = Math.max(width, height);
        double[] result = new double[max * max];
        ArrayTransformations.Rotations(array, width, height, theta, inter, result, max, max);
        return result;
    }

    public static void Rotations(double[] array, int width, int height, double theta, Interpolation inter, double[] result, int reswidth, int resheight) {
        double amx = width >> 1;
        double amy = height >> 1;
        int resmx = reswidth >> 1;
        int resmy = resheight >> 1;
        Matrix R = MatrixNew.Rotation(2, -theta, "X");
        Matrix P = new Matrix(2, 1);
        Matrix Prot = new Matrix(2, 1);
        double[][] p = P.getArray();
        double[][] rot = Prot.getArray();
        Arrays.fill(result, 0.0);
        switch (inter) {
            case None: 
            case Linear: 
            case LinearPlus: {
                break;
            }
            case Cubic: {
                Interpolations.SetCubic();
                break;
            }
            case CubicSmooth: {
                Interpolations.SetCubicSmooth();
                break;
            }
            case CubicCR: {
                Interpolations.SetCubicCR();
                break;
            }
            case Lanczos2: {
                Interpolations.SetLanczosOrder(2);
                break;
            }
            case Lanczos3: {
                Interpolations.SetLanczosOrder(3);
                break;
            }
            case Lanczos4: {
                Interpolations.SetLanczosOrder(4);
                break;
            }
            case Spline: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown interpolation. Must not occur.");
            }
        }
        int pos = 0;
        for (int y = 0; y < resheight; ++y) {
            int x = 0;
            while (x < reswidth) {
                p[0][0] = x - resmx;
                p[1][0] = y - resmy;
                MatrixArithmetic.Multiply(R, P, Prot);
                double px = amx + rot[0][0];
                double py = amy + rot[1][0];
                switch (inter) {
                    case None: {
                        px = rot[0][0] < 0.0 ? (px -= 0.5) : (px += 0.5);
                        if (px < 0.0 || (double)width <= px) break;
                        py = rot[1][0] < 0.0 ? (py -= 0.5) : (py += 0.5);
                        if (py < 0.0 || (double)height <= py) break;
                        result[pos] = array[(int)py * width + (int)px];
                        break;
                    }
                    case Linear: {
                        result[pos] = Interpolations.Bilinear(px, py, array, width, height);
                        break;
                    }
                    case LinearPlus: {
                        result[pos] = Interpolations.BilinearPlus(px, py, array, width, height);
                        break;
                    }
                    case Cubic: 
                    case CubicSmooth: 
                    case CubicCR: {
                        result[pos] = Interpolations.Bicubic(px, py, array, width, height);
                        break;
                    }
                    case Lanczos2: 
                    case Lanczos3: 
                    case Lanczos4: {
                        result[pos] = Interpolations.Lanczos(px, py, array, width, height);
                        break;
                    }
                    case Spline: {
                        result[pos] = Interpolations.Spline(px, py, array, width, height);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown interpolation. Must not occur!!!");
                    }
                }
                ++x;
                ++pos;
            }
        }
        rot = null;
        p = null;
        Prot = null;
        P = null;
        R = null;
    }

    public static double[][][] Rotations(double[][][] array, double DeltaX, double DeltaY, double DeltaZ) {
        int max = Math.max(array.length, Math.max(array[0].length, array[0][0].length));
        double[][][] result = new double[max][max][max];
        ArrayTransformations.Rotations(array, DeltaX, DeltaY, DeltaZ, result);
        return result;
    }

    public static void Rotations(double[][][] array, double DeltaX, double DeltaY, double DeltaZ, double[][][] result) {
        int asizex = array[0][0].length;
        int asizey = array[0].length;
        int asizez = array.length;
        int ressizex = result[0][0].length;
        int ressizey = result[0].length;
        int ressizez = result.length;
        int amx = array[0][0].length >> 1;
        int amy = array[0].length >> 1;
        int amz = array.length >> 1;
        int resmx = ressizex >> 1;
        int resmy = ressizey >> 1;
        int resmz = ressizez >> 1;
        Matrix Rx = MatrixNew.Rotation(3, -DeltaX, "X");
        Matrix Ry = MatrixNew.Rotation(3, -DeltaY, "Y");
        Matrix Rz = MatrixNew.Rotation(3, -DeltaZ, "Z");
        Matrix Ryx = Ry.times(Rx);
        Matrix Rzyx = Rz.times(Ryx);
        Matrix P = new Matrix(3, 1);
        Matrix Prot = new Matrix(3, 1);
        double[][] p = P.getArray();
        double[][] rot = Prot.getArray();
        ArrayOperations.Fill((double[][][])result, (double)0.0);
        result[resmz][resmy][resmx] = array[amz][amy][amx];
        for (int z = 0; z < ressizez; ++z) {
            for (int y = 0; y < ressizey; ++y) {
                for (int x = 0; x < ressizex; ++x) {
                    int pz;
                    int py;
                    p[0][0] = x - resmx;
                    p[1][0] = y - resmy;
                    p[2][0] = z - resmz;
                    MatrixArithmetic.Multiply(Rzyx, P, Prot);
                    double v = rot[0][0];
                    int px = amx + (int)(v < 0.0 ? v - 0.5 : v + 0.5);
                    if (px < 0 || asizex <= px || (py = amy + (int)((v = rot[1][0]) < 0.0 ? v - 0.5 : v + 0.5)) < 0 || asizey <= py || (pz = amz + (int)((v = rot[2][0]) < 0.0 ? v - 0.5 : v + 0.5)) < 0 || asizez <= pz) continue;
                    result[z][y][x] = array[pz][py][px];
                }
            }
        }
        rot = null;
        p = null;
        Prot = null;
        P = null;
        Rzyx = null;
        Ryx = null;
        Rz = null;
        Ry = null;
        Rx = null;
    }

    public static double[][][] Rotations(double[][][] array, double DeltaX, double DeltaY, double DeltaZ, Interpolation inter) {
        int max = Math.max(array.length, Math.max(array[0].length, array[0][0].length));
        double[][][] result = new double[max][max][max];
        ArrayTransformations.Rotations(array, DeltaX, DeltaY, DeltaZ, result);
        return result;
    }

    public static void Rotations(double[][][] array, double DeltaX, double DeltaY, double DeltaZ, Interpolation inter, double[][][] result) {
        int asizex = array[0][0].length;
        int asizey = array[0].length;
        int asizez = array.length;
        int ressizex = result[0][0].length;
        int ressizey = result[0].length;
        int ressizez = result.length;
        int layer = ressizex * ressizey;
        int amx = array[0][0].length >> 1;
        int amy = array[0].length >> 1;
        int amz = array.length >> 1;
        int resmx = ressizex >> 1;
        int resmy = ressizey >> 1;
        int resmz = ressizez >> 1;
        Matrix Rx = MatrixNew.Rotation(3, -DeltaX, "X");
        Matrix Ry = MatrixNew.Rotation(3, -DeltaY, "Y");
        Matrix Rz = MatrixNew.Rotation(3, -DeltaZ, "Z");
        Matrix Ryx = Ry.times(Rx);
        Matrix Rzyx = Rz.times(Ryx);
        Matrix P = new Matrix(3, 1);
        Matrix Prot = new Matrix(3, 1);
        double[][] p = P.getArray();
        double[][] rot = Prot.getArray();
        double[] tab = ArrayConverter.to1D((double[][][])array);
        switch (inter) {
            case None: 
            case Linear: 
            case LinearPlus: {
                break;
            }
            case Cubic: {
                Interpolations.SetCubic();
                break;
            }
            case CubicSmooth: {
                Interpolations.SetCubicSmooth();
                break;
            }
            case CubicCR: {
                Interpolations.SetCubicCR();
                break;
            }
            case Lanczos2: {
                Interpolations.SetLanczosOrder(2);
                break;
            }
            case Lanczos3: {
                Interpolations.SetLanczosOrder(3);
                break;
            }
            case Lanczos4: {
                Interpolations.SetLanczosOrder(4);
                break;
            }
            case Spline: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown interpolation. Must not occur.");
            }
        }
        ArrayOperations.Fill((double[][][])result, (double)0.0);
        result[resmz][resmy][resmx] = array[amz][amy][amx];
        for (int z = 0; z < ressizez; ++z) {
            for (int y = 0; y < ressizey; ++y) {
                block20: for (int x = 0; x < ressizex; ++x) {
                    double pz;
                    double py;
                    p[0][0] = x - resmx;
                    p[1][0] = y - resmy;
                    p[2][0] = z - resmz;
                    MatrixArithmetic.Multiply(Rzyx, P, Prot);
                    double px = (double)amx + rot[0][0];
                    if (px < 0.0 || (double)asizex <= px || (py = (double)amy + rot[1][0]) < 0.0 || (double)asizey <= py || (pz = (double)amz + rot[2][0]) < 0.0 || (double)asizez <= pz) continue;
                    switch (inter) {
                        case None: {
                            px = rot[0][0] < 0.0 ? (px -= 0.5) : (px += 0.5);
                            if (px < 0.0 || (double)asizex <= px) continue block20;
                            py = rot[1][0] < 0.0 ? (py -= 0.5) : (py += 0.5);
                            if (py < 0.0 || (double)asizey <= py) continue block20;
                            pz = rot[2][0] < 0.0 ? (pz -= 0.5) : (pz += 0.5);
                            if (pz < 0.0 || (double)asizez <= pz) continue block20;
                            result[z][y][x] = array[(int)pz][(int)py][(int)px];
                            continue block20;
                        }
                        case Linear: {
                            result[z][y][x] = Interpolations.Trilinear(px, py, pz, tab, ressizex, ressizey, ressizez, layer);
                            continue block20;
                        }
                        case LinearPlus: {
                            throw new IllegalArgumentException("Interpolation not supported in 3D");
                        }
                        case Cubic: 
                        case CubicSmooth: 
                        case CubicCR: {
                            result[z][y][x] = Interpolations.Tricubic(px, py, pz, tab, ressizex, ressizey, ressizez, layer);
                            continue block20;
                        }
                        case Lanczos2: 
                        case Lanczos3: 
                        case Lanczos4: {
                            result[z][y][x] = Interpolations.Lanczos3D(px, py, pz, tab, ressizex, ressizey, ressizez, layer);
                            continue block20;
                        }
                        case Spline: {
                            result[z][y][x] = Interpolations.Spline3D(px, py, pz, tab, ressizex, ressizey, ressizez, layer);
                            continue block20;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown interpolation. Must not occur!!!");
                        }
                    }
                }
            }
        }
        tab = null;
        rot = null;
        p = null;
        Prot = null;
        P = null;
        Rzyx = null;
        Ryx = null;
        Rz = null;
        Ry = null;
        Rx = null;
    }

    public static byte[] Rotate90(byte[] array, int width, int height) {
        byte[] result = new byte[array.length];
        ArrayTransformations.Rotate90(array, width, height, result);
        return result;
    }

    public static void Rotate90(byte[] array, int width, int height, byte[] result) {
        if (array.length != width * height) {
            throw new IllegalArgumentException("array.length != width*height");
        }
        if (array.length != result.length) {
            throw new IllegalArgumentException("array.length != result.length");
        }
        int y = 0;
        int pos = 0;
        int posr = (width - 1) * height;
        while (y < height) {
            int x = 0;
            int posres = posr;
            while (x < width) {
                result[posres] = array[pos];
                ++x;
                ++pos;
                posres -= height;
            }
            ++y;
            ++posr;
        }
    }

    public static short[] Rotate90(short[] array, int width, int height) {
        short[] result = new short[array.length];
        ArrayTransformations.Rotate90(array, width, height, result);
        return result;
    }

    public static void Rotate90(short[] array, int width, int height, short[] result) {
        if (array.length != width * height) {
            throw new IllegalArgumentException("array.length != width*height");
        }
        if (array.length != result.length) {
            throw new IllegalArgumentException("array.length != result.length");
        }
        int y = 0;
        int pos = 0;
        int posr = (width - 1) * height;
        while (y < height) {
            int x = 0;
            int posres = posr;
            while (x < width) {
                result[posres] = array[pos];
                ++x;
                ++pos;
                posres -= height;
            }
            ++y;
            ++posr;
        }
    }

    public static int[] Rotate90(int[] array, int width, int height) {
        int[] result = new int[array.length];
        ArrayTransformations.Rotate90(array, width, height, result);
        return result;
    }

    public static void Rotate90(int[] array, int width, int height, int[] result) {
        if (array.length != width * height) {
            throw new IllegalArgumentException("array.length != width*height");
        }
        if (array.length != result.length) {
            throw new IllegalArgumentException("array.length != result.length");
        }
        int y = 0;
        int pos = 0;
        int posr = (width - 1) * height;
        while (y < height) {
            int x = 0;
            int posres = posr;
            while (x < width) {
                result[posres] = array[pos];
                ++x;
                ++pos;
                posres -= height;
            }
            ++y;
            ++posr;
        }
    }

    public static float[] Rotate90(float[] array, int width, int height) {
        float[] result = new float[array.length];
        ArrayTransformations.Rotate90(array, width, height, result);
        return result;
    }

    public static void Rotate90(float[] array, int width, int height, float[] result) {
        if (array.length != width * height) {
            throw new IllegalArgumentException("array.length != width*height");
        }
        if (array.length != result.length) {
            throw new IllegalArgumentException("array.length != result.length");
        }
        int y = 0;
        int pos = 0;
        int posr = (width - 1) * height;
        while (y < height) {
            int x = 0;
            int posres = posr;
            while (x < width) {
                result[posres] = array[pos];
                ++x;
                ++pos;
                posres -= height;
            }
            ++y;
            ++posr;
        }
    }

    public static double[] Rotate90(double[] array, int width, int height) {
        double[] result = new double[array.length];
        ArrayTransformations.Rotate90(array, width, height, result);
        return result;
    }

    public static void Rotate90(double[] array, int width, int height, double[] result) {
        if (array.length != width * height) {
            throw new IllegalArgumentException("array.length != width*height");
        }
        if (array.length != result.length) {
            throw new IllegalArgumentException("array.length != result.length");
        }
        int y = 0;
        int pos = 0;
        int posr = (width - 1) * height;
        while (y < height) {
            int x = 0;
            int posres = posr;
            while (x < width) {
                result[posres] = array[pos];
                ++x;
                ++pos;
                posres -= height;
            }
            ++y;
            ++posr;
        }
    }

    public static byte[] Rotate180(byte[] array, int width, int height) {
        byte[] result = new byte[array.length];
        ArrayTransformations.Rotate180(array, width, height, result);
        return result;
    }

    public static void Rotate180(byte[] array, int width, int height, byte[] result) {
        if (array.length != width * height) {
            throw new IllegalArgumentException("array.length != width*height");
        }
        if (array.length != result.length) {
            throw new IllegalArgumentException("array.length != result.length");
        }
        int x = 0;
        int pos = array.length - 1;
        while (x < array.length) {
            result[pos] = array[x];
            ++x;
            --pos;
        }
    }

    public static short[] Rotate180(short[] array, int width, int height) {
        short[] result = new short[array.length];
        ArrayTransformations.Rotate180(array, width, height, result);
        return result;
    }

    public static void Rotate180(short[] array, int width, int height, short[] result) {
        if (array.length != width * height) {
            throw new IllegalArgumentException("array.length != width*height");
        }
        if (array.length != result.length) {
            throw new IllegalArgumentException("array.length != result.length");
        }
        int x = 0;
        int pos = array.length - 1;
        while (x < array.length) {
            result[pos] = array[x];
            ++x;
            --pos;
        }
    }

    public static int[] Rotate180(int[] array, int width, int height) {
        int[] result = new int[array.length];
        ArrayTransformations.Rotate180(array, width, height, result);
        return result;
    }

    public static void Rotate180(int[] array, int width, int height, int[] result) {
        if (array.length != width * height) {
            throw new IllegalArgumentException("array.length != width*height");
        }
        if (array.length != result.length) {
            throw new IllegalArgumentException("array.length != result.length");
        }
        int x = 0;
        int pos = array.length - 1;
        while (x < array.length) {
            result[pos] = array[x];
            ++x;
            --pos;
        }
    }

    public static float[] Rotate180(float[] array, int width, int height) {
        float[] result = new float[array.length];
        ArrayTransformations.Rotate180(array, width, height, result);
        return result;
    }

    public static void Rotate180(float[] array, int width, int height, float[] result) {
        if (array.length != width * height) {
            throw new IllegalArgumentException("array.length != width*height");
        }
        if (array.length != result.length) {
            throw new IllegalArgumentException("array.length != result.length");
        }
        int x = 0;
        int pos = array.length - 1;
        while (x < array.length) {
            result[pos] = array[x];
            ++x;
            --pos;
        }
    }

    public static double[] Rotate180(double[] array, int width, int height) {
        double[] result = new double[array.length];
        ArrayTransformations.Rotate180(array, width, height, result);
        return result;
    }

    public static void Rotate180(double[] array, int width, int height, double[] result) {
        if (array.length != width * height) {
            throw new IllegalArgumentException("array.length != width*height");
        }
        if (array.length != result.length) {
            throw new IllegalArgumentException("array.length != result.length");
        }
        int x = 0;
        int pos = array.length - 1;
        while (x < array.length) {
            result[pos] = array[x];
            ++x;
            --pos;
        }
    }

    public static byte[] Rotate270(byte[] array, int width, int height) {
        byte[] result = new byte[array.length];
        ArrayTransformations.Rotate270(array, width, height, result);
        return result;
    }

    public static void Rotate270(byte[] array, int width, int height, byte[] result) {
        if (array.length != width * height) {
            throw new IllegalArgumentException("array.length != width*height");
        }
        if (array.length != result.length) {
            throw new IllegalArgumentException("array.length != result.length");
        }
        int y = 0;
        int pos = 0;
        int posr = height - 1;
        while (y < height) {
            int x = 0;
            int posres = posr;
            while (x < width) {
                result[posres] = array[pos];
                ++x;
                ++pos;
                posres += height;
            }
            ++y;
            --posr;
        }
    }

    public static short[] Rotate270(short[] array, int width, int height) {
        short[] result = new short[array.length];
        ArrayTransformations.Rotate270(array, width, height, result);
        return result;
    }

    public static void Rotate270(short[] array, int width, int height, short[] result) {
        if (array.length != width * height) {
            throw new IllegalArgumentException("array.length != width*height");
        }
        if (array.length != result.length) {
            throw new IllegalArgumentException("array.length != result.length");
        }
        int y = 0;
        int pos = 0;
        int posr = height - 1;
        while (y < height) {
            int x = 0;
            int posres = posr;
            while (x < width) {
                result[posres] = array[pos];
                ++x;
                ++pos;
                posres += height;
            }
            ++y;
            --posr;
        }
    }

    public static int[] Rotate270(int[] array, int width, int height) {
        int[] result = new int[array.length];
        ArrayTransformations.Rotate270(array, width, height, result);
        return result;
    }

    public static void Rotate270(int[] array, int width, int height, int[] result) {
        if (array.length != width * height) {
            throw new IllegalArgumentException("array.length != width*height");
        }
        if (array.length != result.length) {
            throw new IllegalArgumentException("array.length != result.length");
        }
        int y = 0;
        int pos = 0;
        int posr = height - 1;
        while (y < height) {
            int x = 0;
            int posres = posr;
            while (x < width) {
                result[posres] = array[pos];
                ++x;
                ++pos;
                posres += height;
            }
            ++y;
            --posr;
        }
    }

    public static float[] Rotate270(float[] array, int width, int height) {
        float[] result = new float[array.length];
        ArrayTransformations.Rotate270(array, width, height, result);
        return result;
    }

    public static void Rotate270(float[] array, int width, int height, float[] result) {
        if (array.length != width * height) {
            throw new IllegalArgumentException("array.length != width*height");
        }
        if (array.length != result.length) {
            throw new IllegalArgumentException("array.length != result.length");
        }
        int y = 0;
        int pos = 0;
        int posr = height - 1;
        while (y < height) {
            int x = 0;
            int posres = posr;
            while (x < width) {
                result[posres] = array[pos];
                ++x;
                ++pos;
                posres += height;
            }
            ++y;
            --posr;
        }
    }

    public static double[] Rotate270(double[] array, int width, int height) {
        double[] result = new double[array.length];
        ArrayTransformations.Rotate270(array, width, height, result);
        return result;
    }

    public static void Rotate270(double[] array, int width, int height, double[] result) {
        if (array.length != width * height) {
            throw new IllegalArgumentException("array.length != width*height");
        }
        if (array.length != result.length) {
            throw new IllegalArgumentException("array.length != result.length");
        }
        int y = 0;
        int pos = 0;
        int posr = height - 1;
        while (y < height) {
            int x = 0;
            int posres = posr;
            while (x < width) {
                result[posres] = array[pos];
                ++x;
                ++pos;
                posres += height;
            }
            ++y;
            --posr;
        }
    }

    public static byte[] FlipX(byte[] array, int width, int height) {
        byte[] result = new byte[array.length];
        ArrayTransformations.FlipX(array, width, height, result);
        return result;
    }

    public static void FlipX(byte[] array, int width, int height, byte[] result) {
        int end;
        byte[] buffer = new byte[width];
        int start = 0;
        for (end = (height - 1) * width; start < end; start += width, end -= width) {
            System.arraycopy(array, start, buffer, 0, width);
            System.arraycopy(array, end, result, start, width);
            System.arraycopy(buffer, 0, result, end, width);
        }
        if (start == end) {
            System.arraycopy(array, start, result, start, width);
        }
        buffer = null;
    }

    public static short[] FlipX(short[] array, int width, int height) {
        short[] result = new short[array.length];
        ArrayTransformations.FlipX(array, width, height, result);
        return result;
    }

    public static void FlipX(short[] array, int width, int height, short[] result) {
        int end;
        short[] buffer = new short[width];
        int start = 0;
        for (end = (height - 1) * width; start < end; start += width, end -= width) {
            System.arraycopy(array, start, buffer, 0, width);
            System.arraycopy(array, end, result, start, width);
            System.arraycopy(buffer, 0, result, end, width);
        }
        if (start == end) {
            System.arraycopy(array, start, result, start, width);
        }
        buffer = null;
    }

    public static int[] FlipX(int[] array, int width, int height) {
        int[] result = new int[array.length];
        ArrayTransformations.FlipX(array, width, height, result);
        return result;
    }

    public static void FlipX(int[] array, int width, int height, int[] result) {
        int end;
        int[] buffer = new int[width];
        int start = 0;
        for (end = (height - 1) * width; start < end; start += width, end -= width) {
            System.arraycopy(array, start, buffer, 0, width);
            System.arraycopy(array, end, result, start, width);
            System.arraycopy(buffer, 0, result, end, width);
        }
        if (start == end) {
            System.arraycopy(array, start, result, start, width);
        }
        buffer = null;
    }

    public static float[] FlipX(float[] array, int width, int height) {
        float[] result = new float[array.length];
        ArrayTransformations.FlipX(array, width, height, result);
        return result;
    }

    public static void FlipX(float[] array, int width, int height, float[] result) {
        int end;
        float[] buffer = new float[width];
        int start = 0;
        for (end = (height - 1) * width; start < end; start += width, end -= width) {
            System.arraycopy(array, start, buffer, 0, width);
            System.arraycopy(array, end, result, start, width);
            System.arraycopy(buffer, 0, result, end, width);
        }
        if (start == end) {
            System.arraycopy(array, start, result, start, width);
        }
        buffer = null;
    }

    public static double[] FlipX(double[] array, int width, int height) {
        double[] result = new double[array.length];
        ArrayTransformations.FlipX(array, width, height, result);
        return result;
    }

    public static void FlipX(double[] array, int width, int height, double[] result) {
        int end;
        double[] buffer = new double[width];
        int start = 0;
        for (end = (height - 1) * width; start < end; start += width, end -= width) {
            System.arraycopy(array, start, buffer, 0, width);
            System.arraycopy(array, end, result, start, width);
            System.arraycopy(buffer, 0, result, end, width);
        }
        if (start == end) {
            System.arraycopy(array, start, result, start, width);
        }
        buffer = null;
    }

    public static byte[] FlipY(byte[] array, int width, int height) {
        byte[] result = new byte[array.length];
        ArrayTransformations.FlipY(array, width, height, result);
        return result;
    }

    public static void FlipY(byte[] array, int width, int height, byte[] result) {
        int pos = 0;
        int y = 0;
        while (y < height) {
            int end;
            int start = pos;
            for (end = pos + width - 1; start < end; ++start, --end) {
                byte b = array[start];
                result[start] = array[end];
                result[end] = b;
            }
            if (start == end) {
                result[start] = array[start];
            }
            ++y;
            pos += width;
        }
    }

    public static short[] FlipY(short[] array, int width, int height) {
        short[] result = new short[array.length];
        ArrayTransformations.FlipY(array, width, height, result);
        return result;
    }

    public static void FlipY(short[] array, int width, int height, short[] result) {
        int pos = 0;
        int y = 0;
        while (y < height) {
            int end;
            int start = pos;
            for (end = pos + width - 1; start < end; ++start, --end) {
                short b = array[start];
                result[start] = array[end];
                result[end] = b;
            }
            if (start == end) {
                result[start] = array[start];
            }
            ++y;
            pos += width;
        }
    }

    public static int[] FlipY(int[] array, int width, int height) {
        int[] result = new int[array.length];
        ArrayTransformations.FlipY(array, width, height, result);
        return result;
    }

    public static void FlipY(int[] array, int width, int height, int[] result) {
        int pos = 0;
        int y = 0;
        while (y < height) {
            int end;
            int start = pos;
            for (end = pos + width - 1; start < end; ++start, --end) {
                int b = array[start];
                result[start] = array[end];
                result[end] = b;
            }
            if (start == end) {
                result[start] = array[start];
            }
            ++y;
            pos += width;
        }
    }

    public static float[] FlipY(float[] array, int width, int height) {
        float[] result = new float[array.length];
        ArrayTransformations.FlipY(array, width, height, result);
        return result;
    }

    public static void FlipY(float[] array, int width, int height, float[] result) {
        int pos = 0;
        int y = 0;
        while (y < height) {
            int end;
            int start = pos;
            for (end = pos + width - 1; start < end; ++start, --end) {
                float b = array[start];
                result[start] = array[end];
                result[end] = b;
            }
            if (start == end) {
                result[start] = array[start];
            }
            ++y;
            pos += width;
        }
    }

    public static double[] FlipY(double[] array, int width, int height) {
        double[] result = new double[array.length];
        ArrayTransformations.FlipY(array, width, height, result);
        return result;
    }

    public static void FlipY(double[] array, int width, int height, double[] result) {
        int pos = 0;
        int y = 0;
        while (y < height) {
            int end;
            int start = pos;
            for (end = pos + width - 1; start < end; ++start, --end) {
                double b = array[start];
                result[start] = array[end];
                result[end] = b;
            }
            if (start == end) {
                result[start] = array[start];
            }
            ++y;
            pos += width;
        }
    }

    public static int[][] Transpose(int[][] source) {
        int[][] result = new int[source[0].length][source.length];
        ArrayTransformations.Transpose(source, result);
        return result;
    }

    public static void Transpose(int[][] source, int[][] result) {
        if (source.length != result[0].length || source[0].length != result.length) {
            throw new IllegalArgumentException("Dimensions do not match.");
        }
        int width = source[0].length;
        int height = source.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                result[x][y] = source[y][x];
            }
        }
    }

    public static float[][] Transpose(float[][] source) {
        float[][] result = new float[source[0].length][source.length];
        ArrayTransformations.Transpose(source, result);
        return result;
    }

    public static void Transpose(float[][] source, float[][] result) {
        if (source.length != result[0].length || source[0].length != result.length) {
            throw new IllegalArgumentException("Dimensions do not match.");
        }
        int width = source[0].length;
        int height = source.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                result[x][y] = source[y][x];
            }
        }
    }

    public static double[][] Transpose(double[][] source) {
        double[][] result = new double[source[0].length][source.length];
        ArrayTransformations.Transpose(source, result);
        return result;
    }

    public static void Transpose(double[][] source, double[][] result) {
        if (source.length != result[0].length || source[0].length != result.length) {
            throw new IllegalArgumentException("Dimensions do not match.");
        }
        int width = source[0].length;
        int height = source.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                result[x][y] = source[y][x];
            }
        }
    }

    public static enum Interpolation {
        None,
        Linear,
        LinearPlus,
        Cubic,
        CubicSmooth,
        CubicCR,
        Lanczos2,
        Lanczos3,
        Lanczos4,
        Spline;

    }
}

