/*
 * Decompiled with CFR 0.152.
 */
package arrayTiTi;

import arrayTiTi.ArrayConverter;
import arrayTiTi.ArrayFeatures;
import arrayTiTi.ArrayNew;
import java.util.Arrays;
import mathematics.Maths;
import utils.sorts.QuickSort;

public final class ArrayStatistics {
    public static double Epsilon = 1.0E-7;
    public static double SpearmanError = 0.0;
    public static double SpearmanZScore = 0.0;
    public static double SpearmanStudent = 0.0;
    public static double RootMeanSquaredError = -1.0;
    public static double MeanAbsoluteError = -1.0;
    public static double R2 = -1.0;

    public static double Correlation(byte[] y1, byte[] y2) {
        return ArrayStatistics.Correlation(y1, y2, 0, y1.length);
    }

    public static double Correlation(byte[] y1, byte[] y2, int from, int to) {
        if (y1.length != y2.length) {
            throw new IllegalArgumentException("y1.length != y2.length");
        }
        ArrayFeatures AF = new ArrayFeatures();
        double av1 = AF.Average(y1, from, to);
        double av2 = AF.Average(y2, from, to);
        AF = null;
        double y12 = 0.0;
        double y22 = 0.0;
        double y11 = 0.0;
        for (int i2 = from; i2 < to; ++i2) {
            y11 += ((double)(y1[i2] & 0xFF) - av1) * ((double)(y1[i2] & 0xFF) - av1);
            y22 += ((double)(y2[i2] & 0xFF) - av2) * ((double)(y2[i2] & 0xFF) - av2);
            y12 += ((double)(y1[i2] & 0xFF) - av1) * ((double)(y2[i2] & 0xFF) - av2);
        }
        double v = Math.abs(y11 * y22);
        if (v < Epsilon) {
            return 1.0;
        }
        return y12 / Math.sqrt(v);
    }

    public static double Correlation(short[] y1, short[] y2) {
        return ArrayStatistics.Correlation(y1, y2, 0, y1.length);
    }

    public static double Correlation(short[] y1, short[] y2, int from, int to) {
        if (y1.length != y2.length) {
            throw new IllegalArgumentException("y1.length != y2.length");
        }
        ArrayFeatures AF = new ArrayFeatures();
        double av1 = AF.Average(y1, from, to);
        double av2 = AF.Average(y2, from, to);
        AF = null;
        double y12 = 0.0;
        double y22 = 0.0;
        double y11 = 0.0;
        for (int i2 = from; i2 < to; ++i2) {
            y11 += ((double)(y1[i2] & 0xFFFF) - av1) * ((double)(y1[i2] & 0xFFFF) - av1);
            y22 += ((double)(y2[i2] & 0xFFFF) - av2) * ((double)(y2[i2] & 0xFFFF) - av2);
            y12 += ((double)(y1[i2] & 0xFFFF) - av1) * ((double)(y2[i2] & 0xFFFF) - av2);
        }
        double v = Math.abs(y11 * y22);
        if (v < Epsilon) {
            return 1.0;
        }
        return y12 / Math.sqrt(v);
    }

    public static double Correlation(int[] y1, int[] y2) {
        return ArrayStatistics.Correlation(y1, y2, 0, y1.length);
    }

    public static double Correlation(int[] y1, int[] y2, int from, int to) {
        if (y1.length != y2.length) {
            throw new IllegalArgumentException("y1.length != y2.length");
        }
        ArrayFeatures AF = new ArrayFeatures();
        double av1 = AF.Average(y1, from, to);
        double av2 = AF.Average(y2, from, to);
        AF = null;
        double y12 = 0.0;
        double y22 = 0.0;
        double y11 = 0.0;
        for (int i2 = from; i2 < to; ++i2) {
            y11 += ((double)y1[i2] - av1) * ((double)y1[i2] - av1);
            y22 += ((double)y2[i2] - av2) * ((double)y2[i2] - av2);
            y12 += ((double)y1[i2] - av1) * ((double)y2[i2] - av2);
        }
        double v = Math.abs(y11 * y22);
        if (v < Epsilon) {
            return 1.0;
        }
        return y12 / Math.sqrt(v);
    }

    public static double Correlation(double[] y1, double[] y2) {
        return ArrayStatistics.Correlation(y1, y2, 0, y1.length);
    }

    public static double Correlation(double[] y1, double[] y2, int from, int to) {
        if (y1.length != y2.length) {
            throw new IllegalArgumentException("y1.length != y2.length");
        }
        ArrayFeatures AF = new ArrayFeatures();
        double av1 = AF.Average(y1, from, to);
        double av2 = AF.Average(y2, from, to);
        AF = null;
        double y12 = 0.0;
        double y22 = 0.0;
        double y11 = 0.0;
        for (int i2 = from; i2 < to; ++i2) {
            y11 += (y1[i2] - av1) * (y1[i2] - av1);
            y22 += (y2[i2] - av2) * (y2[i2] - av2);
            y12 += (y1[i2] - av1) * (y2[i2] - av2);
        }
        double v = Math.abs(y11 * y22);
        if (v < Epsilon) {
            return 1.0;
        }
        return y12 / Math.sqrt(v);
    }

    public static double Correlation(int[] y1, double[] y2) {
        return ArrayStatistics.Correlation(y1, y2, 0, y1.length);
    }

    public static double Correlation(int[] y1, double[] y2, int from, int to) {
        if (y1.length != y2.length) {
            throw new IllegalArgumentException("y1.length != y2.length");
        }
        ArrayFeatures AF = new ArrayFeatures();
        double av1 = AF.Average(y1, from, to);
        double av2 = AF.Average(y2, from, to);
        AF = null;
        double y12 = 0.0;
        double y22 = 0.0;
        double y11 = 0.0;
        for (int i2 = from; i2 < to; ++i2) {
            y11 += ((double)y1[i2] - av1) * ((double)y1[i2] - av1);
            y22 += (y2[i2] - av2) * (y2[i2] - av2);
            y12 += ((double)y1[i2] - av1) * (y2[i2] - av2);
        }
        double v = Math.abs(y11 * y22);
        if (v < Epsilon) {
            return 1.0;
        }
        return y12 / Math.sqrt(v);
    }

    public static double Spearman(byte[] y1, byte[] y2) {
        if (y1.length != y2.length) {
            throw new IllegalArgumentException("Distributions have different lengths.");
        }
        int N = y1.length;
        int[] t1 = ArrayConverter.UnsignedByteToInt((byte[])y1);
        int[] t2 = ArrayConverter.UnsignedByteToInt((byte[])y2);
        int[] s1 = ArrayNew.IncreasingInt((int)N, (int)0);
        int[] s2 = ArrayNew.IncreasingInt((int)N, (int)0);
        QuickSort.Sort(t1, s1, 0, N - 1);
        QuickSort.Sort(t2, s2, 0, N - 1);
        double[] r1 = new double[N];
        double[] r2 = new double[N];
        for (int i2 = 0; i2 < N; ++i2) {
            double d = i2;
            r2[s2[i2]] = d;
            r1[s1[i2]] = d;
        }
        ArrayStatistics.SpearmanCorrectedRanks(t1, s1, r1);
        ArrayStatistics.SpearmanCorrectedRanks(t2, s2, r2);
        double rho = 0.0;
        for (int i3 = 0; i3 < N; ++i3) {
            rho += (r1[i3] - r2[i3]) * (r1[i3] - r2[i3]);
        }
        rho = 1.0 - 6.0 * rho / (double)(N * (N * N - 1));
        SpearmanError = 0.6325 / Math.sqrt(N - 1);
        SpearmanZScore = Math.sqrt((double)(N - 3) / 1.06) * Math.atan(rho);
        SpearmanStudent = rho * Math.sqrt((double)(N - 2) / (1.0 - rho * rho));
        s2 = null;
        s1 = null;
        t2 = null;
        t1 = null;
        r2 = null;
        r1 = null;
        return rho;
    }

    public static double Spearman(short[] y1, short[] y2) {
        if (y1.length != y2.length) {
            throw new IllegalArgumentException("Distributions have different lengths.");
        }
        int N = y1.length;
        int[] t1 = ArrayConverter.UnsignedShortToInt((short[])y1);
        int[] t2 = ArrayConverter.UnsignedShortToInt((short[])y2);
        int[] s1 = ArrayNew.IncreasingInt((int)N, (int)0);
        int[] s2 = ArrayNew.IncreasingInt((int)N, (int)0);
        QuickSort.Sort(t1, s1, 0, N - 1);
        QuickSort.Sort(t2, s2, 0, N - 1);
        double[] r1 = new double[N];
        double[] r2 = new double[N];
        for (int i2 = 0; i2 < N; ++i2) {
            double d = i2;
            r2[s2[i2]] = d;
            r1[s1[i2]] = d;
        }
        ArrayStatistics.SpearmanCorrectedRanks(t1, s1, r1);
        ArrayStatistics.SpearmanCorrectedRanks(t2, s2, r2);
        double rho = 0.0;
        for (int i3 = 0; i3 < N; ++i3) {
            rho += (r1[i3] - r2[i3]) * (r1[i3] - r2[i3]);
        }
        rho = 1.0 - 6.0 * rho / (double)(N * (N * N - 1));
        SpearmanError = 0.6325 / Math.sqrt(N - 1);
        SpearmanZScore = Math.sqrt((double)(N - 3) / 1.06) * Math.atan(rho);
        SpearmanStudent = rho * Math.sqrt((double)(N - 2) / (1.0 - rho * rho));
        s2 = null;
        s1 = null;
        t2 = null;
        t1 = null;
        r2 = null;
        r1 = null;
        return rho;
    }

    public static double Spearman(int[] y1, int[] y2) {
        if (y1.length != y2.length) {
            throw new IllegalArgumentException("Distributions have different lengths.");
        }
        int N = y1.length;
        int[] t1 = (int[])y1.clone();
        int[] t2 = (int[])y2.clone();
        int[] s1 = ArrayNew.IncreasingInt((int)N, (int)0);
        int[] s2 = ArrayNew.IncreasingInt((int)N, (int)0);
        QuickSort.Sort(t1, s1, 0, N - 1);
        QuickSort.Sort(t2, s2, 0, N - 1);
        double[] r1 = new double[N];
        double[] r2 = new double[N];
        for (int i2 = 0; i2 < N; ++i2) {
            double d = i2;
            r2[s2[i2]] = d;
            r1[s1[i2]] = d;
        }
        ArrayStatistics.SpearmanCorrectedRanks(t1, s1, r1);
        ArrayStatistics.SpearmanCorrectedRanks(t2, s2, r2);
        double rho = 0.0;
        for (int i3 = 0; i3 < N; ++i3) {
            rho += (r1[i3] - r2[i3]) * (r1[i3] - r2[i3]);
        }
        rho = 1.0 - 6.0 * rho / (double)(N * (N * N - 1));
        SpearmanError = 0.6325 / Math.sqrt(N - 1);
        SpearmanZScore = Math.sqrt((double)(N - 3) / 1.06) * Math.atan(rho);
        SpearmanStudent = rho * Math.sqrt((double)(N - 2) / (1.0 - rho * rho));
        s2 = null;
        s1 = null;
        t2 = null;
        t1 = null;
        r2 = null;
        r1 = null;
        return rho;
    }

    public static double Spearman(double[] y1, double[] y2) {
        if (y1.length != y2.length) {
            throw new IllegalArgumentException("Distributions have different lengths.");
        }
        int N = y1.length;
        double[] t1 = (double[])y1.clone();
        double[] t2 = (double[])y2.clone();
        int[] s1 = ArrayNew.IncreasingInt((int)N, (int)0);
        int[] s2 = ArrayNew.IncreasingInt((int)N, (int)0);
        QuickSort.Sort(t1, s1, 0, N - 1);
        QuickSort.Sort(t2, s2, 0, N - 1);
        double[] r1 = new double[N];
        double[] r2 = new double[N];
        for (int i2 = 0; i2 < N; ++i2) {
            double d = i2;
            r2[s2[i2]] = d;
            r1[s1[i2]] = d;
        }
        ArrayStatistics.SpearmanCorrectedRanks(t1, s1, r1);
        ArrayStatistics.SpearmanCorrectedRanks(t2, s2, r2);
        double rho = 0.0;
        for (int i3 = 0; i3 < N; ++i3) {
            rho += (r1[i3] - r2[i3]) * (r1[i3] - r2[i3]);
        }
        rho = 1.0 - 6.0 * rho / (double)(N * (N * N - 1));
        SpearmanError = 0.6325 / Math.sqrt(N - 1);
        SpearmanZScore = Math.sqrt((double)(N - 3) / 1.06) * Math.atan(rho);
        SpearmanStudent = rho * Math.sqrt((double)(N - 2) / (1.0 - rho * rho));
        s2 = null;
        s1 = null;
        r2 = null;
        r1 = null;
        t2 = null;
        t1 = null;
        return rho;
    }

    public static double Spearman(float[] y1, float[] y2) {
        if (y1.length != y2.length) {
            throw new IllegalArgumentException("Distributions have different lengths.");
        }
        int N = y1.length;
        float[] t1 = (float[])y1.clone();
        float[] t2 = (float[])y2.clone();
        int[] s1 = ArrayNew.IncreasingInt((int)N, (int)0);
        int[] s2 = ArrayNew.IncreasingInt((int)N, (int)0);
        QuickSort.Sort(t1, s1, 0, N - 1);
        QuickSort.Sort(t2, s2, 0, N - 1);
        double[] r1 = new double[N];
        double[] r2 = new double[N];
        for (int i2 = 0; i2 < N; ++i2) {
            double d = i2;
            r2[s2[i2]] = d;
            r1[s1[i2]] = d;
        }
        ArrayStatistics.SpearmanCorrectedRanks(t1, s1, r1);
        ArrayStatistics.SpearmanCorrectedRanks(t2, s2, r2);
        double rho = 0.0;
        for (int i3 = 0; i3 < N; ++i3) {
            rho += (r1[i3] - r2[i3]) * (r1[i3] - r2[i3]);
        }
        rho = 1.0 - 6.0 * rho / (double)(N * (N * N - 1));
        SpearmanError = 0.6325 / Math.sqrt(N - 1);
        SpearmanZScore = Math.sqrt((double)(N - 3) / 1.06) * Math.atan(rho);
        SpearmanStudent = rho * Math.sqrt((double)(N - 2) / (1.0 - rho * rho));
        s2 = null;
        s1 = null;
        t2 = null;
        t1 = null;
        r2 = null;
        r1 = null;
        return rho;
    }

    private static void SpearmanCorrectedRanks(int[] T, int[] S, double[] R) {
        int N = T.length;
        for (int i2 = 1; i2 < N; ++i2) {
            if (T[i2] != T[i2 - 1]) continue;
            int nb = 2;
            while (i2 + 1 < N && T[i2] == T[i2 + 1]) {
                ++nb;
                ++i2;
            }
            double ave = (double)(i2 + (i2 - nb + 1)) / 2.0;
            int j = i2;
            while (nb > 0) {
                R[S[j]] = ave;
                --nb;
                --j;
            }
        }
    }

    private static void SpearmanCorrectedRanks(double[] T, int[] S, double[] R) {
        int N = T.length;
        for (int i2 = 1; i2 < N; ++i2) {
            if (T[i2] != T[i2 - 1]) continue;
            int nb = 2;
            while (i2 + 1 < N && T[i2] == T[i2 + 1]) {
                ++nb;
                ++i2;
            }
            double ave = (double)(i2 + (i2 - nb + 1)) / 2.0;
            int j = i2;
            while (nb > 0) {
                R[S[j]] = ave;
                --nb;
                --j;
            }
        }
    }

    private static void SpearmanCorrectedRanks(float[] T, int[] S, double[] R) {
        int N = T.length;
        for (int i2 = 1; i2 < N; ++i2) {
            if (T[i2] != T[i2 - 1]) continue;
            int nb = 2;
            while (i2 + 1 < N && T[i2] == T[i2 + 1]) {
                ++nb;
                ++i2;
            }
            double ave = (double)(i2 + (i2 - nb + 1)) / 2.0;
            int j = i2;
            while (nb > 0) {
                R[S[j]] = ave;
                --nb;
                --j;
            }
        }
    }

    public static double Kendall(byte[] y1, byte[] y2) {
        return ArrayStatistics.Kendall(y1, y2, 0, y1.length);
    }

    public static double Kendall(byte[] y1, byte[] y2, int from, int to) {
        if (y1.length != y2.length) {
            throw new IllegalArgumentException("Distributions have different lengths.");
        }
        int to1 = to - 1;
        int N = to - from;
        double n0 = (double)(N * (N - 1)) / 2.0;
        int ncnd = 0;
        for (int i2 = from; i2 < to1; ++i2) {
            for (int j = i2 + 1; j < to; ++j) {
                ncnd += Maths.Sign((int)((y1[i2] & 0xFF) - (y1[j] & 0xFF))) * Maths.Sign((int)((y2[i2] & 0xFF) - (y2[j] & 0xFF)));
            }
        }
        return (double)ncnd / n0;
    }

    public static double Kendall(short[] y1, short[] y2) {
        return ArrayStatistics.Kendall(y1, y2, 0, y1.length);
    }

    public static double Kendall(short[] y1, short[] y2, int from, int to) {
        if (y1.length != y2.length) {
            throw new IllegalArgumentException("Distributions have different lengths.");
        }
        int to1 = to - 1;
        int N = to - from;
        double n0 = (double)(N * (N - 1)) / 2.0;
        int ncnd = 0;
        for (int i2 = from; i2 < to1; ++i2) {
            for (int j = i2 + 1; j < to; ++j) {
                ncnd += Maths.Sign((int)((y1[i2] & 0xFFFF) - (y1[j] & 0xFFFF))) * Maths.Sign((int)((y2[i2] & 0xFFFF) - (y2[j] & 0xFFFF)));
            }
        }
        return (double)ncnd / n0;
    }

    public static double Kendall(int[] y1, int[] y2) {
        return ArrayStatistics.Kendall(y1, y2, 0, y1.length);
    }

    public static double Kendall(int[] y1, int[] y2, int from, int to) {
        if (y1.length != y2.length) {
            throw new IllegalArgumentException("Distributions have different lengths.");
        }
        int to1 = to - 1;
        int N = to - from;
        double n0 = (double)(N * (N - 1)) / 2.0;
        int ncnd = 0;
        for (int i2 = from; i2 < to1; ++i2) {
            for (int j = i2 + 1; j < to; ++j) {
                ncnd += Maths.Sign((int)(y1[i2] - y1[j])) * Maths.Sign((int)(y2[i2] - y2[j]));
            }
        }
        return (double)ncnd / n0;
    }

    public static double Kendall(double[] y1, double[] y2) {
        return ArrayStatistics.Kendall(y1, y2, 0, y1.length);
    }

    public static double Kendall(double[] y1, double[] y2, int from, int to) {
        if (y1.length != y2.length) {
            throw new IllegalArgumentException("Distributions have different lengths.");
        }
        int to1 = to - 1;
        int N = to - from;
        double n0 = (double)(N * (N - 1)) / 2.0;
        int ncnd = 0;
        for (int i2 = from; i2 < to1; ++i2) {
            for (int j = i2 + 1; j < to; ++j) {
                ncnd += Maths.Sign((double)(y1[i2] - y1[j])) * Maths.Sign((double)(y2[i2] - y2[j]));
            }
        }
        return (double)ncnd / n0;
    }

    public static double Kendall(float[] y1, float[] y2) {
        return ArrayStatistics.Kendall(y1, y2, 0, y1.length);
    }

    public static double Kendall(float[] y1, float[] y2, int from, int to) {
        if (y1.length != y2.length) {
            throw new IllegalArgumentException("Distributions have different lengths.");
        }
        int to1 = to - 1;
        int N = to - from;
        double n0 = (double)(N * (N - 1)) / 2.0;
        int ncnd = 0;
        for (int i2 = from; i2 < to1; ++i2) {
            for (int j = i2 + 1; j < to; ++j) {
                ncnd += Maths.Sign((float)(y1[i2] - y1[j])) * Maths.Sign((float)(y2[i2] - y2[j]));
            }
        }
        return (double)ncnd / n0;
    }

    public static double KendallB(byte[] y1, byte[] y2) {
        return ArrayStatistics.KendallB(y1, y2, 0, y1.length);
    }

    public static double KendallB(byte[] y1, byte[] y2, int from, int to) {
        if (y1.length != y2.length) {
            throw new IllegalArgumentException("Distributions have different lengths.");
        }
        int to1 = to - 1;
        int N = to - from;
        double n0 = (double)(N * (N - 1)) / 2.0;
        int ncnd = 0;
        for (int i2 = from; i2 < to1; ++i2) {
            for (int j = i2 + 1; j < to; ++j) {
                ncnd += Maths.Sign((int)((y1[i2] & 0xFF) - (y1[j] & 0xFF))) * Maths.Sign((int)((y2[i2] & 0xFF) - (y2[j] & 0xFF)));
            }
        }
        int[] T = ArrayConverter.UnsignedByteToInt((byte[])y1);
        Arrays.sort(T, from, to);
        double n1 = ArrayStatistics.KendallBties(T, from, to);
        ArrayConverter.UnsignedByteToInt((byte[])y1, (int[])T);
        Arrays.sort(T, from, to);
        double n2 = ArrayStatistics.KendallBties(T, from, to);
        T = null;
        return (double)ncnd / Math.sqrt((n0 - n1) * (n0 - n2));
    }

    public static double KendallB(short[] y1, short[] y2) {
        return ArrayStatistics.KendallB(y1, y2, 0, y1.length);
    }

    public static double KendallB(short[] y1, short[] y2, int from, int to) {
        if (y1.length != y2.length) {
            throw new IllegalArgumentException("Distributions have different lengths.");
        }
        int to1 = to - 1;
        int N = to - from;
        double n0 = (double)(N * (N - 1)) / 2.0;
        int ncnd = 0;
        for (int i2 = from; i2 < to1; ++i2) {
            for (int j = i2 + 1; j < to; ++j) {
                ncnd += Maths.Sign((int)((y1[i2] & 0xFFFF) - (y1[j] & 0xFFFF))) * Maths.Sign((int)((y2[i2] & 0xFFFF) - (y2[j] & 0xFFFF)));
            }
        }
        int[] T = ArrayConverter.UnsignedShortToInt((short[])y1);
        Arrays.sort(T, from, to);
        double n1 = ArrayStatistics.KendallBties(T, from, to);
        ArrayConverter.UnsignedShortToInt((short[])y1, (int[])T);
        Arrays.sort(T, from, to);
        double n2 = ArrayStatistics.KendallBties(T, from, to);
        T = null;
        return (double)ncnd / Math.sqrt((n0 - n1) * (n0 - n2));
    }

    public static double KendallB(int[] y1, int[] y2) {
        return ArrayStatistics.KendallB(y1, y2, 0, y1.length);
    }

    public static double KendallB(int[] y1, int[] y2, int from, int to) {
        if (y1.length != y2.length) {
            throw new IllegalArgumentException("Distributions have different lengths.");
        }
        int to1 = to - 1;
        int N = to - from;
        double n0 = (double)(N * (N - 1)) / 2.0;
        int ncnd = 0;
        for (int i2 = from; i2 < to1; ++i2) {
            for (int j = i2 + 1; j < to; ++j) {
                ncnd += Maths.Sign((int)(y1[i2] - y1[j])) * Maths.Sign((int)(y2[i2] - y2[j]));
            }
        }
        int[] T = (int[])y1.clone();
        Arrays.sort(T, from, to);
        double n1 = ArrayStatistics.KendallBties(T, from, to);
        System.arraycopy(y2, 0, T, 0, N);
        Arrays.sort(T, from, to);
        double n2 = ArrayStatistics.KendallBties(T, from, to);
        T = null;
        return (double)ncnd / Math.sqrt((n0 - n1) * (n0 - n2));
    }

    public static double KendallB(float[] y1, float[] y2) {
        return ArrayStatistics.KendallB(y1, y2, 0, y1.length);
    }

    public static double KendallB(float[] y1, float[] y2, int from, int to) {
        if (y1.length != y2.length) {
            throw new IllegalArgumentException("Distributions have different lengths.");
        }
        int to1 = to - 1;
        int N = to - from;
        double n0 = (double)(N * (N - 1)) / 2.0;
        int ncnd = 0;
        for (int i2 = from; i2 < to1; ++i2) {
            for (int j = i2 + 1; j < to; ++j) {
                ncnd += Maths.Sign((float)(y1[i2] - y1[j])) * Maths.Sign((float)(y2[i2] - y2[j]));
            }
        }
        float[] T = (float[])y1.clone();
        Arrays.sort(T, from, to);
        double n1 = ArrayStatistics.KendallBties(T, from, to);
        System.arraycopy(y2, 0, T, 0, N);
        Arrays.sort(T, from, to);
        double n2 = ArrayStatistics.KendallBties(T, from, to);
        T = null;
        return (double)ncnd / Math.sqrt((n0 - n1) * (n0 - n2));
    }

    public static double KendallB(double[] y1, double[] y2) {
        return ArrayStatistics.KendallB(y1, y2, 0, y1.length);
    }

    public static double KendallB(double[] y1, double[] y2, int from, int to) {
        if (y1.length != y2.length) {
            throw new IllegalArgumentException("Distributions have different lengths.");
        }
        int to1 = to - 1;
        int N = to - from;
        double n0 = (double)(N * (N - 1)) / 2.0;
        int ncnd = 0;
        for (int i2 = from; i2 < to1; ++i2) {
            for (int j = i2 + 1; j < to; ++j) {
                ncnd += Maths.Sign((double)(y1[i2] - y1[j])) * Maths.Sign((double)(y2[i2] - y2[j]));
            }
        }
        double[] T = (double[])y1.clone();
        Arrays.sort(T, from, to);
        double n1 = ArrayStatistics.KendallBties(T, from, to);
        System.arraycopy(y2, 0, T, 0, N);
        Arrays.sort(T, from, to);
        double n2 = ArrayStatistics.KendallBties(T, from, to);
        T = null;
        return (double)ncnd / Math.sqrt((n0 - n1) * (n0 - n2));
    }

    private static double KendallBties(int[] T, int from, int to) {
        int to1 = to - 1;
        double n = 0.0;
        for (int i2 = from; i2 < to1; ++i2) {
            if (T[i2] != T[i2 + 1]) continue;
            int nb = 2;
            ++i2;
            while (i2 < to1 && T[i2] == T[i2 + 1]) {
                ++i2;
                ++nb;
            }
            n += (double)(nb * (nb - 1)) / 2.0;
        }
        return n;
    }

    private static double KendallBties(float[] T, int from, int to) {
        int to1 = to - 1;
        double n = 0.0;
        for (int i2 = from; i2 < to1; ++i2) {
            if (T[i2] != T[i2 + 1]) continue;
            int nb = 2;
            ++i2;
            while (i2 < to1 && T[i2] == T[i2 + 1]) {
                ++i2;
                ++nb;
            }
            n += (double)(nb * (nb - 1)) / 2.0;
        }
        return n;
    }

    private static double KendallBties(double[] T, int from, int to) {
        int to1 = to - 1;
        double n = 0.0;
        for (int i2 = from; i2 < to1; ++i2) {
            if (T[i2] != T[i2 + 1]) continue;
            int nb = 2;
            ++i2;
            while (i2 < to1 && T[i2] == T[i2 + 1]) {
                ++i2;
                ++nb;
            }
            n += (double)(nb * (nb - 1)) / 2.0;
        }
        return n;
    }

    public static double GoodmanKruskalGamma(byte[] y1, byte[] y2) {
        return ArrayStatistics.GoodmanKruskalGamma(y1, y2, 0, y1.length);
    }

    public static double GoodmanKruskalGamma(byte[] y1, byte[] y2, int from, int to) {
        if (y1.length != y2.length) {
            throw new IllegalArgumentException("Distributions have different lengths.");
        }
        int to1 = to - 1;
        int nc = 0;
        int nd = 0;
        for (int i2 = from; i2 < to1; ++i2) {
            for (int j = i2 + 1; j < to; ++j) {
                int s2;
                int s1 = Maths.Sign((int)((y1[i2] & 0xFF) - (y1[j] & 0xFF)));
                if (s1 == 0 || (s2 = Maths.Sign((int)((y2[i2] & 0xFF) - (y2[j] & 0xFF)))) == 0) continue;
                if (s1 == s2) {
                    ++nc;
                    continue;
                }
                ++nd;
            }
        }
        return (double)(nc - nd) / (double)(nc + nd);
    }

    public static double GoodmanKruskalGamma(short[] y1, short[] y2) {
        return ArrayStatistics.GoodmanKruskalGamma(y1, y2, 0, y1.length);
    }

    public static double GoodmanKruskalGamma(short[] y1, short[] y2, int from, int to) {
        if (y1.length != y2.length) {
            throw new IllegalArgumentException("Distributions have different lengths.");
        }
        int to1 = to - 1;
        int nc = 0;
        int nd = 0;
        for (int i2 = from; i2 < to1; ++i2) {
            for (int j = i2 + 1; j < to; ++j) {
                int s2;
                int s1 = Maths.Sign((int)((y1[i2] & 0xFFFF) - (y1[j] & 0xFFFF)));
                if (s1 == 0 || (s2 = Maths.Sign((int)((y2[i2] & 0xFFFF) - (y2[j] & 0xFFFF)))) == 0) continue;
                if (s1 == s2) {
                    ++nc;
                    continue;
                }
                ++nd;
            }
        }
        return (double)(nc - nd) / (double)(nc + nd);
    }

    public static double GoodmanKruskalGamma(int[] y1, int[] y2) {
        return ArrayStatistics.GoodmanKruskalGamma(y1, y2, 0, y1.length);
    }

    public static double GoodmanKruskalGamma(int[] y1, int[] y2, int from, int to) {
        if (y1.length != y2.length) {
            throw new IllegalArgumentException("Distributions have different lengths.");
        }
        int to1 = to - 1;
        int nc = 0;
        int nd = 0;
        for (int i2 = from; i2 < to1; ++i2) {
            for (int j = i2 + 1; j < to; ++j) {
                int s2;
                int s1 = Maths.Sign((int)(y1[i2] - y1[j]));
                if (s1 == 0 || (s2 = Maths.Sign((int)(y2[i2] - y2[j]))) == 0) continue;
                if (s1 == s2) {
                    ++nc;
                    continue;
                }
                ++nd;
            }
        }
        return (double)(nc - nd) / (double)(nc + nd);
    }

    public static double GoodmanKruskalGamma(float[] y1, float[] y2) {
        return ArrayStatistics.GoodmanKruskalGamma(y1, y2, 0, y1.length);
    }

    public static double GoodmanKruskalGamma(float[] y1, float[] y2, int from, int to) {
        if (y1.length != y2.length) {
            throw new IllegalArgumentException("Distributions have different lengths.");
        }
        int to1 = to - 1;
        int nc = 0;
        int nd = 0;
        for (int i2 = from; i2 < to1; ++i2) {
            for (int j = i2 + 1; j < to; ++j) {
                int s2;
                int s1 = Maths.Sign((float)(y1[i2] - y1[j]));
                if (s1 == 0 || (s2 = Maths.Sign((float)(y2[i2] - y2[j]))) == 0) continue;
                if (s1 == s2) {
                    ++nc;
                    continue;
                }
                ++nd;
            }
        }
        return (double)(nc - nd) / (double)(nc + nd);
    }

    public static double GoodmanKruskalGamma(double[] y1, double[] y2) {
        return ArrayStatistics.GoodmanKruskalGamma(y1, y2, 0, y1.length);
    }

    public static double GoodmanKruskalGamma(double[] y1, double[] y2, int from, int to) {
        if (y1.length != y2.length) {
            throw new IllegalArgumentException("Distributions have different lengths.");
        }
        int to1 = to - 1;
        int nc = 0;
        int nd = 0;
        for (int i2 = from; i2 < to1; ++i2) {
            for (int j = i2 + 1; j < to; ++j) {
                int s2;
                int s1 = Maths.Sign((double)(y1[i2] - y1[j]));
                if (s1 == 0 || (s2 = Maths.Sign((double)(y2[i2] - y2[j]))) == 0) continue;
                if (s1 == s2) {
                    ++nc;
                    continue;
                }
                ++nd;
            }
        }
        return (double)(nc - nd) / (double)(nc + nd);
    }

    public static double Entropy(byte[] counts) {
        double x = 0.0;
        int total = 0;
        for (int j = 0; j < counts.length; ++j) {
            int v = counts[j] & 0xFF;
            x -= Maths.xLog2x((int)v);
            total += v;
        }
        return x + Maths.xLog2x((int)total);
    }

    public static double Entropy(short[] counts) {
        double x = 0.0;
        int total = 0;
        for (int j = 0; j < counts.length; ++j) {
            int v = counts[j] & 0xFFFF;
            x -= Maths.xLog2x((int)v);
            total += v;
        }
        return x + Maths.xLog2x((int)total);
    }

    public static double Entropy(int[] counts) {
        double x = 0.0;
        int total = 0;
        for (int j = 0; j < counts.length; ++j) {
            x -= Maths.xLog2x((int)counts[j]);
            total += counts[j];
        }
        return x + Maths.xLog2x((int)total);
    }

    public static double Entropy(double[] counts) {
        double total = 0.0;
        double x = 0.0;
        for (int j = 0; j < counts.length; ++j) {
            x -= Maths.xLog2x((double)counts[j]);
            total += counts[j];
        }
        return x + Maths.xLog2x((double)total);
    }

    public static void Errors(double[] theory, double[] predictions) {
        ArrayFeatures AF = new ArrayFeatures();
        MeanAbsoluteError = 0.0;
        RootMeanSquaredError = 0.0;
        double average = AF.Average(theory);
        double sct = 0.0;
        for (int i2 = 0; i2 < theory.length; ++i2) {
            double diff = theory[i2] - predictions[i2];
            MeanAbsoluteError += Math.abs(diff);
            RootMeanSquaredError += diff * diff;
            sct += Maths.Power((double)(theory[i2] - average), (int)2);
        }
        R2 = 1.0 - RootMeanSquaredError / sct;
        MeanAbsoluteError /= (double)theory.length;
        RootMeanSquaredError = Math.sqrt(RootMeanSquaredError / (double)theory.length);
    }
}

