/*
 * Decompiled with CFR 0.152.
 */
package arrayTiTi;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Scanner;
import utils.times.Dates;

public class ArrayIO {
    public static void Write(int[] Tab, String Name2, String Separator2) throws IOException {
        int size = Tab.length;
        System.out.print("Writing 1D array '" + Name2 + "'...");
        System.out.flush();
        DataOutputStream Out = new DataOutputStream(new FileOutputStream(Name2));
        Out.write(String.valueOf("# File written with a java class created by Guillaume THIBAULT, on " + Dates.Date() + " at " + Dates.Time(":") + "\n").getBytes("ASCII"));
        Out.write(String.valueOf(size + "\n").getBytes("ASCII"));
        for (int x = 0; x < size - 1; ++x) {
            Out.write(String.valueOf(Tab[x] + Separator2).getBytes("ASCII"));
        }
        Out.write(String.valueOf(Tab[size - 1] + "\n").getBytes("ASCII"));
        Out.close();
        System.out.println(" successfully.");
        System.out.flush();
    }

    public static void Write(double[] Tab, String Name2, String Separator2) throws IOException {
        int size = Tab.length;
        System.out.print("Writing 1D array '" + Name2 + "'...");
        System.out.flush();
        DataOutputStream Out = new DataOutputStream(new FileOutputStream(Name2));
        Out.write(String.valueOf("# File written with a java class created by Guillaume THIBAULT, on " + Dates.Date() + " at " + Dates.Time(":") + "\n").getBytes("ASCII"));
        Out.write(String.valueOf(size + "\n").getBytes("ASCII"));
        for (int x = 0; x < size - 1; ++x) {
            Out.write(String.valueOf(Tab[x] + Separator2).getBytes("ASCII"));
        }
        Out.write(String.valueOf(Tab[size - 1] + "\n").getBytes("ASCII"));
        Out.close();
        System.out.println(" successfully.");
        System.out.flush();
    }

    public static int[] ReadInt1D(File file) throws IOException {
        System.out.print("Reading 1D array '" + file.getAbsolutePath() + "'...");
        System.out.flush();
        Scanner in = new Scanner(new FileInputStream(file.getAbsolutePath()));
        while (in.hasNext() && !in.hasNextInt()) {
            in.nextLine();
        }
        if (!in.hasNext()) {
            throw new IOException("End of file, dimensions not found.");
        }
        int size = in.nextInt();
        int[] Tab = new int[size];
        for (int y = 0; y < size; ++y) {
            Tab[y] = in.nextInt();
        }
        in.close();
        System.out.println(" successfully.");
        System.out.flush();
        return Tab;
    }

    public static double[] ReadDouble1D(File file) throws IOException {
        System.out.print("Reading 1D array '" + file.getAbsolutePath() + "'...");
        System.out.flush();
        Scanner in = new Scanner(new FileInputStream(file.getAbsolutePath()));
        while (in.hasNext() && !in.hasNextInt()) {
            in.nextLine();
        }
        if (!in.hasNext()) {
            throw new IOException("End of file, dimensions not found.");
        }
        int size = in.nextInt();
        double[] Tab = new double[size];
        for (int y = 0; y < size; ++y) {
            Tab[y] = Double.valueOf(in.next());
        }
        in.close();
        System.out.println(" successfully.");
        System.out.flush();
        return Tab;
    }

    public static void Write(int[][] Tab, String Name2, String Separator2) throws IOException {
        int width = Tab[0].length;
        int height = Tab.length;
        int w1 = width - 1;
        System.out.print("Writing 2D array '" + Name2 + "'...");
        System.out.flush();
        DataOutputStream Out = new DataOutputStream(new FileOutputStream(Name2));
        Out.write(String.valueOf("# File written with a java class created by Guillaume THIBAULT, on " + Dates.Date() + " at " + Dates.Time(":") + "\n").getBytes("ASCII"));
        Out.write(String.valueOf(width + Separator2 + height + "\n").getBytes("ASCII"));
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < w1; ++x) {
                Out.write(String.valueOf(Tab[y][x] + Separator2).getBytes("ASCII"));
            }
            Out.write(String.valueOf(Tab[y][w1] + "\n").getBytes("ASCII"));
        }
        Out.close();
        System.out.println(" successfully.");
        System.out.flush();
    }

    public static void Write(double[][] Tab, String Name2, String Separator2) throws IOException {
        int width = Tab[0].length;
        int height = Tab.length;
        int w1 = width - 1;
        System.out.print("Writing 2D array '" + Name2 + "'...");
        System.out.flush();
        DataOutputStream Out = new DataOutputStream(new FileOutputStream(Name2));
        Out.write(String.valueOf("# File written with a java class created by Guillaume THIBAULT, on " + Dates.Date() + " at " + Dates.Time(":") + "\n").getBytes("ASCII"));
        Out.write(String.valueOf(width + Separator2 + height + "\n").getBytes("ASCII"));
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < w1; ++x) {
                Out.write(String.valueOf(Tab[y][x] + Separator2).getBytes("ASCII"));
            }
            Out.write(String.valueOf(Tab[y][w1] + "\n").getBytes("ASCII"));
        }
        Out.close();
        System.out.println(" successfully.");
        System.out.flush();
    }

    public static int[][] ReadInt2D(File file) throws IOException {
        System.out.print("Reading 2D array '" + file.getAbsolutePath() + "'...");
        System.out.flush();
        Scanner in = new Scanner(new FileInputStream(file.getAbsolutePath()));
        while (in.hasNext() && !in.hasNextInt()) {
            in.nextLine();
        }
        if (!in.hasNext()) {
            throw new IOException("End of file, dimensions not found.");
        }
        int width = in.nextInt();
        int height = in.nextInt();
        int[][] Tab = new int[height][width];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Tab[y][x] = in.nextInt();
            }
        }
        in.close();
        System.out.println(" successfully.");
        System.out.flush();
        return Tab;
    }

    public static double[][] ReadDouble2D(File file) throws IOException {
        System.out.print("Reading 2D array '" + file.getAbsolutePath() + "'...");
        System.out.flush();
        Scanner in = new Scanner(new FileInputStream(file.getAbsolutePath()));
        while (in.hasNext() && !in.hasNextInt()) {
            in.nextLine();
        }
        if (!in.hasNext()) {
            throw new IOException("End of file, dimensions not found.");
        }
        int width = in.nextInt();
        int height = in.nextInt();
        double[][] Tab = new double[height][width];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Tab[y][x] = Double.valueOf(in.next());
            }
        }
        in.close();
        System.out.println(" successfully.");
        System.out.flush();
        return Tab;
    }

    public static void WriteAsFunction(int[] Tab, String Name2) throws IOException {
        int size = Tab.length;
        System.out.print("Writing 1D array (as a function/histogram) '" + Name2 + "'...");
        System.out.flush();
        DataOutputStream Out = new DataOutputStream(new FileOutputStream(Name2));
        Out.write(String.valueOf("# File written with a java class created by Guillaume THIBAULT, on " + Dates.Date() + " at " + Dates.Time(":") + "\n").getBytes("ASCII"));
        for (int x = 0; x < size - 1; ++x) {
            Out.write((x + " " + Tab[x] + "\n").getBytes("ASCII"));
        }
        Out.write((size - 1 + " " + Tab[size - 1] + "\n").getBytes("ASCII"));
        Out.close();
        System.out.println(" successfully.");
        System.out.flush();
    }

    public static void WriteAsFunction(int[] Tab, String Name2, int DoNotWrite) throws IOException {
        int size = Tab.length;
        System.out.print("Writing 1D array (as a function/histogram) '" + Name2 + "'...");
        System.out.flush();
        DataOutputStream Out = new DataOutputStream(new FileOutputStream(Name2));
        Out.write(String.valueOf("# File written with a java class created by Guillaume THIBAULT, on " + Dates.Date() + " at " + Dates.Time(":") + "\n").getBytes("ASCII"));
        for (int x = 0; x < size - 1; ++x) {
            if (Tab[x] == DoNotWrite) continue;
            Out.write((x + " " + Tab[x] + "\n").getBytes("ASCII"));
        }
        if (Tab[size - 1] != DoNotWrite) {
            Out.write((size - 1 + " " + Tab[size - 1] + "\n").getBytes("ASCII"));
        }
        Out.close();
        System.out.println(" successfully.");
        System.out.flush();
    }

    public static int[] ReadAsFunctionInt1D(File file) throws IOException {
        int x;
        System.out.print("Reading 2D array (as a function/histogram) '" + file.getAbsolutePath() + "'...");
        System.out.flush();
        Scanner in = new Scanner(new FileInputStream(file.getAbsolutePath()));
        while (in.hasNext() && !in.hasNextInt()) {
            in.nextLine();
        }
        if (!in.hasNext()) {
            throw new IOException("End of file, dimensions not found.");
        }
        int nbrow = 0;
        int max = 0;
        while (in.hasNext()) {
            x = in.nextInt();
            if (max < x) {
                max = x;
            }
            in.nextInt();
            ++nbrow;
        }
        in.close();
        int[] array = new int[max + 1];
        in = new Scanner(new FileInputStream(file.getAbsolutePath()));
        while (in.hasNext() && !in.hasNextInt()) {
            in.nextLine();
        }
        if (!in.hasNext()) {
            throw new IOException("End of file, dimensions not found.");
        }
        for (int i2 = 0; i2 < nbrow; ++i2) {
            x = in.nextInt();
            array[x] = in.nextInt();
        }
        in.close();
        System.out.println(" successfully.");
        System.out.flush();
        return array;
    }

    public static void Display(byte[] Tab, String Separator2) {
        if (Tab == null) {
            System.out.println("null");
            return;
        }
        int size = Tab.length;
        for (int y = 0; y < size - 1; ++y) {
            System.out.print(Tab[y] + Separator2);
        }
        System.out.println(Tab[size - 1]);
    }

    public static void Display(short[] Tab, String Separator2) {
        if (Tab == null) {
            System.out.println("null");
            return;
        }
        int size = Tab.length;
        for (int y = 0; y < size - 1; ++y) {
            System.out.print(Tab[y] + Separator2);
        }
        System.out.println(Tab[size - 1]);
    }

    public static void Display(int[] Tab, String name, String Separator2) {
        System.out.print(name + ":" + Separator2);
        ArrayIO.Display(Tab, Separator2);
    }

    public static void Display(int[] Tab, String Separator2) {
        if (Tab == null) {
            System.out.println("null");
            return;
        }
        ArrayIO.Display(Tab, Separator2, 0, Tab.length);
    }

    public static void Display(int[] Tab, String Separator2, int from, int to) {
        if (Tab == null) {
            System.out.println("null");
            return;
        }
        --to;
        for (int y = from; y < to; ++y) {
            System.out.print(Tab[y] + Separator2);
        }
        System.out.println(Tab[to]);
    }

    public static void Display(long[] Tab, String name, String Separator2) {
        System.out.print(name + ":" + Separator2);
        ArrayIO.Display(Tab, Separator2);
    }

    public static void Display(long[] Tab, String Separator2) {
        if (Tab == null) {
            System.out.println("null");
            return;
        }
        ArrayIO.Display(Tab, Separator2, 0, Tab.length);
    }

    public static void Display(long[] Tab, String Separator2, int from, int to) {
        if (Tab == null) {
            System.out.println("null");
            return;
        }
        --to;
        for (int y = from; y < to; ++y) {
            System.out.print(Tab[y] + Separator2);
        }
        System.out.println(Tab[to]);
    }

    public static void Display(float[] Tab, String name, String Separator2) {
        System.out.print(name + ":" + Separator2);
        ArrayIO.Display(Tab, Separator2);
    }

    public static void Display(float[] Tab, String Separator2) {
        if (Tab == null) {
            System.out.println("null");
            return;
        }
        int size = Tab.length;
        for (int y = 0; y < size - 1; ++y) {
            System.out.print(Tab[y] + Separator2);
        }
        System.out.println(Tab[size - 1]);
    }

    public static void Display(double[] Tab, String name, String Separator2) {
        System.out.print(name + ":" + Separator2);
        if (Tab == null) {
            System.out.println("null");
            return;
        }
        int size = Tab.length;
        for (int y = 0; y < size - 1; ++y) {
            System.out.print(Tab[y] + Separator2);
        }
        System.out.println(Tab[size - 1]);
    }

    public static void Display(double[] Tab, String name, String Separator2, int precision) {
        System.out.print(name + ":" + Separator2);
        if (Tab == null) {
            System.out.println("null");
            return;
        }
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(precision);
        int size = Tab.length;
        for (int y = 0; y < size - 1; ++y) {
            System.out.print(df.format(Tab[y]) + Separator2);
        }
        System.out.println(df.format(Tab[size - 1]));
        df = null;
    }

    public static void Display(boolean[] Tab, String name, String Separator2) {
        System.out.print(name + ":" + Separator2);
        ArrayIO.Display(Tab, Separator2);
    }

    public static void Display(boolean[] Tab, String Separator2) {
        if (Tab == null) {
            System.out.println("null");
            return;
        }
        int size = Tab.length;
        for (int y = 0; y < size - 1; ++y) {
            System.out.print((Tab[y] ? 1 : 0) + Separator2);
        }
        System.out.println(Tab[size - 1] ? 1 : 0);
    }

    public static void Display(byte[] array, int width, int height, String Separator2) {
        if (width * height != array.length) {
            throw new IllegalArgumentException("width*height != array.length");
        }
        if (array == null) {
            System.out.println("null");
            return;
        }
        int w1 = width - 1;
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < w1; ++x) {
                System.out.print(array[pos++] + Separator2);
            }
            System.out.println(array[pos++]);
        }
    }

    public static void Display(short[] array, int width, int height, String Separator2) {
        if (width * height != array.length) {
            throw new IllegalArgumentException("width*height != array.length");
        }
        if (array == null) {
            System.out.println("null");
            return;
        }
        int w1 = width - 1;
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < w1; ++x) {
                System.out.print(array[pos++] + Separator2);
            }
            System.out.println(array[pos++]);
        }
    }

    public static void Display(int[] array, int width, int height, String Separator2) {
        if (width * height != array.length) {
            throw new IllegalArgumentException("width*height != array.length");
        }
        if (array == null) {
            System.out.println("null");
            return;
        }
        int w1 = width - 1;
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < w1; ++x) {
                System.out.print(array[pos++] + Separator2);
            }
            System.out.println(array[pos++]);
        }
    }

    public static void Display(double[] array, int width, int height, String Separator2) {
        if (width * height != array.length) {
            throw new IllegalArgumentException("width*height != array.length");
        }
        if (array == null) {
            System.out.println("null");
            return;
        }
        int w1 = width - 1;
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < w1; ++x) {
                System.out.print(array[pos++] + Separator2);
            }
            System.out.println(array[pos++]);
        }
    }

    public static void Display(float[] array, int width, int height, String Separator2) {
        if (width * height != array.length) {
            throw new IllegalArgumentException("width*height != array.length");
        }
        if (array == null) {
            System.out.println("null");
            return;
        }
        int w1 = width - 1;
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < w1; ++x) {
                System.out.print(array[pos++] + Separator2);
            }
            System.out.println(array[pos++]);
        }
    }

    public static void Display(int[][] Tab, String name, String Separator2) {
        System.out.println(name + ":" + Separator2);
        ArrayIO.Display(Tab, Separator2);
    }

    public static void Display(int[][] Tab, String Separator2) {
        if (Tab == null) {
            System.out.println("null");
            return;
        }
        int height = Tab.length;
        int w1 = Tab[0].length - 1;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < w1; ++x) {
                System.out.print(Tab[y][x] + Separator2);
            }
            System.out.println(Tab[y][w1]);
        }
    }

    public static void Display(float[][] Tab, String name, String Separator2) {
        System.out.println(name + ":");
        ArrayIO.Display(Tab, Separator2);
    }

    public static void Display(float[][] Tab, String Separator2) {
        if (Tab == null) {
            System.out.println("null");
            return;
        }
        int height = Tab.length;
        for (int y = 0; y < height; ++y) {
            if (Tab[y] == null) {
                System.out.println("null");
                continue;
            }
            int w1 = Tab[y].length - 1;
            for (int x = 0; x < w1; ++x) {
                System.out.print(Tab[y][x] + Separator2);
            }
            System.out.println(Tab[y][w1]);
        }
    }

    public static void Display(double[][] Tab, String name, String Separator2) {
        System.out.println(name + ":" + Separator2);
        ArrayIO.Display(Tab, Separator2);
    }

    public static void Display(double[][] Tab, String Separator2) {
        if (Tab == null) {
            System.out.println("null");
            return;
        }
        int height = Tab.length;
        int w1 = Tab[0].length - 1;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < w1; ++x) {
                System.out.print(Tab[y][x] + Separator2);
            }
            System.out.println(Tab[y][w1]);
        }
    }

    public static void Display(double[][] Tab, String name, String Separator2, int precision) {
        System.out.println(name + ":" + Separator2);
        if (Tab == null) {
            System.out.println("null");
            return;
        }
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(precision);
        int height = Tab.length;
        int w1 = Tab[0].length - 1;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < w1; ++x) {
                System.out.print(df.format(Tab[y][x]) + Separator2);
            }
            System.out.println(df.format(Tab[y][w1]));
        }
        df = null;
    }

    public static void Display(boolean[][] Tab, String name, String Separator2) {
        System.out.println(name + ":" + Separator2);
        ArrayIO.Display(Tab, Separator2);
    }

    public static void Display(boolean[][] Tab, String Separator2) {
        if (Tab == null) {
            System.out.println("null");
            return;
        }
        int height = Tab.length;
        int w1 = Tab[0].length - 1;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < w1; ++x) {
                System.out.print((Tab[y][x] ? 1 : 0) + Separator2);
            }
            System.out.println(Tab[y][w1] ? 1 : 0);
        }
    }

    public static void Display(byte[][] Tab, String name, String Separator2) {
        System.out.println(name + ":" + Separator2);
        ArrayIO.Display(Tab, Separator2);
    }

    public static void Display(byte[][] Tab, String Separator2) {
        if (Tab == null) {
            System.out.println("null");
            return;
        }
        int height = Tab.length;
        int w1 = Tab[0].length - 1;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < w1; ++x) {
                System.out.print(Tab[y][x] + Separator2);
            }
            System.out.println(Tab[y][w1]);
        }
    }

    public static void DisplayUnsigned(byte[][] Tab, String Separator2) {
        if (Tab == null) {
            System.out.println("null");
            return;
        }
        int height = Tab.length;
        int w1 = Tab[0].length - 1;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < w1; ++x) {
                System.out.print((Tab[y][x] & 0xFF) + Separator2);
            }
            System.out.println(Tab[y][w1] & 0xFF);
        }
    }

    public static void Display(short[][] Tab, String name, String Separator2) {
        System.out.println(name + ":" + Separator2);
        ArrayIO.Display(Tab, Separator2);
    }

    public static void Display(short[][] Tab, String Separator2) {
        if (Tab == null) {
            System.out.println("null");
            return;
        }
        int height = Tab.length;
        int w1 = Tab[0].length - 1;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < w1; ++x) {
                System.out.print(Tab[y][x] + Separator2);
            }
            System.out.println(Tab[y][w1]);
        }
    }

    public static void DisplayUnsigned(short[][] Tab, String name, String Separator2) {
        System.out.println(name + ":" + Separator2);
        ArrayIO.Display(Tab, Separator2);
    }

    public static void DisplayUnsigned(short[][] Tab, String Separator2) {
        if (Tab == null) {
            System.out.println("null");
            return;
        }
        int height = Tab.length;
        int w1 = Tab[0].length - 1;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < w1; ++x) {
                System.out.print((Tab[y][x] & 0xFFFF) + Separator2);
            }
            System.out.println(Tab[y][w1] & 0xFFFF);
        }
    }

    public static void Display(String[] Tab, String name, String Separator2) {
        System.out.print(name + ":" + Separator2);
        ArrayIO.Display(Tab, Separator2);
    }

    public static void Display(String[] Tab, String Separator2) {
        if (Tab == null) {
            System.out.println("null");
            return;
        }
        int size = Tab.length;
        for (int y = 0; y < size - 1; ++y) {
            System.out.print("\"" + Tab[y] + "\"" + Separator2);
        }
        System.out.println("\"" + Tab[size - 1] + "\"");
    }

    public static void Display(File[] Tab, String name, String Separator2) {
        System.out.print(name + ":" + Separator2);
        ArrayIO.Display(Tab, Separator2);
    }

    public static void Display(File[] Tab, String Separator2) {
        if (Tab == null) {
            System.out.println("null");
            return;
        }
        int size = Tab.length;
        for (int y = 0; y < size - 1; ++y) {
            System.out.print("\"" + Tab[y].getAbsolutePath() + "\"" + Separator2);
        }
        System.out.println("\"" + Tab[size - 1].getAbsolutePath() + "\"");
    }

    public static void Display(short[] Tab, String name, String Separator2) {
        System.out.print(name + ":" + Separator2);
        ArrayIO.Display(Tab, Separator2);
    }

    public static void DisplayUnsigned(short[] Tab, String name, String Separator2) {
        if (Tab == null) {
            System.out.println("null");
            return;
        }
        System.out.print(name + ": ");
        int size = Tab.length;
        for (int y = 0; y < size - 1; ++y) {
            System.out.print((Tab[y] & 0xFFFF) + Separator2);
        }
        System.out.println(Tab[size - 1] & 0xFFFF);
    }

    public static void Display(byte[] Tab, String name, String Separator2) {
        System.out.print(name + ":" + Separator2);
        ArrayIO.Display(Tab, Separator2);
    }

    public static void DisplayUnsigned(byte[] Tab, String name, String Separator2) {
        if (Tab == null) {
            System.out.println("null");
            return;
        }
        System.out.print(name + ": ");
        int size = Tab.length;
        for (int y = 0; y < size - 1; ++y) {
            System.out.print((Tab[y] & 0xFF) + Separator2);
        }
        System.out.println(Tab[size - 1] & 0xFF);
    }

    public static void DisplayUnsigned(byte[] array, int width, int height, String name, String Separator2) {
        if (width * height != array.length) {
            throw new IllegalArgumentException("width x height != array.length");
        }
        System.out.println(name + ":");
        if (array == null) {
            System.out.println("null");
            return;
        }
        int w1 = width - 1;
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < w1; ++x) {
                System.out.print((array[pos++] & 0xFF) + Separator2);
            }
            System.out.println(array[pos++] & 0xFF);
        }
    }

    public static void DisplayUnsigned(short[] array, int width, int height, String name, String Separator2) {
        if (width * height != array.length) {
            throw new IllegalArgumentException("width x height != array.length");
        }
        System.out.println(name + ":");
        if (array == null) {
            System.out.println("null");
            return;
        }
        int w1 = width - 1;
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < w1; ++x) {
                System.out.print((array[pos++] & 0xFFFF) + Separator2);
            }
            System.out.println(array[pos++] & 0xFFFF);
        }
    }

    public static void Display(int[] array, int width, int height, String name, String Separator2) {
        if (width * height != array.length) {
            throw new IllegalArgumentException("width x height != array.length");
        }
        System.out.println(name + ":");
        if (array == null) {
            System.out.println("null");
            return;
        }
        int w1 = width - 1;
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < w1; ++x) {
                System.out.print(array[pos++] + Separator2);
            }
            System.out.println(array[pos++]);
        }
    }

    public static void Display(float[] array, int width, int height, String name, String Separator2) {
        if (width * height != array.length) {
            throw new IllegalArgumentException("width x height != array.length");
        }
        System.out.println(name + ":");
        if (array == null) {
            System.out.println("null");
            return;
        }
        int w1 = width - 1;
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < w1; ++x) {
                System.out.print(array[pos++] + Separator2);
            }
            System.out.println(array[pos++]);
        }
    }

    public static void Display(double[] array, int width, int height, String name, String Separator2) {
        if (width * height != array.length) {
            throw new IllegalArgumentException("width x height != array.length");
        }
        System.out.println(name + ":");
        if (array == null) {
            System.out.println("null");
            return;
        }
        int w1 = width - 1;
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < w1; ++x) {
                System.out.print(array[pos++] + Separator2);
            }
            System.out.println(array[pos++]);
        }
    }

    public static void Display(double[] array, int width, int height, String name, String Separator2, int precision) {
        if (width * height != array.length) {
            throw new IllegalArgumentException("width x height != array.length");
        }
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(precision);
        System.out.println(name + ":");
        if (array == null) {
            System.out.println("null");
            return;
        }
        int w1 = width - 1;
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < w1; ++x) {
                System.out.print(df.format(array[pos++]) + Separator2);
            }
            System.out.println(df.format(array[pos++]));
        }
        df = null;
    }

    public static void DisplayUnsigned(byte[] array, int width, int height, int depth, String name, String Separator2) {
        if (width * height * depth != array.length) {
            throw new IllegalArgumentException("width x height x depth != array.length");
        }
        System.out.println(name + ":");
        if (array == null) {
            System.out.println("null");
            return;
        }
        int w1 = width - 1;
        int pos = 0;
        for (int z = 0; z < depth; ++z) {
            System.out.println("Layer " + z);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < w1; ++x) {
                    System.out.print((array[pos++] & 0xFF) + Separator2);
                }
                System.out.println(array[pos++] & 0xFF);
            }
        }
    }

    public static void DisplayUnsigned(short[] array, int width, int height, int depth, String name, String Separator2) {
        if (width * height * depth != array.length) {
            throw new IllegalArgumentException("width x height x depth != array.length");
        }
        System.out.println(name + ":");
        if (array == null) {
            System.out.println("null");
            return;
        }
        int w1 = width - 1;
        int pos = 0;
        for (int z = 0; z < depth; ++z) {
            System.out.println("Layer " + z);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < w1; ++x) {
                    System.out.print((array[pos++] & 0xFFFF) + Separator2);
                }
                System.out.println(array[pos++] & 0xFFFF);
            }
        }
    }

    public static void Display(int[] array, int width, int height, int depth, String name, String Separator2) {
        if (width * height * depth != array.length) {
            throw new IllegalArgumentException("width x height x depth != array.length");
        }
        System.out.println(name + ":");
        if (array == null) {
            System.out.println("null");
            return;
        }
        int w1 = width - 1;
        int pos = 0;
        for (int z = 0; z < depth; ++z) {
            System.out.println("Layer " + z);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < w1; ++x) {
                    System.out.print(array[pos++] + Separator2);
                }
                System.out.println(array[pos++]);
            }
        }
    }

    public static void Display(float[] array, int width, int height, int depth, String name, String Separator2) {
        if (width * height * depth != array.length) {
            throw new IllegalArgumentException("width x height x depth != array.length");
        }
        System.out.println(name + ":");
        if (array == null) {
            System.out.println("null");
            return;
        }
        int w1 = width - 1;
        int pos = 0;
        for (int z = 0; z < depth; ++z) {
            System.out.println("Layer " + z);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < w1; ++x) {
                    System.out.print(array[pos++] + Separator2);
                }
                System.out.println(array[pos++]);
            }
        }
    }

    public static void Display(double[] array, int width, int height, int depth, String name, String Separator2) {
        if (width * height * depth != array.length) {
            throw new IllegalArgumentException("width x height x depth != array.length");
        }
        System.out.println(name + ":");
        if (array == null) {
            System.out.println("null");
            return;
        }
        int w1 = width - 1;
        int pos = 0;
        for (int z = 0; z < depth; ++z) {
            System.out.println("Layer " + z);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < w1; ++x) {
                    System.out.print(array[pos++] + Separator2);
                }
                System.out.println(array[pos++]);
            }
        }
    }

    public static void Display(double[] array, int width, int height, int depth, String name, String Separator2, int precision) {
        if (width * height * depth != array.length) {
            throw new IllegalArgumentException("width x height x depth != array.length");
        }
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(precision);
        System.out.println(name + ":");
        if (array == null) {
            System.out.println("null");
            return;
        }
        int w1 = width - 1;
        int pos = 0;
        for (int z = 0; z < depth; ++z) {
            System.out.println("Layer " + z);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < w1; ++x) {
                    System.out.print(df.format(array[pos++]) + Separator2);
                }
                System.out.println(df.format(array[pos++]));
            }
        }
        df = null;
    }

    public static void Display(double[][][] array, String name, String Separator2, int precision) {
        System.out.println(name + ":");
        if (array == null) {
            System.out.println("null");
            return;
        }
        for (int z = 0; z < array.length; ++z) {
            ArrayIO.Display(array[z], "Layer " + z, Separator2, precision);
        }
    }

    public static void Display(int[][][] array, String name, String Separator2) {
        System.out.println(name + ":");
        if (array == null) {
            System.out.println("null");
            return;
        }
        for (int z = 0; z < array.length; ++z) {
            ArrayIO.Display(array[z], "Layer " + z, Separator2);
        }
    }
}

