/*
 * Decompiled with CFR 0.152.
 */
package arrayTiTi;

public class ArrayFeaturesWindow {
    public static int Counter(double[][] source, int minx, int miny, int maxx, int maxy, double ForbiddenValue) {
        int nb = 0;
        for (int y = miny; y <= maxy; ++y) {
            for (int x = minx; x <= maxx; ++x) {
                if (source[y][x] == ForbiddenValue) continue;
                ++nb;
            }
        }
        return nb;
    }

    public static double Integral(double[][] source, int minx, int miny, int maxx, int maxy) {
        return ArrayFeaturesWindow.Sum(source, minx, miny, maxx, maxy);
    }

    public static double Sum(double[][] source, int minx, int miny, int maxx, int maxy) {
        double sum = 0.0;
        for (int y = miny; y <= maxy; ++y) {
            for (int x = minx; x <= maxx; ++x) {
                sum += source[y][x];
            }
        }
        return sum;
    }

    public static double Integral(double[][] source, int minx, int miny, int maxx, int maxy, double ForbiddenValue) {
        return ArrayFeaturesWindow.Sum(source, minx, miny, maxx, maxy, ForbiddenValue);
    }

    public static double Sum(double[][] source, int minx, int miny, int maxx, int maxy, double ForbiddenValue) {
        double sum = 0.0;
        for (int y = miny; y <= maxy; ++y) {
            for (int x = minx; x <= maxx; ++x) {
                if (source[y][x] == ForbiddenValue) continue;
                sum += source[y][x];
            }
        }
        return sum;
    }

    public static double Average(double[][] image, int minx, int miny, int maxx, int maxy) {
        return ArrayFeaturesWindow.Sum(image, minx, miny, maxx, maxy) / (double)(image[0].length * image.length);
    }

    public static double Average(double[][] image, int minx, int miny, int maxx, int maxy, double ForbiddenValue) {
        return ArrayFeaturesWindow.Integral(image, minx, miny, maxx, maxy, ForbiddenValue) / (double)ArrayFeaturesWindow.Counter(image, minx, miny, maxx, maxy, ForbiddenValue);
    }

    public static double StandardDeviation(double[][] image, int minx, int miny, int maxx, int maxy) {
        return ArrayFeaturesWindow.StandardDeviation(image, minx, miny, maxx, maxy, -1.0);
    }

    public static double StandardDeviation(double[][] image, int minx, int miny, int maxx, int maxy, double ForbiddenValue) {
        double sd = 0.0;
        double average = ArrayFeaturesWindow.Average(image, minx, miny, maxx, maxy, ForbiddenValue);
        int size = 0;
        for (int y = miny; y <= maxy; ++y) {
            for (int x = minx; x <= maxx; ++x) {
                if (image[y][x] == ForbiddenValue) continue;
                sd += Math.pow(image[y][x] - average, 2.0);
                ++size;
            }
        }
        return sd / (double)size;
    }

    public static double Variance(double[][] image, int minx, int miny, int maxx, int maxy) {
        return Math.sqrt(ArrayFeaturesWindow.StandardDeviation(image, minx, miny, maxx, maxy));
    }

    public static double Variance(double[][] image, int minx, int miny, int maxx, int maxy, int ForbiddenValue) {
        return Math.sqrt(ArrayFeaturesWindow.StandardDeviation(image, minx, miny, maxx, maxy, ForbiddenValue));
    }

    public static double Skewness(double[][] image, int minx, int miny, int maxx, int maxy) {
        double skewness = 0.0;
        double average = ArrayFeaturesWindow.Average(image, minx, miny, maxx, maxy);
        int size = image[0].length * image.length;
        for (int y = miny; y <= maxy; ++y) {
            for (int x = minx; x <= maxx; ++x) {
                skewness += Math.pow(image[y][x] - average, 3.0);
            }
        }
        return skewness / (double)size / Math.pow(ArrayFeaturesWindow.Variance(image, minx, miny, maxx, maxy), 3.0);
    }

    public static double Kurtosis(double[][] image, int minx, int miny, int maxx, int maxy) {
        double kurtosis = 0.0;
        double average = ArrayFeaturesWindow.Average(image, minx, miny, maxx, maxy);
        int size = image[0].length * image.length;
        for (int y = miny; y <= maxy; ++y) {
            for (int x = minx; x <= maxx; ++x) {
                kurtosis += Math.pow(image[y][x] - average, 4.0);
            }
        }
        return kurtosis / (double)size / Math.pow(ArrayFeaturesWindow.Variance(image, minx, miny, maxx, maxy), 4.0);
    }

    public static double Minimum(double[][] image, int minx, int miny, int maxx, int maxy) {
        double min = image[0][0];
        for (int y = miny; y <= maxy; ++y) {
            for (int x = minx; x <= maxx; ++x) {
                if (!(min > image[y][x])) continue;
                min = image[y][x];
            }
        }
        return min;
    }

    public static double Maximum(double[][] image, int minx, int miny, int maxx, int maxy) {
        double max = image[0][0];
        for (int y = miny; y <= maxy; ++y) {
            for (int x = minx; x <= maxx; ++x) {
                if (!(max < image[y][x])) continue;
                max = image[y][x];
            }
        }
        return max;
    }

    public static double Contrast(double[][] image, int minx, int miny, int maxx, int maxy) {
        return (ArrayFeaturesWindow.Maximum(image, minx, miny, maxx, maxy) - ArrayFeaturesWindow.Minimum(image, minx, miny, maxx, maxy)) / ArrayFeaturesWindow.Average(image, minx, miny, maxx, maxy);
    }

    public static double Michelson(double[][] image, int minx, int miny, int maxx, int maxy) {
        double min = ArrayFeaturesWindow.Minimum(image, minx, miny, maxx, maxy);
        double max = ArrayFeaturesWindow.Maximum(image, minx, miny, maxx, maxy);
        return (max - min) / (max + min);
    }
}

