/*
 * Decompiled with CFR 0.152.
 */
package algoGeo.voronoi;

import algoGeo.delauney.Delauney2D;
import displays.Color;
import java.util.List;
import java.util.Vector;
import mathematics.primitives.pointsTiTi.Point3DI;
import mathematics.primitives.pointsTiTi.PointI;
import utils.times.Chronometer;

public class Voronoi2D {
    private final int TailleListe = 10000;
    private int IndiceCourant = 0;
    private int NombreErreur = 0;
    private int nbTriangle = 0;
    private int[][] Triangle = new int[10000][3];
    private List<PointI> Liste = null;
    private List<PointI> Aretes = null;
    private PointI[] CentreBoule = new Point3DI[10000];
    private Delauney2D delauney = null;
    private int HauteurCadre;
    private int ListeGL = -1;
    private float Taille;
    private boolean Visible = true;
    private boolean affichable = true;
    private Color couleur = null;
    private String Nom = null;

    public Voronoi2D(Delauney2D delauney) {
        this.delauney = delauney;
        this.Liste = delauney.getListe();
    }

    public void ComputeVoronoi(Chronometer Chrono) {
        int marker = 0;
        this.Aretes = null;
        this.Aretes = new Vector<PointI>(113);
        this.IndiceCourant = this.Liste.size();
        this.nbTriangle = this.delauney.getNbTriangle();
        this.Triangle = null;
        this.Triangle = this.delauney.getTriangle();
        if (this.IndiceCourant < 3) {
            return;
        }
        if (Chrono != null) {
            System.out.print("Calcul du diagramme de Voronoi 2D : ");
            marker = Chrono.NewMarker();
        }
        for (int i2 = 0; i2 < this.nbTriangle; ++i2) {
            this.CentreBoule[i2] = this.CalculerCentre(i2);
        }
        this.RelierLesVoisins();
        if (Chrono != null) {
            System.out.println(Chrono.getTimeSinceMarker(marker));
            Chrono.FreeMarker(marker);
        }
    }

    int FindTriangle(int mx, int my) {
        for (int i2 = 0; i2 < this.nbTriangle; ++i2) {
            int y2;
            int x2;
            int y1;
            int x1;
            int y0;
            int x0 = this.Liste.get(this.Triangle[i2][0]).getX();
            if (this.EstDansTriangle(x0, y0 = this.Liste.get(this.Triangle[i2][0]).getY(), x1 = this.Liste.get(this.Triangle[i2][1]).getX(), y1 = this.Liste.get(this.Triangle[i2][1]).getY(), x2 = this.Liste.get(this.Triangle[i2][2]).getX(), y2 = this.Liste.get(this.Triangle[i2][2]).getY(), mx, my) != 1) continue;
            return i2;
        }
        return -1;
    }

    private void Cellules(int NumTriangle, int Sommet1, int Sommet2) {
        int xA = this.Liste.get(Sommet1).getX();
        int yA = this.Liste.get(Sommet1).getY();
        int xB = this.CentreBoule[NumTriangle].getX();
        int yB = this.CentreBoule[NumTriangle].getY();
        int xC = this.Liste.get(Sommet2).getX();
        int yC = this.Liste.get(Sommet2).getY();
        double xM0 = ((double)xA + (double)xB) / 2.0;
        double yM0 = ((double)yA + (double)yB) / 2.0;
        double xM1 = ((double)xB + (double)xC) / 2.0;
        double yM1 = ((double)yB + (double)yC) / 2.0;
        double a0 = ((double)yB - (double)yA) / ((double)xB - (double)xA);
        double a1 = ((double)yC - (double)yB) / ((double)xC - (double)xB);
        double x = 1.0 / (1.0 / a0 - 1.0 / a1) * (xM0 / a0 - xM1 / a1 + yM0 - yM1);
        double y = (xM0 - x) / a0 + yM0;
        if (this.EstDansTriangle(this.Liste.get(this.Triangle[NumTriangle][0]).getX(), this.Liste.get(this.Triangle[NumTriangle][0]).getY(), this.Liste.get(this.Triangle[NumTriangle][1]).getX(), this.Liste.get(this.Triangle[NumTriangle][1]).getY(), this.Liste.get(this.Triangle[NumTriangle][2]).getX(), this.Liste.get(this.Triangle[NumTriangle][2]).getY(), this.CentreBoule[NumTriangle].getX(), this.CentreBoule[NumTriangle].getY()) == 1) {
            this.Aretes.add(new Point3DI(this.CentreBoule[NumTriangle].getX(), this.CentreBoule[NumTriangle].getY()));
            this.Aretes.add(new Point3DI((int)x, (int)y));
        } else if (this.FindTriangle(this.CentreBoule[NumTriangle].getX(), this.CentreBoule[NumTriangle].getY()) == -1) {
            this.Aretes.add(new Point3DI(2 * this.CentreBoule[NumTriangle].getX() - (int)x, 2 * this.CentreBoule[NumTriangle].getY() - (int)y));
            this.Aretes.add(new Point3DI(this.CentreBoule[NumTriangle].getX(), this.CentreBoule[NumTriangle].getY()));
        } else {
            this.Aretes.add(new Point3DI(this.CentreBoule[NumTriangle].getX(), this.CentreBoule[NumTriangle].getY()));
            this.Aretes.add(new Point3DI((int)x, (int)y));
        }
    }

    private void RelierLesVoisins() {
        int[] Sommet = new int[3];
        for (int i2 = 0; i2 < this.nbTriangle; ++i2) {
            int k;
            Sommet[2] = 0;
            Sommet[1] = 0;
            Sommet[0] = 0;
            for (int j = 0; j < this.IndiceCourant; ++j) {
                int NumTriangle;
                if (this.SommetDuTriangle(j, i2) != 0 || (NumTriangle = this.TriangleVoisin(j, i2)) < 0) continue;
                this.Aretes.add(new Point3DI(this.CentreBoule[i2].getX(), this.CentreBoule[i2].getY()));
                this.Aretes.add(new Point3DI(this.CentreBoule[NumTriangle].getX(), this.CentreBoule[NumTriangle].getY()));
                for (k = 0; k < 3; ++k) {
                    if (this.SommetDuTriangle(this.Triangle[i2][k], NumTriangle) != 1) continue;
                    int n = k;
                    Sommet[n] = Sommet[n] + 1;
                }
            }
            for (k = 0; k < 3; ++k) {
                if (Sommet[k] == 1 && Sommet[(k + 1) % 3] == 1 && Sommet[(k + 2) % 3] == 2) {
                    this.Cellules(i2, this.Triangle[i2][k], this.Triangle[i2][(k + 1) % 3]);
                }
                if (Sommet[k] == 1 && Sommet[(k + 1) % 3] == 0) {
                    this.Cellules(i2, this.Triangle[i2][k], this.Triangle[i2][(k + 1) % 3]);
                }
                if (Sommet[k] != 0 || Sommet[(k + 1) % 3] != 1) continue;
                this.Cellules(i2, this.Triangle[i2][k], this.Triangle[i2][(k + 1) % 3]);
            }
            if (Sommet[0] != 0 || Sommet[1] != 0 || Sommet[2] != 0) continue;
            this.Cellules(i2, this.Triangle[i2][0], this.Triangle[i2][1]);
            this.Cellules(i2, this.Triangle[i2][1], this.Triangle[i2][2]);
            this.Cellules(i2, this.Triangle[i2][2], this.Triangle[i2][0]);
        }
    }

    private Point3DI CalculerCentre(int NumTriangle) {
        Point3DI Centre = new Point3DI();
        int xA = this.Liste.get(this.Triangle[NumTriangle][0]).getX();
        int yA = this.Liste.get(this.Triangle[NumTriangle][0]).getY();
        int xB = this.Liste.get(this.Triangle[NumTriangle][1]).getX();
        int yB = this.Liste.get(this.Triangle[NumTriangle][1]).getY();
        int xC = this.Liste.get(this.Triangle[NumTriangle][2]).getX();
        int yC = this.Liste.get(this.Triangle[NumTriangle][2]).getY();
        double xM0 = ((double)xA + (double)xB) / 2.0;
        double yM0 = ((double)yA + (double)yB) / 2.0;
        double xM1 = ((double)xB + (double)xC) / 2.0;
        double yM1 = ((double)yB + (double)yC) / 2.0;
        double a0 = ((double)yB - (double)yA) / ((double)xB - (double)xA);
        double a1 = ((double)yC - (double)yB) / ((double)xC - (double)xB);
        double x = 1.0 / (1.0 / a0 - 1.0 / a1) * (xM0 / a0 - xM1 / a1 + yM0 - yM1);
        double y = (xM0 - x) / a0 + yM0;
        if (xA == xB || xB == xC) {
            System.err.println("Voronoi2D Erreur " + this.NombreErreur++ + " : Pente infinie");
        }
        Centre.setXY((int)(x + 0.5), (int)(y + 0.5));
        return Centre;
    }

    private int Signe(int x) {
        if (x < 0) {
            return -1;
        }
        if (x > 0) {
            return 1;
        }
        return 0;
    }

    private int Angle(int x1, int y1, int x2, int y2) {
        return this.Signe(x1 * y2 - y1 * x2);
    }

    private int EstDansTriangle(int x0, int y0, int x1, int y1, int x2, int y2, int mx, int my) {
        int Signe2;
        int Signe1;
        int Signe0 = this.Angle(x0 - mx, y0 - my, x1 - mx, y1 - my);
        if (Signe0 + (Signe1 = this.Angle(x1 - mx, y1 - my, x2 - mx, y2 - my)) + (Signe2 = this.Angle(x2 - mx, y2 - my, x0 - mx, y0 - my)) == 3 || Signe0 + Signe1 + Signe2 == -3) {
            return 1;
        }
        return 0;
    }

    private int SommetDuTriangle(int Num, int NumTriangle) {
        for (int i2 = 0; i2 < 3; ++i2) {
            if (this.Triangle[NumTriangle][i2] != Num) continue;
            return 1;
        }
        return 0;
    }

    private int TriangleVoisin(int Num, int NumeroTriangle) {
        for (int i2 = 0; i2 < this.nbTriangle; ++i2) {
            if (i2 == NumeroTriangle || this.SommetDuTriangle(Num, i2) != 1) continue;
            int Somme = 0;
            Somme += this.SommetDuTriangle(this.Triangle[i2][0], NumeroTriangle);
            Somme += this.SommetDuTriangle(this.Triangle[i2][1], NumeroTriangle);
            if ((Somme += this.SommetDuTriangle(this.Triangle[i2][2], NumeroTriangle)) != 2) continue;
            return i2;
        }
        return -1;
    }

    public List<PointI> getListe() {
        return this.Liste;
    }

    public int getNbTriangle() {
        return this.nbTriangle;
    }

    public int[][] getTriangle() {
        return this.Triangle;
    }

    public int getListeGL() {
        return this.ListeGL;
    }

    public int getListeGLMouvement() {
        return this.ListeGL;
    }

    public void ForceReDisplay() {
        this.ListeGL = -1;
    }

    public Color getColor() {
        return this.couleur;
    }

    public String getName() {
        return this.Nom;
    }

    public float getDisplaySize() {
        return this.Taille;
    }

    public float getTransparence() {
        return -1.0f;
    }

    public int getDisplayType() {
        return -1;
    }

    public boolean isListeCreee() {
        return this.ListeGL != -1;
    }

    public boolean isVisible() {
        return this.Visible;
    }

    public void setColor(Color couleur) {
        this.couleur = couleur;
    }

    public int getHeightFramework() {
        return this.HauteurCadre;
    }

    public void setHeightFramework(int HeightFramework) {
        this.HauteurCadre = HeightFramework;
    }

    public void setName(String Nom) {
        this.Nom = Nom;
    }

    public void setDisplaySize(float Taille) {
        this.Taille = Taille;
    }

    public void setTransparence(float Transparence) {
    }

    public void setDisplayType(int Type2) {
    }

    public void setVisible(boolean Visible) {
        this.Visible = Visible;
    }

    public boolean isDisplayable() {
        return this.affichable;
    }

    public void setDisplayable(boolean Affichable) {
        this.affichable = Affichable;
        if (Affichable) {
            this.ForceReDisplay();
        }
    }

    public String toString() {
        return this.Nom;
    }
}

