/*
 * Decompiled with CFR 0.152.
 */
package algoGeo.delauney;

import displays.Color;
import java.util.List;
import mathematics.metrics.Euclidian;
import mathematics.primitives.pointsTiTi.Point3DI;
import mathematics.primitives.pointsTiTi.PointI;
import utils.times.Chronometer;

public class Delauney2D {
    private final int TailleListe = 10000;
    private int nbTriangle = 0;
    private int IndiceCourant = 0;
    private int[][] Triangle = new int[10000][3];
    private List<PointI> Liste = null;
    private ERROR[] Erreur = new ERROR[10000];
    private int NombreErreur = 0;
    private int HauteurCadre;
    private int ListeGL = -1;
    private float Taille;
    private boolean Visible = true;
    private boolean affichable = true;
    private Color couleur = null;
    private String Nom = null;

    public void Compute(List<PointI> Liste, Chronometer Chrono) {
        this.Liste = Liste;
        this.Compute(Chrono);
    }

    private void Compute(Chronometer Chrono) {
        int marker = 0;
        if (this.Liste == null || this.Liste.size() < 3) {
            return;
        }
        if (Chrono != null) {
            System.out.print("Calcul de la triangulation de Delauney 2D : ");
            marker = Chrono.NewMarker();
        }
        this.IndiceCourant = this.Liste.size();
        this.Rajouter4Points();
        this.InitialiserTriangle();
        for (int i2 = 0; i2 < this.IndiceCourant - 4; ++i2) {
            this.Trianguler(i2);
        }
        this.Supprimer4Points();
        if (Chrono != null) {
            System.out.println(Chrono.getTimeSinceMarker(marker));
            Chrono.FreeMarker(marker);
        }
    }

    private void InitialiserTriangle() {
        int i2;
        this.Erreur = null;
        this.Erreur = new ERROR[10000];
        for (i2 = 0; i2 < 10000; ++i2) {
            this.Erreur[i2] = new ERROR();
        }
        for (i2 = 0; i2 < 10000; ++i2) {
            for (int j = 0; j < 3; ++j) {
                this.Triangle[i2][j] = -1;
            }
        }
        this.nbTriangle = 0;
        this.Triangle[this.nbTriangle][0] = this.IndiceCourant - 4;
        this.Triangle[this.nbTriangle][1] = this.IndiceCourant - 3;
        this.Triangle[this.nbTriangle++][2] = this.IndiceCourant - 2;
        this.Triangle[this.nbTriangle][0] = this.IndiceCourant - 4;
        this.Triangle[this.nbTriangle][1] = this.IndiceCourant - 2;
        this.Triangle[this.nbTriangle++][2] = this.IndiceCourant - 1;
    }

    private void Rajouter4Points() {
        int yMax;
        int xMin;
        int xMax = xMin = this.Liste.get(0).getX();
        int yMin = yMax = this.Liste.get(0).getY();
        for (int i2 = 1; i2 < this.IndiceCourant; ++i2) {
            if (xMin > this.Liste.get(i2).getX()) {
                xMin = this.Liste.get(i2).getX();
            }
            if (xMax < this.Liste.get(i2).getX()) {
                xMax = this.Liste.get(i2).getX();
            }
            if (yMin > this.Liste.get(i2).getY()) {
                yMin = this.Liste.get(i2).getY();
            }
            if (yMax >= this.Liste.get(i2).getY()) continue;
            yMax = this.Liste.get(i2).getY();
        }
        this.Liste.add(new Point3DI());
        ++this.IndiceCourant;
        this.Liste.get(this.Liste.size() - 1).setXY(xMin - 60 - 5, yMin - 60 - 5);
        this.Liste.add(new Point3DI());
        ++this.IndiceCourant;
        this.Liste.get(this.Liste.size() - 1).setXY(xMin - 60, yMax + 60);
        this.Liste.add(new Point3DI());
        ++this.IndiceCourant;
        this.Liste.get(this.Liste.size() - 1).setXY(xMax + 60 + 2, yMax + 60 + 2);
        this.Liste.add(new Point3DI());
        ++this.IndiceCourant;
        this.Liste.get(this.Liste.size() - 1).setXY(xMax + 60, yMin - 60);
    }

    private void Supprimer4Points() {
        int i2;
        for (i2 = 0; i2 < 4; ++i2) {
            this.Liste.remove(--this.IndiceCourant);
        }
        for (i2 = 0; i2 < this.nbTriangle; ++i2) {
            for (int j = 0; j < 3; ++j) {
                if (this.Triangle[i2][j] < this.IndiceCourant) continue;
                this.SupprimerTriangle(i2);
                j = 3;
                --i2;
            }
        }
    }

    void SupprimerTriangle(int Num) {
        for (int i2 = Num; i2 < this.nbTriangle - 1; ++i2) {
            this.Triangle[i2][0] = this.Triangle[i2 + 1][0];
            this.Triangle[i2][1] = this.Triangle[i2 + 1][1];
            this.Triangle[i2][2] = this.Triangle[i2 + 1][2];
        }
        --this.nbTriangle;
    }

    private int Signe(int x) {
        if (x < 0) {
            return -1;
        }
        if (x > 0) {
            return 1;
        }
        return 0;
    }

    private int Angle(int x1, int y1, int x2, int y2) {
        return this.Signe(x1 * y2 - y1 * x2);
    }

    private int EstDansTriangle(int x0, int y0, int x1, int y1, int x2, int y2, int mx, int my) {
        int Signe2;
        int Signe1;
        int Signe0 = this.Angle(x0 - mx, y0 - my, x1 - mx, y1 - my);
        if (Signe0 + (Signe1 = this.Angle(x1 - mx, y1 - my, x2 - mx, y2 - my)) + (Signe2 = this.Angle(x2 - mx, y2 - my, x0 - mx, y0 - my)) == 3 || Signe0 + Signe1 + Signe2 == -3) {
            return 1;
        }
        return 0;
    }

    private int SommetDuTriangle(int Num, int NumTriangle) {
        for (int i2 = 0; i2 < 3; ++i2) {
            if (this.Triangle[NumTriangle][i2] != Num) continue;
            return 1;
        }
        return 0;
    }

    private int TrouverTriangle(int Num) {
        int mx = this.Liste.get(Num).getX();
        int my = this.Liste.get(Num).getY();
        for (int i2 = 0; i2 < this.nbTriangle; ++i2) {
            int y2;
            int x2;
            int y1;
            int x1;
            int y0;
            int x0 = this.Liste.get(this.Triangle[i2][0]).getX();
            if (this.EstDansTriangle(x0, y0 = this.Liste.get(this.Triangle[i2][0]).getY(), x1 = this.Liste.get(this.Triangle[i2][1]).getX(), y1 = this.Liste.get(this.Triangle[i2][1]).getY(), x2 = this.Liste.get(this.Triangle[i2][2]).getX(), y2 = this.Liste.get(this.Triangle[i2][2]).getY(), mx, my) != 1) continue;
            return i2;
        }
        return -1;
    }

    private int TriangleVoisin(int Num, int NumeroTriangle) {
        for (int i2 = 0; i2 < this.nbTriangle; ++i2) {
            if (i2 == NumeroTriangle || this.SommetDuTriangle(Num, i2) != 1) continue;
            int Somme = 0;
            Somme += this.SommetDuTriangle(this.Triangle[i2][0], NumeroTriangle);
            Somme += this.SommetDuTriangle(this.Triangle[i2][1], NumeroTriangle);
            if ((Somme += this.SommetDuTriangle(this.Triangle[i2][2], NumeroTriangle)) != 2) continue;
            return i2;
        }
        return -1;
    }

    private void CreerTriangle(int Num, int NumTriangle) {
        this.Triangle[this.nbTriangle][0] = this.Triangle[NumTriangle][0];
        this.Triangle[this.nbTriangle][1] = this.Triangle[NumTriangle][1];
        this.Triangle[this.nbTriangle++][2] = Num;
        this.Triangle[this.nbTriangle][0] = this.Triangle[NumTriangle][1];
        this.Triangle[this.nbTriangle][1] = this.Triangle[NumTriangle][2];
        this.Triangle[this.nbTriangle++][2] = Num;
        this.Triangle[this.nbTriangle][0] = this.Triangle[NumTriangle][2];
        this.Triangle[this.nbTriangle][1] = this.Triangle[NumTriangle][0];
        this.Triangle[this.nbTriangle++][2] = Num;
        this.SupprimerTriangle(NumTriangle);
    }

    private Point3DI CalculerCentre(int NumTriangle) {
        Point3DI Centre = new Point3DI();
        int xA = this.Liste.get(this.Triangle[NumTriangle][0]).getX();
        int yA = this.Liste.get(this.Triangle[NumTriangle][0]).getY();
        int xB = this.Liste.get(this.Triangle[NumTriangle][1]).getX();
        int yB = this.Liste.get(this.Triangle[NumTriangle][1]).getY();
        int xC = this.Liste.get(this.Triangle[NumTriangle][2]).getX();
        int yC = this.Liste.get(this.Triangle[NumTriangle][2]).getY();
        double xM0 = ((double)xA + (double)xB) / 2.0;
        double yM0 = ((double)yA + (double)yB) / 2.0;
        double xM1 = ((double)xB + (double)xC) / 2.0;
        double yM1 = ((double)yB + (double)yC) / 2.0;
        double a0 = ((double)yB - (double)yA) / ((double)xB - (double)xA);
        double a1 = ((double)yC - (double)yB) / ((double)xC - (double)xB);
        double x = 1.0 / (1.0 / a0 - 1.0 / a1) * (xM0 / a0 - xM1 / a1 + yM0 - yM1);
        double y = (xM0 - x) / a0 + yM0;
        if (xA == xB || xB == xC) {
            System.err.println("Delauney2D Erreur " + this.NombreErreur++ + " : Pente infinie");
        }
        Centre.setXY((int)(x + 0.5), (int)(y + 0.5));
        return Centre;
    }

    private int VerifierBoule(int NumMax) {
        int nbErreur = 0;
        Point3DI Centre = null;
        Euclidian distances = new Euclidian();
        for (int i2 = this.nbTriangle - 1; i2 >= 0; --i2) {
            Centre = this.CalculerCentre(i2);
            int Rayon = (int)(distances.Distance((double)Centre.getX(), (double)Centre.getY(), 0.0, (double)this.Liste.get(this.Triangle[i2][0]).getX(), (double)this.Liste.get(this.Triangle[i2][0]).getY(), 0.0) + 0.5);
            for (int j = 0; j < this.IndiceCourant; ++j) {
                if (j >= NumMax && j < this.IndiceCourant - 4 || j == this.Triangle[i2][0] || j == this.Triangle[i2][1] || j == this.Triangle[i2][2]) continue;
                int Dist = (int)(distances.Distance((double)Centre.getX(), (double)Centre.getY(), 0.0, (double)this.Liste.get(j).getX(), (double)this.Liste.get(j).getY(), 0.0) + 0.5);
                if (Dist == Rayon) {
                    System.err.println("Deulauney2D Erreur " + this.NombreErreur++ + " : 4 points cocycliques");
                }
                if (Dist > Rayon || this.TriangleVoisin(j, i2) == -1) continue;
                this.Erreur[nbErreur].NumTriangle = i2;
                this.Erreur[nbErreur].NumPoint = j;
                ++nbErreur;
            }
        }
        return nbErreur;
    }

    private void PermuterArete(int Num, int NumTriangle) {
        int NumTriangle2 = -1;
        int Sommet = 0;
        int[] SommetCommun = new int[2];
        NumTriangle2 = this.TriangleVoisin(Num, NumTriangle);
        if (NumTriangle2 == -1) {
            return;
        }
        int j = 0;
        for (int i2 = 0; i2 < 3; ++i2) {
            if (this.SommetDuTriangle(this.Triangle[NumTriangle][i2], NumTriangle2) == 1) {
                SommetCommun[j++] = this.Triangle[NumTriangle][i2];
                continue;
            }
            Sommet = this.Triangle[NumTriangle][i2];
        }
        this.SupprimerTriangle(NumTriangle);
        this.SupprimerTriangle(NumTriangle2);
        this.Triangle[this.nbTriangle][0] = Num;
        this.Triangle[this.nbTriangle][1] = Sommet;
        this.Triangle[this.nbTriangle++][2] = SommetCommun[0];
        this.Triangle[this.nbTriangle][0] = Num;
        this.Triangle[this.nbTriangle][1] = Sommet;
        this.Triangle[this.nbTriangle++][2] = SommetCommun[1];
    }

    private void Trianguler(int Num) {
        int nbErreur;
        int NumeroTriangle = this.TrouverTriangle(Num);
        this.CreerTriangle(Num, NumeroTriangle);
        for (int Limite = 0; (nbErreur = this.VerifierBoule(Num)) > 0 && Limite < 10; ++Limite) {
            this.PermuterArete(this.Erreur[0].NumPoint, this.Erreur[0].NumTriangle);
        }
    }

    public List<PointI> getListe() {
        return this.Liste;
    }

    public int getNbTriangle() {
        return this.nbTriangle;
    }

    public int[][] getTriangle() {
        return this.Triangle;
    }

    public int getListeGL() {
        return this.ListeGL;
    }

    public int getListeGLMouvement() {
        return this.ListeGL;
    }

    public void ForceReDisplay() {
        this.ListeGL = -1;
    }

    public Color getColor() {
        return this.couleur;
    }

    public String getName() {
        return this.Nom;
    }

    public float getDisplaySize() {
        return this.Taille;
    }

    public float getTransparence() {
        return -1.0f;
    }

    public int getDisplayType() {
        return -1;
    }

    public boolean isListeCreee() {
        return this.ListeGL != -1;
    }

    public boolean isVisible() {
        return this.Visible;
    }

    public void setColor(Color couleur) {
        this.couleur = couleur;
    }

    public int getHeightFramework() {
        return this.HauteurCadre;
    }

    public void setHeightFramework(int HeightFramework) {
        this.HauteurCadre = HeightFramework;
    }

    public void setName(String Nom) {
        this.Nom = Nom;
    }

    public void setDisplaySize(float Taille) {
        this.Taille = Taille;
    }

    public void setTransparence(float Transparence) {
    }

    public void setDisplayType(int Type2) {
    }

    public void setVisible(boolean Visible) {
        this.Visible = Visible;
    }

    public boolean isDisplayable() {
        return this.affichable;
    }

    public void setDisplayable(boolean Affichable) {
        this.affichable = Affichable;
        if (Affichable) {
            this.ForceReDisplay();
        }
    }

    public String toString() {
        return this.Nom;
    }

    public class ERROR {
        public int NumTriangle = 0;
        public int NumPoint = 0;
    }
}

