/*
 * Decompiled with CFR 0.152.
 */
package algoGeo.convexhull;

import mathematics.metrics.Euclidian;
import mathematics.primitives.pointsTiTi.Coordinate;
import mathematics.primitives.pointsTiTi.Coordinates;
import mathematics.primitives.pointsTiTi.CoordinatesManager;
import quickhull3d.Point3d;

public class QuickHull3D {
    private final quickhull3d.QuickHull3D hull = new quickhull3d.QuickHull3D();
    private Coordinate[] Vertices = null;
    private int[][] Faces = null;
    private double Volume = -1.0;
    private double Surface = -1.0;

    public void Compute(CoordinatesManager Surface, boolean Triangulate) {
        Point3d[] points = new Point3d[Surface.Size()];
        for (int i2 = 0; i2 < Surface.Size(); ++i2) {
            Coordinates c = Surface.Point(i2);
            points[i2] = new Point3d((double)c.X, (double)c.Y, (double)c.Z);
        }
        this.hull.build(points);
        if (Triangulate) {
            this.hull.triangulate();
        }
        Point3d[] vertices = this.hull.getVertices();
        if (this.Vertices != null) {
            this.Vertices = null;
        }
        this.Vertices = new Coordinate[vertices.length];
        for (int i3 = 0; i3 < vertices.length; ++i3) {
            Point3d pnt = vertices[i3];
            this.Vertices[i3] = new Coordinate(pnt.x, pnt.y, pnt.z);
        }
        vertices = null;
        this.Faces = this.hull.getFaces();
    }

    public void ComputeProperties(Coordinate Barycentre) {
        if (this.Vertices == null || this.Faces == null) {
            throw new IllegalStateException("An envelop must be computed first.");
        }
        Euclidian dist = new Euclidian();
        this.Volume = 0.0;
        this.Surface = 0.0;
        for (int[] vertices : this.Faces) {
            if (vertices.length != 3) {
                throw new IllegalStateException("The surfaces must be triangle. Activate the option while computing the hull.");
            }
            Coordinate p0 = this.Vertices[vertices[0]];
            Coordinate p1 = this.Vertices[vertices[1]];
            Coordinate p2 = this.Vertices[vertices[2]];
            double A = dist.Distance(p0, p1);
            double B = dist.Distance(p1, p2);
            double C = dist.Distance(p2, p0);
            double R = (A + B + C) / 2.0;
            this.Surface += Math.sqrt(R * (R - A) * (R - B) * (R - C));
            double a = Barycentre.X - p0.X;
            double b = Barycentre.Y - p0.Y;
            double c = Barycentre.Z - p0.Z;
            double d = Barycentre.X - p1.X;
            double e = Barycentre.Y - p1.Y;
            double f = Barycentre.Z - p1.Z;
            double g = Barycentre.X - p2.X;
            double h = Barycentre.Y - p2.Y;
            double i2 = Barycentre.Z - p2.Z;
            this.Volume += (a * (e * i2 - h * f) - b * (d * i2 - f * g) + c * (d * h - e * g)) / 6.0;
        }
        this.Volume = Math.abs(this.Volume);
    }

    public void Test(int NB, int Dim) {
        Point3d[] vertices;
        Point3d[] points = new Point3d[NB];
        for (int i2 = 0; i2 < points.length; ++i2) {
            points[i2] = new Point3d((double)((int)(Math.random() * (double)Dim)), (double)((int)(Math.random() * (double)Dim)), (double)((int)(Math.random() * (double)Dim)));
        }
        this.hull.build(points);
        this.hull.triangulate();
        System.out.println("Vertices:");
        for (Point3d pnt : vertices = this.hull.getVertices()) {
            System.out.println(pnt.x + " " + pnt.y + " " + pnt.z);
        }
        System.out.println("Faces:");
        int[][] faceIndices = this.hull.getFaces();
        for (int i3 = 0; i3 < vertices.length; ++i3) {
            for (int k = 0; k < faceIndices[i3].length; ++k) {
                System.out.print(faceIndices[i3][k] + " ");
            }
            System.out.println("");
        }
    }

    public double Surface() {
        return this.Surface;
    }

    public double Volume() {
        return this.Volume;
    }

    public Coordinate[] Vertices() {
        return this.Vertices;
    }

    public int[][] Faces() {
        return this.Faces;
    }
}

