/*
 * Decompiled with CFR 0.152.
 */
package algoGeo.convexhull;

import imageTiTi.ImageArithmetic;
import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import utils.memory.Allocator;

public class PseudoConvexHull {
    private final Allocator allocator = Allocator.Instance();
    private BufferedImage tmpMap;
    private BufferedImage Map;
    private PCHthread[] threads = null;
    private int nbFreeThreads = 0;

    public void Kill() {
        if (this.threads != null) {
            for (int i2 = 0; i2 < this.threads.length; ++i2) {
                this.threads[i2].Kill();
                this.threads[i2] = null;
            }
        }
        this.threads = null;
        this.tmpMap = this.allocator.Release(this.tmpMap);
        this.Map = this.allocator.Release(this.Map);
    }

    public void Compute(BufferedImage source, BufferedImage targets, int nbCPU) {
        if (this.Map != null && !ImageTools.areDimensionsEqual((BufferedImage)this.Map, (BufferedImage)source)) {
            this.tmpMap = this.allocator.Release(this.tmpMap);
            this.Map = this.allocator.Release(this.Map);
        }
        if (this.Map == null) {
            this.tmpMap = ImageNew.Same((BufferedImage)source, (int)10);
            this.Map = ImageNew.Same((BufferedImage)source, (int)10);
        }
        int width = source.getRaster().getWidth();
        int height = source.getRaster().getHeight();
        int length = width * height;
        byte[] bbtmp = ((DataBufferByte)this.tmpMap.getRaster().getDataBuffer()).getData();
        block0 : switch (source.getType()) {
            case 10: {
                int pos;
                int y;
                int x;
                int step;
                int i2;
                int pos2;
                int end;
                int start;
                byte[] bbdsrc = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                ImageOperations.Fill((BufferedImage)this.tmpMap, (int)1);
                for (int row = 0; row < height; ++row) {
                    start = row * width;
                    end = start + width;
                    pos2 = start;
                    while (pos2 < end && bbdsrc[pos2] == 0) {
                        bbtmp[pos2++] = 0;
                    }
                    if (pos2 >= end) continue;
                    pos2 = end - 1;
                    while (start <= pos2 && bbdsrc[pos2] == 0) {
                        bbtmp[pos2--] = 0;
                    }
                }
                ImageNew.Copy((BufferedImage)this.tmpMap, (BufferedImage)this.Map);
                ImageOperations.Fill((BufferedImage)this.tmpMap, (int)1);
                for (int col = 0; col < width; ++col) {
                    start = col;
                    end = start + length;
                    for (pos2 = start; pos2 < end && bbdsrc[pos2] == 0; pos2 += width) {
                        bbtmp[pos2] = 0;
                    }
                    if (pos2 >= end) continue;
                    for (pos2 = end - width; start <= pos2 && bbdsrc[pos2] == 0; pos2 -= width) {
                        bbtmp[pos2] = 0;
                    }
                }
                ImageArithmetic.Add(this.Map, this.tmpMap, this.Map);
                ImageOperations.Fill((BufferedImage)this.tmpMap, (int)1);
                for (i2 = 0; i2 < height; ++i2) {
                    step = width - 1;
                    x = 0;
                    y = i2;
                    pos = y * width;
                    while (0 <= x && x < width && 0 <= y && y < height && bbdsrc[pos] == 0) {
                        bbtmp[pos] = 0;
                        ++x;
                        --y;
                        pos -= step;
                    }
                    x = width - 1;
                    y = i2;
                    pos = x + y * width;
                    while (0 <= x && x < width && 0 <= y && y < height && bbdsrc[pos] == 0 && bbtmp[pos] != 0) {
                        bbtmp[pos] = 0;
                        --x;
                        ++y;
                        pos += step;
                    }
                }
                for (i2 = 1; i2 < width; ++i2) {
                    step = width - 1;
                    x = i2;
                    y = 0;
                    pos = x;
                    while (0 <= x && x < width && 0 <= y && y < height && bbdsrc[pos] == 0 && bbtmp[pos] != 0) {
                        bbtmp[pos] = 0;
                        --x;
                        ++y;
                        pos += step;
                    }
                    x = i2;
                    y = height - 1;
                    pos = x + y * width;
                    while (0 <= x && x < width && 0 <= y && y < height && bbdsrc[pos] == 0 && bbtmp[pos] != 0) {
                        bbtmp[pos] = 0;
                        ++x;
                        --y;
                        pos -= step;
                    }
                }
                ImageArithmetic.Add(this.Map, this.tmpMap, this.Map);
                ImageOperations.Fill((BufferedImage)this.tmpMap, (int)1);
                for (i2 = 0; i2 < height; ++i2) {
                    step = width + 1;
                    x = 0;
                    y = i2;
                    pos = y * width;
                    while (0 <= x && x < width && 0 <= y && y < height && bbdsrc[pos] == 0) {
                        bbtmp[pos] = 0;
                        ++x;
                        ++y;
                        pos += step;
                    }
                    x = width - 1;
                    y = i2;
                    pos = x + y * width;
                    while (0 <= x && x < width && 0 <= y && y < height && bbdsrc[pos] == 0 && bbtmp[pos] != 0) {
                        bbtmp[pos] = 0;
                        --x;
                        --y;
                        pos -= step;
                    }
                }
                for (i2 = 1; i2 < width; ++i2) {
                    step = width + 1;
                    x = i2;
                    y = 0;
                    pos = x;
                    while (0 <= x && x < width && 0 <= y && y < height && bbdsrc[pos] == 0 && bbtmp[pos] != 0) {
                        bbtmp[pos] = 0;
                        ++x;
                        ++y;
                        pos += step;
                    }
                    x = i2;
                    y = height - 1;
                    pos = x + y * width;
                    while (0 <= x && x < width && 0 <= y && y < height && bbdsrc[pos] == 0 && bbtmp[pos] != 0) {
                        bbtmp[pos] = 0;
                        --x;
                        --y;
                        pos -= step;
                    }
                }
                ImageArithmetic.Add(this.Map, this.tmpMap, this.Map);
                break;
            }
            case 0: {
                switch (source.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        int pos;
                        int y;
                        int x;
                        int step;
                        int i3;
                        int pos3;
                        int end;
                        int start;
                        int[] ibdsrc = ((DataBufferInt)source.getRaster().getDataBuffer()).getData();
                        ImageOperations.Fill((BufferedImage)this.tmpMap, (int)1);
                        for (int row = 0; row < height; ++row) {
                            start = row * width;
                            end = start + width;
                            pos3 = start;
                            while (pos3 < end && ibdsrc[pos3] == 0) {
                                bbtmp[pos3++] = 0;
                            }
                            if (pos3 >= end) continue;
                            pos3 = end - 1;
                            while (start <= pos3 && ibdsrc[pos3] == 0) {
                                bbtmp[pos3--] = 0;
                            }
                        }
                        ImageNew.Copy((BufferedImage)this.tmpMap, (BufferedImage)this.Map);
                        ImageOperations.Fill((BufferedImage)this.tmpMap, (int)1);
                        for (int col = 0; col < width; ++col) {
                            start = col;
                            end = start + length;
                            for (pos3 = start; pos3 < end && ibdsrc[pos3] == 0; pos3 += width) {
                                bbtmp[pos3] = 0;
                            }
                            if (pos3 >= end) continue;
                            for (pos3 = end - width; start <= pos3 && ibdsrc[pos3] == 0; pos3 -= width) {
                                bbtmp[pos3] = 0;
                            }
                        }
                        ImageArithmetic.Add(this.Map, this.tmpMap, this.Map);
                        ImageOperations.Fill((BufferedImage)this.tmpMap, (int)1);
                        for (i3 = 0; i3 < height; ++i3) {
                            step = width - 1;
                            x = 0;
                            y = i3;
                            pos = y * width;
                            while (0 <= x && x < width && 0 <= y && y < height && ibdsrc[pos] == 0) {
                                bbtmp[pos] = 0;
                                ++x;
                                --y;
                                pos -= step;
                            }
                            x = width - 1;
                            y = i3;
                            pos = x + y * width;
                            while (0 <= x && x < width && 0 <= y && y < height && ibdsrc[pos] == 0 && bbtmp[pos] != 0) {
                                bbtmp[pos] = 0;
                                --x;
                                ++y;
                                pos += step;
                            }
                        }
                        for (i3 = 1; i3 < width; ++i3) {
                            step = width - 1;
                            x = i3;
                            y = 0;
                            pos = x;
                            while (0 <= x && x < width && 0 <= y && y < height && ibdsrc[pos] == 0 && bbtmp[pos] != 0) {
                                bbtmp[pos] = 0;
                                --x;
                                ++y;
                                pos += step;
                            }
                            x = i3;
                            y = height - 1;
                            pos = x + y * width;
                            while (0 <= x && x < width && 0 <= y && y < height && ibdsrc[pos] == 0 && bbtmp[pos] != 0) {
                                bbtmp[pos] = 0;
                                ++x;
                                --y;
                                pos -= step;
                            }
                        }
                        ImageArithmetic.Add(this.Map, this.tmpMap, this.Map);
                        ImageOperations.Fill((BufferedImage)this.tmpMap, (int)1);
                        for (i3 = 0; i3 < height; ++i3) {
                            step = width + 1;
                            x = 0;
                            y = i3;
                            pos = y * width;
                            while (0 <= x && x < width && 0 <= y && y < height && ibdsrc[pos] == 0) {
                                bbtmp[pos] = 0;
                                ++x;
                                ++y;
                                pos += step;
                            }
                            x = width - 1;
                            y = i3;
                            pos = x + y * width;
                            while (0 <= x && x < width && 0 <= y && y < height && ibdsrc[pos] == 0 && bbtmp[pos] != 0) {
                                bbtmp[pos] = 0;
                                --x;
                                --y;
                                pos -= step;
                            }
                        }
                        for (i3 = 1; i3 < width; ++i3) {
                            step = width + 1;
                            x = i3;
                            y = 0;
                            pos = x;
                            while (0 <= x && x < width && 0 <= y && y < height && ibdsrc[pos] == 0 && bbtmp[pos] != 0) {
                                bbtmp[pos] = 0;
                                ++x;
                                ++y;
                                pos += step;
                            }
                            x = i3;
                            y = height - 1;
                            pos = x + y * width;
                            while (0 <= x && x < width && 0 <= y && y < height && ibdsrc[pos] == 0 && bbtmp[pos] != 0) {
                                bbtmp[pos] = 0;
                                --x;
                                --y;
                                pos -= step;
                            }
                        }
                        ImageArithmetic.Add(this.Map, this.tmpMap, this.Map);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet)");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet)");
            }
        }
        if (targets != null) {
            this.Bombing(source, targets, nbCPU);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void Bombing(BufferedImage source, BufferedImage targets, int nbCPU) {
        Object object;
        int i2;
        if (!ImageTools.areDimensionsEqual((BufferedImage)source, (BufferedImage)targets)) {
            throw new IllegalArgumentException("Images have different dimensions");
        }
        int width = targets.getRaster().getWidth();
        int height = targets.getRaster().getHeight();
        if (this.threads == null || this.threads.length == nbCPU) {
            this.nbFreeThreads = 0;
            this.threads = null;
            this.threads = new PCHthread[nbCPU];
            for (int i3 = 0; i3 < nbCPU; ++i3) {
                this.threads[i3] = new PCHthread();
                this.threads[i3].start();
            }
        }
        PseudoConvexHull i3 = this;
        synchronized (i3) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        ImageOperations.Fill((BufferedImage)this.tmpMap, (int)1);
        int step = height / nbCPU;
        this.nbFreeThreads = 0;
        for (i2 = 0; i2 < nbCPU - 1; ++i2) {
            this.threads[i2].setConditions(source, targets, i2 * step, (i2 + 1) * step);
            object = this.threads[i2].lock;
            synchronized (object) {
                this.threads[i2].lock.notify();
                continue;
            }
        }
        this.threads[i2].setConditions(source, targets, i2 * step, height);
        object = this.threads[i2].lock;
        synchronized (object) {
            this.threads[i2].lock.notify();
        }
        object = this;
        synchronized (object) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        ImageArithmetic.Add(this.Map, this.tmpMap, this.Map);
    }

    public BufferedImage Hull() {
        return this.Map;
    }

    protected synchronized void addFreeThread() {
        ++this.nbFreeThreads;
        this.notify();
    }

    private class PCHthread
    extends Thread {
        private int miny;
        private int maxy;
        private BufferedImage source;
        private BufferedImage targets;
        public final Object lock = new Object();
        private boolean Kill = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.Kill = true;
            this.targets = null;
            this.source = null;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(BufferedImage source, BufferedImage targets, int miny, int maxy) {
            this.source = source;
            this.targets = targets;
            this.miny = miny;
            this.maxy = maxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block12: while (true) {
                var1_2 = this.lock;
                synchronized (var1_2) {
                    try {
                        PseudoConvexHull.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                width = this.targets.getRaster().getWidth();
                height = this.targets.getRaster().getHeight();
                bbmap = ((DataBufferByte)PseudoConvexHull.this.tmpMap.getRaster().getDataBuffer()).getData();
                bbtar = ((DataBufferByte)this.targets.getRaster().getDataBuffer()).getData();
                switch (this.source.getType()) {
                    case 10: {
                        bbsrc = ((DataBufferByte)this.source.getRaster().getDataBuffer()).getData();
                        y = this.miny;
                        p = y * width;
                        while (true) {
                            if (y >= this.maxy) continue block12;
                            x = 0;
                            while (x < width) {
                                if (bbtar[p] != 0) {
                                    bbmap[p] = 0;
                                    yy = y;
                                    pos = p + 1;
                                    for (xx = x + 1; 0 <= xx && xx < width && 0 <= yy && yy < height && bbsrc[pos] == 0; ++xx) {
                                        bbmap[pos] = 0;
                                        ++pos;
                                    }
                                    yy = y;
                                    pos = p - 1;
                                    for (xx = x - 1; 0 <= xx && xx < width && 0 <= yy && yy < height && bbsrc[pos] == 0; --xx) {
                                        bbmap[pos] = 0;
                                        --pos;
                                    }
                                    xx = x;
                                    pos = p + width;
                                    for (yy = y + 1; 0 <= xx && xx < width && 0 <= yy && yy < height && bbsrc[pos] == 0; ++yy) {
                                        bbmap[pos] = 0;
                                        pos += width;
                                    }
                                    xx = x;
                                    pos = p - width;
                                    for (yy = y - 1; 0 <= xx && xx < width && 0 <= yy && yy < height && bbsrc[pos] == 0; --yy) {
                                        bbmap[pos] = 0;
                                        pos -= width;
                                    }
                                    xx = x + 1;
                                    pos = p - width + 1;
                                    for (yy = y - 1; 0 <= xx && xx < width && 0 <= yy && yy < height && bbsrc[pos] == 0; ++xx, --yy) {
                                        bbmap[pos] = 0;
                                        pos += -width + 1;
                                    }
                                    xx = x - 1;
                                    pos = p + width - 1;
                                    for (yy = y + 1; 0 <= xx && xx < width && 0 <= yy && yy < height && bbsrc[pos] == 0; --xx, ++yy) {
                                        bbmap[pos] = 0;
                                        pos += width - 1;
                                    }
                                    xx = x + 1;
                                    pos = p + width + 1;
                                    for (yy = y + 1; 0 <= xx && xx < width && 0 <= yy && yy < height && bbsrc[pos] == 0; ++xx, ++yy) {
                                        bbmap[pos] = 0;
                                        pos += width + 1;
                                    }
                                    xx = x - 1;
                                    pos = p - (width + 1);
                                    for (yy = y - 1; 0 <= xx && xx < width && 0 <= yy && yy < height && bbsrc[pos] == 0; --xx, --yy) {
                                        bbmap[pos] = 0;
                                        pos -= width + 1;
                                    }
                                }
                                ++x;
                                ++p;
                            }
                            ++y;
                        }
                    }
                    case 0: {
                        switch (this.source.getRaster().getDataBuffer().getDataType()) {
                            case 3: {
                                ibsrc = ((DataBufferInt)this.source.getRaster().getDataBuffer()).getData();
                                y = 0;
                                p = 0;
                                while (true) {
                                    if (y < height) ** break;
                                    continue block12;
                                    x = 0;
                                    while (x < width) {
                                        if (bbtar[p] != 0) {
                                            bbmap[p] = 0;
                                            yy = y;
                                            pos = p + 1;
                                            for (xx = x + 1; 0 <= xx && xx < width && 0 <= yy && yy < height && ibsrc[pos] == 0; ++xx) {
                                                bbmap[pos] = 0;
                                                ++pos;
                                            }
                                            yy = y;
                                            pos = p - 1;
                                            for (xx = x - 1; 0 <= xx && xx < width && 0 <= yy && yy < height && ibsrc[pos] == 0; --xx) {
                                                bbmap[pos] = 0;
                                                --pos;
                                            }
                                            xx = x;
                                            pos = p + width;
                                            for (yy = y + 1; 0 <= xx && xx < width && 0 <= yy && yy < height && ibsrc[pos] == 0; ++yy) {
                                                bbmap[pos] = 0;
                                                pos += width;
                                            }
                                            xx = x;
                                            pos = p - width;
                                            for (yy = y - 1; 0 <= xx && xx < width && 0 <= yy && yy < height && ibsrc[pos] == 0; --yy) {
                                                bbmap[pos] = 0;
                                                pos -= width;
                                            }
                                            xx = x + 1;
                                            pos = p - width + 1;
                                            for (yy = y - 1; 0 <= xx && xx < width && 0 <= yy && yy < height && ibsrc[pos] == 0; ++xx, --yy) {
                                                bbmap[pos] = 0;
                                                pos += -width + 1;
                                            }
                                            xx = x - 1;
                                            pos = p + width - 1;
                                            for (yy = y + 1; 0 <= xx && xx < width && 0 <= yy && yy < height && ibsrc[pos] == 0; --xx, ++yy) {
                                                bbmap[pos] = 0;
                                                pos += width - 1;
                                            }
                                            xx = x + 1;
                                            pos = p + width + 1;
                                            for (yy = y + 1; 0 <= xx && xx < width && 0 <= yy && yy < height && ibsrc[pos] == 0; ++xx, ++yy) {
                                                bbmap[pos] = 0;
                                                pos += width + 1;
                                            }
                                            xx = x - 1;
                                            pos = p - (width + 1);
                                            for (yy = y - 1; 0 <= xx && xx < width && 0 <= yy && yy < height && ibsrc[pos] == 0; --xx, --yy) {
                                                bbmap[pos] = 0;
                                                pos -= width + 1;
                                            }
                                        }
                                        ++x;
                                        ++p;
                                    }
                                    ++y;
                                }
                            }
                            default: {
                                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
                            }
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("Image type not supported (yet).");
                    }
                }
                break;
            }
        }
    }
}

