/*
 * Decompiled with CFR 0.152.
 */
package algoGeo.convexhull;

import algoGeo.convexhull.AklToussaint;
import algoGeo.convexhull.ConvexHull;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import mathematics.Bresenham;
import mathematics.primitives.pointsTiTi.Coordinates;
import measures.BasicMeasures;
import measures.cclh.ConnectedComponentLabeling;
import measures.cclh.UnionFindCcl;
import processing.filters.Invert;
import utils.pointers.IntPointer;

public class JShull
implements ConvexHull {
    private int Ncce = -1;
    private int Surface = -1;
    private int Perimeter = -1;
    private BufferedImage Differences = null;
    private BufferedImage ConvexShape = null;
    private ConnectedComponentLabeling ccl = new UnionFindCcl();
    private Invert invert = new Invert();
    private List<Coordinates> Hull = new LinkedList<Coordinates>();

    @Override
    public void Compute(BufferedImage image, AklToussaint akl) {
        BasicMeasures bb = new BasicMeasures();
        bb.Compute(image, true);
        this.Compute(bb.Boundary.Points(), akl);
    }

    @Override
    public void Compute(List<Coordinates> ListIn, AklToussaint akl) {
        int i2;
        int[] BoxIndexes = new int[8];
        Coordinates Pt2 = null;
        Node[] Box2 = new Node[8];
        Node elt = null;
        Node prev = null;
        Node nextn = null;
        IntPointer next = new IntPointer(0);
        if (ListIn.size() < 3) {
            return;
        }
        int npol = this.Gets_Limiting_Convex_Box(ListIn, BoxIndexes);
        for (i2 = 0; i2 < npol; ++i2) {
            Box2[i2] = prev = this.Adds_Node(prev, ListIn.get(BoxIndexes[i2]));
        }
        Box2[0].prev = Box2[npol - 1];
        Box2[npol - 1].next = Box2[0];
        int M = npol;
        if (M < ListIn.size()) {
            for (i2 = 0; i2 < ListIn.size(); ++i2) {
                Pt2 = ListIn.get(i2);
                int imin = this.Finds_Closest_Initial_Segment(Pt2, Box2, npol, next);
                if (imin < 0 || (prev = this.Finds_Closest_Segment(Pt2, Box2[imin], Box2[next.value])) == null) continue;
                elt = this.Adds_Node(prev, Pt2);
                this.Checks_Backwards_ClockWise(elt, Box2[imin]);
                this.Checks_Forwards_ClockWise(elt, Box2[next.value]);
            }
        }
        prev = null;
        elt = Box2[0];
        M = 0;
        while (elt != prev) {
            if (prev == null) {
                prev = elt;
            }
            ++M;
            elt = elt.next;
        }
        this.Hull.clear();
        prev = null;
        elt = Box2[0];
        i2 = 0;
        while (elt != prev) {
            if (prev == null) {
                prev = elt;
            }
            this.Hull.add(elt.Adr);
            nextn = elt.next;
            elt = null;
            elt = nextn;
        }
    }

    private void Finds_Extreme_Values(List<Coordinates> Pts, IntPointer iminy, IntPointer imaxy, IntPointer iminx, IntPointer imaxx, IntPointer iminxy, IntPointer imaxxy, IntPointer iminxy1, IntPointer imaxxy1) {
        int dmin1 = Integer.MAX_VALUE;
        int dmax1 = Integer.MIN_VALUE;
        int dmin2 = Integer.MAX_VALUE;
        int dmax2 = Integer.MIN_VALUE;
        int vminy = Pts.get((int)iminy.value).Y;
        int vmaxy = Pts.get((int)imaxy.value).Y;
        int vminx = Pts.get((int)iminx.value).X;
        int vmaxx = Pts.get((int)imaxx.value).X;
        int NPts = Pts.size();
        Coordinates c = Pts.get(0);
        dmin1 = c.X + c.Y;
        dmin2 = c.X - c.Y;
        dmax1 = dmin1;
        dmax2 = dmin2;
        for (int i2 = 1; i2 < NPts; ++i2) {
            int d;
            c = Pts.get(i2);
            if (c.Y < vminy) {
                vminy = c.Y;
                iminy.value = i2;
            }
            if (c.X > vmaxx) {
                vmaxx = c.X;
                imaxx.value = i2;
            }
            if (c.X < vminx) {
                vminx = c.X;
                iminx.value = i2;
            }
            if (c.Y > vmaxy) {
                vmaxy = c.Y;
                imaxy.value = i2;
            }
            if ((d = c.X + c.Y) < dmin1) {
                iminxy.value = i2;
                dmin1 = d;
            }
            if (d > dmax1) {
                imaxxy.value = i2;
                dmax1 = d;
            }
            if ((d = c.X - c.Y) < dmin2) {
                iminxy1.value = i2;
                dmin2 = d;
            }
            if (d <= dmax2) continue;
            imaxxy1.value = i2;
            dmax2 = d;
        }
    }

    private void Stores_In_Box(List<Coordinates> Pts, int iminy, int imaxy, int iminx, int imaxx, int iminxy, int imaxxy, int iminxy1, int imaxxy1, int[] IBox) {
        int nr = 0;
        int nl = 0;
        Arrays.fill(IBox, -1);
        IBox[0] = iminy;
        IBox[4] = imaxy;
        if (imaxx != iminy && imaxx != iminy) {
            IBox[1] = imaxx;
            nr = 1;
        }
        if (iminx != iminy && iminx != iminy) {
            IBox[5] = iminx;
            nl = 1;
        }
        if (imaxxy != iminy && imaxxy != imaxy && imaxxy != imaxx) {
            if (Pts.get((int)imaxxy).Y > Pts.get((int)IBox[nr]).Y) {
                IBox[nr + 1] = imaxxy;
                ++nr;
            } else if (nr == 1) {
                IBox[nr + 1] = IBox[nr];
                IBox[nr] = imaxxy;
                ++nr;
            }
        }
        if (iminxy != iminy && iminxy != imaxy && iminxy != iminx) {
            if (Pts.get((int)iminxy).Y < Pts.get((int)IBox[nl + 4]).Y) {
                IBox[nl + 5] = iminxy;
                ++nl;
            } else if (nl == 1) {
                IBox[nl + 5] = IBox[nl + 4];
                IBox[nl + 4] = iminxy;
                ++nl;
            }
        }
        if (imaxxy1 != iminy && imaxxy1 != imaxy && imaxxy1 != imaxx && imaxxy1 != imaxxy) {
            if (Pts.get((int)imaxxy1).Y > Pts.get((int)IBox[nr]).Y) {
                IBox[nr + 1] = imaxxy1;
            } else {
                IBox[nr + 1] = IBox[nr];
                if (nr == 2 && Pts.get((int)imaxxy1).Y < Pts.get((int)IBox[1]).Y) {
                    IBox[2] = IBox[1];
                    nr = 1;
                }
                IBox[nr] = imaxxy1;
            }
        }
        if (iminxy1 != iminy && iminxy1 != imaxy && iminxy1 != imaxx && iminxy1 != imaxxy) {
            if (Pts.get((int)iminxy1).Y < Pts.get((int)IBox[nl + 4]).Y) {
                IBox[nl + 5] = iminxy1;
            } else {
                IBox[nl + 5] = IBox[nl + 4];
                if (nl == 2 && Pts.get((int)iminxy1).Y > Pts.get((int)IBox[5]).Y) {
                    IBox[6] = IBox[5];
                    nl = 1;
                }
                IBox[nl + 4] = iminxy1;
            }
        }
    }

    private int Gets_Limiting_Convex_Box(List<Coordinates> Pts, int[] IBox) {
        IntPointer iminy = new IntPointer(0);
        IntPointer imaxy = new IntPointer(0);
        IntPointer iminx = new IntPointer(0);
        IntPointer imaxx = new IntPointer(0);
        IntPointer iminxy = new IntPointer(0);
        IntPointer imaxxy = new IntPointer(0);
        IntPointer iminxy1 = new IntPointer(0);
        IntPointer imaxxy1 = new IntPointer(0);
        this.Finds_Extreme_Values(Pts, iminy, imaxy, iminx, imaxx, iminxy, imaxxy, iminxy1, imaxxy1);
        this.Stores_In_Box(Pts, iminy.value, imaxy.value, iminx.value, imaxx.value, iminxy.value, imaxxy.value, iminxy1.value, imaxxy1.value, IBox);
        int j = 1;
        for (int i2 = 1; i2 < 8; ++i2) {
            if (IBox[i2] < 0 || IBox[i2] == IBox[j - 1]) continue;
            IBox[j] = IBox[i2];
            ++j;
        }
        return j;
    }

    private double Distance_PointSegment(Coordinates Pt2, Coordinates Pt1, Coordinates Pt22) {
        int sx = Pt22.X - Pt1.X;
        int ux = Pt2.X - Pt1.X;
        int sy = Pt22.Y - Pt1.Y;
        int uy = Pt2.Y - Pt1.Y;
        int dp = sx * ux + sy * uy;
        if (dp < 0) {
            return Double.MAX_VALUE;
        }
        int sn2 = sx * sx + sy * sy;
        if (dp > sn2) {
            return Double.MAX_VALUE;
        }
        if (sn2 == 0) {
            return Double.MAX_VALUE;
        }
        double ah2 = (double)(dp * dp) / (double)sn2;
        int un2 = ux * ux + uy * uy;
        return Math.abs((double)un2 - ah2);
    }

    private double Is_Left(Coordinates P0, Coordinates P1, Coordinates P2) {
        return (P1.X - P0.X) * (P2.Y - P0.Y) - (P2.X - P0.X) * (P1.Y - P0.Y);
    }

    private int Finds_Closest_Initial_Segment(Coordinates Pt2, Node[] Box2, int NIndex, IntPointer Next) {
        int imin = -1;
        for (int i2 = 0; i2 < NIndex && Box2[i2].Adr != Pt2; ++i2) {
            int i0 = i2 != NIndex - 1 ? i2 + 1 : 0;
            if (!(this.Is_Left(Box2[i2].Adr, Box2[i0].Adr, Pt2) < 0.0)) continue;
            Next.value = i0;
            imin = i2;
            break;
        }
        return imin;
    }

    private Node Finds_Closest_Segment(Coordinates Pt2, Node Lowest, Node Highest) {
        boolean pass = false;
        Node elt = null;
        Node next = null;
        Node result = null;
        double dmin = Double.MAX_VALUE;
        elt = Lowest;
        while (elt != Highest) {
            next = elt.next;
            if (0.0 <= this.Is_Left(elt.Adr, next.Adr, Pt2)) {
                if (pass) break;
                elt = next;
                continue;
            }
            double d = this.Distance_PointSegment(Pt2, elt.Adr, next.Adr);
            if (d < dmin) {
                pass = true;
                result = elt;
                dmin = d;
            }
            elt = next;
        }
        if (!pass) {
            result = null;
        }
        return result;
    }

    private Node Adds_Node(Node Previous, Coordinates Adr) {
        Node elt = new Node();
        if (elt != null) {
            if (Previous != null) {
                elt.next = Previous.next;
                if (elt.next != null) {
                    elt.next.prev = elt;
                }
                Previous.next = elt;
            } else {
                elt.next = null;
            }
            elt.prev = Previous;
            elt.Adr = Adr;
        }
        return elt;
    }

    private void Deletes_Node(Node elt) {
        elt.prev.next = elt.next;
        elt.next.prev = elt.prev;
        elt = null;
    }

    private void Checks_Backwards_ClockWise(Node Start, Node LowLimit) {
        Node elt = null;
        Node prev = null;
        elt = Start.prev;
        while (elt != LowLimit) {
            prev = elt.prev;
            if (this.Is_Left(prev.Adr, Start.Adr, elt.Adr) < 0.0) break;
            this.Deletes_Node(elt);
            elt = prev;
        }
    }

    private void Checks_Forwards_ClockWise(Node Start, Node HighLimit) {
        Node elt = null;
        Node next = null;
        elt = Start.next;
        while (elt != HighLimit) {
            next = elt.next;
            if (this.Is_Left(Start.Adr, next.Adr, elt.Adr) < 0.0) break;
            this.Deletes_Node(elt);
            elt = next;
        }
    }

    @Override
    public void ComputeProperties(BufferedImage Original, int Threshold) {
        int j;
        int i2;
        if (ImageTools.isColored((BufferedImage)Original)) {
            throw new IllegalArgumentException("Colored images not supported.");
        }
        int largeur = Original.getWidth();
        int hauteur = Original.getHeight();
        this.ConvexShape = null;
        this.Differences = null;
        this.Differences = new BufferedImage(largeur, hauteur, 10);
        WritableRaster wrd = this.Differences.getRaster();
        this.ConvexShape = new BufferedImage(largeur, hauteur, 12);
        WritableRaster wrcs = this.ConvexShape.getRaster();
        if (this.Hull.isEmpty()) {
            this.Perimeter = 0;
            this.Surface = 0;
            this.Ncce = 0;
            this.ConvexShape = null;
            this.ConvexShape = ImageNew.Clone((BufferedImage)Original);
            return;
        }
        for (i2 = 0; i2 < this.Hull.size() - 1; ++i2) {
            wrd.setSample(this.Hull.get((int)i2).X, this.Hull.get((int)i2).Y, 0, 255);
        }
        for (i2 = 0; i2 < this.Hull.size() - 1; ++i2) {
            Bresenham.Draw((BufferedImage)this.Differences, (int)this.Hull.get((int)i2).X, (int)this.Hull.get((int)i2).Y, (int)this.Hull.get((int)(i2 + 1)).X, (int)this.Hull.get((int)(i2 + 1)).Y, (int)125);
        }
        Bresenham.Draw((BufferedImage)this.Differences, (int)this.Hull.get((int)(this.Hull.size() - 1)).X, (int)this.Hull.get((int)(this.Hull.size() - 1)).Y, (int)this.Hull.get((int)0).X, (int)this.Hull.get((int)0).Y, (int)125);
        for (i2 = 0; i2 < hauteur; ++i2) {
            for (j = 0; j < largeur; ++j) {
                if (wrd.getSample(j, i2, 0) != 125) continue;
                ++this.Perimeter;
            }
        }
        for (i2 = 0; i2 < hauteur; ++i2) {
            for (j = 0; j < largeur && wrd.getSample(j, i2, 0) == 0; ++j) {
                wrd.setSample(j, i2, 0, 255);
            }
            for (j = largeur - 1; j >= 0 && wrd.getSample(j, i2, 0) == 0; --j) {
                wrd.setSample(j, i2, 0, 255);
            }
        }
        this.Surface = 0;
        for (i2 = 0; i2 < hauteur; ++i2) {
            for (j = 0; j < largeur; ++j) {
                if (wrd.getSample(j, i2, 0) >= 255) continue;
                ++this.Surface;
                wrcs.setSample(j, i2, 0, 1);
            }
        }
        for (i2 = 0; i2 < hauteur; ++i2) {
            for (j = 0; j < largeur; ++j) {
                if (wrd.getSample(j, i2, 0) > 0) {
                    wrd.setSample(j, i2, 0, 255);
                    continue;
                }
                if (wrd.getSample(j, i2, 0) != 125) continue;
                wrd.setSample(j, i2, 0, 255);
            }
        }
        this.invert.Filter(this.Differences, this.Differences, 1);
        WritableRaster wro = Original.getRaster();
        for (i2 = 0; i2 < hauteur; ++i2) {
            for (j = 0; j < largeur; ++j) {
                if (wro.getSample(j, i2, 0) <= 0) continue;
                wrd.setSample(j, i2, 0, 0);
            }
        }
        this.ccl.Label(this.Differences, 0, true);
        this.Ncce = Threshold <= 1 ? this.ccl.ConnectedComponentsNumber() : this.ccl.ConnectedComponentsNumber(Threshold);
        wro = null;
        wrd = null;
        wrcs = null;
    }

    @Override
    public BufferedImage getDifferences() {
        return this.Differences;
    }

    @Override
    public List<Coordinates> getHull() {
        return this.Hull;
    }

    @Override
    public BufferedImage getHullShape() {
        return this.ConvexShape;
    }

    @Override
    public int getPerimeter() {
        return this.Perimeter;
    }

    @Override
    public int getSurface() {
        return this.Surface;
    }

    @Override
    public int getNcce() {
        return this.Ncce;
    }

    private class Node {
        Coordinates Adr;
        Node prev;
        Node next;

        private Node() {
        }
    }
}

