/*
 * Decompiled with CFR 0.152.
 */
package algoGeo.convexhull;

import algoGeo.convexhull.AklToussaint;
import algoGeo.convexhull.ConvexHull;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.List;
import listTiTi.ListNew;
import mathematics.Bresenham;
import mathematics.Geometry2D;
import mathematics.primitives.pointsTiTi.Coordinate;
import mathematics.primitives.pointsTiTi.Coordinates;
import measures.BasicMeasures;
import measures.cclh.ConnectedComponentLabeling;
import measures.cclh.UnionFindCcl;
import processing.filters.Invert;

public class Graham
implements ConvexHull {
    private int Ncce = -1;
    private int Surface = -1;
    private int Perimeter = -1;
    private BufferedImage Differences = null;
    private BufferedImage ConvexShape = null;
    private ConnectedComponentLabeling ccl = new UnionFindCcl();
    private Invert invert = new Invert();
    private double[] Angle = null;
    private List<Coordinates> Hull = null;
    private Coordinates[] HullArray = null;

    @Override
    public void Compute(BufferedImage image, AklToussaint akl) {
        BasicMeasures bb = new BasicMeasures();
        bb.Compute(image, true);
        this.Compute(bb.Boundary.Points(), akl);
    }

    @Override
    public void Compute(List<Coordinates> ListIn, AklToussaint akl) {
        int max;
        Coordinate barycentre = new Coordinate(0.0, 0.0);
        Coordinates p = null;
        this.Hull = ListNew.Clone(ListIn);
        if (akl != null) {
            akl.Remove(this.Hull);
        }
        while (true) {
            int n0 = (int)(Math.random() * (double)this.Hull.size());
            int n1 = (int)(Math.random() * (double)this.Hull.size());
            int n2 = (int)(Math.random() * (double)this.Hull.size());
            if (n0 == n1 || n0 == n2 || n1 == n2) continue;
            barycentre.X = (double)(this.Hull.get((int)n0).X + this.Hull.get((int)n1).X + this.Hull.get((int)n2).X) / 3.0;
            barycentre.Y = (double)(this.Hull.get((int)n0).Y + this.Hull.get((int)n1).Y + this.Hull.get((int)n2).Y) / 3.0;
            if (akl != null) {
                max = akl.Polygon() == 8 ? this.Hull.indexOf(akl.MaxXY()) : this.Hull.indexOf(akl.MaxX());
            } else {
                max = 0;
                for (int i2 = 1; i2 < this.Hull.size(); ++i2) {
                    if (this.Hull.get((int)i2).X > this.Hull.get((int)max).X) {
                        max = i2;
                        continue;
                    }
                    if (this.Hull.get((int)i2).X != this.Hull.get((int)max).X || this.Hull.get((int)i2).Y <= this.Hull.get((int)max).Y) continue;
                    max = i2;
                }
            }
            if (this.ComputeAngles(barycentre, this.Hull.get(max))) break;
        }
        this.Angle[max] = this.Angle[0];
        this.Angle[0] = 0.0;
        p = new Coordinates(this.Hull.get(max));
        this.Hull.set(max, this.Hull.get(0));
        this.Hull.set(0, p);
        this.HullArray = this.Hull.toArray(new Coordinates[1]);
        this.QuickSort(0, this.Angle.length - 1);
        int t = 0;
        while (t + 2 < this.Hull.size()) {
            if (Geometry2D.TurnLeft(this.Hull.get(t), this.Hull.get(t + 1), this.Hull.get(t + 2))) {
                ++t;
                continue;
            }
            this.Hull.remove(t + 1);
            if (0 >= t) continue;
            --t;
        }
        while ((t + 1) % this.Hull.size() != 0) {
            if (Geometry2D.TurnLeft(this.Hull.get(t), this.Hull.get((t + 1) % this.Hull.size()), this.Hull.get((t + 2) % this.Hull.size()))) {
                ++t;
                continue;
            }
            this.Hull.remove(t + 1);
            if (t <= 0) continue;
            --t;
        }
    }

    private boolean ComputeAngles(Coordinate bary, Coordinates p) {
        if (this.Angle == null || this.Angle.length != this.Hull.size()) {
            this.Angle = null;
            this.Angle = new double[this.Hull.size()];
        }
        for (int i2 = 0; i2 < this.Hull.size(); ++i2) {
            double a = Geometry2D.AngleBAC(p, bary, this.Hull.get(i2), true);
            if (Double.isNaN(a)) {
                return false;
            }
            this.Angle[i2] = a;
        }
        return true;
    }

    @Override
    public void ComputeProperties(BufferedImage Original, int Threshold) {
        int j;
        int i2;
        if (ImageTools.isColored((BufferedImage)Original)) {
            throw new IllegalArgumentException("Colored images not supported.");
        }
        int largeur = Original.getWidth();
        int hauteur = Original.getHeight();
        this.ConvexShape = null;
        this.Differences = null;
        this.Differences = new BufferedImage(largeur, hauteur, 10);
        WritableRaster wrd = this.Differences.getRaster();
        this.ConvexShape = new BufferedImage(largeur, hauteur, 12);
        WritableRaster wrcs = this.ConvexShape.getRaster();
        if (this.Hull.isEmpty()) {
            this.Perimeter = 0;
            this.Surface = 0;
            this.Ncce = 0;
            this.ConvexShape = null;
            this.ConvexShape = ImageNew.Clone((BufferedImage)Original);
            return;
        }
        for (i2 = 0; i2 < this.Hull.size() - 1; ++i2) {
            wrd.setSample(this.Hull.get((int)i2).X, this.Hull.get((int)i2).Y, 0, 255);
        }
        for (i2 = 0; i2 < this.Hull.size() - 1; ++i2) {
            Bresenham.Draw((BufferedImage)this.Differences, (int)this.Hull.get((int)i2).X, (int)this.Hull.get((int)i2).Y, (int)this.Hull.get((int)(i2 + 1)).X, (int)this.Hull.get((int)(i2 + 1)).Y, (int)125);
        }
        Bresenham.Draw((BufferedImage)this.Differences, (int)this.Hull.get((int)(this.Hull.size() - 1)).X, (int)this.Hull.get((int)(this.Hull.size() - 1)).Y, (int)this.Hull.get((int)0).X, (int)this.Hull.get((int)0).Y, (int)125);
        for (i2 = 0; i2 < hauteur; ++i2) {
            for (j = 0; j < largeur; ++j) {
                if (wrd.getSample(j, i2, 0) != 125) continue;
                ++this.Perimeter;
            }
        }
        for (i2 = 0; i2 < hauteur; ++i2) {
            for (j = 0; j < largeur && wrd.getSample(j, i2, 0) == 0; ++j) {
                wrd.setSample(j, i2, 0, 255);
            }
            for (j = largeur - 1; j >= 0 && wrd.getSample(j, i2, 0) == 0; --j) {
                wrd.setSample(j, i2, 0, 255);
            }
        }
        this.Surface = 0;
        for (i2 = 0; i2 < hauteur; ++i2) {
            for (j = 0; j < largeur; ++j) {
                if (wrd.getSample(j, i2, 0) >= 255) continue;
                ++this.Surface;
                wrcs.setSample(j, i2, 0, 1);
            }
        }
        for (i2 = 0; i2 < hauteur; ++i2) {
            for (j = 0; j < largeur; ++j) {
                if (wrd.getSample(j, i2, 0) > 0) {
                    wrd.setSample(j, i2, 0, 255);
                    continue;
                }
                if (wrd.getSample(j, i2, 0) != 125) continue;
                wrd.setSample(j, i2, 0, 255);
            }
        }
        this.invert.Filter(this.Differences, this.Differences, 1);
        WritableRaster wro = Original.getRaster();
        for (i2 = 0; i2 < hauteur; ++i2) {
            for (j = 0; j < largeur; ++j) {
                if (wro.getSample(j, i2, 0) <= 0) continue;
                wrd.setSample(j, i2, 0, 0);
            }
        }
        this.ccl.Label(this.Differences, 0, true);
        this.Ncce = Threshold <= 1 ? this.ccl.ConnectedComponentsNumber() : this.ccl.ConnectedComponentsNumber(Threshold);
        wro = null;
        wrd = null;
        wrcs = null;
    }

    private int Partition(int m, int n) {
        double v = this.Angle[m];
        int i2 = m - 1;
        int j = n + 1;
        while (true) {
            if (this.Angle[--j] > v) {
                continue;
            }
            while (this.Angle[++i2] < v) {
            }
            if (i2 >= j) break;
            Coordinates pi = this.HullArray[i2];
            Coordinates pj = this.HullArray[j];
            int tmp = pi.X;
            pi.X = pj.X;
            pj.X = tmp;
            tmp = pi.Y;
            pi.Y = pj.Y;
            pj.Y = tmp;
            double tampon = this.Angle[i2];
            this.Angle[i2] = this.Angle[j];
            this.Angle[j] = tampon;
        }
        return j;
    }

    private void QuickSort(int m, int n) {
        if (m < n) {
            int p = this.Partition(m, n);
            this.QuickSort(m, p);
            this.QuickSort(p + 1, n);
        }
    }

    @Override
    public BufferedImage getDifferences() {
        return this.Differences;
    }

    @Override
    public List<Coordinates> getHull() {
        return this.Hull;
    }

    @Override
    public BufferedImage getHullShape() {
        return this.ConvexShape;
    }

    @Override
    public int getPerimeter() {
        return this.Perimeter;
    }

    @Override
    public int getSurface() {
        return this.Surface;
    }

    @Override
    public int getNcce() {
        return this.Ncce;
    }
}

