/*
 * Decompiled with CFR 0.152.
 */
package algoGeo.convexhull;

import dv.DV;
import java.util.Iterator;
import java.util.List;
import mathematics.metrics.Euclidian;
import mathematics.primitives.pointsTiTi.Coordinates;
import mathematics.primitives.pointsTiTi.CoordinatesManager;
import mathematics.primitives.pointsTiTi.Point;
import mathematics.primitives.pointsTiTi.Point3DF;
import net.arpenteur.common.geometry.IPoint3D;
import net.arpenteur.common.geometry.IPoint3DManager;
import net.arpenteur.common.geometry.geom3D.Geom3D;
import net.arpenteur.common.geometry.geom3D.IEdge;
import net.arpenteur.common.geometry.geom3D.IFace;
import net.arpenteur.common.geometry.geom3D.Polyhedron;
import net.arpenteur.common.geometry.primitive.point.Pt;
import net.arpenteur.common.manager.PointManager;

public class ConvexHull3D {
    public final int FACES = 0;
    public final int ARETES = 1;
    public final int SOMMETS = 2;
    private double Surface = 0.0;
    private double Volume = 0.0;
    private Polyhedron Enveloppe = new Polyhedron();

    public ConvexHull3D() {
    }

    public ConvexHull3D(DV dv, boolean AklToussaint2) {
        this.Compute(dv, AklToussaint2);
    }

    public void Compute(DV dv, boolean AklToussaint2) {
        throw new Error("To upgrade.");
    }

    public void Compute(CoordinatesManager surface, boolean AklToussaint2) {
        PointManager Liste = new PointManager();
        for (int i2 = 0; i2 < surface.Size(); ++i2) {
            Coordinates c = surface.Point(i2);
            Liste.addPoint3D((IPoint3D)new Pt((double)c.X, (double)c.Y, (double)c.Z));
            c = null;
        }
        this.Enveloppe = Geom3D.convexHull((PointManager)Liste, (boolean)AklToussaint2);
    }

    public void ComputeProperties(Point B) {
        if (this.Enveloppe == null) {
            throw new Error("enveloppe = null");
        }
        if (this.Enveloppe.getFaces() == null) {
            throw new Error("enveloppe.getFaces = null");
        }
        PointManager points = null;
        Iterator iter = this.Enveloppe.getFaces().iterator();
        Point3DF p1 = new Point3DF();
        Point3DF p2 = new Point3DF();
        Point3DF p0 = new Point3DF();
        Euclidian dist = new Euclidian();
        this.Volume = 0.0;
        this.Surface = 0.0;
        while (iter.hasNext()) {
            points = ((IFace)iter.next()).getVertices();
            p0.setXYZ(points.getPointAt(0).getX(), points.getPointAt(0).getY(), points.getPointAt(0).getZ());
            p1.setXYZ(points.getPointAt(1).getX(), points.getPointAt(1).getY(), points.getPointAt(1).getZ());
            p2.setXYZ(points.getPointAt(2).getX(), points.getPointAt(2).getY(), points.getPointAt(2).getZ());
            double a = dist.Distance((Point)p0, (Point)p1);
            double b = dist.Distance((Point)p1, (Point)p2);
            double c = dist.Distance((Point)p2, (Point)p0);
            double r = (a + b + c) / 2.0;
            this.Surface += Math.sqrt(r * (r - a) * (r - b) * (r - c));
            a = B.getX() - p0.getX();
            b = B.getY() - p0.getY();
            c = B.getZ() - p0.getZ();
            double d = B.getX() - p1.getX();
            double e = B.getY() - p1.getY();
            double f = B.getZ() - p1.getZ();
            double g = B.getX() - p2.getX();
            double h = B.getY() - p2.getY();
            double i2 = B.getZ() - p2.getZ();
            this.Volume += (a * (e * i2 - h * f) - b * (d * i2 - f * g) + c * (d * h - e * g)) / 6.0;
        }
        this.Volume = Math.abs(this.Volume);
        iter = null;
        p1 = null;
        p2 = null;
        p0 = null;
        points = null;
    }

    public double getVolume() {
        return this.Volume;
    }

    public double getSurface() {
        return this.Surface;
    }

    public Polyhedron getHull() {
        return this.Enveloppe;
    }

    public int getNbFaces() {
        return this.Enveloppe.getFaces().size();
    }

    public List<IFace> getFaces(int index) {
        return this.Enveloppe.getFaces();
    }

    public IFace getFace(int index) {
        return (IFace)this.Enveloppe.getFaces().get(index);
    }

    public int getNbEdges() {
        return this.Enveloppe.getEdges().size();
    }

    public List<IEdge> getEdges(int index) {
        return this.Enveloppe.getEdges();
    }

    public IEdge getEdge(int index) {
        return (IEdge)this.Enveloppe.getEdges().get(index);
    }

    public int getNbVertices() {
        return this.Enveloppe.getVertices().size();
    }

    public IPoint3DManager getVertices(int index) {
        return this.Enveloppe.getVertices();
    }

    public IPoint3D getVertex(int index) {
        return this.Enveloppe.getVertices().getPointAt(index);
    }
}

