/*
 * Decompiled with CFR 0.152.
 */
package algoGeo.convexhull;

import java.util.List;
import mathematics.Geometry2D;
import mathematics.primitives.pointsTiTi.Coordinates;

public class AklToussaint {
    private Coordinates cminx;
    private Coordinates cmaxx;
    private Coordinates cminy;
    private Coordinates cmaxy;
    private Coordinates cminxy;
    private Coordinates cmaxxy;
    private Coordinates cminxy2;
    private Coordinates cmaxxy2;
    private int polygon = 8;

    public AklToussaint() {
    }

    public AklToussaint(int polygon) {
        this.Parameters(polygon);
    }

    public void Remove(List<Coordinates> list) {
        this.Remove(list, this.polygon);
    }

    public void Remove(List<Coordinates> list, int polygon) {
        int i2;
        this.Parameters(polygon);
        this.cminxy2 = this.cmaxxy2 = list.get(0);
        this.cmaxxy = this.cmaxxy2;
        this.cminxy = this.cmaxxy2;
        this.cmaxy = this.cmaxxy2;
        this.cminy = this.cmaxxy2;
        this.cmaxx = this.cmaxxy2;
        this.cminx = this.cmaxxy2;
        Coordinates c = this.cmaxxy2;
        int dmin1 = c.X + c.Y;
        int dmin2 = c.X - c.Y;
        int dmax1 = dmin1;
        int dmax2 = dmin2;
        for (i2 = 1; i2 < list.size(); ++i2) {
            c = list.get(i2);
            if (c.X < this.cminx.X) {
                this.cminx = c;
            }
            if (c.Y < this.cminy.Y) {
                this.cminy = c;
            }
            if (this.cmaxx.X < c.X) {
                this.cmaxx = c;
            }
            if (this.cmaxy.Y < c.Y) {
                this.cmaxy = c;
            }
            if (8 != polygon) continue;
            int d = c.X + c.Y;
            if (d < dmin1) {
                this.cminxy = c;
                dmin1 = d;
            }
            if (d > dmax1) {
                this.cmaxxy = c;
                dmax1 = d;
            }
            if ((d = c.X - c.Y) < dmin2) {
                this.cminxy2 = c;
                dmin2 = d;
            }
            if (d <= dmax2) continue;
            this.cmaxxy2 = c;
            dmax2 = d;
        }
        i2 = 0;
        while (i2 < list.size()) {
            c = list.get(i2);
            if (Geometry2D.isInField(this.cminx, this.cminy, this.cmaxx, c) && Geometry2D.isInField(this.cmaxx, this.cmaxy, this.cminx, c)) {
                list.remove(i2);
                continue;
            }
            if (8 == polygon && Geometry2D.isInField(this.cminxy2, this.cminxy, this.cmaxxy2, c) && Geometry2D.isInField(this.cmaxxy2, this.cmaxy, this.cminxy2, c)) {
                list.remove(i2);
                continue;
            }
            if (8 == polygon && Geometry2D.isInField(this.cmaxxy, this.cminxy2, this.cminxy, c) && Geometry2D.isInField(this.cminxy, this.cmaxxy2, this.cmaxxy, c)) {
                list.remove(i2);
                continue;
            }
            ++i2;
        }
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 1) {
            throw new IllegalArgumentException("Exactly 1 parameter required.");
        }
        int p = (Integer)parameters[0];
        if (p != 4 && p != 8) {
            throw new IllegalArgumentException("Bad value for polygon (4 or 8 expected).");
        }
        this.polygon = p;
    }

    public int Polygon() {
        return this.polygon;
    }

    public Coordinates MinX() {
        return this.cminx;
    }

    public Coordinates MaxX() {
        return this.cmaxx;
    }

    public Coordinates MinY() {
        return this.cminy;
    }

    public Coordinates MaxY() {
        return this.cmaxy;
    }

    public Coordinates MinXY() {
        return this.cminxy;
    }

    public Coordinates MaxXY() {
        return this.cmaxxy;
    }

    public Coordinates MinXY2() {
        return this.cminxy2;
    }

    public Coordinates MaxXY2() {
        return this.cmaxxy2;
    }
}

