/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.process.StackProcessor;
import java.awt.Rectangle;

public class Transformer
implements PlugInFilter {
    ImagePlus imp;
    String arg;

    @Override
    public int setup(String arg, ImagePlus imp) {
        this.arg = arg;
        this.imp = imp;
        if (arg.equals("fliph") || arg.equals("flipv")) {
            return IJ.setupDialog(imp, 287);
        }
        return 415;
    }

    @Override
    public void run(ImageProcessor ip) {
        boolean transformOrigin;
        Calibration cal = this.imp.getCalibration();
        boolean bl = transformOrigin = cal.xOrigin != 0.0 || cal.yOrigin != 0.0;
        if (this.arg.equals("fliph")) {
            ip.flipHorizontal();
            Rectangle r = ip.getRoi();
            if (transformOrigin && r.x == 0 && r.y == 0 && r.width == ip.getWidth() && r.height == ip.getHeight()) {
                cal.xOrigin = (double)(this.imp.getWidth() - 1) - cal.xOrigin;
            }
            return;
        }
        if (this.arg.equals("flipv")) {
            ip.flipVertical();
            Rectangle r = ip.getRoi();
            if (transformOrigin && r.x == 0 && r.y == 0 && r.width == ip.getWidth() && r.height == ip.getHeight()) {
                cal.yOrigin = (double)(this.imp.getHeight() - 1) - cal.yOrigin;
            }
            return;
        }
        if (this.arg.equals("right") || this.arg.equals("left")) {
            double yOrigin;
            double xOrigin;
            StackProcessor sp = new StackProcessor(this.imp.getStack(), ip);
            ImageStack s2 = null;
            if (this.arg.equals("right")) {
                s2 = sp.rotateRight();
                if (transformOrigin) {
                    xOrigin = (double)(this.imp.getHeight() - 1) - cal.yOrigin;
                    yOrigin = cal.xOrigin;
                    cal.xOrigin = xOrigin;
                    cal.yOrigin = yOrigin;
                }
            } else {
                s2 = sp.rotateLeft();
                if (transformOrigin) {
                    xOrigin = cal.yOrigin;
                    yOrigin = (double)(this.imp.getWidth() - 1) - cal.xOrigin;
                    cal.xOrigin = xOrigin;
                    cal.yOrigin = yOrigin;
                }
            }
            this.imp.setStack(null, s2);
            double pixelWidth = cal.pixelWidth;
            cal.pixelWidth = cal.pixelHeight;
            cal.pixelHeight = pixelWidth;
            if (!cal.getXUnit().equals(cal.getYUnit())) {
                String xUnit = cal.getXUnit();
                cal.setXUnit(cal.getYUnit());
                cal.setYUnit(xUnit);
            }
            return;
        }
    }
}

