/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.Menus;
import ij.Prefs;
import ij.plugin.PlugIn;
import ij.util.StringSorter;
import java.io.File;
import java.util.Vector;

public class ClassChecker
implements PlugIn {
    String[] paths;
    String[] names;

    @Override
    public void run(String arg) {
        this.deleteDuplicates();
    }

    void deleteDuplicates() {
        int i;
        this.getPathsAndNames();
        if (this.paths == null || this.paths.length < 2) {
            return;
        }
        String[] sortedNames = new String[this.names.length];
        for (i = 0; i < this.names.length; ++i) {
            sortedNames[i] = this.names[i];
        }
        StringSorter.sort(sortedNames);
        for (i = 0; i < sortedNames.length - 1; ++i) {
            if (!sortedNames[i].equals(sortedNames[i + 1])) continue;
            this.delete(sortedNames[i]);
        }
    }

    void delete(String name) {
        String path1 = null;
        String path2 = null;
        for (int i = 0; i < this.names.length; ++i) {
            long date2;
            if (path1 == null && this.names[i].equals(name)) {
                path1 = this.paths[i] + this.names[i];
            } else if (path2 == null && this.names[i].equals(name)) {
                path2 = this.paths[i] + this.names[i];
            }
            if (path1 == null || path2 == null) continue;
            File file1 = new File(path1);
            File file2 = new File(path2);
            if (file1 == null || file2 == null) {
                return;
            }
            long date1 = file1.lastModified();
            if (date1 < (date2 = file2.lastModified())) {
                this.write(path1);
                file1.delete();
                break;
            }
            this.write(path2);
            file2.delete();
            break;
        }
    }

    void write(String path) {
        IJ.log("Deleting duplicate plugin: " + path);
    }

    void getPathsAndNames() {
        String path = Menus.getPlugInsPath();
        if (path == null) {
            return;
        }
        File f = new File(path);
        String[] list = f.list();
        if (list == null) {
            return;
        }
        Vector<String> v1 = new Vector<String>(1000);
        Vector<String> v2 = new Vector<String>(1000);
        for (int i = 0; i < list.length; ++i) {
            String name = list[i];
            if (name.endsWith(".class") || name.endsWith(".jar")) {
                v1.addElement(path);
                v2.addElement(name);
                continue;
            }
            this.getSubdirectoryFiles(path, name, v1, v2);
        }
        this.paths = new String[v1.size()];
        v1.copyInto(this.paths);
        this.names = new String[v2.size()];
        v2.copyInto(this.names);
    }

    void getSubdirectoryFiles(String path, String dir, Vector v1, Vector v2) {
        if (dir.endsWith(".java")) {
            return;
        }
        File f = new File(path, dir);
        if (!f.isDirectory()) {
            return;
        }
        String[] list = f.list();
        if (list == null) {
            return;
        }
        dir = dir + Prefs.separator;
        for (int i = 0; i < list.length; ++i) {
            String name = list[i];
            if (!name.endsWith(".class") && !name.endsWith(".jar")) continue;
            v1.addElement(path + dir);
            v2.addElement(name);
        }
    }
}

