/*
 * Decompiled with CFR 0.152.
 */
package utils.strings;

import java.awt.image.BufferedImage;

public class StringToolsImageDV {
    public static String FindExtension(String name) {
        int pos;
        for (pos = name.length() - 1; 0 <= pos && name.charAt(pos) != '.'; --pos) {
        }
        if (pos < 0) {
            return null;
        }
        return name.substring(++pos);
    }

    public static String DeleteExtension(String name) {
        int pos;
        for (pos = name.length() - 1; 0 <= pos && name.charAt(pos) != '.'; --pos) {
        }
        if (pos < 0) {
            return null;
        }
        return name.substring(0, pos);
    }

    public static String FindName(String FileName) {
        int sep;
        int point;
        for (point = FileName.length() - 1; point >= 0 && FileName.charAt(point) != '.'; --point) {
        }
        if (point < 0) {
            return null;
        }
        for (sep = point - 1; sep >= 0 && FileName.charAt(sep) != '/' && FileName.charAt(sep) != '\\'; --sep) {
        }
        if (sep < 0) {
            return FileName.substring(0, point);
        }
        return FileName.substring(sep + 1, point);
    }

    public static String FindName2(String FileName) {
        int sep;
        String result = StringToolsImageDV.FindName(FileName);
        if (result != null) {
            return result;
        }
        for (sep = FileName.length() - 1; sep >= 0 && FileName.charAt(sep) != '/' && FileName.charAt(sep) != '\\'; --sep) {
        }
        if (sep < 0) {
            return FileName.substring(0, FileName.length() - 1);
        }
        return FileName.substring(sep + 1, FileName.length() - 1);
    }

    public static String FindPath(String FileName) {
        int sep;
        int point;
        for (point = FileName.length() - 1; point >= 0 && FileName.charAt(point) != '.'; --point) {
        }
        if (point < 0) {
            return null;
        }
        for (sep = point - 1; sep >= 0 && FileName.charAt(sep) != '/' && FileName.charAt(sep) != '\\'; --sep) {
        }
        if (sep < 0) {
            return "";
        }
        return FileName.substring(0, sep + 1);
    }

    public static String StringBeforeExtension(String FileName) {
        int i;
        String str = StringToolsImageDV.DeleteExtension(FileName);
        for (i = str.length() - 1; i >= 0 && str.charAt(i) != '_'; --i) {
        }
        if (i < 0) {
            return null;
        }
        return str.substring(i + 1, str.length());
    }

    public static String NameOfType(int type) {
        switch (type) {
            case 5: {
                return "3BYTE_BGR";
            }
            case 6: {
                return "4BYTE_ABGR";
            }
            case 7: {
                return "4BYTE_ABGR_PRE";
            }
            case 12: {
                return "BYTE_BINARY";
            }
            case 10: {
                return "BYTE_GRAY";
            }
            case 13: {
                return "BYTE_INDEXED";
            }
            case 0: {
                return "CUSTOM";
            }
            case 2: {
                return "INT_ARGB";
            }
            case 3: {
                return "INT_ARGB_PRE";
            }
            case 4: {
                return "INT_BGR";
            }
            case 1: {
                return "INT_RGB";
            }
            case 9: {
                return "USHORT_555_RGB";
            }
            case 8: {
                return "USHORT_565_RGB";
            }
            case 11: {
                return "USHORT_GRAY";
            }
        }
        throw new IllegalArgumentException("Default: unknow image type.");
    }

    public static String NameOfTypeDV(int type) {
        switch (type) {
            case 8: {
                return "BYTE_GRAY";
            }
            case 64: {
                return "DOUBLE_GRAY";
            }
            case -32: {
                return "FLOAT_GRAY";
            }
            case 32: {
                return "INT_GRAY";
            }
            case 16: {
                return "SHORT_GRAY";
            }
        }
        throw new IllegalArgumentException("Default: unknow DV type.");
    }

    public static String NameOfDataBufferType(BufferedImage image) {
        switch (image.getType()) {
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: {
                return "Byte";
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return "Int";
            }
            case 8: 
            case 9: 
            case 11: {
                return "Short";
            }
            case 0: {
                switch (image.getRaster().getDataBuffer().getDataType()) {
                    case 0: {
                        return "Byte";
                    }
                    case 5: {
                        return "Double";
                    }
                    case 4: {
                        return "Float";
                    }
                    case 3: {
                        return "Int";
                    }
                    case 2: {
                        return "Short";
                    }
                    case 32: {
                        return "Undefined";
                    }
                    case 1: {
                        return "UShort";
                    }
                }
                throw new IllegalArgumentException("Default: unknow type of DataBuffer.");
            }
        }
        throw new IllegalArgumentException("Default: unknow type of image.");
    }

    public static String NameOfDataBufferType(int type) {
        switch (type) {
            case 0: {
                return "Byte";
            }
            case 5: {
                return "Double";
            }
            case 4: {
                return "Float";
            }
            case 3: {
                return "Int";
            }
            case 2: {
                return "Short";
            }
            case 32: {
                return "Undefined";
            }
            case 1: {
                return "UShort";
            }
        }
        throw new IllegalArgumentException("Default: unknow type of DataBuffer.");
    }
}

