/*
 * Decompiled with CFR 0.152.
 */
package utils.memory;

import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.concurrent.ConcurrentLinkedQueue;

public class Allocator {
    public ConcurrentLinkedQueue<int[]> intlist = new ConcurrentLinkedQueue();
    public ConcurrentLinkedQueue<byte[]> bytelist = new ConcurrentLinkedQueue();
    public ConcurrentLinkedQueue<short[]> shortlist = new ConcurrentLinkedQueue();
    public ConcurrentLinkedQueue<float[]> floatlist = new ConcurrentLinkedQueue();
    public ConcurrentLinkedQueue<double[]> doublelist = new ConcurrentLinkedQueue();
    public ConcurrentLinkedQueue<boolean[]> boollist = new ConcurrentLinkedQueue();
    public ConcurrentLinkedQueue<BufferedImage> imlist = new ConcurrentLinkedQueue();

    private Allocator() {
    }

    public static Allocator Instance() {
        return AllocatorSingleton.INSTANCE;
    }

    public synchronized int[] Release(int[] array) {
        if (array == null) {
            return null;
        }
        this.intlist.add(array);
        Arrays.fill(array, 0);
        return null;
    }

    public synchronized int[] newIntArray(int length) {
        for (int[] array : this.intlist) {
            if (array.length != length) continue;
            this.intlist.remove(array);
            return array;
        }
        return new int[length];
    }

    public synchronized void ClearIntArrays() {
        this.intlist.clear();
    }

    public synchronized byte[] Release(byte[] array) {
        if (array == null) {
            return null;
        }
        this.bytelist.add(array);
        Arrays.fill(array, (byte)0);
        return null;
    }

    public synchronized byte[] newByteArray(int length) {
        for (byte[] array : this.bytelist) {
            if (array.length != length) continue;
            this.bytelist.remove(array);
            return array;
        }
        return new byte[length];
    }

    public synchronized void ClearByteArrays() {
        this.bytelist.clear();
    }

    public synchronized short[] Release(short[] array) {
        if (array == null) {
            return null;
        }
        this.shortlist.add(array);
        Arrays.fill(array, (short)0);
        return null;
    }

    public synchronized short[] newShortArray(int length) {
        for (short[] array : this.shortlist) {
            if (array.length != length) continue;
            this.shortlist.remove(array);
            return array;
        }
        return new short[length];
    }

    public synchronized void ClearShortArrays() {
        this.shortlist.clear();
    }

    public synchronized float[] Release(float[] array) {
        if (array == null) {
            return null;
        }
        this.floatlist.add(array);
        Arrays.fill(array, 0.0f);
        return null;
    }

    public synchronized float[] newFloatArray(int length) {
        for (float[] array : this.floatlist) {
            if (array.length != length) continue;
            this.floatlist.remove(array);
            return array;
        }
        return new float[length];
    }

    public synchronized void ClearFloatArrays() {
        this.floatlist.clear();
    }

    public synchronized double[] Release(double[] array) {
        if (array == null) {
            return null;
        }
        this.doublelist.add(array);
        Arrays.fill(array, 0.0);
        return null;
    }

    public synchronized double[] newDoubleArray(int length) {
        for (double[] array : this.doublelist) {
            if (array.length != length) continue;
            this.doublelist.remove(array);
            return array;
        }
        return new double[length];
    }

    public synchronized void ClearDoubleArrays() {
        this.doublelist.clear();
    }

    public synchronized boolean[] Release(boolean[] array) {
        if (array == null) {
            return null;
        }
        this.boollist.add(array);
        Arrays.fill(array, false);
        return null;
    }

    public synchronized boolean[] newBooleanArray(int length) {
        for (boolean[] array : this.boollist) {
            if (array.length != length) continue;
            this.boollist.remove(array);
            return array;
        }
        return new boolean[length];
    }

    public synchronized void ClearBooleanArrays() {
        this.boollist.clear();
    }

    public synchronized void ClearArrays(boolean callgc) {
        this.boollist.clear();
        this.bytelist.clear();
        this.doublelist.clear();
        this.floatlist.clear();
        this.intlist.clear();
        this.shortlist.clear();
        if (callgc) {
            System.gc();
        }
    }

    public synchronized BufferedImage Release(BufferedImage image) {
        if (image == null) {
            return null;
        }
        this.imlist.add(image);
        switch (image.getRaster().getDataBuffer().getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                ImageOperations.Fill(image, 0);
                break;
            }
            case 4: {
                ImageOperations.Fill(image, 0.0f);
                break;
            }
            case 5: {
                ImageOperations.Fill(image, 0.0);
                break;
            }
            default: {
                throw new UnsupportedOperationException("DataBuffer type unknown: " + image.getRaster().getDataBuffer().getDataType());
            }
        }
        return null;
    }

    public synchronized BufferedImage newBufferedImage(int width, int height, BufferedImage image) {
        switch (image.getType()) {
            case 0: {
                switch (image.getRaster().getDataBuffer().getDataType()) {
                    case 0: {
                        throw new IllegalArgumentException("DataBuffer type not supported (yet).");
                    }
                    case 5: {
                        return this.newBufferedImageDouble(width, height, image.getRaster().getNumBands());
                    }
                    case 4: {
                        return this.newBufferedImageFloat(width, height, image.getRaster().getNumBands());
                    }
                    case 3: {
                        return this.newBufferedImageInt(width, height, image.getRaster().getNumBands());
                    }
                    case 2: {
                        return this.newBufferedImageShort(width, height, image.getRaster().getNumBands());
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
        }
        return this.newBufferedImage(width, height, image.getType());
    }

    public synchronized BufferedImage newBufferedImage(int width, int height, int type) {
        if (type == 0) {
            throw new IllegalArgumentException("Unsupported type, use the dedicated methods.");
        }
        for (BufferedImage im : this.imlist) {
            if (im.getType() != type || im.getWidth() != width || im.getHeight() != height) continue;
            this.imlist.remove(im);
            return im;
        }
        return new BufferedImage(width, height, type);
    }

    public synchronized BufferedImage newBufferedImageInt(int width, int height, int channels) {
        for (BufferedImage im : this.imlist) {
            if (im.getType() != 0 || im.getRaster().getDataBuffer().getDataType() != 3 || im.getWidth() != width || im.getHeight() != height) continue;
            this.imlist.remove(im);
            return im;
        }
        return ImageNew.Integer(width, height, channels, true);
    }

    public synchronized BufferedImage newBufferedImageShort(int width, int height, int channels) {
        for (BufferedImage im : this.imlist) {
            if (im.getType() != 0 || im.getRaster().getDataBuffer().getDataType() != 1 || im.getWidth() != width || im.getHeight() != height) continue;
            this.imlist.remove(im);
            return im;
        }
        return ImageNew.Short(width, height, channels, true);
    }

    public synchronized BufferedImage newBufferedImageDouble(int width, int height, int channels) {
        for (BufferedImage im : this.imlist) {
            if (im.getType() != 0 || im.getRaster().getDataBuffer().getDataType() != 5 || im.getWidth() != width || im.getHeight() != height) continue;
            this.imlist.remove(im);
            return im;
        }
        return ImageNew.Double(width, height, channels, true);
    }

    public synchronized BufferedImage newBufferedImageFloat(int width, int height, int channels) {
        for (BufferedImage im : this.imlist) {
            if (im.getType() != 0 || im.getRaster().getDataBuffer().getDataType() != 4 || im.getWidth() != width || im.getHeight() != height) continue;
            this.imlist.remove(im);
            return im;
        }
        return ImageNew.Float(width, height, channels, true);
    }

    public synchronized void ClearBufferedImage(boolean callgc) {
        this.imlist.clear();
        if (callgc) {
            System.gc();
        }
    }

    public void ClearAll(boolean callgc) {
        this.ClearBufferedImage(false);
        this.ClearArrays(callgc);
    }

    private static class AllocatorSingleton {
        private static final Allocator INSTANCE = new Allocator();

        private AllocatorSingleton() {
        }
    }
}

