/*
 * Decompiled with CFR 0.152.
 */
package registration.turboreg;

import ij.ImagePlus;
import java.util.Stack;
import mathematics.Maths;

class TurboRegImageFloat
implements Runnable {
    private final Stack<Object> pyramid = new Stack();
    private Thread t = new Thread(this);
    private float[] image;
    private float[] coefficient;
    private float[] xGradient;
    private float[] yGradient;
    private final int width;
    private final int height;
    private int pyramidDepth;
    private int transformation;
    private final boolean isTarget;
    private final int nbCPU;
    private InterpolationThread[] interthreads = null;
    private int nbFreeInterThreads = 0;
    private SymmetricThread[] symthreads = null;
    private int nbFreeSymmetricThreads = 0;
    private CoefToXYGThread[] stxythreads = null;
    private int nbFreeCTCXGThreads = 0;
    private HalfDualThread[] halfdualthreads = null;
    private int nbFreeHalfDualThreads = 0;
    private final int SizeCPU = 5;
    private final float TwoThird = 0.6666667f;
    private final float OneSixth = 0.16666667f;

    @Override
    public void run() {
        int i;
        this.coefficient = this.getBasicFromCardinal2D();
        switch (this.transformation) {
            case -1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                if (this.isTarget) {
                    this.buildCoefficientPyramid();
                    break;
                }
                this.imageToXYGradient2D();
                this.buildImageAndGradientPyramid();
                break;
            }
            case 8: {
                if (this.isTarget) {
                    this.buildImagePyramid();
                    break;
                }
                this.buildCoefficientPyramid();
            }
        }
        if (this.interthreads != null) {
            for (i = 0; i < this.interthreads.length; ++i) {
                this.interthreads[i].Kill();
                this.interthreads[i] = null;
            }
        }
        this.interthreads = null;
        if (this.symthreads != null) {
            for (i = 0; i < this.symthreads.length; ++i) {
                this.symthreads[i].Kill();
                this.symthreads[i] = null;
            }
        }
        this.symthreads = null;
        if (this.stxythreads != null) {
            for (i = 0; i < this.stxythreads.length; ++i) {
                this.stxythreads[i].Kill();
                this.stxythreads[i] = null;
            }
        }
        this.stxythreads = null;
        if (this.halfdualthreads != null) {
            for (i = 0; i < this.halfdualthreads.length; ++i) {
                this.halfdualthreads[i].Kill();
                this.halfdualthreads[i] = null;
            }
        }
        this.halfdualthreads = null;
    }

    public void Kill() {
        this.yGradient = null;
        this.xGradient = null;
        this.coefficient = null;
        this.image = null;
        this.pyramid.clear();
    }

    public TurboRegImageFloat(ImagePlus imp, int transformation, boolean isTarget, int MaxThread) {
        this.t.setDaemon(true);
        this.transformation = transformation;
        this.isTarget = isTarget;
        this.width = imp.getWidth();
        this.height = imp.getHeight();
        this.nbCPU = Math.min(MaxThread, Runtime.getRuntime().availableProcessors());
        switch (imp.getType()) {
            case 0: {
                this.image = new float[this.width * this.height];
                byte[] pixels = (byte[])imp.getProcessor().getPixels();
                int pos = 0;
                for (int y = 0; y < this.height; ++y) {
                    int x = 0;
                    while (x < this.width) {
                        this.image[pos] = pixels[pos] & 0xFF;
                        ++x;
                        ++pos;
                    }
                }
                break;
            }
            case 1: {
                this.image = new float[this.width * this.height];
                short[] pixels = (short[])imp.getProcessor().getPixels();
                int pos = 0;
                for (int y = 0; y < this.height; ++y) {
                    int x = 0;
                    while (x < this.width) {
                        this.image[pos] = pixels[pos] & 0xFFFF;
                        ++x;
                        ++pos;
                    }
                }
                break;
            }
            case 2: {
                this.image = (float[])imp.getProcessor().getPixels();
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
    }

    public float[] getCoefficient() {
        return this.coefficient;
    }

    public int getHeight() {
        return this.height;
    }

    public float[] getImage() {
        return this.image;
    }

    public Stack<Object> getPyramid() {
        return this.pyramid;
    }

    public int getPyramidDepth() {
        return this.pyramidDepth;
    }

    public Thread getThread() {
        return this.t;
    }

    public int getWidth() {
        return this.width;
    }

    public float[] getXGradient() {
        return this.xGradient;
    }

    public float[] getYGradient() {
        return this.yGradient;
    }

    public void setPyramidDepth(int pyramidDepth) {
        this.pyramidDepth = pyramidDepth;
    }

    public void setTransformation(int transformation) {
        this.transformation = transformation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void basicToCardinal2D(float[] basic, float[] cardinal, int width, int height, int degree) {
        Object object;
        int i;
        int min;
        float[] h = null;
        switch (degree) {
            case 3: {
                h = new float[]{0.6666667f, 0.16666667f};
                break;
            }
            case 7: {
                h = new float[]{0.47936508f, 0.23630953f, 0.023809524f, 1.984127E-4f};
                break;
            }
            default: {
                h = new float[]{1.0f};
            }
        }
        if (this.symthreads == null) {
            this.nbFreeSymmetricThreads = 0;
            this.symthreads = new SymmetricThread[this.nbCPU];
            for (int i2 = 0; i2 < this.nbCPU; ++i2) {
                this.symthreads[i2] = new SymmetricThread();
                this.symthreads[i2].start();
            }
            TurboRegImageFloat i2 = this;
            synchronized (i2) {
                while (this.nbFreeSymmetricThreads != this.nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        int nbcpu = Math.max(this.nbCPU << 5 < (min = Math.min(width, height)) ? this.nbCPU : min >> 5, 1);
        int step = height / nbcpu;
        this.nbFreeSymmetricThreads = 0;
        for (i = 0; i < nbcpu - 1; ++i) {
            this.symthreads[i].setConditions(basic, width, height, i * step, (i + 1) * step, h, true, cardinal);
            object = this.symthreads[i].lock;
            synchronized (object) {
                this.symthreads[i].lock.notify();
                continue;
            }
        }
        this.symthreads[i].setConditions(basic, width, height, i * step, height, h, true, cardinal);
        object = this.symthreads[i].lock;
        synchronized (object) {
            this.symthreads[i].lock.notify();
        }
        object = this;
        synchronized (object) {
            while (this.nbFreeSymmetricThreads != nbcpu) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        step = width / nbcpu;
        this.nbFreeSymmetricThreads = 0;
        for (i = 0; i < nbcpu - 1; ++i) {
            this.symthreads[i].setConditions(cardinal, width, height, i * step, (i + 1) * step, h, false, cardinal);
            object = this.symthreads[i].lock;
            synchronized (object) {
                this.symthreads[i].lock.notify();
                continue;
            }
        }
        this.symthreads[i].setConditions(cardinal, width, height, i * step, width, h, false, cardinal);
        object = this.symthreads[i].lock;
        synchronized (object) {
            this.symthreads[i].lock.notify();
        }
        object = this;
        synchronized (object) {
            while (this.nbFreeSymmetricThreads != nbcpu) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void buildCoefficientPyramid() {
        float[] fullDual = new float[this.width * this.height];
        int halfWidth = this.width;
        int halfHeight = this.height;
        if (1 < this.pyramidDepth) {
            this.basicToCardinal2D(this.coefficient, fullDual, this.width, this.height, 7);
        }
        for (int depth = 1; depth < this.pyramidDepth; ++depth) {
            int fullWidth = halfWidth;
            int fullHeight = halfHeight;
            float[] halfDual = this.getHalfDual2D(fullDual, fullWidth, fullHeight);
            float[] halfCoefficient = this.getBasicFromCardinal2D(halfDual, halfWidth >>= 1, halfHeight >>= 1, 7);
            this.pyramid.push(halfCoefficient);
            this.pyramid.push(halfHeight);
            this.pyramid.push(halfWidth);
            fullDual = halfDual;
        }
    }

    private void buildImageAndGradientPyramid() {
        float[] fullDual = new float[this.width * this.height];
        int halfWidth = this.width;
        int halfHeight = this.height;
        if (1 < this.pyramidDepth) {
            this.cardinalToDual2D(this.image, fullDual, this.width, this.height, 3);
        }
        for (int depth = 1; depth < this.pyramidDepth; ++depth) {
            int fullWidth = halfWidth;
            int fullHeight = halfHeight;
            float[] halfDual = this.getHalfDual2D(fullDual, fullWidth, fullHeight);
            float[] halfImage = this.getBasicFromCardinal2D(halfDual, halfWidth >>= 1, halfHeight >>= 1, 7);
            float[] halfXGradient = new float[halfWidth * halfHeight];
            float[] halfYGradient = new float[halfWidth * halfHeight];
            this.coefficientToXYGradient2D(halfImage, halfXGradient, halfYGradient, halfWidth, halfHeight);
            this.basicToCardinal2D(halfImage, halfImage, halfWidth, halfHeight, 3);
            this.pyramid.push(halfYGradient);
            this.pyramid.push(halfXGradient);
            this.pyramid.push(halfImage);
            this.pyramid.push(halfHeight);
            this.pyramid.push(halfWidth);
            fullDual = halfDual;
        }
    }

    private void buildImagePyramid() {
        float[] fullDual = new float[this.width * this.height];
        int halfWidth = this.width;
        int halfHeight = this.height;
        if (1 < this.pyramidDepth) {
            this.cardinalToDual2D(this.image, fullDual, this.width, this.height, 3);
        }
        for (int depth = 1; depth < this.pyramidDepth; ++depth) {
            int fullWidth = halfWidth;
            int fullHeight = halfHeight;
            float[] halfDual = this.getHalfDual2D(fullDual, fullWidth, fullHeight);
            float[] halfImage = new float[(halfWidth >>= 1) * (halfHeight >>= 1)];
            this.dualToCardinal2D(halfDual, halfImage, halfWidth, halfHeight, 3);
            this.pyramid.push(halfImage);
            this.pyramid.push(halfHeight);
            this.pyramid.push(halfWidth);
            fullDual = halfDual;
        }
    }

    private void cardinalToDual2D(float[] cardinal, float[] dual, int width, int height, int degree) {
        this.basicToCardinal2D(this.getBasicFromCardinal2D(cardinal, width, height, degree), dual, width, height, 2 * degree + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void coefficientToXYGradient2D(float[] basic, float[] xGradient, float[] yGradient, int width, int height) {
        Object object;
        int i;
        int min;
        if (this.stxythreads == null) {
            this.nbFreeCTCXGThreads = 0;
            this.stxythreads = new CoefToXYGThread[this.nbCPU];
            for (int i2 = 0; i2 < this.nbCPU; ++i2) {
                this.stxythreads[i2] = new CoefToXYGThread();
                this.stxythreads[i2].start();
            }
            TurboRegImageFloat i2 = this;
            synchronized (i2) {
                while (this.nbFreeCTCXGThreads != this.nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        int nbcpu = Math.max(this.nbCPU << 5 < (min = Math.min(width, height)) ? this.nbCPU : min >> 5, 1);
        int step = height / nbcpu;
        this.nbFreeCTCXGThreads = 0;
        for (i = 0; i < nbcpu - 1; ++i) {
            this.stxythreads[i].setConditions(basic, width, height, i * step, (i + 1) * step, true, xGradient, yGradient);
            object = this.stxythreads[i].lock;
            synchronized (object) {
                this.stxythreads[i].lock.notify();
                continue;
            }
        }
        this.stxythreads[i].setConditions(basic, width, height, i * step, height, true, xGradient, yGradient);
        object = this.stxythreads[i].lock;
        synchronized (object) {
            this.stxythreads[i].lock.notify();
        }
        object = this;
        synchronized (object) {
            while (this.nbFreeCTCXGThreads != nbcpu) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        step = width / nbcpu;
        this.nbFreeCTCXGThreads = 0;
        for (i = 0; i < nbcpu - 1; ++i) {
            this.stxythreads[i].setConditions(basic, width, height, i * step, (i + 1) * step, false, xGradient, yGradient);
            object = this.stxythreads[i].lock;
            synchronized (object) {
                this.stxythreads[i].lock.notify();
                continue;
            }
        }
        this.stxythreads[i].setConditions(basic, width, height, i * step, width, false, xGradient, yGradient);
        object = this.stxythreads[i].lock;
        synchronized (object) {
            this.stxythreads[i].lock.notify();
        }
        object = this;
        synchronized (object) {
            while (this.nbFreeCTCXGThreads != nbcpu) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void dualToCardinal2D(float[] dual, float[] cardinal, int width, int height, int degree) {
        this.basicToCardinal2D(this.getBasicFromCardinal2D(dual, width, height, 2 * degree + 1), cardinal, width, height, degree);
    }

    private float[] getBasicFromCardinal2D() {
        float[] basic = new float[this.width * this.height];
        this.samplesToInterpolationCoefficient1D(this.image, this.width, this.height, 3, 0.0f, false, true, basic);
        this.samplesToInterpolationCoefficient1D(basic, this.width, this.height, 3, 0.0f, false, false, basic);
        return basic;
    }

    private float[] getBasicFromCardinal2D(float[] cardinal, int width, int height, int degree) {
        float[] basic = new float[width * height];
        this.samplesToInterpolationCoefficient1D(cardinal, width, height, degree, 0.0f, false, true, basic);
        this.samplesToInterpolationCoefficient1D(basic, width, height, degree, 0.0f, false, false, basic);
        return basic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float[] getHalfDual2D(float[] fullDual, int fullWidth, int fullHeight) {
        Object object;
        int i;
        int min;
        int halfWidth = fullWidth >> 1;
        int halfHeight = fullHeight >> 1;
        float[] demiDual = new float[halfWidth * fullHeight];
        float[] halfDual = new float[halfWidth * halfHeight];
        if (this.halfdualthreads == null) {
            this.nbFreeHalfDualThreads = 0;
            this.halfdualthreads = new HalfDualThread[this.nbCPU];
            for (int i2 = 0; i2 < this.nbCPU; ++i2) {
                this.halfdualthreads[i2] = new HalfDualThread();
                this.halfdualthreads[i2].start();
            }
            TurboRegImageFloat i2 = this;
            synchronized (i2) {
                while (this.nbFreeHalfDualThreads != this.nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        int nbcpu = Math.max(this.nbCPU << 5 < (min = Math.min(fullWidth, fullHeight)) ? this.nbCPU : min >> 5, 1);
        int step = fullHeight / nbcpu;
        this.nbFreeHalfDualThreads = 0;
        for (i = 0; i < nbcpu - 1; ++i) {
            this.halfdualthreads[i].setConditions(fullDual, fullWidth, fullHeight, i * step, (i + 1) * step, true, demiDual, halfDual, halfWidth, halfHeight);
            object = this.halfdualthreads[i].lock;
            synchronized (object) {
                this.halfdualthreads[i].lock.notify();
                continue;
            }
        }
        this.halfdualthreads[i].setConditions(fullDual, fullWidth, fullHeight, i * step, fullHeight, true, demiDual, halfDual, halfWidth, halfHeight);
        object = this.halfdualthreads[i].lock;
        synchronized (object) {
            this.halfdualthreads[i].lock.notify();
        }
        object = this;
        synchronized (object) {
            while (this.nbFreeHalfDualThreads != nbcpu) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        min = Math.min(halfWidth, fullHeight);
        nbcpu = Math.max(this.nbCPU << 5 < min ? this.nbCPU : min >> 5, 1);
        step = halfWidth / nbcpu;
        this.nbFreeHalfDualThreads = 0;
        for (i = 0; i < nbcpu - 1; ++i) {
            this.halfdualthreads[i].setConditions(fullDual, fullWidth, fullHeight, i * step, (i + 1) * step, false, demiDual, halfDual, halfWidth, halfHeight);
            object = this.halfdualthreads[i].lock;
            synchronized (object) {
                this.halfdualthreads[i].lock.notify();
                continue;
            }
        }
        this.halfdualthreads[i].setConditions(fullDual, fullWidth, fullHeight, i * step, halfWidth, false, demiDual, halfDual, halfWidth, halfHeight);
        object = this.halfdualthreads[i].lock;
        synchronized (object) {
            this.halfdualthreads[i].lock.notify();
        }
        object = this;
        synchronized (object) {
            while (this.nbFreeHalfDualThreads != nbcpu) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        return halfDual;
    }

    private void imageToXYGradient2D() {
        this.xGradient = new float[this.width * this.height];
        this.yGradient = new float[this.width * this.height];
        this.samplesToInterpolationCoefficient1D(this.image, this.width, this.height, 3, 0.0f, true, true, this.xGradient);
        this.samplesToInterpolationCoefficient1D(this.image, this.width, this.height, 3, 0.0f, true, false, this.yGradient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void samplesToInterpolationCoefficient1D(float[] input, int width, int height, int degree, float tolerance, boolean coefficientToGradient1D, boolean horizontal, float[] output) {
        Object object;
        int i;
        int nbcpu;
        if (horizontal && width == 1 || !horizontal && height == 1) {
            return;
        }
        float[] z = null;
        switch (degree) {
            case 3: {
                z = new float[]{(float)Math.sqrt(3.0) - 2.0f};
                break;
            }
            case 7: {
                z = new float[]{-0.5352804f, -0.122554615f, -0.009148695f};
            }
        }
        if (this.interthreads == null) {
            this.nbFreeInterThreads = 0;
            this.interthreads = new InterpolationThread[this.nbCPU];
            for (int i2 = 0; i2 < this.nbCPU; ++i2) {
                this.interthreads[i2] = new InterpolationThread();
                this.interthreads[i2].start();
            }
            TurboRegImageFloat i2 = this;
            synchronized (i2) {
                while (this.nbFreeInterThreads != this.nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        int step = -1;
        int last = -1;
        if (horizontal) {
            nbcpu = Math.max(this.nbCPU << 5 < height ? this.nbCPU : height >> 5, 1);
            step = height / nbcpu;
            last = height;
        } else {
            nbcpu = Math.max(this.nbCPU << 5 < width ? this.nbCPU : width >> 5, 1);
            step = width / nbcpu;
            last = width;
        }
        this.nbFreeInterThreads = 0;
        for (i = 0; i < nbcpu - 1; ++i) {
            this.interthreads[i].setConditions(input, width, height, i * step, (i + 1) * step, z, tolerance, horizontal, coefficientToGradient1D, output);
            object = this.interthreads[i].lock;
            synchronized (object) {
                this.interthreads[i].lock.notify();
                continue;
            }
        }
        this.interthreads[i].setConditions(input, width, height, i * step, last, z, tolerance, horizontal, coefficientToGradient1D, output);
        object = this.interthreads[i].lock;
        synchronized (object) {
            this.interthreads[i].lock.notify();
        }
        object = this;
        synchronized (object) {
            while (this.nbFreeInterThreads != nbcpu) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected synchronized void addFreeHalfDualThread() {
        ++this.nbFreeHalfDualThreads;
        this.notify();
    }

    protected synchronized void addFreeCTCXGThread() {
        ++this.nbFreeCTCXGThreads;
        this.notify();
    }

    protected synchronized void addFreeSymmetricThread() {
        ++this.nbFreeSymmetricThreads;
        this.notify();
    }

    protected synchronized void addFreeInterpolationThread() {
        ++this.nbFreeInterThreads;
        this.notify();
    }

    private final class InterpolationThread
    extends Thread {
        public Object lock = new Object();
        private boolean Kill = false;
        private int min;
        private int max;
        private boolean X = true;
        private final float[] h = new float[]{0.0f, 0.5f};
        private float[] vline;
        private float[] hline;
        private float[] hdata;
        private float[] vdata;
        private float[] z = null;
        private float tolerance;
        private float[] input;
        private float[] output;
        private boolean coefficientToGradient1D = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.vdata = null;
            this.hdata = null;
            this.hline = null;
            this.vline = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(float[] input, int width, int height, int min, int max, float[] z, float tolerance, boolean X, boolean coefficientToGradient1D, float[] output) {
            this.input = input;
            if (this.hline == null || this.hline.length != width) {
                this.hdata = new float[width];
                this.hline = new float[width];
            }
            if (this.vline == null || this.vline.length != height) {
                this.vdata = new float[height];
                this.vline = new float[height];
            }
            this.min = min;
            this.max = max;
            this.z = z;
            this.tolerance = tolerance;
            this.X = X;
            this.coefficientToGradient1D = coefficientToGradient1D;
            this.output = output;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.isInterrupted()) {
                int n;
                float zz;
                int pos;
                int i;
                int r;
                int k;
                Object object = this.lock;
                synchronized (object) {
                    try {
                        TurboRegImageFloat.this.addFreeInterpolationThread();
                        this.lock.wait();
                        if (this.Kill) {
                            this.interrupt();
                            break;
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                int W = this.hline.length;
                int H = this.vline.length;
                float lambda = 1.0f;
                for (k = 0; k < this.z.length; ++k) {
                    lambda *= (1.0f - this.z[k]) * (1.0f - 1.0f / this.z[k]);
                }
                if (this.X) {
                    for (r = this.min; r < this.max; ++r) {
                        i = 0;
                        pos = r * W;
                        while (i < W) {
                            this.hline[i] = this.input[pos] * lambda;
                            ++i;
                            ++pos;
                        }
                        for (k = 0; k < this.z.length; ++k) {
                            zz = this.z[k];
                            this.hline[0] = this.getInitialCausalCoefficientMirrorOffBoundsin(this.hline, zz, this.tolerance);
                            for (n = 1; n < W; ++n) {
                                int n2 = n;
                                this.hline[n2] = this.hline[n2] + zz * this.hline[n - 1];
                            }
                            this.hline[W - 1] = zz * this.hline[W - 1] / (zz - 1.0f);
                            for (n = W - 2; 0 <= n; --n) {
                                this.hline[n] = zz * (this.hline[n + 1] - this.hline[n]);
                            }
                        }
                        if (this.coefficientToGradient1D) {
                            this.antiSymmetricFirMirrorOffBounds1Din(this.h, this.hline, this.hdata);
                        }
                        i = 0;
                        pos = r * W;
                        while (i < W) {
                            this.output[pos] = this.hline[i];
                            ++i;
                            ++pos;
                        }
                    }
                } else {
                    for (r = this.min; r < this.max; ++r) {
                        i = 0;
                        pos = r;
                        while (i < H) {
                            this.vline[i] = this.input[pos] * lambda;
                            ++i;
                            pos += W;
                        }
                        for (k = 0; k < this.z.length; ++k) {
                            zz = this.z[k];
                            this.vline[0] = this.getInitialCausalCoefficientMirrorOffBoundsin(this.vline, zz, this.tolerance);
                            for (n = 1; n < H; ++n) {
                                int n3 = n;
                                this.vline[n3] = this.vline[n3] + zz * this.vline[n - 1];
                            }
                            this.vline[H - 1] = zz * this.vline[H - 1] / (zz - 1.0f);
                            for (n = H - 2; 0 <= n; --n) {
                                this.vline[n] = zz * (this.vline[n + 1] - this.vline[n]);
                            }
                        }
                        if (this.coefficientToGradient1D) {
                            this.antiSymmetricFirMirrorOffBounds1Din(this.h, this.vline, this.vdata);
                        }
                        i = 0;
                        pos = r;
                        while (i < H) {
                            this.output[pos] = this.vline[i];
                            ++i;
                            pos += W;
                        }
                    }
                }
                this.z = null;
                this.output = null;
                this.input = null;
            }
        }

        private float getInitialCausalCoefficientMirrorOffBoundsin(float[] c, float z, float tolerance) {
            float z1 = z;
            float zn = Maths.Power(z, c.length);
            float sum = (1.0f + z) * (c[0] + zn * c[c.length - 1]);
            int horizon = c.length;
            if (0.0 < (double)tolerance) {
                horizon = 2 + (int)(Math.log(tolerance) / Math.log(Math.abs(z)));
                horizon = horizon < c.length ? horizon : c.length;
            }
            int size = horizon - 1;
            zn *= zn;
            for (int n = 1; n < size; ++n) {
                sum += ((z1 *= z) + (zn /= z)) * c[n];
            }
            return sum / (1.0f - Maths.Power(z, c.length << 1));
        }

        private void antiSymmetricFirMirrorOffBounds1Din(float[] h, float[] c, float[] s) {
            if (2 <= c.length) {
                int sl1 = s.length - 1;
                s[0] = h[1] * (c[1] - c[0]);
                for (int i = 1; i < sl1; ++i) {
                    s[i] = h[1] * (c[i + 1] - c[i - 1]);
                }
                s[sl1] = h[1] * (c[c.length - 1] - c[c.length - 2]);
            } else {
                s[0] = 0.0f;
            }
            System.arraycopy(s, 0, c, 0, s.length);
        }
    }

    private final class SymmetricThread
    extends Thread {
        public Object lock = new Object();
        private boolean Kill = false;
        private int min;
        private int max;
        private boolean X = true;
        private float[] vline;
        private float[] hline;
        private float[] vdata;
        private float[] hdata;
        private float[] h = null;
        private float[] input;
        private float[] output;
        private int Width;
        private int Height;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.hline = null;
            this.vline = null;
            this.hdata = null;
            this.vdata = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(float[] input, int width, int height, int min, int max, float[] h, boolean X, float[] output) {
            this.input = input;
            this.Width = width;
            this.Height = height;
            if (this.vline == null || this.vline.length != height) {
                this.vline = new float[height];
                this.vdata = new float[height];
            }
            if (this.hline == null || this.hline.length != width) {
                this.hline = new float[width];
                this.hdata = new float[width];
            }
            this.min = min;
            this.max = max;
            this.h = h;
            this.X = X;
            this.output = output;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.isInterrupted()) {
                int r;
                Object object = this.lock;
                synchronized (object) {
                    try {
                        TurboRegImageFloat.this.addFreeSymmetricThread();
                        this.lock.wait();
                        if (this.Kill) {
                            this.interrupt();
                            break;
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                if (this.X) {
                    for (r = this.min; r < this.max; ++r) {
                        System.arraycopy(this.input, r * this.Width, this.hline, 0, this.Width);
                        this.symmetricFirMirrorOffBounds1Din(this.h, this.hline, this.hdata);
                        System.arraycopy(this.hdata, 0, this.output, r * this.Width, this.Width);
                    }
                } else {
                    for (r = this.min; r < this.max; ++r) {
                        int i = 0;
                        int pos = r;
                        while (i < this.Height) {
                            this.vline[i] = this.input[pos];
                            ++i;
                            pos += this.Width;
                        }
                        this.symmetricFirMirrorOffBounds1Din(this.h, this.vline, this.vdata);
                        i = 0;
                        pos = r;
                        while (i < this.Height) {
                            this.output[pos] = this.vdata[i];
                            ++i;
                            pos += this.Width;
                        }
                    }
                }
                this.h = null;
                this.output = null;
                this.input = null;
            }
        }

        private void symmetricFirMirrorOffBounds1Din(float[] h, float[] c, float[] s) {
            block0 : switch (h.length) {
                case 2: {
                    if (2 <= c.length) {
                        s[0] = h[0] * c[0] + h[1] * (c[0] + c[1]);
                        int end = s.length - 1;
                        for (int i = 1; i < end; ++i) {
                            s[i] = h[0] * c[i] + h[1] * (c[i - 1] + c[i + 1]);
                        }
                        s[s.length - 1] = h[0] * c[c.length - 1] + h[1] * (c[c.length - 2] + c[c.length - 1]);
                        break;
                    }
                    s[0] = (h[0] + 2.0f * h[1]) * c[0];
                    break;
                }
                case 4: {
                    if (6 <= c.length) {
                        s[0] = h[0] * c[0] + h[1] * (c[0] + c[1]) + h[2] * (c[1] + c[2]) + h[3] * (c[2] + c[3]);
                        s[1] = h[0] * c[1] + h[1] * (c[0] + c[2]) + h[2] * (c[0] + c[3]) + h[3] * (c[1] + c[4]);
                        s[2] = h[0] * c[2] + h[1] * (c[1] + c[3]) + h[2] * (c[0] + c[4]) + h[3] * (c[0] + c[5]);
                        int end = s.length - 3;
                        for (int i = 3; i < end; ++i) {
                            s[i] = h[0] * c[i] + h[1] * (c[i - 1] + c[i + 1]) + h[2] * (c[i - 2] + c[i + 2]) + h[3] * (c[i - 3] + c[i + 3]);
                        }
                        s[s.length - 3] = h[0] * c[c.length - 3] + h[1] * (c[c.length - 4] + c[c.length - 2]) + h[2] * (c[c.length - 5] + c[c.length - 1]) + h[3] * (c[c.length - 6] + c[c.length - 1]);
                        s[s.length - 2] = h[0] * c[c.length - 2] + h[1] * (c[c.length - 3] + c[c.length - 1]) + h[2] * (c[c.length - 4] + c[c.length - 1]) + h[3] * (c[c.length - 5] + c[c.length - 2]);
                        s[s.length - 1] = h[0] * c[c.length - 1] + h[1] * (c[c.length - 2] + c[c.length - 1]) + h[2] * (c[c.length - 3] + c[c.length - 2]) + h[3] * (c[c.length - 4] + c[c.length - 3]);
                        break;
                    }
                    switch (c.length) {
                        case 5: {
                            s[0] = h[0] * c[0] + h[1] * (c[0] + c[1]) + h[2] * (c[1] + c[2]) + h[3] * (c[2] + c[3]);
                            s[1] = h[0] * c[1] + h[1] * (c[0] + c[2]) + h[2] * (c[0] + c[3]) + h[3] * (c[1] + c[4]);
                            s[2] = h[0] * c[2] + h[1] * (c[1] + c[3]) + (h[2] + h[3]) * (c[0] + c[4]);
                            s[3] = h[0] * c[3] + h[1] * (c[2] + c[4]) + h[2] * (c[1] + c[4]) + h[3] * (c[0] + c[3]);
                            s[4] = h[0] * c[4] + h[1] * (c[3] + c[4]) + h[2] * (c[2] + c[3]) + h[3] * (c[1] + c[2]);
                            break block0;
                        }
                        case 4: {
                            s[0] = h[0] * c[0] + h[1] * (c[0] + c[1]) + h[2] * (c[1] + c[2]) + h[3] * (c[2] + c[3]);
                            s[1] = h[0] * c[1] + h[1] * (c[0] + c[2]) + h[2] * (c[0] + c[3]) + h[3] * (c[1] + c[3]);
                            s[2] = h[0] * c[2] + h[1] * (c[1] + c[3]) + h[2] * (c[0] + c[3]) + h[3] * (c[0] + c[2]);
                            s[3] = h[0] * c[3] + h[1] * (c[2] + c[3]) + h[2] * (c[1] + c[2]) + h[3] * (c[0] + c[1]);
                            break block0;
                        }
                        case 3: {
                            s[0] = h[0] * c[0] + h[1] * (c[0] + c[1]) + h[2] * (c[1] + c[2]) + 2.0f * h[3] * c[2];
                            s[1] = h[0] * c[1] + (h[1] + h[2]) * (c[0] + c[2]) + 2.0f * h[3] * c[1];
                            s[2] = h[0] * c[2] + h[1] * (c[1] + c[2]) + h[2] * (c[0] + c[1]) + 2.0f * h[3] * c[0];
                            break block0;
                        }
                        case 2: {
                            s[0] = (h[0] + h[1] + h[3]) * c[0] + (h[1] + 2.0f * h[2] + h[3]) * c[1];
                            s[1] = (h[0] + h[1] + h[3]) * c[1] + (h[1] + 2.0f * h[2] + h[3]) * c[0];
                            break block0;
                        }
                        case 1: {
                            s[0] = (h[0] + 2.0f * (h[1] + h[2] + h[3])) * c[0];
                        }
                    }
                }
            }
        }
    }

    private final class CoefToXYGThread
    extends Thread {
        public Object lock = new Object();
        private boolean Kill = false;
        private int min;
        private int max;
        private boolean X = true;
        private float[] vline;
        private float[] hline;
        private float[] hdata;
        private float[] input;
        private float[] xGradient;
        private float[] yGradient;
        private int Width;
        private int Height;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.hdata = null;
            this.vline = null;
            this.hline = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(float[] input, int width, int height, int min, int max, boolean X, float[] xGradient, float[] yGradient) {
            this.input = input;
            this.Width = width;
            this.Height = height;
            if (this.vline == null || this.vline.length != height) {
                this.vline = new float[height];
            }
            if (this.hline == null || this.hline.length != width) {
                this.hline = new float[width];
                this.hdata = new float[width];
            }
            this.min = min;
            this.max = max;
            this.X = X;
            this.xGradient = xGradient;
            this.yGradient = yGradient;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.isInterrupted()) {
                int pos;
                int r;
                Object object = this.lock;
                synchronized (object) {
                    try {
                        TurboRegImageFloat.this.addFreeCTCXGThread();
                        this.lock.wait();
                        if (this.Kill) {
                            this.interrupt();
                            break;
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                if (this.X) {
                    r = this.min;
                    pos = r * this.Width;
                    while (r < this.max) {
                        System.arraycopy(this.input, pos, this.hline, 0, this.Width);
                        System.arraycopy(this.hline, 0, this.hdata, 0, this.Width);
                        this.coefficientToGradient1Din(this.hline);
                        this.coefficientToSamples1Din(this.hdata);
                        System.arraycopy(this.hline, 0, this.xGradient, pos, this.Width);
                        System.arraycopy(this.hdata, 0, this.yGradient, pos, this.Width);
                        ++r;
                        pos += this.Width;
                    }
                } else {
                    for (r = this.min; r < this.max; ++r) {
                        int i = 0;
                        pos = r;
                        while (i < this.Height) {
                            this.vline[i] = this.xGradient[pos];
                            ++i;
                            pos += this.Width;
                        }
                        this.coefficientToSamples1Din(this.vline);
                        i = 0;
                        pos = r;
                        while (i < this.Height) {
                            this.xGradient[pos] = this.vline[i];
                            ++i;
                            pos += this.Width;
                        }
                        i = 0;
                        pos = r;
                        while (i < this.Height) {
                            this.vline[i] = this.yGradient[pos];
                            ++i;
                            pos += this.Width;
                        }
                        this.coefficientToGradient1Din(this.vline);
                        i = 0;
                        pos = r;
                        while (i < this.Height) {
                            this.yGradient[pos] = this.vline[i];
                            ++i;
                            pos += this.Width;
                        }
                    }
                }
                this.yGradient = null;
                this.xGradient = null;
                this.input = null;
            }
        }

        private void coefficientToSamples1Din(float[] c) {
            float[] h = new float[]{0.6666667f, 0.16666667f};
            float[] s = new float[c.length];
            this.symmetricFirMirrorOffBounds1Din(h, c, s);
            System.arraycopy(s, 0, c, 0, s.length);
        }

        private void symmetricFirMirrorOffBounds1Din(float[] h, float[] c, float[] s) {
            block0 : switch (h.length) {
                case 2: {
                    if (2 <= c.length) {
                        s[0] = h[0] * c[0] + h[1] * (c[0] + c[1]);
                        int end = s.length - 1;
                        for (int i = 1; i < end; ++i) {
                            s[i] = h[0] * c[i] + h[1] * (c[i - 1] + c[i + 1]);
                        }
                        s[s.length - 1] = h[0] * c[c.length - 1] + h[1] * (c[c.length - 2] + c[c.length - 1]);
                        break;
                    }
                    s[0] = (h[0] + 2.0f * h[1]) * c[0];
                    break;
                }
                case 4: {
                    if (6 <= c.length) {
                        s[0] = h[0] * c[0] + h[1] * (c[0] + c[1]) + h[2] * (c[1] + c[2]) + h[3] * (c[2] + c[3]);
                        s[1] = h[0] * c[1] + h[1] * (c[0] + c[2]) + h[2] * (c[0] + c[3]) + h[3] * (c[1] + c[4]);
                        s[2] = h[0] * c[2] + h[1] * (c[1] + c[3]) + h[2] * (c[0] + c[4]) + h[3] * (c[0] + c[5]);
                        int end = s.length - 3;
                        for (int i = 3; i < end; ++i) {
                            s[i] = h[0] * c[i] + h[1] * (c[i - 1] + c[i + 1]) + h[2] * (c[i - 2] + c[i + 2]) + h[3] * (c[i - 3] + c[i + 3]);
                        }
                        s[s.length - 3] = h[0] * c[c.length - 3] + h[1] * (c[c.length - 4] + c[c.length - 2]) + h[2] * (c[c.length - 5] + c[c.length - 1]) + h[3] * (c[c.length - 6] + c[c.length - 1]);
                        s[s.length - 2] = h[0] * c[c.length - 2] + h[1] * (c[c.length - 3] + c[c.length - 1]) + h[2] * (c[c.length - 4] + c[c.length - 1]) + h[3] * (c[c.length - 5] + c[c.length - 2]);
                        s[s.length - 1] = h[0] * c[c.length - 1] + h[1] * (c[c.length - 2] + c[c.length - 1]) + h[2] * (c[c.length - 3] + c[c.length - 2]) + h[3] * (c[c.length - 4] + c[c.length - 3]);
                        break;
                    }
                    switch (c.length) {
                        case 5: {
                            s[0] = h[0] * c[0] + h[1] * (c[0] + c[1]) + h[2] * (c[1] + c[2]) + h[3] * (c[2] + c[3]);
                            s[1] = h[0] * c[1] + h[1] * (c[0] + c[2]) + h[2] * (c[0] + c[3]) + h[3] * (c[1] + c[4]);
                            s[2] = h[0] * c[2] + h[1] * (c[1] + c[3]) + (h[2] + h[3]) * (c[0] + c[4]);
                            s[3] = h[0] * c[3] + h[1] * (c[2] + c[4]) + h[2] * (c[1] + c[4]) + h[3] * (c[0] + c[3]);
                            s[4] = h[0] * c[4] + h[1] * (c[3] + c[4]) + h[2] * (c[2] + c[3]) + h[3] * (c[1] + c[2]);
                            break block0;
                        }
                        case 4: {
                            s[0] = h[0] * c[0] + h[1] * (c[0] + c[1]) + h[2] * (c[1] + c[2]) + h[3] * (c[2] + c[3]);
                            s[1] = h[0] * c[1] + h[1] * (c[0] + c[2]) + h[2] * (c[0] + c[3]) + h[3] * (c[1] + c[3]);
                            s[2] = h[0] * c[2] + h[1] * (c[1] + c[3]) + h[2] * (c[0] + c[3]) + h[3] * (c[0] + c[2]);
                            s[3] = h[0] * c[3] + h[1] * (c[2] + c[3]) + h[2] * (c[1] + c[2]) + h[3] * (c[0] + c[1]);
                            break block0;
                        }
                        case 3: {
                            s[0] = h[0] * c[0] + h[1] * (c[0] + c[1]) + h[2] * (c[1] + c[2]) + 2.0f * h[3] * c[2];
                            s[1] = h[0] * c[1] + (h[1] + h[2]) * (c[0] + c[2]) + 2.0f * h[3] * c[1];
                            s[2] = h[0] * c[2] + h[1] * (c[1] + c[2]) + h[2] * (c[0] + c[1]) + 2.0f * h[3] * c[0];
                            break block0;
                        }
                        case 2: {
                            s[0] = (h[0] + h[1] + h[3]) * c[0] + (h[1] + 2.0f * h[2] + h[3]) * c[1];
                            s[1] = (h[0] + h[1] + h[3]) * c[1] + (h[1] + 2.0f * h[2] + h[3]) * c[0];
                            break block0;
                        }
                        case 1: {
                            s[0] = (h[0] + 2.0f * (h[1] + h[2] + h[3])) * c[0];
                        }
                    }
                }
            }
        }

        private void coefficientToGradient1Din(float[] c) {
            float[] h = new float[]{0.0f, 0.5f};
            float[] s = new float[c.length];
            this.antiSymmetricFirMirrorOffBounds1Din(h, c, s);
            System.arraycopy(s, 0, c, 0, s.length);
        }

        private void antiSymmetricFirMirrorOffBounds1Din(float[] h, float[] c, float[] s) {
            if (2 <= c.length) {
                int sl1 = s.length - 1;
                s[0] = h[1] * (c[1] - c[0]);
                for (int i = 1; i < sl1; ++i) {
                    s[i] = h[1] * (c[i + 1] - c[i - 1]);
                }
                s[sl1] = h[1] * (c[c.length - 1] - c[c.length - 2]);
            } else {
                s[0] = 0.0f;
            }
        }
    }

    private final class HalfDualThread
    extends Thread {
        public Object lock = new Object();
        private boolean Kill = false;
        private int min;
        private int max;
        private boolean X = true;
        private float[] vline;
        private float[] hline;
        private float[] hdata;
        private float[] vdata;
        private float[] fullDual;
        private float[] demiDual;
        private float[] halfDual;
        private int fullWidth;
        private int halfWidth;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.vdata = null;
            this.hdata = null;
            this.vline = null;
            this.hline = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(float[] fullDual, int fullWidth, int fullHeight, int min, int max, boolean X, float[] demiDual, float[] halfDual, int halfWidth, int halfHeight) {
            this.fullDual = fullDual;
            this.fullWidth = fullWidth;
            if (this.vline == null || this.vline.length != fullHeight) {
                this.vline = new float[fullHeight];
                this.vdata = new float[halfHeight];
            }
            if (this.hline == null || this.hline.length != fullWidth) {
                this.hline = new float[fullWidth];
                this.hdata = new float[halfWidth];
            }
            this.min = min;
            this.max = max;
            this.X = X;
            this.demiDual = demiDual;
            this.halfDual = halfDual;
            this.halfWidth = halfWidth;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.isInterrupted()) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        TurboRegImageFloat.this.addFreeHalfDualThread();
                        this.lock.wait();
                        if (this.Kill) {
                            this.interrupt();
                            break;
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                if (this.X) {
                    for (int y = this.min; y < this.max; ++y) {
                        System.arraycopy(this.fullDual, y * this.fullWidth, this.hline, 0, this.fullWidth);
                        this.reduceDual1D(this.hline, this.hdata);
                        System.arraycopy(this.hdata, 0, this.demiDual, y * this.halfWidth, this.halfWidth);
                    }
                } else {
                    for (int x = this.min; x < this.max; ++x) {
                        int i = 0;
                        int pos = x;
                        while (i < this.vline.length) {
                            this.vline[i] = this.demiDual[pos];
                            ++i;
                            pos += this.halfWidth;
                        }
                        this.reduceDual1D(this.vline, this.vdata);
                        i = 0;
                        pos = x;
                        while (i < this.vdata.length) {
                            this.halfDual[pos] = this.vdata[i];
                            ++i;
                            pos += this.halfWidth;
                        }
                    }
                }
                this.demiDual = null;
                this.halfDual = null;
                this.fullDual = null;
            }
        }

        private void reduceDual1D(float[] c, float[] s) {
            float[] h = new float[]{0.375f, 0.25f, 0.0625f};
            if (2 <= s.length) {
                s[0] = h[0] * c[0] + h[1] * (c[0] + c[1]) + h[2] * (c[1] + c[2]);
                int i = 2;
                for (int j = 1; j < s.length - 1; ++j) {
                    s[j] = h[0] * c[i] + h[1] * (c[i - 1] + c[i + 1]) + h[2] * (c[i - 2] + c[i + 2]);
                    i += 2;
                }
                s[s.length - 1] = c.length == 2 * s.length ? h[0] * c[c.length - 2] + h[1] * (c[c.length - 3] + c[c.length - 1]) + h[2] * (c[c.length - 4] + c[c.length - 1]) : h[0] * c[c.length - 3] + h[1] * (c[c.length - 4] + c[c.length - 2]) + h[2] * (c[c.length - 5] + c[c.length - 1]);
            } else {
                switch (c.length) {
                    case 3: {
                        s[0] = h[0] * c[0] + h[1] * (c[0] + c[1]) + h[2] * (c[1] + c[2]);
                        break;
                    }
                    case 2: {
                        s[0] = h[0] * c[0] + h[1] * (c[0] + c[1]) + 2.0f * h[2] * c[1];
                    }
                }
            }
        }
    }
}

