/*
 * Decompiled with CFR 0.152.
 */
package processing.filters.gradients;

import arrayTiTi.ArrayArithmetic;
import arrayTiTi.ArrayComparator;
import arrayTiTi.ArrayConverter;
import arrayTiTi.ArrayFeatures;
import dv.DV;
import dv.DvNew;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mathematics.primitives.pointsTiTi.CoordinatesWeighted;
import morphee.MorphoFilter;
import morphee.StructuringElement;
import morphee.StructuringElement3D;
import processing.filters.DynamicExpansion;
import processing.filters.gradients.SignalGradient;
import utils.memory.Allocator;

public class Gradient
implements MorphoFilter,
SignalGradient {
    private final Allocator allocator = Allocator.Instance();
    private int HowCorrect = 0;
    private double CoefNeg = 0.0;
    private double CoefPos = 0.0;
    private DynamicExpansion de = new DynamicExpansion();
    private ArrayFeatures AF = new ArrayFeatures();
    private StructuringElement se = null;
    private StructuringElement3D se3d = null;
    private int MAX = 255;
    private Image_Gradient_IntSE_Intdata_Thread[] imintintthreads = null;
    private Image_Gradient_IntSE_Doubledata_Thread[] imintdoublethreads = null;
    private Image_Gradient_DoubleSE_Intdata_Thread[] imdoubleintthreads = null;
    private DV_Gradient_IntSE_Intdata_Thread[] dvintintthreads = null;
    private DV_Gradient_IntSE_Doubledata_Thread[] dvintdoublethreads = null;
    private DV_Gradient_DoubleSE_Intdata_Thread[] dvdoubleintthreads = null;
    private int nbFreeThreads = 0;

    @Override
    public void Kill() {
        int i;
        if (this.imintintthreads != null) {
            for (i = 0; i < this.imintintthreads.length; ++i) {
                this.imintintthreads[i].Kill();
                this.imintintthreads[i] = null;
            }
            this.imintintthreads = null;
        }
        if (this.imintdoublethreads != null) {
            for (i = 0; i < this.imintdoublethreads.length; ++i) {
                this.imintdoublethreads[i].Kill();
                this.imintdoublethreads[i] = null;
            }
            this.imintdoublethreads = null;
        }
        if (this.imdoubleintthreads != null) {
            for (i = 0; i < this.imdoubleintthreads.length; ++i) {
                this.imdoubleintthreads[i].Kill();
                this.imdoubleintthreads[i] = null;
            }
            this.imdoubleintthreads = null;
        }
        if (this.dvintintthreads != null) {
            for (i = 0; i < this.dvintintthreads.length; ++i) {
                this.dvintintthreads[i].Kill();
                this.dvintintthreads[i] = null;
            }
            this.dvintintthreads = null;
        }
        if (this.dvdoubleintthreads != null) {
            for (i = 0; i < this.dvdoubleintthreads.length; ++i) {
                this.dvdoubleintthreads[i].Kill();
                this.dvdoubleintthreads[i] = null;
            }
            this.dvdoubleintthreads = null;
        }
        if (this.dvintdoublethreads != null) {
            for (i = 0; i < this.dvintdoublethreads.length; ++i) {
                this.dvintdoublethreads[i].Kill();
                this.dvintdoublethreads[i] = null;
            }
            this.dvintdoublethreads = null;
        }
        this.se = null;
        this.se3d = null;
        this.de.Kill();
        this.de = null;
        this.AF = null;
    }

    @Override
    public BufferedImage Filter(BufferedImage source, StructuringElement se, int nbCPU) {
        BufferedImage res = ImageNew.Same(source);
        this.Filter(source, se, res, nbCPU);
        return res;
    }

    @Override
    public void Filter(BufferedImage source, StructuringElement se, BufferedImage result, int nbCPU) {
        this.setStructuringElement(se);
        this.Filter(source, result, nbCPU);
    }

    @Override
    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage res = ImageNew.Same(source);
        this.Filter(source, res, nbCPU);
        return res;
    }

    @Override
    public void Filter(BufferedImage source, BufferedImage Result, int nbCPU) {
        if (ImageTools.isColored(source) || ImageTools.isColored(Result)) {
            throw new IllegalArgumentException("Only gray level or binary images supported.");
        }
        if (!ImageTools.areDimensionsEqual(source, Result)) {
            throw new IllegalArgumentException("Images source and result must have identic dimensions.");
        }
        if (this.se == null) {
            throw new NullPointerException("Any structuring element defined.");
        }
        this.se.PreComputePositions(source.getWidth());
        this.FindCoefSum();
        block0 : switch (source.getType()) {
            case 10: 
            case 11: {
                if (this.se.hasIntWeights()) {
                    this.FilterIntSEIntData(source, Result, nbCPU);
                    break;
                }
                this.FilterDoubleSEIntData(source, Result, nbCPU);
                break;
            }
            case 0: {
                switch (source.getRaster().getDataBuffer().getDataType()) {
                    case 4: 
                    case 5: {
                        if (this.se.hasIntWeights()) {
                            this.FilterIntSEDoubleData(source, Result, nbCPU);
                            break block0;
                        }
                        throw new IllegalStateException("Configuration Double SE Double/Float Data not supported (yet)");
                    }
                    case 3: {
                        if (this.se.hasIntWeights()) {
                            this.FilterIntSEIntData(source, Result, nbCPU);
                            break block0;
                        }
                        this.FilterDoubleSEIntData(source, Result, nbCPU);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void FilterIntSEIntData(BufferedImage source, BufferedImage Result, int nbCPU) {
        Object object;
        int i;
        int width = source.getWidth();
        int height = source.getHeight();
        int length = width * height;
        int step = height / nbCPU;
        int[] tmpres = this.allocator.newIntArray(length);
        if (this.imintintthreads == null || this.imintintthreads.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.imintintthreads = null;
            this.imintintthreads = new Image_Gradient_IntSE_Intdata_Thread[nbCPU];
            for (i = 0; i < nbCPU; ++i) {
                this.imintintthreads[i] = new Image_Gradient_IntSE_Intdata_Thread();
                this.imintintthreads[i].start();
            }
            object = this;
            synchronized (object) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.nbFreeThreads = 0;
        for (i = 0; i < nbCPU - 1; ++i) {
            this.imintintthreads[i].setConditions(source, tmpres, this.se, i * step, (i + 1) * step);
            object = this.imintintthreads[i].lock;
            synchronized (object) {
                this.imintintthreads[i].lock.notify();
                continue;
            }
        }
        this.imintintthreads[i].setConditions(source, tmpres, this.se, i * step, height);
        object = this.imintintthreads[i].lock;
        synchronized (object) {
            this.imintintthreads[i].lock.notify();
        }
        object = this;
        synchronized (object) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        switch (Result.getType()) {
            case 10: {
                this.MAX = 255;
                break;
            }
            case 11: {
                this.MAX = 65535;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported image type.");
            }
        }
        switch (this.HowCorrect) {
            case 0: {
                break;
            }
            case 4: {
                ArrayArithmetic.Abs(tmpres, tmpres);
                break;
            }
            case 2: {
                ArrayArithmetic.Abs(tmpres, tmpres);
                this.CoefPos = Math.max(-this.CoefNeg, this.CoefPos);
                this.CoefNeg = 0.0;
            }
            case 1: {
                this.de.Filter(tmpres, tmpres, (int)(this.CoefNeg * (double)this.MAX - 0.5), (int)(this.CoefPos * (double)this.MAX + 0.5), 0, this.MAX);
                break;
            }
            case 3: {
                ArrayComparator.Compare(tmpres, "<=", this.MAX, tmpres, this.MAX, tmpres);
                ArrayComparator.Compare(tmpres, ">=", 0, tmpres, 0, tmpres);
                break;
            }
            default: {
                throw new IllegalArgumentException("Correction value unknown.");
            }
        }
        block21 : switch (Result.getType()) {
            case 10: {
                ArrayConverter.IntToByte(tmpres, ((DataBufferByte)Result.getRaster().getDataBuffer()).getData());
                break;
            }
            case 11: {
                ArrayConverter.IntToShort(tmpres, ((DataBufferUShort)Result.getRaster().getDataBuffer()).getData());
                break;
            }
            case 0: {
                switch (Result.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        System.arraycopy(tmpres, 0, ((DataBufferInt)Result.getRaster().getDataBuffer()).getData(), 0, length);
                        break block21;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        tmpres = this.allocator.Release(tmpres);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void FilterDoubleSEIntData(BufferedImage source, BufferedImage Result, int nbCPU) {
        Object object;
        int i;
        int width = source.getWidth();
        int height = source.getHeight();
        int length = width * height;
        int[] tmpres = this.allocator.newIntArray(length);
        if (this.imdoubleintthreads == null || this.imdoubleintthreads.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.imdoubleintthreads = null;
            this.imdoubleintthreads = new Image_Gradient_DoubleSE_Intdata_Thread[nbCPU];
            for (int i2 = 0; i2 < nbCPU; ++i2) {
                this.imdoubleintthreads[i2] = new Image_Gradient_DoubleSE_Intdata_Thread();
                this.imdoubleintthreads[i2].start();
            }
            Gradient i2 = this;
            synchronized (i2) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.nbFreeThreads = 0;
        int step = height / nbCPU;
        for (i = 0; i < nbCPU - 1; ++i) {
            this.imdoubleintthreads[i].setConditions(source, tmpres, this.se, i * step, (i + 1) * step);
            object = this.imdoubleintthreads[i].lock;
            synchronized (object) {
                this.imdoubleintthreads[i].lock.notify();
                continue;
            }
        }
        this.imdoubleintthreads[i].setConditions(source, tmpres, this.se, i * step, height);
        object = this.imdoubleintthreads[i].lock;
        synchronized (object) {
            this.imdoubleintthreads[i].lock.notify();
        }
        object = this;
        synchronized (object) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        switch (Result.getType()) {
            case 10: {
                this.MAX = 255;
                break;
            }
            case 11: {
                this.MAX = 65535;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported image type.");
            }
        }
        switch (this.HowCorrect) {
            case 0: {
                break;
            }
            case 4: {
                ArrayArithmetic.Abs(tmpres, tmpres);
                break;
            }
            case 2: {
                ArrayArithmetic.Abs(tmpres, tmpres);
                this.CoefPos = Math.max(-this.CoefNeg, this.CoefPos);
                this.CoefNeg = 0.0;
            }
            case 1: {
                this.de.Filter(tmpres, tmpres, (int)(this.CoefNeg * (double)this.MAX - 0.5), (int)(this.CoefPos * (double)this.MAX + 0.5), 0, this.MAX);
                break;
            }
            case 3: {
                ArrayComparator.Compare(tmpres, "<=", this.MAX, tmpres, this.MAX, tmpres);
                ArrayComparator.Compare(tmpres, ">=", 0, tmpres, 0, tmpres);
                break;
            }
            default: {
                throw new IllegalArgumentException("Correction value unknown.");
            }
        }
        block21 : switch (Result.getType()) {
            case 10: {
                ArrayConverter.IntToByte(tmpres, ((DataBufferByte)Result.getRaster().getDataBuffer()).getData());
                break;
            }
            case 11: {
                ArrayConverter.IntToShort(tmpres, ((DataBufferUShort)Result.getRaster().getDataBuffer()).getData());
                break;
            }
            case 0: {
                switch (Result.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        System.arraycopy(tmpres, 0, ((DataBufferInt)Result.getRaster().getDataBuffer()).getData(), 0, length);
                        break block21;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        tmpres = this.allocator.Release(tmpres);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void FilterIntSEDoubleData(BufferedImage source, BufferedImage Result, int nbCPU) {
        Object object;
        int i;
        int width = source.getWidth();
        int height = source.getHeight();
        int length = width * height;
        double[] tmpres = this.allocator.newDoubleArray(length);
        int step = height / nbCPU;
        if (this.imintdoublethreads == null || this.imintdoublethreads.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.imintdoublethreads = null;
            this.imintdoublethreads = new Image_Gradient_IntSE_Doubledata_Thread[nbCPU];
            for (i = 0; i < nbCPU; ++i) {
                this.imintdoublethreads[i] = new Image_Gradient_IntSE_Doubledata_Thread();
                this.imintdoublethreads[i].start();
            }
            object = this;
            synchronized (object) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.nbFreeThreads = 0;
        for (i = 0; i < nbCPU - 1; ++i) {
            this.imintdoublethreads[i].setConditions(source, tmpres, this.se, i * step, (i + 1) * step);
            object = this.imintdoublethreads[i].lock;
            synchronized (object) {
                this.imintdoublethreads[i].lock.notify();
                continue;
            }
        }
        this.imintdoublethreads[i].setConditions(source, tmpres, this.se, i * step, height);
        object = this.imintdoublethreads[i].lock;
        synchronized (object) {
            this.imintdoublethreads[i].lock.notify();
        }
        object = this;
        synchronized (object) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        block10 : switch (Result.getType()) {
            case 0: {
                switch (Result.getRaster().getDataBuffer().getDataType()) {
                    case 5: {
                        this.CoefPos = Double.MAX_VALUE;
                        this.CoefNeg = -1.7976931348623157E308;
                        break block10;
                    }
                    case 4: {
                        this.CoefPos = 3.4028234663852886E38;
                        this.CoefNeg = -3.4028234663852886E38;
                        break block10;
                    }
                }
                throw new IllegalArgumentException("Unsupported DataBuffer type.");
            }
            default: {
                throw new IllegalArgumentException("Unsupported image type.");
            }
        }
        switch (this.HowCorrect) {
            case 0: {
                break;
            }
            case 4: {
                ArrayArithmetic.Abs(tmpres, tmpres);
                break;
            }
            case 2: {
                ArrayArithmetic.Abs(tmpres, tmpres);
                this.CoefNeg = 0.0;
            }
            case 1: {
                this.de.Filter(tmpres, tmpres, this.AF.Minimum(tmpres), this.AF.Maximum(tmpres), this.CoefNeg, this.CoefPos);
                break;
            }
            case 3: {
                throw new UnsupportedOperationException("Correction value not implemented (yet)");
            }
            default: {
                throw new IllegalArgumentException("Correction value unknown.");
            }
        }
        block24 : switch (Result.getType()) {
            case 0: {
                switch (Result.getRaster().getDataBuffer().getDataType()) {
                    case 5: {
                        System.arraycopy(tmpres, 0, ((DataBufferDouble)Result.getRaster().getDataBuffer()).getData(), 0, length);
                        break block24;
                    }
                    case 4: {
                        ArrayConverter.DoubleToFloat(tmpres, ((DataBufferFloat)Result.getRaster().getDataBuffer()).getData());
                        break block24;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        tmpres = this.allocator.Release(tmpres);
    }

    @Override
    public DV Filter(DV source, StructuringElement3D se, int nbCPU) {
        this.setStructuringElement3D(se);
        return this.Filter(source, nbCPU);
    }

    @Override
    public void Filter(DV source, StructuringElement3D se, DV result, int nbCPU) {
        this.setStructuringElement3D(se);
        this.Filter(source, result, nbCPU);
    }

    @Override
    public DV Filter(DV source, int nbCPU) {
        DV dvres = DvNew.Same(source);
        this.Filter(source, dvres, nbCPU);
        return dvres;
    }

    @Override
    public void Filter(DV source, DV result, int nbCPU) {
        if (this.se3d == null) {
            throw new NullPointerException("Any 3D structuring element defined.");
        }
        this.se3d.PreComputePositions(source.SizeX, source.SizeY);
        this.FindCoefSum3D();
        switch (source.Type) {
            case 8: 
            case 16: {
                if (this.se3d.hasIntWeights()) {
                    this.FilterIntSEIntData(source, result, nbCPU);
                    break;
                }
                this.FilterDoubleSEIntData(source, result, nbCPU);
                break;
            }
            case 64: {
                if (this.se3d.hasIntWeights()) {
                    this.FilterIntSEDoubleData(source, result, nbCPU);
                    break;
                }
                throw new UnsupportedOperationException("Configuration not supported: Double SE and Double data.");
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void FilterIntSEIntData(DV source, DV result, int nbCPU) {
        int i;
        int depth = source.SizeZ;
        int length = source.Length;
        int channel = source.Channel;
        int[] tmpres = this.allocator.newIntArray(length);
        int step = depth / nbCPU;
        if (this.dvintintthreads == null || this.dvintintthreads.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.dvintintthreads = null;
            this.dvintintthreads = new DV_Gradient_IntSE_Intdata_Thread[nbCPU];
            for (i = 0; i < nbCPU; ++i) {
                this.dvintintthreads[i] = new DV_Gradient_IntSE_Intdata_Thread();
                this.dvintintthreads[i].start();
            }
            Gradient gradient = this;
            synchronized (gradient) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        switch (result.Type) {
            case 8: {
                this.MAX = 255;
                break;
            }
            case 16: {
                this.MAX = 65535;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported DV type.");
            }
        }
        block33: for (int c = 0; c < channel; ++c) {
            Object object;
            this.nbFreeThreads = 0;
            for (i = 0; i < nbCPU - 1; ++i) {
                this.dvintintthreads[i].setConditions(source, c, tmpres, this.se3d, i * step, (i + 1) * step);
                object = this.dvintintthreads[i].lock;
                synchronized (object) {
                    this.dvintintthreads[i].lock.notify();
                    continue;
                }
            }
            this.dvintintthreads[i].setConditions(source, c, tmpres, this.se3d, i * step, source.SizeZ);
            object = this.dvintintthreads[i].lock;
            synchronized (object) {
                this.dvintintthreads[i].lock.notify();
            }
            object = this;
            synchronized (object) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            switch (this.HowCorrect) {
                case 0: {
                    break;
                }
                case 4: {
                    ArrayArithmetic.Abs(tmpres, tmpres);
                    break;
                }
                case 2: {
                    ArrayArithmetic.Abs(tmpres, tmpres);
                    this.CoefPos = Math.max(-this.CoefNeg, this.CoefPos);
                    this.CoefNeg = 0.0;
                }
                case 1: {
                    this.de.Filter(tmpres, tmpres, (int)(this.CoefNeg * (double)this.MAX - 0.5), (int)(this.CoefPos * (double)this.MAX + 0.5), 0, this.MAX);
                    break;
                }
                case 3: {
                    ArrayComparator.Compare(tmpres, "<=", this.MAX, tmpres, this.MAX, tmpres);
                    ArrayComparator.Compare(tmpres, ">=", 0, tmpres, 0, tmpres);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown correction value.");
                }
            }
            switch (result.Type) {
                case 8: {
                    ArrayConverter.IntToByte(tmpres, result.getDataBufferByte(c));
                    continue block33;
                }
                case 16: {
                    ArrayConverter.IntToShort(tmpres, result.getDataBufferShort(c));
                    continue block33;
                }
                default: {
                    throw new IllegalArgumentException("Default: DV type not supported (yet).");
                }
            }
        }
        tmpres = this.allocator.Release(tmpres);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void FilterDoubleSEIntData(DV source, DV result, int nbCPU) {
        int i;
        int depth = source.SizeZ;
        int length = source.Length;
        int channel = source.Channel;
        int[] tmpres = this.allocator.newIntArray(length);
        int step = depth / nbCPU;
        if (this.dvdoubleintthreads == null || this.dvdoubleintthreads.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.dvdoubleintthreads = null;
            this.dvdoubleintthreads = new DV_Gradient_DoubleSE_Intdata_Thread[nbCPU];
            for (i = 0; i < nbCPU; ++i) {
                this.dvdoubleintthreads[i] = new DV_Gradient_DoubleSE_Intdata_Thread();
                this.dvdoubleintthreads[i].start();
            }
            Gradient gradient = this;
            synchronized (gradient) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        switch (result.Type) {
            case 8: {
                this.MAX = 255;
                break;
            }
            case 16: {
                this.MAX = 65535;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported DV type.");
            }
        }
        block33: for (int c = 0; c < channel; ++c) {
            Object object;
            this.nbFreeThreads = 0;
            for (i = 0; i < nbCPU - 1; ++i) {
                this.dvdoubleintthreads[i].setConditions(source, c, tmpres, this.se3d, i * step, (i + 1) * step);
                object = this.dvdoubleintthreads[i].lock;
                synchronized (object) {
                    this.dvdoubleintthreads[i].lock.notify();
                    continue;
                }
            }
            this.dvdoubleintthreads[i].setConditions(source, c, tmpres, this.se3d, i * step, source.SizeZ);
            object = this.dvdoubleintthreads[i].lock;
            synchronized (object) {
                this.dvdoubleintthreads[i].lock.notify();
            }
            object = this;
            synchronized (object) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            switch (this.HowCorrect) {
                case 0: {
                    break;
                }
                case 4: {
                    ArrayArithmetic.Abs(tmpres, tmpres);
                    break;
                }
                case 2: {
                    ArrayArithmetic.Abs(tmpres, tmpres);
                    this.CoefPos = Math.max(-this.CoefNeg, this.CoefPos);
                    this.CoefNeg = 0.0;
                }
                case 1: {
                    this.de.Filter(tmpres, tmpres, (int)(this.CoefNeg * (double)this.MAX - 0.5), (int)(this.CoefPos * (double)this.MAX + 0.5), 0, this.MAX);
                    break;
                }
                case 3: {
                    ArrayComparator.Compare(tmpres, "<=", this.MAX, tmpres, this.MAX, tmpres);
                    ArrayComparator.Compare(tmpres, ">=", 0, tmpres, 0, tmpres);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown correction value.");
                }
            }
            switch (result.Type) {
                case 8: {
                    ArrayConverter.IntToByte(tmpres, result.getDataBufferByte(c));
                    continue block33;
                }
                case 16: {
                    ArrayConverter.IntToShort(tmpres, result.getDataBufferShort(c));
                    continue block33;
                }
                default: {
                    throw new IllegalArgumentException("Default: DV type not supported (yet).");
                }
            }
        }
        tmpres = this.allocator.Release(tmpres);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void FilterIntSEDoubleData(DV source, DV result, int nbCPU) {
        int i;
        int depth = source.SizeZ;
        int length = source.Length;
        int channel = source.Channel;
        double[] tmpres = this.allocator.newDoubleArray(length);
        int step = depth / nbCPU;
        if (this.dvintdoublethreads == null || this.dvintdoublethreads.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.dvintdoublethreads = null;
            this.dvintdoublethreads = new DV_Gradient_IntSE_Doubledata_Thread[nbCPU];
            for (i = 0; i < nbCPU; ++i) {
                this.dvintdoublethreads[i] = new DV_Gradient_IntSE_Doubledata_Thread();
                this.dvintdoublethreads[i].start();
            }
            Gradient gradient = this;
            synchronized (gradient) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        block29: for (int c = 0; c < channel; ++c) {
            Object object;
            this.nbFreeThreads = 0;
            for (i = 0; i < nbCPU - 1; ++i) {
                this.dvintdoublethreads[i].setConditions(source, c, tmpres, this.se3d, i * step, (i + 1) * step);
                object = this.dvintdoublethreads[i].lock;
                synchronized (object) {
                    this.dvintdoublethreads[i].lock.notify();
                    continue;
                }
            }
            this.dvintdoublethreads[i].setConditions(source, c, tmpres, this.se3d, i * step, depth);
            object = this.dvintdoublethreads[i].lock;
            synchronized (object) {
                this.dvintdoublethreads[i].lock.notify();
            }
            object = this;
            synchronized (object) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            this.CoefNeg = -100.0;
            this.CoefPos = 100.0;
            switch (this.HowCorrect) {
                case 0: {
                    break;
                }
                case 4: {
                    ArrayArithmetic.Abs(tmpres, tmpres);
                    break;
                }
                case 2: {
                    ArrayArithmetic.Abs(tmpres, tmpres);
                    this.CoefNeg = 0.0;
                }
                case 1: {
                    this.de.Filter(tmpres, tmpres, this.AF.Minimum(tmpres), this.AF.Maximum(tmpres), this.CoefNeg, this.CoefPos);
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Correction value unknown.");
                }
            }
            switch (result.Type) {
                case 64: {
                    System.arraycopy(tmpres, 0, result.getDataBufferDouble(c), 0, length);
                    continue block29;
                }
                case -32: {
                    ArrayConverter.DoubleToFloat(tmpres, result.getDataBufferFloat(c));
                    continue block29;
                }
                default: {
                    throw new IllegalArgumentException("DV type not supported.");
                }
            }
        }
        tmpres = this.allocator.Release(tmpres);
    }

    private void FindCoefSum() {
        CoordinatesWeighted[] cws = this.se.getSE();
        this.CoefPos = 0.0;
        this.CoefNeg = 0.0;
        if (this.se.hasIntWeights()) {
            for (CoordinatesWeighted cw : cws) {
                int w = cw.Wi;
                if (w < 0) {
                    this.CoefNeg += (double)w;
                    continue;
                }
                this.CoefPos += (double)w;
            }
        } else {
            for (CoordinatesWeighted cw : cws) {
                double w = cw.Wd;
                if (w < 0.0) {
                    this.CoefNeg += w;
                    continue;
                }
                this.CoefPos += w;
            }
        }
        cws = null;
    }

    private void FindCoefSum3D() {
        CoordinatesWeighted[] cws = this.se3d.getSE();
        this.CoefPos = 0.0;
        this.CoefNeg = 0.0;
        if (this.se3d.hasIntWeights()) {
            for (CoordinatesWeighted cw : cws) {
                if (cw.Wi < 0) {
                    this.CoefNeg += (double)cw.Wi;
                    continue;
                }
                this.CoefPos += (double)cw.Wi;
            }
        } else {
            for (CoordinatesWeighted cw : cws) {
                if (cw.Wd < 0.0) {
                    this.CoefNeg += cw.Wd;
                    continue;
                }
                this.CoefPos += cw.Wd;
            }
        }
        cws = null;
    }

    protected synchronized void addFreeThread() {
        ++this.nbFreeThreads;
        this.notify();
    }

    @Override
    public void Parameters(Object ... parameters) {
        if (parameters.length != 2) {
            throw new IllegalArgumentException("Exactly 2 parameters required.");
        }
        if (parameters[0] instanceof StructuringElement) {
            this.se = (StructuringElement)parameters[0];
        } else if (parameters[0] instanceof StructuringElement3D) {
            this.se3d = (StructuringElement3D)parameters[0];
        } else {
            throw new IllegalArgumentException("The first parameter is not a structuring element.");
        }
        this.HowCorrect((Integer)parameters[1]);
    }

    @Override
    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(2);
        params.add(this.se);
        params.add(this.HowCorrect);
        return params;
    }

    @Override
    public void HowCorrect(int howcorrect) {
        this.HowCorrect = howcorrect;
    }

    @Override
    public int HowCorrect() {
        return this.HowCorrect;
    }

    @Override
    public void setStructuringElement(StructuringElement se) {
        this.se = se;
    }

    @Override
    public StructuringElement getStructuringElement() {
        return this.se;
    }

    @Override
    public StructuringElement3D getStructuringElement3D() {
        return this.se3d;
    }

    @Override
    public void setStructuringElement3D(StructuringElement3D se) {
        this.se3d = se;
    }

    @Override
    public int BorderEffectSizeX() {
        if (this.se3d != null) {
            return this.se3d.getSizeX() >> 1;
        }
        if (this.se != null) {
            return this.se.getSizeX() >> 1;
        }
        throw new IllegalStateException("No structuring element defined (mandatory to compute the border effect size).");
    }

    @Override
    public int BorderEffectSizeY() {
        if (this.se3d != null) {
            return this.se3d.getSizeY() >> 1;
        }
        if (this.se != null) {
            return this.se.getSizeY() >> 1;
        }
        throw new IllegalStateException("No structuring element defined (mandatory to compute the border effect size).");
    }

    @Override
    public int BorderEffectSizeZ() {
        if (this.se3d != null) {
            return this.se3d.getSizeZ() >> 1;
        }
        throw new IllegalStateException("No 3D structuring element defined (mandatory to compute the border effect size).");
    }

    @Override
    public SignalGradient Clone() {
        Gradient gradient = new Gradient();
        gradient.HowCorrect(this.HowCorrect);
        if (this.se != null) {
            gradient.setStructuringElement(this.se);
        }
        if (this.se3d != null) {
            gradient.setStructuringElement3D(this.se3d);
        }
        return gradient;
    }

    private class DV_Gradient_IntSE_Doubledata_Thread
    extends Thread {
        private int width;
        private int height;
        private int depth;
        private int type;
        private int channel;
        private int sizex = -1;
        private int sizey = -1;
        private int sizez = -1;
        private StructuringElement3D se = null;
        private int minz;
        private int maxz;
        private boolean Kill = false;
        private DV dv = null;
        private double[] resgrad = null;
        public final Object lock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.resgrad = null;
            this.dv = null;
            this.se = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(DV source, int channel, double[] resgrad, StructuringElement3D se, int minz, int maxz) {
            this.dv = source;
            this.resgrad = resgrad;
            this.se = se;
            this.sizex = se.getSizeX() >> 1;
            this.sizey = se.getSizeY() >> 1;
            this.sizez = se.getSizeZ() >> 1;
            this.channel = channel;
            this.minz = minz;
            this.maxz = maxz;
            this.width = source.SizeX;
            this.height = source.SizeY;
            this.depth = source.SizeZ;
            this.type = source.Type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block12: while (true) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        Gradient.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                CoordinatesWeighted[] cws = this.se.getSE();
                int Length = this.width - this.se.getSizeX() + 1;
                int heightminussize = this.height - this.sizey;
                int depthminussize = this.depth - this.sizez;
                int MinZ = this.minz < this.sizez ? this.sizez : this.minz;
                int MaxZ = this.maxz >= depthminussize ? depthminussize : this.maxz;
                int sizeywidth = this.sizey * this.width;
                switch (this.type) {
                    case 64: {
                        double[] doublebufferin = this.dv.getDataBufferDouble(this.channel);
                        if (this.minz < MinZ) {
                            Arrays.fill(this.resgrad, this.minz * this.dv.LayerSize, MinZ * this.dv.LayerSize, 0.0);
                        }
                        int pos = MinZ * this.dv.LayerSize;
                        for (int z = MinZ; z < MaxZ; ++z) {
                            Arrays.fill(this.resgrad, pos, pos + sizeywidth, 0.0);
                            pos += sizeywidth;
                            int y = this.sizey;
                            while (y < heightminussize) {
                                Arrays.fill(this.resgrad, pos, pos + this.width, 0.0);
                                int psx = pos + this.sizex;
                                block15: for (CoordinatesWeighted cw : cws) {
                                    switch (cw.Wi) {
                                        case 1: {
                                            ArrayArithmetic.Add(doublebufferin, psx + cw.Pos, this.resgrad, psx, this.resgrad, psx, Length);
                                            continue block15;
                                        }
                                        case -1: {
                                            ArrayArithmetic.Subtract(this.resgrad, psx, doublebufferin, psx + cw.Pos, this.resgrad, psx, Length);
                                            continue block15;
                                        }
                                        default: {
                                            ArrayArithmetic.AddTimes(doublebufferin, psx + cw.Pos, (double)cw.Wi, this.resgrad, psx, this.resgrad, psx, Length);
                                        }
                                    }
                                }
                                ++y;
                                pos += this.width;
                            }
                            Arrays.fill(this.resgrad, pos, pos + sizeywidth, 0.0);
                            pos += sizeywidth;
                        }
                        if (MaxZ < this.maxz) {
                            Arrays.fill(this.resgrad, MaxZ * this.dv.LayerSize, this.maxz * this.dv.LayerSize, 0.0);
                        }
                        doublebufferin = null;
                        continue block12;
                    }
                }
                break;
            }
            throw new IllegalArgumentException("DV type not supported (yet).");
        }
    }

    private class DV_Gradient_DoubleSE_Intdata_Thread
    extends Thread {
        private int width;
        private int height;
        private int depth;
        private int type;
        private int channel;
        private int sizex = -1;
        private int sizey = -1;
        private int sizez = -1;
        private StructuringElement3D se = null;
        private int minz;
        private int maxz;
        private boolean Kill = false;
        private DV dv = null;
        private int[] resgrad = null;
        private double[] buffer = null;
        public final Object lock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.resgrad = null;
            this.dv = null;
            this.se = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(DV source, int channel, int[] resgrad, StructuringElement3D se, int minz, int maxz) {
            this.dv = source;
            this.resgrad = resgrad;
            this.se = se;
            this.sizex = se.getSizeX() >> 1;
            this.sizey = se.getSizeY() >> 1;
            this.sizez = se.getSizeZ() >> 1;
            this.channel = channel;
            this.minz = minz;
            this.maxz = maxz;
            this.width = source.SizeX;
            this.height = source.SizeY;
            this.depth = source.SizeZ;
            this.type = source.Type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block9: while (true) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        Gradient.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                CoordinatesWeighted[] cws = this.se.getSE();
                int Length = this.width - this.se.getSizeX() + 1;
                int heightminussize = this.height - this.sizey;
                int depthminussize = this.depth - this.sizez;
                int MinZ = this.minz < this.sizez ? this.sizez : this.minz;
                int MaxZ = this.maxz >= depthminussize ? depthminussize : this.maxz;
                int sizeywidth = this.sizey * this.width;
                if (this.buffer == null || this.buffer.length != this.width) {
                    this.buffer = new double[this.width];
                }
                switch (this.type) {
                    case 8: {
                        byte[] bytebufferin = this.dv.getDataBufferByte(this.channel);
                        if (this.minz < MinZ) {
                            Arrays.fill(this.resgrad, this.minz * this.dv.LayerSize, MinZ * this.dv.LayerSize, 0);
                        }
                        int pos = MinZ * this.dv.LayerSize;
                        for (int z = MinZ; z < MaxZ; ++z) {
                            Arrays.fill(this.resgrad, pos, pos + sizeywidth, 0);
                            pos += sizeywidth;
                            int y = this.sizey;
                            while (y < heightminussize) {
                                Arrays.fill(this.buffer, 0.0);
                                int psx = pos + this.sizex;
                                for (CoordinatesWeighted cw : cws) {
                                    ArrayArithmetic.AddTimesUnsigned(bytebufferin, psx + cw.Pos, cw.Wd, this.buffer, this.sizex, this.buffer, this.sizex, Length);
                                }
                                ArrayConverter.DoubleToInt(this.buffer, 0, this.resgrad, pos, this.width);
                                ++y;
                                pos += this.width;
                            }
                            Arrays.fill(this.resgrad, pos, pos + sizeywidth, 0);
                            pos += sizeywidth;
                        }
                        if (MaxZ < this.maxz) {
                            Arrays.fill(this.resgrad, MaxZ * this.dv.LayerSize, this.maxz * this.dv.LayerSize, 0);
                        }
                        bytebufferin = null;
                        continue block9;
                    }
                    case 16: {
                        short[] shortbufferin = this.dv.getDataBufferShort(this.channel);
                        if (this.minz < MinZ) {
                            Arrays.fill(this.resgrad, this.minz * this.dv.LayerSize, MinZ * this.dv.LayerSize, 0);
                        }
                        int pos = MinZ * this.dv.LayerSize;
                        for (int z = MinZ; z < MaxZ; ++z) {
                            Arrays.fill(this.resgrad, pos, pos + sizeywidth, 0);
                            pos += sizeywidth;
                            int y = this.sizey;
                            while (y < heightminussize) {
                                Arrays.fill(this.buffer, 0.0);
                                int psx = pos + this.sizex;
                                for (CoordinatesWeighted cw : cws) {
                                    ArrayArithmetic.AddTimesUnsigned(shortbufferin, psx + cw.Pos, cw.Wd, this.buffer, this.sizex, this.buffer, this.sizex, Length);
                                }
                                ArrayConverter.DoubleToInt(this.buffer, 0, this.resgrad, pos, this.width);
                                ++y;
                                pos += this.width;
                            }
                            Arrays.fill(this.resgrad, pos, pos + sizeywidth, 0);
                            pos += sizeywidth;
                        }
                        if (MaxZ < this.maxz) {
                            Arrays.fill(this.resgrad, MaxZ * this.dv.LayerSize, this.maxz * this.dv.LayerSize, 0);
                        }
                        shortbufferin = null;
                        continue block9;
                    }
                }
                break;
            }
            throw new IllegalArgumentException("DV type not supported (yet).");
        }
    }

    private class DV_Gradient_IntSE_Intdata_Thread
    extends Thread {
        private int width;
        private int height;
        private int depth;
        private int type;
        private int channel;
        private int sizex = -1;
        private int sizey = -1;
        private int sizez = -1;
        private StructuringElement3D se = null;
        private int minz;
        private int maxz;
        private boolean Kill = false;
        private DV dv = null;
        private int[] resgrad = null;
        public final Object lock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.resgrad = null;
            this.dv = null;
            this.se = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(DV source, int channel, int[] resgrad, StructuringElement3D se, int minz, int maxz) {
            this.dv = source;
            this.resgrad = resgrad;
            this.se = se;
            this.sizex = se.getSizeX() >> 1;
            this.sizey = se.getSizeY() >> 1;
            this.sizez = se.getSizeZ() >> 1;
            this.channel = channel;
            this.minz = minz;
            this.maxz = maxz;
            this.width = source.SizeX;
            this.height = source.SizeY;
            this.depth = source.SizeZ;
            this.type = source.Type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block17: while (true) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        Gradient.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                CoordinatesWeighted[] cws = this.se.getSE();
                int Length = this.width - this.se.getSizeX() + 1;
                int heightminussize = this.height - this.sizey;
                int depthminussize = this.depth - this.sizez;
                int MinZ = this.minz < this.sizez ? this.sizez : this.minz;
                int MaxZ = this.maxz >= depthminussize ? depthminussize : this.maxz;
                int sizeywidth = this.sizey * this.width;
                switch (this.type) {
                    case 8: {
                        byte[] bytebufferin = this.dv.getDataBufferByte(this.channel);
                        if (this.minz < MinZ) {
                            Arrays.fill(this.resgrad, this.minz * this.dv.LayerSize, MinZ * this.dv.LayerSize, 0);
                        }
                        int pos = MinZ * this.dv.LayerSize;
                        for (int z = MinZ; z < MaxZ; ++z) {
                            Arrays.fill(this.resgrad, pos, pos + sizeywidth, 0);
                            pos += sizeywidth;
                            int y = this.sizey;
                            while (y < heightminussize) {
                                Arrays.fill(this.resgrad, pos, pos + this.width, 0);
                                int psx = pos + this.sizex;
                                block20: for (CoordinatesWeighted cw : cws) {
                                    switch (cw.Wi) {
                                        case 1: {
                                            ArrayArithmetic.AddUnsigned(bytebufferin, psx + cw.Pos, this.resgrad, psx, this.resgrad, psx, Length);
                                            continue block20;
                                        }
                                        case -1: {
                                            ArrayArithmetic.SubtractUnsigned(this.resgrad, psx, bytebufferin, psx + cw.Pos, this.resgrad, psx, Length);
                                            continue block20;
                                        }
                                        default: {
                                            ArrayArithmetic.AddTimesUnsigned(bytebufferin, psx + cw.Pos, cw.Wi, this.resgrad, psx, this.resgrad, psx, Length);
                                        }
                                    }
                                }
                                ++y;
                                pos += this.width;
                            }
                            Arrays.fill(this.resgrad, pos, pos + sizeywidth, 0);
                            pos += sizeywidth;
                        }
                        if (MaxZ < this.maxz) {
                            Arrays.fill(this.resgrad, MaxZ * this.dv.LayerSize, this.maxz * this.dv.LayerSize, 0);
                        }
                        bytebufferin = null;
                        continue block17;
                    }
                    case 16: {
                        short[] shortbufferin = this.dv.getDataBufferShort(this.channel);
                        if (this.minz < MinZ) {
                            Arrays.fill(this.resgrad, this.minz * this.dv.LayerSize, MinZ * this.dv.LayerSize, 0);
                        }
                        int pos = MinZ * this.dv.LayerSize;
                        for (int z = MinZ; z < MaxZ; ++z) {
                            Arrays.fill(this.resgrad, pos, pos + sizeywidth, 0);
                            pos += sizeywidth;
                            int y = this.sizey;
                            while (y < heightminussize) {
                                Arrays.fill(this.resgrad, pos, pos + this.width, 0);
                                int psx = pos + this.sizex;
                                block23: for (CoordinatesWeighted cw : cws) {
                                    switch (cw.Wi) {
                                        case 1: {
                                            ArrayArithmetic.AddUnsigned(shortbufferin, psx + cw.Pos, this.resgrad, psx, this.resgrad, psx, Length);
                                            continue block23;
                                        }
                                        case -1: {
                                            ArrayArithmetic.SubtractUnsigned(this.resgrad, psx, shortbufferin, psx + cw.Pos, this.resgrad, psx, Length);
                                            continue block23;
                                        }
                                        default: {
                                            ArrayArithmetic.AddTimesUnsigned(shortbufferin, psx + cw.Pos, cw.Wi, this.resgrad, psx, this.resgrad, psx, Length);
                                        }
                                    }
                                }
                                ++y;
                                pos += this.width;
                            }
                            Arrays.fill(this.resgrad, pos, pos + sizeywidth, 0);
                            pos += sizeywidth;
                        }
                        if (MaxZ < this.maxz) {
                            Arrays.fill(this.resgrad, MaxZ * this.dv.LayerSize, this.maxz * this.dv.LayerSize, 0);
                        }
                        shortbufferin = null;
                        continue block17;
                    }
                }
                break;
            }
            throw new IllegalArgumentException("DV type not supported (yet).");
        }
    }

    private class Image_Gradient_DoubleSE_Intdata_Thread
    extends Thread {
        private StructuringElement se = null;
        private int miny;
        private int maxy;
        private boolean Kill = false;
        private BufferedImage source = null;
        private int[] resgrad = null;
        private double[] buffer = null;
        public final Object lock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.resgrad = null;
            this.source = null;
            this.buffer = null;
            this.se = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(BufferedImage source, int[] resgrad, StructuringElement se, int miny, int maxy) {
            this.source = source;
            this.resgrad = resgrad;
            this.se = se;
            this.miny = miny;
            this.maxy = maxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block9: while (true) {
                int MaxY;
                Object object = this.lock;
                synchronized (object) {
                    try {
                        Gradient.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                int width = this.source.getWidth();
                int height = this.source.getHeight();
                int sizex = this.se.getSizeX() >> 1;
                int sizey = this.se.getSizeY() >> 1;
                CoordinatesWeighted[] cws = this.se.getSE();
                int Length = width - this.se.getSizeX() + 1;
                int heightminussize = height - sizey;
                int MinY = this.miny < sizey ? sizey : this.miny;
                int n = MaxY = this.maxy >= heightminussize ? heightminussize : this.maxy;
                if (this.buffer == null || this.buffer.length != width) {
                    this.buffer = new double[width];
                }
                switch (this.source.getType()) {
                    case 10: {
                        byte[] bytebufferin = ((DataBufferByte)this.source.getRaster().getDataBuffer()).getData();
                        int y = MinY;
                        int pos = y * width;
                        while (y < MaxY) {
                            Arrays.fill(this.buffer, 0.0);
                            int psx = pos + sizex;
                            for (CoordinatesWeighted cw : cws) {
                                ArrayArithmetic.AddTimesUnsigned(bytebufferin, psx + cw.Pos, cw.Wd, this.buffer, sizex, this.buffer, sizex, Length);
                            }
                            ArrayConverter.DoubleToInt(this.buffer, 0, this.resgrad, pos, width);
                            ++y;
                            pos += width;
                        }
                        bytebufferin = null;
                        continue block9;
                    }
                    case 11: {
                        short[] shortbufferin = ((DataBufferUShort)this.source.getRaster().getDataBuffer()).getData();
                        int y = MinY;
                        int pos = y * width;
                        while (y < MaxY) {
                            Arrays.fill(this.buffer, 0.0);
                            int psx = pos + sizex;
                            for (CoordinatesWeighted cw : cws) {
                                ArrayArithmetic.AddTimesUnsigned(shortbufferin, psx + cw.Pos, cw.Wd, this.buffer, sizex, this.buffer, sizex, Length);
                            }
                            ArrayConverter.DoubleToInt(this.buffer, 0, this.resgrad, pos, width);
                            ++y;
                            pos += width;
                        }
                        shortbufferin = null;
                        continue block9;
                    }
                }
                break;
            }
            throw new IllegalArgumentException("Image type not supported (yet).");
        }
    }

    private class Image_Gradient_IntSE_Doubledata_Thread
    extends Thread {
        private StructuringElement se = null;
        private int miny;
        private int maxy;
        private boolean Kill = false;
        private BufferedImage source = null;
        private double[] resgrad = null;
        public final Object lock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.resgrad = null;
            this.source = null;
            this.se = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(BufferedImage source, double[] resgrad, StructuringElement se, int miny, int maxy) {
            this.source = source;
            this.resgrad = resgrad;
            this.se = se;
            this.miny = miny;
            this.maxy = maxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block20: while (true) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        Gradient.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                int width = this.source.getWidth();
                int height = this.source.getHeight();
                int sizex = this.se.getSizeX() >> 1;
                int sizey = this.se.getSizeY() >> 1;
                CoordinatesWeighted[] cws = this.se.getSE();
                int Length = width - this.se.getSizeX() + 1;
                int heightminussize = height - sizey;
                int MinY = this.miny < sizey ? sizey : this.miny;
                int MaxY = this.maxy >= heightminussize ? heightminussize : this.maxy;
                switch (this.source.getType()) {
                    case 0: {
                        switch (this.source.getRaster().getDataBuffer().getDataType()) {
                            case 5: {
                                double[] doublebufferin = ((DataBufferDouble)this.source.getRaster().getDataBuffer()).getData();
                                int y = MinY;
                                int pos = y * width;
                                while (y < MaxY) {
                                    Arrays.fill(this.resgrad, pos, pos + width, 0.0);
                                    int psx = pos + sizex;
                                    block22: for (CoordinatesWeighted cw : cws) {
                                        switch (cw.Wi) {
                                            case 1: {
                                                ArrayArithmetic.Add(doublebufferin, psx + cw.Pos, this.resgrad, psx, this.resgrad, psx, Length);
                                                continue block22;
                                            }
                                            case -1: {
                                                ArrayArithmetic.Subtract(this.resgrad, psx, doublebufferin, psx + cw.Pos, this.resgrad, psx, Length);
                                                continue block22;
                                            }
                                            default: {
                                                ArrayArithmetic.AddTimes(doublebufferin, psx + cw.Pos, (double)cw.Wi, this.resgrad, psx, this.resgrad, psx, Length);
                                            }
                                        }
                                    }
                                    ++y;
                                    pos += width;
                                }
                                doublebufferin = null;
                                break;
                            }
                            case 4: {
                                float[] floatbufferin = ((DataBufferFloat)this.source.getRaster().getDataBuffer()).getData();
                                float[] buffer = new float[width];
                                int y = MinY;
                                int pos = y * width;
                                while (y < MaxY) {
                                    Arrays.fill(buffer, 0.0f);
                                    int psx = pos + sizex;
                                    block24: for (CoordinatesWeighted cw : cws) {
                                        switch (cw.Wi) {
                                            case 1: {
                                                ArrayArithmetic.Add(floatbufferin, psx + cw.Pos, buffer, 0, buffer, psx, Length);
                                                continue block24;
                                            }
                                            case -1: {
                                                ArrayArithmetic.Subtract(buffer, psx, floatbufferin, psx + cw.Pos, buffer, psx, Length);
                                                continue block24;
                                            }
                                            default: {
                                                ArrayArithmetic.AddTimes(floatbufferin, psx + cw.Pos, (float)cw.Wi, buffer, psx, buffer, psx, Length);
                                            }
                                        }
                                    }
                                    System.arraycopy(buffer, 0, this.resgrad, psx, width);
                                    ++y;
                                    pos += width;
                                }
                                buffer = null;
                                floatbufferin = null;
                            }
                        }
                        continue block20;
                    }
                }
                break;
            }
            throw new IllegalArgumentException("Image type not supported (yet).");
        }
    }

    private class Image_Gradient_IntSE_Intdata_Thread
    extends Thread {
        private StructuringElement se = null;
        private int miny;
        private int maxy;
        private boolean Kill = false;
        private BufferedImage source = null;
        private int[] resgrad = null;
        public final Object lock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.resgrad = null;
            this.source = null;
            this.se = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(BufferedImage source, int[] resgrad, StructuringElement se, int miny, int maxy) {
            this.source = source;
            this.resgrad = resgrad;
            this.se = se;
            this.miny = miny;
            this.maxy = maxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block17: while (true) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        Gradient.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                int width = this.source.getWidth();
                int height = this.source.getHeight();
                int sizex = this.se.getSizeX() >> 1;
                int sizey = this.se.getSizeY() >> 1;
                CoordinatesWeighted[] cws = this.se.getSE();
                int Length = width - this.se.getSizeX() + 1;
                int heightminussize = height - sizey;
                int MinY = this.miny < sizey ? sizey : this.miny;
                int MaxY = this.maxy >= heightminussize ? heightminussize : this.maxy;
                switch (this.source.getType()) {
                    case 10: {
                        byte[] bytebufferin = ((DataBufferByte)this.source.getRaster().getDataBuffer()).getData();
                        int y = MinY;
                        int pos = y * width;
                        while (y < MaxY) {
                            Arrays.fill(this.resgrad, pos, pos + width, 0);
                            int psx = pos + sizex;
                            block19: for (CoordinatesWeighted cw : cws) {
                                switch (cw.Wi) {
                                    case 1: {
                                        ArrayArithmetic.AddUnsigned(bytebufferin, psx + cw.Pos, this.resgrad, psx, this.resgrad, psx, Length);
                                        continue block19;
                                    }
                                    case -1: {
                                        ArrayArithmetic.SubtractUnsigned(this.resgrad, psx, bytebufferin, psx + cw.Pos, this.resgrad, psx, Length);
                                        continue block19;
                                    }
                                    default: {
                                        ArrayArithmetic.AddTimesUnsigned(bytebufferin, psx + cw.Pos, cw.Wi, this.resgrad, psx, this.resgrad, psx, Length);
                                    }
                                }
                            }
                            ++y;
                            pos += width;
                        }
                        bytebufferin = null;
                        continue block17;
                    }
                    case 11: {
                        short[] shortbufferin = ((DataBufferUShort)this.source.getRaster().getDataBuffer()).getData();
                        int y = MinY;
                        int pos = y * width;
                        while (y < MaxY) {
                            Arrays.fill(this.resgrad, pos, pos + width, 0);
                            int psx = pos + sizex;
                            block21: for (CoordinatesWeighted cw : cws) {
                                switch (cw.Wi) {
                                    case 1: {
                                        ArrayArithmetic.AddUnsigned(shortbufferin, psx + cw.Pos, this.resgrad, psx, this.resgrad, psx, Length);
                                        continue block21;
                                    }
                                    case -1: {
                                        ArrayArithmetic.SubtractUnsigned(this.resgrad, psx, shortbufferin, psx + cw.Pos, this.resgrad, psx, Length);
                                        continue block21;
                                    }
                                    default: {
                                        ArrayArithmetic.AddTimesUnsigned(shortbufferin, psx + cw.Pos, cw.Wi, this.resgrad, psx, this.resgrad, psx, Length);
                                    }
                                }
                            }
                            ++y;
                            pos += width;
                        }
                        shortbufferin = null;
                        continue block17;
                    }
                }
                break;
            }
            throw new IllegalArgumentException("Image type not supported (yet).");
        }
    }
}

