/*
 * Decompiled with CFR 0.152.
 */
package morphee.fastMorphee;

import arrayTiTi.ArrayMM;
import java.util.Arrays;
import morphee.fastMorphee.FastMorphee;

public class ErodeSegmentZ
implements FastMorphee {
    private ErodeZhistThread[] threadshist = null;
    private ErodeZfmThread[] threadsfm = null;
    private ErodeZavThread[] threadsav = null;
    private int nbFreeThreads = 0;
    private int sewidth = 0;
    private FastMorphee.Algorithm algo = FastMorphee.Algorithm.Histogram;
    private Object[] sigsin;
    private Object[] sigsout;
    private int Channel;
    private int SizeX;
    private int SizeZ;
    private int Layer;
    private int Type;

    @Override
    public synchronized void Kill() {
        int i;
        this.sigsout = null;
        this.sigsin = null;
        if (this.threadshist != null) {
            for (i = 0; i < this.threadshist.length; ++i) {
                this.threadshist[i].Kill();
                this.threadshist[i] = null;
            }
            this.threadshist = null;
        }
        if (this.threadsfm != null) {
            for (i = 0; i < this.threadsfm.length; ++i) {
                this.threadsfm[i].Kill();
                this.threadsfm[i] = null;
            }
            this.threadsfm = null;
        }
        if (this.threadsav != null) {
            for (i = 0; i < this.threadsav.length; ++i) {
                this.threadsav[i].Kill();
                this.threadsav[i] = null;
            }
            this.threadsav = null;
        }
    }

    @Override
    public void FilterInterlaced(Object source, int sizex, int sizey, int sizez, int channel, int type, int sewidth, Object result, int nbCPU) {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Filter(Object[] sources, int sizex, int sizey, int sizez, int type, int sewidth, Object[] results, int nbCPU) {
        Object object;
        if (sewidth < 1) {
            throw new IllegalArgumentException("The structuring element order must be positive.");
        }
        this.sewidth = sewidth;
        switch (type) {
            case -2: {
                if (sewidth <= 3) {
                    this.StartAV(nbCPU);
                    break;
                }
                this.StartHist(nbCPU);
                break;
            }
            case -3: {
                if (sewidth <= 3) {
                    this.StartAV(nbCPU);
                    break;
                }
                this.StartFM(nbCPU);
                break;
            }
            case -5: 
            case -4: 
            case -1: {
                if (sewidth <= 3) {
                    this.StartAV(nbCPU);
                    break;
                }
                this.StartFM(nbCPU);
                break;
            }
            default: {
                throw new IllegalArgumentException("Object type unknown.");
            }
        }
        this.sigsin = sources;
        this.sigsout = results;
        this.SizeX = sizex;
        this.SizeZ = sizez;
        this.Layer = sizex * sizey;
        this.Channel = sources.length;
        this.Type = type;
        ErodeSegmentZ erodeSegmentZ = this;
        synchronized (erodeSegmentZ) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        this.nbFreeThreads = 0;
        int step = sizey / nbCPU;
        int nbCPUm1 = nbCPU - 1;
        switch (this.algo) {
            case AutoVectorization: {
                Object object2;
                for (int i = 0; i < nbCPUm1; ++i) {
                    this.threadsav[i].setConditions(i * step, (i + 1) * step);
                    object2 = this.threadsav[i].lock;
                    synchronized (object2) {
                        this.threadsav[i].lock.notify();
                        continue;
                    }
                }
                this.threadsav[nbCPUm1].setConditions(nbCPUm1 * step, sizey);
                Object i = this.threadsav[nbCPUm1].lock;
                synchronized (i) {
                    this.threadsav[nbCPUm1].lock.notify();
                    break;
                }
            }
            case FastMorphM: {
                Object object2;
                for (int i = 0; i < nbCPUm1; ++i) {
                    this.threadsfm[i].setConditions(i * step, (i + 1) * step);
                    object2 = this.threadsfm[i].lock;
                    synchronized (object2) {
                        this.threadsfm[i].lock.notify();
                        continue;
                    }
                }
                this.threadsfm[nbCPUm1].setConditions(nbCPUm1 * step, sizey);
                Object i = this.threadsfm[nbCPUm1].lock;
                synchronized (i) {
                    this.threadsfm[nbCPUm1].lock.notify();
                    break;
                }
            }
            case Histogram: {
                Object object2;
                for (int i = 0; i < nbCPUm1; ++i) {
                    this.threadshist[i].setConditions(i * step, (i + 1) * step);
                    object2 = this.threadshist[i].lock;
                    synchronized (object2) {
                        this.threadshist[i].lock.notify();
                        continue;
                    }
                }
                this.threadshist[nbCPUm1].setConditions(nbCPUm1 * step, sizey);
                object = this.threadshist[nbCPUm1].lock;
                synchronized (object) {
                    this.threadshist[nbCPUm1].lock.notify();
                    break;
                }
            }
            default: {
                throw new IllegalArgumentException("Unknown algorithm.");
            }
        }
        object = this;
        synchronized (object) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void StartHist(int nbCPU) {
        this.algo = FastMorphee.Algorithm.Histogram;
        if (this.threadshist != null && this.threadshist.length == nbCPU) {
            return;
        }
        this.Kill();
        this.nbFreeThreads = 0;
        this.threadshist = new ErodeZhistThread[nbCPU];
        for (int i = 0; i < nbCPU; ++i) {
            this.threadshist[i] = new ErodeZhistThread();
            this.threadshist[i].start();
        }
    }

    private void StartFM(int nbCPU) {
        this.algo = FastMorphee.Algorithm.FastMorphM;
        if (this.threadsfm != null && this.threadsfm.length == nbCPU) {
            return;
        }
        this.Kill();
        this.nbFreeThreads = 0;
        this.threadsfm = new ErodeZfmThread[nbCPU];
        for (int i = 0; i < nbCPU; ++i) {
            this.threadsfm[i] = new ErodeZfmThread();
            this.threadsfm[i].start();
        }
    }

    private void StartAV(int nbCPU) {
        this.algo = FastMorphee.Algorithm.AutoVectorization;
        if (this.threadsav != null && this.threadsav.length == nbCPU) {
            return;
        }
        this.Kill();
        this.nbFreeThreads = 0;
        this.threadsav = new ErodeZavThread[nbCPU];
        for (int i = 0; i < nbCPU; ++i) {
            this.threadsav[i] = new ErodeZavThread();
            this.threadsav[i].start();
        }
    }

    protected synchronized void addFreeThread() {
        ++this.nbFreeThreads;
        this.notify();
    }

    private class ErodeZavThread
    extends Thread {
        private int miny;
        private int maxy;
        public final Object lock = new Object();
        private boolean Kill = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(int miny, int maxy) {
            this.miny = miny;
            this.maxy = maxy;
            switch (ErodeSegmentZ.this.Type) {
                case -5: 
                case -4: 
                case -3: 
                case -2: 
                case -1: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Type not supported (yet).");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block12: while (true) lbl-1000:
            // 6 sources

            {
                var1_2 = this.lock;
                synchronized (var1_2) {
                    try {
                        ErodeSegmentZ.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                type = ErodeSegmentZ.this.Type;
                sizex = ErodeSegmentZ.this.SizeX;
                sizez = ErodeSegmentZ.this.SizeZ;
                layer = ErodeSegmentZ.this.Layer;
                channel = ErodeSegmentZ.this.Channel;
                switch (type) {
                    case -2: {
                        c = 0;
                        while (true) {
                            if (c >= channel) ** GOTO lbl-1000
                            bytebufferin = (byte[])ErodeSegmentZ.this.sigsin[c];
                            bytebufferout = (byte[])ErodeSegmentZ.this.sigsout[c];
                            for (y = this.miny; y < this.maxy; ++y) {
                                z = 0;
                                pos = y * sizex;
                                while (z < sizez) {
                                    System.arraycopy(bytebufferin, pos, bytebufferout, pos, sizex);
                                    s = -1;
                                    p = pos - layer;
                                    while (-ErodeSegmentZ.this.sewidth <= s && 0 <= z + s) {
                                        ArrayMM.MinimumUnsigned(bytebufferin, p, bytebufferout, pos, bytebufferout, pos, sizex);
                                        --s;
                                        p -= layer;
                                    }
                                    s = 1;
                                    p = pos + layer;
                                    while (s <= ErodeSegmentZ.this.sewidth && z + s < sizez) {
                                        ArrayMM.MinimumUnsigned(bytebufferin, p, bytebufferout, pos, bytebufferout, pos, sizex);
                                        ++s;
                                        p += layer;
                                    }
                                    ++z;
                                    pos += layer;
                                }
                            }
                            bytebufferout = null;
                            bytebufferin = null;
                            ++c;
                        }
                    }
                    case -3: {
                        c = 0;
                        while (true) {
                            if (c >= channel) ** GOTO lbl-1000
                            shortbufferin = (short[])ErodeSegmentZ.this.sigsin[c];
                            shortbufferout = (short[])ErodeSegmentZ.this.sigsout[c];
                            for (y = this.miny; y < this.maxy; ++y) {
                                z = 0;
                                pos = y * sizex;
                                while (z < sizez) {
                                    System.arraycopy(shortbufferin, pos, shortbufferout, pos, sizex);
                                    s = -1;
                                    p = pos - layer;
                                    while (-ErodeSegmentZ.this.sewidth <= s && 0 <= z + s) {
                                        ArrayMM.MinimumUnsigned(shortbufferin, p, shortbufferout, pos, shortbufferout, pos, sizex);
                                        --s;
                                        p -= layer;
                                    }
                                    s = 1;
                                    p = pos + layer;
                                    while (s <= ErodeSegmentZ.this.sewidth && z + s < sizez) {
                                        ArrayMM.MinimumUnsigned(shortbufferin, p, shortbufferout, pos, shortbufferout, pos, sizex);
                                        ++s;
                                        p += layer;
                                    }
                                    ++z;
                                    pos += layer;
                                }
                            }
                            shortbufferout = null;
                            shortbufferin = null;
                            ++c;
                        }
                    }
                    case -4: {
                        c = 0;
                        while (true) {
                            if (c >= channel) ** GOTO lbl-1000
                            floatbufferin = (float[])ErodeSegmentZ.this.sigsin[c];
                            floatbufferout = (float[])ErodeSegmentZ.this.sigsout[c];
                            for (y = this.miny; y < this.maxy; ++y) {
                                z = 0;
                                pos = y * sizex;
                                while (z < sizez) {
                                    System.arraycopy(floatbufferin, pos, floatbufferout, pos, sizex);
                                    s = -1;
                                    p = pos - layer;
                                    while (-ErodeSegmentZ.this.sewidth <= s && 0 <= z + s) {
                                        ArrayMM.Minimum(floatbufferin, p, floatbufferout, pos, floatbufferout, pos, sizex);
                                        --s;
                                        p -= layer;
                                    }
                                    s = 1;
                                    p = pos + layer;
                                    while (s <= ErodeSegmentZ.this.sewidth && z + s < sizez) {
                                        ArrayMM.Minimum(floatbufferin, p, floatbufferout, pos, floatbufferout, pos, sizex);
                                        ++s;
                                        p += layer;
                                    }
                                    ++z;
                                    pos += layer;
                                }
                            }
                            floatbufferout = null;
                            floatbufferin = null;
                            ++c;
                        }
                    }
                    case -5: {
                        c = 0;
                        while (true) {
                            if (c >= channel) ** GOTO lbl-1000
                            doublebufferin = (double[])ErodeSegmentZ.this.sigsin[c];
                            doublebufferout = (double[])ErodeSegmentZ.this.sigsout[c];
                            for (y = this.miny; y < this.maxy; ++y) {
                                z = 0;
                                pos = y * sizex;
                                while (z < sizez) {
                                    System.arraycopy(doublebufferin, pos, doublebufferout, pos, sizex);
                                    s = -1;
                                    p = pos - layer;
                                    while (-ErodeSegmentZ.this.sewidth <= s && 0 <= z + s) {
                                        ArrayMM.Minimum(doublebufferin, p, doublebufferout, pos, doublebufferout, pos, sizex);
                                        --s;
                                        p -= layer;
                                    }
                                    s = 1;
                                    p = pos + layer;
                                    while (s <= ErodeSegmentZ.this.sewidth && z + s < sizez) {
                                        ArrayMM.Minimum(doublebufferin, p, doublebufferout, pos, doublebufferout, pos, sizex);
                                        ++s;
                                        p += layer;
                                    }
                                    ++z;
                                    pos += layer;
                                }
                            }
                            doublebufferout = null;
                            doublebufferin = null;
                            ++c;
                        }
                    }
                    case -1: {
                        c = 0;
                        while (true) {
                            if (c >= channel) continue block12;
                            intbufferin = (int[])ErodeSegmentZ.this.sigsin[c];
                            intbufferout = (int[])ErodeSegmentZ.this.sigsout[c];
                            for (y = this.miny; y < this.maxy; ++y) {
                                z = 0;
                                pos = y * sizex;
                                while (z < sizez) {
                                    System.arraycopy(intbufferin, pos, intbufferout, pos, sizex);
                                    s = -1;
                                    p = pos - layer;
                                    while (-ErodeSegmentZ.this.sewidth <= s && 0 <= z + s) {
                                        ArrayMM.Minimum(intbufferin, p, intbufferout, pos, intbufferout, pos, sizex);
                                        --s;
                                        p -= layer;
                                    }
                                    s = 1;
                                    p = pos + layer;
                                    while (s <= ErodeSegmentZ.this.sewidth && z + s < sizez) {
                                        ArrayMM.Minimum(intbufferin, p, intbufferout, pos, intbufferout, pos, sizex);
                                        ++s;
                                        p += layer;
                                    }
                                    ++z;
                                    pos += layer;
                                }
                            }
                            intbufferout = null;
                            intbufferin = null;
                            ++c;
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("Type not supported (yet).");
                    }
                }
                break;
            }
        }
    }

    private class ErodeZfmThread
    extends Thread {
        private int miny;
        private int maxy;
        private int[] buffer = null;
        private float[] bufferfloat = null;
        private double[] bufferdouble = null;
        public final Object lock = new Object();
        private boolean Kill = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.Kill = true;
            this.buffer = null;
            this.bufferfloat = null;
            this.bufferdouble = null;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(int miny, int maxy) {
            this.miny = miny;
            this.maxy = maxy;
            switch (ErodeSegmentZ.this.Type) {
                case -3: 
                case -1: {
                    if (this.buffer != null && this.buffer.length == ErodeSegmentZ.this.SizeZ) break;
                    this.buffer = null;
                    this.buffer = new int[ErodeSegmentZ.this.SizeZ];
                    break;
                }
                case -4: {
                    if (this.bufferfloat != null && this.bufferfloat.length == ErodeSegmentZ.this.SizeZ) break;
                    this.bufferfloat = null;
                    this.bufferfloat = new float[ErodeSegmentZ.this.SizeZ];
                    break;
                }
                case -5: {
                    if (this.bufferdouble != null && this.bufferdouble.length == ErodeSegmentZ.this.SizeZ) break;
                    this.bufferdouble = null;
                    this.bufferdouble = new double[ErodeSegmentZ.this.SizeZ];
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Type not supported (yet).");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block11: while (true) lbl-1000:
            // 5 sources

            {
                var1_2 = this.lock;
                synchronized (var1_2) {
                    try {
                        ErodeSegmentZ.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                type = ErodeSegmentZ.this.Type;
                sizex = ErodeSegmentZ.this.SizeX;
                sizez = ErodeSegmentZ.this.SizeZ;
                layer = ErodeSegmentZ.this.Layer;
                channel = ErodeSegmentZ.this.Channel;
                ds1 = sizez - ErodeSegmentZ.this.sewidth - 1;
                switch (type) {
                    case -3: {
                        c = 0;
                        while (true) {
                            if (c >= channel) ** GOTO lbl-1000
                            shortbufferin = (short[])ErodeSegmentZ.this.sigsin[c];
                            shortbufferout = (short[])ErodeSegmentZ.this.sigsout[c];
                            for (y = this.miny; y < this.maxy; ++y) {
                                x = 0;
                                pos = x + y * sizex;
                                while (x < sizex) {
                                    T = 65535;
                                    G = 65535;
                                    nbprop = 0;
                                    for (z = 0; z < sizez; ++z) {
                                        T_pre = T;
                                        G_pre = G;
                                        rowval = shortbufferin[pos + z * layer] & 65535;
                                        T = z > ds1 ? (T_pre > rowval ? rowval : T_pre) : 65535;
                                        if (G_pre < rowval && nbprop < ErodeSegmentZ.this.sewidth) {
                                            G = G_pre;
                                            ++nbprop;
                                        } else {
                                            G = z > ds1 && nbprop >= ErodeSegmentZ.this.sewidth ? T : rowval;
                                            T = 65535;
                                            nbprop = 0;
                                        }
                                        this.buffer[sizez - z - 1] = z - ErodeSegmentZ.this.sewidth < 0 ? G : Math.min(G, shortbufferin[pos + (z - ErodeSegmentZ.this.sewidth) * layer] & 65535);
                                    }
                                    T = 65535;
                                    G = 65535;
                                    nbprop = 0;
                                    rowval = 65535;
                                    rowval_pre = 65535;
                                    for (z = 0; z < sizez; ++z) {
                                        T_pre = T;
                                        G_pre = G;
                                        rowval_pre = rowval;
                                        rowval = this.buffer[z];
                                        T = z == 0 ? rowval : (rowval < rowval_pre && T > rowval ? rowval : T_pre);
                                        if (G_pre < rowval && nbprop < ErodeSegmentZ.this.sewidth) {
                                            G = G_pre;
                                            ++nbprop;
                                        } else {
                                            G = nbprop >= ErodeSegmentZ.this.sewidth ? T : rowval;
                                            T = 65535;
                                            nbprop = 0;
                                        }
                                        shortbufferout[pos + (sizez - z - 1) * layer] = z < ErodeSegmentZ.this.sewidth ? (short)G : (short)Math.min(G, this.buffer[z - ErodeSegmentZ.this.sewidth]);
                                    }
                                    ++x;
                                    ++pos;
                                }
                            }
                            ++c;
                        }
                    }
                    case -1: {
                        c = 0;
                        while (true) {
                            if (c >= channel) ** GOTO lbl-1000
                            intbufferin = (int[])ErodeSegmentZ.this.sigsin[c];
                            intbufferout = (int[])ErodeSegmentZ.this.sigsout[c];
                            for (y = this.miny; y < this.maxy; ++y) {
                                x = 0;
                                pos = x + y * sizex;
                                while (x < sizex) {
                                    T = 0x7FFFFFFF;
                                    G = 0x7FFFFFFF;
                                    nbprop = 0;
                                    for (z = 0; z < sizez; ++z) {
                                        T_pre = T;
                                        G_pre = G;
                                        rowval = intbufferin[pos + z * layer];
                                        T = z > ds1 ? (T_pre > rowval ? rowval : T_pre) : 0x7FFFFFFF;
                                        if (G_pre < rowval && nbprop < ErodeSegmentZ.this.sewidth) {
                                            G = G_pre;
                                            ++nbprop;
                                        } else {
                                            G = z > ds1 && nbprop >= ErodeSegmentZ.this.sewidth ? T : rowval;
                                            T = 0x7FFFFFFF;
                                            nbprop = 0;
                                        }
                                        this.buffer[sizez - z - 1] = z - ErodeSegmentZ.this.sewidth < 0 ? G : Math.min(G, intbufferin[pos + (z - ErodeSegmentZ.this.sewidth) * layer]);
                                    }
                                    T = 0x7FFFFFFF;
                                    G = 0x7FFFFFFF;
                                    nbprop = 0;
                                    rowval = 0x7FFFFFFF;
                                    rowval_pre = 0x7FFFFFFF;
                                    for (z = 0; z < sizez; ++z) {
                                        T_pre = T;
                                        G_pre = G;
                                        rowval_pre = rowval;
                                        rowval = this.buffer[z];
                                        T = z == 0 ? rowval : (rowval < rowval_pre && T > rowval ? rowval : T_pre);
                                        if (G_pre < rowval && nbprop < ErodeSegmentZ.this.sewidth) {
                                            G = G_pre;
                                            ++nbprop;
                                        } else {
                                            G = nbprop >= ErodeSegmentZ.this.sewidth ? T : rowval;
                                            T = 0x7FFFFFFF;
                                            nbprop = 0;
                                        }
                                        intbufferout[pos + (sizez - z - 1) * layer] = z < ErodeSegmentZ.this.sewidth ? G : Math.min(G, this.buffer[z - ErodeSegmentZ.this.sewidth]);
                                    }
                                    ++x;
                                    ++pos;
                                }
                            }
                            ++c;
                        }
                    }
                    case -4: {
                        c = 0;
                        while (true) {
                            if (c >= channel) ** GOTO lbl-1000
                            floatbufferin = (float[])ErodeSegmentZ.this.sigsin[c];
                            floatbufferout = (float[])ErodeSegmentZ.this.sigsout[c];
                            for (y = this.miny; y < this.maxy; ++y) {
                                x = 0;
                                pos = x + y * sizex;
                                while (x < sizex) {
                                    FT = 3.4028235E38f;
                                    FG = 3.4028235E38f;
                                    nbprop = 0;
                                    for (z = 0; z < sizez; ++z) {
                                        FT_pre = FT;
                                        FG_pre = FG;
                                        frowval = floatbufferin[pos + z * layer];
                                        FT = z > ds1 ? (FT_pre > frowval ? frowval : FT_pre) : 3.4028235E38f;
                                        if (FG_pre < frowval && nbprop < ErodeSegmentZ.this.sewidth) {
                                            FG = FG_pre;
                                            ++nbprop;
                                        } else {
                                            FG = z > ds1 && nbprop >= ErodeSegmentZ.this.sewidth ? FT : frowval;
                                            FT = 3.4028235E38f;
                                            nbprop = 0;
                                        }
                                        this.bufferfloat[sizez - z - 1] = z - ErodeSegmentZ.this.sewidth < 0 ? FG : Math.min(FG, floatbufferin[pos + (z - ErodeSegmentZ.this.sewidth) * layer]);
                                    }
                                    FT = 3.4028235E38f;
                                    FG = 3.4028235E38f;
                                    nbprop = 0;
                                    frowval = 3.4028235E38f;
                                    frowval_pre = 3.4028235E38f;
                                    for (z = 0; z < sizez; ++z) {
                                        FT_pre = FT;
                                        FG_pre = FG;
                                        frowval_pre = frowval;
                                        frowval = this.bufferfloat[z];
                                        FT = z == 0 ? frowval : (frowval < frowval_pre && FT > frowval ? frowval : FT_pre);
                                        if (FG_pre < frowval && nbprop < ErodeSegmentZ.this.sewidth) {
                                            FG = FG_pre;
                                            ++nbprop;
                                        } else {
                                            FG = nbprop >= ErodeSegmentZ.this.sewidth ? FT : frowval;
                                            FT = 3.4028235E38f;
                                            nbprop = 0;
                                        }
                                        floatbufferout[pos + (sizez - z - 1) * layer] = z < ErodeSegmentZ.this.sewidth ? FG : Math.min(FG, this.bufferfloat[z - ErodeSegmentZ.this.sewidth]);
                                    }
                                    ++x;
                                    ++pos;
                                }
                            }
                            ++c;
                        }
                    }
                    case -5: {
                        c = 0;
                        while (true) {
                            if (c >= channel) continue block11;
                            doublebufferin = (double[])ErodeSegmentZ.this.sigsin[c];
                            doublebufferout = (double[])ErodeSegmentZ.this.sigsout[c];
                            for (y = this.miny; y < this.maxy; ++y) {
                                x = 0;
                                pos = x + y * sizex;
                                while (x < sizex) {
                                    DT = 1.7976931348623157E308;
                                    DG = 1.7976931348623157E308;
                                    nbprop = 0;
                                    for (z = 0; z < sizez; ++z) {
                                        DT_pre = DT;
                                        DG_pre = DG;
                                        drowval = doublebufferin[pos + z * layer];
                                        DT = z > ds1 ? (DT_pre > drowval ? drowval : DT_pre) : 1.7976931348623157E308;
                                        if (DG_pre < drowval && nbprop < ErodeSegmentZ.this.sewidth) {
                                            DG = DG_pre;
                                            ++nbprop;
                                        } else {
                                            DG = z > ds1 && nbprop >= ErodeSegmentZ.this.sewidth ? DT : drowval;
                                            DT = 1.7976931348623157E308;
                                            nbprop = 0;
                                        }
                                        this.bufferdouble[sizez - z - 1] = z - ErodeSegmentZ.this.sewidth < 0 ? DG : Math.min(DG, doublebufferin[pos + (z - ErodeSegmentZ.this.sewidth) * layer]);
                                    }
                                    DT = 1.7976931348623157E308;
                                    DG = 1.7976931348623157E308;
                                    nbprop = 0;
                                    drowval = 1.7976931348623157E308;
                                    drowval_pre = 1.7976931348623157E308;
                                    for (z = 0; z < sizez; ++z) {
                                        DT_pre = DT;
                                        DG_pre = DG;
                                        drowval_pre = drowval;
                                        drowval = this.bufferdouble[z];
                                        DT = z == 0 ? drowval : (drowval < drowval_pre && DT > drowval ? drowval : DT_pre);
                                        if (DG_pre < drowval && nbprop < ErodeSegmentZ.this.sewidth) {
                                            DG = DG_pre;
                                            ++nbprop;
                                        } else {
                                            DG = nbprop >= ErodeSegmentZ.this.sewidth ? DT : drowval;
                                            DT = 1.7976931348623157E308;
                                            nbprop = 0;
                                        }
                                        doublebufferout[pos + (sizez - z - 1) * layer] = z < ErodeSegmentZ.this.sewidth ? DG : Math.min(DG, this.bufferdouble[z - ErodeSegmentZ.this.sewidth]);
                                    }
                                    ++x;
                                    ++pos;
                                }
                            }
                            ++c;
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("Type not supported (yet).");
                    }
                }
                break;
            }
        }
    }

    private class ErodeZhistThread
    extends Thread {
        private int miny;
        private int maxy;
        private int[] Hist = null;
        private int[] buffer = null;
        public final Object lock = new Object();
        private boolean Kill = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.buffer = null;
            this.Hist = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(int miny, int maxy) {
            this.miny = miny;
            this.maxy = maxy;
            switch (ErodeSegmentZ.this.Type) {
                case -2: {
                    if (this.Hist == null) {
                        this.Hist = new int[256];
                    }
                    if (this.buffer == null || this.buffer.length != ErodeSegmentZ.this.SizeZ) {
                        this.buffer = null;
                        this.buffer = new int[ErodeSegmentZ.this.SizeZ];
                    }
                    Arrays.fill(this.Hist, 0);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Type not supported (yet).");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block8: while (true) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        ErodeSegmentZ.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                int type = ErodeSegmentZ.this.Type;
                int sizex = ErodeSegmentZ.this.SizeX;
                int sizez = ErodeSegmentZ.this.SizeZ;
                int layer = ErodeSegmentZ.this.Layer;
                int channel = ErodeSegmentZ.this.Channel;
                switch (type) {
                    case -2: {
                        int c = 0;
                        while (true) {
                            if (c >= channel) continue block8;
                            byte[] bytebufferin = (byte[])ErodeSegmentZ.this.sigsin[c];
                            byte[] bytebufferout = (byte[])ErodeSegmentZ.this.sigsout[c];
                            for (int y = this.miny; y < this.maxy; ++y) {
                                for (int x = 0; x < sizex; ++x) {
                                    int start2;
                                    int aux;
                                    int pos = x + y * sizex;
                                    int i = 0;
                                    int z = pos;
                                    while (i < sizez) {
                                        this.buffer[i] = bytebufferin[z] & 0xFF;
                                        ++i;
                                        z += layer;
                                    }
                                    int mini = 255;
                                    for (z = 0; z < ErodeSegmentZ.this.sewidth; ++z) {
                                        int n = aux = this.buffer[z];
                                        this.Hist[n] = this.Hist[n] + 1;
                                        if (aux >= mini) continue;
                                        mini = aux;
                                    }
                                    z = 0;
                                    while (z < ErodeSegmentZ.this.sewidth) {
                                        int n = aux = this.buffer[z + ErodeSegmentZ.this.sewidth];
                                        this.Hist[n] = this.Hist[n] + 1;
                                        if (aux < mini) {
                                            mini = aux;
                                        }
                                        bytebufferout[pos] = (byte)mini;
                                        ++z;
                                        pos += layer;
                                    }
                                    int start = ErodeSegmentZ.this.sewidth;
                                    int end = sizez - ErodeSegmentZ.this.sewidth;
                                    int z2 = start;
                                    while (z2 < end) {
                                        int aux2;
                                        int n = aux2 = this.buffer[z2 + ErodeSegmentZ.this.sewidth];
                                        this.Hist[n] = this.Hist[n] + 1;
                                        if (aux2 < mini) {
                                            mini = aux2;
                                        }
                                        bytebufferout[pos] = (byte)mini;
                                        int n2 = this.buffer[z2 - ErodeSegmentZ.this.sewidth];
                                        this.Hist[n2] = this.Hist[n2] - 1;
                                        while (this.Hist[mini] == 0) {
                                            ++mini;
                                        }
                                        ++z2;
                                        pos += layer;
                                    }
                                    int z3 = start2 = end;
                                    while (z3 < sizez) {
                                        bytebufferout[pos] = (byte)mini;
                                        int n = this.buffer[z3 - ErodeSegmentZ.this.sewidth];
                                        this.Hist[n] = this.Hist[n] - 1;
                                        while (this.Hist[mini] == 0) {
                                            ++mini;
                                        }
                                        ++z3;
                                        pos += layer;
                                    }
                                    for (z3 = start2; z3 < sizez; ++z3) {
                                        int n = this.buffer[z3];
                                        this.Hist[n] = this.Hist[n] - 1;
                                    }
                                }
                            }
                            bytebufferout = null;
                            bytebufferin = null;
                            ++c;
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("Type not supported (yet).");
                    }
                }
                break;
            }
        }
    }
}

