/*
 * Decompiled with CFR 0.152.
 */
package morphee.fastMorphee;

import arrayTiTi.ArrayMM;
import java.util.Arrays;
import morphee.fastMorphee.FastMorphee;

public class ErodeSegmentY
implements FastMorphee {
    private ErodeYhistThread[] threadshist = null;
    private ErodeYfmThread[] threadsfm = null;
    private ErodeYavThread[] threadsav = null;
    private ErodeInterYhistThread[] threadsinterhist = null;
    private ErodeInterYfmThread[] threadsinterfm = null;
    private ErodeInterYavThread[] threadsinterav = null;
    private int nbFreeThreads = 0;
    private FastMorphee.Algorithm algo = FastMorphee.Algorithm.Histogram;
    private Object sigin;
    private Object sigout;
    private Object[] sigsin;
    private Object[] sigsout;
    private int Channel;
    private int SizeX;
    private int SizeY;
    private int SizeZ;
    private int Layer;
    private int Type;
    private int sewidth;

    @Override
    public synchronized void Kill() {
        int i;
        this.sigout = null;
        this.sigin = null;
        this.sigsout = null;
        this.sigsin = null;
        if (this.threadshist != null) {
            for (i = 0; i < this.threadshist.length; ++i) {
                this.threadshist[i].Kill();
                this.threadshist[i] = null;
            }
            this.threadshist = null;
        }
        if (this.threadsfm != null) {
            for (i = 0; i < this.threadsfm.length; ++i) {
                this.threadsfm[i].Kill();
                this.threadsfm[i] = null;
            }
            this.threadsfm = null;
        }
        if (this.threadsav != null) {
            for (i = 0; i < this.threadsav.length; ++i) {
                this.threadsav[i].Kill();
                this.threadsav[i] = null;
            }
            this.threadsav = null;
        }
        if (this.threadsinterhist != null) {
            for (i = 0; i < this.threadsinterhist.length; ++i) {
                this.threadsinterhist[i].Kill();
                this.threadsinterhist[i] = null;
            }
            this.threadsinterhist = null;
        }
        if (this.threadsinterfm != null) {
            for (i = 0; i < this.threadsinterfm.length; ++i) {
                this.threadsinterfm[i].Kill();
                this.threadsinterfm[i] = null;
            }
            this.threadsinterfm = null;
        }
        if (this.threadsinterav != null) {
            for (i = 0; i < this.threadsinterav.length; ++i) {
                this.threadsinterav[i].Kill();
                this.threadsinterav[i] = null;
            }
            this.threadsinterav = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void FilterInterlaced(Object source, int sizex, int sizey, int sizez, int channel, int type, int sewidth, Object result, int nbCPU) {
        Object object;
        if (sewidth < 1) {
            throw new IllegalArgumentException("The structuring element order must be positive.");
        }
        this.sewidth = sewidth;
        switch (type) {
            case -2: {
                if (sewidth <= 3) {
                    this.StartInterlacedAV(nbCPU);
                    break;
                }
                this.StartInterlacedHist(nbCPU);
                break;
            }
            case -3: {
                if (sewidth <= 4 || channel != 1) {
                    this.StartInterlacedAV(nbCPU);
                    break;
                }
                this.StartInterlacedFM(nbCPU);
                break;
            }
            case -5: 
            case -4: 
            case -1: {
                if (sewidth <= 4 || channel != 1) {
                    this.StartInterlacedAV(nbCPU);
                    break;
                }
                this.StartInterlacedFM(nbCPU);
                break;
            }
            default: {
                throw new IllegalArgumentException("Object type unknown.");
            }
        }
        this.sigin = source;
        this.sigout = result;
        this.SizeX = sizex;
        this.SizeY = sizey;
        this.SizeZ = sizez;
        this.Layer = sizex * sizey;
        this.Channel = channel;
        this.Type = type;
        ErodeSegmentY erodeSegmentY = this;
        synchronized (erodeSegmentY) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        this.nbFreeThreads = 0;
        int nbCPUm1 = nbCPU - 1;
        switch (this.algo) {
            case AutoVectorization: {
                Object object2;
                int step = sizey / nbCPU;
                for (int i = 0; i < nbCPUm1; ++i) {
                    this.threadsinterav[i].setConditions(i * step, (i + 1) * step);
                    object2 = this.threadsinterav[i].lock;
                    synchronized (object2) {
                        this.threadsinterav[i].lock.notify();
                        continue;
                    }
                }
                this.threadsinterav[nbCPUm1].setConditions(nbCPUm1 * step, sizey);
                Object i = this.threadsinterav[nbCPUm1].lock;
                synchronized (i) {
                    this.threadsinterav[nbCPUm1].lock.notify();
                    break;
                }
            }
            case FastMorphM: {
                Object object2;
                int step = sizex / nbCPU;
                for (int i = 0; i < nbCPU - 1; ++i) {
                    this.threadsinterfm[i].setConditions(i * step, (i + 1) * step);
                    object2 = this.threadsinterfm[i].lock;
                    synchronized (object2) {
                        this.threadsinterfm[i].lock.notify();
                        continue;
                    }
                }
                this.threadsinterfm[nbCPUm1].setConditions(nbCPUm1 * step, sizex);
                Object i = this.threadsinterfm[nbCPUm1].lock;
                synchronized (i) {
                    this.threadsinterfm[nbCPUm1].lock.notify();
                    break;
                }
            }
            case Histogram: {
                Object object2;
                int step = sizex / nbCPU;
                for (int i = 0; i < nbCPUm1; ++i) {
                    this.threadsinterhist[i].setConditions(i * step, (i + 1) * step);
                    object2 = this.threadsinterhist[i].lock;
                    synchronized (object2) {
                        this.threadsinterhist[i].lock.notify();
                        continue;
                    }
                }
                this.threadsinterhist[nbCPUm1].setConditions(nbCPUm1 * step, sizex);
                object = this.threadsinterhist[nbCPUm1].lock;
                synchronized (object) {
                    this.threadsinterhist[nbCPUm1].lock.notify();
                    break;
                }
            }
            default: {
                throw new IllegalArgumentException("Unknown algorithm.");
            }
        }
        object = this;
        synchronized (object) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void StartInterlacedHist(int nbCPU) {
        this.algo = FastMorphee.Algorithm.Histogram;
        if (this.threadsinterhist != null && this.threadsinterhist.length == nbCPU) {
            return;
        }
        this.Kill();
        this.nbFreeThreads = 0;
        this.threadsinterhist = new ErodeInterYhistThread[nbCPU];
        for (int i = 0; i < nbCPU; ++i) {
            this.threadsinterhist[i] = new ErodeInterYhistThread();
            this.threadsinterhist[i].start();
        }
    }

    private void StartInterlacedFM(int nbCPU) {
        this.algo = FastMorphee.Algorithm.FastMorphM;
        if (this.threadsinterfm != null && this.threadsinterfm.length == nbCPU) {
            return;
        }
        this.Kill();
        this.nbFreeThreads = 0;
        this.threadsinterfm = new ErodeInterYfmThread[nbCPU];
        for (int i = 0; i < nbCPU; ++i) {
            this.threadsinterfm[i] = new ErodeInterYfmThread();
            this.threadsinterfm[i].start();
        }
    }

    private void StartInterlacedAV(int nbCPU) {
        this.algo = FastMorphee.Algorithm.AutoVectorization;
        if (this.threadsinterav != null && this.threadsinterav.length == nbCPU) {
            return;
        }
        this.Kill();
        this.nbFreeThreads = 0;
        this.threadsinterav = new ErodeInterYavThread[nbCPU];
        for (int i = 0; i < nbCPU; ++i) {
            this.threadsinterav[i] = new ErodeInterYavThread();
            this.threadsinterav[i].start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Filter(Object[] sources, int sizex, int sizey, int sizez, int type, int sewidth, Object[] results, int nbCPU) {
        Object object;
        if (sewidth < 1) {
            throw new IllegalArgumentException("The structuring element order must be positive.");
        }
        this.sewidth = sewidth;
        switch (type) {
            case -2: {
                if (sewidth <= 3) {
                    this.StartAV(nbCPU);
                    break;
                }
                this.StartHist(nbCPU);
                break;
            }
            case -3: {
                if (sewidth <= 3) {
                    this.StartAV(nbCPU);
                    break;
                }
                this.StartFM(nbCPU);
                break;
            }
            case -5: 
            case -4: 
            case -1: {
                if (sewidth <= 3) {
                    this.StartAV(nbCPU);
                    break;
                }
                this.StartFM(nbCPU);
                break;
            }
            default: {
                throw new IllegalArgumentException("Object type unknown.");
            }
        }
        this.sigsin = sources;
        this.sigsout = results;
        this.SizeX = sizex;
        this.SizeY = sizey;
        this.SizeZ = sizez;
        this.Layer = sizex * sizey;
        this.Channel = sources.length;
        this.Type = type;
        ErodeSegmentY erodeSegmentY = this;
        synchronized (erodeSegmentY) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        this.nbFreeThreads = 0;
        int nbCPUm1 = nbCPU - 1;
        switch (this.algo) {
            case AutoVectorization: {
                Object object2;
                int step = sizey / nbCPU;
                for (int i = 0; i < nbCPUm1; ++i) {
                    this.threadsav[i].setConditions(i * step, (i + 1) * step);
                    object2 = this.threadsav[i].lock;
                    synchronized (object2) {
                        this.threadsav[i].lock.notify();
                        continue;
                    }
                }
                this.threadsav[nbCPUm1].setConditions(nbCPUm1 * step, sizey);
                Object i = this.threadsav[nbCPUm1].lock;
                synchronized (i) {
                    this.threadsav[nbCPUm1].lock.notify();
                    break;
                }
            }
            case FastMorphM: {
                Object object2;
                int step = sizex / nbCPU;
                for (int i = 0; i < nbCPUm1; ++i) {
                    this.threadsfm[i].setConditions(i * step, (i + 1) * step);
                    object2 = this.threadsfm[i].lock;
                    synchronized (object2) {
                        this.threadsfm[i].lock.notify();
                        continue;
                    }
                }
                this.threadsfm[nbCPUm1].setConditions(nbCPUm1 * step, sizex);
                Object i = this.threadsfm[nbCPUm1].lock;
                synchronized (i) {
                    this.threadsfm[nbCPUm1].lock.notify();
                    break;
                }
            }
            case Histogram: {
                Object object2;
                int step = sizex / nbCPU;
                for (int i = 0; i < nbCPUm1; ++i) {
                    this.threadshist[i].setConditions(i * step, (i + 1) * step);
                    object2 = this.threadshist[i].lock;
                    synchronized (object2) {
                        this.threadshist[i].lock.notify();
                        continue;
                    }
                }
                this.threadshist[nbCPUm1].setConditions(nbCPUm1 * step, sizex);
                object = this.threadshist[nbCPUm1].lock;
                synchronized (object) {
                    this.threadshist[nbCPUm1].lock.notify();
                    break;
                }
            }
            default: {
                throw new IllegalArgumentException("Unknown algorithm.");
            }
        }
        object = this;
        synchronized (object) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void StartHist(int nbCPU) {
        this.algo = FastMorphee.Algorithm.Histogram;
        if (this.threadshist != null && this.threadshist.length == nbCPU) {
            return;
        }
        this.Kill();
        this.nbFreeThreads = 0;
        this.threadshist = new ErodeYhistThread[nbCPU];
        for (int i = 0; i < nbCPU; ++i) {
            this.threadshist[i] = new ErodeYhistThread();
            this.threadshist[i].start();
        }
    }

    private void StartFM(int nbCPU) {
        this.algo = FastMorphee.Algorithm.FastMorphM;
        if (this.threadsfm != null && this.threadsfm.length == nbCPU) {
            return;
        }
        this.Kill();
        this.nbFreeThreads = 0;
        this.threadsfm = new ErodeYfmThread[nbCPU];
        for (int i = 0; i < nbCPU; ++i) {
            this.threadsfm[i] = new ErodeYfmThread();
            this.threadsfm[i].start();
        }
    }

    private void StartAV(int nbCPU) {
        this.algo = FastMorphee.Algorithm.AutoVectorization;
        if (this.threadsav != null && this.threadsav.length == nbCPU) {
            return;
        }
        this.Kill();
        this.nbFreeThreads = 0;
        this.threadsav = new ErodeYavThread[nbCPU];
        for (int i = 0; i < nbCPU; ++i) {
            this.threadsav[i] = new ErodeYavThread();
            this.threadsav[i].start();
        }
    }

    protected synchronized void addFreeThread() {
        ++this.nbFreeThreads;
        this.notify();
    }

    private class ErodeInterYavThread
    extends Thread {
        private int miny;
        private int maxy;
        public final Object lock = new Object();
        private boolean Kill = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(int miny, int maxy) {
            this.miny = miny;
            this.maxy = maxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block12: while (true) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        ErodeSegmentY.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                int type = ErodeSegmentY.this.Type;
                int sizex = ErodeSegmentY.this.SizeX;
                int sizey = ErodeSegmentY.this.SizeY;
                int sizez = ErodeSegmentY.this.SizeZ;
                int layer = ErodeSegmentY.this.Layer;
                int channel = ErodeSegmentY.this.Channel;
                int sizexchannel = sizex * channel;
                switch (type) {
                    case -2: {
                        byte[] bytebufferin = (byte[])ErodeSegmentY.this.sigin;
                        byte[] bytebufferout = (byte[])ErodeSegmentY.this.sigout;
                        for (int z = 0; z < sizez; ++z) {
                            int y = this.miny;
                            int pos = (z * layer + y * sizex) * channel;
                            while (y < this.maxy) {
                                System.arraycopy(bytebufferin, pos, bytebufferout, pos, sizexchannel);
                                int s = -1;
                                int p = pos - sizexchannel;
                                while (-ErodeSegmentY.this.sewidth <= s && 0 <= y + s) {
                                    ArrayMM.MinimumUnsigned(bytebufferin, p, bytebufferout, pos, bytebufferout, pos, sizexchannel);
                                    --s;
                                    p -= sizexchannel;
                                }
                                s = 1;
                                p = pos + sizexchannel;
                                while (s <= ErodeSegmentY.this.sewidth && y + s < sizey) {
                                    ArrayMM.MinimumUnsigned(bytebufferin, p, bytebufferout, pos, bytebufferout, pos, sizexchannel);
                                    ++s;
                                    p += sizexchannel;
                                }
                                ++y;
                                pos += sizexchannel;
                            }
                        }
                        bytebufferout = null;
                        bytebufferin = null;
                        continue block12;
                    }
                    case -3: {
                        short[] shortbufferin = (short[])ErodeSegmentY.this.sigin;
                        short[] shortbufferout = (short[])ErodeSegmentY.this.sigout;
                        for (int z = 0; z < sizez; ++z) {
                            int y = this.miny;
                            int pos = (z * layer + y * sizex) * channel;
                            while (y < this.maxy) {
                                System.arraycopy(shortbufferin, pos, shortbufferout, pos, sizexchannel);
                                int s = -1;
                                int p = pos - sizexchannel;
                                while (-ErodeSegmentY.this.sewidth <= s && 0 <= y + s) {
                                    ArrayMM.MinimumUnsigned(shortbufferin, p, shortbufferout, pos, shortbufferout, pos, sizexchannel);
                                    --s;
                                    p -= sizexchannel;
                                }
                                s = 1;
                                p = pos + sizexchannel;
                                while (s <= ErodeSegmentY.this.sewidth && y + s < sizey) {
                                    ArrayMM.MinimumUnsigned(shortbufferin, p, shortbufferout, pos, shortbufferout, pos, sizexchannel);
                                    ++s;
                                    p += sizexchannel;
                                }
                                ++y;
                                pos += sizexchannel;
                            }
                        }
                        shortbufferout = null;
                        shortbufferin = null;
                        continue block12;
                    }
                    case -1: {
                        int[] intbufferin = (int[])ErodeSegmentY.this.sigin;
                        int[] intbufferout = (int[])ErodeSegmentY.this.sigout;
                        for (int z = 0; z < sizez; ++z) {
                            int y = this.miny;
                            int pos = (z * layer + y * sizex) * channel;
                            while (y < this.maxy) {
                                System.arraycopy(intbufferin, pos, intbufferout, pos, sizexchannel);
                                int s = -1;
                                int p = pos - sizexchannel;
                                while (-ErodeSegmentY.this.sewidth <= s && 0 <= y + s) {
                                    ArrayMM.Minimum(intbufferin, p, intbufferout, pos, intbufferout, pos, sizexchannel);
                                    --s;
                                    p -= sizexchannel;
                                }
                                s = 1;
                                p = pos + sizexchannel;
                                while (s <= ErodeSegmentY.this.sewidth && y + s < sizey) {
                                    ArrayMM.Minimum(intbufferin, p, intbufferout, pos, intbufferout, pos, sizexchannel);
                                    ++s;
                                    p += sizexchannel;
                                }
                                ++y;
                                pos += sizexchannel;
                            }
                        }
                        intbufferout = null;
                        intbufferin = null;
                        continue block12;
                    }
                    case -4: {
                        float[] floatbufferin = (float[])ErodeSegmentY.this.sigin;
                        float[] floatbufferout = (float[])ErodeSegmentY.this.sigout;
                        for (int z = 0; z < sizez; ++z) {
                            int y = this.miny;
                            int pos = (z * layer + y * sizex) * channel;
                            while (y < this.maxy) {
                                System.arraycopy(floatbufferin, pos, floatbufferout, pos, sizexchannel);
                                int s = -1;
                                int p = pos - sizexchannel;
                                while (-ErodeSegmentY.this.sewidth <= s && 0 <= y + s) {
                                    ArrayMM.Minimum(floatbufferin, p, floatbufferout, pos, floatbufferout, pos, sizexchannel);
                                    --s;
                                    p -= sizexchannel;
                                }
                                s = 1;
                                p = pos + sizexchannel;
                                while (s <= ErodeSegmentY.this.sewidth && y + s < sizey) {
                                    ArrayMM.Minimum(floatbufferin, p, floatbufferout, pos, floatbufferout, pos, sizexchannel);
                                    ++s;
                                    p += sizexchannel;
                                }
                                ++y;
                                pos += sizex;
                            }
                        }
                        floatbufferout = null;
                        floatbufferin = null;
                        continue block12;
                    }
                    case -5: {
                        double[] doublebufferin = (double[])ErodeSegmentY.this.sigin;
                        double[] doublebufferout = (double[])ErodeSegmentY.this.sigout;
                        for (int z = 0; z < sizez; ++z) {
                            int y = this.miny;
                            int pos = (z * layer + y * sizex) * channel;
                            while (y < this.maxy) {
                                System.arraycopy(doublebufferin, pos, doublebufferout, pos, sizexchannel);
                                int s = -1;
                                int p = pos - sizexchannel;
                                while (-ErodeSegmentY.this.sewidth <= s && 0 <= y + s) {
                                    ArrayMM.Minimum(doublebufferin, p, doublebufferout, pos, doublebufferout, pos, sizexchannel);
                                    --s;
                                    p -= sizexchannel;
                                }
                                s = 1;
                                p = pos + sizexchannel;
                                while (s <= ErodeSegmentY.this.sewidth && y + s < sizey) {
                                    ArrayMM.Minimum(doublebufferin, p, doublebufferout, pos, doublebufferout, pos, sizexchannel);
                                    ++s;
                                    p += sizexchannel;
                                }
                                ++y;
                                pos += sizexchannel;
                            }
                        }
                        doublebufferout = null;
                        doublebufferin = null;
                        continue block12;
                    }
                }
                break;
            }
            throw new IllegalArgumentException("Type not supported (yet).");
        }
    }

    private class ErodeInterYfmThread
    extends Thread {
        private int minx;
        private int maxx;
        private int[] buffer = null;
        private float[] bufferfloat = null;
        private double[] bufferdouble = null;
        public final Object lock = new Object();
        private boolean Kill = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.buffer = null;
            this.bufferfloat = null;
            this.bufferdouble = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(int minx, int maxx) {
            if (ErodeSegmentY.this.Channel != 1) {
                throw new IllegalArgumentException("Only single channel signal supported (so far).");
            }
            this.minx = minx;
            this.maxx = maxx;
            switch (ErodeSegmentY.this.Type) {
                case -3: 
                case -1: {
                    this.bufferdouble = null;
                    this.bufferfloat = null;
                    if (this.buffer != null && this.buffer.length == ErodeSegmentY.this.SizeY) break;
                    this.buffer = null;
                    this.buffer = new int[ErodeSegmentY.this.SizeY];
                    break;
                }
                case -4: {
                    this.buffer = null;
                    this.bufferdouble = null;
                    if (this.bufferfloat != null && this.bufferfloat.length == ErodeSegmentY.this.SizeY) break;
                    this.bufferfloat = null;
                    this.bufferfloat = new float[ErodeSegmentY.this.SizeY];
                    break;
                }
                case -5: {
                    this.buffer = null;
                    this.bufferfloat = null;
                    if (this.bufferdouble != null && this.bufferdouble.length == ErodeSegmentY.this.SizeY) break;
                    this.bufferdouble = null;
                    this.bufferdouble = new double[ErodeSegmentY.this.SizeY];
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Type not supported (yet).");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block11: while (true) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        ErodeSegmentY.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                int type = ErodeSegmentY.this.Type;
                int sizex = ErodeSegmentY.this.SizeX;
                int sizey = ErodeSegmentY.this.SizeY;
                int sizez = ErodeSegmentY.this.SizeZ;
                int layer = ErodeSegmentY.this.Layer;
                int hs1 = sizey - ErodeSegmentY.this.sewidth - 1;
                switch (type) {
                    case -3: {
                        short[] shortbufferin = (short[])ErodeSegmentY.this.sigin;
                        short[] shortbufferout = (short[])ErodeSegmentY.this.sigout;
                        for (int z = 0; z < sizez; ++z) {
                            int x = this.minx;
                            int pos = x + z * layer;
                            while (x < this.maxx) {
                                int T = 65535;
                                int G = 65535;
                                int nbprop = 0;
                                for (int y = 0; y < sizey; ++y) {
                                    int T_pre = T;
                                    int G_pre = G;
                                    int rowval = shortbufferin[pos + y * sizex] & 0xFFFF;
                                    T = y > hs1 ? (T_pre > rowval ? rowval : T_pre) : 65535;
                                    if (G_pre < rowval && nbprop < ErodeSegmentY.this.sewidth) {
                                        G = G_pre;
                                        ++nbprop;
                                    } else {
                                        G = y > hs1 && nbprop >= ErodeSegmentY.this.sewidth ? T : rowval;
                                        T = 65535;
                                        nbprop = 0;
                                    }
                                    this.buffer[sizey - y - 1] = y - ErodeSegmentY.this.sewidth < 0 ? G : Math.min(G, shortbufferin[pos + (y - ErodeSegmentY.this.sewidth) * sizex] & 0xFFFF);
                                }
                                T = 65535;
                                G = 65535;
                                nbprop = 0;
                                int rowval = 65535;
                                int rowval_pre = 65535;
                                for (int y = 0; y < sizey; ++y) {
                                    int T_pre = T;
                                    int G_pre = G;
                                    rowval_pre = rowval;
                                    rowval = this.buffer[y];
                                    T = y == 0 ? rowval : (rowval < rowval_pre && T > rowval ? rowval : T_pre);
                                    if (G_pre < rowval && nbprop < ErodeSegmentY.this.sewidth) {
                                        G = G_pre;
                                        ++nbprop;
                                    } else {
                                        G = nbprop >= ErodeSegmentY.this.sewidth ? T : rowval;
                                        T = 65535;
                                        nbprop = 0;
                                    }
                                    shortbufferout[pos + (sizey - y - 1) * sizex] = y < ErodeSegmentY.this.sewidth ? (short)G : (short)Math.min(G, this.buffer[y - ErodeSegmentY.this.sewidth]);
                                }
                                ++x;
                                ++pos;
                            }
                        }
                        shortbufferout = null;
                        shortbufferin = null;
                        continue block11;
                    }
                    case -1: {
                        int[] intbufferin = (int[])ErodeSegmentY.this.sigin;
                        int[] intbufferout = (int[])ErodeSegmentY.this.sigout;
                        for (int z = 0; z < sizez; ++z) {
                            int x = this.minx;
                            int pos = x + z * layer;
                            while (x < this.maxx) {
                                int T = Integer.MAX_VALUE;
                                int G = Integer.MAX_VALUE;
                                int nbprop = 0;
                                for (int y = 0; y < sizey; ++y) {
                                    int T_pre = T;
                                    int G_pre = G;
                                    int rowval = intbufferin[pos + y * sizex];
                                    T = y > hs1 ? (T_pre > rowval ? rowval : T_pre) : Integer.MAX_VALUE;
                                    if (G_pre < rowval && nbprop < ErodeSegmentY.this.sewidth) {
                                        G = G_pre;
                                        ++nbprop;
                                    } else {
                                        G = y > hs1 && nbprop >= ErodeSegmentY.this.sewidth ? T : rowval;
                                        T = Integer.MAX_VALUE;
                                        nbprop = 0;
                                    }
                                    this.buffer[sizey - y - 1] = y - ErodeSegmentY.this.sewidth < 0 ? G : Math.min(G, intbufferin[pos + (y - ErodeSegmentY.this.sewidth) * sizex]);
                                }
                                T = Integer.MAX_VALUE;
                                G = Integer.MAX_VALUE;
                                nbprop = 0;
                                int rowval = Integer.MAX_VALUE;
                                int rowval_pre = Integer.MAX_VALUE;
                                for (int y = 0; y < sizey; ++y) {
                                    int T_pre = T;
                                    int G_pre = G;
                                    rowval_pre = rowval;
                                    rowval = this.buffer[y];
                                    T = y == 0 ? rowval : (rowval < rowval_pre && T > rowval ? rowval : T_pre);
                                    if (G_pre < rowval && nbprop < ErodeSegmentY.this.sewidth) {
                                        G = G_pre;
                                        ++nbprop;
                                    } else {
                                        G = nbprop >= ErodeSegmentY.this.sewidth ? T : rowval;
                                        T = Integer.MAX_VALUE;
                                        nbprop = 0;
                                    }
                                    intbufferout[pos + (sizey - y - 1) * sizex] = y < ErodeSegmentY.this.sewidth ? G : Math.min(G, this.buffer[y - ErodeSegmentY.this.sewidth]);
                                }
                                ++x;
                                ++pos;
                            }
                        }
                        intbufferout = null;
                        intbufferin = null;
                        continue block11;
                    }
                    case -4: {
                        float[] floatbufferin = (float[])ErodeSegmentY.this.sigin;
                        float[] floatbufferout = (float[])ErodeSegmentY.this.sigout;
                        for (int z = 0; z < sizez; ++z) {
                            int x = this.minx;
                            int pos = x + z * layer;
                            while (x < this.maxx) {
                                float FT = Float.MAX_VALUE;
                                float FG = Float.MAX_VALUE;
                                int nbprop = 0;
                                for (int y = 0; y < sizey; ++y) {
                                    float FT_pre = FT;
                                    float FG_pre = FG;
                                    float frowval = floatbufferin[pos + y * sizex];
                                    FT = y > hs1 ? (FT_pre > frowval ? frowval : FT_pre) : Float.MAX_VALUE;
                                    if (FG_pre < frowval && nbprop < ErodeSegmentY.this.sewidth) {
                                        FG = FG_pre;
                                        ++nbprop;
                                    } else {
                                        FG = y > hs1 && nbprop >= ErodeSegmentY.this.sewidth ? FT : frowval;
                                        FT = Float.MAX_VALUE;
                                        nbprop = 0;
                                    }
                                    this.bufferfloat[sizey - y - 1] = y - ErodeSegmentY.this.sewidth < 0 ? FG : Math.min(FG, floatbufferin[pos + (y - ErodeSegmentY.this.sewidth) * sizex]);
                                }
                                FT = Float.MAX_VALUE;
                                FG = Float.MAX_VALUE;
                                nbprop = 0;
                                float frowval = Float.MAX_VALUE;
                                float frowval_pre = Float.MAX_VALUE;
                                for (int y = 0; y < sizey; ++y) {
                                    float FT_pre = FT;
                                    float FG_pre = FG;
                                    frowval_pre = frowval;
                                    frowval = this.bufferfloat[y];
                                    FT = y == 0 ? frowval : (frowval < frowval_pre && FT > frowval ? frowval : FT_pre);
                                    if (FG_pre < frowval && nbprop < ErodeSegmentY.this.sewidth) {
                                        FG = FG_pre;
                                        ++nbprop;
                                    } else {
                                        FG = nbprop >= ErodeSegmentY.this.sewidth ? FT : frowval;
                                        FT = Float.MAX_VALUE;
                                        nbprop = 0;
                                    }
                                    floatbufferout[pos + (sizey - y - 1) * sizex] = y < ErodeSegmentY.this.sewidth ? FG : Math.min(FG, this.bufferfloat[y - ErodeSegmentY.this.sewidth]);
                                }
                                ++x;
                                ++pos;
                            }
                        }
                        floatbufferout = null;
                        floatbufferin = null;
                        continue block11;
                    }
                    case -5: {
                        double[] doublebufferin = (double[])ErodeSegmentY.this.sigin;
                        double[] doublebufferout = (double[])ErodeSegmentY.this.sigout;
                        for (int z = 0; z < sizez; ++z) {
                            int x = this.minx;
                            int pos = x + z * layer;
                            while (x < this.maxx) {
                                double DT = Double.MAX_VALUE;
                                double DG = Double.MAX_VALUE;
                                int nbprop = 0;
                                for (int y = 0; y < sizey; ++y) {
                                    double DT_pre = DT;
                                    double DG_pre = DG;
                                    double drowval = doublebufferin[pos + y * sizex];
                                    DT = y > hs1 ? (DT_pre > drowval ? drowval : DT_pre) : Double.MAX_VALUE;
                                    if (DG_pre < drowval && nbprop < ErodeSegmentY.this.sewidth) {
                                        DG = DG_pre;
                                        ++nbprop;
                                    } else {
                                        DG = y > hs1 && nbprop >= ErodeSegmentY.this.sewidth ? DT : drowval;
                                        DT = Double.MAX_VALUE;
                                        nbprop = 0;
                                    }
                                    this.bufferdouble[sizey - y - 1] = y - ErodeSegmentY.this.sewidth < 0 ? DG : Math.min(DG, doublebufferin[pos + (y - ErodeSegmentY.this.sewidth) * sizex]);
                                }
                                DT = Double.MAX_VALUE;
                                DG = Double.MAX_VALUE;
                                nbprop = 0;
                                double drowval = Double.MAX_VALUE;
                                double drowval_pre = Double.MAX_VALUE;
                                for (int y = 0; y < sizey; ++y) {
                                    double DT_pre = DT;
                                    double DG_pre = DG;
                                    drowval_pre = drowval;
                                    drowval = this.bufferdouble[y];
                                    DT = y == 0 ? drowval : (drowval < drowval_pre && DT > drowval ? drowval : DT_pre);
                                    if (DG_pre < drowval && nbprop < ErodeSegmentY.this.sewidth) {
                                        DG = DG_pre;
                                        ++nbprop;
                                    } else {
                                        DG = nbprop >= ErodeSegmentY.this.sewidth ? DT : drowval;
                                        DT = Double.MAX_VALUE;
                                        nbprop = 0;
                                    }
                                    doublebufferout[pos + (sizey - y - 1) * sizex] = y < ErodeSegmentY.this.sewidth ? DG : Math.min(DG, this.bufferdouble[y - ErodeSegmentY.this.sewidth]);
                                }
                                ++x;
                                ++pos;
                            }
                        }
                        doublebufferout = null;
                        doublebufferin = null;
                        continue block11;
                    }
                }
                break;
            }
            throw new IllegalArgumentException("Type not supported (yet).");
        }
    }

    private class ErodeInterYhistThread
    extends Thread {
        private int minx;
        private int maxx;
        private int[] Hist = new int[256];
        public final Object lock = new Object();
        private boolean Kill = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.Hist = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(int minx, int maxx) {
            this.minx = minx;
            this.maxx = maxx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block8: while (true) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        ErodeSegmentY.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                int type = ErodeSegmentY.this.Type;
                int sizex = ErodeSegmentY.this.SizeX;
                int sizez = ErodeSegmentY.this.SizeZ;
                int layer = ErodeSegmentY.this.Layer;
                int channel = ErodeSegmentY.this.Channel;
                int sizexchannel = sizex * channel;
                int layerchannel = layer * channel;
                int sewidthwidthchannel = ErodeSegmentY.this.sewidth * sizexchannel;
                Arrays.fill(this.Hist, 0);
                switch (type) {
                    case -2: {
                        byte[] bytebufferin = (byte[])ErodeSegmentY.this.sigin;
                        byte[] bytebufferout = (byte[])ErodeSegmentY.this.sigout;
                        for (int z = 0; z < sizez; ++z) {
                            for (int x = this.minx; x < this.maxx; ++x) {
                                for (int c = 0; c < channel; ++c) {
                                    int y;
                                    int aux;
                                    int y2;
                                    int mini = 255;
                                    int pos = (z * layer + x) * channel + c;
                                    int end = pos + sewidthwidthchannel;
                                    for (y2 = pos; y2 < end; y2 += sizexchannel) {
                                        int n = aux = bytebufferin[y2] & 0xFF;
                                        this.Hist[n] = this.Hist[n] + 1;
                                        if (aux >= mini) continue;
                                        mini = aux;
                                    }
                                    for (y2 = pos; y2 < end; y2 += sizexchannel) {
                                        int n = aux = bytebufferin[y2 + sewidthwidthchannel] & 0xFF;
                                        this.Hist[n] = this.Hist[n] + 1;
                                        if (aux < mini) {
                                            mini = aux;
                                        }
                                        bytebufferout[y2] = (byte)mini;
                                    }
                                    int start = pos + sewidthwidthchannel;
                                    int end2 = pos + (sizex - ErodeSegmentY.this.sewidth) * sizexchannel;
                                    for (int y3 = start; y3 < end2; y3 += sizexchannel) {
                                        int aux2;
                                        int n = aux2 = bytebufferin[y3 + sewidthwidthchannel] & 0xFF;
                                        this.Hist[n] = this.Hist[n] + 1;
                                        if (aux2 < mini) {
                                            mini = aux2;
                                        }
                                        bytebufferout[y3] = (byte)mini;
                                        int n2 = bytebufferin[y3 - sewidthwidthchannel] & 0xFF;
                                        this.Hist[n2] = this.Hist[n2] - 1;
                                        while (this.Hist[mini] == 0) {
                                            ++mini;
                                        }
                                    }
                                    int start2 = end2;
                                    int end3 = pos + layerchannel;
                                    for (y = start2; y < end3; y += sizexchannel) {
                                        bytebufferout[y] = (byte)mini;
                                        int n = bytebufferin[y - sewidthwidthchannel] & 0xFF;
                                        this.Hist[n] = this.Hist[n] - 1;
                                        while (this.Hist[mini] == 0) {
                                            ++mini;
                                        }
                                    }
                                    for (y = start2; y < end3; y += sizexchannel) {
                                        int n = bytebufferin[y] & 0xFF;
                                        this.Hist[n] = this.Hist[n] - 1;
                                    }
                                }
                            }
                        }
                        bytebufferout = null;
                        bytebufferin = null;
                        continue block8;
                    }
                }
                break;
            }
            throw new IllegalArgumentException("Type not supported (yet).");
        }
    }

    private class ErodeYavThread
    extends Thread {
        private int miny;
        private int maxy;
        public final Object lock = new Object();
        private boolean Kill = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(int miny, int maxy) {
            this.miny = miny;
            this.maxy = maxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block12: while (true) lbl-1000:
            // 6 sources

            {
                var1_2 = this.lock;
                synchronized (var1_2) {
                    try {
                        ErodeSegmentY.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                type = ErodeSegmentY.this.Type;
                sizex = ErodeSegmentY.this.SizeX;
                sizey = ErodeSegmentY.this.SizeY;
                sizez = ErodeSegmentY.this.SizeZ;
                layer = ErodeSegmentY.this.Layer;
                channel = ErodeSegmentY.this.Channel;
                switch (type) {
                    case -2: {
                        c = 0;
                        while (true) {
                            if (c >= channel) ** GOTO lbl-1000
                            bytebufferin = (byte[])ErodeSegmentY.this.sigsin[c];
                            bytebufferout = (byte[])ErodeSegmentY.this.sigsout[c];
                            for (z = 0; z < sizez; ++z) {
                                y = this.miny;
                                pos = z * layer + y * sizex;
                                while (y < this.maxy) {
                                    System.arraycopy(bytebufferin, pos, bytebufferout, pos, sizex);
                                    s = -1;
                                    p = pos - sizex;
                                    while (-ErodeSegmentY.this.sewidth <= s && 0 <= y + s) {
                                        ArrayMM.MinimumUnsigned(bytebufferin, p, bytebufferout, pos, bytebufferout, pos, sizex);
                                        --s;
                                        p -= sizex;
                                    }
                                    s = 1;
                                    p = pos + sizex;
                                    while (s <= ErodeSegmentY.this.sewidth && y + s < sizey) {
                                        ArrayMM.MinimumUnsigned(bytebufferin, p, bytebufferout, pos, bytebufferout, pos, sizex);
                                        ++s;
                                        p += sizex;
                                    }
                                    ++y;
                                    pos += sizex;
                                }
                            }
                            bytebufferout = null;
                            bytebufferin = null;
                            ++c;
                        }
                    }
                    case -3: {
                        c = 0;
                        while (true) {
                            if (c >= channel) ** GOTO lbl-1000
                            shortbufferin = (short[])ErodeSegmentY.this.sigsin[c];
                            shortbufferout = (short[])ErodeSegmentY.this.sigsout[c];
                            for (z = 0; z < sizez; ++z) {
                                y = this.miny;
                                pos = z * layer + y * sizex;
                                while (y < this.maxy) {
                                    System.arraycopy(shortbufferin, pos, shortbufferout, pos, sizex);
                                    s = -1;
                                    p = pos - sizex;
                                    while (-ErodeSegmentY.this.sewidth <= s && 0 <= y + s) {
                                        ArrayMM.MinimumUnsigned(shortbufferin, p, shortbufferout, pos, shortbufferout, pos, sizex);
                                        --s;
                                        p -= sizex;
                                    }
                                    s = 1;
                                    p = pos + sizex;
                                    while (s <= ErodeSegmentY.this.sewidth && y + s < sizey) {
                                        ArrayMM.MinimumUnsigned(shortbufferin, p, shortbufferout, pos, shortbufferout, pos, sizex);
                                        ++s;
                                        p += sizex;
                                    }
                                    ++y;
                                    pos += sizex;
                                }
                            }
                            shortbufferout = null;
                            shortbufferin = null;
                            ++c;
                        }
                    }
                    case -1: {
                        c = 0;
                        while (true) {
                            if (c >= channel) ** GOTO lbl-1000
                            intbufferin = (int[])ErodeSegmentY.this.sigsin[c];
                            intbufferout = (int[])ErodeSegmentY.this.sigsout[c];
                            for (z = 0; z < sizez; ++z) {
                                y = this.miny;
                                pos = z * layer + y * sizex;
                                while (y < this.maxy) {
                                    System.arraycopy(intbufferin, pos, intbufferout, pos, sizex);
                                    s = -1;
                                    p = pos - sizex;
                                    while (-ErodeSegmentY.this.sewidth <= s && 0 <= y + s) {
                                        ArrayMM.Minimum(intbufferin, p, intbufferout, pos, intbufferout, pos, sizex);
                                        --s;
                                        p -= sizex;
                                    }
                                    s = 1;
                                    p = pos + sizex;
                                    while (s <= ErodeSegmentY.this.sewidth && y + s < sizey) {
                                        ArrayMM.Minimum(intbufferin, p, intbufferout, pos, intbufferout, pos, sizex);
                                        ++s;
                                        p += sizex;
                                    }
                                    ++y;
                                    pos += sizex;
                                }
                            }
                            intbufferout = null;
                            intbufferin = null;
                            ++c;
                        }
                    }
                    case -4: {
                        c = 0;
                        while (true) {
                            if (c >= channel) ** GOTO lbl-1000
                            floatbufferin = (float[])ErodeSegmentY.this.sigsin[c];
                            floatbufferout = (float[])ErodeSegmentY.this.sigsout[c];
                            for (z = 0; z < sizez; ++z) {
                                y = this.miny;
                                pos = z * layer + y * sizex;
                                while (y < this.maxy) {
                                    System.arraycopy(floatbufferin, pos, floatbufferout, pos, sizex);
                                    s = -1;
                                    p = pos - sizex;
                                    while (-ErodeSegmentY.this.sewidth <= s && 0 <= y + s) {
                                        ArrayMM.Minimum(floatbufferin, p, floatbufferout, pos, floatbufferout, pos, sizex);
                                        --s;
                                        p -= sizex;
                                    }
                                    s = 1;
                                    p = pos + sizex;
                                    while (s <= ErodeSegmentY.this.sewidth && y + s < sizey) {
                                        ArrayMM.Minimum(floatbufferin, p, floatbufferout, pos, floatbufferout, pos, sizex);
                                        ++s;
                                        p += sizex;
                                    }
                                    ++y;
                                    pos += sizex;
                                }
                            }
                            floatbufferout = null;
                            floatbufferin = null;
                            ++c;
                        }
                    }
                    case -5: {
                        c = 0;
                        while (true) {
                            if (c >= channel) continue block12;
                            doublebufferin = (double[])ErodeSegmentY.this.sigsin[c];
                            doublebufferout = (double[])ErodeSegmentY.this.sigsout[c];
                            for (z = 0; z < sizez; ++z) {
                                y = this.miny;
                                pos = z * layer + y * sizex;
                                while (y < this.maxy) {
                                    System.arraycopy(doublebufferin, pos, doublebufferout, pos, sizex);
                                    s = -1;
                                    p = pos - sizex;
                                    while (-ErodeSegmentY.this.sewidth <= s && 0 <= y + s) {
                                        ArrayMM.Minimum(doublebufferin, p, doublebufferout, pos, doublebufferout, pos, sizex);
                                        --s;
                                        p -= sizex;
                                    }
                                    s = 1;
                                    p = pos + sizex;
                                    while (s <= ErodeSegmentY.this.sewidth && y + s < sizey) {
                                        ArrayMM.Minimum(doublebufferin, p, doublebufferout, pos, doublebufferout, pos, sizex);
                                        ++s;
                                        p += sizex;
                                    }
                                    ++y;
                                    pos += sizex;
                                }
                            }
                            doublebufferout = null;
                            doublebufferin = null;
                            ++c;
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("Type not supported (yet).");
                    }
                }
                break;
            }
        }
    }

    private class ErodeYfmThread
    extends Thread {
        private int minx;
        private int maxx;
        private int[] buffer = null;
        private float[] bufferfloat = null;
        private double[] bufferdouble = null;
        public final Object lock = new Object();
        private boolean Kill = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.buffer = null;
            this.bufferfloat = null;
            this.bufferdouble = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(int minx, int maxx) {
            this.minx = minx;
            this.maxx = maxx;
            switch (ErodeSegmentY.this.Type) {
                case -3: 
                case -1: {
                    this.bufferdouble = null;
                    this.bufferfloat = null;
                    if (this.buffer != null && this.buffer.length == ErodeSegmentY.this.SizeY) break;
                    this.buffer = null;
                    this.buffer = new int[ErodeSegmentY.this.SizeY];
                    break;
                }
                case -4: {
                    this.buffer = null;
                    this.bufferdouble = null;
                    if (this.bufferfloat != null && this.bufferfloat.length == ErodeSegmentY.this.SizeY) break;
                    this.bufferfloat = null;
                    this.bufferfloat = new float[ErodeSegmentY.this.SizeY];
                    break;
                }
                case -5: {
                    this.buffer = null;
                    this.bufferfloat = null;
                    if (this.bufferdouble != null && this.bufferdouble.length == ErodeSegmentY.this.SizeY) break;
                    this.bufferdouble = null;
                    this.bufferdouble = new double[ErodeSegmentY.this.SizeY];
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Type not supported (yet).");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block11: while (true) lbl-1000:
            // 5 sources

            {
                var1_2 = this.lock;
                synchronized (var1_2) {
                    try {
                        ErodeSegmentY.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                type = ErodeSegmentY.this.Type;
                sizex = ErodeSegmentY.this.SizeX;
                sizey = ErodeSegmentY.this.SizeY;
                sizez = ErodeSegmentY.this.SizeZ;
                layer = ErodeSegmentY.this.Layer;
                channel = ErodeSegmentY.this.Channel;
                hs1 = sizey - ErodeSegmentY.this.sewidth - 1;
                switch (type) {
                    case -3: {
                        c = 0;
                        while (true) {
                            if (c >= channel) ** GOTO lbl-1000
                            shortbufferin = (short[])ErodeSegmentY.this.sigsin[c];
                            shortbufferout = (short[])ErodeSegmentY.this.sigsout[c];
                            for (z = 0; z < sizez; ++z) {
                                x = this.minx;
                                pos = x + z * layer;
                                while (x < this.maxx) {
                                    T = 65535;
                                    G = 65535;
                                    nbprop = 0;
                                    for (y = 0; y < sizey; ++y) {
                                        T_pre = T;
                                        G_pre = G;
                                        rowval = shortbufferin[pos + y * sizex] & 65535;
                                        T = y > hs1 ? (T_pre > rowval ? rowval : T_pre) : 65535;
                                        if (G_pre < rowval && nbprop < ErodeSegmentY.this.sewidth) {
                                            G = G_pre;
                                            ++nbprop;
                                        } else {
                                            G = y > hs1 && nbprop >= ErodeSegmentY.this.sewidth ? T : rowval;
                                            T = 65535;
                                            nbprop = 0;
                                        }
                                        this.buffer[sizey - y - 1] = y - ErodeSegmentY.this.sewidth < 0 ? G : Math.min(G, shortbufferin[pos + (y - ErodeSegmentY.this.sewidth) * sizex] & 65535);
                                    }
                                    T = 65535;
                                    G = 65535;
                                    nbprop = 0;
                                    rowval = 65535;
                                    rowval_pre = 65535;
                                    for (y = 0; y < sizey; ++y) {
                                        T_pre = T;
                                        G_pre = G;
                                        rowval_pre = rowval;
                                        rowval = this.buffer[y];
                                        T = y == 0 ? rowval : (rowval < rowval_pre && T > rowval ? rowval : T_pre);
                                        if (G_pre < rowval && nbprop < ErodeSegmentY.this.sewidth) {
                                            G = G_pre;
                                            ++nbprop;
                                        } else {
                                            G = nbprop >= ErodeSegmentY.this.sewidth ? T : rowval;
                                            T = 65535;
                                            nbprop = 0;
                                        }
                                        shortbufferout[pos + (sizey - y - 1) * sizex] = y < ErodeSegmentY.this.sewidth ? (short)G : (short)Math.min(G, this.buffer[y - ErodeSegmentY.this.sewidth]);
                                    }
                                    ++x;
                                    ++pos;
                                }
                            }
                            shortbufferout = null;
                            shortbufferin = null;
                            ++c;
                        }
                    }
                    case -1: {
                        c = 0;
                        while (true) {
                            if (c >= channel) ** GOTO lbl-1000
                            intbufferin = (int[])ErodeSegmentY.this.sigsin[c];
                            intbufferout = (int[])ErodeSegmentY.this.sigsout[c];
                            for (z = 0; z < sizez; ++z) {
                                x = this.minx;
                                pos = x + z * layer;
                                while (x < this.maxx) {
                                    T = 0x7FFFFFFF;
                                    G = 0x7FFFFFFF;
                                    nbprop = 0;
                                    for (y = 0; y < sizey; ++y) {
                                        T_pre = T;
                                        G_pre = G;
                                        rowval = intbufferin[pos + y * sizex];
                                        T = y > hs1 ? (T_pre > rowval ? rowval : T_pre) : 0x7FFFFFFF;
                                        if (G_pre < rowval && nbprop < ErodeSegmentY.this.sewidth) {
                                            G = G_pre;
                                            ++nbprop;
                                        } else {
                                            G = y > hs1 && nbprop >= ErodeSegmentY.this.sewidth ? T : rowval;
                                            T = 0x7FFFFFFF;
                                            nbprop = 0;
                                        }
                                        this.buffer[sizey - y - 1] = y - ErodeSegmentY.this.sewidth < 0 ? G : Math.min(G, intbufferin[pos + (y - ErodeSegmentY.this.sewidth) * sizex]);
                                    }
                                    T = 0x7FFFFFFF;
                                    G = 0x7FFFFFFF;
                                    nbprop = 0;
                                    rowval = 0x7FFFFFFF;
                                    rowval_pre = 0x7FFFFFFF;
                                    for (y = 0; y < sizey; ++y) {
                                        T_pre = T;
                                        G_pre = G;
                                        rowval_pre = rowval;
                                        rowval = this.buffer[y];
                                        T = y == 0 ? rowval : (rowval < rowval_pre && T > rowval ? rowval : T_pre);
                                        if (G_pre < rowval && nbprop < ErodeSegmentY.this.sewidth) {
                                            G = G_pre;
                                            ++nbprop;
                                        } else {
                                            G = nbprop >= ErodeSegmentY.this.sewidth ? T : rowval;
                                            T = 0x7FFFFFFF;
                                            nbprop = 0;
                                        }
                                        intbufferout[pos + (sizey - y - 1) * sizex] = y < ErodeSegmentY.this.sewidth ? G : Math.min(G, this.buffer[y - ErodeSegmentY.this.sewidth]);
                                    }
                                    ++x;
                                    ++pos;
                                }
                            }
                            intbufferout = null;
                            intbufferin = null;
                            ++c;
                        }
                    }
                    case -4: {
                        c = 0;
                        while (true) {
                            if (c >= channel) ** GOTO lbl-1000
                            floatbufferin = (float[])ErodeSegmentY.this.sigsin[c];
                            floatbufferout = (float[])ErodeSegmentY.this.sigsout[c];
                            for (z = 0; z < sizez; ++z) {
                                x = this.minx;
                                pos = x + z * layer;
                                while (x < this.maxx) {
                                    FT = 3.4028235E38f;
                                    FG = 3.4028235E38f;
                                    nbprop = 0;
                                    for (y = 0; y < sizey; ++y) {
                                        FT_pre = FT;
                                        FG_pre = FG;
                                        frowval = floatbufferin[pos + y * sizex];
                                        FT = y > hs1 ? (FT_pre > frowval ? frowval : FT_pre) : 3.4028235E38f;
                                        if (FG_pre < frowval && nbprop < ErodeSegmentY.this.sewidth) {
                                            FG = FG_pre;
                                            ++nbprop;
                                        } else {
                                            FG = y > hs1 && nbprop >= ErodeSegmentY.this.sewidth ? FT : frowval;
                                            FT = 3.4028235E38f;
                                            nbprop = 0;
                                        }
                                        this.bufferfloat[sizey - y - 1] = y - ErodeSegmentY.this.sewidth < 0 ? FG : Math.min(FG, floatbufferin[pos + (y - ErodeSegmentY.this.sewidth) * sizex]);
                                    }
                                    FT = 3.4028235E38f;
                                    FG = 3.4028235E38f;
                                    nbprop = 0;
                                    frowval = 3.4028235E38f;
                                    frowval_pre = 3.4028235E38f;
                                    for (y = 0; y < sizey; ++y) {
                                        FT_pre = FT;
                                        FG_pre = FG;
                                        frowval_pre = frowval;
                                        frowval = this.bufferfloat[y];
                                        FT = y == 0 ? frowval : (frowval < frowval_pre && FT > frowval ? frowval : FT_pre);
                                        if (FG_pre < frowval && nbprop < ErodeSegmentY.this.sewidth) {
                                            FG = FG_pre;
                                            ++nbprop;
                                        } else {
                                            FG = nbprop >= ErodeSegmentY.this.sewidth ? FT : frowval;
                                            FT = 3.4028235E38f;
                                            nbprop = 0;
                                        }
                                        floatbufferout[pos + (sizey - y - 1) * sizex] = y < ErodeSegmentY.this.sewidth ? FG : Math.min(FG, this.bufferfloat[y - ErodeSegmentY.this.sewidth]);
                                    }
                                    ++x;
                                    ++pos;
                                }
                            }
                            floatbufferout = null;
                            floatbufferin = null;
                            ++c;
                        }
                    }
                    case -5: {
                        c = 0;
                        while (true) {
                            if (c >= channel) continue block11;
                            doublebufferin = (double[])ErodeSegmentY.this.sigsin[c];
                            doublebufferout = (double[])ErodeSegmentY.this.sigsout[c];
                            for (z = 0; z < sizez; ++z) {
                                x = this.minx;
                                pos = x + z * layer;
                                while (x < this.maxx) {
                                    DT = 1.7976931348623157E308;
                                    DG = 1.7976931348623157E308;
                                    nbprop = 0;
                                    for (y = 0; y < sizey; ++y) {
                                        DT_pre = DT;
                                        DG_pre = DG;
                                        drowval = doublebufferin[pos + y * sizex];
                                        DT = y > hs1 ? (DT_pre > drowval ? drowval : DT_pre) : 1.7976931348623157E308;
                                        if (DG_pre < drowval && nbprop < ErodeSegmentY.this.sewidth) {
                                            DG = DG_pre;
                                            ++nbprop;
                                        } else {
                                            DG = y > hs1 && nbprop >= ErodeSegmentY.this.sewidth ? DT : drowval;
                                            DT = 1.7976931348623157E308;
                                            nbprop = 0;
                                        }
                                        this.bufferdouble[sizey - y - 1] = y - ErodeSegmentY.this.sewidth < 0 ? DG : Math.min(DG, doublebufferin[pos + (y - ErodeSegmentY.this.sewidth) * sizex]);
                                    }
                                    DT = 1.7976931348623157E308;
                                    DG = 1.7976931348623157E308;
                                    nbprop = 0;
                                    drowval = 1.7976931348623157E308;
                                    drowval_pre = 1.7976931348623157E308;
                                    for (y = 0; y < sizey; ++y) {
                                        DT_pre = DT;
                                        DG_pre = DG;
                                        drowval_pre = drowval;
                                        drowval = this.bufferdouble[y];
                                        DT = y == 0 ? drowval : (drowval < drowval_pre && DT > drowval ? drowval : DT_pre);
                                        if (DG_pre < drowval && nbprop < ErodeSegmentY.this.sewidth) {
                                            DG = DG_pre;
                                            ++nbprop;
                                        } else {
                                            DG = nbprop >= ErodeSegmentY.this.sewidth ? DT : drowval;
                                            DT = 1.7976931348623157E308;
                                            nbprop = 0;
                                        }
                                        doublebufferout[pos + (sizey - y - 1) * sizex] = y < ErodeSegmentY.this.sewidth ? DG : Math.min(DG, this.bufferdouble[y - ErodeSegmentY.this.sewidth]);
                                    }
                                    ++x;
                                    ++pos;
                                }
                            }
                            doublebufferout = null;
                            doublebufferin = null;
                            ++c;
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("Type not supported (yet).");
                    }
                }
                break;
            }
        }
    }

    private class ErodeYhistThread
    extends Thread {
        private int minx;
        private int maxx;
        private int[] Hist = new int[256];
        public final Object lock = new Object();
        private boolean Kill = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.Hist = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(int minx, int maxx) {
            this.minx = minx;
            this.maxx = maxx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block8: while (true) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        ErodeSegmentY.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                int type = ErodeSegmentY.this.Type;
                int sizex = ErodeSegmentY.this.SizeX;
                int sizey = ErodeSegmentY.this.SizeY;
                int sizez = ErodeSegmentY.this.SizeZ;
                int layer = ErodeSegmentY.this.Layer;
                int channel = ErodeSegmentY.this.Channel;
                int sewidthwidth = ErodeSegmentY.this.sewidth * sizex;
                Arrays.fill(this.Hist, 0);
                switch (type) {
                    case -2: {
                        int c = 0;
                        while (true) {
                            if (c >= channel) continue block8;
                            byte[] bytebufferin = (byte[])ErodeSegmentY.this.sigsin[c];
                            byte[] bytebufferout = (byte[])ErodeSegmentY.this.sigsout[c];
                            for (int z = 0; z < sizez; ++z) {
                                int x = this.minx;
                                int pos = z * layer + x;
                                while (x < this.maxx) {
                                    int y;
                                    int aux;
                                    int y2;
                                    int mini = 255;
                                    int end = pos + sewidthwidth;
                                    for (y2 = pos; y2 < end; y2 += sizex) {
                                        int n = aux = bytebufferin[y2] & 0xFF;
                                        this.Hist[n] = this.Hist[n] + 1;
                                        if (aux >= mini) continue;
                                        mini = aux;
                                    }
                                    for (y2 = pos; y2 < end; y2 += sizex) {
                                        int n = aux = bytebufferin[y2 + sewidthwidth] & 0xFF;
                                        this.Hist[n] = this.Hist[n] + 1;
                                        if (aux < mini) {
                                            mini = aux;
                                        }
                                        bytebufferout[y2] = (byte)mini;
                                    }
                                    int start = pos + sewidthwidth;
                                    int end2 = pos + (sizey - ErodeSegmentY.this.sewidth) * sizex;
                                    for (int y3 = start; y3 < end2; y3 += sizex) {
                                        int aux2;
                                        int n = aux2 = bytebufferin[y3 + sewidthwidth] & 0xFF;
                                        this.Hist[n] = this.Hist[n] + 1;
                                        if (aux2 < mini) {
                                            mini = aux2;
                                        }
                                        bytebufferout[y3] = (byte)mini;
                                        int n2 = bytebufferin[y3 - sewidthwidth] & 0xFF;
                                        this.Hist[n2] = this.Hist[n2] - 1;
                                        while (this.Hist[mini] == 0) {
                                            ++mini;
                                        }
                                    }
                                    int start2 = end2;
                                    int end3 = pos + layer;
                                    for (y = start2; y < end3; y += sizex) {
                                        bytebufferout[y] = (byte)mini;
                                        int n = bytebufferin[y - sewidthwidth] & 0xFF;
                                        this.Hist[n] = this.Hist[n] - 1;
                                        while (this.Hist[mini] == 0) {
                                            ++mini;
                                        }
                                    }
                                    for (y = start2; y < end3; y += sizex) {
                                        int n = bytebufferin[y] & 0xFF;
                                        this.Hist[n] = this.Hist[n] - 1;
                                    }
                                    ++x;
                                    ++pos;
                                }
                            }
                            bytebufferout = null;
                            bytebufferin = null;
                            ++c;
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("Type not supported (yet).");
                    }
                }
                break;
            }
        }
    }
}

