/*
 * Decompiled with CFR 0.152.
 */
package morphee.fastMorphee;

import arrayTiTi.ArrayMM;
import java.util.Arrays;
import morphee.fastMorphee.FastMorphee;

public class ErodeSegmentX
implements FastMorphee {
    private ErodeXhistThread[] threadshist = null;
    private ErodeXfmThread[] threadsfm = null;
    private ErodeXavThread[] threadsav = null;
    private ErodeInterXhistThread[] threadsinterhist = null;
    private ErodeInterXfmThread[] threadsinterfm = null;
    private ErodeInterXavThread[] threadsinterav = null;
    private int nbFreeThreads = 0;
    private FastMorphee.Algorithm algo = FastMorphee.Algorithm.Histogram;
    private Object sigin;
    private Object sigout;
    private Object[] sigsin;
    private Object[] sigsout;
    private int Channel;
    private int SizeX;
    private int SizeZ;
    private int Layer;
    private int Type;
    private int sewidth;

    @Override
    public synchronized void Kill() {
        int i;
        this.sigout = null;
        this.sigin = null;
        this.sigsout = null;
        this.sigsin = null;
        if (this.threadshist != null) {
            for (i = 0; i < this.threadshist.length; ++i) {
                this.threadshist[i].Kill();
                this.threadshist[i] = null;
            }
            this.threadshist = null;
        }
        if (this.threadsfm != null) {
            for (i = 0; i < this.threadsfm.length; ++i) {
                this.threadsfm[i].Kill();
                this.threadsfm[i] = null;
            }
            this.threadsfm = null;
        }
        if (this.threadsav != null) {
            for (i = 0; i < this.threadsav.length; ++i) {
                this.threadsav[i].Kill();
                this.threadsav[i] = null;
            }
            this.threadsav = null;
        }
        if (this.threadsinterhist != null) {
            for (i = 0; i < this.threadsinterhist.length; ++i) {
                this.threadsinterhist[i].Kill();
                this.threadsinterhist[i] = null;
            }
            this.threadsinterhist = null;
        }
        if (this.threadsinterfm != null) {
            for (i = 0; i < this.threadsinterfm.length; ++i) {
                this.threadsinterfm[i].Kill();
                this.threadsinterfm[i] = null;
            }
            this.threadsinterfm = null;
        }
        if (this.threadsinterav != null) {
            for (i = 0; i < this.threadsinterav.length; ++i) {
                this.threadsinterav[i].Kill();
                this.threadsinterav[i] = null;
            }
            this.threadsinterav = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void FilterInterlaced(Object source, int sizex, int sizey, int sizez, int channel, int type, int sewidth, Object result, int nbCPU) {
        Object object;
        if (sewidth < 1) {
            throw new IllegalArgumentException("The structuring element order must be positive.");
        }
        this.sewidth = sewidth;
        switch (type) {
            case -2: {
                if (sewidth <= 3) {
                    this.StartInterlacedAV(nbCPU);
                    break;
                }
                this.StartInterlacedHist(nbCPU);
                break;
            }
            case -3: {
                if (sewidth <= 4 || channel != 1) {
                    this.StartInterlacedAV(nbCPU);
                    break;
                }
                this.StartInterlacedFM(nbCPU);
                break;
            }
            case -5: 
            case -4: 
            case -1: {
                if (sewidth <= 4 || channel != 1) {
                    this.StartInterlacedAV(nbCPU);
                    break;
                }
                this.StartInterlacedFM(nbCPU);
                break;
            }
            default: {
                throw new IllegalArgumentException("Object type unknown.");
            }
        }
        this.sigin = source;
        this.sigout = result;
        this.SizeX = sizex;
        this.SizeZ = sizez;
        this.Layer = sizex * sizey;
        this.Channel = channel;
        this.Type = type;
        ErodeSegmentX erodeSegmentX = this;
        synchronized (erodeSegmentX) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        int step = sizey / nbCPU;
        int nbCPUm1 = nbCPU - 1;
        this.nbFreeThreads = 0;
        switch (this.algo) {
            case AutoVectorization: {
                Object object2;
                for (int i = 0; i < nbCPUm1; ++i) {
                    this.threadsinterav[i].setConditions(i * step, (i + 1) * step);
                    object2 = this.threadsinterav[i].lock;
                    synchronized (object2) {
                        this.threadsinterav[i].lock.notify();
                        continue;
                    }
                }
                this.threadsinterav[nbCPUm1].setConditions(nbCPUm1 * step, sizey);
                Object i = this.threadsinterav[nbCPUm1].lock;
                synchronized (i) {
                    this.threadsinterav[nbCPUm1].lock.notify();
                    break;
                }
            }
            case FastMorphM: {
                Object object2;
                for (int i = 0; i < nbCPUm1; ++i) {
                    this.threadsinterfm[i].setConditions(i * step, (i + 1) * step);
                    object2 = this.threadsinterfm[i].lock;
                    synchronized (object2) {
                        this.threadsinterfm[i].lock.notify();
                        continue;
                    }
                }
                this.threadsinterfm[nbCPUm1].setConditions(nbCPUm1 * step, sizey);
                Object i = this.threadsinterfm[nbCPUm1].lock;
                synchronized (i) {
                    this.threadsinterfm[nbCPUm1].lock.notify();
                    break;
                }
            }
            case Histogram: {
                Object object2;
                for (int i = 0; i < nbCPUm1; ++i) {
                    this.threadsinterhist[i].setConditions(i * step, (i + 1) * step);
                    object2 = this.threadsinterhist[i].lock;
                    synchronized (object2) {
                        this.threadsinterhist[i].lock.notify();
                        continue;
                    }
                }
                this.threadsinterhist[nbCPUm1].setConditions(nbCPUm1 * step, sizey);
                object = this.threadsinterhist[nbCPUm1].lock;
                synchronized (object) {
                    this.threadsinterhist[nbCPUm1].lock.notify();
                    break;
                }
            }
            default: {
                throw new IllegalArgumentException("Unknown algorithm.");
            }
        }
        object = this;
        synchronized (object) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void StartInterlacedHist(int nbCPU) {
        this.algo = FastMorphee.Algorithm.Histogram;
        if (this.threadsinterhist != null && this.threadsinterhist.length == nbCPU) {
            return;
        }
        this.Kill();
        this.nbFreeThreads = 0;
        this.threadsinterhist = new ErodeInterXhistThread[nbCPU];
        for (int i = 0; i < nbCPU; ++i) {
            this.threadsinterhist[i] = new ErodeInterXhistThread();
            this.threadsinterhist[i].start();
        }
    }

    private void StartInterlacedFM(int nbCPU) {
        this.algo = FastMorphee.Algorithm.FastMorphM;
        if (this.threadsinterfm != null && this.threadsinterfm.length == nbCPU) {
            return;
        }
        this.Kill();
        this.nbFreeThreads = 0;
        this.threadsinterfm = new ErodeInterXfmThread[nbCPU];
        for (int i = 0; i < nbCPU; ++i) {
            this.threadsinterfm[i] = new ErodeInterXfmThread();
            this.threadsinterfm[i].start();
        }
    }

    private void StartInterlacedAV(int nbCPU) {
        this.algo = FastMorphee.Algorithm.AutoVectorization;
        if (this.threadsinterav != null && this.threadsinterav.length == nbCPU) {
            return;
        }
        this.Kill();
        this.nbFreeThreads = 0;
        this.threadsinterav = new ErodeInterXavThread[nbCPU];
        for (int i = 0; i < nbCPU; ++i) {
            this.threadsinterav[i] = new ErodeInterXavThread();
            this.threadsinterav[i].start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Filter(Object[] sources, int sizex, int sizey, int sizez, int type, int sewidth, Object[] results, int nbCPU) {
        Object object;
        if (sewidth < 1) {
            throw new IllegalArgumentException("The structuring element order must be positive.");
        }
        this.sewidth = sewidth;
        switch (type) {
            case -2: {
                if (sewidth <= 3) {
                    this.StartAV(nbCPU);
                    break;
                }
                this.StartHist(nbCPU);
                break;
            }
            case -3: {
                if (sewidth <= 3) {
                    this.StartAV(nbCPU);
                    break;
                }
                this.StartFM(nbCPU);
                break;
            }
            case -5: 
            case -4: 
            case -1: {
                if (sewidth <= 3) {
                    this.StartAV(nbCPU);
                    break;
                }
                this.StartFM(nbCPU);
                break;
            }
            default: {
                throw new IllegalArgumentException("Object type unknown.");
            }
        }
        this.sigsin = sources;
        this.sigsout = results;
        this.SizeX = sizex;
        this.SizeZ = sizez;
        this.Layer = sizex * sizey;
        this.Channel = sources.length;
        this.Type = type;
        ErodeSegmentX erodeSegmentX = this;
        synchronized (erodeSegmentX) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        int step = sizey / nbCPU;
        int nbCPUm1 = nbCPU - 1;
        this.nbFreeThreads = 0;
        switch (this.algo) {
            case AutoVectorization: {
                Object object2;
                for (int i = 0; i < nbCPUm1; ++i) {
                    this.threadsav[i].setConditions(i * step, (i + 1) * step);
                    object2 = this.threadsav[i].lock;
                    synchronized (object2) {
                        this.threadsav[i].lock.notify();
                        continue;
                    }
                }
                this.threadsav[nbCPUm1].setConditions(nbCPUm1 * step, sizey);
                Object i = this.threadsav[nbCPUm1].lock;
                synchronized (i) {
                    this.threadsav[nbCPUm1].lock.notify();
                    break;
                }
            }
            case FastMorphM: {
                Object object2;
                for (int i = 0; i < nbCPUm1; ++i) {
                    this.threadsfm[i].setConditions(i * step, (i + 1) * step);
                    object2 = this.threadsfm[i].lock;
                    synchronized (object2) {
                        this.threadsfm[i].lock.notify();
                        continue;
                    }
                }
                this.threadsfm[nbCPUm1].setConditions(nbCPUm1 * step, sizey);
                Object i = this.threadsfm[nbCPUm1].lock;
                synchronized (i) {
                    this.threadsfm[nbCPUm1].lock.notify();
                    break;
                }
            }
            case Histogram: {
                Object object2;
                for (int i = 0; i < nbCPUm1; ++i) {
                    this.threadshist[i].setConditions(i * step, (i + 1) * step);
                    object2 = this.threadshist[i].lock;
                    synchronized (object2) {
                        this.threadshist[i].lock.notify();
                        continue;
                    }
                }
                this.threadshist[nbCPUm1].setConditions(nbCPUm1 * step, sizey);
                object = this.threadshist[nbCPUm1].lock;
                synchronized (object) {
                    this.threadshist[nbCPUm1].lock.notify();
                    break;
                }
            }
            default: {
                throw new IllegalArgumentException("Unknown algorithm.");
            }
        }
        object = this;
        synchronized (object) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void StartHist(int nbCPU) {
        this.algo = FastMorphee.Algorithm.Histogram;
        if (this.threadshist != null && this.threadshist.length == nbCPU) {
            return;
        }
        this.Kill();
        this.nbFreeThreads = 0;
        this.threadshist = new ErodeXhistThread[nbCPU];
        for (int i = 0; i < nbCPU; ++i) {
            this.threadshist[i] = new ErodeXhistThread();
            this.threadshist[i].start();
        }
    }

    private void StartFM(int nbCPU) {
        this.algo = FastMorphee.Algorithm.FastMorphM;
        if (this.threadsfm != null && this.threadsfm.length == nbCPU) {
            return;
        }
        this.Kill();
        this.nbFreeThreads = 0;
        this.threadsfm = new ErodeXfmThread[nbCPU];
        for (int i = 0; i < nbCPU; ++i) {
            this.threadsfm[i] = new ErodeXfmThread();
            this.threadsfm[i].start();
        }
    }

    private void StartAV(int nbCPU) {
        this.algo = FastMorphee.Algorithm.AutoVectorization;
        if (this.threadsav != null && this.threadsav.length == nbCPU) {
            return;
        }
        this.Kill();
        this.nbFreeThreads = 0;
        this.threadsav = new ErodeXavThread[nbCPU];
        for (int i = 0; i < nbCPU; ++i) {
            this.threadsav[i] = new ErodeXavThread();
            this.threadsav[i].start();
        }
    }

    protected synchronized void addFreeThread() {
        ++this.nbFreeThreads;
        this.notify();
    }

    private class ErodeInterXavThread
    extends Thread {
        private int miny;
        private int maxy;
        public final Object lock = new Object();
        private boolean Kill = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(int miny, int maxy) {
            this.miny = miny;
            this.maxy = maxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block12: while (true) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        ErodeSegmentX.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                int type = ErodeSegmentX.this.Type;
                int sizex = ErodeSegmentX.this.SizeX;
                int sizez = ErodeSegmentX.this.SizeZ;
                int layer = ErodeSegmentX.this.Layer;
                int channel = ErodeSegmentX.this.Channel;
                int sizexchannel = sizex * channel;
                switch (type) {
                    case -2: {
                        byte[] bytebufferin = (byte[])ErodeSegmentX.this.sigin;
                        byte[] bytebufferout = (byte[])ErodeSegmentX.this.sigout;
                        for (int z = 0; z < sizez; ++z) {
                            int y = this.miny;
                            int pos = (z * layer + y * sizex) * channel;
                            while (y < this.maxy) {
                                int s;
                                System.arraycopy(bytebufferin, pos, bytebufferout, pos, sizexchannel);
                                for (s = 1; s <= ErodeSegmentX.this.sewidth; ++s) {
                                    ArrayMM.MinimumUnsigned(bytebufferin, pos + s * channel, bytebufferout, pos, bytebufferout, pos, sizexchannel - s * channel);
                                }
                                for (s = -1; -ErodeSegmentX.this.sewidth <= s; --s) {
                                    ArrayMM.MinimumUnsigned(bytebufferin, pos, bytebufferout, pos - s * channel, bytebufferout, pos - s * channel, sizexchannel + s * channel);
                                }
                                ++y;
                                pos += sizexchannel;
                            }
                        }
                        bytebufferout = null;
                        bytebufferin = null;
                        break;
                    }
                    case -3: {
                        int s;
                        int pos;
                        int y;
                        int z;
                        int c = 0;
                        while (true) {
                            if (c >= channel) continue block12;
                            short[] shortbufferin = (short[])ErodeSegmentX.this.sigin;
                            short[] shortbufferout = (short[])ErodeSegmentX.this.sigout;
                            for (z = 0; z < sizez; ++z) {
                                y = this.miny;
                                pos = (z * layer + y * sizex) * channel;
                                while (y < this.maxy) {
                                    System.arraycopy(shortbufferin, pos, shortbufferout, pos, sizexchannel);
                                    for (s = 1; s <= ErodeSegmentX.this.sewidth; ++s) {
                                        ArrayMM.MinimumUnsigned(shortbufferin, pos + s * channel, shortbufferout, pos, shortbufferout, pos, sizexchannel - s * channel);
                                    }
                                    for (s = -1; -ErodeSegmentX.this.sewidth <= s; --s) {
                                        ArrayMM.MinimumUnsigned(shortbufferin, pos, shortbufferout, pos - s * channel, shortbufferout, pos - s * channel, sizexchannel + s * channel);
                                    }
                                    ++y;
                                    pos += sizexchannel;
                                }
                            }
                            shortbufferout = null;
                            shortbufferin = null;
                            ++c;
                        }
                    }
                    case -1: {
                        int s;
                        int pos;
                        int y;
                        int z;
                        int c = 0;
                        while (true) {
                            if (c >= channel) continue block12;
                            int[] intbufferin = (int[])ErodeSegmentX.this.sigin;
                            int[] intbufferout = (int[])ErodeSegmentX.this.sigout;
                            for (z = 0; z < sizez; ++z) {
                                y = this.miny;
                                pos = (z * layer + y * sizex) * channel;
                                while (y < this.maxy) {
                                    System.arraycopy(intbufferin, pos, intbufferout, pos, sizexchannel);
                                    for (s = 1; s <= ErodeSegmentX.this.sewidth; ++s) {
                                        ArrayMM.Minimum(intbufferin, pos + s * channel, intbufferout, pos, intbufferout, pos, sizexchannel - s * channel);
                                    }
                                    for (s = -1; -ErodeSegmentX.this.sewidth <= s; --s) {
                                        ArrayMM.Minimum(intbufferin, pos, intbufferout, pos - s * channel, intbufferout, pos - s * channel, sizexchannel + s * channel);
                                    }
                                    ++y;
                                    pos += sizexchannel;
                                }
                            }
                            intbufferout = null;
                            intbufferin = null;
                            ++c;
                        }
                    }
                    case -4: {
                        int s;
                        int pos;
                        int y;
                        int z;
                        int c = 0;
                        while (true) {
                            if (c >= channel) continue block12;
                            float[] floatbufferin = (float[])ErodeSegmentX.this.sigin;
                            float[] floatbufferout = (float[])ErodeSegmentX.this.sigout;
                            for (z = 0; z < sizez; ++z) {
                                y = this.miny;
                                pos = (z * layer + y * sizex) * channel;
                                while (y < this.maxy) {
                                    System.arraycopy(floatbufferin, pos, floatbufferout, pos, sizexchannel);
                                    for (s = 1; s <= ErodeSegmentX.this.sewidth; ++s) {
                                        ArrayMM.Minimum(floatbufferin, pos + s * channel, floatbufferout, pos, floatbufferout, pos, sizexchannel - s * channel);
                                    }
                                    for (s = -1; -ErodeSegmentX.this.sewidth <= s; --s) {
                                        ArrayMM.Minimum(floatbufferin, pos, floatbufferout, pos - s * channel, floatbufferout, pos - s * channel, sizexchannel + s * channel);
                                    }
                                    ++y;
                                    pos += sizexchannel;
                                }
                            }
                            floatbufferout = null;
                            floatbufferin = null;
                            ++c;
                        }
                    }
                    case -5: {
                        int s;
                        int pos;
                        int y;
                        int z;
                        int c = 0;
                        while (true) {
                            if (c >= channel) continue block12;
                            double[] doublebufferin = (double[])ErodeSegmentX.this.sigin;
                            double[] doublebufferout = (double[])ErodeSegmentX.this.sigout;
                            for (z = 0; z < sizez; ++z) {
                                y = this.miny;
                                pos = (z * layer + y * sizex) * channel;
                                while (y < this.maxy) {
                                    System.arraycopy(doublebufferin, pos, doublebufferout, pos, sizexchannel);
                                    for (s = 1; s <= ErodeSegmentX.this.sewidth; ++s) {
                                        ArrayMM.Minimum(doublebufferin, pos + s * channel, doublebufferout, pos, doublebufferout, pos, sizexchannel - s * channel);
                                    }
                                    for (s = -1; -ErodeSegmentX.this.sewidth <= s; --s) {
                                        ArrayMM.Minimum(doublebufferin, pos, doublebufferout, pos - s * channel, doublebufferout, pos - s * channel, sizexchannel + s * channel);
                                    }
                                    ++y;
                                    pos += sizexchannel;
                                }
                            }
                            doublebufferout = null;
                            doublebufferin = null;
                            ++c;
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("Type not supported (yet).");
                    }
                }
            }
        }
    }

    private class ErodeInterXfmThread
    extends Thread {
        private int miny;
        private int maxy;
        private int[] buffer = null;
        private float[] bufferfloat = null;
        private double[] bufferdouble = null;
        public final Object lock = new Object();
        private boolean Kill = false;

        private ErodeInterXfmThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.buffer = null;
            this.bufferfloat = null;
            this.bufferdouble = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(int miny, int maxy) {
            this.miny = miny;
            this.maxy = maxy;
            switch (ErodeSegmentX.this.Type) {
                case -3: 
                case -1: {
                    this.bufferdouble = null;
                    this.bufferfloat = null;
                    if (this.buffer != null && this.buffer.length == ErodeSegmentX.this.SizeX) break;
                    this.buffer = null;
                    this.buffer = new int[ErodeSegmentX.this.SizeX];
                    break;
                }
                case -4: {
                    this.buffer = null;
                    this.bufferdouble = null;
                    if (this.bufferfloat != null && this.bufferfloat.length == ErodeSegmentX.this.SizeX) break;
                    this.bufferfloat = null;
                    this.bufferfloat = new float[ErodeSegmentX.this.SizeX];
                    break;
                }
                case -5: {
                    this.buffer = null;
                    this.bufferfloat = null;
                    if (this.bufferdouble != null && this.bufferdouble.length == ErodeSegmentX.this.SizeX) break;
                    this.bufferdouble = null;
                    this.bufferdouble = new double[ErodeSegmentX.this.SizeX];
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Type not supported (yet).");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block11: while (true) {
                var1_2 = this.lock;
                synchronized (var1_2) {
                    try {
                        ErodeSegmentX.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                type = ErodeSegmentX.this.Type;
                sizex = ErodeSegmentX.this.SizeX;
                sizez = ErodeSegmentX.this.SizeZ;
                layer = ErodeSegmentX.this.Layer;
                sizex1 = sizex - 1;
                sizexsewidth1 = sizex1 - ErodeSegmentX.this.sewidth;
                switch (type) {
                    case -3: {
                        shortbufferin = (short[])ErodeSegmentX.this.sigin;
                        shortbufferout = (short[])ErodeSegmentX.this.sigout;
                        z = 0;
                        while (true) {
                            if (z >= sizez) continue block11;
                            y = this.miny;
                            pos = z * layer + y * sizex;
                            while (y < this.maxy) {
                                T = 65535;
                                G = 65535;
                                nbprop = 0;
                                for (x = 0; x < sizex; ++x) {
                                    T_pre = T;
                                    G_pre = G;
                                    rowval = shortbufferin[pos + x] & 65535;
                                    T = x > sizexsewidth1 ? (T_pre > rowval ? rowval : T_pre) : 65535;
                                    if (G_pre < rowval && nbprop < ErodeSegmentX.this.sewidth) {
                                        G = G_pre;
                                        ++nbprop;
                                    } else {
                                        G = x > sizexsewidth1 && nbprop >= ErodeSegmentX.this.sewidth ? T : rowval;
                                        T = 65535;
                                        nbprop = 0;
                                    }
                                    this.buffer[sizex1 - x] = x - ErodeSegmentX.this.sewidth < 0 ? G : Math.min(G, shortbufferin[pos + x - ErodeSegmentX.this.sewidth] & 65535);
                                }
                                T = 65535;
                                G = 65535;
                                nbprop = 0;
                                rowval = 65535;
                                rowval_pre = 65535;
                                for (x = 0; x < sizex; ++x) {
                                    T_pre = T;
                                    G_pre = G;
                                    rowval_pre = rowval;
                                    rowval = this.buffer[x];
                                    T = x == 0 ? rowval : (rowval < rowval_pre && T > rowval ? rowval : T_pre);
                                    if (G_pre < rowval && nbprop < ErodeSegmentX.this.sewidth) {
                                        G = G_pre;
                                        ++nbprop;
                                    } else {
                                        G = nbprop >= ErodeSegmentX.this.sewidth ? T : rowval;
                                        T = 65535;
                                        nbprop = 0;
                                    }
                                    shortbufferout[pos + sizex1 - x] = x < ErodeSegmentX.this.sewidth ? (short)G : (short)Math.min(G, this.buffer[x - ErodeSegmentX.this.sewidth]);
                                }
                                ++y;
                                pos += sizex;
                            }
                            ++z;
                        }
                    }
                    case -1: {
                        intbufferin = (int[])ErodeSegmentX.this.sigin;
                        intbufferout = (int[])ErodeSegmentX.this.sigout;
                        z = 0;
                        while (true) {
                            if (z >= sizez) continue block11;
                            y = this.miny;
                            pos = z * layer + y * sizex;
                            while (y < this.maxy) {
                                T = 0x7FFFFFFF;
                                G = 0x7FFFFFFF;
                                nbprop = 0;
                                for (x = 0; x < sizex; ++x) {
                                    T_pre = T;
                                    G_pre = G;
                                    rowval = intbufferin[pos + x];
                                    T = x > sizexsewidth1 ? (T_pre > rowval ? rowval : T_pre) : 0x7FFFFFFF;
                                    if (G_pre < rowval && nbprop < ErodeSegmentX.this.sewidth) {
                                        G = G_pre;
                                        ++nbprop;
                                    } else {
                                        G = x > sizexsewidth1 && nbprop >= ErodeSegmentX.this.sewidth ? T : rowval;
                                        T = 0x7FFFFFFF;
                                        nbprop = 0;
                                    }
                                    this.buffer[sizex1 - x] = x - ErodeSegmentX.this.sewidth < 0 ? G : Math.min(G, intbufferin[pos + x - ErodeSegmentX.this.sewidth]);
                                }
                                T = 0x7FFFFFFF;
                                G = 0x7FFFFFFF;
                                nbprop = 0;
                                rowval = 0x7FFFFFFF;
                                rowval_pre = 0x7FFFFFFF;
                                for (x = 0; x < sizex; ++x) {
                                    T_pre = T;
                                    G_pre = G;
                                    rowval_pre = rowval;
                                    rowval = this.buffer[x];
                                    T = x == 0 ? rowval : (rowval < rowval_pre && T > rowval ? rowval : T_pre);
                                    if (G_pre < rowval && nbprop < ErodeSegmentX.this.sewidth) {
                                        G = G_pre;
                                        ++nbprop;
                                    } else {
                                        G = nbprop >= ErodeSegmentX.this.sewidth ? T : rowval;
                                        T = 0x7FFFFFFF;
                                        nbprop = 0;
                                    }
                                    intbufferout[pos + sizex1 - x] = x < ErodeSegmentX.this.sewidth ? G : Math.min(G, this.buffer[x - ErodeSegmentX.this.sewidth]);
                                }
                                ++y;
                                pos += sizex;
                            }
                            ++z;
                        }
                    }
                    case -4: {
                        floatbufferin = (float[])ErodeSegmentX.this.sigin;
                        floatbufferout = (float[])ErodeSegmentX.this.sigout;
                        z = 0;
                        while (true) {
                            if (z >= sizez) continue block11;
                            y = this.miny;
                            pos = z * layer + y * sizex;
                            while (y < this.maxy) {
                                FT = 3.4028235E38f;
                                FG = 3.4028235E38f;
                                nbprop = 0;
                                for (x = 0; x < sizex; ++x) {
                                    FT_pre = FT;
                                    FG_pre = FG;
                                    frowval = floatbufferin[pos + x];
                                    FT = x > sizexsewidth1 ? (FT_pre > frowval ? frowval : FT_pre) : 3.4028235E38f;
                                    if (FG_pre < frowval && nbprop < ErodeSegmentX.this.sewidth) {
                                        FG = FG_pre;
                                        ++nbprop;
                                    } else {
                                        FG = x > sizexsewidth1 && nbprop >= ErodeSegmentX.this.sewidth ? FT : frowval;
                                        FT = 3.4028235E38f;
                                        nbprop = 0;
                                    }
                                    this.bufferfloat[sizex1 - x] = x - ErodeSegmentX.this.sewidth < 0 ? FG : Math.min(FG, floatbufferin[pos + x - ErodeSegmentX.this.sewidth]);
                                }
                                FT = 3.4028235E38f;
                                FG = 3.4028235E38f;
                                nbprop = 0;
                                frowval = 3.4028235E38f;
                                frowval_pre = 3.4028235E38f;
                                for (x = 0; x < sizex; ++x) {
                                    FT_pre = FT;
                                    FG_pre = FG;
                                    frowval_pre = frowval;
                                    frowval = this.bufferfloat[x];
                                    FT = x == 0 ? frowval : (frowval < frowval_pre && FT > frowval ? frowval : FT_pre);
                                    if (FG_pre < frowval && nbprop < ErodeSegmentX.this.sewidth) {
                                        FG = FG_pre;
                                        ++nbprop;
                                    } else {
                                        FG = nbprop >= ErodeSegmentX.this.sewidth ? FT : frowval;
                                        FT = 3.4028235E38f;
                                        nbprop = 0;
                                    }
                                    floatbufferout[pos + sizex1 - x] = x < ErodeSegmentX.this.sewidth ? FG : Math.min(FG, this.bufferfloat[x - ErodeSegmentX.this.sewidth]);
                                }
                                ++y;
                                pos += sizex;
                            }
                            ++z;
                        }
                    }
                    case -5: {
                        doublebufferin = (double[])ErodeSegmentX.this.sigin;
                        doublebufferout = (double[])ErodeSegmentX.this.sigout;
                        z = 0;
                        while (true) {
                            if (z < sizez) ** break;
                            continue block11;
                            y = this.miny;
                            pos = z * layer + y * sizex;
                            while (y < this.maxy) {
                                DT = 1.7976931348623157E308;
                                DG = 1.7976931348623157E308;
                                nbprop = 0;
                                for (x = 0; x < sizex; ++x) {
                                    DT_pre = DT;
                                    DG_pre = DG;
                                    drowval = doublebufferin[pos + x];
                                    DT = x > sizexsewidth1 ? (DT_pre > drowval ? drowval : DT_pre) : 1.7976931348623157E308;
                                    if (DG_pre < drowval && nbprop < ErodeSegmentX.this.sewidth) {
                                        DG = DG_pre;
                                        ++nbprop;
                                    } else {
                                        DG = x > sizexsewidth1 && nbprop >= ErodeSegmentX.this.sewidth ? DT : drowval;
                                        DT = 1.7976931348623157E308;
                                        nbprop = 0;
                                    }
                                    this.bufferdouble[sizex1 - x] = x - ErodeSegmentX.this.sewidth < 0 ? DG : Math.min(DG, doublebufferin[pos + x - ErodeSegmentX.this.sewidth]);
                                }
                                DT = 1.7976931348623157E308;
                                DG = 1.7976931348623157E308;
                                nbprop = 0;
                                drowval = 1.7976931348623157E308;
                                drowval_pre = 1.7976931348623157E308;
                                for (x = 0; x < sizex; ++x) {
                                    DT_pre = DT;
                                    DG_pre = DG;
                                    drowval_pre = drowval;
                                    drowval = this.bufferdouble[x];
                                    DT = x == 0 ? drowval : (drowval < drowval_pre && DT > drowval ? drowval : DT_pre);
                                    if (DG_pre < drowval && nbprop < ErodeSegmentX.this.sewidth) {
                                        DG = DG_pre;
                                        ++nbprop;
                                    } else {
                                        DG = nbprop >= ErodeSegmentX.this.sewidth ? DT : drowval;
                                        DT = 1.7976931348623157E308;
                                        nbprop = 0;
                                    }
                                    doublebufferout[pos + sizex1 - x] = x < ErodeSegmentX.this.sewidth ? DG : Math.min(DG, this.bufferdouble[x - ErodeSegmentX.this.sewidth]);
                                }
                                ++y;
                                pos += sizex;
                            }
                            ++z;
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("Type not supported (yet).");
                    }
                }
                break;
            }
        }
    }

    private class ErodeInterXhistThread
    extends Thread {
        private int miny;
        private int maxy;
        private int[] Hist = new int[256];
        public final Object lock = new Object();
        private boolean Kill = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.Hist = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(int miny, int maxy) {
            this.miny = miny;
            this.maxy = maxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block8: while (true) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        ErodeSegmentX.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                int type = ErodeSegmentX.this.Type;
                int sizex = ErodeSegmentX.this.SizeX;
                int sizez = ErodeSegmentX.this.SizeZ;
                int layer = ErodeSegmentX.this.Layer;
                int channel = ErodeSegmentX.this.Channel;
                int sewidthchannel = ErodeSegmentX.this.sewidth * channel;
                Arrays.fill(this.Hist, 0);
                switch (type) {
                    case -2: {
                        byte[] bbin = (byte[])ErodeSegmentX.this.sigin;
                        byte[] bbout = (byte[])ErodeSegmentX.this.sigout;
                        for (int z = 0; z < sizez; ++z) {
                            for (int y = this.miny; y < this.maxy; ++y) {
                                for (int c = 0; c < channel; ++c) {
                                    int x;
                                    int aux;
                                    int x2;
                                    int mini = 255;
                                    int pos = (z * layer + y * sizex) * channel + c;
                                    int end = pos + ErodeSegmentX.this.sewidth * channel;
                                    for (x2 = pos; x2 < end; x2 += channel) {
                                        int n = aux = bbin[x2] & 0xFF;
                                        this.Hist[n] = this.Hist[n] + 1;
                                        if (aux >= mini) continue;
                                        mini = aux;
                                    }
                                    for (x2 = pos; x2 < end; x2 += channel) {
                                        int n = aux = bbin[x2 + sewidthchannel] & 0xFF;
                                        this.Hist[n] = this.Hist[n] + 1;
                                        if (aux < mini) {
                                            mini = aux;
                                        }
                                        bbout[x2] = (byte)mini;
                                    }
                                    int start = end;
                                    int end2 = pos + (sizex - ErodeSegmentX.this.sewidth) * channel;
                                    for (int x3 = start; x3 < end2; x3 += channel) {
                                        int aux2;
                                        int n = aux2 = bbin[x3 + sewidthchannel] & 0xFF;
                                        this.Hist[n] = this.Hist[n] + 1;
                                        if (aux2 < mini) {
                                            mini = aux2;
                                        }
                                        bbout[x3] = (byte)mini;
                                        int n2 = bbin[x3 - sewidthchannel] & 0xFF;
                                        this.Hist[n2] = this.Hist[n2] - 1;
                                        while (this.Hist[mini] == 0) {
                                            ++mini;
                                        }
                                    }
                                    int start2 = end2;
                                    int end3 = pos + sizex * channel;
                                    for (x = start2; x < end3; x += channel) {
                                        bbout[x] = (byte)mini;
                                        int n = bbin[x - sewidthchannel] & 0xFF;
                                        this.Hist[n] = this.Hist[n] - 1;
                                        while (this.Hist[mini] == 0) {
                                            ++mini;
                                        }
                                    }
                                    for (x = start2; x < end3; x += channel) {
                                        int n = bbin[x] & 0xFF;
                                        this.Hist[n] = this.Hist[n] - 1;
                                    }
                                }
                            }
                        }
                        bbout = null;
                        bbin = null;
                        continue block8;
                    }
                }
                break;
            }
            throw new IllegalArgumentException("Type not supported (yet).");
        }
    }

    private class ErodeXavThread
    extends Thread {
        private int miny;
        private int maxy;
        public final Object lock = new Object();
        private boolean Kill = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(int miny, int maxy) {
            this.miny = miny;
            this.maxy = maxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block12: while (true) lbl-1000:
            // 6 sources

            {
                var1_2 = this.lock;
                synchronized (var1_2) {
                    try {
                        ErodeSegmentX.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                type = ErodeSegmentX.this.Type;
                sizex = ErodeSegmentX.this.SizeX;
                sizez = ErodeSegmentX.this.SizeZ;
                layer = ErodeSegmentX.this.Layer;
                channel = ErodeSegmentX.this.Channel;
                switch (type) {
                    case -2: {
                        c = 0;
                        while (true) {
                            if (c >= channel) ** GOTO lbl-1000
                            bytebufferin = (byte[])ErodeSegmentX.this.sigsin[c];
                            bytebufferout = (byte[])ErodeSegmentX.this.sigsout[c];
                            for (z = 0; z < sizez; ++z) {
                                y = this.miny;
                                pos = z * layer + y * sizex;
                                while (y < this.maxy) {
                                    System.arraycopy(bytebufferin, pos, bytebufferout, pos, sizex);
                                    for (s = 1; s <= ErodeSegmentX.this.sewidth; ++s) {
                                        ArrayMM.MinimumUnsigned(bytebufferin, pos + s, bytebufferout, pos, bytebufferout, pos, sizex - s);
                                    }
                                    for (s = -1; -ErodeSegmentX.this.sewidth <= s; --s) {
                                        ArrayMM.MinimumUnsigned(bytebufferin, pos, bytebufferout, pos - s, bytebufferout, pos - s, sizex + s);
                                    }
                                    ++y;
                                    pos += sizex;
                                }
                            }
                            bytebufferout = null;
                            bytebufferin = null;
                            ++c;
                        }
                    }
                    case -3: {
                        c = 0;
                        while (true) {
                            if (c >= channel) ** GOTO lbl-1000
                            shortbufferin = (short[])ErodeSegmentX.this.sigsin[c];
                            shortbufferout = (short[])ErodeSegmentX.this.sigsout[c];
                            for (z = 0; z < sizez; ++z) {
                                y = this.miny;
                                pos = z * layer + y * sizex;
                                while (y < this.maxy) {
                                    System.arraycopy(shortbufferin, pos, shortbufferout, pos, sizex);
                                    for (s = 1; s <= ErodeSegmentX.this.sewidth; ++s) {
                                        ArrayMM.MinimumUnsigned(shortbufferin, pos + s, shortbufferout, pos, shortbufferout, pos, sizex - s);
                                    }
                                    for (s = -1; -ErodeSegmentX.this.sewidth <= s; --s) {
                                        ArrayMM.MinimumUnsigned(shortbufferin, pos, shortbufferout, pos - s, shortbufferout, pos - s, sizex + s);
                                    }
                                    ++y;
                                    pos += sizex;
                                }
                            }
                            shortbufferout = null;
                            shortbufferin = null;
                            ++c;
                        }
                    }
                    case -1: {
                        c = 0;
                        while (true) {
                            if (c >= channel) ** GOTO lbl-1000
                            intbufferin = (int[])ErodeSegmentX.this.sigsin[c];
                            intbufferout = (int[])ErodeSegmentX.this.sigsout[c];
                            for (z = 0; z < sizez; ++z) {
                                y = this.miny;
                                pos = z * layer + y * sizex;
                                while (y < this.maxy) {
                                    System.arraycopy(intbufferin, pos, intbufferout, pos, sizex);
                                    for (s = 1; s <= ErodeSegmentX.this.sewidth; ++s) {
                                        ArrayMM.Minimum(intbufferin, pos + s, intbufferout, pos, intbufferout, pos, sizex - s);
                                    }
                                    for (s = -1; -ErodeSegmentX.this.sewidth <= s; --s) {
                                        ArrayMM.Minimum(intbufferin, pos, intbufferout, pos - s, intbufferout, pos - s, sizex + s);
                                    }
                                    ++y;
                                    pos += sizex;
                                }
                            }
                            intbufferout = null;
                            intbufferin = null;
                            ++c;
                        }
                    }
                    case -4: {
                        c = 0;
                        while (true) {
                            if (c >= channel) ** GOTO lbl-1000
                            floatbufferin = (float[])ErodeSegmentX.this.sigsin[c];
                            floatbufferout = (float[])ErodeSegmentX.this.sigsout[c];
                            for (z = 0; z < sizez; ++z) {
                                y = this.miny;
                                pos = z * layer + y * sizex;
                                while (y < this.maxy) {
                                    System.arraycopy(floatbufferin, pos, floatbufferout, pos, sizex);
                                    for (s = 1; s <= ErodeSegmentX.this.sewidth; ++s) {
                                        ArrayMM.Minimum(floatbufferin, pos + s, floatbufferout, pos, floatbufferout, pos, sizex - s);
                                    }
                                    for (s = -1; -ErodeSegmentX.this.sewidth <= s; --s) {
                                        ArrayMM.Minimum(floatbufferin, pos, floatbufferout, pos - s, floatbufferout, pos - s, sizex + s);
                                    }
                                    ++y;
                                    pos += sizex;
                                }
                            }
                            floatbufferout = null;
                            floatbufferin = null;
                            ++c;
                        }
                    }
                    case -5: {
                        c = 0;
                        while (true) {
                            if (c >= channel) continue block12;
                            doublebufferin = (double[])ErodeSegmentX.this.sigsin[c];
                            doublebufferout = (double[])ErodeSegmentX.this.sigsout[c];
                            for (z = 0; z < sizez; ++z) {
                                y = this.miny;
                                pos = z * layer + y * sizex;
                                while (y < this.maxy) {
                                    System.arraycopy(doublebufferin, pos, doublebufferout, pos, sizex);
                                    for (s = 1; s <= ErodeSegmentX.this.sewidth; ++s) {
                                        ArrayMM.Minimum(doublebufferin, pos + s, doublebufferout, pos, doublebufferout, pos, sizex - s);
                                    }
                                    for (s = -1; -ErodeSegmentX.this.sewidth <= s; --s) {
                                        ArrayMM.Minimum(doublebufferin, pos, doublebufferout, pos - s, doublebufferout, pos - s, sizex + s);
                                    }
                                    ++y;
                                    pos += sizex;
                                }
                            }
                            doublebufferout = null;
                            doublebufferin = null;
                            ++c;
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("Type not supported (yet).");
                    }
                }
                break;
            }
        }
    }

    private class ErodeXfmThread
    extends Thread {
        private int miny;
        private int maxy;
        private int[] buffer = null;
        private float[] bufferfloat = null;
        private double[] bufferdouble = null;
        public final Object lock = new Object();
        private boolean Kill = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.buffer = null;
            this.bufferfloat = null;
            this.bufferdouble = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(int miny, int maxy) {
            this.miny = miny;
            this.maxy = maxy;
            switch (ErodeSegmentX.this.Type) {
                case -3: 
                case -1: {
                    this.bufferdouble = null;
                    this.bufferfloat = null;
                    if (this.buffer != null && this.buffer.length == ErodeSegmentX.this.SizeX) break;
                    this.buffer = null;
                    this.buffer = new int[ErodeSegmentX.this.SizeX];
                    break;
                }
                case -4: {
                    this.buffer = null;
                    this.bufferdouble = null;
                    if (this.bufferfloat != null && this.bufferfloat.length == ErodeSegmentX.this.SizeX) break;
                    this.bufferfloat = null;
                    this.bufferfloat = new float[ErodeSegmentX.this.SizeX];
                    break;
                }
                case -5: {
                    this.buffer = null;
                    this.bufferfloat = null;
                    if (this.bufferdouble != null && this.bufferdouble.length == ErodeSegmentX.this.SizeX) break;
                    this.bufferdouble = null;
                    this.bufferdouble = new double[ErodeSegmentX.this.SizeX];
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Type not supported (yet).");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block11: while (true) lbl-1000:
            // 5 sources

            {
                var1_2 = this.lock;
                synchronized (var1_2) {
                    try {
                        ErodeSegmentX.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                type = ErodeSegmentX.this.Type;
                sizex = ErodeSegmentX.this.SizeX;
                sizez = ErodeSegmentX.this.SizeZ;
                layer = ErodeSegmentX.this.Layer;
                channel = ErodeSegmentX.this.Channel;
                sizex1 = sizex - 1;
                sizexsewidth1 = sizex1 - ErodeSegmentX.this.sewidth;
                switch (type) {
                    case -3: {
                        c = 0;
                        while (true) {
                            if (c >= channel) ** GOTO lbl-1000
                            shortbufferin = (short[])ErodeSegmentX.this.sigsin[c];
                            shortbufferout = (short[])ErodeSegmentX.this.sigsout[c];
                            for (z = 0; z < sizez; ++z) {
                                y = this.miny;
                                pos = z * layer + y * sizex;
                                while (y < this.maxy) {
                                    T = 65535;
                                    G = 65535;
                                    nbprop = 0;
                                    for (x = 0; x < sizex; ++x) {
                                        T_pre = T;
                                        G_pre = G;
                                        rowval = shortbufferin[pos + x] & 65535;
                                        T = x > sizexsewidth1 ? (T_pre > rowval ? rowval : T_pre) : 65535;
                                        if (G_pre < rowval && nbprop < ErodeSegmentX.this.sewidth) {
                                            G = G_pre;
                                            ++nbprop;
                                        } else {
                                            G = x > sizexsewidth1 && nbprop >= ErodeSegmentX.this.sewidth ? T : rowval;
                                            T = 65535;
                                            nbprop = 0;
                                        }
                                        this.buffer[sizex1 - x] = x - ErodeSegmentX.this.sewidth < 0 ? G : Math.min(G, shortbufferin[pos + x - ErodeSegmentX.this.sewidth] & 65535);
                                    }
                                    T = 65535;
                                    G = 65535;
                                    nbprop = 0;
                                    rowval = 65535;
                                    rowval_pre = 65535;
                                    for (x = 0; x < sizex; ++x) {
                                        T_pre = T;
                                        G_pre = G;
                                        rowval_pre = rowval;
                                        rowval = this.buffer[x];
                                        T = x == 0 ? rowval : (rowval < rowval_pre && T > rowval ? rowval : T_pre);
                                        if (G_pre < rowval && nbprop < ErodeSegmentX.this.sewidth) {
                                            G = G_pre;
                                            ++nbprop;
                                        } else {
                                            G = nbprop >= ErodeSegmentX.this.sewidth ? T : rowval;
                                            T = 65535;
                                            nbprop = 0;
                                        }
                                        shortbufferout[pos + sizex1 - x] = x < ErodeSegmentX.this.sewidth ? (short)G : (short)Math.min(G, this.buffer[x - ErodeSegmentX.this.sewidth]);
                                    }
                                    ++y;
                                    pos += sizex;
                                }
                            }
                            ++c;
                        }
                    }
                    case -1: {
                        c = 0;
                        while (true) {
                            if (c >= channel) ** GOTO lbl-1000
                            intbufferin = (int[])ErodeSegmentX.this.sigsin[c];
                            intbufferout = (int[])ErodeSegmentX.this.sigsout[c];
                            for (z = 0; z < sizez; ++z) {
                                y = this.miny;
                                pos = z * layer + y * sizex;
                                while (y < this.maxy) {
                                    T = 0x7FFFFFFF;
                                    G = 0x7FFFFFFF;
                                    nbprop = 0;
                                    for (x = 0; x < sizex; ++x) {
                                        T_pre = T;
                                        G_pre = G;
                                        rowval = intbufferin[pos + x];
                                        T = x > sizexsewidth1 ? (T_pre > rowval ? rowval : T_pre) : 0x7FFFFFFF;
                                        if (G_pre < rowval && nbprop < ErodeSegmentX.this.sewidth) {
                                            G = G_pre;
                                            ++nbprop;
                                        } else {
                                            G = x > sizexsewidth1 && nbprop >= ErodeSegmentX.this.sewidth ? T : rowval;
                                            T = 0x7FFFFFFF;
                                            nbprop = 0;
                                        }
                                        this.buffer[sizex1 - x] = x - ErodeSegmentX.this.sewidth < 0 ? G : Math.min(G, intbufferin[pos + x - ErodeSegmentX.this.sewidth]);
                                    }
                                    T = 0x7FFFFFFF;
                                    G = 0x7FFFFFFF;
                                    nbprop = 0;
                                    rowval = 0x7FFFFFFF;
                                    rowval_pre = 0x7FFFFFFF;
                                    for (x = 0; x < sizex; ++x) {
                                        T_pre = T;
                                        G_pre = G;
                                        rowval_pre = rowval;
                                        rowval = this.buffer[x];
                                        T = x == 0 ? rowval : (rowval < rowval_pre && T > rowval ? rowval : T_pre);
                                        if (G_pre < rowval && nbprop < ErodeSegmentX.this.sewidth) {
                                            G = G_pre;
                                            ++nbprop;
                                        } else {
                                            G = nbprop >= ErodeSegmentX.this.sewidth ? T : rowval;
                                            T = 0x7FFFFFFF;
                                            nbprop = 0;
                                        }
                                        intbufferout[pos + sizex1 - x] = x < ErodeSegmentX.this.sewidth ? G : Math.min(G, this.buffer[x - ErodeSegmentX.this.sewidth]);
                                    }
                                    ++y;
                                    pos += sizex;
                                }
                            }
                            ++c;
                        }
                    }
                    case -4: {
                        c = 0;
                        while (true) {
                            if (c >= channel) ** GOTO lbl-1000
                            floatbufferin = (float[])ErodeSegmentX.this.sigsin[c];
                            floatbufferout = (float[])ErodeSegmentX.this.sigsout[c];
                            for (z = 0; z < sizez; ++z) {
                                y = this.miny;
                                pos = z * layer + y * sizex;
                                while (y < this.maxy) {
                                    FT = 3.4028235E38f;
                                    FG = 3.4028235E38f;
                                    nbprop = 0;
                                    for (x = 0; x < sizex; ++x) {
                                        FT_pre = FT;
                                        FG_pre = FG;
                                        frowval = floatbufferin[pos + x];
                                        FT = x > sizexsewidth1 ? (FT_pre > frowval ? frowval : FT_pre) : 3.4028235E38f;
                                        if (FG_pre < frowval && nbprop < ErodeSegmentX.this.sewidth) {
                                            FG = FG_pre;
                                            ++nbprop;
                                        } else {
                                            FG = x > sizexsewidth1 && nbprop >= ErodeSegmentX.this.sewidth ? FT : frowval;
                                            FT = 3.4028235E38f;
                                            nbprop = 0;
                                        }
                                        this.bufferfloat[sizex1 - x] = x - ErodeSegmentX.this.sewidth < 0 ? FG : Math.min(FG, floatbufferin[pos + x - ErodeSegmentX.this.sewidth]);
                                    }
                                    FT = 3.4028235E38f;
                                    FG = 3.4028235E38f;
                                    nbprop = 0;
                                    frowval = 3.4028235E38f;
                                    frowval_pre = 3.4028235E38f;
                                    for (x = 0; x < sizex; ++x) {
                                        FT_pre = FT;
                                        FG_pre = FG;
                                        frowval_pre = frowval;
                                        frowval = this.bufferfloat[x];
                                        FT = x == 0 ? frowval : (frowval < frowval_pre && FT > frowval ? frowval : FT_pre);
                                        if (FG_pre < frowval && nbprop < ErodeSegmentX.this.sewidth) {
                                            FG = FG_pre;
                                            ++nbprop;
                                        } else {
                                            FG = nbprop >= ErodeSegmentX.this.sewidth ? FT : frowval;
                                            FT = 3.4028235E38f;
                                            nbprop = 0;
                                        }
                                        floatbufferout[pos + sizex1 - x] = x < ErodeSegmentX.this.sewidth ? FG : Math.min(FG, this.bufferfloat[x - ErodeSegmentX.this.sewidth]);
                                    }
                                    ++y;
                                    pos += sizex;
                                }
                            }
                            ++c;
                        }
                    }
                    case -5: {
                        c = 0;
                        while (true) {
                            if (c >= channel) continue block11;
                            doublebufferin = (double[])ErodeSegmentX.this.sigsin[c];
                            doublebufferout = (double[])ErodeSegmentX.this.sigsout[c];
                            for (z = 0; z < sizez; ++z) {
                                y = this.miny;
                                pos = z * layer + y * sizex;
                                while (y < this.maxy) {
                                    DT = 1.7976931348623157E308;
                                    DG = 1.7976931348623157E308;
                                    nbprop = 0;
                                    for (x = 0; x < sizex; ++x) {
                                        DT_pre = DT;
                                        DG_pre = DG;
                                        drowval = doublebufferin[pos + x];
                                        DT = x > sizexsewidth1 ? (DT_pre > drowval ? drowval : DT_pre) : 1.7976931348623157E308;
                                        if (DG_pre < drowval && nbprop < ErodeSegmentX.this.sewidth) {
                                            DG = DG_pre;
                                            ++nbprop;
                                        } else {
                                            DG = x > sizexsewidth1 && nbprop >= ErodeSegmentX.this.sewidth ? DT : drowval;
                                            DT = 1.7976931348623157E308;
                                            nbprop = 0;
                                        }
                                        this.bufferdouble[sizex1 - x] = x - ErodeSegmentX.this.sewidth < 0 ? DG : Math.min(DG, doublebufferin[pos + x - ErodeSegmentX.this.sewidth]);
                                    }
                                    DT = 1.7976931348623157E308;
                                    DG = 1.7976931348623157E308;
                                    nbprop = 0;
                                    drowval = 1.7976931348623157E308;
                                    drowval_pre = 1.7976931348623157E308;
                                    for (x = 0; x < sizex; ++x) {
                                        DT_pre = DT;
                                        DG_pre = DG;
                                        drowval_pre = drowval;
                                        drowval = this.bufferdouble[x];
                                        DT = x == 0 ? drowval : (drowval < drowval_pre && DT > drowval ? drowval : DT_pre);
                                        if (DG_pre < drowval && nbprop < ErodeSegmentX.this.sewidth) {
                                            DG = DG_pre;
                                            ++nbprop;
                                        } else {
                                            DG = nbprop >= ErodeSegmentX.this.sewidth ? DT : drowval;
                                            DT = 1.7976931348623157E308;
                                            nbprop = 0;
                                        }
                                        doublebufferout[pos + sizex1 - x] = x < ErodeSegmentX.this.sewidth ? DG : Math.min(DG, this.bufferdouble[x - ErodeSegmentX.this.sewidth]);
                                    }
                                    ++y;
                                    pos += sizex;
                                }
                            }
                            ++c;
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("Type not supported (yet).");
                    }
                }
                break;
            }
        }
    }

    private class ErodeXhistThread
    extends Thread {
        private int miny;
        private int maxy;
        private int[] Hist = new int[256];
        public final Object lock = new Object();
        private boolean Kill = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.Hist = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(int miny, int maxy) {
            this.miny = miny;
            this.maxy = maxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block8: while (true) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        ErodeSegmentX.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                int type = ErodeSegmentX.this.Type;
                int sizex = ErodeSegmentX.this.SizeX;
                int sizez = ErodeSegmentX.this.SizeZ;
                int layer = ErodeSegmentX.this.Layer;
                int channel = ErodeSegmentX.this.Channel;
                Arrays.fill(this.Hist, 0);
                switch (type) {
                    case -2: {
                        int c = 0;
                        while (true) {
                            if (c >= channel) continue block8;
                            byte[] bytebufferin = (byte[])ErodeSegmentX.this.sigsin[c];
                            byte[] bytebufferout = (byte[])ErodeSegmentX.this.sigsout[c];
                            for (int z = 0; z < sizez; ++z) {
                                int y = this.miny;
                                int pos = z * layer + y * sizex;
                                while (y < this.maxy) {
                                    int x;
                                    int aux;
                                    int x2;
                                    int mini = 255;
                                    int end = pos + ErodeSegmentX.this.sewidth;
                                    for (x2 = pos; x2 < end; ++x2) {
                                        int n = aux = bytebufferin[x2] & 0xFF;
                                        this.Hist[n] = this.Hist[n] + 1;
                                        if (aux >= mini) continue;
                                        mini = aux;
                                    }
                                    for (x2 = pos; x2 < end; ++x2) {
                                        int n = aux = bytebufferin[x2 + ErodeSegmentX.this.sewidth] & 0xFF;
                                        this.Hist[n] = this.Hist[n] + 1;
                                        if (aux < mini) {
                                            mini = aux;
                                        }
                                        bytebufferout[x2] = (byte)mini;
                                    }
                                    int start = end;
                                    int end2 = pos + sizex - ErodeSegmentX.this.sewidth;
                                    for (int x3 = start; x3 < end2; ++x3) {
                                        int aux2;
                                        int n = aux2 = bytebufferin[x3 + ErodeSegmentX.this.sewidth] & 0xFF;
                                        this.Hist[n] = this.Hist[n] + 1;
                                        if (aux2 < mini) {
                                            mini = aux2;
                                        }
                                        bytebufferout[x3] = (byte)mini;
                                        int n2 = bytebufferin[x3 - ErodeSegmentX.this.sewidth] & 0xFF;
                                        this.Hist[n2] = this.Hist[n2] - 1;
                                        while (this.Hist[mini] == 0) {
                                            ++mini;
                                        }
                                    }
                                    int start2 = end2;
                                    int end3 = pos + sizex;
                                    for (x = start2; x < end3; ++x) {
                                        bytebufferout[x] = (byte)mini;
                                        int n = bytebufferin[x - ErodeSegmentX.this.sewidth] & 0xFF;
                                        this.Hist[n] = this.Hist[n] - 1;
                                        while (this.Hist[mini] == 0) {
                                            ++mini;
                                        }
                                    }
                                    for (x = start2; x < end3; ++x) {
                                        int n = bytebufferin[x] & 0xFF;
                                        this.Hist[n] = this.Hist[n] - 1;
                                    }
                                    ++y;
                                    pos += sizex;
                                }
                            }
                            bytebufferout = null;
                            bytebufferin = null;
                            ++c;
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("Type not supported (yet).");
                    }
                }
                break;
            }
        }
    }
}

