/*
 * Decompiled with CFR 0.152.
 */
package morphee.fastMorphee;

import dv.DV;
import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.util.ArrayList;
import java.util.List;
import morphee.MorphoFilter;
import morphee.StructuringElement;
import morphee.StructuringElement3D;
import morphee.fastMorphee.ErodeSegment135;
import morphee.fastMorphee.ErodeSegment45;
import morphee.fastMorphee.ErodeSquare;
import utils.memory.Allocator;

public class ErodeOctagon
implements MorphoFilter {
    private final Allocator allocator = Allocator.Instance();
    private final ErodeSquare erosquare = new ErodeSquare();
    private final ErodeSegment135 eroseg135 = new ErodeSegment135();
    private final ErodeSegment45 eroseg45 = new ErodeSegment45();
    private int sewidth = 0;

    @Override
    public synchronized void Kill() {
        this.erosquare.Kill();
        this.eroseg135.Kill();
        this.eroseg45.Kill();
    }

    @Override
    public BufferedImage Filter(BufferedImage source, StructuringElement se, int nbCPU) {
        this.setStructuringElement(se);
        return this.Filter(source, nbCPU);
    }

    @Override
    public void Filter(BufferedImage source, StructuringElement se, BufferedImage result, int nbCPU) {
        this.setStructuringElement(se);
        this.Filter(source, result, nbCPU);
    }

    @Override
    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same(source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    @Override
    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        if (this.sewidth == 0) {
            throw new IllegalArgumentException("Structuring element's width not defined or less/equals than 0.");
        }
        this.Filter(source, this.sewidth, result, nbCPU);
    }

    public void Filter(BufferedImage source, int sewidth, BufferedImage result, int nbCPU) {
        BufferedImage imtmp = ImageNew.Same(source);
        this.sewidth = sewidth;
        Object[] src = new Object[1];
        Object[] tmp = new Object[1];
        Object[] res = new Object[1];
        block0 : switch (source.getType()) {
            case 10: {
                src[0] = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                tmp[0] = ((DataBufferByte)imtmp.getRaster().getDataBuffer()).getData();
                res[0] = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                this.erosquare.Filter(source, sewidth, result, nbCPU);
                this.eroseg135.Filter(res, source.getWidth(), source.getHeight(), 1, -2, sewidth, tmp, nbCPU);
                this.eroseg45.Filter(tmp, source.getWidth(), source.getHeight(), 1, -2, sewidth, res, nbCPU);
                break;
            }
            case 11: {
                src[0] = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                tmp[0] = ((DataBufferUShort)imtmp.getRaster().getDataBuffer()).getData();
                res[0] = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                this.erosquare.Filter(source, sewidth, result, nbCPU);
                this.eroseg135.Filter(res, source.getWidth(), source.getHeight(), 1, -3, sewidth, tmp, nbCPU);
                this.eroseg45.Filter(tmp, source.getWidth(), source.getHeight(), 1, -3, sewidth, res, nbCPU);
                break;
            }
            case 5: 
            case 6: {
                this.erosquare.Filter(source, sewidth, result, nbCPU);
                this.eroseg135.FilterInterlaced(((DataBufferByte)result.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight(), 1, source.getRaster().getNumBands(), -2, sewidth, ((DataBufferByte)imtmp.getRaster().getDataBuffer()).getData(), nbCPU);
                this.eroseg45.FilterInterlaced(((DataBufferByte)imtmp.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight(), 1, source.getRaster().getNumBands(), -2, sewidth, ((DataBufferByte)result.getRaster().getDataBuffer()).getData(), nbCPU);
                break;
            }
            case 0: {
                switch (source.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        this.erosquare.Filter(source, sewidth, result, nbCPU);
                        this.eroseg135.FilterInterlaced(((DataBufferInt)result.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight(), 1, source.getRaster().getNumBands(), -1, sewidth, ((DataBufferInt)imtmp.getRaster().getDataBuffer()).getData(), nbCPU);
                        this.eroseg45.FilterInterlaced(((DataBufferInt)imtmp.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight(), 1, source.getRaster().getNumBands(), -1, sewidth, ((DataBufferInt)result.getRaster().getDataBuffer()).getData(), nbCPU);
                        break block0;
                    }
                    case 4: {
                        this.erosquare.Filter(source, sewidth, result, nbCPU);
                        this.eroseg135.FilterInterlaced(((DataBufferFloat)result.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight(), 1, source.getRaster().getNumBands(), -4, sewidth, ((DataBufferFloat)imtmp.getRaster().getDataBuffer()).getData(), nbCPU);
                        this.eroseg45.FilterInterlaced(((DataBufferFloat)imtmp.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight(), 1, source.getRaster().getNumBands(), -4, sewidth, ((DataBufferFloat)result.getRaster().getDataBuffer()).getData(), nbCPU);
                        break block0;
                    }
                    case 5: {
                        this.erosquare.Filter(source, sewidth, result, nbCPU);
                        this.eroseg135.FilterInterlaced(((DataBufferDouble)result.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight(), 1, source.getRaster().getNumBands(), -5, sewidth, ((DataBufferDouble)imtmp.getRaster().getDataBuffer()).getData(), nbCPU);
                        this.eroseg45.FilterInterlaced(((DataBufferDouble)imtmp.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight(), 1, source.getRaster().getNumBands(), -5, sewidth, ((DataBufferDouble)result.getRaster().getDataBuffer()).getData(), nbCPU);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        imtmp = this.allocator.Release(imtmp);
        res[0] = null;
        tmp[0] = null;
        src[0] = null;
        res = null;
        tmp = null;
        src = null;
    }

    @Override
    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    @Override
    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    @Override
    public DV Filter(DV source, StructuringElement3D se, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    @Override
    public void Filter(DV source, StructuringElement3D se, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    @Override
    public StructuringElement3D getStructuringElement3D() {
        return null;
    }

    @Override
    public void setStructuringElement3D(StructuringElement3D se) {
    }

    @Override
    public StructuringElement getStructuringElement() {
        return null;
    }

    @Override
    public void setStructuringElement(StructuringElement se) {
        this.sewidth = se.getOrder();
    }

    @Override
    public void Parameters(Object ... parameters) {
        if (parameters.length != 1) {
            throw new IllegalArgumentException("Exactly 1 parameter required.");
        }
        this.sewidth = (Integer)parameters[0];
    }

    @Override
    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(1);
        params.add(this.sewidth);
        return params;
    }

    @Override
    public int BorderEffectSizeX() {
        return this.sewidth;
    }

    @Override
    public int BorderEffectSizeY() {
        return this.sewidth;
    }

    @Override
    public int BorderEffectSizeZ() {
        return this.sewidth;
    }

    @Override
    public MorphoFilter Clone() {
        ErodeOctagon clone = new ErodeOctagon();
        clone.Parameters(this.sewidth);
        return clone;
    }
}

