/*
 * Decompiled with CFR 0.152.
 */
package morphee.fastMorphee;

import arrayTiTi.ArrayMM;
import java.util.Arrays;
import morphee.fastMorphee.FastMorphee;

public class DilateSegmentX
implements FastMorphee {
    private DilateXhistThread[] threadshist = null;
    private DilateXfmThread[] threadsfm = null;
    private DilateXavThread[] threadsav = null;
    private DilateInterXhistThread[] threadsinterhist = null;
    private DilateInterXfmThread[] threadsinterfm = null;
    private DilateInterXavThread[] threadsinterav = null;
    private int nbFreeThreads = 0;
    private FastMorphee.Algorithm algo = FastMorphee.Algorithm.Histogram;
    private Object sigin;
    private Object sigout;
    private Object[] sigsin;
    private Object[] sigsout;
    private int Channel;
    private int SizeX;
    private int SizeZ;
    private int Layer;
    private int Type;
    private int sewidth;

    @Override
    public synchronized void Kill() {
        int i;
        this.sigout = null;
        this.sigin = null;
        this.sigsout = null;
        this.sigsin = null;
        if (this.threadshist != null) {
            for (i = 0; i < this.threadshist.length; ++i) {
                this.threadshist[i].Kill();
                this.threadshist[i] = null;
            }
            this.threadshist = null;
        }
        if (this.threadsfm != null) {
            for (i = 0; i < this.threadsfm.length; ++i) {
                this.threadsfm[i].Kill();
                this.threadsfm[i] = null;
            }
            this.threadsfm = null;
        }
        if (this.threadsav != null) {
            for (i = 0; i < this.threadsav.length; ++i) {
                this.threadsav[i].Kill();
                this.threadsav[i] = null;
            }
            this.threadsav = null;
        }
        if (this.threadsinterhist != null) {
            for (i = 0; i < this.threadsinterhist.length; ++i) {
                this.threadsinterhist[i].Kill();
                this.threadsinterhist[i] = null;
            }
            this.threadsinterhist = null;
        }
        if (this.threadsinterfm != null) {
            for (i = 0; i < this.threadsinterfm.length; ++i) {
                this.threadsinterfm[i].Kill();
                this.threadsinterfm[i] = null;
            }
            this.threadsinterfm = null;
        }
        if (this.threadsinterav != null) {
            for (i = 0; i < this.threadsinterav.length; ++i) {
                this.threadsinterav[i].Kill();
                this.threadsinterav[i] = null;
            }
            this.threadsinterav = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void FilterInterlaced(Object source, int sizex, int sizey, int sizez, int channel, int type, int sewidth, Object result, int nbCPU) {
        Object object;
        if (sewidth < 1) {
            throw new IllegalArgumentException("The structuring element order must be positive.");
        }
        this.sewidth = sewidth;
        switch (type) {
            case -2: {
                if (sewidth <= 3) {
                    this.StartInterlacedAV(nbCPU);
                    break;
                }
                this.StartInterlacedHist(nbCPU);
                break;
            }
            case -3: {
                if (sewidth <= 4 || channel != 1) {
                    this.StartInterlacedAV(nbCPU);
                    break;
                }
                this.StartInterlacedFM(nbCPU);
                break;
            }
            case -5: 
            case -4: 
            case -1: {
                if (sewidth <= 4 || channel != 1) {
                    this.StartInterlacedAV(nbCPU);
                    break;
                }
                this.StartInterlacedFM(nbCPU);
                break;
            }
            default: {
                throw new IllegalArgumentException("Object type unknown.");
            }
        }
        this.sigin = source;
        this.sigout = result;
        this.SizeX = sizex;
        this.SizeZ = sizez;
        this.Layer = sizex * sizey;
        this.Channel = channel;
        this.Type = type;
        DilateSegmentX dilateSegmentX = this;
        synchronized (dilateSegmentX) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        int step = sizey / nbCPU;
        int nbCPUm1 = nbCPU - 1;
        this.nbFreeThreads = 0;
        switch (this.algo) {
            case AutoVectorization: {
                Object object2;
                for (int i = 0; i < nbCPUm1; ++i) {
                    this.threadsinterav[i].setConditions(i * step, (i + 1) * step);
                    object2 = this.threadsinterav[i].lock;
                    synchronized (object2) {
                        this.threadsinterav[i].lock.notify();
                        continue;
                    }
                }
                this.threadsinterav[nbCPUm1].setConditions(nbCPUm1 * step, sizey);
                Object i = this.threadsinterav[nbCPUm1].lock;
                synchronized (i) {
                    this.threadsinterav[nbCPUm1].lock.notify();
                    break;
                }
            }
            case FastMorphM: {
                Object object2;
                for (int i = 0; i < nbCPUm1; ++i) {
                    this.threadsinterfm[i].setConditions(i * step, (i + 1) * step);
                    object2 = this.threadsinterfm[i].lock;
                    synchronized (object2) {
                        this.threadsinterfm[i].lock.notify();
                        continue;
                    }
                }
                this.threadsinterfm[nbCPUm1].setConditions(nbCPUm1 * step, sizey);
                Object i = this.threadsinterfm[nbCPUm1].lock;
                synchronized (i) {
                    this.threadsinterfm[nbCPUm1].lock.notify();
                    break;
                }
            }
            case Histogram: {
                Object object2;
                for (int i = 0; i < nbCPUm1; ++i) {
                    this.threadsinterhist[i].setConditions(i * step, (i + 1) * step);
                    object2 = this.threadsinterhist[i].lock;
                    synchronized (object2) {
                        this.threadsinterhist[i].lock.notify();
                        continue;
                    }
                }
                this.threadsinterhist[nbCPUm1].setConditions(nbCPUm1 * step, sizey);
                object = this.threadsinterhist[nbCPUm1].lock;
                synchronized (object) {
                    this.threadsinterhist[nbCPUm1].lock.notify();
                    break;
                }
            }
            default: {
                throw new IllegalArgumentException("Unknown algorithm.");
            }
        }
        object = this;
        synchronized (object) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void StartInterlacedHist(int nbCPU) {
        this.algo = FastMorphee.Algorithm.Histogram;
        if (this.threadsinterhist != null && this.threadsinterhist.length == nbCPU) {
            return;
        }
        this.Kill();
        this.nbFreeThreads = 0;
        this.threadsinterhist = new DilateInterXhistThread[nbCPU];
        for (int i = 0; i < nbCPU; ++i) {
            this.threadsinterhist[i] = new DilateInterXhistThread();
            this.threadsinterhist[i].start();
        }
    }

    private void StartInterlacedFM(int nbCPU) {
        this.algo = FastMorphee.Algorithm.FastMorphM;
        if (this.threadsinterfm != null && this.threadsinterfm.length == nbCPU) {
            return;
        }
        this.Kill();
        this.nbFreeThreads = 0;
        this.threadsinterfm = new DilateInterXfmThread[nbCPU];
        for (int i = 0; i < nbCPU; ++i) {
            this.threadsinterfm[i] = new DilateInterXfmThread();
            this.threadsinterfm[i].start();
        }
    }

    private void StartInterlacedAV(int nbCPU) {
        this.algo = FastMorphee.Algorithm.AutoVectorization;
        if (this.threadsinterav != null && this.threadsinterav.length == nbCPU) {
            return;
        }
        this.Kill();
        this.nbFreeThreads = 0;
        this.threadsinterav = new DilateInterXavThread[nbCPU];
        for (int i = 0; i < nbCPU; ++i) {
            this.threadsinterav[i] = new DilateInterXavThread();
            this.threadsinterav[i].start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Filter(Object[] sources, int sizex, int sizey, int sizez, int type, int sewidth, Object[] results, int nbCPU) {
        Object object;
        if (sewidth < 1) {
            throw new IllegalArgumentException("The structuring element order must be positive.");
        }
        this.sewidth = sewidth;
        switch (type) {
            case -2: {
                if (sewidth <= 3) {
                    this.StartAV(nbCPU);
                    break;
                }
                this.StartHist(nbCPU);
                break;
            }
            case -3: {
                if (sewidth <= 3) {
                    this.StartAV(nbCPU);
                    break;
                }
                this.StartFM(nbCPU);
                break;
            }
            case -5: 
            case -4: 
            case -1: {
                if (sewidth <= 3) {
                    this.StartAV(nbCPU);
                    break;
                }
                this.StartFM(nbCPU);
                break;
            }
            default: {
                throw new IllegalArgumentException("Object type unknown.");
            }
        }
        this.sigsin = sources;
        this.sigsout = results;
        this.SizeX = sizex;
        this.SizeZ = sizez;
        this.Layer = sizex * sizey;
        this.Channel = sources.length;
        this.Type = type;
        DilateSegmentX dilateSegmentX = this;
        synchronized (dilateSegmentX) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        int step = sizey / nbCPU;
        int nbCPUm1 = nbCPU - 1;
        this.nbFreeThreads = 0;
        switch (this.algo) {
            case AutoVectorization: {
                Object object2;
                for (int i = 0; i < nbCPU - 1; ++i) {
                    this.threadsav[i].setConditions(i * step, (i + 1) * step);
                    object2 = this.threadsav[i].lock;
                    synchronized (object2) {
                        this.threadsav[i].lock.notify();
                        continue;
                    }
                }
                this.threadsav[nbCPUm1].setConditions(nbCPUm1 * step, sizey);
                Object i = this.threadsav[nbCPUm1].lock;
                synchronized (i) {
                    this.threadsav[nbCPUm1].lock.notify();
                    break;
                }
            }
            case FastMorphM: {
                Object object2;
                for (int i = 0; i < nbCPU - 1; ++i) {
                    this.threadsfm[i].setConditions(i * step, (i + 1) * step);
                    object2 = this.threadsfm[i].lock;
                    synchronized (object2) {
                        this.threadsfm[i].lock.notify();
                        continue;
                    }
                }
                this.threadsfm[nbCPUm1].setConditions(nbCPUm1 * step, sizey);
                Object i = this.threadsfm[nbCPUm1].lock;
                synchronized (i) {
                    this.threadsfm[nbCPUm1].lock.notify();
                    break;
                }
            }
            case Histogram: {
                Object object2;
                for (int i = 0; i < nbCPU - 1; ++i) {
                    this.threadshist[i].setConditions(i * step, (i + 1) * step);
                    object2 = this.threadshist[i].lock;
                    synchronized (object2) {
                        this.threadshist[i].lock.notify();
                        continue;
                    }
                }
                this.threadshist[nbCPUm1].setConditions(nbCPUm1 * step, sizey);
                object = this.threadshist[nbCPUm1].lock;
                synchronized (object) {
                    this.threadshist[nbCPUm1].lock.notify();
                    break;
                }
            }
            default: {
                throw new IllegalArgumentException("Unknown algorithm.");
            }
        }
        object = this;
        synchronized (object) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void StartHist(int nbCPU) {
        this.algo = FastMorphee.Algorithm.Histogram;
        if (this.threadshist != null && this.threadshist.length == nbCPU) {
            return;
        }
        this.Kill();
        this.nbFreeThreads = 0;
        this.threadshist = new DilateXhistThread[nbCPU];
        for (int i = 0; i < nbCPU; ++i) {
            this.threadshist[i] = new DilateXhistThread();
            this.threadshist[i].start();
        }
    }

    private void StartFM(int nbCPU) {
        this.algo = FastMorphee.Algorithm.FastMorphM;
        if (this.threadsfm != null && this.threadsfm.length == nbCPU) {
            return;
        }
        this.Kill();
        this.nbFreeThreads = 0;
        this.threadsfm = new DilateXfmThread[nbCPU];
        for (int i = 0; i < nbCPU; ++i) {
            this.threadsfm[i] = new DilateXfmThread();
            this.threadsfm[i].start();
        }
    }

    private void StartAV(int nbCPU) {
        this.algo = FastMorphee.Algorithm.AutoVectorization;
        if (this.threadsav != null && this.threadsav.length == nbCPU) {
            return;
        }
        this.Kill();
        this.nbFreeThreads = 0;
        this.threadsav = new DilateXavThread[nbCPU];
        for (int i = 0; i < nbCPU; ++i) {
            this.threadsav[i] = new DilateXavThread();
            this.threadsav[i].start();
        }
    }

    protected synchronized void addFreeThread() {
        ++this.nbFreeThreads;
        this.notify();
    }

    private class DilateInterXavThread
    extends Thread {
        private int miny;
        private int maxy;
        public final Object lock = new Object();
        private boolean Kill = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(int miny, int maxy) {
            this.miny = miny;
            this.maxy = maxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block12: while (true) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        DilateSegmentX.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                int type = DilateSegmentX.this.Type;
                int sizex = DilateSegmentX.this.SizeX;
                int sizez = DilateSegmentX.this.SizeZ;
                int layer = DilateSegmentX.this.Layer;
                int channel = DilateSegmentX.this.Channel;
                int sizexchannel = sizex * channel;
                switch (type) {
                    case -2: {
                        byte[] bytebufferin = (byte[])DilateSegmentX.this.sigin;
                        byte[] bytebufferout = (byte[])DilateSegmentX.this.sigout;
                        for (int z = 0; z < sizez; ++z) {
                            int y = this.miny;
                            int pos = (z * layer + y * sizex) * channel;
                            while (y < this.maxy) {
                                int s;
                                System.arraycopy(bytebufferin, pos, bytebufferout, pos, sizexchannel);
                                for (s = 1; s <= DilateSegmentX.this.sewidth; ++s) {
                                    ArrayMM.MaximumUnsigned(bytebufferin, pos + s * channel, bytebufferout, pos, bytebufferout, pos, sizexchannel - s * channel);
                                }
                                for (s = -1; -DilateSegmentX.this.sewidth <= s; --s) {
                                    ArrayMM.MaximumUnsigned(bytebufferin, pos, bytebufferout, pos - s * channel, bytebufferout, pos - s * channel, sizexchannel + s * channel);
                                }
                                ++y;
                                pos += sizexchannel;
                            }
                        }
                        bytebufferout = null;
                        bytebufferin = null;
                        continue block12;
                    }
                    case -3: {
                        short[] shortbufferin = (short[])DilateSegmentX.this.sigin;
                        short[] shortbufferout = (short[])DilateSegmentX.this.sigout;
                        for (int z = 0; z < sizez; ++z) {
                            int y = this.miny;
                            int pos = (z * layer + y * sizex) * channel;
                            while (y < this.maxy) {
                                int s;
                                System.arraycopy(shortbufferin, pos, shortbufferout, pos, sizexchannel);
                                for (s = 1; s <= DilateSegmentX.this.sewidth; ++s) {
                                    ArrayMM.MaximumUnsigned(shortbufferin, pos + s * channel, shortbufferout, pos, shortbufferout, pos, sizexchannel - s * channel);
                                }
                                for (s = -1; -DilateSegmentX.this.sewidth <= s; --s) {
                                    ArrayMM.MaximumUnsigned(shortbufferin, pos, shortbufferout, pos - s * channel, shortbufferout, pos - s * channel, sizexchannel + s * channel);
                                }
                                ++y;
                                pos += sizexchannel;
                            }
                        }
                        shortbufferout = null;
                        shortbufferin = null;
                        continue block12;
                    }
                    case -1: {
                        int[] intbufferin = (int[])DilateSegmentX.this.sigin;
                        int[] intbufferout = (int[])DilateSegmentX.this.sigout;
                        for (int z = 0; z < sizez; ++z) {
                            int y = this.miny;
                            int pos = (z * layer + y * sizex) * channel;
                            while (y < this.maxy) {
                                int s;
                                System.arraycopy(intbufferin, pos, intbufferout, pos, sizexchannel);
                                for (s = 1; s <= DilateSegmentX.this.sewidth; ++s) {
                                    ArrayMM.Maximum(intbufferin, pos + s * channel, intbufferout, pos, intbufferout, pos, sizexchannel - s * channel);
                                }
                                for (s = -1; -DilateSegmentX.this.sewidth <= s; --s) {
                                    ArrayMM.Maximum(intbufferin, pos, intbufferout, pos - s * channel, intbufferout, pos - s * channel, sizexchannel + s * channel);
                                }
                                ++y;
                                pos += sizexchannel;
                            }
                        }
                        intbufferout = null;
                        intbufferin = null;
                        continue block12;
                    }
                    case -4: {
                        float[] floatbufferin = (float[])DilateSegmentX.this.sigin;
                        float[] floatbufferout = (float[])DilateSegmentX.this.sigout;
                        for (int z = 0; z < sizez; ++z) {
                            int y = this.miny;
                            int pos = (z * layer + y * sizex) * channel;
                            while (y < this.maxy) {
                                int s;
                                System.arraycopy(floatbufferin, pos, floatbufferout, pos, sizexchannel);
                                for (s = 1; s <= DilateSegmentX.this.sewidth; ++s) {
                                    ArrayMM.Maximum(floatbufferin, pos + s * channel, floatbufferout, pos, floatbufferout, pos, sizexchannel - s * channel);
                                }
                                for (s = -1; -DilateSegmentX.this.sewidth <= s; --s) {
                                    ArrayMM.Maximum(floatbufferin, pos, floatbufferout, pos - s * channel, floatbufferout, pos - s * channel, sizexchannel + s * channel);
                                }
                                ++y;
                                pos += sizexchannel;
                            }
                        }
                        floatbufferout = null;
                        floatbufferin = null;
                        continue block12;
                    }
                    case -5: {
                        double[] doublebufferin = (double[])DilateSegmentX.this.sigin;
                        double[] doublebufferout = (double[])DilateSegmentX.this.sigout;
                        for (int z = 0; z < sizez; ++z) {
                            int y = this.miny;
                            int pos = (z * layer + y * sizex) * channel;
                            while (y < this.maxy) {
                                int s;
                                System.arraycopy(doublebufferin, pos, doublebufferout, pos, sizexchannel);
                                for (s = 1; s <= DilateSegmentX.this.sewidth; ++s) {
                                    ArrayMM.Maximum(doublebufferin, pos + s * channel, doublebufferout, pos, doublebufferout, pos, sizexchannel - s * channel);
                                }
                                for (s = -1; -DilateSegmentX.this.sewidth <= s; --s) {
                                    ArrayMM.Maximum(doublebufferin, pos, doublebufferout, pos - s * channel, doublebufferout, pos - s * channel, sizexchannel + s * channel);
                                }
                                ++y;
                                pos += sizexchannel;
                            }
                        }
                        doublebufferout = null;
                        doublebufferin = null;
                        continue block12;
                    }
                }
                break;
            }
            throw new IllegalArgumentException("Type not supported (yet).");
        }
    }

    private class DilateInterXfmThread
    extends Thread {
        private int miny;
        private int maxy;
        private int[] buffer = null;
        private float[] bufferfloat = null;
        private double[] bufferdouble = null;
        public final Object lock = new Object();
        private boolean Kill = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.buffer = null;
            this.bufferfloat = null;
            this.bufferdouble = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(int miny, int maxy) {
            if (DilateSegmentX.this.Channel != 1) {
                throw new IllegalArgumentException("Only single channel signal supported (so far).");
            }
            this.miny = miny;
            this.maxy = maxy;
            switch (DilateSegmentX.this.Type) {
                case -3: 
                case -1: {
                    this.bufferdouble = null;
                    this.bufferfloat = null;
                    if (this.buffer != null && this.buffer.length == DilateSegmentX.this.SizeX) break;
                    this.buffer = null;
                    this.buffer = new int[DilateSegmentX.this.SizeX];
                    break;
                }
                case -4: {
                    this.buffer = null;
                    this.bufferdouble = null;
                    if (this.bufferfloat != null && this.bufferfloat.length == DilateSegmentX.this.SizeX) break;
                    this.bufferfloat = null;
                    this.bufferfloat = new float[DilateSegmentX.this.SizeX];
                    break;
                }
                case -5: {
                    this.buffer = null;
                    this.bufferfloat = null;
                    if (this.bufferdouble != null && this.bufferdouble.length == DilateSegmentX.this.SizeX) break;
                    this.bufferdouble = null;
                    this.bufferdouble = new double[DilateSegmentX.this.SizeX];
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Type not supported (yet).");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block11: while (true) {
                var1_2 = this.lock;
                synchronized (var1_2) {
                    try {
                        DilateSegmentX.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                type = DilateSegmentX.this.Type;
                sizex = DilateSegmentX.this.SizeX;
                sizez = DilateSegmentX.this.SizeZ;
                layer = DilateSegmentX.this.Layer;
                sizex1 = sizex - 1;
                sizexsewidth1 = sizex1 - DilateSegmentX.this.sewidth;
                switch (type) {
                    case -3: {
                        shortbufferin = (short[])DilateSegmentX.this.sigin;
                        shortbufferout = (short[])DilateSegmentX.this.sigout;
                        z = 0;
                        while (true) {
                            if (z >= sizez) continue block11;
                            y = this.miny;
                            pos = z * layer + y * sizex;
                            while (y < this.maxy) {
                                T = 0;
                                G = 0;
                                nbprop = 0;
                                for (x = 0; x < sizex; ++x) {
                                    T_pre = T;
                                    G_pre = G;
                                    rowval = shortbufferin[pos + x] & 65535;
                                    T = x > sizexsewidth1 ? (T_pre < rowval ? rowval : T_pre) : 0;
                                    if (G_pre > rowval && nbprop < DilateSegmentX.this.sewidth) {
                                        G = G_pre;
                                        ++nbprop;
                                    } else {
                                        G = x > sizexsewidth1 && nbprop >= DilateSegmentX.this.sewidth ? T : rowval;
                                        T = 0;
                                        nbprop = 0;
                                    }
                                    this.buffer[sizex1 - x] = x - DilateSegmentX.this.sewidth < 0 ? G : Math.max(G, shortbufferin[pos + x - DilateSegmentX.this.sewidth] & 65535);
                                }
                                T = 0;
                                G = 0;
                                nbprop = 0;
                                rowval = 0;
                                rowval_pre = 0;
                                for (x = 0; x < sizex; ++x) {
                                    T_pre = T;
                                    G_pre = G;
                                    rowval_pre = rowval;
                                    rowval = this.buffer[x];
                                    T = x == 0 ? rowval : (rowval > rowval_pre && T < rowval ? rowval : T_pre);
                                    if (G_pre > rowval && nbprop < DilateSegmentX.this.sewidth) {
                                        G = G_pre;
                                        ++nbprop;
                                    } else {
                                        G = nbprop >= DilateSegmentX.this.sewidth ? T : rowval;
                                        T = 0;
                                        nbprop = 0;
                                    }
                                    shortbufferout[pos + sizex1 - x] = x < DilateSegmentX.this.sewidth ? (short)G : (short)Math.max(G, this.buffer[x - DilateSegmentX.this.sewidth]);
                                }
                                ++y;
                                pos += sizex;
                            }
                            ++z;
                        }
                    }
                    case -1: {
                        intbufferin = (int[])DilateSegmentX.this.sigin;
                        intbufferout = (int[])DilateSegmentX.this.sigout;
                        z = 0;
                        while (true) {
                            if (z >= sizez) continue block11;
                            y = this.miny;
                            pos = z * layer + y * sizex;
                            while (y < this.maxy) {
                                T = -2147483648;
                                G = -2147483648;
                                nbprop = 0;
                                for (x = 0; x < sizex; ++x) {
                                    T_pre = T;
                                    G_pre = G;
                                    rowval = intbufferin[pos + x];
                                    T = x > sizexsewidth1 ? (T_pre < rowval ? rowval : T_pre) : -2147483648;
                                    if (G_pre > rowval && nbprop < DilateSegmentX.this.sewidth) {
                                        G = G_pre;
                                        ++nbprop;
                                    } else {
                                        G = x > sizexsewidth1 && nbprop >= DilateSegmentX.this.sewidth ? T : rowval;
                                        T = -2147483648;
                                        nbprop = 0;
                                    }
                                    this.buffer[sizex1 - x] = x - DilateSegmentX.this.sewidth < 0 ? G : Math.max(G, intbufferin[pos + x - DilateSegmentX.this.sewidth]);
                                }
                                T = -2147483648;
                                G = -2147483648;
                                nbprop = 0;
                                rowval = -2147483648;
                                rowval_pre = -2147483648;
                                for (x = 0; x < sizex; ++x) {
                                    T_pre = T;
                                    G_pre = G;
                                    rowval_pre = rowval;
                                    rowval = this.buffer[x];
                                    T = x == 0 ? rowval : (rowval > rowval_pre && T < rowval ? rowval : T_pre);
                                    if (G_pre > rowval && nbprop < DilateSegmentX.this.sewidth) {
                                        G = G_pre;
                                        ++nbprop;
                                    } else {
                                        G = nbprop >= DilateSegmentX.this.sewidth ? T : rowval;
                                        T = -2147483648;
                                        nbprop = 0;
                                    }
                                    intbufferout[pos + sizex1 - x] = x < DilateSegmentX.this.sewidth ? G : Math.max(G, this.buffer[x - DilateSegmentX.this.sewidth]);
                                }
                                ++y;
                                pos += sizex;
                            }
                            ++z;
                        }
                    }
                    case -4: {
                        floatbufferin = (float[])DilateSegmentX.this.sigin;
                        floatbufferout = (float[])DilateSegmentX.this.sigout;
                        z = 0;
                        while (true) {
                            if (z >= sizez) continue block11;
                            y = this.miny;
                            pos = z * layer + y * sizex;
                            while (y < this.maxy) {
                                FT = -3.4028235E38f;
                                FG = -3.4028235E38f;
                                nbprop = 0;
                                for (x = 0; x < sizex; ++x) {
                                    FT_pre = FT;
                                    FG_pre = FG;
                                    frowval = floatbufferin[pos + x];
                                    FT = x > sizexsewidth1 ? (FT_pre < frowval ? frowval : FT_pre) : -3.4028235E38f;
                                    if (FG_pre > frowval && nbprop < DilateSegmentX.this.sewidth) {
                                        FG = FG_pre;
                                        ++nbprop;
                                    } else {
                                        FG = x > sizexsewidth1 && nbprop >= DilateSegmentX.this.sewidth ? FT : frowval;
                                        FT = -3.4028235E38f;
                                        nbprop = 0;
                                    }
                                    this.bufferfloat[sizex1 - x] = x - DilateSegmentX.this.sewidth < 0 ? FG : Math.max(FG, floatbufferin[pos + x - DilateSegmentX.this.sewidth]);
                                }
                                FT = -3.4028235E38f;
                                FG = -3.4028235E38f;
                                nbprop = 0;
                                frowval = -3.4028235E38f;
                                frowval_pre = -3.4028235E38f;
                                for (x = 0; x < sizex; ++x) {
                                    FT_pre = FT;
                                    FG_pre = FG;
                                    frowval_pre = frowval;
                                    frowval = this.bufferfloat[x];
                                    FT = x == 0 ? frowval : (frowval > frowval_pre && FT < frowval ? frowval : FT_pre);
                                    if (FG_pre > frowval && nbprop < DilateSegmentX.this.sewidth) {
                                        FG = FG_pre;
                                        ++nbprop;
                                    } else {
                                        FG = nbprop >= DilateSegmentX.this.sewidth ? FT : frowval;
                                        FT = -3.4028235E38f;
                                        nbprop = 0;
                                    }
                                    floatbufferout[pos + sizex1 - x] = x < DilateSegmentX.this.sewidth ? FG : Math.max(FG, this.bufferfloat[x - DilateSegmentX.this.sewidth]);
                                }
                                ++y;
                                pos += sizex;
                            }
                            ++z;
                        }
                    }
                    case -5: {
                        doublebufferin = (double[])DilateSegmentX.this.sigin;
                        doublebufferout = (double[])DilateSegmentX.this.sigout;
                        z = 0;
                        while (true) {
                            if (z < sizez) ** break;
                            continue block11;
                            y = this.miny;
                            pos = z * layer + y * sizex;
                            while (y < this.maxy) {
                                DT = -1.7976931348623157E308;
                                DG = -1.7976931348623157E308;
                                nbprop = 0;
                                for (x = 0; x < sizex; ++x) {
                                    DT_pre = DT;
                                    DG_pre = DG;
                                    drowval = doublebufferin[pos + x];
                                    DT = x > sizexsewidth1 ? (DT_pre < drowval ? drowval : DT_pre) : -1.7976931348623157E308;
                                    if (DG_pre > drowval && nbprop < DilateSegmentX.this.sewidth) {
                                        DG = DG_pre;
                                        ++nbprop;
                                    } else {
                                        DG = x > sizexsewidth1 && nbprop >= DilateSegmentX.this.sewidth ? DT : drowval;
                                        DT = -1.7976931348623157E308;
                                        nbprop = 0;
                                    }
                                    this.bufferdouble[sizex1 - x] = x - DilateSegmentX.this.sewidth < 0 ? DG : Math.max(DG, doublebufferin[pos + x - DilateSegmentX.this.sewidth]);
                                }
                                DT = -1.7976931348623157E308;
                                DG = -1.7976931348623157E308;
                                nbprop = 0;
                                drowval = -1.7976931348623157E308;
                                drowval_pre = -1.7976931348623157E308;
                                for (x = 0; x < sizex; ++x) {
                                    DT_pre = DT;
                                    DG_pre = DG;
                                    drowval_pre = drowval;
                                    drowval = this.bufferdouble[x];
                                    DT = x == 0 ? drowval : (drowval > drowval_pre && DT < drowval ? drowval : DT_pre);
                                    if (DG_pre > drowval && nbprop < DilateSegmentX.this.sewidth) {
                                        DG = DG_pre;
                                        ++nbprop;
                                    } else {
                                        DG = nbprop >= DilateSegmentX.this.sewidth ? DT : drowval;
                                        DT = -1.7976931348623157E308;
                                        nbprop = 0;
                                    }
                                    doublebufferout[pos + sizex1 - x] = x < DilateSegmentX.this.sewidth ? DG : Math.max(DG, this.bufferdouble[x - DilateSegmentX.this.sewidth]);
                                }
                                ++y;
                                pos += sizex;
                            }
                            ++z;
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("Type not supported (yet).");
                    }
                }
                break;
            }
        }
    }

    private class DilateInterXhistThread
    extends Thread {
        private int miny;
        private int maxy;
        private int[] Hist = new int[256];
        public final Object lock = new Object();
        private boolean Kill = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.Hist = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(int miny, int maxy) {
            this.miny = miny;
            this.maxy = maxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block8: while (true) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        DilateSegmentX.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                int type = DilateSegmentX.this.Type;
                int sizex = DilateSegmentX.this.SizeX;
                int sizez = DilateSegmentX.this.SizeZ;
                int layer = DilateSegmentX.this.Layer;
                int channel = DilateSegmentX.this.Channel;
                int sewidthchannel = DilateSegmentX.this.sewidth * channel;
                int sizexchannel = sizex * channel;
                Arrays.fill(this.Hist, 0);
                switch (type) {
                    case -2: {
                        byte[] bbin = (byte[])DilateSegmentX.this.sigin;
                        byte[] bbout = (byte[])DilateSegmentX.this.sigout;
                        for (int z = 0; z < sizez; ++z) {
                            for (int y = this.miny; y < this.maxy; ++y) {
                                for (int c = 0; c < channel; ++c) {
                                    int x;
                                    int aux;
                                    int x2;
                                    int maxi = 0;
                                    int pos = (z * layer + y * sizex) * channel + c;
                                    int end = pos + sewidthchannel;
                                    for (x2 = pos; x2 < end; x2 += channel) {
                                        int n = aux = bbin[x2] & 0xFF;
                                        this.Hist[n] = this.Hist[n] + 1;
                                        if (aux <= maxi) continue;
                                        maxi = aux;
                                    }
                                    for (x2 = pos; x2 < end; x2 += channel) {
                                        int n = aux = bbin[x2 + sewidthchannel] & 0xFF;
                                        this.Hist[n] = this.Hist[n] + 1;
                                        if (aux > maxi) {
                                            maxi = aux;
                                        }
                                        bbout[x2] = (byte)maxi;
                                    }
                                    int start = end;
                                    int end2 = pos + sizexchannel - sewidthchannel;
                                    for (int x3 = start; x3 < end2; x3 += channel) {
                                        int aux2;
                                        int n = aux2 = bbin[x3 + sewidthchannel] & 0xFF;
                                        this.Hist[n] = this.Hist[n] + 1;
                                        if (aux2 > maxi) {
                                            maxi = aux2;
                                        }
                                        bbout[x3] = (byte)maxi;
                                        int n2 = bbin[x3 - sewidthchannel] & 0xFF;
                                        this.Hist[n2] = this.Hist[n2] - 1;
                                        while (this.Hist[maxi] == 0) {
                                            --maxi;
                                        }
                                    }
                                    int start2 = end2;
                                    int end3 = pos + sizexchannel;
                                    for (x = start2; x < end3; x += channel) {
                                        bbout[x] = (byte)maxi;
                                        int n = bbin[x - sewidthchannel] & 0xFF;
                                        this.Hist[n] = this.Hist[n] - 1;
                                        while (this.Hist[maxi] == 0) {
                                            --maxi;
                                        }
                                    }
                                    for (x = start2; x < end3; x += channel) {
                                        int n = bbin[x] & 0xFF;
                                        this.Hist[n] = this.Hist[n] - 1;
                                    }
                                }
                            }
                        }
                        bbout = null;
                        bbin = null;
                        continue block8;
                    }
                }
                break;
            }
            throw new IllegalArgumentException("Type not supported (yet).");
        }
    }

    private class DilateXavThread
    extends Thread {
        private int miny;
        private int maxy;
        public final Object lock = new Object();
        private boolean Kill = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(int miny, int maxy) {
            this.miny = miny;
            this.maxy = maxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block12: while (true) lbl-1000:
            // 6 sources

            {
                var1_2 = this.lock;
                synchronized (var1_2) {
                    try {
                        DilateSegmentX.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                type = DilateSegmentX.this.Type;
                sizex = DilateSegmentX.this.SizeX;
                sizez = DilateSegmentX.this.SizeZ;
                layer = DilateSegmentX.this.Layer;
                channel = DilateSegmentX.this.Channel;
                switch (type) {
                    case -2: {
                        c = 0;
                        while (true) {
                            if (c >= channel) ** GOTO lbl-1000
                            bytebufferin = (byte[])DilateSegmentX.this.sigsin[c];
                            bytebufferout = (byte[])DilateSegmentX.this.sigsout[c];
                            for (z = 0; z < sizez; ++z) {
                                y = this.miny;
                                pos = z * layer + y * sizex;
                                while (y < this.maxy) {
                                    System.arraycopy(bytebufferin, pos, bytebufferout, pos, sizex);
                                    for (s = 1; s <= DilateSegmentX.this.sewidth; ++s) {
                                        ArrayMM.MaximumUnsigned(bytebufferin, pos + s, bytebufferout, pos, bytebufferout, pos, sizex - s);
                                    }
                                    for (s = -1; -DilateSegmentX.this.sewidth <= s; --s) {
                                        ArrayMM.MaximumUnsigned(bytebufferin, pos, bytebufferout, pos - s, bytebufferout, pos - s, sizex + s);
                                    }
                                    ++y;
                                    pos += sizex;
                                }
                            }
                            bytebufferout = null;
                            bytebufferin = null;
                            ++c;
                        }
                    }
                    case -3: {
                        c = 0;
                        while (true) {
                            if (c >= channel) ** GOTO lbl-1000
                            shortbufferin = (short[])DilateSegmentX.this.sigsin[c];
                            shortbufferout = (short[])DilateSegmentX.this.sigsout[c];
                            for (z = 0; z < sizez; ++z) {
                                y = this.miny;
                                pos = z * layer + y * sizex;
                                while (y < this.maxy) {
                                    System.arraycopy(shortbufferin, pos, shortbufferout, pos, sizex);
                                    for (s = 1; s <= DilateSegmentX.this.sewidth; ++s) {
                                        ArrayMM.MaximumUnsigned(shortbufferin, pos + s, shortbufferout, pos, shortbufferout, pos, sizex - s);
                                    }
                                    for (s = -1; -DilateSegmentX.this.sewidth <= s; --s) {
                                        ArrayMM.MaximumUnsigned(shortbufferin, pos, shortbufferout, pos - s, shortbufferout, pos - s, sizex + s);
                                    }
                                    ++y;
                                    pos += sizex;
                                }
                            }
                            shortbufferout = null;
                            shortbufferin = null;
                            ++c;
                        }
                    }
                    case -1: {
                        c = 0;
                        while (true) {
                            if (c >= channel) ** GOTO lbl-1000
                            intbufferin = (int[])DilateSegmentX.this.sigsin[c];
                            intbufferout = (int[])DilateSegmentX.this.sigsout[c];
                            for (z = 0; z < sizez; ++z) {
                                y = this.miny;
                                pos = z * layer + y * sizex;
                                while (y < this.maxy) {
                                    System.arraycopy(intbufferin, pos, intbufferout, pos, sizex);
                                    for (s = 1; s <= DilateSegmentX.this.sewidth; ++s) {
                                        ArrayMM.Maximum(intbufferin, pos + s, intbufferout, pos, intbufferout, pos, sizex - s);
                                    }
                                    for (s = -1; -DilateSegmentX.this.sewidth <= s; --s) {
                                        ArrayMM.Maximum(intbufferin, pos, intbufferout, pos - s, intbufferout, pos - s, sizex + s);
                                    }
                                    ++y;
                                    pos += sizex;
                                }
                            }
                            intbufferout = null;
                            intbufferin = null;
                            ++c;
                        }
                    }
                    case -4: {
                        c = 0;
                        while (true) {
                            if (c >= channel) ** GOTO lbl-1000
                            floatbufferin = (float[])DilateSegmentX.this.sigsin[c];
                            floatbufferout = (float[])DilateSegmentX.this.sigsout[c];
                            for (z = 0; z < sizez; ++z) {
                                y = this.miny;
                                pos = z * layer + y * sizex;
                                while (y < this.maxy) {
                                    System.arraycopy(floatbufferin, pos, floatbufferout, pos, sizex);
                                    for (s = 1; s <= DilateSegmentX.this.sewidth; ++s) {
                                        ArrayMM.Maximum(floatbufferin, pos + s, floatbufferout, pos, floatbufferout, pos, sizex - s);
                                    }
                                    for (s = -1; -DilateSegmentX.this.sewidth <= s; --s) {
                                        ArrayMM.Maximum(floatbufferin, pos, floatbufferout, pos - s, floatbufferout, pos - s, sizex + s);
                                    }
                                    ++y;
                                    pos += sizex;
                                }
                            }
                            floatbufferout = null;
                            floatbufferin = null;
                            ++c;
                        }
                    }
                    case -5: {
                        c = 0;
                        while (true) {
                            if (c >= channel) continue block12;
                            doublebufferin = (double[])DilateSegmentX.this.sigsin[c];
                            doublebufferout = (double[])DilateSegmentX.this.sigsout[c];
                            for (z = 0; z < sizez; ++z) {
                                y = this.miny;
                                pos = z * layer + y * sizex;
                                while (y < this.maxy) {
                                    System.arraycopy(doublebufferin, pos, doublebufferout, pos, sizex);
                                    for (s = 1; s <= DilateSegmentX.this.sewidth; ++s) {
                                        ArrayMM.Maximum(doublebufferin, pos + s, doublebufferout, pos, doublebufferout, pos, sizex - s);
                                    }
                                    for (s = -1; -DilateSegmentX.this.sewidth <= s; --s) {
                                        ArrayMM.Maximum(doublebufferin, pos, doublebufferout, pos - s, doublebufferout, pos - s, sizex + s);
                                    }
                                    ++y;
                                    pos += sizex;
                                }
                            }
                            doublebufferout = null;
                            doublebufferin = null;
                            ++c;
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("Type not supported (yet).");
                    }
                }
                break;
            }
        }
    }

    private class DilateXfmThread
    extends Thread {
        private int miny;
        private int maxy;
        private int[] buffer = null;
        private float[] bufferfloat = null;
        private double[] bufferdouble = null;
        public final Object lock = new Object();
        private boolean Kill = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.buffer = null;
            this.bufferfloat = null;
            this.bufferdouble = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(int miny, int maxy) {
            this.miny = miny;
            this.maxy = maxy;
            switch (DilateSegmentX.this.Type) {
                case -3: 
                case -1: {
                    this.bufferdouble = null;
                    this.bufferfloat = null;
                    if (this.buffer != null && this.buffer.length == DilateSegmentX.this.SizeX) break;
                    this.buffer = null;
                    this.buffer = new int[DilateSegmentX.this.SizeX];
                    break;
                }
                case -4: {
                    this.buffer = null;
                    this.bufferdouble = null;
                    if (this.bufferfloat != null && this.bufferfloat.length == DilateSegmentX.this.SizeX) break;
                    this.bufferfloat = null;
                    this.bufferfloat = new float[DilateSegmentX.this.SizeX];
                    break;
                }
                case -5: {
                    this.buffer = null;
                    this.bufferfloat = null;
                    if (this.bufferdouble != null && this.bufferdouble.length == DilateSegmentX.this.SizeX) break;
                    this.bufferdouble = null;
                    this.bufferdouble = new double[DilateSegmentX.this.SizeX];
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Type not supported (yet).");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block11: while (true) lbl-1000:
            // 5 sources

            {
                var1_2 = this.lock;
                synchronized (var1_2) {
                    try {
                        DilateSegmentX.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                type = DilateSegmentX.this.Type;
                sizex = DilateSegmentX.this.SizeX;
                sizez = DilateSegmentX.this.SizeZ;
                layer = DilateSegmentX.this.Layer;
                channel = DilateSegmentX.this.Channel;
                sizex1 = sizex - 1;
                sizexsewidth1 = sizex1 - DilateSegmentX.this.sewidth;
                switch (type) {
                    case -3: {
                        c = 0;
                        while (true) {
                            if (c >= channel) ** GOTO lbl-1000
                            shortbufferin = (short[])DilateSegmentX.this.sigsin[c];
                            shortbufferout = (short[])DilateSegmentX.this.sigsout[c];
                            for (z = 0; z < sizez; ++z) {
                                y = this.miny;
                                pos = z * layer + y * sizex;
                                while (y < this.maxy) {
                                    T = 0;
                                    G = 0;
                                    nbprop = 0;
                                    for (x = 0; x < sizex; ++x) {
                                        T_pre = T;
                                        G_pre = G;
                                        rowval = shortbufferin[pos + x] & 65535;
                                        T = x > sizexsewidth1 ? (T_pre < rowval ? rowval : T_pre) : 0;
                                        if (G_pre > rowval && nbprop < DilateSegmentX.this.sewidth) {
                                            G = G_pre;
                                            ++nbprop;
                                        } else {
                                            G = x > sizexsewidth1 && nbprop >= DilateSegmentX.this.sewidth ? T : rowval;
                                            T = 0;
                                            nbprop = 0;
                                        }
                                        this.buffer[sizex1 - x] = x - DilateSegmentX.this.sewidth < 0 ? G : Math.max(G, shortbufferin[pos + x - DilateSegmentX.this.sewidth] & 65535);
                                    }
                                    T = 0;
                                    G = 0;
                                    nbprop = 0;
                                    rowval = 0;
                                    rowval_pre = 0;
                                    for (x = 0; x < sizex; ++x) {
                                        T_pre = T;
                                        G_pre = G;
                                        rowval_pre = rowval;
                                        rowval = this.buffer[x];
                                        T = x == 0 ? rowval : (rowval > rowval_pre && T < rowval ? rowval : T_pre);
                                        if (G_pre > rowval && nbprop < DilateSegmentX.this.sewidth) {
                                            G = G_pre;
                                            ++nbprop;
                                        } else {
                                            G = nbprop >= DilateSegmentX.this.sewidth ? T : rowval;
                                            T = 0;
                                            nbprop = 0;
                                        }
                                        shortbufferout[pos + sizex1 - x] = x < DilateSegmentX.this.sewidth ? (short)G : (short)Math.max(G, this.buffer[x - DilateSegmentX.this.sewidth]);
                                    }
                                    ++y;
                                    pos += sizex;
                                }
                            }
                            ++c;
                        }
                    }
                    case -1: {
                        c = 0;
                        while (true) {
                            if (c >= channel) ** GOTO lbl-1000
                            intbufferin = (int[])DilateSegmentX.this.sigsin[c];
                            intbufferout = (int[])DilateSegmentX.this.sigsout[c];
                            for (z = 0; z < sizez; ++z) {
                                y = this.miny;
                                pos = z * layer + y * sizex;
                                while (y < this.maxy) {
                                    T = -2147483648;
                                    G = -2147483648;
                                    nbprop = 0;
                                    for (x = 0; x < sizex; ++x) {
                                        T_pre = T;
                                        G_pre = G;
                                        rowval = intbufferin[pos + x];
                                        T = x > sizexsewidth1 ? (T_pre < rowval ? rowval : T_pre) : -2147483648;
                                        if (G_pre > rowval && nbprop < DilateSegmentX.this.sewidth) {
                                            G = G_pre;
                                            ++nbprop;
                                        } else {
                                            G = x > sizexsewidth1 && nbprop >= DilateSegmentX.this.sewidth ? T : rowval;
                                            T = -2147483648;
                                            nbprop = 0;
                                        }
                                        this.buffer[sizex1 - x] = x - DilateSegmentX.this.sewidth < 0 ? G : Math.max(G, intbufferin[pos + x - DilateSegmentX.this.sewidth]);
                                    }
                                    T = -2147483648;
                                    G = -2147483648;
                                    nbprop = 0;
                                    rowval = -2147483648;
                                    rowval_pre = -2147483648;
                                    for (x = 0; x < sizex; ++x) {
                                        T_pre = T;
                                        G_pre = G;
                                        rowval_pre = rowval;
                                        rowval = this.buffer[x];
                                        T = x == 0 ? rowval : (rowval > rowval_pre && T < rowval ? rowval : T_pre);
                                        if (G_pre > rowval && nbprop < DilateSegmentX.this.sewidth) {
                                            G = G_pre;
                                            ++nbprop;
                                        } else {
                                            G = nbprop >= DilateSegmentX.this.sewidth ? T : rowval;
                                            T = -2147483648;
                                            nbprop = 0;
                                        }
                                        intbufferout[pos + sizex1 - x] = x < DilateSegmentX.this.sewidth ? G : Math.max(G, this.buffer[x - DilateSegmentX.this.sewidth]);
                                    }
                                    ++y;
                                    pos += sizex;
                                }
                            }
                            ++c;
                        }
                    }
                    case -4: {
                        c = 0;
                        while (true) {
                            if (c >= channel) ** GOTO lbl-1000
                            floatbufferin = (float[])DilateSegmentX.this.sigsin[c];
                            floatbufferout = (float[])DilateSegmentX.this.sigsout[c];
                            for (z = 0; z < sizez; ++z) {
                                y = this.miny;
                                pos = z * layer + y * sizex;
                                while (y < this.maxy) {
                                    FT = -3.4028235E38f;
                                    FG = -3.4028235E38f;
                                    nbprop = 0;
                                    for (x = 0; x < sizex; ++x) {
                                        FT_pre = FT;
                                        FG_pre = FG;
                                        frowval = floatbufferin[pos + x];
                                        FT = x > sizexsewidth1 ? (FT_pre < frowval ? frowval : FT_pre) : -3.4028235E38f;
                                        if (FG_pre > frowval && nbprop < DilateSegmentX.this.sewidth) {
                                            FG = FG_pre;
                                            ++nbprop;
                                        } else {
                                            FG = x > sizexsewidth1 && nbprop >= DilateSegmentX.this.sewidth ? FT : frowval;
                                            FT = -3.4028235E38f;
                                            nbprop = 0;
                                        }
                                        this.bufferfloat[sizex1 - x] = x - DilateSegmentX.this.sewidth < 0 ? FG : Math.max(FG, floatbufferin[pos + x - DilateSegmentX.this.sewidth]);
                                    }
                                    FT = -3.4028235E38f;
                                    FG = -3.4028235E38f;
                                    nbprop = 0;
                                    frowval = -3.4028235E38f;
                                    frowval_pre = -3.4028235E38f;
                                    for (x = 0; x < sizex; ++x) {
                                        FT_pre = FT;
                                        FG_pre = FG;
                                        frowval_pre = frowval;
                                        frowval = this.bufferfloat[x];
                                        FT = x == 0 ? frowval : (frowval > frowval_pre && FT < frowval ? frowval : FT_pre);
                                        if (FG_pre > frowval && nbprop < DilateSegmentX.this.sewidth) {
                                            FG = FG_pre;
                                            ++nbprop;
                                        } else {
                                            FG = nbprop >= DilateSegmentX.this.sewidth ? FT : frowval;
                                            FT = -3.4028235E38f;
                                            nbprop = 0;
                                        }
                                        floatbufferout[pos + sizex1 - x] = x < DilateSegmentX.this.sewidth ? FG : Math.max(FG, this.bufferfloat[x - DilateSegmentX.this.sewidth]);
                                    }
                                    ++y;
                                    pos += sizex;
                                }
                            }
                            ++c;
                        }
                    }
                    case -5: {
                        c = 0;
                        while (true) {
                            if (c >= channel) continue block11;
                            doublebufferin = (double[])DilateSegmentX.this.sigsin[c];
                            doublebufferout = (double[])DilateSegmentX.this.sigsout[c];
                            for (z = 0; z < sizez; ++z) {
                                y = this.miny;
                                pos = z * layer + y * sizex;
                                while (y < this.maxy) {
                                    DT = -1.7976931348623157E308;
                                    DG = -1.7976931348623157E308;
                                    nbprop = 0;
                                    for (x = 0; x < sizex; ++x) {
                                        DT_pre = DT;
                                        DG_pre = DG;
                                        drowval = doublebufferin[pos + x];
                                        DT = x > sizexsewidth1 ? (DT_pre < drowval ? drowval : DT_pre) : -1.7976931348623157E308;
                                        if (DG_pre > drowval && nbprop < DilateSegmentX.this.sewidth) {
                                            DG = DG_pre;
                                            ++nbprop;
                                        } else {
                                            DG = x > sizexsewidth1 && nbprop >= DilateSegmentX.this.sewidth ? DT : drowval;
                                            DT = -1.7976931348623157E308;
                                            nbprop = 0;
                                        }
                                        this.bufferdouble[sizex1 - x] = x - DilateSegmentX.this.sewidth < 0 ? DG : Math.max(DG, doublebufferin[pos + x - DilateSegmentX.this.sewidth]);
                                    }
                                    DT = -1.7976931348623157E308;
                                    DG = -1.7976931348623157E308;
                                    nbprop = 0;
                                    drowval = -1.7976931348623157E308;
                                    drowval_pre = -1.7976931348623157E308;
                                    for (x = 0; x < sizex; ++x) {
                                        DT_pre = DT;
                                        DG_pre = DG;
                                        drowval_pre = drowval;
                                        drowval = this.bufferdouble[x];
                                        DT = x == 0 ? drowval : (drowval > drowval_pre && DT < drowval ? drowval : DT_pre);
                                        if (DG_pre > drowval && nbprop < DilateSegmentX.this.sewidth) {
                                            DG = DG_pre;
                                            ++nbprop;
                                        } else {
                                            DG = nbprop >= DilateSegmentX.this.sewidth ? DT : drowval;
                                            DT = -1.7976931348623157E308;
                                            nbprop = 0;
                                        }
                                        doublebufferout[pos + sizex1 - x] = x < DilateSegmentX.this.sewidth ? DG : Math.max(DG, this.bufferdouble[x - DilateSegmentX.this.sewidth]);
                                    }
                                    ++y;
                                    pos += sizex;
                                }
                            }
                            ++c;
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("Type not supported (yet).");
                    }
                }
                break;
            }
        }
    }

    private class DilateXhistThread
    extends Thread {
        private int miny;
        private int maxy;
        private int[] Hist = new int[256];
        public final Object lock = new Object();
        private boolean Kill = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.Hist = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(int miny, int maxy) {
            this.miny = miny;
            this.maxy = maxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block8: while (true) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        DilateSegmentX.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                int type = DilateSegmentX.this.Type;
                int sizex = DilateSegmentX.this.SizeX;
                int sizez = DilateSegmentX.this.SizeZ;
                int layer = DilateSegmentX.this.Layer;
                int channel = DilateSegmentX.this.Channel;
                Arrays.fill(this.Hist, 0);
                switch (type) {
                    case -2: {
                        int c = 0;
                        while (true) {
                            if (c >= channel) continue block8;
                            byte[] bytebufferin = (byte[])DilateSegmentX.this.sigsin[c];
                            byte[] bytebufferout = (byte[])DilateSegmentX.this.sigsout[c];
                            for (int z = 0; z < sizez; ++z) {
                                int y = this.miny;
                                int pos = z * layer + y * sizex;
                                while (y < this.maxy) {
                                    int x;
                                    int aux;
                                    int x2;
                                    int maxi = 0;
                                    int end = pos + DilateSegmentX.this.sewidth;
                                    for (x2 = pos; x2 < end; ++x2) {
                                        int n = aux = bytebufferin[x2] & 0xFF;
                                        this.Hist[n] = this.Hist[n] + 1;
                                        if (aux <= maxi) continue;
                                        maxi = aux;
                                    }
                                    for (x2 = pos; x2 < end; ++x2) {
                                        int n = aux = bytebufferin[x2 + DilateSegmentX.this.sewidth] & 0xFF;
                                        this.Hist[n] = this.Hist[n] + 1;
                                        if (aux > maxi) {
                                            maxi = aux;
                                        }
                                        bytebufferout[x2] = (byte)maxi;
                                    }
                                    int start = end;
                                    int end2 = pos + sizex - DilateSegmentX.this.sewidth;
                                    for (int x3 = start; x3 < end2; ++x3) {
                                        int aux2;
                                        int n = aux2 = bytebufferin[x3 + DilateSegmentX.this.sewidth] & 0xFF;
                                        this.Hist[n] = this.Hist[n] + 1;
                                        if (aux2 > maxi) {
                                            maxi = aux2;
                                        }
                                        bytebufferout[x3] = (byte)maxi;
                                        int n2 = bytebufferin[x3 - DilateSegmentX.this.sewidth] & 0xFF;
                                        this.Hist[n2] = this.Hist[n2] - 1;
                                        while (this.Hist[maxi] == 0) {
                                            --maxi;
                                        }
                                    }
                                    int start2 = end2;
                                    int end3 = pos + sizex;
                                    for (x = start2; x < end3; ++x) {
                                        bytebufferout[x] = (byte)maxi;
                                        int n = bytebufferin[x - DilateSegmentX.this.sewidth] & 0xFF;
                                        this.Hist[n] = this.Hist[n] - 1;
                                        while (this.Hist[maxi] == 0) {
                                            --maxi;
                                        }
                                    }
                                    for (x = start2; x < end3; ++x) {
                                        int n = bytebufferin[x] & 0xFF;
                                        this.Hist[n] = this.Hist[n] - 1;
                                    }
                                    ++y;
                                    pos += sizex;
                                }
                            }
                            bytebufferout = null;
                            bytebufferin = null;
                            ++c;
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("Type not supported (yet).");
                    }
                }
                break;
            }
        }
    }
}

