/*
 * Decompiled with CFR 0.152.
 */
package morphee.fastMorphee;

import arrayTiTi.ArrayMM;
import mathematics.Maths;
import morphee.fastMorphee.FastMorphee;
import utils.memory.Allocator;

public class DilateHexagon
implements FastMorphee {
    private final Allocator allocator = Allocator.Instance();

    @Override
    public synchronized void Kill() {
    }

    @Override
    public void FilterInterlaced(Object source, int sizex, int sizey, int sizez, int channel, int type, int sewidth, Object result, int nbCPU) {
        if (sewidth < 1) {
            throw new IllegalArgumentException("The structuring element order must be positive.");
        }
        switch (type) {
            case -2: {
                this.Filter((byte[])source, sizex, sizey, channel, sewidth, (byte[])result);
                break;
            }
            case -3: {
                this.Filter((short[])source, sizex, sizey, channel, sewidth, (short[])result);
                break;
            }
            case -1: {
                this.Filter((int[])source, sizex, sizey, channel, sewidth, (int[])result);
                break;
            }
            case -4: {
                this.Filter((float[])source, sizex, sizey, channel, sewidth, (float[])result);
                break;
            }
            case -5: {
                this.Filter((double[])source, sizex, sizey, channel, sewidth, (double[])result);
                break;
            }
            default: {
                throw new IllegalArgumentException("Object type unknown.");
            }
        }
    }

    @Override
    public void Filter(Object[] sources, int sizex, int sizey, int sizez, int type, int sewidth, Object[] results, int nbCPU) {
        if (sewidth < 1) {
            throw new IllegalArgumentException("The structuring element order must be positive.");
        }
        switch (type) {
            case -2: {
                for (int c = 0; c < sources.length; ++c) {
                    this.Filter((byte[])sources[c], sizex, sizey, 1, sewidth, (byte[])results[c]);
                }
                break;
            }
            case -3: {
                for (int c = 0; c < sources.length; ++c) {
                    this.Filter((short[])sources[c], sizex, sizey, 1, sewidth, (short[])results[c]);
                }
                break;
            }
            case -1: {
                for (int c = 0; c < sources.length; ++c) {
                    this.Filter((int[])sources[c], sizex, sizey, 1, sewidth, (int[])results[c]);
                }
                break;
            }
            case -4: {
                for (int c = 0; c < sources.length; ++c) {
                    this.Filter((float[])sources[c], sizex, sizey, 1, sewidth, (float[])results[c]);
                }
                break;
            }
            case -5: {
                for (int c = 0; c < sources.length; ++c) {
                    this.Filter((double[])sources[c], sizex, sizey, 1, sewidth, (double[])results[c]);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Object type unknown.");
            }
        }
    }

    private void DilateRight(byte[] src, int chan, int lmc, byte[] res) {
        ArrayMM.MaximumUnsigned(src, 0, src, chan, res, 0, lmc);
        System.arraycopy(src, lmc, res, lmc, chan);
    }

    private void DilateRight(short[] src, int chan, int lmc, short[] res) {
        ArrayMM.MaximumUnsigned(src, 0, src, chan, res, 0, lmc);
        System.arraycopy(src, lmc, res, lmc, chan);
    }

    private void DilateRight(int[] src, int chan, int lmc, int[] res) {
        ArrayMM.Maximum(src, 0, src, chan, res, 0, lmc);
        System.arraycopy(src, lmc, res, lmc, chan);
    }

    private void DilateRight(float[] src, int chan, int lmc, float[] res) {
        ArrayMM.Maximum(src, 0, src, chan, res, 0, lmc);
        System.arraycopy(src, lmc, res, lmc, chan);
    }

    private void DilateRight(double[] src, int chan, int lmc, double[] res) {
        ArrayMM.Maximum(src, 0, src, chan, res, 0, lmc);
        System.arraycopy(src, lmc, res, lmc, chan);
    }

    private void DilateLeft(byte[] src, int chan, int lmc, byte[] res) {
        ArrayMM.MaximumUnsigned(src, chan, src, 0, res, chan, lmc);
        System.arraycopy(src, 0, res, 0, chan);
    }

    private void DilateLeft(short[] src, int chan, int lmc, short[] res) {
        ArrayMM.MaximumUnsigned(src, chan, src, 0, res, chan, lmc);
        System.arraycopy(src, 0, res, 0, chan);
    }

    private void DilateLeft(int[] src, int chan, int lmc, int[] res) {
        ArrayMM.Maximum(src, chan, src, 0, res, chan, lmc);
        System.arraycopy(src, 0, res, 0, chan);
    }

    private void DilateLeft(float[] src, int chan, int lmc, float[] res) {
        ArrayMM.Maximum(src, chan, src, 0, res, chan, lmc);
        System.arraycopy(src, 0, res, 0, chan);
    }

    private void DilateLeft(double[] src, int chan, int lmc, double[] res) {
        ArrayMM.Maximum(src, chan, src, 0, res, chan, lmc);
        System.arraycopy(src, 0, res, 0, chan);
    }

    private void Filter(byte[] in, int width, int height, int channel, int sewidth, byte[] out) {
        byte[] tmp = this.allocator.newByteArray(in.length);
        System.arraycopy(in, 0, tmp, 0, tmp.length);
        for (int i = 0; i < sewidth - 1; ++i) {
            this.Filter(tmp, width, height, channel, out);
            System.arraycopy(out, 0, tmp, 0, tmp.length);
        }
        this.Filter(tmp, width, height, channel, out);
        tmp = this.allocator.Release(tmp);
    }

    private void Filter(byte[] in, int width, int height, int channel, byte[] out) {
        int pos = 0;
        int wc = width * channel;
        int wc1 = wc - channel;
        byte[] lineIn = new byte[wc];
        byte[] lineOut = new byte[wc];
        byte[] lineTmp1 = new byte[wc];
        byte[] lineTmp2 = new byte[wc];
        byte[] lineTmp3 = new byte[wc];
        byte[] lineTmp4 = new byte[wc];
        System.arraycopy(in, pos, lineIn, 0, width);
        this.DilateLeft(lineIn, channel, wc1, lineTmp1);
        this.DilateRight(lineTmp1, channel, wc1, lineTmp4);
        pos = wc;
        System.arraycopy(in, pos, lineIn, 0, wc);
        this.DilateRight(lineIn, channel, wc1, lineTmp2);
        ArrayMM.MaximumUnsigned(lineTmp4, 0, lineTmp2, 0, out, 0, wc);
        int i = 2;
        pos = wc << 1;
        while (i < height) {
            System.arraycopy(in, pos, lineIn, 0, wc);
            if (Maths.ModuloDyadic(i, 2) == 0) {
                this.DilateLeft(lineIn, channel, wc1, lineTmp3);
                this.DilateLeft(lineTmp2, channel, wc1, lineTmp4);
            } else {
                this.DilateRight(lineIn, channel, wc1, lineTmp3);
                this.DilateRight(lineTmp2, channel, wc1, lineTmp4);
            }
            ArrayMM.MaximumUnsigned(lineTmp1, lineTmp3, lineOut);
            ArrayMM.MaximumUnsigned(lineTmp4, 0, lineOut, 0, out, pos - wc, wc);
            byte[] lineTmp = lineTmp1;
            lineTmp1 = lineTmp2;
            lineTmp2 = lineTmp3;
            lineTmp3 = lineTmp;
            ++i;
            pos += wc;
        }
        if (Maths.ModuloDyadic(i, 2) == 0) {
            this.DilateLeft(lineTmp2, channel, wc1, lineTmp4);
        } else {
            this.DilateRight(lineTmp2, channel, wc1, lineTmp4);
        }
        ArrayMM.MaximumUnsigned(lineTmp4, 0, lineTmp1, 0, out, pos - wc, wc);
        lineTmp4 = null;
        lineTmp3 = null;
        lineTmp2 = null;
        lineTmp1 = null;
        lineOut = null;
        lineIn = null;
    }

    private void Filter(short[] in, int width, int height, int channel, int sewidth, short[] out) {
        short[] tmp = this.allocator.newShortArray(in.length);
        System.arraycopy(in, 0, tmp, 0, tmp.length);
        for (int i = 0; i < sewidth - 1; ++i) {
            this.Filter(tmp, width, height, channel, out);
            System.arraycopy(out, 0, tmp, 0, tmp.length);
        }
        this.Filter(tmp, width, height, channel, out);
        tmp = this.allocator.Release(tmp);
    }

    private void Filter(short[] in, int width, int height, int channel, short[] out) {
        int pos = 0;
        int wc = width * channel;
        int wc1 = wc - channel;
        short[] lineIn = new short[wc];
        short[] lineOut = new short[wc];
        short[] lineTmp1 = new short[wc];
        short[] lineTmp2 = new short[wc];
        short[] lineTmp3 = new short[wc];
        short[] lineTmp4 = new short[wc];
        System.arraycopy(in, pos, lineIn, 0, width);
        this.DilateLeft(lineIn, channel, wc1, lineTmp1);
        this.DilateRight(lineTmp1, channel, wc1, lineTmp4);
        pos = wc;
        System.arraycopy(in, pos, lineIn, 0, wc);
        this.DilateRight(lineIn, channel, wc1, lineTmp2);
        ArrayMM.MaximumUnsigned(lineTmp4, 0, lineTmp2, 0, out, 0, wc);
        int i = 2;
        pos = wc << 1;
        while (i < height) {
            System.arraycopy(in, pos, lineIn, 0, wc);
            if (Maths.ModuloDyadic(i, 2) == 0) {
                this.DilateLeft(lineIn, channel, wc1, lineTmp3);
                this.DilateLeft(lineTmp2, channel, wc1, lineTmp4);
            } else {
                this.DilateRight(lineIn, channel, wc1, lineTmp3);
                this.DilateRight(lineTmp2, channel, wc1, lineTmp4);
            }
            ArrayMM.MaximumUnsigned(lineTmp1, lineTmp3, lineOut);
            ArrayMM.MaximumUnsigned(lineTmp4, 0, lineOut, 0, out, pos - wc, wc);
            short[] lineTmp = lineTmp1;
            lineTmp1 = lineTmp2;
            lineTmp2 = lineTmp3;
            lineTmp3 = lineTmp;
            ++i;
            pos += wc;
        }
        if (Maths.ModuloDyadic(i, 2) == 0) {
            this.DilateLeft(lineTmp2, channel, wc1, lineTmp4);
        } else {
            this.DilateRight(lineTmp2, channel, wc1, lineTmp4);
        }
        ArrayMM.MaximumUnsigned(lineTmp4, 0, lineTmp1, 0, out, pos - wc, wc);
        lineTmp4 = null;
        lineTmp3 = null;
        lineTmp2 = null;
        lineTmp1 = null;
        lineOut = null;
        lineIn = null;
    }

    private void Filter(int[] in, int width, int height, int channel, int sewidth, int[] out) {
        int[] tmp = this.allocator.newIntArray(in.length);
        System.arraycopy(in, 0, tmp, 0, tmp.length);
        for (int i = 0; i < sewidth - 1; ++i) {
            this.Filter(tmp, width, height, channel, out);
            System.arraycopy(out, 0, tmp, 0, tmp.length);
        }
        this.Filter(tmp, width, height, channel, out);
        tmp = this.allocator.Release(tmp);
    }

    private void Filter(int[] in, int width, int height, int channel, int[] out) {
        int pos = 0;
        int wc = width * channel;
        int wc1 = wc - channel;
        int[] lineIn = new int[wc];
        int[] lineOut = new int[wc];
        int[] lineTmp1 = new int[wc];
        int[] lineTmp2 = new int[wc];
        int[] lineTmp3 = new int[wc];
        int[] lineTmp4 = new int[wc];
        System.arraycopy(in, pos, lineIn, 0, width);
        this.DilateLeft(lineIn, channel, wc1, lineTmp1);
        this.DilateRight(lineTmp1, channel, wc1, lineTmp4);
        pos = wc;
        System.arraycopy(in, pos, lineIn, 0, wc);
        this.DilateRight(lineIn, channel, wc1, lineTmp2);
        ArrayMM.Maximum(lineTmp4, 0, lineTmp2, 0, out, 0, wc);
        int i = 2;
        pos = wc << 1;
        while (i < height) {
            System.arraycopy(in, pos, lineIn, 0, wc);
            if (Maths.ModuloDyadic(i, 2) == 0) {
                this.DilateLeft(lineIn, channel, wc1, lineTmp3);
                this.DilateLeft(lineTmp2, channel, wc1, lineTmp4);
            } else {
                this.DilateRight(lineIn, channel, wc1, lineTmp3);
                this.DilateRight(lineTmp2, channel, wc1, lineTmp4);
            }
            ArrayMM.Maximum(lineTmp1, lineTmp3, lineOut);
            ArrayMM.Maximum(lineTmp4, 0, lineOut, 0, out, pos - wc, wc);
            int[] lineTmp = lineTmp1;
            lineTmp1 = lineTmp2;
            lineTmp2 = lineTmp3;
            lineTmp3 = lineTmp;
            ++i;
            pos += wc;
        }
        if (Maths.ModuloDyadic(i, 2) == 0) {
            this.DilateLeft(lineTmp2, channel, wc1, lineTmp4);
        } else {
            this.DilateRight(lineTmp2, channel, wc1, lineTmp4);
        }
        ArrayMM.Maximum(lineTmp4, 0, lineTmp1, 0, out, pos - wc, wc);
        lineTmp4 = null;
        lineTmp3 = null;
        lineTmp2 = null;
        lineTmp1 = null;
        lineOut = null;
        lineIn = null;
    }

    private void Filter(float[] in, int width, int height, int channel, int sewidth, float[] out) {
        float[] tmp = this.allocator.newFloatArray(in.length);
        System.arraycopy(in, 0, tmp, 0, tmp.length);
        for (int i = 0; i < sewidth - 1; ++i) {
            this.Filter(tmp, width, height, channel, out);
            System.arraycopy(out, 0, tmp, 0, tmp.length);
        }
        this.Filter(tmp, width, height, channel, out);
        tmp = this.allocator.Release(tmp);
    }

    private void Filter(float[] in, int width, int height, int channel, float[] out) {
        int pos = 0;
        int wc = width * channel;
        int wc1 = wc - channel;
        float[] lineIn = new float[wc];
        float[] lineOut = new float[wc];
        float[] lineTmp1 = new float[wc];
        float[] lineTmp2 = new float[wc];
        float[] lineTmp3 = new float[wc];
        float[] lineTmp4 = new float[wc];
        System.arraycopy(in, pos, lineIn, 0, width);
        this.DilateLeft(lineIn, channel, wc1, lineTmp1);
        this.DilateRight(lineTmp1, channel, wc1, lineTmp4);
        pos = wc;
        System.arraycopy(in, pos, lineIn, 0, wc);
        this.DilateRight(lineIn, channel, wc1, lineTmp2);
        ArrayMM.Maximum(lineTmp4, 0, lineTmp2, 0, out, 0, wc);
        int i = 2;
        pos = wc << 1;
        while (i < height) {
            System.arraycopy(in, pos, lineIn, 0, wc);
            if (Maths.ModuloDyadic(i, 2) == 0) {
                this.DilateLeft(lineIn, channel, wc1, lineTmp3);
                this.DilateLeft(lineTmp2, channel, wc1, lineTmp4);
            } else {
                this.DilateRight(lineIn, channel, wc1, lineTmp3);
                this.DilateRight(lineTmp2, channel, wc1, lineTmp4);
            }
            ArrayMM.Maximum(lineTmp1, lineTmp3, lineOut);
            ArrayMM.Maximum(lineTmp4, 0, lineOut, 0, out, pos - wc, wc);
            float[] lineTmp = lineTmp1;
            lineTmp1 = lineTmp2;
            lineTmp2 = lineTmp3;
            lineTmp3 = lineTmp;
            ++i;
            pos += wc;
        }
        if (Maths.ModuloDyadic(i, 2) == 0) {
            this.DilateLeft(lineTmp2, channel, wc1, lineTmp4);
        } else {
            this.DilateRight(lineTmp2, channel, wc1, lineTmp4);
        }
        ArrayMM.Maximum(lineTmp4, 0, lineTmp1, 0, out, pos - wc, wc);
        lineTmp4 = null;
        lineTmp3 = null;
        lineTmp2 = null;
        lineTmp1 = null;
        lineOut = null;
        lineIn = null;
    }

    private void Filter(double[] in, int width, int height, int channel, int sewidth, double[] out) {
        double[] tmp = this.allocator.newDoubleArray(in.length);
        System.arraycopy(in, 0, tmp, 0, tmp.length);
        for (int i = 0; i < sewidth - 1; ++i) {
            this.Filter(tmp, width, height, channel, out);
            System.arraycopy(out, 0, tmp, 0, tmp.length);
        }
        this.Filter(tmp, width, height, channel, out);
        tmp = this.allocator.Release(tmp);
    }

    private void Filter(double[] in, int width, int height, int channel, double[] out) {
        int pos = 0;
        int wc = width * channel;
        int wc1 = wc - channel;
        double[] lineIn = new double[wc];
        double[] lineOut = new double[wc];
        double[] lineTmp1 = new double[wc];
        double[] lineTmp2 = new double[wc];
        double[] lineTmp3 = new double[wc];
        double[] lineTmp4 = new double[wc];
        System.arraycopy(in, pos, lineIn, 0, width);
        this.DilateLeft(lineIn, channel, wc1, lineTmp1);
        this.DilateRight(lineTmp1, channel, wc1, lineTmp4);
        pos = wc;
        System.arraycopy(in, pos, lineIn, 0, wc);
        this.DilateRight(lineIn, channel, wc1, lineTmp2);
        ArrayMM.Maximum(lineTmp4, 0, lineTmp2, 0, out, 0, wc);
        int i = 2;
        pos = wc << 1;
        while (i < height) {
            System.arraycopy(in, pos, lineIn, 0, wc);
            if (Maths.ModuloDyadic(i, 2) == 0) {
                this.DilateLeft(lineIn, channel, wc1, lineTmp3);
                this.DilateLeft(lineTmp2, channel, wc1, lineTmp4);
            } else {
                this.DilateRight(lineIn, channel, wc1, lineTmp3);
                this.DilateRight(lineTmp2, channel, wc1, lineTmp4);
            }
            ArrayMM.Maximum(lineTmp1, lineTmp3, lineOut);
            ArrayMM.Maximum(lineTmp4, 0, lineOut, 0, out, pos - wc, wc);
            double[] lineTmp = lineTmp1;
            lineTmp1 = lineTmp2;
            lineTmp2 = lineTmp3;
            lineTmp3 = lineTmp;
            ++i;
            pos += wc;
        }
        if (Maths.ModuloDyadic(i, 2) == 0) {
            this.DilateLeft(lineTmp2, channel, wc1, lineTmp4);
        } else {
            this.DilateRight(lineTmp2, channel, wc1, lineTmp4);
        }
        ArrayMM.Maximum(lineTmp4, 0, lineTmp1, 0, out, pos - wc, wc);
        lineTmp4 = null;
        lineTmp3 = null;
        lineTmp2 = null;
        lineTmp1 = null;
        lineOut = null;
        lineIn = null;
    }
}

