/*
 * Decompiled with CFR 0.152.
 */
package morphee;

import arrayTiTi.ArrayFeatures;
import arrayTiTi.ArrayOperations;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import mathematics.metrics.Euclidian;
import mathematics.primitives.pointsTiTi.CoordinatesWeighted;

public class StructuringElement3D {
    protected final double Epsilon = 1.0E-4;
    public static final int CUBE = -1;
    public static final int SPHERE = -2;
    public static final int SEGMENTX = -3;
    public static final int SEGMENTY = -4;
    public static final int SEGMENTZ = -5;
    public static final int CUSTOMIZED = -7;
    public static final int EMPTY = -12;
    public static final int LBP = -13;
    public static final int MONTANARI = -15;
    private int Order = 0;
    private int Type = 0;
    private int Size = 0;
    private int SizeX = 0;
    private int SizeY = 0;
    private int SizeZ = 0;
    private double SumOfWeights = 0.0;
    private boolean[][][] data = null;
    private int[][][] dataint = null;
    private double[][][] datadouble = null;
    private List<CoordinatesWeighted> list = new ArrayList<CoordinatesWeighted>(113);
    private CoordinatesWeighted[] se = null;
    private boolean Iterable = false;
    private boolean IntWeights = false;
    private boolean Heavy = false;
    private CoordinatesWeighted[] forward = null;
    private CoordinatesWeighted[] backward = null;
    private int Width = -1;
    private int Height = -1;
    private boolean Flat = true;
    private boolean useFastestAlgorithmOC = false;

    public StructuringElement3D(Object ... parameters) {
        if (parameters.length != 2 && parameters.length != 3) {
            throw new IllegalArgumentException("2 or 3 parameters required.");
        }
        this.setOrder((Integer)parameters[0]);
        switch ((Integer)parameters[1]) {
            case -2: {
                this.MakeSphere();
                break;
            }
            case -12: {
                this.Type = -12;
                this.Iterable = false;
                break;
            }
            case -1: {
                this.MakeCube();
                break;
            }
            case -5: 
            case -4: 
            case -3: {
                this.MakeSegment((Integer)parameters[1]);
                break;
            }
            case -13: {
                if (parameters.length != 3) {
                    throw new IllegalArgumentException("Exactly 3 parameters required (int Order/Radius, int Type, int nbPoints).");
                }
                this.MakeLBP((Integer)parameters[2]);
                break;
            }
            case -15: {
                if (parameters.length != 2) {
                    throw new IllegalArgumentException("Exactly 2 parameters required (int Order, int Type).");
                }
                this.MakeMontanari();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type: " + this.Type);
            }
        }
    }

    public StructuringElement3D(int[][][] Mask) {
        this.Iterable = false;
        this.Type = -7;
        this.data = new boolean[Mask.length][Mask[0].length][Mask[0][0].length];
        for (int z = 0; z < Mask.length; ++z) {
            for (int y = 0; y < Mask[0].length; ++y) {
                for (int x = 0; x < Mask[0][0].length; ++x) {
                    this.data[z][y][x] = 0 != Mask[z][y][x];
                }
            }
        }
        this.BuildList(Mask);
    }

    public StructuringElement3D(double[][][] Mask) {
        this.Iterable = false;
        this.Type = -7;
        this.data = new boolean[Mask.length][Mask[0].length][Mask[0][0].length];
        for (int z = 0; z < Mask.length; ++z) {
            for (int y = 0; y < Mask[0].length; ++y) {
                for (int x = 0; x < Mask[0][0].length; ++x) {
                    this.data[z][y][x] = !(Math.abs(Mask[z][y][x]) < 1.0E-4);
                }
            }
        }
        this.BuildList(Mask);
    }

    public StructuringElement3D(boolean[][][] Mask) {
        this.Iterable = false;
        this.Size = Math.max(Math.max(Mask.length, Mask[0].length), Mask[0][0].length);
        this.Order = this.Size >> 1;
        this.Type = -7;
        this.data = Mask;
        this.BuildList();
    }

    public void Kill() {
        this.data = null;
        this.datadouble = null;
        if (this.list != null) {
            this.list.clear();
        }
        this.list = null;
        if (this.se != null) {
            Arrays.fill(this.se, null);
        }
        this.se = null;
        if (this.forward != null) {
            Arrays.fill(this.forward, null);
        }
        this.forward = null;
        if (this.backward != null) {
            Arrays.fill(this.backward, null);
        }
        this.backward = null;
    }

    private void setOrder(int Order) {
        if (Order <= 0) {
            throw new IllegalArgumentException("Order <= 0");
        }
        this.Order = Order;
        this.Size = (Order << 1) + 1;
        if (this.Type == -12) {
            return;
        }
        this.data = new boolean[this.Size][this.Size][this.Size];
        ArrayOperations.Fill(this.data, false);
    }

    private void MakeCube() {
        if (this.data == null) {
            throw new NullPointerException("Set dimensions before construction.");
        }
        ArrayOperations.Fill(this.data, true);
        this.Type = -1;
        this.Iterable = true;
        this.BuildList();
    }

    private void MakeSphere() {
        if (this.data == null) {
            throw new NullPointerException("Set dimensions before construction.");
        }
        Euclidian distances = new Euclidian();
        for (int z = 0; z < this.Size; ++z) {
            for (int y = 0; y < this.Size; ++y) {
                for (int x = 0; x < this.Size; ++x) {
                    this.data[z][y][x] = distances.Distance(x, y, z, this.Order, this.Order, this.Order) < (double)this.Order + 1.0E-4;
                }
            }
        }
        distances = null;
        this.Iterable = false;
        this.Type = -2;
        this.BuildList();
    }

    private void MakeSegment(int orientation) {
        if (this.data == null) {
            throw new NullPointerException("Set dimensions before construction.");
        }
        switch (orientation) {
            case -3: {
                Arrays.fill(this.data[this.Order][this.Order], 0, this.Size, true);
                break;
            }
            case -4: {
                for (int y = 0; y < this.Size; ++y) {
                    this.data[this.Order][y][this.Order] = true;
                }
                break;
            }
            case -5: {
                for (int z = 0; z < this.Size; ++z) {
                    this.data[z][this.Order][this.Order] = true;
                }
                break;
            }
        }
        this.Iterable = true;
        this.Type = orientation;
        this.BuildList();
    }

    private void MakeLBP(int nbPoints) {
        this.data = null;
        this.se = new CoordinatesWeighted[nbPoints];
        this.Iterable = false;
        this.Type = -13;
        this.IntWeights = true;
    }

    private void MakeMontanari() {
        int i;
        int x;
        int y;
        int z;
        int Radius = this.Order + 1;
        boolean[][][] visible = new boolean[Radius][Radius][Radius];
        Euclidian distances = new Euclidian();
        for (z = 0; z < Radius; ++z) {
            for (y = 0; y < Radius; ++y) {
                for (x = 0; x < Radius; ++x) {
                    visible[z][y][x] = distances.Distance(0.0, 0.0, 0.0, x, y, z) <= (double)Radius + 1.0E-4;
                }
            }
        }
        visible[0][0][0] = false;
        for (z = 0; z < Radius; ++z) {
            for (y = 0; y < Radius; ++y) {
                for (x = 0; x < Radius; ++x) {
                    if (!visible[z][y][x]) continue;
                    int i2 = 2;
                    while (i2 * z < Radius && i2 * y < Radius && i2 * x < Radius) {
                        visible[i2 * z][i2 * y][i2 * x] = false;
                        ++i2;
                    }
                }
            }
        }
        for (z = 0; z < Radius; ++z) {
            for (y = 0; y < Radius; ++y) {
                for (x = 0; x < Radius; ++x) {
                    if (!visible[z][y][x]) continue;
                    this.list.add(new CoordinatesWeighted(x, y, z, -1, distances.Distance(0.0, 0.0, 0.0, x, y, z)));
                }
            }
        }
        visible = null;
        CoordinatesWeighted c = null;
        int nb = this.list.size();
        for (i = 0; i < nb; ++i) {
            c = this.list.get(i);
            if (0 < c.X) {
                this.list.add(new CoordinatesWeighted(-c.X, c.Y, c.Z, -1, c.Wd));
            }
            c = null;
        }
        nb = this.list.size();
        for (i = 0; i < nb; ++i) {
            c = this.list.get(i);
            if (0 < c.Y) {
                this.list.add(new CoordinatesWeighted(c.X, -c.Y, c.Z, -1, c.Wd));
            }
            c = null;
        }
        nb = this.list.size();
        for (i = 0; i < nb; ++i) {
            c = this.list.get(i);
            if (0 < c.Z) {
                this.list.add(new CoordinatesWeighted(c.X, c.Y, -c.Z, -1, c.Wd));
            }
            c = null;
        }
        this.se = new CoordinatesWeighted[this.list.size()];
        for (i = 0; i < this.se.length; ++i) {
            this.se[i] = this.list.get(i);
        }
        this.Iterable = false;
        this.Type = -15;
        this.IntWeights = false;
        this.BuildListChamfer();
    }

    private void BuildList() {
        int x;
        int y;
        int z;
        int datalength2 = this.data.length >> 1;
        int data0length2 = this.data[0].length >> 1;
        int data00length2 = this.data[0][0].length >> 1;
        int width = this.data[0][0].length;
        int height = this.data[0].length;
        int depth = this.data.length;
        ArrayFeatures af = new ArrayFeatures();
        this.SumOfWeights = af.Integral(this.data);
        af = null;
        for (z = 0; z < depth; ++z) {
            for (y = 0; y < height; ++y) {
                for (x = 0; x < width; ++x) {
                    if (!this.data[z][y][x]) continue;
                    this.list.add(new CoordinatesWeighted(x - data00length2, y - data0length2, z - datalength2, -1, 1));
                }
            }
        }
        this.SizeZ = 0;
        this.SizeY = 0;
        this.SizeX = 0;
        this.se = new CoordinatesWeighted[this.list.size()];
        for (int i = 0; i < this.se.length; ++i) {
            CoordinatesWeighted cw = this.list.get(i);
            if (this.SizeX < Math.abs(cw.X)) {
                this.SizeX = Math.abs(cw.X);
            }
            if (this.SizeY < Math.abs(cw.Y)) {
                this.SizeY = Math.abs(cw.Y);
            }
            if (this.SizeZ < Math.abs(cw.Z)) {
                this.SizeZ = Math.abs(cw.Z);
            }
            this.se[i] = cw;
        }
        this.SizeX = 2 * this.SizeX + 1;
        this.SizeY = 2 * this.SizeY + 1;
        this.SizeZ = 2 * this.SizeZ + 1;
        int nb = 0;
        for (z = 0; z < depth; ++z) {
            for (y = 0; y < height; ++y) {
                for (x = 0; x < width; ++x) {
                    if (!this.data[z][y][x]) continue;
                    if (x == width - 1) {
                        ++nb;
                        continue;
                    }
                    if (this.data[z][y][x + 1]) continue;
                    ++nb;
                }
            }
        }
        this.forward = new CoordinatesWeighted[nb];
        nb = 0;
        for (z = 0; z < depth; ++z) {
            for (y = 0; y < height; ++y) {
                for (x = 0; x < width; ++x) {
                    if (!this.data[z][y][x]) continue;
                    if (x == width - 1) {
                        this.forward[nb++] = new CoordinatesWeighted(x - data00length2, y - data0length2, z - datalength2, -1, 1);
                        continue;
                    }
                    if (this.data[z][y][x + 1]) continue;
                    this.forward[nb++] = new CoordinatesWeighted(x - data00length2, y - data0length2, z - datalength2, -1, 1);
                }
            }
        }
        nb = 0;
        for (z = 0; z < depth; ++z) {
            for (y = 0; y < height; ++y) {
                for (x = 0; x < width; ++x) {
                    if (!this.data[z][y][x]) continue;
                    if (x == 0) {
                        ++nb;
                        continue;
                    }
                    if (this.data[z][y][x - 1]) continue;
                    ++nb;
                }
            }
        }
        this.backward = new CoordinatesWeighted[nb];
        nb = 0;
        for (z = 0; z < depth; ++z) {
            for (y = 0; y < height; ++y) {
                for (x = 0; x < width; ++x) {
                    if (!this.data[z][y][x]) continue;
                    if (x == 0) {
                        this.backward[nb++] = new CoordinatesWeighted(x - data00length2 - 1, y - data0length2, z - datalength2, -1, 1);
                        continue;
                    }
                    if (this.data[z][y][x - 1]) continue;
                    this.backward[nb++] = new CoordinatesWeighted(x - data00length2 - 1, y - data0length2, z - datalength2, -1, 1);
                }
            }
        }
        boolean bl = this.Heavy = this.se.length > this.forward.length + this.backward.length + 1;
        if (this.backward.length != this.forward.length) {
            throw new IllegalArgumentException("The structuring element is not symetric. Number of pixel in forward different of backward.");
        }
        this.IntWeights = true;
        this.CheckIfFlat();
        this.data = null;
    }

    private void BuildList(int[][][] weights) {
        int x;
        int y;
        int z;
        int datalength2 = this.data.length >> 1;
        int data0length2 = this.data[0].length >> 1;
        int data00length2 = this.data[0][0].length >> 1;
        int width = this.data[0][0].length;
        int height = this.data[0].length;
        int depth = this.data.length;
        ArrayFeatures af = new ArrayFeatures();
        this.SumOfWeights = af.Integral(weights);
        af = null;
        for (z = 0; z < depth; ++z) {
            for (y = 0; y < height; ++y) {
                for (x = 0; x < width; ++x) {
                    if (!this.data[z][y][x]) continue;
                    this.list.add(new CoordinatesWeighted(x - data00length2, y - data0length2, z - datalength2, -1, weights[z][y][x]));
                }
            }
        }
        this.SizeZ = 0;
        this.SizeY = 0;
        this.SizeX = 0;
        this.se = new CoordinatesWeighted[this.list.size()];
        for (int i = 0; i < this.se.length; ++i) {
            CoordinatesWeighted cw = this.list.get(i);
            if (this.SizeX < Math.abs(cw.X)) {
                this.SizeX = Math.abs(cw.X);
            }
            if (this.SizeY < Math.abs(cw.Y)) {
                this.SizeY = Math.abs(cw.Y);
            }
            if (this.SizeZ < Math.abs(cw.Z)) {
                this.SizeZ = Math.abs(cw.Z);
            }
            this.se[i] = cw;
        }
        this.SizeX = (this.SizeX << 1) + 1;
        this.SizeY = (this.SizeY << 1) + 1;
        this.SizeZ = (this.SizeZ << 1) + 1;
        this.Size = Math.max(Math.max(this.SizeX, this.SizeY), this.SizeZ);
        this.Order = this.Size >> 1;
        int nb = 0;
        for (z = 0; z < depth; ++z) {
            for (y = 0; y < height; ++y) {
                for (x = 0; x < width; ++x) {
                    if (!this.data[z][y][x]) continue;
                    if (x == width - 1) {
                        ++nb;
                        continue;
                    }
                    if (this.data[z][y][x + 1]) continue;
                    ++nb;
                }
            }
        }
        this.forward = new CoordinatesWeighted[nb];
        nb = 0;
        for (z = 0; z < depth; ++z) {
            for (y = 0; y < height; ++y) {
                for (x = 0; x < width; ++x) {
                    if (!this.data[z][y][x]) continue;
                    if (x == width - 1) {
                        this.forward[nb++] = new CoordinatesWeighted(x - data00length2, y - data0length2, z - datalength2, -1, weights[z][y][x]);
                        continue;
                    }
                    if (this.data[z][y][x + 1]) continue;
                    this.forward[nb++] = new CoordinatesWeighted(x - data00length2, y - data0length2, z - datalength2, -1, weights[z][y][x]);
                }
            }
        }
        nb = 0;
        for (z = 0; z < depth; ++z) {
            for (y = 0; y < height; ++y) {
                for (x = 0; x < width; ++x) {
                    if (!this.data[z][y][x]) continue;
                    if (x == 0) {
                        ++nb;
                        continue;
                    }
                    if (this.data[z][y][x - 1]) continue;
                    ++nb;
                }
            }
        }
        this.backward = new CoordinatesWeighted[nb];
        nb = 0;
        for (z = 0; z < depth; ++z) {
            for (y = 0; y < height; ++y) {
                for (x = 0; x < width; ++x) {
                    if (!this.data[z][y][x]) continue;
                    if (x == 0) {
                        this.backward[nb++] = new CoordinatesWeighted(x - data00length2 - 1, y - data0length2, z - datalength2, -1, weights[z][y][x]);
                        continue;
                    }
                    if (this.data[z][y][x - 1]) continue;
                    this.backward[nb++] = new CoordinatesWeighted(x - data00length2 - 1, y - data0length2, z - datalength2, -1, weights[z][y][x]);
                }
            }
        }
        boolean bl = this.Heavy = this.se.length > this.forward.length + this.backward.length + 1;
        if (this.backward.length != this.forward.length) {
            throw new IllegalArgumentException("The structuring element is not symetric. Number of pixel in forward different of backward.");
        }
        this.IntWeights = true;
        this.CheckIfFlat();
        this.data = null;
    }

    private void BuildList(double[][][] weights) {
        int x;
        int y;
        int z;
        int datalength2 = this.data.length >> 1;
        int data0length2 = this.data[0].length >> 1;
        int data00length2 = this.data[0][0].length >> 1;
        int width = this.data[0][0].length;
        int height = this.data[0].length;
        int depth = this.data.length;
        ArrayFeatures af = new ArrayFeatures();
        this.SumOfWeights = af.Integral(weights);
        af = null;
        for (z = 0; z < depth; ++z) {
            for (y = 0; y < height; ++y) {
                for (x = 0; x < width; ++x) {
                    if (!this.data[z][y][x]) continue;
                    this.list.add(new CoordinatesWeighted(x - data00length2, y - data0length2, z - datalength2, -1, weights[z][y][x]));
                }
            }
        }
        this.SizeZ = 0;
        this.SizeY = 0;
        this.SizeX = 0;
        this.se = new CoordinatesWeighted[this.list.size()];
        for (int i = 0; i < this.se.length; ++i) {
            CoordinatesWeighted cw = this.list.get(i);
            if (this.SizeX < Math.abs(cw.X)) {
                this.SizeX = Math.abs(cw.X);
            }
            if (this.SizeY < Math.abs(cw.Y)) {
                this.SizeY = Math.abs(cw.Y);
            }
            if (this.SizeZ < Math.abs(cw.Z)) {
                this.SizeZ = Math.abs(cw.Z);
            }
            this.se[i] = cw;
        }
        this.SizeX = (this.SizeX << 1) + 1;
        this.SizeY = (this.SizeY << 1) + 1;
        this.SizeZ = (this.SizeZ << 1) + 1;
        this.Size = Math.max(Math.max(this.SizeX, this.SizeY), this.SizeZ);
        this.Order = this.Size >> 1;
        int nb = 0;
        for (z = 0; z < depth; ++z) {
            for (y = 0; y < height; ++y) {
                for (x = 0; x < width; ++x) {
                    if (!this.data[z][y][x]) continue;
                    if (x == width - 1) {
                        ++nb;
                        continue;
                    }
                    if (this.data[z][y][x + 1]) continue;
                    ++nb;
                }
            }
        }
        this.forward = new CoordinatesWeighted[nb];
        nb = 0;
        for (z = 0; z < depth; ++z) {
            for (y = 0; y < height; ++y) {
                for (x = 0; x < width; ++x) {
                    if (!this.data[z][y][x]) continue;
                    if (x == width - 1) {
                        this.forward[nb++] = new CoordinatesWeighted(x - data00length2, y - data0length2, z - datalength2, -1, weights[z][y][x]);
                        continue;
                    }
                    if (this.data[z][y][x + 1]) continue;
                    this.forward[nb++] = new CoordinatesWeighted(x - data00length2, y - data0length2, z - datalength2, -1, weights[z][y][x]);
                }
            }
        }
        nb = 0;
        for (z = 0; z < depth; ++z) {
            for (y = 0; y < height; ++y) {
                for (x = 0; x < width; ++x) {
                    if (!this.data[z][y][x]) continue;
                    if (x == 0) {
                        ++nb;
                        continue;
                    }
                    if (this.data[z][y][x - 1]) continue;
                    ++nb;
                }
            }
        }
        this.backward = new CoordinatesWeighted[nb];
        nb = 0;
        for (z = 0; z < depth; ++z) {
            for (y = 0; y < height; ++y) {
                for (x = 0; x < width; ++x) {
                    if (!this.data[z][y][x]) continue;
                    if (x == 0) {
                        this.backward[nb++] = new CoordinatesWeighted(x - data00length2 - 1, y - data0length2, z - datalength2, -1, weights[z][y][x]);
                        continue;
                    }
                    if (this.data[z][y][x - 1]) continue;
                    this.backward[nb++] = new CoordinatesWeighted(x - data00length2 - 1, y - data0length2, z - datalength2, -1, weights[z][y][x]);
                }
            }
        }
        boolean bl = this.Heavy = this.se.length > this.forward.length + this.backward.length + 1;
        if (this.backward.length != this.forward.length) {
            throw new IllegalArgumentException("The structuring element is not symetric. Number of pixel in forward different of backward.");
        }
        this.IntWeights = false;
        this.CheckIfFlat();
        this.data = null;
    }

    private void BuildListLBP() {
        ArrayFeatures af = new ArrayFeatures();
        this.SumOfWeights = af.Integral(this.data);
        af = null;
        this.se = new CoordinatesWeighted[6];
        int nb = 0;
        CoordinatesWeighted cw = new CoordinatesWeighted(0, 0, this.Order, -1, 1);
        this.list.add(cw);
        this.se[nb++] = cw;
        cw = new CoordinatesWeighted(this.Order, 0, 0, -1, 1);
        this.list.add(cw);
        this.se[nb++] = cw;
        cw = new CoordinatesWeighted(0, this.Order, 0, -1, 1);
        this.list.add(cw);
        this.se[nb++] = cw;
        cw = new CoordinatesWeighted(-this.Order, 0, 0, -1, 1);
        this.list.add(cw);
        this.se[nb++] = cw;
        cw = new CoordinatesWeighted(0, -this.Order, 0, -1, 1);
        this.list.add(cw);
        this.se[nb++] = cw;
        cw = new CoordinatesWeighted(0, 0, -this.Order, -1, 1);
        this.list.add(cw);
        this.se[nb++] = cw;
        this.SizeY = this.SizeZ = (this.Order << 1) + 1;
        this.SizeX = this.SizeZ;
        this.Heavy = false;
        this.CheckIfFlat();
        this.data = null;
        this.IntWeights = true;
    }

    private void BuildListChamfer() {
        int i;
        CoordinatesWeighted c = null;
        int nb = 0;
        for (i = 0; i < this.se.length; ++i) {
            c = this.se[i];
            if (0 <= c.Z) {
                ++nb;
            }
            c = null;
        }
        this.forward = new CoordinatesWeighted[nb];
        this.backward = new CoordinatesWeighted[nb];
        int pf = 0;
        int pb = 0;
        for (i = 0; i < this.se.length; ++i) {
            c = this.se[i];
            if (0 == c.Z) {
                this.backward[pb++] = this.se[i];
                this.forward[pf++] = this.se[i];
            } else if (0 < c.Z) {
                this.backward[pb++] = this.se[i];
            } else {
                this.forward[pf++] = this.se[i];
            }
            c = null;
        }
        this.IntWeights = true;
    }

    public void setLinearWeigths(int step) {
        int d;
        int i;
        int max = 0;
        Euclidian metric = new Euclidian();
        CoordinatesWeighted c = null;
        for (i = 0; i < this.se.length; ++i) {
            c = this.se[i];
            d = (int)(metric.Distance(c.X, c.Y, c.Z, 0.0, 0.0, 0.0) + 0.5) + 1;
            if (max < d) {
                max = d;
            }
            c = null;
        }
        this.SumOfWeights = 0.0;
        int MAX = max * step + 1;
        for (i = 0; i < this.se.length; ++i) {
            c = this.se[i];
            d = (int)(metric.Distance(c.X, c.Y, c.Z, 0.0, 0.0, 0.0) + 0.5) + 1;
            c.Wi = MAX - step * d;
            this.SumOfWeights += (double)c.Wi;
            c = null;
        }
        metric = null;
        this.Flat = false;
    }

    public boolean CheckIfFlat() {
        double wd = this.se[0].Wd;
        int wi = this.se[0].Wi;
        for (int i = 1; i < this.se.length; ++i) {
            if (Double.compare(wd, this.se[i].Wd) == 0 && wi == this.se[i].Wi) continue;
            this.Flat = false;
            return this.Flat;
        }
        this.Flat = true;
        return this.Flat;
    }

    public void GenerateIntArray() {
        this.dataint = new int[this.SizeZ][this.SizeY][this.SizeX];
        int dx = this.SizeX >> 1;
        int dy = this.SizeY >> 1;
        int dz = this.SizeZ >> 1;
        for (CoordinatesWeighted cw : this.se) {
            this.dataint[dz + cw.Z][dy + cw.Y][dx + cw.X] = cw.Wi;
        }
        ArrayFeatures af = new ArrayFeatures();
        this.SumOfWeights = af.Integral(this.dataint);
        af = null;
    }

    public void GenerateDoubleArray() {
        this.datadouble = new double[this.SizeZ][this.SizeY][this.SizeX];
        int dx = this.SizeX >> 1;
        int dy = this.SizeY >> 1;
        int dz = this.SizeZ >> 1;
        for (CoordinatesWeighted cw : this.se) {
            this.datadouble[dz + cw.Z][dy + cw.Y][dx + cw.X] = cw.Wd;
        }
        ArrayFeatures af = new ArrayFeatures();
        this.SumOfWeights = af.Integral(this.datadouble);
        af = null;
    }

    public void PreComputePositions(int width, int height) {
        CoordinatesWeighted cw;
        int i;
        if (this.Width == width && this.Height == height) {
            return;
        }
        int layersize = width * height;
        for (i = 0; i < this.se.length; ++i) {
            cw = this.se[i];
            cw.Pos = cw.X + cw.Y * width + cw.Z * layersize;
            cw = null;
        }
        if (this.forward != null) {
            for (i = 0; i < this.forward.length; ++i) {
                cw = this.forward[i];
                cw.Pos = cw.X + cw.Y * width + cw.Z * layersize;
                cw = null;
            }
            for (i = 0; i < this.backward.length; ++i) {
                cw = this.backward[i];
                cw.Pos = cw.X + cw.Y * width + cw.Z * layersize;
                cw = null;
            }
        }
        this.Width = width;
        this.Height = height;
    }

    public int LastWidth() {
        return this.Width;
    }

    public int LastHeight() {
        return this.Height;
    }

    public void ComputeSumOfWeights() {
        this.SumOfWeights = 0.0;
        for (CoordinatesWeighted cw : this.se) {
            this.SumOfWeights += cw.Wd;
        }
    }

    public List<CoordinatesWeighted> getList() {
        return this.list;
    }

    public CoordinatesWeighted getCoordinates(int i) {
        return this.list.get(i);
    }

    public Iterator<CoordinatesWeighted> getListIterator() {
        return this.list.iterator();
    }

    public CoordinatesWeighted[] getSE() {
        return this.se;
    }

    public CoordinatesWeighted[] getForward() {
        return this.forward;
    }

    public CoordinatesWeighted[] getBackward() {
        return this.backward;
    }

    public int getOrder() {
        return this.Order;
    }

    public int getType() {
        return this.Type;
    }

    public int getSizeX() {
        return this.SizeX;
    }

    public int getSizeY() {
        return this.SizeY;
    }

    public int getSizeZ() {
        return this.SizeZ;
    }

    public int getSize() {
        return this.Size;
    }

    public double getSumOfWeights() {
        return this.SumOfWeights;
    }

    public boolean isIterable() {
        return this.Iterable;
    }

    public boolean isHeavy() {
        return this.Heavy;
    }

    public boolean isFlat() {
        return this.Flat;
    }

    public boolean hasIntWeights() {
        return this.IntWeights;
    }

    public void ForceNonIterable() {
        this.Iterable = false;
    }

    public void ForceNonHeavy() {
        this.Heavy = false;
    }

    public boolean useFastestAlgorithmOC() {
        return this.useFastestAlgorithmOC;
    }

    public void FastestAlgorithmOC(boolean use) {
        this.useFastestAlgorithmOC = use;
    }

    public int[][][] getWeightsInt() {
        if (this.dataint == null) {
            this.GenerateIntArray();
        }
        return this.dataint;
    }

    public double[][][] getWeightsDouble() {
        if (this.datadouble == null) {
            this.GenerateDoubleArray();
        }
        return this.datadouble;
    }

    public void appendTo(Appendable out) throws IOException {
        out.append(this.Order + " ");
        switch (this.Type) {
            case -1: {
                out.append("SQUARE");
                break;
            }
            case -7: {
                out.append("CUSTOMIZED");
                break;
            }
            case -12: {
                out.append("EMPTY");
                break;
            }
            case -13: {
                out.append("LBP");
                break;
            }
            case -2: {
                out.append("SPHERE");
                break;
            }
            default: {
                throw new IllegalArgumentException("Default, type not supported: " + this.Type + ". Must not occured!");
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(113);
        try {
            this.appendTo(sb);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public StructuringElement3D Clone() {
        CoordinatesWeighted coord;
        CoordinatesWeighted coordclone;
        int i;
        StructuringElement3D clone = null;
        switch (this.Type) {
            case -12: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case -1: {
                clone = new StructuringElement3D(this.Order, this.Type);
                break;
            }
            case -13: {
                clone = new StructuringElement3D(this.Order, this.Type, this.se.length);
                break;
            }
            case -7: {
                this.GenerateDoubleArray();
                clone = new StructuringElement3D(this.datadouble);
                break;
            }
            default: {
                throw new IllegalStateException("Default, unknown type: " + this.Type);
            }
        }
        CoordinatesWeighted[] seclone = clone.getSE();
        for (i = 0; i < this.se.length; ++i) {
            coordclone = seclone[i];
            coord = this.se[i];
            coordclone.Wi = coord.Wi;
            coordclone.Wd = coord.Wd;
            coordclone.Pos = coord.Pos;
            coord = null;
            coordclone = null;
        }
        if (this.forward != null) {
            seclone = clone.getForward();
            for (i = 0; i < this.forward.length; ++i) {
                coordclone = seclone[i];
                coord = this.forward[i];
                coordclone.Wi = coord.Wi;
                coordclone.Wd = coord.Wd;
                coordclone.Pos = coord.Pos;
                coord = null;
                coordclone = null;
            }
            seclone = clone.getBackward();
            for (i = 0; i < this.backward.length; ++i) {
                coordclone = seclone[i];
                coord = this.backward[i];
                coordclone.Wi = coord.Wi;
                coordclone.Wd = coord.Wd;
                coordclone.Pos = coord.Pos;
                coord = null;
                coordclone = null;
            }
        }
        clone.ComputeSumOfWeights();
        return clone;
    }
}

