/*
 * Decompiled with CFR 0.152.
 */
package mathematics.primitives.pointsTiTi;

import mathematics.primitives.pointsTiTi.PointI;

public class PointIntND
implements PointI {
    protected int[] Coordonnees = null;
    protected int Dimension = 0;

    public PointIntND() {
    }

    public PointIntND(int Dimension2) {
        this.setDimension(Dimension2);
    }

    public PointIntND(int x, int y) {
        this.setDimension(2);
        this.Coordonnees[0] = x;
        this.Coordonnees[1] = y;
    }

    public PointIntND(int x, int y, int z) {
        this.setDimension(3);
        this.Coordonnees[0] = x;
        this.Coordonnees[1] = y;
        this.Coordonnees[2] = z;
    }

    public PointIntND(short[] Coordonnees) {
        this.Dimension = Coordonnees.length;
        this.Coordonnees = new int[this.Dimension];
        for (int i = 0; i < this.Dimension; ++i) {
            this.Coordonnees[i] = Coordonnees[i];
        }
    }

    public PointIntND(int[] Coordonnees) {
        this.Dimension = Coordonnees.length;
        this.Coordonnees = new int[this.Dimension];
        System.arraycopy(Coordonnees, 0, this.Coordonnees, 0, this.Dimension);
    }

    public PointIntND(PointI p) {
        this.Dimension = p.Size();
        this.Coordonnees = (int[])p.get().clone();
    }

    public void setDimension(int Dimension2) {
        if (Dimension2 < 1) {
            throw new Error("Dimension incorrecte : " + Dimension2 + ", attendu > 0.");
        }
        this.Dimension = Dimension2;
        this.Coordonnees = null;
        this.Coordonnees = new int[Dimension2];
    }

    @Override
    public int getX() {
        return this.Coordonnees[0];
    }

    @Override
    public int getY() {
        return this.Coordonnees[1];
    }

    @Override
    public int getZ() {
        return this.Coordonnees[2];
    }

    @Override
    public int[] get() {
        return this.Coordonnees;
    }

    @Override
    public int get(int x) {
        return this.Coordonnees[x];
    }

    @Override
    public void set(int index, int value) {
        this.Coordonnees[index] = value;
    }

    @Override
    public void set(int[] values) {
        if (values.length != this.Dimension) {
            throw new Error("Dimension du nouveau tableau incorrecte : " + values.length);
        }
        this.Coordonnees = (int[])values.clone();
    }

    @Override
    public void setX(int X) {
        this.Coordonnees[0] = X;
    }

    @Override
    public void setY(int Y) {
        this.Coordonnees[1] = Y;
    }

    @Override
    public void setZ(int Z) {
        this.Coordonnees[2] = Z;
    }

    @Override
    public void setXY(int X, int Y) {
        this.Coordonnees[0] = X;
        this.Coordonnees[1] = Y;
    }

    @Override
    public void setXYZ(int X, int Y, int Z) {
        this.Coordonnees[0] = X;
        this.Coordonnees[1] = Y;
        this.Coordonnees[2] = Z;
    }

    @Override
    public int Dimension() {
        return this.Dimension;
    }

    @Override
    public int Size() {
        return this.Dimension;
    }

    @Override
    public void Add(int x) {
        int i = 0;
        while (i < this.Dimension) {
            int n = i++;
            this.Coordonnees[n] = this.Coordonnees[n] + x;
        }
    }

    @Override
    public void Add(int[] x) {
        if (x.length != this.Dimension) {
            throw new IllegalArgumentException("Length paramater different of this point.");
        }
        for (int i = 0; i < this.Dimension; ++i) {
            int n = i;
            this.Coordonnees[n] = this.Coordonnees[n] + x[i];
        }
    }

    @Override
    public void Times(int x) {
        int i = 0;
        while (i < this.Dimension) {
            int n = i++;
            this.Coordonnees[n] = this.Coordonnees[n] * x;
        }
    }

    @Override
    public boolean Equal(PointI p) {
        if (p.Size() != this.Dimension) {
            return false;
        }
        for (int i = 0; i < this.Dimension; ++i) {
            if (p.get(i) == this.Coordonnees[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public PointI Clone() {
        return new PointIntND(this.Coordonnees);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(113);
        for (int i = 0; i < this.Dimension - 1; ++i) {
            sb.append(this.Coordonnees[i]).append(" ");
        }
        sb.append(this.Coordonnees[this.Dimension - 1]).append("\n");
        return sb.toString();
    }
}

