/*
 * Decompiled with CFR 0.152.
 */
package mathematics.metrics;

import mathematics.Maths;
import mathematics.metrics.Metric;
import mathematics.primitives.pointsTiTi.Coordinate;
import mathematics.primitives.pointsTiTi.Coordinates;
import mathematics.primitives.pointsTiTi.Point;
import mathematics.primitives.pointsTiTi.PointI;

public class Euclidian
implements Metric {
    @Override
    public double Distance(double[] v1, double[] v2) {
        if (v1.length != v2.length) {
            throw new IllegalArgumentException("Gap between dimensions of vectors: " + v1.length + " " + v2.length);
        }
        double sum = 0.0;
        int weightSize = v1.length;
        for (int i = 0; i < weightSize; ++i) {
            double diff = v2[i] - v1[i];
            sum += diff * diff;
        }
        return Math.sqrt(sum);
    }

    @Override
    public double Distance(float[] v1, float[] v2) {
        if (v1.length != v2.length) {
            throw new IllegalArgumentException("Gap between dimensions of vectors: " + v1.length + " " + v2.length);
        }
        double sum = 0.0;
        int weightSize = v1.length;
        for (int i = 0; i < weightSize; ++i) {
            double diff = v2[i] - v1[i];
            sum += diff * diff;
        }
        return Math.sqrt(sum);
    }

    @Override
    public double Distance(int[] v1, int[] v2) {
        if (v1.length != v2.length) {
            throw new IllegalArgumentException("Gap between dimensions of vectors: " + v1.length + " " + v2.length);
        }
        double sum = 0.0;
        int weightSize = v1.length;
        for (int i = 0; i < weightSize; ++i) {
            int diff = v2[i] - v1[i];
            sum += (double)(diff * diff);
        }
        return Math.sqrt(sum);
    }

    @Override
    public double Distance(Point p1, Point p2) {
        if (p1.Size() != p2.Size()) {
            throw new IllegalArgumentException("Gap between dimensions of vectors: " + p1.Size() + " " + p2.Size());
        }
        double sum = 0.0;
        int weightSize = p1.Size();
        for (int i = 0; i < weightSize; ++i) {
            double diff = p1.get(i) - p2.get(i);
            sum += diff * diff;
        }
        return Math.sqrt(sum);
    }

    @Override
    public double Distance(PointI p1, PointI p2) {
        if (p1.Size() != p2.Size()) {
            throw new IllegalArgumentException("Gap between dimensions of vectors: " + p1.Size() + " " + p2.Size());
        }
        double sum = 0.0;
        int weightSize = p1.Size();
        for (int i = 0; i < weightSize; ++i) {
            int diff = p1.get(i) - p2.get(i);
            sum += (double)(diff * diff);
        }
        return Math.sqrt(sum);
    }

    @Override
    public double Distance(Point p1, PointI p2) {
        if (p1.Size() != p2.Size()) {
            throw new IllegalArgumentException("Gap between dimensions of vectors: " + p1.Size() + " " + p2.Size());
        }
        double sum = 0.0;
        int weightSize = p1.Size();
        for (int i = 0; i < weightSize; ++i) {
            double diff = p1.get(i) - (double)p2.get(i);
            sum += diff * diff;
        }
        return Math.sqrt(sum);
    }

    @Override
    public double Distance(double Ux, double Uy, double Uz, double Vx, double Vy, double Vz) {
        return Math.sqrt((Ux - Vx) * (Ux - Vx) + (Uy - Vy) * (Uy - Vy) + (Uz - Vz) * (Uz - Vz));
    }

    @Override
    public double Distance(Coordinates u, Coordinates v) {
        return Math.sqrt((u.X - v.X) * (u.X - v.X) + (u.Y - v.Y) * (u.Y - v.Y) + (u.Z - v.Z) * (u.Z - v.Z));
    }

    @Override
    public double Distance(Point u, Coordinates v) {
        return Math.sqrt((u.getX() - (double)v.X) * (u.getX() - (double)v.X) + (u.getY() - (double)v.Y) * (u.getY() - (double)v.Y));
    }

    @Override
    public double Distance(PointI u, Coordinates v) {
        return Math.sqrt(Maths.Power(u.getX() - v.X, 2) + Maths.Power(u.getY() - v.Y, 2));
    }

    @Override
    public double Distance(Coordinate u, Coordinate v) {
        return Math.sqrt(Maths.Power(u.X - v.X, 2) + Maths.Power(u.Y - v.Y, 2) + Maths.Power(u.Z - v.Z, 2));
    }

    @Override
    public double Distance(Coordinates u, Coordinate v) {
        return Math.sqrt(Maths.Power((double)u.X - v.X, 2) + Maths.Power((double)u.Y - v.Y, 2) + Maths.Power((double)u.Z - v.Z, 2));
    }

    @Override
    public double Distance(Point u, Coordinate v) {
        return Math.sqrt(Maths.Power(u.getX() - v.X, 2) + Maths.Power(u.getY() - v.Y, 2));
    }

    @Override
    public double Distance(PointI u, Coordinate v) {
        return Math.sqrt(Maths.Power((double)u.getX() - v.X, 2) + Maths.Power((double)u.getY() - v.Y, 2));
    }
}

