/*
 * Decompiled with CFR 0.152.
 */
package mathematics;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.List;
import mathematics.primitives.pointsTiTi.Coordinates;
import mathematics.primitives.pointsTiTi.PointI;
import mathematics.primitives.pointsTiTi.PointIntND;

public class Bresenham {
    public static void Draw(BufferedImage image, int xi, int yi, int xf, int yf, int Couleur) {
        WritableRaster wr = image.getRaster();
        int x = xi;
        int y = yi;
        int dx = xf - xi;
        int dy = yf - yi;
        int xinc = dx > 0 ? 1 : -1;
        int yinc = dy > 0 ? 1 : -1;
        dx = Math.abs(dx);
        dy = Math.abs(dy);
        wr.setSample(x, y, 0, Couleur);
        if (dx > dy) {
            int cumul = dx >> 1;
            for (int i = 1; i <= dx; ++i) {
                x += xinc;
                if ((cumul += dy) >= dx) {
                    cumul -= dx;
                    y += yinc;
                }
                wr.setSample(x, y, 0, Couleur);
            }
        } else {
            int cumul = dy >> 1;
            for (int i = 1; i <= dy; ++i) {
                y += yinc;
                if ((cumul += dx) >= dy) {
                    cumul -= dy;
                    x += xinc;
                }
                wr.setSample(x, y, 0, Couleur);
            }
        }
        wr = null;
    }

    public static List<PointI> Points(int xi, int yi, int xf, int yf) {
        ArrayList<PointI> Liste = new ArrayList<PointI>((int)(1.15 * (double)Math.max(xf - xi, yf - yi)));
        int x = xi;
        int y = yi;
        int dx = xf - xi;
        int dy = yf - yi;
        int xinc = dx > 0 ? 1 : -1;
        int yinc = dy > 0 ? 1 : -1;
        dx = Math.abs(dx);
        dy = Math.abs(dy);
        Liste.add(new PointIntND(x, y));
        if (dx > dy) {
            int cumul = dx >> 1;
            for (int i = 1; i <= dx; ++i) {
                x += xinc;
                if ((cumul += dy) >= dx) {
                    cumul -= dx;
                    y += yinc;
                }
                Liste.add(new PointIntND(x, y));
            }
        } else {
            int cumul = dy >> 1;
            for (int i = 1; i <= dy; ++i) {
                y += yinc;
                if ((cumul += dx) >= dy) {
                    cumul -= dy;
                    x += xinc;
                }
                Liste.add(new PointIntND(x, y));
            }
        }
        return Liste;
    }

    public static List<Coordinates> Coordinates(int xi, int yi, int xf, int yf) {
        ArrayList<Coordinates> Liste = new ArrayList<Coordinates>((int)(1.13 * (double)Math.max(Math.abs(xf - xi), Math.abs(yf - yi))));
        int x = xi;
        int y = yi;
        int dx = xf - xi;
        int dy = yf - yi;
        int xinc = dx > 0 ? 1 : -1;
        int yinc = dy > 0 ? 1 : -1;
        dx = Math.abs(dx);
        dy = Math.abs(dy);
        Liste.add(new Coordinates(x, y));
        if (dx > dy) {
            int cumul = dx >> 1;
            for (int i = 1; i <= dx; ++i) {
                x += xinc;
                if ((cumul += dy) >= dx) {
                    cumul -= dx;
                    y += yinc;
                }
                Liste.add(new Coordinates(x, y));
            }
        } else {
            int cumul = dy >> 1;
            for (int i = 1; i <= dy; ++i) {
                y += yinc;
                if ((cumul += dx) >= dy) {
                    cumul -= dy;
                    x += xinc;
                }
                Liste.add(new Coordinates(x, y));
            }
        }
        return Liste;
    }
}

