/*
 * Decompiled with CFR 0.152.
 */
package imageTiTi.colorSpace;

import java.awt.color.ColorSpace;

public class HLS
extends ColorSpace {
    private static final long serialVersionUID = -7713114653902159981L;
    private ColorSpace rgb = ColorSpace.getInstance(1000);
    private float min;
    private float max;
    private float H;
    private float L;
    private float S;
    private float q;
    private float p;
    private float h;
    private float[] T = new float[3];
    private float[] RGB = new float[3];
    private static final float Epsilon = 1.0E-6f;

    public HLS() {
        super(8, 3);
    }

    @Override
    public float[] fromCIEXYZ(float[] pixel) {
        return this.fromRGB(this.rgb.fromCIEXYZ(pixel));
    }

    @Override
    public float[] fromRGB(float[] RGB) {
        this.max = RGB[0] >= RGB[1] && RGB[0] >= RGB[2] ? RGB[0] : (RGB[1] >= RGB[0] && RGB[1] >= RGB[2] ? RGB[1] : RGB[2]);
        this.min = RGB[0] <= RGB[1] && RGB[0] <= RGB[2] ? RGB[0] : (RGB[1] <= RGB[0] && RGB[1] <= RGB[2] ? RGB[1] : RGB[2]);
        this.H = Math.abs(this.max - this.min) < 1.0E-6f ? 0.0f : (Math.abs(this.max - RGB[0]) < 1.0E-6f ? (60.0f * (RGB[1] - RGB[2]) / (this.max - this.min) + 360.0f) % 360.0f : (Math.abs(this.max - RGB[1]) < 1.0E-6f ? 60.0f * (RGB[2] - RGB[0]) / (this.max - this.min) + 120.0f : 60.0f * (RGB[0] - RGB[1]) / (this.max - this.min) + 240.0f));
        this.L = (this.max + this.min) / 2.0f;
        this.S = Math.abs(this.max - this.min) < 1.0E-6f ? 0.0f : ((double)this.L > 0.5 ? (this.max - this.min) / (2.0f - 2.0f * this.L) : (this.max - this.min) / (2.0f * this.L));
        return new float[]{this.H, this.L, this.S};
    }

    @Override
    public float[] toCIEXYZ(float[] pixel) {
        return this.rgb.toCIEXYZ(this.toRGB(pixel));
    }

    @Override
    public float[] toRGB(float[] HLS2) {
        int i;
        this.q = (double)HLS2[1] < 0.5 ? HLS2[1] * (1.0f + HLS2[2]) : HLS2[1] + HLS2[2] - HLS2[1] * HLS2[2];
        this.p = 2.0f * HLS2[1] - this.q;
        this.h = HLS2[0] / 360.0f;
        this.T[0] = this.h + 0.3333333f;
        this.T[1] = this.h;
        this.T[2] = this.h - 0.3333333f;
        for (i = 0; i < 3; ++i) {
            if (this.T[i] < 0.0f) {
                int n = i;
                this.T[n] = this.T[n] + 1.0f;
                continue;
            }
            if (!(this.T[i] > 1.0f)) continue;
            int n = i;
            this.T[n] = this.T[n] - 1.0f;
        }
        for (i = 0; i < 3; ++i) {
            this.RGB[i] = this.T[i] < 0.16666667f ? this.p + (this.q - this.p) * 6.0f * this.T[i] : (this.T[i] < 0.5f ? this.q : (this.T[i] < 0.666666f ? this.p + (this.q - this.p) * 6.0f * (0.666666f - this.T[i]) : this.p));
        }
        return new float[]{this.RGB[0], this.RGB[1], this.RGB[2]};
    }
}

