/*
 * Decompiled with CFR 0.152.
 */
package imageTiTi.colorSpace;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;

public class ColorSpaceTests {
    public final int MIN = 0;
    public final int MAX = 1;
    private float[][] MinMax = new float[3][2];

    public void TestMinMax(ColorSpace cs) {
        float[] rgb = new float[]{0.0f, 0.0f, 0.0f};
        float[] res = cs.fromRGB(rgb);
        float f = res[0];
        this.MinMax[0][1] = f;
        this.MinMax[0][0] = f;
        float f2 = res[1];
        this.MinMax[1][1] = f2;
        this.MinMax[1][0] = f2;
        float f3 = res[2];
        this.MinMax[2][1] = f3;
        this.MinMax[2][0] = f3;
        res = null;
        for (int r = 0; r < 256; ++r) {
            rgb[0] = (float)r / 255.0f;
            for (int g = 0; g < 256; ++g) {
                rgb[1] = (float)g / 255.0f;
                for (int b = 0; b < 256; ++b) {
                    rgb[2] = (float)b / 255.0f;
                    res = cs.fromRGB(rgb);
                    if (res[0] < this.MinMax[0][0]) {
                        this.MinMax[0][0] = res[0];
                    }
                    if (res[0] > this.MinMax[0][1]) {
                        this.MinMax[0][1] = res[0];
                    }
                    if (res[1] < this.MinMax[1][0]) {
                        this.MinMax[1][0] = res[1];
                    }
                    if (res[1] > this.MinMax[1][1]) {
                        this.MinMax[1][1] = res[1];
                    }
                    if (res[2] < this.MinMax[2][0]) {
                        this.MinMax[2][0] = res[2];
                    }
                    if (res[2] > this.MinMax[2][1]) {
                        this.MinMax[2][1] = res[2];
                    }
                    res = null;
                }
            }
        }
        rgb = null;
    }

    public int TestConversions(BufferedImage source, ColorSpace cs, int nbWriteProblems) {
        int x;
        int y;
        int height = source.getHeight();
        int width = source.getWidth();
        ComponentColorModel myColorModel = new ComponentColorModel(cs, null, false, false, 1, 4);
        BufferedImage image = new BufferedImage(myColorModel, ((ColorModel)myColorModel).createCompatibleWritableRaster(width, height), false, null);
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                image.setRGB(x, y, source.getRGB(x, y));
            }
        }
        int nbErrors = 0;
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                if (source.getRGB(x, y) == image.getRGB(x, y) || ++nbErrors > nbWriteProblems) continue;
                System.err.println(nbErrors + ": " + x + " " + y + " => " + source.getRGB(x, y) + " =/= " + image.getRGB(x, y));
            }
        }
        return nbErrors;
    }

    public float[][] MinMax() {
        return this.MinMax;
    }

    public void DisplayMinMax() {
        System.out.println("Channel 0: " + this.MinMax[0][0] + " " + this.MinMax[0][1]);
        System.out.println("Channel 1: " + this.MinMax[1][0] + " " + this.MinMax[1][1]);
        System.out.println("Channel 2: " + this.MinMax[2][0] + " " + this.MinMax[2][1]);
    }
}

