/*
 * Decompiled with CFR 0.152.
 */
package imageTiTi;

import arrayTiTi.ArrayConverter;
import imageTiTi.ImageOperations;
import imageTiTi.ImageTools;
import imageTiTi.colorSpace.FloatCS;
import imageTiTi.colorSpace.HLS;
import imageTiTi.colorSpace.HSB;
import imageTiTi.colorSpace.HSV;
import imageTiTi.colorSpace.Lab;
import imageTiTi.colorSpace.NormalizedRGB;
import imageTiTi.colorSpace.YCbCr601;
import imageTiTi.colorSpace.YCbCr709;
import imageTiTi.colorSpace.YIQ;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import utils.memory.Allocator;

public class ImageNew {
    public static BufferedImage Same(BufferedImage src) {
        Allocator allocator = Allocator.Instance();
        int width = src.getWidth();
        int height = src.getHeight();
        int channel = src.getRaster().getNumBands();
        if (src.getType() == 0) {
            switch (src.getRaster().getDataBuffer().getDataType()) {
                case 5: {
                    return allocator.newBufferedImageDouble(width, height, channel);
                }
                case 4: {
                    return allocator.newBufferedImageFloat(width, height, channel);
                }
                case 3: {
                    return allocator.newBufferedImageInt(width, height, channel);
                }
            }
            throw new IllegalArgumentException("DataBuffer type not handled.");
        }
        return allocator.newBufferedImage(width, height, src.getType());
    }

    public static BufferedImage Same(BufferedImage src, int type) {
        switch (type) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                Allocator allocator = Allocator.Instance();
                return allocator.newBufferedImage(src.getWidth(), src.getHeight(), type);
            }
        }
        throw new IllegalArgumentException("Type or DataBuffer not supported (yet).");
    }

    public static BufferedImage Same(int width, int height, BufferedImage image) {
        return ImageNew.New(width, height, image);
    }

    public static BufferedImage SameBinary(BufferedImage src) {
        Allocator allocator = Allocator.Instance();
        return allocator.newBufferedImage(src.getWidth(), src.getHeight(), 12);
    }

    public static BufferedImage SameDouble(BufferedImage src) {
        Allocator allocator = Allocator.Instance();
        return allocator.newBufferedImageDouble(src.getWidth(), src.getHeight(), src.getRaster().getNumBands());
    }

    public static BufferedImage SameFloat(BufferedImage src) {
        Allocator allocator = Allocator.Instance();
        return allocator.newBufferedImageFloat(src.getWidth(), src.getHeight(), src.getRaster().getNumBands());
    }

    public static BufferedImage SameInteger(BufferedImage src) {
        Allocator allocator = Allocator.Instance();
        return allocator.newBufferedImageInt(src.getWidth(), src.getHeight(), src.getRaster().getNumBands());
    }

    public static BufferedImage SameHLS(BufferedImage src) {
        return ImageNew.HLS(src.getWidth(), src.getHeight());
    }

    public static BufferedImage SameHSB(BufferedImage src) {
        return ImageNew.HSB(src.getWidth(), src.getHeight());
    }

    public static BufferedImage SameHSV(BufferedImage src) {
        return ImageNew.HSV(src.getWidth(), src.getHeight());
    }

    public static BufferedImage SameLab(BufferedImage src) {
        return ImageNew.Lab(src.getWidth(), src.getHeight());
    }

    public static BufferedImage SameYCbCr601(BufferedImage src) {
        return ImageNew.YCbCr601(src.getWidth(), src.getHeight());
    }

    public static BufferedImage SameYCbCr709(BufferedImage src) {
        return ImageNew.YCbCr709(src.getWidth(), src.getHeight());
    }

    public static BufferedImage SameYIQ(BufferedImage src) {
        return ImageNew.YIQ(src.getWidth(), src.getHeight());
    }

    public static BufferedImage Clone2(BufferedImage src) {
        BufferedImage clone = new BufferedImage(src.getColorModel(), src.getRaster().createCompatibleWritableRaster(src.getWidth(), src.getHeight()), src.getColorModel().isAlphaPremultiplied(), null);
        clone.setData(src.getSubimage(0, 0, src.getWidth(), src.getHeight()).getRaster());
        return clone;
    }

    public static BufferedImage Clone(BufferedImage src) {
        BufferedImage clone = ImageNew.Same(src);
        block0 : switch (src.getType()) {
            case 5: 
            case 6: 
            case 10: 
            case 12: {
                byte[] datasrc = ((DataBufferByte)src.getRaster().getDataBuffer()).getData();
                byte[] dataclone = ((DataBufferByte)clone.getRaster().getDataBuffer()).getData();
                System.arraycopy(datasrc, 0, dataclone, 0, datasrc.length);
                break;
            }
            case 11: {
                short[] datasrc = ((DataBufferUShort)src.getRaster().getDataBuffer()).getData();
                short[] dataclone = ((DataBufferUShort)clone.getRaster().getDataBuffer()).getData();
                System.arraycopy(datasrc, 0, dataclone, 0, datasrc.length);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                int[] datasrc = ((DataBufferInt)src.getRaster().getDataBuffer()).getData();
                int[] dataclone = ((DataBufferInt)clone.getRaster().getDataBuffer()).getData();
                System.arraycopy(datasrc, 0, dataclone, 0, datasrc.length);
                break;
            }
            case 0: {
                switch (src.getRaster().getDataBuffer().getDataType()) {
                    case 5: {
                        double[] datasrc = ((DataBufferDouble)src.getRaster().getDataBuffer()).getData();
                        double[] dataclone = ((DataBufferDouble)clone.getRaster().getDataBuffer()).getData();
                        System.arraycopy(datasrc, 0, dataclone, 0, datasrc.length);
                        break block0;
                    }
                    case 4: {
                        float[] datasrc = ((DataBufferFloat)src.getRaster().getDataBuffer()).getData();
                        float[] dataclone = ((DataBufferFloat)clone.getRaster().getDataBuffer()).getData();
                        System.arraycopy(datasrc, 0, dataclone, 0, datasrc.length);
                        break block0;
                    }
                    case 3: {
                        int[] datasrc = ((DataBufferInt)src.getRaster().getDataBuffer()).getData();
                        int[] dataclone = ((DataBufferInt)clone.getRaster().getDataBuffer()).getData();
                        System.arraycopy(datasrc, 0, dataclone, 0, datasrc.length);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        return clone;
    }

    public static void Copy(BufferedImage source, BufferedImage destination) {
        if (!ImageTools.areDimensionsAndTypeEqual(source, destination)) {
            throw new IllegalArgumentException("Images have different types or Dimensions.");
        }
        block0 : switch (source.getType()) {
            case 5: 
            case 6: 
            case 10: 
            case 12: {
                byte[] datasrc = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                byte[] datadest = ((DataBufferByte)destination.getRaster().getDataBuffer()).getData();
                System.arraycopy(datasrc, 0, datadest, 0, datasrc.length);
                break;
            }
            case 11: {
                short[] datasrc = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                short[] datadest = ((DataBufferUShort)destination.getRaster().getDataBuffer()).getData();
                System.arraycopy(datasrc, 0, datadest, 0, datasrc.length);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                int[] datasrc = ((DataBufferInt)source.getRaster().getDataBuffer()).getData();
                int[] datadest = ((DataBufferInt)destination.getRaster().getDataBuffer()).getData();
                System.arraycopy(datasrc, 0, datadest, 0, datasrc.length);
                break;
            }
            case 0: {
                switch (source.getRaster().getDataBuffer().getDataType()) {
                    case 0: {
                        byte[] datasrc = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                        byte[] datadest = ((DataBufferByte)destination.getRaster().getDataBuffer()).getData();
                        System.arraycopy(datasrc, 0, datadest, 0, datasrc.length);
                        break block0;
                    }
                    case 5: {
                        double[] datasrc = ((DataBufferDouble)source.getRaster().getDataBuffer()).getData();
                        double[] datadest = ((DataBufferDouble)destination.getRaster().getDataBuffer()).getData();
                        System.arraycopy(datasrc, 0, datadest, 0, datasrc.length);
                        break block0;
                    }
                    case 4: {
                        float[] datasrc = ((DataBufferFloat)source.getRaster().getDataBuffer()).getData();
                        float[] datadest = ((DataBufferFloat)destination.getRaster().getDataBuffer()).getData();
                        System.arraycopy(datasrc, 0, datadest, 0, datasrc.length);
                        break block0;
                    }
                    case 3: {
                        int[] datasrc = ((DataBufferInt)source.getRaster().getDataBuffer()).getData();
                        int[] datadest = ((DataBufferInt)destination.getRaster().getDataBuffer()).getData();
                        System.arraycopy(datasrc, 0, datadest, 0, datasrc.length);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Images type not supported (yet).");
            }
        }
    }

    public static void CopyRough(BufferedImage source, BufferedImage destination) {
        int width = source.getWidth() < destination.getWidth() ? source.getWidth() : destination.getWidth();
        int height = source.getHeight() < destination.getHeight() ? source.getHeight() : destination.getHeight();
        WritableRaster wr = source.getRaster();
        WritableRaster wrd = destination.getRaster();
        switch (source.getType()) {
            case 10: 
            case 11: 
            case 12: {
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        wrd.setSample(x, y, 0, wr.getSample(x, y, 0));
                    }
                }
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        wrd.setSample(y, x, 0, wr.getSample(x, y, 0));
                        wrd.setSample(y, x, 1, wr.getSample(x, y, 1));
                        wrd.setSample(y, x, 2, wr.getSample(x, y, 2));
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Type of image not supported (yet).");
            }
        }
    }

    public static void Copy(BufferedImage source, BufferedImage destination, int channel) {
        if (!ImageTools.areDimensionsEqual(source, destination)) {
            throw new IllegalArgumentException("Images have different Dimensions.");
        }
        int nbbands = destination.getRaster().getNumBands();
        block0 : switch (source.getType()) {
            case 10: {
                if (destination.getType() != 5 && destination.getType() != 6) {
                    throw new IllegalArgumentException("Destination image type must be TYPE_3BYTE_BGR or TYPE_4BYTE_ABGR.");
                }
                byte[] bbin = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                byte[] bbout = ((DataBufferByte)destination.getRaster().getDataBuffer()).getData();
                int i = 0;
                int pos = channel;
                while (i < bbin.length) {
                    bbout[pos] = bbin[i];
                    ++i;
                    pos += nbbands;
                }
                bbout = null;
                bbin = null;
                break;
            }
            case 11: {
                switch (destination.getType()) {
                    case 5: 
                    case 6: {
                        short[] sbin = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                        byte[] bout = ((DataBufferByte)destination.getRaster().getDataBuffer()).getData();
                        int i = 0;
                        int pos = channel;
                        while (i < sbin.length) {
                            bout[pos] = (byte)((sbin[i] & 0xFFFF) >> 8);
                            ++i;
                            pos += nbbands;
                        }
                        sbin = null;
                        bout = null;
                        break block0;
                    }
                    case 0: {
                        switch (source.getRaster().getDataBuffer().getDataType()) {
                            case 1: {
                                short[] sbi = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                                short[] sbo = ((DataBufferUShort)destination.getRaster().getDataBuffer()).getData();
                                int i = 0;
                                int pos = channel;
                                while (i < sbi.length) {
                                    sbo[pos] = sbi[i];
                                    ++i;
                                    pos += nbbands;
                                }
                                sbo = null;
                                sbi = null;
                                break block0;
                            }
                        }
                        throw new IllegalArgumentException("Destination image type not supported for the given input.");
                    }
                }
                throw new IllegalArgumentException("Destination image type not supported for the given input.");
            }
            default: {
                throw new IllegalArgumentException("Source image type not supported (yet).");
            }
        }
    }

    public static BufferedImage New(int width, int height, int type) {
        Allocator allocator = Allocator.Instance();
        return allocator.newBufferedImage(width, height, type);
    }

    public static BufferedImage New(int width, int height, BufferedImage image) {
        Allocator allocator = Allocator.Instance();
        switch (image.getType()) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                return allocator.newBufferedImage(width, height, image.getType());
            }
            case 0: {
                switch (image.getRaster().getDataBuffer().getDataType()) {
                    case 5: {
                        return allocator.newBufferedImageDouble(width, height, image.getRaster().getNumBands());
                    }
                    case 4: {
                        return allocator.newBufferedImageFloat(width, height, image.getRaster().getNumBands());
                    }
                    case 3: {
                        return allocator.newBufferedImageInt(width, height, image.getRaster().getNumBands());
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
        }
        throw new IllegalArgumentException("Image type not supported (yet).");
    }

    public static BufferedImage SubImage(BufferedImage source, int MinX, int MinY, int MaxX, int MaxY) {
        BufferedImage result;
        block6: {
            Allocator allocator;
            block5: {
                allocator = Allocator.Instance();
                result = null;
                if (source.getType() != 0) break block5;
                switch (source.getRaster().getDataBuffer().getDataType()) {
                    case 5: {
                        result = allocator.newBufferedImageDouble(MaxX - MinX + 1, MaxY - MinY + 1, source.getRaster().getNumBands());
                        break block6;
                    }
                    case 4: {
                        result = allocator.newBufferedImageFloat(MaxX - MinX + 1, MaxY - MinY + 1, source.getRaster().getNumBands());
                        break block6;
                    }
                    case 3: {
                        result = allocator.newBufferedImageInt(MaxX - MinX + 1, MaxY - MinY + 1, source.getRaster().getNumBands());
                        break block6;
                    }
                    default: {
                        throw new IllegalArgumentException("Image type not supported (yet).");
                    }
                }
            }
            result = allocator.newBufferedImage(MaxX - MinX + 1, MaxY - MinY + 1, source.getType());
        }
        ImageNew.SubImage(source, MinX, MinY, MaxX, MaxY, result);
        return result;
    }

    public static void SubImage(BufferedImage source, int MinX, int MinY, int MaxX, int MaxY, BufferedImage result) {
        ImageNew.SubImageWH(source, MinX, MinY, MaxX - MinX + 1, MaxY - MinY + 1, result);
    }

    public static BufferedImage SubImageWH(BufferedImage source, int StartX, int StartY, int Width, int Height) {
        Allocator allocator = Allocator.Instance();
        BufferedImage result = allocator.newBufferedImage(Width, Height, source);
        ImageNew.SubImageWH(source, StartX, StartY, Width, Height, result);
        allocator = null;
        return result;
    }

    public static void SubImageWH(BufferedImage source, int StartX, int StartY, int Width, int Height, BufferedImage result) {
        if (result.getWidth() != Width || result.getHeight() != Height) {
            throw new IllegalArgumentException("result.getWidth() != Width || result.getHeight() != Height");
        }
        int width = source.getWidth();
        block0 : switch (source.getType()) {
            case 10: {
                byte[] bbin = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                byte[] bbout = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                int y = 0;
                int posnew = 0;
                int pos = StartY * width + StartX;
                while (y < Height) {
                    System.arraycopy(bbin, pos, bbout, posnew, Width);
                    ++y;
                    pos += width;
                    posnew += Width;
                }
                bbout = null;
                bbin = null;
                break;
            }
            case 11: {
                short[] sbin = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                short[] sbout = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                int y = 0;
                int posnew = 0;
                int pos = StartY * width + StartX;
                while (y < Height) {
                    System.arraycopy(sbin, pos, sbout, posnew, Width);
                    ++y;
                    pos += width;
                    posnew += Width;
                }
                sbout = null;
                sbin = null;
                break;
            }
            case 5: 
            case 6: {
                byte[] bbsrc = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                byte[] bbres = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                int channel = source.getRaster().getNumBands();
                int widthchannel = width * channel;
                int WidthChannel = Width * channel;
                int y = 0;
                int posres = 0;
                int pos = (StartY * width + StartX) * channel;
                while (y < Height) {
                    System.arraycopy(bbsrc, pos, bbres, posres, WidthChannel);
                    ++y;
                    pos += widthchannel;
                    posres += WidthChannel;
                }
                bbres = null;
                bbsrc = null;
                break;
            }
            case 1: 
            case 4: 
            case 12: {
                WritableRaster wr = source.getRaster();
                WritableRaster wrsub = result.getRaster();
                int endx = StartX + Width;
                int endy = StartY + Height;
                int channels = wr.getNumBands();
                for (int c = 0; c < channels; ++c) {
                    for (int y = StartY; y < endy; ++y) {
                        for (int x = StartX; x < endx; ++x) {
                            wrsub.setSample(x - StartX, y - StartY, c, wr.getSample(x, y, c));
                        }
                    }
                }
                break;
            }
            case 0: {
                switch (source.getRaster().getDataBuffer().getDataType()) {
                    case 5: {
                        double[] dbin = ((DataBufferDouble)source.getRaster().getDataBuffer()).getData();
                        double[] dbout = ((DataBufferDouble)result.getRaster().getDataBuffer()).getData();
                        int y = 0;
                        int posnew = 0;
                        int pos = StartY * width + StartX;
                        while (y < Height) {
                            System.arraycopy(dbin, pos, dbout, posnew, Width);
                            ++y;
                            pos += width;
                            posnew += Width;
                        }
                        dbout = null;
                        dbin = null;
                        break block0;
                    }
                    case 4: {
                        float[] fbin = ((DataBufferFloat)source.getRaster().getDataBuffer()).getData();
                        float[] fbout = ((DataBufferFloat)result.getRaster().getDataBuffer()).getData();
                        int y = 0;
                        int posnew = 0;
                        int pos = StartY * width + StartX;
                        while (y < Height) {
                            System.arraycopy(fbin, pos, fbout, posnew, Width);
                            ++y;
                            pos += width;
                            posnew += Width;
                        }
                        fbout = null;
                        fbin = null;
                        break block0;
                    }
                    case 3: {
                        int[] ibin = ((DataBufferInt)source.getRaster().getDataBuffer()).getData();
                        int[] ibout = ((DataBufferInt)result.getRaster().getDataBuffer()).getData();
                        int y = 0;
                        int posnew = 0;
                        int pos = StartY * width + StartX;
                        while (y < Height) {
                            System.arraycopy(ibin, pos, ibout, posnew, Width);
                            ++y;
                            pos += width;
                            posnew += Width;
                        }
                        ibout = null;
                        ibin = null;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
    }

    public static BufferedImage HLS(int width, int height) {
        HLS myColorSpace = new HLS();
        ComponentColorModel myColorModel = new ComponentColorModel(myColorSpace, null, false, false, 1, 4);
        return new BufferedImage(myColorModel, ((ColorModel)myColorModel).createCompatibleWritableRaster(width, height), false, null);
    }

    public static BufferedImage HSV(int width, int height) {
        HSV myColorSpace = new HSV();
        ComponentColorModel myColorModel = new ComponentColorModel(myColorSpace, null, false, false, 1, 4);
        return new BufferedImage(myColorModel, ((ColorModel)myColorModel).createCompatibleWritableRaster(width, height), false, null);
    }

    public static BufferedImage HSB(int width, int height) {
        HSB myColorSpace = new HSB();
        ComponentColorModel myColorModel = new ComponentColorModel(myColorSpace, null, false, false, 1, 4);
        return new BufferedImage(myColorModel, ((ColorModel)myColorModel).createCompatibleWritableRaster(width, height), false, null);
    }

    public static BufferedImage Lab(int width, int height) {
        Lab myColorSpace = new Lab();
        ComponentColorModel myColorModel = new ComponentColorModel(myColorSpace, null, false, false, 1, 4);
        return new BufferedImage(myColorModel, ((ColorModel)myColorModel).createCompatibleWritableRaster(width, height), false, null);
    }

    public static BufferedImage NormalizedRGB(int width, int height) {
        NormalizedRGB myColorSpace = new NormalizedRGB();
        ComponentColorModel myColorModel = new ComponentColorModel(myColorSpace, null, false, false, 1, 4);
        return new BufferedImage(myColorModel, ((ColorModel)myColorModel).createCompatibleWritableRaster(width, height), false, null);
    }

    public static BufferedImage YCbCr601(int width, int height) {
        YCbCr601 myColorSpace = new YCbCr601();
        ComponentColorModel myColorModel = new ComponentColorModel(myColorSpace, null, false, false, 1, 4);
        return new BufferedImage(myColorModel, ((ColorModel)myColorModel).createCompatibleWritableRaster(width, height), false, null);
    }

    public static BufferedImage YCbCr709(int width, int height) {
        YCbCr709 myColorSpace = new YCbCr709();
        ComponentColorModel myColorModel = new ComponentColorModel(myColorSpace, null, false, false, 1, 4);
        return new BufferedImage(myColorModel, ((ColorModel)myColorModel).createCompatibleWritableRaster(width, height), false, null);
    }

    public static BufferedImage YIQ(int width, int height) {
        YIQ myColorSpace = new YIQ();
        ComponentColorModel myColorModel = new ComponentColorModel(myColorSpace, null, false, false, 1, 4);
        return new BufferedImage(myColorModel, ((ColorModel)myColorModel).createCompatibleWritableRaster(width, height), false, null);
    }

    public static BufferedImage Double(int width, int height, int channel) {
        return ImageNew.Double(width, height, channel, false);
    }

    public static BufferedImage Double(int width, int height, int channel, boolean force) {
        if (!force) {
            Allocator allocator = Allocator.Instance();
            return allocator.newBufferedImageDouble(width, height, channel);
        }
        FloatCS myColorSpace = new FloatCS(channel == 1 ? 6 : 5, channel);
        ComponentColorModel myColorModel = new ComponentColorModel(myColorSpace, null, false, false, 1, 5);
        return new BufferedImage(myColorModel, ((ColorModel)myColorModel).createCompatibleWritableRaster(width, height), false, null);
    }

    public static BufferedImage Float(int width, int height, int channel) {
        return ImageNew.Float(width, height, channel, false);
    }

    public static BufferedImage Float(int width, int height, int channel, boolean force) {
        if (!force) {
            Allocator allocator = Allocator.Instance();
            return allocator.newBufferedImageFloat(width, height, channel);
        }
        FloatCS myColorSpace = new FloatCS(channel == 1 ? 6 : 5, channel);
        ComponentColorModel myColorModel = new ComponentColorModel(myColorSpace, null, false, false, 1, 4);
        return new BufferedImage(myColorModel, ((ColorModel)myColorModel).createCompatibleWritableRaster(width, height), false, null);
    }

    public static BufferedImage Integer(int width, int height, int channel) {
        return ImageNew.Integer(width, height, channel, false);
    }

    public static BufferedImage Integer(int width, int height, int channel, boolean force) {
        if (!force) {
            Allocator allocator = Allocator.Instance();
            return allocator.newBufferedImageInt(width, height, channel);
        }
        FloatCS myColorSpace = new FloatCS(channel == 1 ? 6 : 5, channel);
        int[] bits = new int[channel];
        Arrays.fill(bits, 32);
        ComponentColorModel myColorModel = new ComponentColorModel(myColorSpace, bits, false, false, 1, 3);
        return new BufferedImage(myColorModel, ((ColorModel)myColorModel).createCompatibleWritableRaster(width, height), false, null);
    }

    public static BufferedImage Integer(int width, int height, int channel, int[] databuffer) {
        if (height * width != databuffer.length) {
            throw new IllegalArgumentException("height*width != databuffer.length ");
        }
        BufferedImage result = ImageNew.Integer(width, height, channel);
        int[] buffer = ((DataBufferInt)result.getRaster().getDataBuffer()).getData();
        System.arraycopy(databuffer, 0, buffer, 0, databuffer.length);
        buffer = null;
        return result;
    }

    public static BufferedImage Integer(int width, int height, int channel, byte[] databuffer) {
        if (height * width != databuffer.length) {
            throw new IllegalArgumentException("height*width != databuffer.length ");
        }
        BufferedImage result = ImageNew.Integer(width, height, channel);
        int[] buffer = ((DataBufferInt)result.getRaster().getDataBuffer()).getData();
        ArrayConverter.UnsignedByteToInt(databuffer, buffer);
        buffer = null;
        return result;
    }

    public static BufferedImage Short(int width, int height, int channel) {
        return ImageNew.Short(width, height, channel, false);
    }

    public static BufferedImage Short(int width, int height, int channel, boolean force) {
        if (!force) {
            Allocator allocator = Allocator.Instance();
            return allocator.newBufferedImageShort(width, height, channel);
        }
        FloatCS myColorSpace = new FloatCS(channel == 1 ? 6 : 5, channel);
        ComponentColorModel myColorModel = new ComponentColorModel(myColorSpace, null, false, false, 1, 1);
        return new BufferedImage(myColorModel, ((ColorModel)myColorModel).createCompatibleWritableRaster(width, height), false, null);
    }

    public static BufferedImage Random(BufferedImage reference) {
        BufferedImage im = ImageNew.Same(reference);
        ImageOperations.FillRandomly(im);
        return im;
    }

    public static BufferedImage Random(int width, int height, int type) {
        Allocator allocator = Allocator.Instance();
        BufferedImage result = allocator.newBufferedImage(width, height, type);
        allocator = null;
        ImageOperations.FillRandomly(result);
        return result;
    }

    public static BufferedImage RandomGaussian(BufferedImage reference, double sd) {
        return ImageNew.RandomGaussian(reference.getWidth(), reference.getHeight(), reference.getType(), sd);
    }

    public static BufferedImage RandomGaussian(int width, int height, int type, double sd) {
        Allocator allocator = Allocator.Instance();
        BufferedImage result = allocator.newBufferedImage(width, height, type);
        allocator = null;
        ImageOperations.FillGaussianRandomly(result, sd);
        return result;
    }

    public static BufferedImage Increasingly(BufferedImage reference) {
        return ImageNew.Increasingly(reference.getWidth(), reference.getHeight(), reference.getType());
    }

    public static BufferedImage Increasingly(int width, int height, int type) {
        Allocator allocator = Allocator.Instance();
        BufferedImage result = allocator.newBufferedImage(width, height, type);
        allocator = null;
        ImageOperations.FillIncreasingly(result);
        return result;
    }
}

