/*
 * Decompiled with CFR 0.152.
 */
package imageTiTi;

import arrayTiTi.ArrayFeatures;
import imageTiTi.ImageComparator;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.util.LinkedList;
import java.util.List;
import listTiTi.ListTools;
import mathematics.Bresenham;
import mathematics.primitives.pointsTiTi.Coordinates;

public final class ImageFeatures {
    private long Integral = -1L;
    private double IntegralDouble = -1.0;
    private long Size = 0L;
    private double Average = 0.0;
    private double Variance = 0.0;
    private double StandardDeviation = 0.0;
    private double Kurtosis = 0.0;
    private double Skewness = 0.0;
    private double Contrast = 0.0;
    private double Michelson = 0.0;
    private double Minimum = 0.0;
    private double Maximum = 0.0;
    private int MinimumIndex = 0;
    private int MaximumIndex = 0;
    private double Rank005 = 0.0;
    private double Rank01 = 0.0;
    private double Rank025 = 0.0;
    private double Rank05 = 0.0;
    private double Rank10 = 0.0;
    private double Rank25 = 0.0;
    private double Rank50 = 0.0;
    private double Rank75 = 0.0;
    private double Rank90 = 0.0;
    private double Rank95 = 0.0;
    private double Rank975 = 0.0;
    private double Rank99 = 0.0;
    private double Rank995 = 0.0;
    private final ArrayFeatures AF = new ArrayFeatures();

    public long Counter(BufferedImage image, int channel, int ForbiddenValue) {
        int width = image.getWidth();
        int height = image.getHeight();
        this.Size = 0L;
        switch (image.getType()) {
            case 12: {
                WritableRaster wr = image.getRaster();
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        if (wr.getSample(x, y, 0) == ForbiddenValue) continue;
                        ++this.Size;
                    }
                }
                wr = null;
                break;
            }
            case 10: {
                this.Size = this.AF.Counter(((DataBufferByte)image.getRaster().getDataBuffer()).getData(), (byte)ForbiddenValue);
                break;
            }
            case 11: {
                this.Size = this.AF.Counter(((DataBufferUShort)image.getRaster().getDataBuffer()).getData(), (short)ForbiddenValue);
                break;
            }
            case 5: 
            case 6: {
                int nbchannel = image.getRaster().getNumBands();
                byte[] bytecolorbuffer = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                for (int x = channel; x < bytecolorbuffer.length; x += nbchannel) {
                    if ((bytecolorbuffer[x] & 0xFF) == ForbiddenValue) continue;
                    ++this.Size;
                }
                bytecolorbuffer = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Not supported (yet).");
            }
        }
        return this.Size;
    }

    public long Counter(BufferedImage image, double ForbiddenValue) {
        switch (image.getRaster().getDataBuffer().getDataType()) {
            case 4: {
                this.Size = this.AF.Counter(((DataBufferFloat)image.getRaster().getDataBuffer()).getData(), (float)ForbiddenValue);
                break;
            }
            case 5: {
                this.Size = this.AF.Counter(((DataBufferDouble)image.getRaster().getDataBuffer()).getData(), ForbiddenValue);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not supported (yet).");
            }
        }
        return this.Size;
    }

    public long Counter(BufferedImage image, double ForbiddenValue, int FromX, int EndX, int FromY, int EndY) {
        switch (image.getRaster().getDataBuffer().getDataType()) {
            case 4: {
                this.Size = this.AF.Counter(((DataBufferFloat)image.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), 1, (float)ForbiddenValue, FromX, EndX, FromY, EndY, 0, 1);
                break;
            }
            case 5: {
                this.Size = this.AF.Counter(((DataBufferDouble)image.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), 1, ForbiddenValue, FromX, EndX, FromY, EndY, 0, 1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not supported (yet).");
            }
        }
        return this.Size;
    }

    public long Counter(BufferedImage image, int ForbiddenValue) {
        return this.Counter(image, ForbiddenValue, 0, 0, image.getWidth(), image.getHeight());
    }

    public long Counter(BufferedImage image, int ForbiddenValue, int FromX, int EndX, int FromY, int EndY) {
        switch (image.getRaster().getDataBuffer().getDataType()) {
            case 0: {
                this.Size = this.AF.Counter(((DataBufferByte)image.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), 1, (byte)ForbiddenValue, FromX, EndX, FromY, EndY, 0, 1);
                break;
            }
            case 1: {
                this.Size = this.AF.Counter(((DataBufferUShort)image.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), 1, (short)ForbiddenValue, FromX, EndX, FromY, EndY, 0, 1);
                break;
            }
            case 3: {
                this.Size = this.AF.Counter(((DataBufferInt)image.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), 1, ForbiddenValue, FromX, EndX, FromY, EndY, 0, 1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not supported (yet).");
            }
        }
        return this.Size;
    }

    public void Integral(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        this.Size = 0L;
        this.Integral = 0L;
        this.IntegralDouble = 0.0;
        block0 : switch (image.getType()) {
            case 12: {
                WritableRaster wr = image.getRaster();
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        this.Integral += (long)wr.getSample(x, y, 0);
                    }
                }
                wr = null;
                break;
            }
            case 10: {
                this.Integral = this.AF.Integral(((DataBufferByte)image.getRaster().getDataBuffer()).getData());
                break;
            }
            case 11: {
                this.Integral = this.AF.Integral(((DataBufferUShort)image.getRaster().getDataBuffer()).getData());
                break;
            }
            case 0: {
                switch (image.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        this.Integral = this.AF.Integral(((DataBufferInt)image.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                    case 4: {
                        this.IntegralDouble = this.AF.Integral(((DataBufferFloat)image.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                    case 5: {
                        this.IntegralDouble = this.AF.Integral(((DataBufferDouble)image.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        this.Size = width * height;
    }

    public double Integral(BufferedImage image, double ForbiddenValue) {
        block0 : switch (image.getType()) {
            case 0: {
                switch (image.getRaster().getDataBuffer().getDataType()) {
                    case 4: {
                        this.IntegralDouble = this.AF.Integral(((DataBufferFloat)image.getRaster().getDataBuffer()).getData(), (float)ForbiddenValue);
                        break block0;
                    }
                    case 5: {
                        this.IntegralDouble = this.AF.Integral(((DataBufferDouble)image.getRaster().getDataBuffer()).getData(), ForbiddenValue);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        this.Size = this.AF.Size();
        return this.IntegralDouble;
    }

    public long Integral(BufferedImage image, int ForbiddenValue) {
        int width = image.getWidth();
        int height = image.getHeight();
        this.Size = 0L;
        this.Integral = 0L;
        switch (image.getType()) {
            case 12: {
                WritableRaster wr = image.getRaster();
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        if (wr.getSample(x, y, 0) == ForbiddenValue) continue;
                        this.Integral += (long)wr.getSample(x, y, 0);
                        ++this.Size;
                    }
                }
                wr = null;
                break;
            }
            case 10: {
                this.Integral = this.AF.Integral(((DataBufferByte)image.getRaster().getDataBuffer()).getData(), (byte)ForbiddenValue);
                this.Size = this.AF.Size();
                break;
            }
            case 11: {
                this.Integral = this.AF.Integral(((DataBufferUShort)image.getRaster().getDataBuffer()).getData(), (short)ForbiddenValue);
                this.Size = this.AF.Size();
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        return this.Integral;
    }

    public void Integral(BufferedImage image, int FromX, int EndX, int FromY, int EndY) {
        this.IntegralDouble = 0.0;
        this.Integral = 0L;
        switch (image.getType()) {
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 12: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        switch (image.getRaster().getDataBuffer().getDataType()) {
            case 0: {
                this.Integral = this.AF.Integral(((DataBufferByte)image.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), 1, FromX, EndX, FromY, EndY, 0, 1);
                break;
            }
            case 1: {
                this.Integral = this.AF.Integral(((DataBufferUShort)image.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), 1, FromX, EndX, FromY, EndY, 0, 1);
                break;
            }
            case 3: {
                this.Integral = this.AF.Integral(((DataBufferInt)image.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), 1, FromX, EndX, FromY, EndY, 0, 1);
                break;
            }
            case 4: {
                this.IntegralDouble = this.AF.Integral(((DataBufferFloat)image.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), 1, FromX, EndX, FromY, EndY, 0, 1);
                break;
            }
            case 5: {
                this.IntegralDouble = this.AF.Integral(((DataBufferDouble)image.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), 1, FromX, EndX, FromY, EndY, 0, 1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not supported (yet).");
            }
        }
        this.Size = this.AF.Size();
    }

    public long Integral(BufferedImage image, int ForbiddenValue, int FromX, int EndX, int FromY, int EndY) {
        this.IntegralDouble = 0.0;
        switch (image.getRaster().getDataBuffer().getDataType()) {
            case 0: {
                this.Integral = this.AF.Integral(((DataBufferByte)image.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), 1, (byte)ForbiddenValue, FromX, EndX, FromY, EndY, 0, 1);
                break;
            }
            case 1: {
                this.Integral = this.AF.Integral(((DataBufferUShort)image.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), 1, (short)ForbiddenValue, FromX, EndX, FromY, EndY, 0, 1);
                break;
            }
            case 3: {
                this.Integral = this.AF.Integral(((DataBufferInt)image.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), 1, ForbiddenValue, FromX, EndX, FromY, EndY, 0, 1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not supported (yet).");
            }
        }
        this.Size = this.AF.Size();
        return this.Integral;
    }

    public double Integral(BufferedImage image, double ForbiddenValue, int FromX, int EndX, int FromY, int EndY) {
        this.Integral = 0L;
        switch (image.getRaster().getDataBuffer().getDataType()) {
            case 4: {
                this.IntegralDouble = this.AF.Integral(((DataBufferFloat)image.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), 1, (float)ForbiddenValue, FromX, EndX, FromY, EndY, 0, 1);
                break;
            }
            case 5: {
                this.IntegralDouble = this.AF.Integral(((DataBufferDouble)image.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), 1, ForbiddenValue, FromX, EndX, FromY, EndY, 0, 1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not supported (yet).");
            }
        }
        this.Size = this.AF.Size();
        return this.IntegralDouble;
    }

    public double Average(BufferedImage image) {
        this.Integral = 0L;
        this.IntegralDouble = 0.0;
        block0 : switch (image.getType()) {
            case 10: {
                this.Average = this.AF.Average(((DataBufferByte)image.getRaster().getDataBuffer()).getData());
                this.Size = this.AF.Size();
                this.Integral = this.AF.Integral();
                break;
            }
            case 11: {
                this.Average = this.AF.Average(((DataBufferUShort)image.getRaster().getDataBuffer()).getData());
                this.Size = this.AF.Size();
                this.Integral = this.AF.Integral();
                break;
            }
            case 0: {
                switch (image.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        this.Average = this.AF.Average(((DataBufferInt)image.getRaster().getDataBuffer()).getData());
                        this.Size = this.AF.Size();
                        this.Integral = this.AF.Integral();
                        break block0;
                    }
                    case 4: {
                        this.Average = this.AF.Average(((DataBufferFloat)image.getRaster().getDataBuffer()).getData());
                        this.Size = this.AF.Size();
                        this.IntegralDouble = this.AF.IntegralDouble();
                        break block0;
                    }
                    case 5: {
                        this.Average = this.AF.Average(((DataBufferFloat)image.getRaster().getDataBuffer()).getData());
                        this.Size = this.AF.Size();
                        this.IntegralDouble = this.AF.IntegralDouble();
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        return this.Average;
    }

    public double Average(BufferedImage image, int ForbiddenValue) {
        block0 : switch (image.getType()) {
            case 10: {
                this.Average = this.AF.Average(((DataBufferByte)image.getRaster().getDataBuffer()).getData(), (byte)ForbiddenValue);
                this.Size = this.AF.Size();
                this.Integral = this.AF.Integral();
                break;
            }
            case 11: {
                this.Average = this.AF.Average(((DataBufferUShort)image.getRaster().getDataBuffer()).getData(), (short)ForbiddenValue);
                this.Size = this.AF.Size();
                this.Integral = this.AF.Integral();
                break;
            }
            case 0: {
                switch (image.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        this.Average = this.AF.Average(((DataBufferInt)image.getRaster().getDataBuffer()).getData(), ForbiddenValue);
                        this.Size = this.AF.Size();
                        this.Integral = this.AF.Integral();
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        return this.Average;
    }

    public double Average(BufferedImage image, double ForbiddenValue) {
        block0 : switch (image.getType()) {
            case 0: {
                switch (image.getRaster().getDataBuffer().getDataType()) {
                    case 4: {
                        this.Average = this.AF.Average(((DataBufferFloat)image.getRaster().getDataBuffer()).getData(), (float)ForbiddenValue);
                        this.Size = this.AF.Size();
                        this.IntegralDouble = this.AF.IntegralDouble();
                        break block0;
                    }
                    case 5: {
                        this.Average = this.AF.Average(((DataBufferDouble)image.getRaster().getDataBuffer()).getData(), ForbiddenValue);
                        this.Size = this.AF.Size();
                        this.IntegralDouble = this.AF.IntegralDouble();
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        return this.Average;
    }

    public double Average(BufferedImage image, int FromX, int EndX, int FromY, int EndY) {
        switch (image.getType()) {
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 12: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        switch (image.getRaster().getDataBuffer().getDataType()) {
            case 0: {
                this.Average = this.AF.Average(((DataBufferByte)image.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), 1, FromX, EndX, FromY, EndY, 0, 1);
                this.Integral = this.AF.Integral();
                break;
            }
            case 1: {
                this.Average = this.AF.Average(((DataBufferUShort)image.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), 1, FromX, EndX, FromY, EndY, 0, 1);
                this.Integral = this.AF.Integral();
                break;
            }
            case 3: {
                this.Average = this.AF.Average(((DataBufferInt)image.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), 1, FromX, EndX, FromY, EndY, 0, 1);
                this.Integral = this.AF.Integral();
                break;
            }
            case 4: {
                this.Average = this.AF.Average(((DataBufferFloat)image.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), 1, FromX, EndX, FromY, EndY, 0, 1);
                this.IntegralDouble = this.AF.IntegralDouble();
                break;
            }
            case 5: {
                this.Average = this.AF.Average(((DataBufferDouble)image.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), 1, FromX, EndX, FromY, EndY, 0, 1);
                this.IntegralDouble = this.AF.IntegralDouble();
                break;
            }
            default: {
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
        }
        this.Size = this.AF.Size();
        return this.Average;
    }

    public double Average(BufferedImage image, int ForbiddenValue, int FromX, int EndX, int FromY, int EndY) {
        block0 : switch (image.getType()) {
            case 0: {
                switch (image.getRaster().getDataBuffer().getDataType()) {
                    case 0: {
                        this.Average = this.AF.Average(((DataBufferByte)image.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), 1, (byte)ForbiddenValue, FromX, EndX, FromY, EndY, 0, 1);
                        break block0;
                    }
                    case 1: {
                        this.Average = this.AF.Average(((DataBufferUShort)image.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), 1, (short)ForbiddenValue, FromX, EndX, FromY, EndY, 0, 1);
                        break block0;
                    }
                    case 3: {
                        this.Average = this.AF.Average(((DataBufferInt)image.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), 1, ForbiddenValue, FromX, EndX, FromY, EndY, 0, 1);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        this.Size = this.AF.Size();
        this.Integral = this.AF.Integral();
        return this.Average;
    }

    public double Average(BufferedImage image, double ForbiddenValue, int FromX, int EndX, int FromY, int EndY) {
        block0 : switch (image.getType()) {
            case 0: {
                switch (image.getRaster().getDataBuffer().getDataType()) {
                    case 4: {
                        this.Average = this.AF.Average(((DataBufferFloat)image.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), 1, (float)ForbiddenValue, FromX, EndX, FromY, EndY, 0, 1);
                        break block0;
                    }
                    case 5: {
                        this.Average = this.AF.Average(((DataBufferDouble)image.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), 1, ForbiddenValue, FromX, EndX, FromY, EndY, 0, 1);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        this.Size = this.AF.Size();
        this.IntegralDouble = this.AF.IntegralDouble();
        return this.Average;
    }

    public void Moments(BufferedImage image) {
        if (!ImageTools.isGrayLevel(image)) {
            throw new IllegalArgumentException("Gray level image required.");
        }
        switch (image.getType()) {
            case 10: {
                this.AF.Moments(((DataBufferByte)image.getRaster().getDataBuffer()).getData());
                break;
            }
            case 11: {
                this.AF.Moments(((DataBufferUShort)image.getRaster().getDataBuffer()).getData());
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        this.Size = this.AF.Size();
        if (image.getType() != 0) {
            this.Integral = this.AF.Integral();
        }
        this.Average = this.AF.Average();
        this.Variance = this.AF.Variance();
        this.StandardDeviation = this.AF.StandardDeviation();
        this.Skewness = this.AF.Skewness();
        this.Kurtosis = this.AF.Kurtosis();
    }

    public void Moments(BufferedImage image, int ForbiddenValue) {
        if (!ImageTools.isGrayLevel(image)) {
            throw new IllegalArgumentException("Gray level image required.");
        }
        switch (image.getType()) {
            case 10: {
                this.AF.Moments(((DataBufferByte)image.getRaster().getDataBuffer()).getData(), (byte)ForbiddenValue);
                break;
            }
            case 11: {
                this.AF.Moments(((DataBufferUShort)image.getRaster().getDataBuffer()).getData(), (short)ForbiddenValue);
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        this.Size = this.AF.Size();
        if (image.getType() != 0) {
            this.Integral = this.AF.Integral();
        }
        this.Average = this.AF.Average();
        this.Variance = this.AF.Variance();
        this.StandardDeviation = this.AF.StandardDeviation();
        this.Skewness = this.AF.Skewness();
        this.Kurtosis = this.AF.Kurtosis();
    }

    public void Moments(BufferedImage image, BufferedImage mask) {
        if (!ImageTools.isGrayLevel(image)) {
            throw new IllegalArgumentException("Gray level image required.");
        }
        if (!ImageTools.areDimensionsAndTypeEqual(image, mask)) {
            throw new IllegalArgumentException("Image and Mask have different types or dimensions.");
        }
        block0 : switch (image.getType()) {
            case 10: {
                this.AF.Moments(((DataBufferByte)image.getRaster().getDataBuffer()).getData(), ((DataBufferByte)image.getRaster().getDataBuffer()).getData());
                break;
            }
            case 11: {
                this.AF.Moments(((DataBufferUShort)image.getRaster().getDataBuffer()).getData(), ((DataBufferUShort)image.getRaster().getDataBuffer()).getData());
                break;
            }
            case 0: {
                switch (image.getRaster().getDataBuffer().getDataType()) {
                    case 5: {
                        this.AF.Moments(((DataBufferDouble)image.getRaster().getDataBuffer()).getData(), ((DataBufferDouble)image.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                    case 4: {
                        this.AF.Moments(((DataBufferFloat)image.getRaster().getDataBuffer()).getData(), ((DataBufferFloat)image.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                    case 3: {
                        this.AF.Moments(((DataBufferInt)image.getRaster().getDataBuffer()).getData(), ((DataBufferInt)image.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        this.Size = this.AF.Size();
        if (image.getType() != 0) {
            this.Integral = this.AF.Integral();
        }
        this.Average = this.AF.Average();
        this.Variance = this.AF.Variance();
        this.StandardDeviation = this.AF.StandardDeviation();
        this.Skewness = this.AF.Skewness();
        this.Kurtosis = this.AF.Kurtosis();
    }

    public void MomentsParallelized(BufferedImage image, int nbCPU) {
        if (!ImageTools.isGrayLevel(image)) {
            throw new IllegalArgumentException("Gray level image required.");
        }
        switch (image.getType()) {
            case 10: {
                this.AF.MomentsParallelized(((DataBufferByte)image.getRaster().getDataBuffer()).getData(), nbCPU);
                break;
            }
            case 11: {
                this.AF.MomentsParallelized(((DataBufferUShort)image.getRaster().getDataBuffer()).getData(), nbCPU);
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        this.Size = this.AF.Size();
        if (image.getType() != 0) {
            this.Integral = this.AF.Integral();
        }
        this.Average = this.AF.Average();
        this.Variance = this.AF.Variance();
        this.StandardDeviation = this.AF.StandardDeviation();
        this.Skewness = this.AF.Skewness();
        this.Kurtosis = this.AF.Kurtosis();
    }

    public void MomentsParallelized(BufferedImage image, int ForbiddenValue, int nbCPU) {
        if (!ImageTools.isGrayLevel(image)) {
            throw new IllegalArgumentException("Gray level image required.");
        }
        switch (image.getType()) {
            case 10: {
                this.AF.MomentsParallelized(((DataBufferByte)image.getRaster().getDataBuffer()).getData(), (byte)ForbiddenValue, nbCPU);
                break;
            }
            case 11: {
                this.AF.MomentsParallelized(((DataBufferUShort)image.getRaster().getDataBuffer()).getData(), (short)ForbiddenValue, nbCPU);
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        this.Size = this.AF.Size();
        if (image.getType() != 0) {
            this.Integral = this.AF.Integral();
        }
        this.Average = this.AF.Average();
        this.Variance = this.AF.Variance();
        this.StandardDeviation = this.AF.StandardDeviation();
        this.Skewness = this.AF.Skewness();
        this.Kurtosis = this.AF.Kurtosis();
    }

    public void Ranks(BufferedImage image) {
        if (!ImageTools.isGrayLevel(image)) {
            throw new IllegalArgumentException("Gray level image required.");
        }
        switch (image.getType()) {
            case 10: {
                this.AF.Ranks(((DataBufferByte)image.getRaster().getDataBuffer()).getData());
                break;
            }
            case 11: {
                this.AF.Ranks(((DataBufferUShort)image.getRaster().getDataBuffer()).getData());
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        this.Minimum = this.AF.Minimum();
        this.MinimumIndex = this.AF.MinimumIndex();
        this.Rank005 = this.AF.Rank005();
        this.Rank01 = this.AF.Rank01();
        this.Rank025 = this.AF.Rank025();
        this.Rank05 = this.AF.Rank05();
        this.Rank10 = this.AF.Rank10();
        this.Rank25 = this.AF.Rank25();
        this.Rank50 = this.AF.Rank50();
        this.Rank75 = this.AF.Rank75();
        this.Rank90 = this.AF.Rank90();
        this.Rank95 = this.AF.Rank95();
        this.Rank975 = this.AF.Rank975();
        this.Rank99 = this.AF.Rank99();
        this.Rank995 = this.AF.Rank995();
        this.Maximum = this.AF.Maximum();
        this.MaximumIndex = this.AF.MaximumIndex();
    }

    public void Ranks(BufferedImage image, int ForbiddenValue) {
        if (!ImageTools.isGrayLevel(image)) {
            throw new IllegalArgumentException("Gray level image required.");
        }
        switch (image.getType()) {
            case 10: {
                this.AF.Ranks(((DataBufferByte)image.getRaster().getDataBuffer()).getData(), (byte)ForbiddenValue);
                break;
            }
            case 11: {
                this.AF.Ranks(((DataBufferUShort)image.getRaster().getDataBuffer()).getData(), (short)ForbiddenValue);
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        this.Minimum = this.AF.Minimum();
        this.MinimumIndex = this.AF.MinimumIndex();
        this.Rank005 = this.AF.Rank005();
        this.Rank01 = this.AF.Rank01();
        this.Rank025 = this.AF.Rank025();
        this.Rank05 = this.AF.Rank05();
        this.Rank10 = this.AF.Rank10();
        this.Rank25 = this.AF.Rank25();
        this.Rank50 = this.AF.Rank50();
        this.Rank75 = this.AF.Rank75();
        this.Rank90 = this.AF.Rank90();
        this.Rank95 = this.AF.Rank95();
        this.Rank975 = this.AF.Rank975();
        this.Rank99 = this.AF.Rank99();
        this.Rank995 = this.AF.Rank995();
        this.Maximum = this.AF.Maximum();
        this.MaximumIndex = this.AF.MaximumIndex();
    }

    public double Minimum(BufferedImage image) {
        block0 : switch (image.getType()) {
            case 5: 
            case 6: 
            case 10: {
                this.Minimum = this.AF.Minimum(((DataBufferByte)image.getRaster().getDataBuffer()).getData());
                break;
            }
            case 11: {
                this.Minimum = this.AF.Minimum(((DataBufferUShort)image.getRaster().getDataBuffer()).getData());
                break;
            }
            case 0: {
                switch (image.getRaster().getDataBuffer().getDataType()) {
                    case 5: {
                        this.Minimum = this.AF.Minimum(((DataBufferDouble)image.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                    case 4: {
                        this.Minimum = this.AF.Minimum(((DataBufferFloat)image.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                    case 3: {
                        this.Minimum = this.AF.Minimum(((DataBufferInt)image.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        this.MinimumIndex = this.AF.MinimumIndex();
        return this.Minimum;
    }

    public double Maximum(BufferedImage image) {
        switch (image.getType()) {
            case 5: 
            case 6: 
            case 10: {
                this.Maximum = this.AF.Maximum(((DataBufferByte)image.getRaster().getDataBuffer()).getData());
                break;
            }
            case 11: {
                this.Maximum = this.AF.Maximum(((DataBufferUShort)image.getRaster().getDataBuffer()).getData());
                break;
            }
            case 0: {
                switch (image.getRaster().getDataBuffer().getDataType()) {
                    case 5: {
                        this.Maximum = this.AF.Maximum(((DataBufferDouble)image.getRaster().getDataBuffer()).getData());
                        break;
                    }
                    case 4: {
                        this.Maximum = this.AF.Maximum(((DataBufferFloat)image.getRaster().getDataBuffer()).getData());
                        break;
                    }
                    case 3: {
                        this.Maximum = this.AF.Maximum(((DataBufferInt)image.getRaster().getDataBuffer()).getData());
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        this.MaximumIndex = this.AF.MaximumIndex();
        return this.Maximum;
    }

    public double Minimum(BufferedImage image, int ForbiddenValue) {
        if (!ImageTools.isGrayLevel(image)) {
            throw new IllegalArgumentException("Gray level image required.");
        }
        block0 : switch (image.getType()) {
            case 10: {
                this.Minimum = this.AF.Minimum(((DataBufferByte)image.getRaster().getDataBuffer()).getData(), (byte)ForbiddenValue);
                break;
            }
            case 11: {
                this.Minimum = this.AF.Minimum(((DataBufferUShort)image.getRaster().getDataBuffer()).getData(), (short)ForbiddenValue);
                break;
            }
            case 0: {
                switch (image.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        this.Minimum = this.AF.Minimum(((DataBufferInt)image.getRaster().getDataBuffer()).getData(), ForbiddenValue);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        this.MinimumIndex = this.AF.MinimumIndex();
        return this.Minimum;
    }

    public double Minimum(BufferedImage image, double ForbiddenValue) {
        if (!ImageTools.isGrayLevel(image)) {
            throw new IllegalArgumentException("Gray level image required.");
        }
        block0 : switch (image.getType()) {
            case 0: {
                switch (image.getRaster().getDataBuffer().getDataType()) {
                    case 5: {
                        this.Minimum = this.AF.Minimum(((DataBufferDouble)image.getRaster().getDataBuffer()).getData(), ForbiddenValue);
                        break block0;
                    }
                    case 4: {
                        this.Minimum = this.AF.Minimum(((DataBufferFloat)image.getRaster().getDataBuffer()).getData(), (float)ForbiddenValue);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        this.MinimumIndex = this.AF.MinimumIndex();
        return this.Minimum;
    }

    public double Maximum(BufferedImage image, int ForbiddenValue) {
        if (!ImageTools.isGrayLevel(image)) {
            throw new IllegalArgumentException("Gray level image required.");
        }
        block0 : switch (image.getType()) {
            case 10: {
                this.Maximum = this.AF.Maximum(((DataBufferByte)image.getRaster().getDataBuffer()).getData(), (byte)ForbiddenValue);
                break;
            }
            case 11: {
                this.Maximum = this.AF.Maximum(((DataBufferUShort)image.getRaster().getDataBuffer()).getData(), (short)ForbiddenValue);
                break;
            }
            case 0: {
                switch (image.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        this.Maximum = this.AF.Maximum(((DataBufferInt)image.getRaster().getDataBuffer()).getData(), ForbiddenValue);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        this.MaximumIndex = this.AF.MaximumIndex();
        return this.Maximum;
    }

    public double Maximum(BufferedImage image, double ForbiddenValue) {
        if (!ImageTools.isGrayLevel(image)) {
            throw new IllegalArgumentException("Gray level image required.");
        }
        block0 : switch (image.getType()) {
            case 0: {
                switch (image.getRaster().getDataBuffer().getDataType()) {
                    case 5: {
                        this.Maximum = this.AF.Maximum(((DataBufferDouble)image.getRaster().getDataBuffer()).getData(), ForbiddenValue);
                        break block0;
                    }
                    case 4: {
                        this.Maximum = this.AF.Maximum(((DataBufferFloat)image.getRaster().getDataBuffer()).getData(), (float)ForbiddenValue);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        this.MaximumIndex = this.AF.MaximumIndex();
        return this.Maximum;
    }

    public double Contrast(BufferedImage image) {
        this.Contrast = (this.Maximum(image) - this.Minimum(image)) / this.Average(image);
        return this.Contrast;
    }

    public double Michelson(BufferedImage image) {
        double min = this.Minimum(image);
        double max = this.Maximum(image);
        this.Michelson = (max - min) / (max + min);
        return this.Michelson;
    }

    public double MichelsonFromRanks(BufferedImage image, int ranksup) {
        switch (image.getType()) {
            case 10: {
                this.Michelson = this.AF.MichelsonFromRanks(((DataBufferByte)image.getRaster().getDataBuffer()).getData(), ranksup);
                break;
            }
            case 11: {
                this.Michelson = this.AF.MichelsonFromRanks(((DataBufferUShort)image.getRaster().getDataBuffer()).getData(), ranksup);
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        return this.Michelson;
    }

    public double Contrast(BufferedImage image, int ForbiddenValue) {
        this.Contrast = (this.Maximum(image, ForbiddenValue) - this.Minimum(image, ForbiddenValue)) / this.Average(image, ForbiddenValue);
        return this.Contrast;
    }

    public double Michelson(BufferedImage image, int ForbiddenValue) {
        double min = this.Minimum(image, ForbiddenValue);
        double max = this.Maximum(image, ForbiddenValue);
        this.Michelson = (max - min) / (max + min);
        return this.Michelson;
    }

    public double MichelsonFromRanks(BufferedImage image, int ranksup, int ForbiddenValue) {
        switch (image.getType()) {
            case 10: {
                this.Michelson = this.AF.MichelsonFromRanks(((DataBufferByte)image.getRaster().getDataBuffer()).getData(), ranksup, (byte)ForbiddenValue);
                break;
            }
            case 11: {
                this.Michelson = this.AF.MichelsonFromRanks(((DataBufferUShort)image.getRaster().getDataBuffer()).getData(), ranksup, (short)ForbiddenValue);
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        return this.Michelson;
    }

    public double[] Saturation(BufferedImage image) {
        double[] sat = new double[image.getHeight() * image.getWidth()];
        this.Saturation(image, sat);
        return sat;
    }

    public void Saturation(BufferedImage image, double[] saturation) {
        if (image.getWidth() * image.getHeight() != saturation.length) {
            throw new IllegalArgumentException("Image and array have different dimensions.");
        }
        if (!ImageTools.isColored(image)) {
            throw new IllegalArgumentException("Colored image required.");
        }
        WritableRaster wr = image.getRaster();
        int pos = 0;
        for (int y = 0; y < image.getHeight(); ++y) {
            int x = 0;
            while (x < image.getWidth()) {
                int v0 = wr.getSample(x, y, 0);
                int v1 = wr.getSample(x, y, 1);
                int v2 = wr.getSample(x, y, 2);
                int min = Math.min(Math.min(v0, v1), v2);
                int max = Math.max(Math.max(v0, v1), v2);
                saturation[pos] = (double)(max - min) / (double)max;
                ++x;
                ++pos;
            }
        }
        wr = null;
    }

    public void Nplex(BufferedImage source, BufferedImage result, int N) {
        int width = source.getWidth();
        int width1 = width - 1;
        int height1 = source.getHeight() - 1;
        LinkedList<Integer> list = new LinkedList<Integer>();
        switch (source.getType()) {
            case 10: {
                byte[] srcbb = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                byte[] resbb = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                int y = 1;
                int pos = width + 1;
                while (y < height1) {
                    int x = 1;
                    while (x < width1) {
                        int v = srcbb[pos] & 0xFF;
                        int posnei = pos - width - 1;
                        int p = srcbb[posnei] & 0xFF;
                        if (v != p && !ListTools.isInList(list, p)) {
                            list.add(p);
                        }
                        if (v != (p = srcbb[++posnei] & 0xFF) && !ListTools.isInList(list, p)) {
                            list.add(p);
                        }
                        if (v != (p = srcbb[++posnei] & 0xFF) && !ListTools.isInList(list, p)) {
                            list.add(p);
                        }
                        if (v != (p = srcbb[pos - 1] & 0xFF) && !ListTools.isInList(list, p)) {
                            list.add(p);
                        }
                        if (v != (p = srcbb[pos + 1] & 0xFF) && !ListTools.isInList(list, p)) {
                            list.add(p);
                        }
                        if (v != (p = srcbb[posnei = pos + width - 1] & 0xFF) && !ListTools.isInList(list, p)) {
                            list.add(p);
                        }
                        if (v != (p = srcbb[++posnei] & 0xFF) && !ListTools.isInList(list, p)) {
                            list.add(p);
                        }
                        if (v != (p = srcbb[++posnei] & 0xFF) && !ListTools.isInList(list, p)) {
                            list.add(p);
                        }
                        resbb[pos] = (byte)(list.size() == N ? v : 0);
                        list.clear();
                        ++x;
                        ++pos;
                    }
                    ++y;
                    pos += 2;
                }
                resbb = null;
                srcbb = null;
                break;
            }
            case 11: {
                short[] srcsb = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                short[] ressb = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                int y = 1;
                int pos = width + 1;
                while (y < height1) {
                    int x = 1;
                    while (x < width1) {
                        int v = srcsb[pos] & 0xFFFF;
                        int posnei = pos - width - 1;
                        int p = srcsb[posnei] & 0xFFFF;
                        if (v != p && !ListTools.isInList(list, p)) {
                            list.add(p);
                        }
                        if (v != (p = srcsb[++posnei] & 0xFFFF) && !ListTools.isInList(list, p)) {
                            list.add(p);
                        }
                        if (v != (p = srcsb[++posnei] & 0xFFFF) && !ListTools.isInList(list, p)) {
                            list.add(p);
                        }
                        if (v != (p = srcsb[pos - 1] & 0xFFFF) && !ListTools.isInList(list, p)) {
                            list.add(p);
                        }
                        if (v != (p = srcsb[pos + 1] & 0xFFFF) && !ListTools.isInList(list, p)) {
                            list.add(p);
                        }
                        if (v != (p = srcsb[posnei = pos + width - 1] & 0xFFFF) && !ListTools.isInList(list, p)) {
                            list.add(p);
                        }
                        if (v != (p = srcsb[++posnei] & 0xFFFF) && !ListTools.isInList(list, p)) {
                            list.add(p);
                        }
                        if (v != (p = srcsb[++posnei] & 0xFFFF) && !ListTools.isInList(list, p)) {
                            list.add(p);
                        }
                        ressb[pos] = (short)(list.size() == N ? v : 0);
                        list.clear();
                        ++x;
                        ++pos;
                    }
                    ++y;
                    pos += 2;
                }
                ressb = null;
                srcsb = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not yet supported.");
            }
        }
    }

    public void Nplex(BufferedImage source, BufferedImage result) {
        int width = source.getWidth();
        int width1 = width - 1;
        int height1 = source.getHeight() - 1;
        LinkedList<Integer> list = new LinkedList<Integer>();
        switch (source.getType()) {
            case 10: {
                byte[] srcbb = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                byte[] resbb = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                int y = 1;
                int pos = width + 1;
                while (y < height1) {
                    int x = 1;
                    while (x < width1) {
                        int v = srcbb[pos] & 0xFF;
                        int posnei = pos - width - 1;
                        int p = srcbb[posnei] & 0xFF;
                        if (v != p && !ListTools.isInList(list, p)) {
                            list.add(p);
                        }
                        if (v != (p = srcbb[++posnei] & 0xFF) && !ListTools.isInList(list, p)) {
                            list.add(p);
                        }
                        if (v != (p = srcbb[++posnei] & 0xFF) && !ListTools.isInList(list, p)) {
                            list.add(p);
                        }
                        if (v != (p = srcbb[pos - 1] & 0xFF) && !ListTools.isInList(list, p)) {
                            list.add(p);
                        }
                        if (v != (p = srcbb[pos + 1] & 0xFF) && !ListTools.isInList(list, p)) {
                            list.add(p);
                        }
                        if (v != (p = srcbb[posnei = pos + width - 1] & 0xFF) && !ListTools.isInList(list, p)) {
                            list.add(p);
                        }
                        if (v != (p = srcbb[++posnei] & 0xFF) && !ListTools.isInList(list, p)) {
                            list.add(p);
                        }
                        if (v != (p = srcbb[++posnei] & 0xFF) && !ListTools.isInList(list, p)) {
                            list.add(p);
                        }
                        resbb[pos] = (byte)list.size();
                        list.clear();
                        ++x;
                        ++pos;
                    }
                    ++y;
                    pos += 2;
                }
                resbb = null;
                srcbb = null;
                break;
            }
            case 11: {
                short[] srcsb = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                short[] ressb = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                int y = 1;
                int pos = width + 1;
                while (y < height1) {
                    int x = 1;
                    while (x < width1) {
                        int v = srcsb[pos] & 0xFFFF;
                        int posnei = pos - width - 1;
                        int p = srcsb[posnei] & 0xFFFF;
                        if (v != p && !ListTools.isInList(list, p)) {
                            list.add(p);
                        }
                        if (v != (p = srcsb[++posnei] & 0xFFFF) && !ListTools.isInList(list, p)) {
                            list.add(p);
                        }
                        if (v != (p = srcsb[++posnei] & 0xFFFF) && !ListTools.isInList(list, p)) {
                            list.add(p);
                        }
                        if (v != (p = srcsb[pos - 1] & 0xFFFF) && !ListTools.isInList(list, p)) {
                            list.add(p);
                        }
                        if (v != (p = srcsb[pos + 1] & 0xFFFF) && !ListTools.isInList(list, p)) {
                            list.add(p);
                        }
                        if (v != (p = srcsb[posnei = pos + width - 1] & 0xFFFF) && !ListTools.isInList(list, p)) {
                            list.add(p);
                        }
                        if (v != (p = srcsb[++posnei] & 0xFFFF) && !ListTools.isInList(list, p)) {
                            list.add(p);
                        }
                        if (v != (p = srcsb[++posnei] & 0xFFFF) && !ListTools.isInList(list, p)) {
                            list.add(p);
                        }
                        ressb[pos] = (short)list.size();
                        list.clear();
                        ++x;
                        ++pos;
                    }
                    ++y;
                    pos += 2;
                }
                ressb = null;
                srcsb = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not yet supported.");
            }
        }
    }

    public void NplexStrict(BufferedImage source, BufferedImage result, int N) {
        this.NplexStrict(source, result);
        ImageComparator.Compare(result, "==", N, source, 0, result);
    }

    public void NplexStrict(BufferedImage source, BufferedImage result) {
        if (!ImageTools.areDimensionsAndTypeEqual(source, result)) {
            throw new IllegalArgumentException("Images source and result have different type and dimensions.");
        }
        int width = source.getWidth();
        int width1 = width - 1;
        int height1 = source.getHeight() - 1;
        switch (source.getType()) {
            case 10: {
                byte[] srcbb = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                byte[] resbb = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                int y = 1;
                int pos = width + 1;
                while (y < height1) {
                    int x = 1;
                    while (x < width1) {
                        int p;
                        int v = srcbb[pos] & 0xFF;
                        boolean found = false;
                        int posnei = pos - width - 1;
                        int prev = p = srcbb[posnei] & 0xFF;
                        int first = p;
                        if (p == v) {
                            found = true;
                        }
                        int count = 1;
                        if ((p = srcbb[++posnei] & 0xFF) == v) {
                            found = true;
                        }
                        if (p != prev) {
                            ++count;
                            prev = p;
                        }
                        if ((p = srcbb[++posnei] & 0xFF) == v) {
                            found = true;
                        }
                        if (p != prev) {
                            ++count;
                            prev = p;
                        }
                        if ((p = srcbb[pos + 1] & 0xFF) == v) {
                            found = true;
                        }
                        if (p != prev) {
                            ++count;
                            prev = p;
                        }
                        if ((p = srcbb[posnei = pos + width + 1] & 0xFF) == v) {
                            found = true;
                        }
                        if (p != prev) {
                            ++count;
                            prev = p;
                        }
                        if ((p = srcbb[--posnei] & 0xFF) == v) {
                            found = true;
                        }
                        if (p != prev) {
                            ++count;
                            prev = p;
                        }
                        if ((p = srcbb[--posnei] & 0xFF) == v) {
                            found = true;
                        }
                        if (p != prev) {
                            ++count;
                            prev = p;
                        }
                        int last = p = srcbb[pos - 1] & 0xFF;
                        if (p == v) {
                            found = true;
                        }
                        if (p != prev) {
                            ++count;
                            prev = p;
                        }
                        if (2 < count && last == first) {
                            --count;
                        }
                        resbb[pos] = !found ? (byte)0 : (byte)count;
                        ++x;
                        ++pos;
                    }
                    ++y;
                    pos += 2;
                }
                resbb = null;
                srcbb = null;
                break;
            }
            case 11: {
                short[] srcsb = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                short[] ressb = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                int y = 1;
                int pos = width + 1;
                while (y < height1) {
                    int x = 1;
                    while (x < width1) {
                        int p;
                        int v = srcsb[pos] & 0xFFFF;
                        boolean found = false;
                        int posnei = pos - width - 1;
                        int prev = p = srcsb[posnei] & 0xFFFF;
                        int first = p;
                        if (p == v) {
                            found = true;
                        }
                        int count = 1;
                        if ((p = srcsb[++posnei] & 0xFFFF) == v) {
                            found = true;
                        }
                        if (p != prev) {
                            ++count;
                            prev = p;
                        }
                        if ((p = srcsb[++posnei] & 0xFFFF) == v) {
                            found = true;
                        }
                        if (p != prev) {
                            ++count;
                            prev = p;
                        }
                        if ((p = srcsb[pos + 1] & 0xFFFF) == v) {
                            found = true;
                        }
                        if (p != prev) {
                            ++count;
                            prev = p;
                        }
                        if ((p = srcsb[posnei = pos + width + 1] & 0xFFFF) == v) {
                            found = true;
                        }
                        if (p != prev) {
                            ++count;
                            prev = p;
                        }
                        if ((p = srcsb[--posnei] & 0xFFFF) == v) {
                            found = true;
                        }
                        if (p != prev) {
                            ++count;
                            prev = p;
                        }
                        if ((p = srcsb[--posnei] & 0xFFFF) == v) {
                            found = true;
                        }
                        if (p != prev) {
                            ++count;
                            prev = p;
                        }
                        int last = p = srcsb[pos - 1] & 0xFFFF;
                        if (p == v) {
                            found = true;
                        }
                        if (p != prev) {
                            ++count;
                            prev = p;
                        }
                        if (2 < count && last == first) {
                            --count;
                        }
                        ressb[pos] = !found ? (short)0 : (short)((byte)count);
                        ++x;
                        ++pos;
                    }
                    ++y;
                    pos += 2;
                }
                ressb = null;
                srcsb = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not yet supported.");
            }
        }
    }

    public double MaximumPotentialValue(BufferedImage image) {
        switch (image.getType()) {
            case 12: {
                return 1.0;
            }
            case 10: {
                return 255.0;
            }
            case 11: {
                return 65535.0;
            }
            case 5: {
                return 255.0;
            }
            case 6: {
                return 255.0;
            }
            case 0: {
                switch (image.getRaster().getDataBuffer().getDataType()) {
                    case 5: {
                        return Double.MAX_VALUE;
                    }
                    case 4: {
                        return 3.4028234663852886E38;
                    }
                    case 3: {
                        return 2.147483647E9;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported.");
            }
        }
        throw new IllegalArgumentException("Image type not supported.");
    }

    public double[] Profiler(BufferedImage image, int startx, int starty, int endx, int endy) {
        List<Coordinates> list = Bresenham.Coordinates(startx, starty, endx, endy);
        int size = list.size();
        int width = image.getWidth();
        double[] profile = new double[size];
        block0 : switch (image.getType()) {
            case 10: {
                byte[] bb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                for (int i = 0; i < size; ++i) {
                    Coordinates c = list.get(i);
                    profile[i] = bb[c.Y * width + c.X] & 0xFF;
                }
                bb = null;
                break;
            }
            case 11: {
                short[] sb = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                for (int i = 0; i < size; ++i) {
                    Coordinates c = list.get(i);
                    profile[i] = sb[c.Y * width + c.X] & 0xFFFF;
                }
                sb = null;
                break;
            }
            case 0: {
                switch (image.getRaster().getDataBuffer().getDataType()) {
                    case 5: {
                        double[] db = ((DataBufferDouble)image.getRaster().getDataBuffer()).getData();
                        for (int i = 0; i < size; ++i) {
                            Coordinates c = list.get(i);
                            profile[i] = db[c.Y * width + c.X];
                        }
                        db = null;
                        break block0;
                    }
                    case 4: {
                        float[] fb = ((DataBufferFloat)image.getRaster().getDataBuffer()).getData();
                        for (int i = 0; i < size; ++i) {
                            Coordinates c = list.get(i);
                            profile[i] = fb[c.Y * width + c.X];
                        }
                        fb = null;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported.");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        list.clear();
        list = null;
        return profile;
    }

    public long Integral() {
        return this.Integral;
    }

    public double IntegralDouble() {
        return this.IntegralDouble;
    }

    public long Size() {
        return this.Size;
    }

    public double Average() {
        return this.Average;
    }

    public double Variance() {
        return this.Variance;
    }

    public double StandardDeviation() {
        return this.StandardDeviation;
    }

    public double Kurtosis() {
        return this.Kurtosis;
    }

    public double Skewness() {
        return this.Skewness;
    }

    public double Contrast() {
        return this.Contrast;
    }

    public double Michelson() {
        return this.Michelson;
    }

    public double Minimum() {
        return this.Minimum;
    }

    public double Maximum() {
        return this.Maximum;
    }

    public int MinimumIndex() {
        return this.MinimumIndex;
    }

    public int MaximumIndex() {
        return this.MaximumIndex;
    }

    public double Rank005() {
        return this.Rank005;
    }

    public double Rank01() {
        return this.Rank01;
    }

    public double Rank025() {
        return this.Rank025;
    }

    public double Rank05() {
        return this.Rank05;
    }

    public double Rank10() {
        return this.Rank10;
    }

    public double Rank25() {
        return this.Rank25;
    }

    public double Rank50() {
        return this.Rank50;
    }

    public double Rank75() {
        return this.Rank75;
    }

    public double Rank90() {
        return this.Rank90;
    }

    public double Rank95() {
        return this.Rank95;
    }

    public double Rank975() {
        return this.Rank975;
    }

    public double Rank99() {
        return this.Rank99;
    }

    public double Rank995() {
        return this.Rank995;
    }
}

