/*
 * Decompiled with CFR 0.152.
 */
package imageTiTi;

import arrayTiTi.ArrayComparator;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import utils.strings.StringToolsImageDV;

public final class ImageComparator {
    public static final String EQUALS = "==";
    public static final String DIFFERENT = "!=";
    public static final String SUP = ">";
    public static final String SUPOREQUAL = ">=";
    public static final String INF = "<";
    public static final String INFOREQUAL = "<=";

    private static String MessageError(BufferedImage source, String operation, Object ... objects) {
        if (objects.length != 4) {
            throw new IllegalArgumentException("Bug, must not occured:  objects.length != 4.");
        }
        StringBuilder message = new StringBuilder(13);
        message.append("Configuration not supported: Compare(").append(StringToolsImageDV.NameOfType(source.getType())).append(",");
        switch (operation) {
            case "==": {
                message.append(" == ");
                break;
            }
            case "!=": {
                message.append(" != ");
                break;
            }
            case ">": {
                message.append(" > ");
                break;
            }
            case ">=": {
                message.append(" >= ");
                break;
            }
            case "<": {
                message.append(" < ");
                break;
            }
            case "<=": {
                message.append(" <= ");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operation: " + operation);
            }
        }
        message.append(", ");
        for (int i = 0; i < objects.length; ++i) {
            if (objects[i] instanceof BufferedImage) {
                message.append(StringToolsImageDV.NameOfType(((BufferedImage)objects[i]).getType()));
                if (((BufferedImage)objects[i]).getType() == 0) {
                    message.append(" (").append(StringToolsImageDV.NameOfDataBufferType((BufferedImage)objects[i])).append("), ");
                    continue;
                }
                message.append(", ");
                continue;
            }
            if (objects[i] instanceof Integer) {
                message.append("int, ");
                continue;
            }
            throw new IllegalArgumentException("Bug:  parameter " + i + " is not neither BufferedImage, neither Integer.");
        }
        message.setCharAt(message.length() - 2, ')');
        message.setCharAt(message.length() - 1, ';');
        return message.toString();
    }

    public static void Compare(BufferedImage source, String operation, BufferedImage comparison, BufferedImage thenvalues, BufferedImage elsevalues, BufferedImage result) {
        if (!ImageTools.areDimensionsEqual(source, comparison)) {
            throw new IllegalArgumentException("source and comparison images must have identic dimensions.");
        }
        if (!ImageTools.areDimensionsEqual(source, thenvalues)) {
            throw new IllegalArgumentException("source and thenvalues images must have identic dimensions.");
        }
        if (!ImageTools.areDimensionsEqual(source, elsevalues)) {
            throw new IllegalArgumentException("source and elsevalues images must have identic dimensions.");
        }
        if (!ImageTools.areDimensionsEqual(source, result)) {
            throw new IllegalArgumentException("source and result images must have identic dimensions.");
        }
        block0 : switch (source.getType()) {
            case 12: {
                if (comparison.getType() != 12) {
                    throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                }
                if (thenvalues.getType() != 12 || elsevalues.getType() != 12 || result.getType() != 12) {
                    throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                }
                ArrayComparator.CompareBinaries(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), operation, ((DataBufferByte)comparison.getRaster().getDataBuffer()).getData(), ((DataBufferByte)thenvalues.getRaster().getDataBuffer()).getData(), ((DataBufferByte)elsevalues.getRaster().getDataBuffer()).getData(), ((DataBufferByte)result.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight());
                break;
            }
            case 10: {
                switch (comparison.getType()) {
                    case 10: {
                        if (thenvalues.getType() != 10 || elsevalues.getType() != 10 || result.getType() != 10) {
                            throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                        }
                        ArrayComparator.CompareUnsigned(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), operation, ((DataBufferByte)comparison.getRaster().getDataBuffer()).getData(), ((DataBufferByte)thenvalues.getRaster().getDataBuffer()).getData(), ((DataBufferByte)elsevalues.getRaster().getDataBuffer()).getData(), ((DataBufferByte)result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                    case 11: {
                        if (thenvalues.getType() != 10 || elsevalues.getType() != 11 || result.getType() != 11) {
                            throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                        }
                        ArrayComparator.CompareUnsigned(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), operation, ((DataBufferUShort)comparison.getRaster().getDataBuffer()).getData(), ((DataBufferByte)thenvalues.getRaster().getDataBuffer()).getData(), ((DataBufferUShort)elsevalues.getRaster().getDataBuffer()).getData(), ((DataBufferUShort)result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                }
                throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
            }
            case 11: {
                if (comparison.getType() != 11 || thenvalues.getType() != 11 || elsevalues.getType() != 11 || result.getType() != 11) {
                    throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                }
                ArrayComparator.CompareUnsigned(((DataBufferUShort)source.getRaster().getDataBuffer()).getData(), operation, ((DataBufferUShort)comparison.getRaster().getDataBuffer()).getData(), ((DataBufferUShort)thenvalues.getRaster().getDataBuffer()).getData(), ((DataBufferUShort)elsevalues.getRaster().getDataBuffer()).getData(), ((DataBufferUShort)result.getRaster().getDataBuffer()).getData());
                break;
            }
            case 0: {
                switch (source.getRaster().getDataBuffer().getDataType()) {
                    case 5: {
                        if (comparison.getRaster().getDataBuffer().getDataType() != 5 || thenvalues.getRaster().getDataBuffer().getDataType() != 5 || elsevalues.getRaster().getDataBuffer().getDataType() != 5 || result.getRaster().getDataBuffer().getDataType() != 5) {
                            throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                        }
                        ArrayComparator.Compare(((DataBufferDouble)source.getRaster().getDataBuffer()).getData(), operation, ((DataBufferDouble)comparison.getRaster().getDataBuffer()).getData(), ((DataBufferDouble)thenvalues.getRaster().getDataBuffer()).getData(), ((DataBufferDouble)elsevalues.getRaster().getDataBuffer()).getData(), ((DataBufferDouble)result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                    case 4: {
                        if (comparison.getRaster().getDataBuffer().getDataType() != 4 || thenvalues.getRaster().getDataBuffer().getDataType() != 4 || elsevalues.getRaster().getDataBuffer().getDataType() != 4 || result.getRaster().getDataBuffer().getDataType() != 4) {
                            throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                        }
                        ArrayComparator.Compare(((DataBufferFloat)source.getRaster().getDataBuffer()).getData(), operation, ((DataBufferFloat)comparison.getRaster().getDataBuffer()).getData(), ((DataBufferFloat)thenvalues.getRaster().getDataBuffer()).getData(), ((DataBufferFloat)elsevalues.getRaster().getDataBuffer()).getData(), ((DataBufferFloat)result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                    case 3: {
                        switch (comparison.getType()) {
                            case 10: {
                                if (thenvalues.getRaster().getDataBuffer().getDataType() != 3 || elsevalues.getType() != 10 || result.getType() != 10) {
                                    throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                                }
                                ArrayComparator.CompareUnsigned(((DataBufferInt)source.getRaster().getDataBuffer()).getData(), operation, ((DataBufferByte)comparison.getRaster().getDataBuffer()).getData(), ((DataBufferInt)thenvalues.getRaster().getDataBuffer()).getData(), ((DataBufferByte)elsevalues.getRaster().getDataBuffer()).getData(), ((DataBufferByte)result.getRaster().getDataBuffer()).getData());
                                break block0;
                            }
                            case 0: {
                                if (comparison.getRaster().getDataBuffer().getDataType() != 3 || thenvalues.getRaster().getDataBuffer().getDataType() != 3 || elsevalues.getRaster().getDataBuffer().getDataType() != 3 || result.getRaster().getDataBuffer().getDataType() != 3) {
                                    throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                                }
                                ArrayComparator.Compare(((DataBufferInt)source.getRaster().getDataBuffer()).getData(), operation, ((DataBufferInt)comparison.getRaster().getDataBuffer()).getData(), ((DataBufferInt)thenvalues.getRaster().getDataBuffer()).getData(), ((DataBufferInt)elsevalues.getRaster().getDataBuffer()).getData(), ((DataBufferInt)result.getRaster().getDataBuffer()).getData());
                                break block0;
                            }
                        }
                        throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
            }
        }
    }

    public static void Compare(BufferedImage source, String operation, BufferedImage comparison, BufferedImage thenvalues, int elsevalues, BufferedImage result) {
        if (!ImageTools.areDimensionsEqual(source, comparison)) {
            throw new IllegalArgumentException("source and comparison images must have identic dimensions.");
        }
        if (!ImageTools.areDimensionsEqual(source, thenvalues)) {
            throw new IllegalArgumentException("source and thenvalues images must have identic dimensions.");
        }
        if (!ImageTools.areDimensionsEqual(source, result)) {
            throw new IllegalArgumentException("source and result images must have identic dimensions.");
        }
        block0 : switch (source.getType()) {
            case 10: {
                if (comparison.getType() != 10) {
                    throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                }
                switch (thenvalues.getType()) {
                    case 12: {
                        if (result.getType() != 12) {
                            throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                        }
                        ArrayComparator.CompareUnsignedBinaries(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), operation, ((DataBufferByte)comparison.getRaster().getDataBuffer()).getData(), ((DataBufferByte)thenvalues.getRaster().getDataBuffer()).getData(), elsevalues, ((DataBufferByte)result.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight());
                        break block0;
                    }
                    case 10: {
                        if (result.getType() != 10) {
                            throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                        }
                        ArrayComparator.CompareUnsigned(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), operation, ((DataBufferByte)comparison.getRaster().getDataBuffer()).getData(), ((DataBufferByte)thenvalues.getRaster().getDataBuffer()).getData(), (byte)elsevalues, ((DataBufferByte)result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                }
                throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
            }
            case 11: {
                if (comparison.getType() != 11) {
                    throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                }
                switch (thenvalues.getType()) {
                    case 12: {
                        if (result.getType() != 12) {
                            throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                        }
                        ArrayComparator.CompareUnsignedBinaries(((DataBufferUShort)source.getRaster().getDataBuffer()).getData(), operation, ((DataBufferUShort)comparison.getRaster().getDataBuffer()).getData(), ((DataBufferByte)thenvalues.getRaster().getDataBuffer()).getData(), elsevalues, ((DataBufferByte)result.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight());
                        break block0;
                    }
                    case 10: {
                        if (result.getType() != 10) {
                            throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                        }
                        ArrayComparator.CompareUnsigned(((DataBufferUShort)source.getRaster().getDataBuffer()).getData(), operation, ((DataBufferUShort)comparison.getRaster().getDataBuffer()).getData(), ((DataBufferByte)thenvalues.getRaster().getDataBuffer()).getData(), (byte)elsevalues, ((DataBufferByte)result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                    case 11: {
                        if (result.getType() != 11) {
                            throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                        }
                        ArrayComparator.CompareUnsigned(((DataBufferUShort)source.getRaster().getDataBuffer()).getData(), operation, ((DataBufferUShort)comparison.getRaster().getDataBuffer()).getData(), ((DataBufferUShort)thenvalues.getRaster().getDataBuffer()).getData(), (short)elsevalues, ((DataBufferUShort)result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                }
                throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
            }
            case 0: {
                switch (source.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        switch (comparison.getType()) {
                            case 10: {
                                if (thenvalues.getRaster().getDataBuffer().getDataType() != 3 || result.getRaster().getDataBuffer().getDataType() != 3) {
                                    throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                                }
                                ArrayComparator.CompareUnsigned(((DataBufferInt)source.getRaster().getDataBuffer()).getData(), operation, ((DataBufferByte)comparison.getRaster().getDataBuffer()).getData(), ((DataBufferInt)thenvalues.getRaster().getDataBuffer()).getData(), elsevalues, ((DataBufferInt)result.getRaster().getDataBuffer()).getData());
                                break block0;
                            }
                            case 0: {
                                if (comparison.getRaster().getDataBuffer().getDataType() != 3) {
                                    throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                                }
                                switch (thenvalues.getType()) {
                                    case 12: {
                                        if (result.getType() != 12) {
                                            throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                                        }
                                        ArrayComparator.CompareBinary(((DataBufferInt)source.getRaster().getDataBuffer()).getData(), operation, ((DataBufferInt)comparison.getRaster().getDataBuffer()).getData(), ((DataBufferByte)thenvalues.getRaster().getDataBuffer()).getData(), elsevalues, ((DataBufferByte)result.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight());
                                        break block0;
                                    }
                                    case 0: {
                                        if (result.getType() != 0) {
                                            throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                                        }
                                        switch (thenvalues.getRaster().getDataBuffer().getDataType()) {
                                            case 3: {
                                                if (result.getRaster().getDataBuffer().getDataType() != 3) {
                                                    throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                                                }
                                                ArrayComparator.Compare(((DataBufferInt)source.getRaster().getDataBuffer()).getData(), operation, ((DataBufferInt)comparison.getRaster().getDataBuffer()).getData(), ((DataBufferInt)thenvalues.getRaster().getDataBuffer()).getData(), elsevalues, ((DataBufferInt)result.getRaster().getDataBuffer()).getData());
                                                break block0;
                                            }
                                        }
                                        throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                                    }
                                }
                                throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                            }
                        }
                        break block0;
                    }
                }
                throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
            }
            default: {
                throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
            }
        }
    }

    public static void Compare(BufferedImage source, String operation, BufferedImage comparison, int thenvalues, int elsevalues, BufferedImage result) {
        if (!ImageTools.areDimensionsEqual(source, comparison)) {
            throw new IllegalArgumentException("source and comparison images must have identic dimensions.");
        }
        if (!ImageTools.areDimensionsEqual(source, result)) {
            throw new IllegalArgumentException("source and result images must have identic dimensions.");
        }
        block0 : switch (source.getType()) {
            case 10: {
                switch (comparison.getType()) {
                    case 10: {
                        switch (result.getType()) {
                            case 12: {
                                ArrayComparator.CompareUnsignedBinary(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), operation, ((DataBufferByte)comparison.getRaster().getDataBuffer()).getData(), thenvalues, elsevalues, ((DataBufferByte)result.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight());
                                break block0;
                            }
                            case 10: {
                                ArrayComparator.CompareUnsigned(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), operation, ((DataBufferByte)comparison.getRaster().getDataBuffer()).getData(), (byte)thenvalues, (byte)elsevalues, ((DataBufferByte)result.getRaster().getDataBuffer()).getData());
                                break block0;
                            }
                        }
                        throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                    }
                    case 11: {
                        switch (result.getType()) {
                            case 12: {
                                ArrayComparator.CompareUnsignedBinary(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), operation, ((DataBufferUShort)comparison.getRaster().getDataBuffer()).getData(), thenvalues, elsevalues, ((DataBufferByte)result.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight());
                                break;
                            }
                            case 10: {
                                ArrayComparator.CompareUnsigned(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), operation, ((DataBufferUShort)comparison.getRaster().getDataBuffer()).getData(), (byte)thenvalues, (byte)elsevalues, ((DataBufferByte)result.getRaster().getDataBuffer()).getData());
                                break;
                            }
                            case 11: {
                                ArrayComparator.CompareUnsigned(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), operation, ((DataBufferUShort)comparison.getRaster().getDataBuffer()).getData(), (short)thenvalues, (short)elsevalues, ((DataBufferUShort)result.getRaster().getDataBuffer()).getData());
                            }
                        }
                        break block0;
                    }
                }
                throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
            }
            case 11: {
                if (comparison.getType() != 11) {
                    throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                }
                switch (result.getType()) {
                    case 12: {
                        ArrayComparator.CompareUnsignedBinary(((DataBufferUShort)source.getRaster().getDataBuffer()).getData(), operation, ((DataBufferUShort)comparison.getRaster().getDataBuffer()).getData(), thenvalues, elsevalues, ((DataBufferByte)result.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight());
                        break block0;
                    }
                    case 11: {
                        ArrayComparator.CompareUnsigned(((DataBufferUShort)source.getRaster().getDataBuffer()).getData(), operation, ((DataBufferUShort)comparison.getRaster().getDataBuffer()).getData(), (short)thenvalues, (short)elsevalues, ((DataBufferUShort)result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                }
                throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
            }
            default: {
                throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
            }
        }
    }

    public static void Compare(BufferedImage source, String operation, int comparison, BufferedImage thenvalues, BufferedImage elsevalues, BufferedImage result) {
        if (!ImageTools.areDimensionsEqual(source, thenvalues)) {
            throw new IllegalArgumentException("source and thenvalues images must have identic dimensions.");
        }
        if (!ImageTools.areDimensionsEqual(source, elsevalues)) {
            throw new IllegalArgumentException("source and elsevalues images must have identic dimensions.");
        }
        if (!ImageTools.areDimensionsEqual(source, result)) {
            throw new IllegalArgumentException("source and result images must have identic dimensions.");
        }
        block0 : switch (source.getType()) {
            case 12: {
                switch (thenvalues.getType()) {
                    case 12: {
                        if (elsevalues.getType() != 12 || result.getType() != 12) {
                            throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                        }
                        ArrayComparator.CompareBinaries(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), operation, comparison, ((DataBufferByte)thenvalues.getRaster().getDataBuffer()).getData(), ((DataBufferByte)elsevalues.getRaster().getDataBuffer()).getData(), ((DataBufferByte)result.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight());
                        break block0;
                    }
                    case 10: {
                        switch (elsevalues.getType()) {
                            case 10: {
                                if (result.getType() != 10) {
                                    throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                                }
                                ArrayComparator.CompareBinary(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), operation, comparison, ((DataBufferByte)thenvalues.getRaster().getDataBuffer()).getData(), ((DataBufferByte)elsevalues.getRaster().getDataBuffer()).getData(), ((DataBufferByte)result.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight());
                                break block0;
                            }
                            case 11: {
                                if (result.getType() != 11) {
                                    throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                                }
                                ArrayComparator.CompareBinary(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), operation, comparison, ((DataBufferByte)thenvalues.getRaster().getDataBuffer()).getData(), ((DataBufferUShort)elsevalues.getRaster().getDataBuffer()).getData(), ((DataBufferUShort)result.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight());
                                break block0;
                            }
                        }
                        throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                    }
                    case 11: {
                        if (elsevalues.getType() != 11 || result.getType() != 11) {
                            throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                        }
                        ArrayComparator.CompareBinary(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), operation, comparison, ((DataBufferUShort)thenvalues.getRaster().getDataBuffer()).getData(), ((DataBufferUShort)elsevalues.getRaster().getDataBuffer()).getData(), ((DataBufferUShort)result.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight());
                        break block0;
                    }
                }
                throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
            }
            case 10: {
                switch (thenvalues.getType()) {
                    case 10: {
                        switch (elsevalues.getType()) {
                            case 10: {
                                if (result.getType() != 10) {
                                    throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                                }
                                ArrayComparator.CompareUnsigned(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), operation, comparison, ((DataBufferByte)thenvalues.getRaster().getDataBuffer()).getData(), ((DataBufferByte)elsevalues.getRaster().getDataBuffer()).getData(), ((DataBufferByte)result.getRaster().getDataBuffer()).getData());
                                break block0;
                            }
                        }
                        throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                    }
                }
                throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
            }
            case 11: {
                switch (thenvalues.getType()) {
                    case 10: {
                        if (elsevalues.getType() != 10 || result.getType() != 10) {
                            throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                        }
                        ArrayComparator.CompareUnsigned(((DataBufferUShort)source.getRaster().getDataBuffer()).getData(), operation, comparison, ((DataBufferByte)thenvalues.getRaster().getDataBuffer()).getData(), ((DataBufferByte)elsevalues.getRaster().getDataBuffer()).getData(), ((DataBufferByte)result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                    case 11: {
                        if (elsevalues.getType() != 11 || result.getType() != 11) {
                            throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                        }
                        ArrayComparator.CompareUnsigned(((DataBufferUShort)source.getRaster().getDataBuffer()).getData(), operation, comparison, ((DataBufferUShort)thenvalues.getRaster().getDataBuffer()).getData(), ((DataBufferUShort)elsevalues.getRaster().getDataBuffer()).getData(), ((DataBufferUShort)result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                    case 0: {
                        switch (thenvalues.getRaster().getDataBuffer().getDataType()) {
                            case 3: {
                                if (elsevalues.getRaster().getDataBuffer().getDataType() != 3 || result.getRaster().getDataBuffer().getDataType() != 3) {
                                    throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                                }
                                ArrayComparator.CompareUnsigned(((DataBufferUShort)source.getRaster().getDataBuffer()).getData(), operation, comparison, ((DataBufferInt)thenvalues.getRaster().getDataBuffer()).getData(), ((DataBufferInt)elsevalues.getRaster().getDataBuffer()).getData(), ((DataBufferInt)result.getRaster().getDataBuffer()).getData());
                                break block0;
                            }
                        }
                        throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                    }
                }
                throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
            }
            default: {
                throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
            }
        }
    }

    public static void Compare(BufferedImage source, String operation, int comparison, BufferedImage thenvalues, int elsevalues, BufferedImage result) {
        if (!ImageTools.areDimensionsEqual(source, thenvalues)) {
            throw new IllegalArgumentException("source and thenvalues images must have identic dimensions.");
        }
        if (!ImageTools.areDimensionsEqual(source, result)) {
            throw new IllegalArgumentException("source and result images must have identic dimensions.");
        }
        block0 : switch (source.getType()) {
            case 12: {
                switch (thenvalues.getType()) {
                    case 10: {
                        if (result.getType() != 10) {
                            throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                        }
                        ArrayComparator.CompareBinary(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), operation, comparison, ((DataBufferByte)thenvalues.getRaster().getDataBuffer()).getData(), elsevalues, ((DataBufferByte)result.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight());
                        break block0;
                    }
                    case 11: {
                        if (result.getType() != 11) {
                            throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                        }
                        ArrayComparator.CompareBinary(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), operation, comparison, ((DataBufferUShort)thenvalues.getRaster().getDataBuffer()).getData(), elsevalues, ((DataBufferUShort)result.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight());
                        break block0;
                    }
                }
                throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
            }
            case 10: {
                switch (thenvalues.getType()) {
                    case 12: {
                        if (result.getType() != 12) {
                            throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                        }
                        ArrayComparator.CompareUnsignedBinary(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), operation, comparison, ((DataBufferByte)thenvalues.getRaster().getDataBuffer()).getData(), elsevalues, ((DataBufferByte)result.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight());
                        break block0;
                    }
                    case 10: {
                        switch (result.getType()) {
                            case 10: {
                                ArrayComparator.CompareUnsigned(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), operation, comparison, ((DataBufferByte)thenvalues.getRaster().getDataBuffer()).getData(), (byte)elsevalues, ((DataBufferByte)result.getRaster().getDataBuffer()).getData());
                                break block0;
                            }
                            case 0: {
                                switch (result.getRaster().getDataBuffer().getDataType()) {
                                    case 3: {
                                        ArrayComparator.CompareUnsigned(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), operation, comparison, ((DataBufferByte)thenvalues.getRaster().getDataBuffer()).getData(), elsevalues, ((DataBufferInt)result.getRaster().getDataBuffer()).getData());
                                        break block0;
                                    }
                                }
                                throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                            }
                        }
                        throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                    }
                    case 11: {
                        if (result.getType() != 11) {
                            throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                        }
                        ArrayComparator.CompareUnsigned(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), operation, comparison, ((DataBufferUShort)thenvalues.getRaster().getDataBuffer()).getData(), (short)elsevalues, ((DataBufferUShort)result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                    case 5: {
                        if (result.getType() != 5) {
                            throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                        }
                        ArrayComparator.CompareUnsigned(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), operation, comparison, ((DataBufferByte)thenvalues.getRaster().getDataBuffer()).getData(), (byte)elsevalues, ((DataBufferByte)result.getRaster().getDataBuffer()).getData(), 3);
                        break block0;
                    }
                    case 0: {
                        switch (thenvalues.getRaster().getDataBuffer().getDataType()) {
                            case 3: {
                                if (result.getType() != 0 || thenvalues.getRaster().getDataBuffer().getDataType() != 3) {
                                    throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                                }
                                ArrayComparator.CompareUnsigned(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), operation, comparison, ((DataBufferInt)thenvalues.getRaster().getDataBuffer()).getData(), elsevalues, ((DataBufferInt)result.getRaster().getDataBuffer()).getData());
                                break block0;
                            }
                        }
                        throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                    }
                }
                throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
            }
            case 11: {
                switch (thenvalues.getType()) {
                    case 10: {
                        if (result.getType() != 10) {
                            throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                        }
                        ArrayComparator.CompareUnsigned(((DataBufferUShort)source.getRaster().getDataBuffer()).getData(), operation, comparison, ((DataBufferByte)thenvalues.getRaster().getDataBuffer()).getData(), (byte)elsevalues, ((DataBufferByte)result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                    case 11: {
                        if (result.getType() != 11) {
                            throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                        }
                        ArrayComparator.CompareUnsigned(((DataBufferUShort)source.getRaster().getDataBuffer()).getData(), operation, comparison, ((DataBufferUShort)thenvalues.getRaster().getDataBuffer()).getData(), (short)elsevalues, ((DataBufferUShort)result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                    case 0: {
                        switch (thenvalues.getRaster().getDataBuffer().getDataType()) {
                            case 3: {
                                if (result.getRaster().getDataBuffer().getDataType() != 3) {
                                    throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                                }
                                ArrayComparator.CompareUnsigned(((DataBufferUShort)source.getRaster().getDataBuffer()).getData(), operation, comparison, ((DataBufferInt)thenvalues.getRaster().getDataBuffer()).getData(), elsevalues, ((DataBufferInt)result.getRaster().getDataBuffer()).getData());
                                break block0;
                            }
                        }
                        throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                    }
                }
                throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
            }
            case 0: {
                switch (source.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        switch (thenvalues.getType()) {
                            case 10: {
                                if (result.getType() != 10) {
                                    throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                                }
                                ArrayComparator.Compare(((DataBufferInt)source.getRaster().getDataBuffer()).getData(), operation, comparison, ((DataBufferByte)thenvalues.getRaster().getDataBuffer()).getData(), (int)((byte)elsevalues), ((DataBufferByte)result.getRaster().getDataBuffer()).getData());
                                break block0;
                            }
                            case 11: {
                                if (result.getType() != 11) {
                                    throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                                }
                                ArrayComparator.Compare(((DataBufferInt)source.getRaster().getDataBuffer()).getData(), operation, comparison, ((DataBufferUShort)thenvalues.getRaster().getDataBuffer()).getData(), (short)elsevalues, ((DataBufferUShort)result.getRaster().getDataBuffer()).getData());
                                break block0;
                            }
                            case 0: {
                                switch (thenvalues.getRaster().getDataBuffer().getDataType()) {
                                    case 3: {
                                        if (result.getRaster().getDataBuffer().getDataType() != 3) {
                                            throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                                        }
                                        ArrayComparator.Compare(((DataBufferInt)source.getRaster().getDataBuffer()).getData(), operation, comparison, ((DataBufferInt)thenvalues.getRaster().getDataBuffer()).getData(), elsevalues, ((DataBufferInt)result.getRaster().getDataBuffer()).getData());
                                        break block0;
                                    }
                                }
                                throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                            }
                        }
                        throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                    }
                    case 5: {
                        if (thenvalues.getRaster().getDataBuffer().getDataType() != 5 || result.getRaster().getDataBuffer().getDataType() != 5) {
                            throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                        }
                        ArrayComparator.Compare(((DataBufferDouble)source.getRaster().getDataBuffer()).getData(), operation, (double)comparison, ((DataBufferDouble)thenvalues.getRaster().getDataBuffer()).getData(), (double)elsevalues, ((DataBufferDouble)result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                }
                throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
            }
            default: {
                throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
            }
        }
    }

    public static void Compare(BufferedImage source, String operation, int comparison, int thenvalues, int elsevalues, BufferedImage result) {
        if (!ImageTools.areDimensionsEqual(source, result)) {
            throw new IllegalArgumentException("source and result images must have identic dimensions.");
        }
        block0 : switch (source.getType()) {
            case 12: {
                switch (result.getType()) {
                    case 12: {
                        ArrayComparator.CompareBinaries(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), operation, comparison, thenvalues, elsevalues, ((DataBufferByte)result.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight());
                        break block0;
                    }
                    case 10: {
                        ArrayComparator.CompareBinary(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), operation, comparison, thenvalues, elsevalues, ((DataBufferByte)result.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight());
                        break block0;
                    }
                    case 11: {
                        ArrayComparator.CompareBinary(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), operation, comparison, thenvalues, elsevalues, ((DataBufferUShort)result.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight());
                        break block0;
                    }
                }
                throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
            }
            case 10: {
                switch (result.getType()) {
                    case 12: {
                        ArrayComparator.CompareUnsignedBinary(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), operation, comparison, thenvalues, elsevalues, ((DataBufferByte)result.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight());
                        break block0;
                    }
                    case 10: {
                        ArrayComparator.CompareUnsigned(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), operation, comparison, (byte)thenvalues, (byte)elsevalues, ((DataBufferByte)result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                    case 11: {
                        ArrayComparator.CompareUnsigned(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), operation, comparison, (short)thenvalues, (short)elsevalues, ((DataBufferUShort)result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                    case 0: {
                        switch (result.getRaster().getDataBuffer().getDataType()) {
                            case 3: {
                                ArrayComparator.CompareUnsigned(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), operation, comparison, thenvalues, elsevalues, ((DataBufferInt)result.getRaster().getDataBuffer()).getData());
                                break block0;
                            }
                        }
                        throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                    }
                }
                throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
            }
            case 11: {
                switch (result.getType()) {
                    case 12: {
                        ArrayComparator.CompareUnsignedBinary(((DataBufferUShort)source.getRaster().getDataBuffer()).getData(), operation, comparison, thenvalues, elsevalues, ((DataBufferByte)result.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight());
                        break block0;
                    }
                    case 10: {
                        ArrayComparator.CompareUnsigned(((DataBufferUShort)source.getRaster().getDataBuffer()).getData(), operation, comparison, (byte)thenvalues, (byte)elsevalues, ((DataBufferByte)result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                    case 11: {
                        ArrayComparator.CompareUnsigned(((DataBufferUShort)source.getRaster().getDataBuffer()).getData(), operation, comparison, (short)thenvalues, (short)elsevalues, ((DataBufferUShort)result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                    case 0: {
                        switch (result.getRaster().getDataBuffer().getDataType()) {
                            case 3: {
                                ArrayComparator.CompareUnsigned(((DataBufferUShort)source.getRaster().getDataBuffer()).getData(), operation, comparison, thenvalues, elsevalues, ((DataBufferInt)result.getRaster().getDataBuffer()).getData());
                                break block0;
                            }
                        }
                        throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                    }
                }
                throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
            }
            case 0: {
                switch (result.getType()) {
                    case 12: {
                        ArrayComparator.CompareBinary(((DataBufferInt)source.getRaster().getDataBuffer()).getData(), operation, comparison, thenvalues, elsevalues, ((DataBufferByte)result.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight());
                        break block0;
                    }
                    case 10: {
                        switch (source.getRaster().getDataBuffer().getDataType()) {
                            case 3: {
                                ArrayComparator.Compare(((DataBufferInt)source.getRaster().getDataBuffer()).getData(), operation, comparison, (byte)thenvalues, (byte)elsevalues, ((DataBufferByte)result.getRaster().getDataBuffer()).getData());
                                break block0;
                            }
                        }
                        throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                    }
                    case 0: {
                        switch (source.getRaster().getDataBuffer().getDataType()) {
                            case 3: {
                                if (result.getRaster().getDataBuffer().getDataType() != 3) {
                                    throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                                }
                                ArrayComparator.Compare(((DataBufferInt)source.getRaster().getDataBuffer()).getData(), operation, comparison, thenvalues, elsevalues, ((DataBufferInt)result.getRaster().getDataBuffer()).getData());
                            }
                        }
                        break block0;
                    }
                }
                throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
            }
            default: {
                throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
            }
        }
    }

    public static void Compare(BufferedImage source, String operation, int comparison, float thenvalue, float elsevalue, float[] result) {
        if (source.getRaster().getDataBuffer().getSize() != result.length) {
            throw new IllegalArgumentException("The image and the array have different dimensions.");
        }
        block0 : switch (source.getType()) {
            case 10: {
                ArrayComparator.CompareUnsigned(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), operation, comparison, thenvalue, elsevalue, result);
                break;
            }
            case 11: {
                ArrayComparator.CompareUnsigned(((DataBufferUShort)source.getRaster().getDataBuffer()).getData(), operation, comparison, thenvalue, elsevalue, result);
                break;
            }
            case 0: {
                switch (source.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        ArrayComparator.Compare(((DataBufferInt)source.getRaster().getDataBuffer()).getData(), operation, comparison, thenvalue, elsevalue, result);
                        break block0;
                    }
                }
                throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, Float.valueOf(thenvalue), Float.valueOf(elsevalue), result));
            }
            default: {
                throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, Float.valueOf(thenvalue), Float.valueOf(elsevalue), result));
            }
        }
    }

    public static void Compare(BufferedImage source, String operation, int comparison, double thenvalue, double elsevalue, double[] result) {
        if (source.getRaster().getDataBuffer().getSize() != result.length) {
            throw new IllegalArgumentException("The image and the array have different dimensions.");
        }
        block0 : switch (source.getType()) {
            case 10: {
                ArrayComparator.CompareUnsigned(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), operation, comparison, thenvalue, elsevalue, result);
                break;
            }
            case 11: {
                ArrayComparator.CompareUnsigned(((DataBufferUShort)source.getRaster().getDataBuffer()).getData(), operation, comparison, thenvalue, elsevalue, result);
                break;
            }
            case 0: {
                switch (source.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        ArrayComparator.Compare(((DataBufferInt)source.getRaster().getDataBuffer()).getData(), operation, comparison, thenvalue, elsevalue, result);
                        break block0;
                    }
                }
                throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalue, elsevalue, result));
            }
            default: {
                throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalue, elsevalue, result));
            }
        }
    }

    public static void Compare(BufferedImage source, String operation, int comparison, int thenvalue, int elsevalue, int[] result) {
        if (source.getRaster().getDataBuffer().getSize() != result.length) {
            throw new IllegalArgumentException("The image and the array have different dimensions.");
        }
        block0 : switch (source.getType()) {
            case 10: {
                ArrayComparator.CompareUnsigned(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), operation, comparison, thenvalue, elsevalue, result);
                break;
            }
            case 11: {
                ArrayComparator.CompareUnsigned(((DataBufferUShort)source.getRaster().getDataBuffer()).getData(), operation, comparison, thenvalue, elsevalue, result);
                break;
            }
            case 0: {
                switch (source.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        ArrayComparator.Compare(((DataBufferInt)source.getRaster().getDataBuffer()).getData(), operation, comparison, thenvalue, elsevalue, result);
                        break block0;
                    }
                }
                throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalue, elsevalue, result));
            }
            default: {
                throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalue, elsevalue, result));
            }
        }
    }

    public static void Compare(BufferedImage source, String operation, int comparison, double[] thenvalues, double elsevalue, double[] result) {
        if (source.getRaster().getDataBuffer().getSize() != result.length) {
            throw new IllegalArgumentException("The image and the array have different dimensions.");
        }
        block0 : switch (source.getType()) {
            case 10: {
                ArrayComparator.CompareUnsigned(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), operation, comparison, thenvalues, elsevalue, result);
                break;
            }
            case 11: {
                ArrayComparator.CompareUnsigned(((DataBufferUShort)source.getRaster().getDataBuffer()).getData(), operation, comparison, thenvalues, elsevalue, result);
                break;
            }
            case 0: {
                switch (source.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        ArrayComparator.Compare(((DataBufferInt)source.getRaster().getDataBuffer()).getData(), operation, comparison, thenvalues, elsevalue, result);
                        break block0;
                    }
                }
                throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalue, result));
            }
            default: {
                throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalue, result));
            }
        }
    }

    public static void Compare(BufferedImage source, String operation, int comparison, float[] thenvalues, float elsevalue, float[] result) {
        if (source.getRaster().getDataBuffer().getSize() != result.length) {
            throw new IllegalArgumentException("The image and the array have different dimensions.");
        }
        block0 : switch (source.getType()) {
            case 10: {
                ArrayComparator.CompareUnsigned(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), operation, comparison, thenvalues, elsevalue, result);
                break;
            }
            case 11: {
                ArrayComparator.CompareUnsigned(((DataBufferUShort)source.getRaster().getDataBuffer()).getData(), operation, comparison, thenvalues, elsevalue, result);
                break;
            }
            case 0: {
                switch (source.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        ArrayComparator.Compare(((DataBufferInt)source.getRaster().getDataBuffer()).getData(), operation, comparison, thenvalues, elsevalue, result);
                        break block0;
                    }
                }
                throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, Float.valueOf(elsevalue), result));
            }
            default: {
                throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, Float.valueOf(elsevalue), result));
            }
        }
    }

    public static void Compare(BufferedImage source, String operation, int comparison, int[] thenvalues, int elsevalue, int[] result) {
        if (source.getRaster().getDataBuffer().getSize() != result.length) {
            throw new IllegalArgumentException("The image and the array have different dimensions.");
        }
        block0 : switch (source.getType()) {
            case 10: {
                ArrayComparator.CompareUnsigned(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), operation, comparison, thenvalues, elsevalue, result);
                break;
            }
            case 11: {
                ArrayComparator.CompareUnsigned(((DataBufferUShort)source.getRaster().getDataBuffer()).getData(), operation, comparison, thenvalues, elsevalue, result);
                break;
            }
            case 0: {
                switch (source.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        ArrayComparator.Compare(((DataBufferInt)source.getRaster().getDataBuffer()).getData(), operation, comparison, thenvalues, elsevalue, result);
                        break block0;
                    }
                }
                throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalue, result));
            }
            default: {
                throw new IllegalArgumentException(ImageComparator.MessageError(source, operation, comparison, thenvalues, elsevalue, result));
            }
        }
    }
}

