/*
 * Decompiled with CFR 0.152.
 */
package ij.util;

public class FloatArray {
    private int size;
    private float[] data;

    public FloatArray() {
        this(100);
    }

    public FloatArray(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal FloatArray Capacity: " + initialCapacity);
        }
        this.data = new float[initialCapacity];
    }

    public int size() {
        return this.size;
    }

    public float[] toArray() {
        float[] out = new float[this.size];
        System.arraycopy(this.data, 0, out, 0, this.size);
        return out;
    }

    public float get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("FloatArray Index out of Bounds: " + index);
        }
        return this.data[index];
    }

    public float set(int index, float value) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("FloatArray Index out of Bounds: " + index);
        }
        float previousValue = this.data[index];
        this.data[index] = value;
        return previousValue;
    }

    public int add(float value) {
        if (this.size >= this.data.length) {
            float[] newData = new float[this.size * 2 + 50];
            System.arraycopy(this.data, 0, newData, 0, this.size);
            this.data = newData;
        }
        this.data[this.size++] = value;
        return this.size;
    }

    public void trimToSize() {
        this.data = this.toArray();
    }
}

