/*
 * Decompiled with CFR 0.152.
 */
package dv;

import dv.DV;

public class DvTools {
    public static boolean areEqual(DV dv1, DV dv2) {
        if (!DvTools.areDimensionsAndTypeEqual(dv1, dv2)) {
            return false;
        }
        switch (dv1.Type) {
            case 8: {
                for (int c = 0; c < dv1.Channel; ++c) {
                    byte[] bb1 = dv1.getDataBufferByte(c);
                    byte[] bb2 = dv2.getDataBufferByte(c);
                    for (int x = 0; x < bb1.length; ++x) {
                        if (bb1[x] == bb2[x]) continue;
                        bb2 = null;
                        bb1 = null;
                        return false;
                    }
                    bb2 = null;
                    bb1 = null;
                }
                break;
            }
            case 16: {
                for (int c = 0; c < dv1.Channel; ++c) {
                    short[] sb1 = dv1.getDataBufferShort(c);
                    short[] sb2 = dv2.getDataBufferShort(c);
                    for (int x = 0; x < sb1.length; ++x) {
                        if (sb1[x] == sb2[x]) continue;
                        sb2 = null;
                        sb1 = null;
                        return false;
                    }
                    sb2 = null;
                    sb1 = null;
                }
                break;
            }
            case 32: {
                for (int c = 0; c < dv1.Channel; ++c) {
                    int[] ib1 = dv1.getDataBufferInt(c);
                    int[] ib2 = dv2.getDataBufferInt(c);
                    for (int x = 0; x < ib1.length; ++x) {
                        if (ib1[x] == ib2[x]) continue;
                        ib2 = null;
                        ib1 = null;
                        return false;
                    }
                    ib2 = null;
                    ib1 = null;
                }
                break;
            }
            case -32: {
                for (int c = 0; c < dv1.Channel; ++c) {
                    float[] fb1 = dv1.getDataBufferFloat(c);
                    float[] fb2 = dv2.getDataBufferFloat(c);
                    for (int x = 0; x < fb1.length; ++x) {
                        if (fb1[x] == fb2[x]) continue;
                        fb2 = null;
                        fb1 = null;
                        return false;
                    }
                    fb2 = null;
                    fb1 = null;
                }
                break;
            }
            case 64: {
                for (int c = 0; c < dv1.Channel; ++c) {
                    double[] db1 = dv1.getDataBufferDouble(c);
                    double[] db2 = dv2.getDataBufferDouble(c);
                    for (int x = 0; x < db1.length; ++x) {
                        if (db1[x] == db2[x]) continue;
                        db2 = null;
                        db1 = null;
                        return false;
                    }
                    db2 = null;
                    db1 = null;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        return true;
    }

    public static boolean areDimensionsEqual(DV dv1, DV dv2) {
        return dv1.SizeX == dv2.SizeX && dv1.SizeY == dv2.SizeY && dv1.SizeZ == dv2.SizeZ && dv1.Channel == dv2.Channel;
    }

    public static boolean areDimensionsAndTypeEqual(DV dv1, DV dv2) {
        return dv1.Type == dv2.Type && DvTools.areDimensionsEqual(dv1, dv2);
    }

    public static boolean isGrayLevel(DV dv) {
        return dv.Channel == 1;
    }

    public static boolean isColored(DV dv) {
        return dv.Channel != 1;
    }

    public static boolean isBlack(DV dv) {
        switch (dv.Type) {
            case 8: {
                for (int c = 0; c < dv.Channel; ++c) {
                    byte[] bb = dv.getDataBufferByte(c);
                    for (int x = 0; x < bb.length; ++x) {
                        if (bb[x] == 0) continue;
                        bb = null;
                        return false;
                    }
                    bb = null;
                }
                break;
            }
            case 16: {
                for (int c = 0; c < dv.Channel; ++c) {
                    short[] sb = dv.getDataBufferShort(c);
                    for (int x = 0; x < sb.length; ++x) {
                        if (sb[x] == 0) continue;
                        sb = null;
                        return false;
                    }
                    sb = null;
                }
                break;
            }
            case 32: {
                for (int c = 0; c < dv.Channel; ++c) {
                    int[] ib = dv.getDataBufferInt(c);
                    for (int x = 0; x < ib.length; ++x) {
                        if (ib[x] == 0) continue;
                        ib = null;
                        return false;
                    }
                    ib = null;
                }
                break;
            }
            case -32: {
                for (int c = 0; c < dv.Channel; ++c) {
                    float[] fb = dv.getDataBufferFloat(c);
                    for (int x = 0; x < fb.length; ++x) {
                        if (fb[x] == 0.0f) continue;
                        fb = null;
                        return false;
                    }
                    fb = null;
                }
                break;
            }
            case 64: {
                for (int c = 0; c < dv.Channel; ++c) {
                    double[] db = dv.getDataBufferDouble(c);
                    for (int x = 0; x < db.length; ++x) {
                        if (db[x] == 0.0) continue;
                        db = null;
                        return false;
                    }
                    Object var3_15 = null;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        return true;
    }

    public static boolean isWhite(DV dv) {
        switch (dv.Type) {
            case 8: {
                int max = 255;
                for (int c = 0; c < dv.Channel; ++c) {
                    byte[] bb = dv.getDataBufferByte(c);
                    for (int x = 0; x < bb.length; ++x) {
                        if ((bb[x] & 0xFF) == max) continue;
                        bb = null;
                        return false;
                    }
                    bb = null;
                }
                break;
            }
            case 16: {
                int max = 65535;
                for (int c = 0; c < dv.Channel; ++c) {
                    short[] sb = dv.getDataBufferShort(c);
                    for (int x = 0; x < sb.length; ++x) {
                        if ((sb[x] & 0xFFFF) == max) continue;
                        sb = null;
                        return false;
                    }
                    sb = null;
                }
                break;
            }
            case 32: {
                int max = Integer.MAX_VALUE;
                for (int c = 0; c < dv.Channel; ++c) {
                    int[] ib = dv.getDataBufferInt(c);
                    for (int x = 0; x < ib.length; ++x) {
                        if (ib[x] == max) continue;
                        ib = null;
                        return false;
                    }
                    ib = null;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        return true;
    }

    public static boolean Contains(DV dv, int value) {
        for (int c = 0; c < dv.Channel; ++c) {
            if (!DvTools.Contains(dv, c, value)) continue;
            return true;
        }
        return false;
    }

    public static boolean Contains(DV dv, int channel, int value) {
        switch (dv.Type) {
            case 8: {
                byte[] bb = dv.getDataBufferByte(channel);
                for (int x = 0; x < bb.length; ++x) {
                    if ((bb[x] & 0xFF) != value) continue;
                    return true;
                }
                bb = null;
                break;
            }
            case 16: {
                short[] sb = dv.getDataBufferShort(channel);
                for (int x = 0; x < sb.length; ++x) {
                    if ((sb[x] & 0xFFFF) != value) continue;
                    return true;
                }
                sb = null;
                break;
            }
            case 32: {
                int[] ib = dv.getDataBufferInt(channel);
                for (int x = 0; x < ib.length; ++x) {
                    if (ib[x] != value) continue;
                    return true;
                }
                ib = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        return false;
    }

    public static boolean Contains(DV dv, int minx, int miny, int minz, int maxx, int maxy, int maxz, int value) {
        for (int c = 0; c < dv.Channel; ++c) {
            if (!DvTools.Contains(dv, c, minx, miny, minz, maxx, maxy, maxz, value)) continue;
            return true;
        }
        return false;
    }

    public static boolean Contains(DV dv, int channel, int minx, int miny, int minz, int maxx, int maxy, int maxz, int value) {
        int popy = dv.SizeX - maxx + minx;
        int popz = (dv.SizeY - maxy + miny) * dv.SizeX;
        switch (dv.Type) {
            case 8: {
                byte[] bb = dv.getDataBufferByte(channel);
                int z = minz;
                int pos = minz * dv.LayerSize + miny * dv.SizeX + minx;
                while (z < maxz) {
                    int y = miny;
                    while (y < maxy) {
                        int x = minx;
                        while (x < maxx) {
                            if ((bb[pos] & 0xFF) == value) {
                                return true;
                            }
                            ++x;
                            ++pos;
                        }
                        ++y;
                        pos += popy;
                    }
                    ++z;
                    pos += popz;
                }
                bb = null;
                break;
            }
            case 16: {
                short[] sb = dv.getDataBufferShort(channel);
                int z = minz;
                int pos = minz * dv.LayerSize + miny * dv.SizeX + minx;
                while (z < maxz) {
                    int y = miny;
                    while (y < maxy) {
                        int x = minx;
                        while (x < maxx) {
                            if ((sb[pos] & 0xFFFF) == value) {
                                return true;
                            }
                            ++x;
                            ++pos;
                        }
                        ++y;
                        pos += popy;
                    }
                    ++z;
                    pos += popz;
                }
                sb = null;
                break;
            }
            case 32: {
                int[] ib = dv.getDataBufferInt(channel);
                int z = minz;
                int pos = minz * dv.LayerSize + miny * dv.SizeX + minx;
                while (z < maxz) {
                    int y = miny;
                    while (y < maxy) {
                        int x = minx;
                        while (x < maxx) {
                            if (ib[pos] == value) {
                                return true;
                            }
                            ++x;
                            ++pos;
                        }
                        ++y;
                        pos += popy;
                    }
                    ++z;
                    pos += popz;
                }
                ib = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        return false;
    }

    public static boolean Contains(DV dv, double value) {
        for (int c = 0; c < dv.Channel; ++c) {
            if (!DvTools.Contains(dv, c, value)) continue;
            return true;
        }
        return false;
    }

    public static boolean Contains(DV dv, int channel, double value) {
        switch (dv.Type) {
            case -32: {
                float[] fb = dv.getDataBufferFloat(channel);
                for (int x = 0; x < fb.length; ++x) {
                    if ((double)fb[x] != value) continue;
                    return true;
                }
                fb = null;
                break;
            }
            case 64: {
                double[] db = dv.getDataBufferDouble(channel);
                for (int x = 0; x < db.length; ++x) {
                    if (db[x] != value) continue;
                    return true;
                }
                db = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        return false;
    }

    public static boolean Contains(DV dv, int minx, int miny, int minz, int maxx, int maxy, int maxz, double value) {
        for (int c = 0; c < dv.Channel; ++c) {
            if (!DvTools.Contains(dv, c, minx, miny, minz, maxx, maxy, maxz, value)) continue;
            return true;
        }
        return false;
    }

    public static boolean Contains(DV dv, int channel, int minx, int miny, int minz, int maxx, int maxy, int maxz, double value) {
        int popy = dv.SizeX - maxx + minx;
        int popz = (dv.SizeY - maxy + miny) * dv.SizeX;
        switch (dv.Type) {
            case -32: {
                float[] fb = dv.getDataBufferFloat(channel);
                int z = minz;
                int pos = minz * dv.LayerSize + miny * dv.SizeX + minx;
                while (z < maxz) {
                    int y = miny;
                    while (y < maxy) {
                        int x = minx;
                        while (x < maxx) {
                            if ((double)fb[pos] == value) {
                                return true;
                            }
                            ++x;
                            ++pos;
                        }
                        ++y;
                        pos += popy;
                    }
                    ++z;
                    pos += popz;
                }
                fb = null;
                break;
            }
            case 64: {
                double[] db = dv.getDataBufferDouble(channel);
                int z = minz;
                int pos = minz * dv.LayerSize + miny * dv.SizeX + minx;
                while (z < maxz) {
                    int y = miny;
                    while (y < maxy) {
                        int x = minx;
                        while (x < maxx) {
                            if (db[pos] == value) {
                                return true;
                            }
                            ++x;
                            ++pos;
                        }
                        ++y;
                        pos += popy;
                    }
                    ++z;
                    pos += popz;
                }
                db = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        return false;
    }

    private static int TrouverMarge(DV dv) {
        throw new Error("Must be upgraded.");
    }

    public static DV SymetriqueLac(DV source) {
        return DvTools.SymetriqueLac(source, DvTools.TrouverMarge(source));
    }

    public static DV SymetriqueLac(DV source, int Marge) {
        throw new Error("Must be upgraded.");
    }
}

