/*
 * Decompiled with CFR 0.152.
 */
package arrayTiTi;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public final class ArrayTools {
    public static boolean areDimensionsEqual(byte[] tab1, byte[] tab2) {
        return tab1.length == tab2.length;
    }

    public static boolean areDimensionsEqual(boolean[] tab1, boolean[] tab2) {
        return tab1.length == tab2.length;
    }

    public static boolean areDimensionsEqual(short[] tab1, short[] tab2) {
        return tab1.length == tab2.length;
    }

    public static boolean areDimensionsEqual(int[] tab1, int[] tab2) {
        return tab1.length == tab2.length;
    }

    public static boolean areDimensionsEqual(short[] tab1, int[] tab2) {
        return tab1.length == tab2.length;
    }

    public static boolean areDimensionsEqual(float[] tab1, float[] tab2) {
        return tab1.length == tab2.length;
    }

    public static boolean areDimensionsEqual(double[] tab1, double[] tab2) {
        return tab1.length == tab2.length;
    }

    public static boolean areDimensionsEqual(double[] tab1, boolean[] tab2) {
        return tab1.length == tab2.length;
    }

    public static boolean areDimensionsEqual(int[] tab1, double[] tab2) {
        return tab1.length == tab2.length;
    }

    public static boolean areDimensionsEqual(int[] tab1, boolean[] tab2) {
        return tab1.length == tab2.length;
    }

    public static boolean areDimensionsEqual(float[] tab1, double[] tab2) {
        return tab1.length == tab2.length;
    }

    public static boolean areDimensionsEqual(String[] tab1, String[] tab2) {
        return tab1.length == tab2.length;
    }

    public static boolean areDimensionsEqual(byte[][] tab1, byte[][] tab2) {
        return tab1.length == tab2.length && tab1[0].length == tab2[0].length;
    }

    public static boolean areDimensionsEqual(boolean[][] tab1, boolean[][] tab2) {
        return tab1.length == tab2.length && tab1[0].length == tab2[0].length;
    }

    public static boolean areDimensionsEqual(short[][] tab1, short[][] tab2) {
        return tab1.length == tab2.length && tab1[0].length == tab2[0].length;
    }

    public static boolean areDimensionsEqual(int[][] tab1, boolean[][] tab2) {
        return tab1.length == tab2.length && tab1[0].length == tab2[0].length;
    }

    public static boolean areDimensionsEqual(int[][] tab1, int[][] tab2) {
        return tab1.length == tab2.length && tab1[0].length == tab2[0].length;
    }

    public static boolean areDimensionsEqual(short[][] tab1, int[][] tab2) {
        return tab1.length == tab2.length && tab1[0].length == tab2[0].length;
    }

    public static boolean areDimensionsEqual(float[][] tab1, float[][] tab2) {
        return tab1.length == tab2.length && tab1[0].length == tab2[0].length;
    }

    public static boolean areDimensionsEqual(double[][] tab1, boolean[][] tab2) {
        return tab1.length == tab2.length && tab1[0].length == tab2[0].length;
    }

    public static boolean areDimensionsEqual(double[][] tab1, double[][] tab2) {
        return tab1.length == tab2.length && tab1[0].length == tab2[0].length;
    }

    public static boolean areDimensionsEqual(float[][] tab1, double[][] tab2) {
        return tab1.length == tab2.length && tab1[0].length == tab2[0].length;
    }

    public static boolean areDimensionsEqual(int[][] tab1, double[][] tab2) {
        return tab1.length == tab2.length && tab1[0].length == tab2[0].length;
    }

    public static boolean areDimensionsEqual(int[][] tab1, float[][] tab2) {
        return tab1.length == tab2.length && tab1[0].length == tab2[0].length;
    }

    public static boolean areDimensionsEqual(String[][] tab1, String[][] tab2) {
        return tab1.length == tab2.length && tab1[0].length == tab2[0].length;
    }

    public static boolean areDimensionsEqual(byte[][][] tab1, byte[][][] tab2) {
        return tab1.length == tab2.length && tab1[0].length == tab2[0].length && tab1[0][0].length == tab2[0][0].length;
    }

    public static boolean areDimensionsEqual(boolean[][][] tab1, boolean[][][] tab2) {
        return tab1.length == tab2.length && tab1[0].length == tab2[0].length && tab1[0][0].length == tab2[0][0].length;
    }

    public static boolean areDimensionsEqual(short[][][] tab1, short[][][] tab2) {
        return tab1.length == tab2.length && tab1[0].length == tab2[0].length && tab1[0][0].length == tab2[0][0].length;
    }

    public static boolean areDimensionsEqual(int[][][] tab1, boolean[][][] tab2) {
        return tab1.length == tab2.length && tab1[0].length == tab2[0].length && tab1[0][0].length == tab2[0][0].length;
    }

    public static boolean areDimensionsEqual(int[][][] tab1, int[][][] tab2) {
        return tab1.length == tab2.length && tab1[0].length == tab2[0].length && tab1[0][0].length == tab2[0][0].length;
    }

    public static boolean areDimensionsEqual(short[][][] tab1, int[][][] tab2) {
        return tab1.length == tab2.length && tab1[0].length == tab2[0].length && tab1[0][0].length == tab2[0][0].length;
    }

    public static boolean areDimensionsEqual(float[][][] tab1, float[][][] tab2) {
        return tab1.length == tab2.length && tab1[0].length == tab2[0].length && tab1[0][0].length == tab2[0][0].length;
    }

    public static boolean areDimensionsEqual(double[][][] tab1, boolean[][][] tab2) {
        return tab1.length == tab2.length && tab1[0].length == tab2[0].length && tab1[0][0].length == tab2[0][0].length;
    }

    public static boolean areDimensionsEqual(double[][][] tab1, double[][][] tab2) {
        return tab1.length == tab2.length && tab1[0].length == tab2[0].length && tab1[0][0].length == tab2[0][0].length;
    }

    public static boolean areDimensionsEqual(float[][][] tab1, double[][][] tab2) {
        return tab1.length == tab2.length && tab1[0].length == tab2[0].length && tab1[0][0].length == tab2[0][0].length;
    }

    public static boolean areDimensionsEqual(int[][][] tab1, double[][][] tab2) {
        return tab1.length == tab2.length && tab1[0].length == tab2[0].length && tab1[0][0].length == tab2[0][0].length;
    }

    public static boolean areDimensionsEqual(int[][][] tab1, float[][][] tab2) {
        return tab1.length == tab2.length && tab1[0].length == tab2[0].length && tab1[0][0].length == tab2[0][0].length;
    }

    public static boolean areDimensionsEqual(String[][][] tab1, String[][][] tab2) {
        return tab1.length == tab2.length && tab1[0].length == tab2[0].length && tab1[0][0].length == tab2[0][0].length;
    }

    public static boolean AreEqual(boolean[] t1, boolean[] t2) {
        if (t1.length != t2.length) {
            return false;
        }
        for (int i = 0; i < t1.length; ++i) {
            if (t1[i] == t2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean AreEqual(byte[] t1, byte[] t2) {
        if (t1.length != t2.length) {
            return false;
        }
        for (int i = 0; i < t1.length; ++i) {
            if (t1[i] == t2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean AreEqual(short[] t1, short[] t2) {
        if (t1.length != t2.length) {
            return false;
        }
        for (int i = 0; i < t1.length; ++i) {
            if (t1[i] == t2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean AreEqual(int[] t1, int[] t2) {
        if (t1.length != t2.length) {
            return false;
        }
        for (int i = 0; i < t1.length; ++i) {
            if (t1[i] == t2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean AreEqual(float[] t1, float[] t2) {
        if (t1.length != t2.length) {
            return false;
        }
        for (int i = 0; i < t1.length; ++i) {
            if (Float.compare(t1[i], t2[i]) == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean AreEqual(double[] t1, double[] t2) {
        if (t1.length != t2.length) {
            return false;
        }
        for (int i = 0; i < t1.length; ++i) {
            if (Double.compare(t1[i], t2[i]) == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean AreEqual(byte[][] t1, byte[][] t2) {
        int height = t1.length;
        int width = t1[0].length;
        if (!ArrayTools.areDimensionsEqual(t1, t2)) {
            return false;
        }
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (t1[y][x] == t2[y][x]) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean AreEqual(int[][] t1, int[][] t2) {
        int height = t1.length;
        int width = t1[0].length;
        if (!ArrayTools.areDimensionsEqual(t1, t2)) {
            return false;
        }
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (t1[y][x] == t2[y][x]) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean AreEqual(float[][] t1, float[][] t2, float epsilon) {
        int height = t1.length;
        int width = t1[0].length;
        if (!ArrayTools.areDimensionsEqual(t1, t2)) {
            return false;
        }
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (!(Math.abs(t1[y][x] - t2[y][x]) > epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean AreEqual(double[][] t1, double[][] t2, double epsilon) {
        int height = t1.length;
        int width = t1[0].length;
        if (!ArrayTools.areDimensionsEqual(t1, t2)) {
            return false;
        }
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (!(Math.abs(t1[y][x] - t2[y][x]) > epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean AreEqual(double[][] t1, double[][] t2) {
        int height = t1.length;
        int width = t1[0].length;
        if (!ArrayTools.areDimensionsEqual(t1, t2)) {
            return false;
        }
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (Double.compare(t1[y][x], t2[y][x]) == 0) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean AreEqual(byte[][][] t1, byte[][][] t2) {
        if (!ArrayTools.areDimensionsEqual(t1, t2)) {
            return false;
        }
        for (int z = 0; z < t1.length; ++z) {
            if (ArrayTools.AreEqual(t1[z], t2[z])) continue;
            return false;
        }
        return true;
    }

    public static boolean AreEqual(int[][][] t1, int[][][] t2) {
        if (!ArrayTools.areDimensionsEqual(t1, t2)) {
            return false;
        }
        for (int z = 0; z < t1.length; ++z) {
            if (ArrayTools.AreEqual(t1[z], t2[z])) continue;
            return false;
        }
        return true;
    }

    public static boolean AreEqual(float[][][] t1, float[][][] t2, float epsilon) {
        if (!ArrayTools.areDimensionsEqual(t1, t2)) {
            return false;
        }
        for (int z = 0; z < t1.length; ++z) {
            if (ArrayTools.AreEqual(t1[z], t2[z], epsilon)) continue;
            return false;
        }
        return true;
    }

    public static boolean AreEqual(double[][][] t1, double[][][] t2, double epsilon) {
        if (!ArrayTools.areDimensionsEqual(t1, t2)) {
            return false;
        }
        for (int z = 0; z < t1.length; ++z) {
            if (ArrayTools.AreEqual(t1[z], t2[z], epsilon)) continue;
            return false;
        }
        return true;
    }

    public static boolean AreEqual(double[][][] t1, double[][][] t2) {
        if (!ArrayTools.areDimensionsEqual(t1, t2)) {
            return false;
        }
        for (int z = 0; z < t1.length; ++z) {
            if (ArrayTools.AreEqual(t1[z], t2[z])) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqual(int[] Tab, int val) {
        for (int x = 0; x < Tab.length; ++x) {
            if (Tab[x] == val) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqual(int[][] Tab, int val) {
        int height = Tab.length;
        int width = Tab[0].length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (Tab[y][x] == val) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean AreEqual(String[] t1, String[] t2) {
        if (t1.length != t2.length) {
            return false;
        }
        for (int i = 0; i < t1.length; ++i) {
            if (t1[i].equalsIgnoreCase(t2[i])) continue;
            return false;
        }
        return true;
    }

    public static int Miror(int[][] Tab, int y, int x) {
        return ArrayTools.Miror(Tab, y, x, Tab.length, Tab[0].length);
    }

    public static int Miror(int[][] Tab, int y, int x, int Height, int Width) {
        if (x < 0) {
            x = -x;
        }
        if (y < 0) {
            y = -y;
        }
        if (x >= Width) {
            x = Width - (x - Width + 1);
        }
        if (y >= Height) {
            y = Height - (y - Height + 1);
        }
        if (y < 0 || x < 0) {
            return ArrayTools.Miror(Tab, y, x, Height, Width);
        }
        return Tab[y][x];
    }

    public static double Miror(double[][] Tab, int y, int x) {
        return ArrayTools.Miror(Tab, y, x, Tab.length, Tab[0].length);
    }

    public static double Miror(double[][] Tab, int y, int x, int Height, int Width) {
        if (x < 0) {
            x = -x;
        }
        if (y < 0) {
            y = -y;
        }
        if (x >= Width) {
            x = Width - (x - Width + 1);
        }
        if (y >= Height) {
            y = Height - (y - Height + 1);
        }
        if (y < 0 || x < 0) {
            return ArrayTools.Miror(Tab, y, x, Height, Width);
        }
        return Tab[y][x];
    }

    public static int ArrayDimensions(Class array) {
        if (array.getComponentType().isArray()) {
            return 1 + ArrayTools.ArrayDimensions(array.getComponentType());
        }
        return 1;
    }

    public static int ArrayDimensions(Object array) {
        return ArrayTools.ArrayDimensions(array.getClass());
    }

    public static double[][] SubArray(double[][] array, int startx, int starty, int endx, int endy) {
        double[][] result = new double[endy - starty + 1][endx - startx + 1];
        for (int y = starty; y <= endy; ++y) {
            for (int x = startx; x <= endx; ++x) {
                result[y - starty][x - startx] = array[y][x];
            }
        }
        return result;
    }

    public static int[][] SubArray(int[][] array, int startx, int starty, int endx, int endy) {
        int[][] result = new int[endy - starty + 1][endx - startx + 1];
        for (int y = starty; y <= endy; ++y) {
            for (int x = startx; x <= endx; ++x) {
                result[y - starty][x - startx] = array[y][x];
            }
        }
        return result;
    }

    public static boolean ContainsNaN(double[] tab) {
        for (int x = 0; x < tab.length; ++x) {
            if (!Double.isNaN(tab[x])) continue;
            return true;
        }
        return false;
    }

    public static boolean ContainsNaN(double[][] tab) {
        for (double[] t : tab) {
            for (int x = 0; x < t.length; ++x) {
                if (!Double.isNaN(t[x])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean ContainsInifinite(double[] tab) {
        for (int x = 0; x < tab.length; ++x) {
            if (!Double.isInfinite(tab[x])) continue;
            return true;
        }
        return false;
    }

    public static boolean ContainsInifinite(double[][] tab) {
        for (double[] t : tab) {
            for (int x = 0; x < t.length; ++x) {
                if (!Double.isInfinite(t[x])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean Contains(byte[] array, byte value) {
        for (int x = 0; x < array.length; ++x) {
            if (array[x] != value) continue;
            return true;
        }
        return false;
    }

    public static boolean Contains(short[] array, short value) {
        for (int x = 0; x < array.length; ++x) {
            if (array[x] != value) continue;
            return true;
        }
        return false;
    }

    public static boolean Contains(int[] array, int value) {
        return ArrayTools.Contains(array, 0, array.length, value);
    }

    public static boolean Contains(int[] array, int start, int end, int value) {
        for (int x = start; x < end; ++x) {
            if (array[x] != value) continue;
            return true;
        }
        return false;
    }

    public static boolean Contains(double[] array, double value) {
        for (int x = 0; x < array.length; ++x) {
            if (Double.compare(array[x], value) != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean Contains(byte[] array, int value) {
        for (int x = 0; x < array.length; ++x) {
            if ((array[x] & 0xFF) != value) continue;
            return true;
        }
        return false;
    }

    public static boolean Contains(short[] array, int value) {
        for (int x = 0; x < array.length; ++x) {
            if ((array[x] & 0xFFFF) != value) continue;
            return true;
        }
        return false;
    }

    public static boolean Contains(String[] array, String str) {
        for (String s : array) {
            if (!s.equalsIgnoreCase(str)) continue;
            return true;
        }
        return false;
    }

    public static List<Byte> ListOfUniqueItems(byte[] array) {
        int[] hist = new int[256];
        for (int x = 0; x < array.length; ++x) {
            hist[array[x] & 0xFF] = 1;
        }
        LinkedList<Byte> list = new LinkedList<Byte>();
        for (int x = 0; x < hist.length; ++x) {
            if (hist[x] != 1) continue;
            list.add((byte)x);
        }
        hist = null;
        return list;
    }

    public static List<Short> ListOfUniqueItems(short[] array) {
        int[] hist = new int[65535];
        for (int x = 0; x < array.length; ++x) {
            hist[array[x] & 0xFFFF] = 1;
        }
        LinkedList<Short> list = new LinkedList<Short>();
        for (int x = 0; x < hist.length; ++x) {
            if (hist[x] != 1) continue;
            list.add((short)x);
        }
        hist = null;
        return list;
    }

    public static List<String> ListOfUniqueItems(String[] array) {
        HashMap<String, Integer> hm = new HashMap<String, Integer>();
        for (int i = 0; i < array.length; ++i) {
            hm.put(array[i], i);
        }
        return new LinkedList<String>(hm.keySet());
    }

    public static List<Integer> ListOfUniqueItems(int[] array) {
        HashMap<Integer, Integer> hm = new HashMap<Integer, Integer>();
        for (int i = 0; i < array.length; ++i) {
            hm.put(array[i], i);
        }
        return new LinkedList<Integer>(hm.keySet());
    }

    public static boolean isMinimumLocal(double[][] source, int x, int y) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (i == 0 && j == 0 || !(source[y][x] >= source[y + i][x + j])) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isMaximumLocal(double[][] source, int x, int y) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (i == 0 && j == 0 || !(source[y][x] <= source[y + i][x + j])) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isMinimumLocal(int[][] source, int x, int y) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (i == 0 && j == 0 || source[y][x] < source[y + i][x + j]) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isMaximumLocal(int[][] source, int x, int y) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (i == 0 && j == 0 || source[y][x] > source[y + i][x + j]) continue;
                return false;
            }
        }
        return true;
    }
}

