/*
 * Decompiled with CFR 0.152.
 */
package arrayTiTi;

import arrayTiTi.ArrayTools;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import mathematics.primitives.pointsTiTi.Coordinates;
import mathematics.primitives.pointsTiTi.CoordinatesWeighted;
import utils.memory.Allocator;

public final class ArrayConverter {
    private static final double Epsilon = 1.0E-4;

    public static int[][] BooleanToInt(boolean[][] source) {
        int[][] result = new int[source.length][source[0].length];
        ArrayConverter.BooleanToInt(source, result);
        return result;
    }

    public static void BooleanToInt(boolean[][] source, int[][] result) {
        if (source.length != result.length || source[0].length != result[0].length) {
            throw new IllegalArgumentException("Arrays have different dimensions");
        }
        int width = source[0].length;
        int height = source.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                result[y][x] = source[y][x] ? 1 : 0;
            }
        }
    }

    public static int[][] ShortToInt(short[][] source) {
        int[][] result = new int[source.length][source[0].length];
        ArrayConverter.ShortToInt(source, result);
        return result;
    }

    public static void ShortToInt(short[][] source, int[][] result) {
        if (!ArrayTools.areDimensionsEqual(source, result)) {
            throw new IllegalArgumentException("Arrays have different dimensions");
        }
        int width = source[0].length;
        int height = source.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                result[y][x] = source[y][x];
            }
        }
    }

    public static short[][] IntToShort(int[][] source) {
        short[][] result = new short[source.length][source[0].length];
        ArrayConverter.IntToShort(source, result);
        return result;
    }

    public static void IntToShort(int[][] source, short[][] result) {
        if (!ArrayTools.areDimensionsEqual(result, source)) {
            throw new IllegalArgumentException("Arrays have different dimensions");
        }
        int width = source[0].length;
        int height = source.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                result[y][x] = (short)source[y][x];
            }
        }
    }

    public static double[][] IntToDouble(int[][] source) {
        double[][] result = new double[source.length][source[0].length];
        ArrayConverter.IntToDouble(source, result);
        return result;
    }

    public static void IntToDouble(int[][] source, double[][] result) {
        if (!ArrayTools.areDimensionsEqual(source, result)) {
            throw new IllegalArgumentException("Arrays have different dimensions");
        }
        int width = source[0].length;
        int height = source.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                result[y][x] = source[y][x];
            }
        }
    }

    public static float[][] IntToFloat(int[][] source) {
        float[][] result = new float[source.length][source[0].length];
        ArrayConverter.IntToFloat(source, result);
        return result;
    }

    public static void IntToFloat(int[][] source, float[][] result) {
        if (!ArrayTools.areDimensionsEqual(source, result)) {
            throw new IllegalArgumentException("Arrays have different dimensions");
        }
        int width = source[0].length;
        int height = source.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                result[y][x] = source[y][x];
            }
        }
    }

    public static boolean[][] IntToBoolean(int[][] source) {
        boolean[][] result = new boolean[source.length][source[0].length];
        ArrayConverter.IntToBoolean(source, result);
        return result;
    }

    public static void IntToBoolean(int[][] source, boolean[][] result) {
        if (!ArrayTools.areDimensionsEqual(source, result)) {
            throw new IllegalArgumentException("Arrays have different dimensions");
        }
        int width = source[0].length;
        int height = source.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                result[y][x] = (double)source[y][x] != 0.0;
            }
        }
    }

    public static double[][] FloatToDouble(float[][] source) {
        double[][] result = new double[source.length][source[0].length];
        ArrayConverter.FloatToDouble(source, result);
        return result;
    }

    public static void FloatToDouble(float[][] source, double[][] result) {
        if (!ArrayTools.areDimensionsEqual(source, result)) {
            throw new IllegalArgumentException("Arrays have different dimensions");
        }
        int width = source[0].length;
        int height = source.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                result[y][x] = source[y][x];
            }
        }
    }

    public static float[][] DoubleToFloat(double[][] source) {
        float[][] result = new float[source.length][source[0].length];
        ArrayConverter.DoubleToFloat(source, result);
        return result;
    }

    public static void DoubleToFloat(double[][] source, float[][] result) {
        if (!ArrayTools.areDimensionsEqual(result, source)) {
            throw new IllegalArgumentException("Arrays have different dimensions");
        }
        int width = source[0].length;
        int height = source.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                result[y][x] = (float)source[y][x];
            }
        }
    }

    public static boolean[][] DoubleToBoolean(double[][] source) {
        boolean[][] result = new boolean[source.length][source[0].length];
        ArrayConverter.DoubleToBoolean(source, result);
        return result;
    }

    public static void DoubleToBoolean(double[][] source, boolean[][] result) {
        if (!ArrayTools.areDimensionsEqual(source, result)) {
            throw new IllegalArgumentException("Arrays have different dimensions");
        }
        int width = source[0].length;
        int height = source.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                result[y][x] = source[y][x] != 0.0;
            }
        }
    }

    public static int[][] DoubleToInt(double[][] source, boolean closest) {
        int[][] result = new int[source.length][source[0].length];
        ArrayConverter.DoubleToInt(source, result, closest);
        return result;
    }

    public static void DoubleToInt(double[][] source, int[][] result, boolean closest) {
        if (!ArrayTools.areDimensionsEqual(result, source)) {
            throw new IllegalArgumentException("Arrays have different dimensions");
        }
        int width = source[0].length;
        int height = source.length;
        if (closest) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    result[y][x] = (int)(source[y][x] + 0.5);
                }
            }
        } else {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    result[y][x] = (int)source[y][x];
                }
            }
        }
    }

    public static int[][] Transpose(int[][] source) {
        int[][] result = new int[source[0].length][source.length];
        ArrayConverter.Transpose(source, result);
        return result;
    }

    public static void Transpose(int[][] source, int[][] result) {
        if (source.length != result[0].length || source[0].length != result.length) {
            throw new IllegalArgumentException("Dimensions are not transposed.");
        }
        for (int y = 0; y < source.length; ++y) {
            for (int x = 0; x < source[0].length; ++x) {
                result[x][y] = source[y][x];
            }
        }
    }

    public static float[][] Transpose(float[][] source) {
        float[][] result = new float[source[0].length][source.length];
        ArrayConverter.Transpose(source, result);
        return result;
    }

    public static void Transpose(float[][] source, float[][] result) {
        if (source.length != result[0].length || source[0].length != result.length) {
            throw new IllegalArgumentException("Dimensions are not transposed.");
        }
        for (int y = 0; y < source.length; ++y) {
            for (int x = 0; x < source[0].length; ++x) {
                result[x][y] = source[y][x];
            }
        }
    }

    public static double[][] Transpose(double[][] source) {
        double[][] result = new double[source[0].length][source.length];
        ArrayConverter.Transpose(source, result);
        return result;
    }

    public static void Transpose(double[][] source, double[][] result) {
        if (source.length != result[0].length || source[0].length != result.length) {
            throw new IllegalArgumentException("Dimensions are not transpoesed.");
        }
        for (int y = 0; y < source.length; ++y) {
            for (int x = 0; x < source[0].length; ++x) {
                result[x][y] = source[y][x];
            }
        }
    }

    public static boolean[][] Transpose(boolean[][] source) {
        boolean[][] result = new boolean[source[0].length][source.length];
        ArrayConverter.Transpose(source, result);
        return result;
    }

    public static void Transpose(boolean[][] source, boolean[][] result) {
        if (source.length != result[0].length || source[0].length != result.length) {
            throw new IllegalArgumentException("Dimensions are not transpoesed.");
        }
        for (int y = 0; y < source.length; ++y) {
            for (int x = 0; x < source[0].length; ++x) {
                result[x][y] = source[y][x];
            }
        }
    }

    public static byte[][] to2D(byte[] array, int width, int height) {
        if (array.length != width * height) {
            throw new IllegalArgumentException("array.length != width * height.");
        }
        byte[][] result = new byte[height][width];
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                result[y][x] = array[pos];
                ++x;
                ++pos;
            }
        }
        return result;
    }

    public static short[][] to2D(short[] array, int width, int height) {
        if (array.length != width * height) {
            throw new IllegalArgumentException("array.length != width * height.");
        }
        short[][] result = new short[height][width];
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                result[y][x] = array[pos];
                ++x;
                ++pos;
            }
        }
        return result;
    }

    public static int[][] to2D(int[] array, int width, int height) {
        if (array.length != width * height) {
            throw new IllegalArgumentException("array.length != width * height.");
        }
        int[][] result = new int[height][width];
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                result[y][x] = array[pos];
                ++x;
                ++pos;
            }
        }
        return result;
    }

    public static double[][] to2D(double[] array, int width, int height) {
        if (array.length != width * height) {
            throw new IllegalArgumentException("array.length != width * height.");
        }
        double[][] result = new double[height][width];
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                result[y][x] = array[pos];
                ++x;
                ++pos;
            }
        }
        return result;
    }

    public static double[] to1D(double[][] array) {
        int width = array[0].length;
        int height = array.length;
        Allocator allocator = Allocator.Instance();
        double[] result = allocator.newDoubleArray(width * height);
        allocator = null;
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                result[pos] = array[y][x];
                ++x;
                ++pos;
            }
        }
        return result;
    }

    public static float[] to1D(float[][] array) {
        int width = array[0].length;
        int height = array.length;
        Allocator allocator = Allocator.Instance();
        float[] result = allocator.newFloatArray(width * height);
        allocator = null;
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                result[pos] = array[y][x];
                ++x;
                ++pos;
            }
        }
        return result;
    }

    public static byte[] to1D(byte[][] array) {
        int width = array[0].length;
        int height = array.length;
        Allocator allocator = Allocator.Instance();
        byte[] result = allocator.newByteArray(width * height);
        allocator = null;
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                result[pos] = array[y][x];
                ++x;
                ++pos;
            }
        }
        return result;
    }

    public static short[] to1D(short[][] array) {
        int width = array[0].length;
        int height = array.length;
        Allocator allocator = Allocator.Instance();
        short[] result = allocator.newShortArray(width * height);
        allocator = null;
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                result[pos] = array[y][x];
                ++x;
                ++pos;
            }
        }
        return result;
    }

    public static int[] to1D(int[][] array) {
        int width = array[0].length;
        int height = array.length;
        Allocator allocator = Allocator.Instance();
        int[] result = allocator.newIntArray(width * height);
        allocator = null;
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                result[pos] = array[y][x];
                ++x;
                ++pos;
            }
        }
        return result;
    }

    public static int[] to1D(int[][][] array) {
        int width = array[0][0].length;
        int height = array[0].length;
        int depth = array.length;
        Allocator allocator = Allocator.Instance();
        int[] result = allocator.newIntArray(width * height * depth);
        allocator = null;
        int pos = 0;
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                int x = 0;
                while (x < width) {
                    result[pos] = array[z][y][x];
                    ++x;
                    ++pos;
                }
            }
        }
        return result;
    }

    public static byte[] to1D(byte[][][] array) {
        int width = array[0][0].length;
        int height = array[0].length;
        int depth = array.length;
        Allocator allocator = Allocator.Instance();
        byte[] result = allocator.newByteArray(width * height * depth);
        allocator = null;
        int pos = 0;
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                int x = 0;
                while (x < width) {
                    result[pos] = array[z][y][x];
                    ++x;
                    ++pos;
                }
            }
        }
        return result;
    }

    public static short[] to1D(short[][][] array) {
        int width = array[0][0].length;
        int height = array[0].length;
        int depth = array.length;
        Allocator allocator = Allocator.Instance();
        short[] result = allocator.newShortArray(width * height * depth);
        allocator = null;
        int pos = 0;
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                int x = 0;
                while (x < width) {
                    result[pos] = array[z][y][x];
                    ++x;
                    ++pos;
                }
            }
        }
        return result;
    }

    public static float[] to1D(float[][][] array) {
        int width = array[0][0].length;
        int height = array[0].length;
        int depth = array.length;
        Allocator allocator = Allocator.Instance();
        float[] result = allocator.newFloatArray(width * height * depth);
        allocator = null;
        int pos = 0;
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                int x = 0;
                while (x < width) {
                    result[pos] = array[z][y][x];
                    ++x;
                    ++pos;
                }
            }
        }
        return result;
    }

    public static double[] to1D(double[][][] array) {
        int width = array[0][0].length;
        int height = array[0].length;
        int depth = array.length;
        Allocator allocator = Allocator.Instance();
        double[] result = allocator.newDoubleArray(width * height * depth);
        allocator = null;
        int pos = 0;
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                int x = 0;
                while (x < width) {
                    result[pos] = array[z][y][x];
                    ++x;
                    ++pos;
                }
            }
        }
        return result;
    }

    public static double[][][] to3D(double[] array, int width, int height, int depth) {
        if (array.length != width * height * depth) {
            throw new IllegalArgumentException("array.length != width * height * depth .");
        }
        double[][][] result = new double[depth][height][width];
        int pos = 0;
        for (int z = 0; z < depth; ++z) {
            int y = 0;
            while (y < height) {
                System.arraycopy(array, pos, result[z][y], 0, width);
                ++y;
                pos += width;
            }
        }
        return result;
    }

    public static float[][][] to3D(float[] array, int width, int height, int depth) {
        if (array.length != width * height * depth) {
            throw new IllegalArgumentException("array.length != width * height * depth .");
        }
        float[][][] result = new float[depth][height][width];
        int pos = 0;
        for (int z = 0; z < depth; ++z) {
            int y = 0;
            while (y < height) {
                System.arraycopy(array, pos, result[z][y], 0, width);
                ++y;
                pos += width;
            }
        }
        return result;
    }

    public static int[][][] to3D(int[] array, int width, int height, int depth) {
        if (array.length != width * height * depth) {
            throw new IllegalArgumentException("array.length != width * height * depth .");
        }
        int[][][] result = new int[depth][height][width];
        int pos = 0;
        for (int z = 0; z < depth; ++z) {
            int y = 0;
            while (y < height) {
                System.arraycopy(array, pos, result[z][y], 0, width);
                ++y;
                pos += width;
            }
        }
        return result;
    }

    public static byte[][][] to3D(byte[] array, int width, int height, int depth) {
        if (array.length != width * height * depth) {
            throw new IllegalArgumentException("array.length != width * height * depth .");
        }
        byte[][][] result = new byte[depth][height][width];
        int pos = 0;
        for (int z = 0; z < depth; ++z) {
            int y = 0;
            while (y < height) {
                System.arraycopy(array, pos, result[z][y], 0, width);
                ++y;
                pos += width;
            }
        }
        return result;
    }

    public static short[][][] to3D(short[] array, int width, int height, int depth) {
        if (array.length != width * height * depth) {
            throw new IllegalArgumentException("array.length != width * height * depth .");
        }
        short[][][] result = new short[depth][height][width];
        int pos = 0;
        for (int z = 0; z < depth; ++z) {
            int y = 0;
            while (y < height) {
                System.arraycopy(array, pos, result[z][y], 0, width);
                ++y;
                pos += width;
            }
        }
        return result;
    }

    public static List<CoordinatesWeighted> ArrayToList(int[] array, int width, int height) {
        Vector<CoordinatesWeighted> list = new Vector<CoordinatesWeighted>(1111);
        ArrayConverter.ArrayToList(array, width, height, list);
        return list;
    }

    public static void ArrayToList(int[] array, int width, int height, List<CoordinatesWeighted> list) {
        list.clear();
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                if (array[pos] != 0) {
                    list.add(new CoordinatesWeighted(x, y, 0, pos, -1));
                }
                ++x;
                ++pos;
            }
        }
    }

    public static List<Coordinates> ArrayToList(int[][] array) {
        Vector<Coordinates> list = new Vector<Coordinates>(1111);
        ArrayConverter.ArrayToList(array, list);
        return list;
    }

    public static void ArrayToList(int[][] array, List<Coordinates> list) {
        list.clear();
        for (int y = 0; y < array.length; ++y) {
            for (int x = 0; x < array[0].length; ++x) {
                if (array[y][x] == 0) continue;
                list.add(new Coordinates(x, y));
            }
        }
    }

    public static List<Coordinates> ArrayToList(double[][] array) {
        ArrayList<Coordinates> list = new ArrayList<Coordinates>(1111);
        ArrayConverter.ArrayToList(array, list);
        return list;
    }

    public static void ArrayToList(double[][] array, List<Coordinates> list) {
        list.clear();
        for (int y = 0; y < array.length; ++y) {
            for (int x = 0; x < array[0].length; ++x) {
                if (array[y][x] == 0.0) continue;
                list.add(new Coordinates(x, y));
            }
        }
    }

    public static List<Coordinates> ArrayToList(short[][] array) {
        ArrayList<Coordinates> list = new ArrayList<Coordinates>(1111);
        ArrayConverter.ArrayToList(array, list);
        return list;
    }

    public static void ArrayToList(short[][] array, List<Coordinates> list) {
        list.clear();
        for (int y = 0; y < array.length; ++y) {
            for (int x = 0; x < array[0].length; ++x) {
                if ((double)array[y][x] == 0.0) continue;
                list.add(new Coordinates(x, y));
            }
        }
    }

    public static List<Coordinates> ArrayToList(byte[][] array) {
        ArrayList<Coordinates> list = new ArrayList<Coordinates>(1111);
        ArrayConverter.ArrayToList(array, list);
        return list;
    }

    public static void ArrayToList(byte[][] array, List<Coordinates> list) {
        list.clear();
        for (int y = 0; y < array.length; ++y) {
            for (int x = 0; x < array[0].length; ++x) {
                if ((double)array[y][x] == 0.0) continue;
                list.add(new Coordinates(x, y));
            }
        }
    }

    public static List<Coordinates> ArrayToList(boolean[][] array) {
        ArrayList<Coordinates> list = new ArrayList<Coordinates>(1111);
        ArrayConverter.ArrayToList(array, list);
        return list;
    }

    public static void ArrayToList(boolean[][] array, List<Coordinates> list) {
        list.clear();
        for (int y = 0; y < array.length; ++y) {
            for (int x = 0; x < array[0].length; ++x) {
                if (!array[y][x]) continue;
                list.add(new Coordinates(x, y));
            }
        }
    }

    public static short[] UnsignedByteToShort(byte[] source) {
        Allocator allocator = Allocator.Instance();
        short[] result = allocator.newShortArray(source.length);
        allocator = null;
        ArrayConverter.UnsignedByteToShort(source, result);
        return result;
    }

    public static void UnsignedByteToShort(byte[] source, short[] result) {
        if (source.length != result.length) {
            throw new IllegalArgumentException("Arrays have different dimensions");
        }
        for (int x = 0; x < source.length; ++x) {
            result[x] = (short)(source[x] & 0xFF);
        }
    }

    public static int[] UnsignedByteToInt(byte[] source) {
        Allocator allocator = Allocator.Instance();
        int[] result = allocator.newIntArray(source.length);
        allocator = null;
        ArrayConverter.UnsignedByteToInt(source, result);
        return result;
    }

    public static void UnsignedByteToInt(byte[] source, int[] result) {
        if (source.length != result.length) {
            throw new IllegalArgumentException("Arrays have different dimensions");
        }
        for (int x = 0; x < source.length; ++x) {
            result[x] = source[x] & 0xFF;
        }
    }

    public static float[] UnsignedByteToFloat(byte[] source) {
        Allocator allocator = Allocator.Instance();
        float[] result = allocator.newFloatArray(source.length);
        allocator = null;
        ArrayConverter.UnsignedByteToFloat(source, result);
        return result;
    }

    public static void UnsignedByteToFloat(byte[] source, float[] result) {
        if (source.length != result.length) {
            throw new IllegalArgumentException("Arrays have different dimensions");
        }
        for (int x = 0; x < source.length; ++x) {
            result[x] = source[x] & 0xFF;
        }
    }

    public static double[] UnsignedByteToDouble(byte[] source) {
        Allocator allocator = Allocator.Instance();
        double[] result = allocator.newDoubleArray(source.length);
        allocator = null;
        ArrayConverter.UnsignedByteToDouble(source, result);
        return result;
    }

    public static void UnsignedByteToDouble(byte[] source, double[] result) {
        if (source.length != result.length) {
            throw new IllegalArgumentException("Arrays have different dimensions");
        }
        for (int x = 0; x < source.length; ++x) {
            result[x] = source[x] & 0xFF;
        }
    }

    public static byte[] UnsignedShortToByte(short[] source) {
        Allocator allocator = Allocator.Instance();
        byte[] result = allocator.newByteArray(source.length);
        allocator = null;
        ArrayConverter.UnsignedShortToByte(source, result);
        return result;
    }

    public static void UnsignedShortToByte(short[] source, byte[] result) {
        if (source.length != result.length) {
            throw new IllegalArgumentException("Arrays have different dimensions");
        }
        for (int x = 0; x < source.length; ++x) {
            result[x] = (byte)(source[x] & 0xFFFF);
        }
    }

    public static int[] UnsignedShortToInt(short[] source) {
        Allocator allocator = Allocator.Instance();
        int[] result = allocator.newIntArray(source.length);
        allocator = null;
        ArrayConverter.UnsignedShortToInt(source, result);
        return result;
    }

    public static void UnsignedShortToInt(short[] source, int[] result) {
        if (source.length != result.length) {
            throw new IllegalArgumentException("Arrays have different dimensions");
        }
        for (int x = 0; x < source.length; ++x) {
            result[x] = source[x] & 0xFFFF;
        }
    }

    public static float[] UnsignedShortToFloat(short[] source) {
        Allocator allocator = Allocator.Instance();
        float[] result = allocator.newFloatArray(source.length);
        allocator = null;
        ArrayConverter.UnsignedShortToFloat(source, result);
        return result;
    }

    public static void UnsignedShortToFloat(short[] source, float[] result) {
        if (source.length != result.length) {
            throw new IllegalArgumentException("Arrays have different dimensions");
        }
        for (int x = 0; x < source.length; ++x) {
            result[x] = source[x] & 0xFFFF;
        }
    }

    public static double[] UnsignedShortToDouble(short[] source) {
        Allocator allocator = Allocator.Instance();
        double[] result = allocator.newDoubleArray(source.length);
        allocator = null;
        ArrayConverter.UnsignedShortToDouble(source, result);
        return result;
    }

    public static void UnsignedShortToDouble(short[] source, double[] result) {
        if (source.length != result.length) {
            throw new IllegalArgumentException("Arrays have different dimensions");
        }
        for (int x = 0; x < source.length; ++x) {
            result[x] = source[x] & 0xFFFF;
        }
    }

    public static byte[] IntToByte(int[] source) {
        Allocator allocator = Allocator.Instance();
        byte[] result = allocator.newByteArray(source.length);
        allocator = null;
        ArrayConverter.IntToByte(source, result);
        return result;
    }

    public static void IntToByte(int[] source, byte[] result) {
        if (source.length != result.length) {
            throw new IllegalArgumentException("Arrays have different dimensions");
        }
        for (int x = 0; x < source.length; ++x) {
            result[x] = (byte)source[x];
        }
    }

    public static short[] IntToShort(int[] source) {
        Allocator allocator = Allocator.Instance();
        short[] result = allocator.newShortArray(source.length);
        allocator = null;
        ArrayConverter.IntToShort(source, result);
        return result;
    }

    public static void IntToShort(int[] source, short[] result) {
        if (source.length != result.length) {
            throw new IllegalArgumentException("Arrays have different dimensions");
        }
        for (int x = 0; x < source.length; ++x) {
            result[x] = (short)source[x];
        }
    }

    public static float[] IntToFloat(int[] source) {
        Allocator allocator = Allocator.Instance();
        float[] result = allocator.newFloatArray(source.length);
        allocator = null;
        ArrayConverter.IntToFloat(source, result);
        return result;
    }

    public static void IntToFloat(int[] source, float[] result) {
        if (source.length != result.length) {
            throw new IllegalArgumentException("Arrays have different dimensions");
        }
        for (int x = 0; x < source.length; ++x) {
            result[x] = source[x];
        }
    }

    public static double[] IntToDouble(int[] source) {
        Allocator allocator = Allocator.Instance();
        double[] result = allocator.newDoubleArray(source.length);
        allocator = null;
        ArrayConverter.IntToDouble(source, result);
        return result;
    }

    public static void IntToDouble(int[] source, double[] result) {
        if (source.length != result.length) {
            throw new IllegalArgumentException("Arrays have different dimensions");
        }
        for (int x = 0; x < source.length; ++x) {
            result[x] = source[x];
        }
    }

    public static byte[] DoubleToByte(double[] source) {
        Allocator allocator = Allocator.Instance();
        byte[] result = allocator.newByteArray(source.length);
        allocator = null;
        ArrayConverter.DoubleToByte(source, result);
        return result;
    }

    public static void DoubleToByte(double[] source, byte[] result) {
        if (source.length != result.length) {
            throw new IllegalArgumentException("Arrays have different dimensions");
        }
        for (int x = 0; x < source.length; ++x) {
            result[x] = (byte)source[x];
        }
    }

    public static byte[] DoubleToByteRound(double[] source) {
        Allocator allocator = Allocator.Instance();
        byte[] result = allocator.newByteArray(source.length);
        allocator = null;
        ArrayConverter.DoubleToByteRound(source, result);
        return result;
    }

    public static void DoubleToByteRound(double[] source, byte[] result) {
        if (source.length != result.length) {
            throw new IllegalArgumentException("Arrays have different dimensions");
        }
        for (int x = 0; x < source.length; ++x) {
            result[x] = (byte)(source[x] + 0.5);
        }
    }

    public static short[] DoubleToShort(double[] source) {
        Allocator allocator = Allocator.Instance();
        short[] result = allocator.newShortArray(source.length);
        allocator = null;
        ArrayConverter.DoubleToShort(source, result);
        return result;
    }

    public static void DoubleToShort(double[] source, short[] result) {
        if (source.length != result.length) {
            throw new IllegalArgumentException("Arrays have different dimensions");
        }
        for (int x = 0; x < source.length; ++x) {
            result[x] = (short)source[x];
        }
    }

    public static short[] DoubleToShortRound(double[] source) {
        Allocator allocator = Allocator.Instance();
        short[] result = allocator.newShortArray(source.length);
        allocator = null;
        ArrayConverter.DoubleToShortRound(source, result);
        return result;
    }

    public static void DoubleToShortRound(double[] source, short[] result) {
        if (source.length != result.length) {
            throw new IllegalArgumentException("Arrays have different dimensions");
        }
        for (int x = 0; x < source.length; ++x) {
            result[x] = (short)(source[x] + 0.5);
        }
    }

    public static float[] DoubleToFloat(double[] source) {
        Allocator allocator = Allocator.Instance();
        float[] result = allocator.newFloatArray(source.length);
        allocator = null;
        ArrayConverter.DoubleToFloat(source, result);
        return result;
    }

    public static void DoubleToFloat(double[] source, float[] result) {
        if (source.length != result.length) {
            throw new IllegalArgumentException("Arrays have different dimensions");
        }
        for (int x = 0; x < source.length; ++x) {
            result[x] = (float)source[x];
        }
    }

    public static int[] DoubleToIntRound(double[] source) {
        Allocator allocator = Allocator.Instance();
        int[] result = allocator.newIntArray(source.length);
        allocator = null;
        ArrayConverter.DoubleToIntRound(source, result);
        return result;
    }

    public static void DoubleToIntRound(double[] source, int[] result) {
        if (source.length != result.length) {
            throw new IllegalArgumentException("Arrays have different dimensions");
        }
        for (int x = 0; x < source.length; ++x) {
            result[x] = (int)(source[x] + 0.5);
        }
    }

    public static void DoubleToIntRound(double[] source, int poss, int[] result, int posr, int length) {
        int x = 0;
        int ps = poss;
        int pr = posr;
        while (x < length) {
            result[pr] = (int)(source[ps] + 0.5);
            ++x;
            ++ps;
            ++pr;
        }
    }

    public static int[] DoubleToInt(double[] source) {
        Allocator allocator = Allocator.Instance();
        int[] result = allocator.newIntArray(source.length);
        allocator = null;
        ArrayConverter.DoubleToInt(source, result);
        return result;
    }

    public static void DoubleToInt(double[] source, int[] result) {
        if (source.length != result.length) {
            throw new IllegalArgumentException("Arrays have different dimensions");
        }
        for (int x = 0; x < source.length; ++x) {
            result[x] = (int)source[x];
        }
    }

    public static void DoubleToInt(double[] source, int poss, int[] result, int posr, int length) {
        int x = 0;
        int ps = poss;
        int pr = posr;
        while (x < length) {
            result[pr] = (int)source[ps];
            ++x;
            ++ps;
            ++pr;
        }
    }

    public static byte[] FloatToByte(float[] source) {
        Allocator allocator = Allocator.Instance();
        byte[] result = allocator.newByteArray(source.length);
        allocator = null;
        ArrayConverter.FloatToByte(source, result);
        return result;
    }

    public static void FloatToByte(float[] source, byte[] result) {
        if (source.length != result.length) {
            throw new IllegalArgumentException("Arrays have different dimensions");
        }
        for (int x = 0; x < source.length; ++x) {
            result[x] = (byte)source[x];
        }
    }

    public static byte[] FloatToByteRound(float[] source) {
        Allocator allocator = Allocator.Instance();
        byte[] result = allocator.newByteArray(source.length);
        allocator = null;
        ArrayConverter.FloatToByteRound(source, result);
        return result;
    }

    public static void FloatToByteRound(float[] source, byte[] result) {
        if (source.length != result.length) {
            throw new IllegalArgumentException("Arrays have different dimensions");
        }
        for (int x = 0; x < source.length; ++x) {
            result[x] = (byte)(source[x] + 0.5f);
        }
    }

    public static short[] FloatToShort(float[] source) {
        Allocator allocator = Allocator.Instance();
        short[] result = allocator.newShortArray(source.length);
        allocator = null;
        ArrayConverter.FloatToShort(source, result);
        return result;
    }

    public static void FloatToShort(float[] source, short[] result) {
        if (source.length != result.length) {
            throw new IllegalArgumentException("Arrays have different dimensions");
        }
        for (int x = 0; x < source.length; ++x) {
            result[x] = (short)source[x];
        }
    }

    public static short[] FloatToShortRound(float[] source) {
        Allocator allocator = Allocator.Instance();
        short[] result = allocator.newShortArray(source.length);
        allocator = null;
        ArrayConverter.FloatToShortRound(source, result);
        return result;
    }

    public static void FloatToShortRound(float[] source, short[] result) {
        if (source.length != result.length) {
            throw new IllegalArgumentException("Arrays have different dimensions");
        }
        for (int x = 0; x < source.length; ++x) {
            result[x] = (short)(source[x] + 0.5f);
        }
    }

    public static double[] FloatToDouble(float[] source) {
        Allocator allocator = Allocator.Instance();
        double[] result = allocator.newDoubleArray(source.length);
        allocator = null;
        ArrayConverter.FloatToDouble(source, result);
        return result;
    }

    public static void FloatToDouble(float[] source, double[] result) {
        if (source.length != result.length) {
            throw new IllegalArgumentException("Arrays have different dimensions");
        }
        for (int x = 0; x < source.length; ++x) {
            result[x] = source[x];
        }
    }

    public static int[] FloatToInt(float[] source) {
        Allocator allocator = Allocator.Instance();
        int[] result = allocator.newIntArray(source.length);
        allocator = null;
        ArrayConverter.FloatToInt(source, result);
        return result;
    }

    public static void FloatToInt(float[] source, int[] result) {
        if (source.length != result.length) {
            throw new IllegalArgumentException("Arrays have different dimensions");
        }
        for (int x = 0; x < source.length; ++x) {
            result[x] = (int)source[x];
        }
    }

    public static int[] FloatToIntRound(float[] source) {
        Allocator allocator = Allocator.Instance();
        int[] result = allocator.newIntArray(source.length);
        allocator = null;
        ArrayConverter.FloatToIntRound(source, result);
        return result;
    }

    public static void FloatToIntRound(float[] source, int[] result) {
        if (source.length != result.length) {
            throw new IllegalArgumentException("Arrays have different dimensions");
        }
        for (int x = 0; x < source.length; ++x) {
            result[x] = (int)(source[x] + 0.5f);
        }
    }

    public static void RGB_To_HSV(double[] RGB, double[] HSV2) {
        double min;
        double max = RGB[0] >= RGB[1] && RGB[0] >= RGB[2] ? RGB[0] : (RGB[1] >= RGB[0] && RGB[1] >= RGB[2] ? RGB[1] : RGB[2]);
        if (Math.abs(max - (min = RGB[0] <= RGB[1] && RGB[0] <= RGB[2] ? RGB[0] : (RGB[1] <= RGB[0] && RGB[1] <= RGB[2] ? RGB[1] : RGB[2]))) < 1.0E-4) {
            HSV2[0] = 0.0;
        } else if (Math.abs(max - RGB[0]) < 1.0E-4) {
            HSV2[0] = (60.0 * (RGB[1] - RGB[2]) / (max - min) + 360.0) % 360.0;
        } else if (Math.abs(max - RGB[1]) < 1.0E-4) {
            HSV2[0] = 60.0 * (RGB[2] - RGB[0]) / (max - min) + 120.0;
        } else if (Math.abs(max - RGB[2]) < 1.0E-4) {
            HSV2[0] = 60.0 * (RGB[0] - RGB[1]) / (max - min) + 240.0;
        }
        HSV2[1] = max < 1.0E-4 ? 0.0 : 1.0 - min / max;
        HSV2[2] = max;
    }

    public static int[] ByteToInt(byte[] source) {
        Allocator allocator = Allocator.Instance();
        int[] result = allocator.newIntArray(source.length);
        allocator = null;
        ArrayConverter.ByteToInt(source, result);
        return result;
    }

    public static void ByteToInt(byte[] array1, int[] array2) {
        if (array1.length != array2.length) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        for (int i = 0; i < array1.length; ++i) {
            array2[i] = array1[i];
        }
    }

    public static short[] ByteToShort(byte[] source) {
        Allocator allocator = Allocator.Instance();
        short[] result = allocator.newShortArray(source.length);
        allocator = null;
        ArrayConverter.ByteToShort(source, result);
        return result;
    }

    public static void ByteToShort(byte[] array1, short[] array2) {
        if (array1.length != array2.length) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        for (int i = 0; i < array1.length; ++i) {
            array2[i] = array1[i];
        }
    }

    public static float[] ByteToFloat(byte[] source) {
        Allocator allocator = Allocator.Instance();
        float[] result = allocator.newFloatArray(source.length);
        allocator = null;
        ArrayConverter.ByteToFloat(source, result);
        return result;
    }

    public static void ByteToFloat(byte[] array1, float[] array2) {
        if (array1.length != array2.length) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        for (int i = 0; i < array1.length; ++i) {
            array2[i] = array1[i];
        }
    }

    public static double[] ByteToDouble(byte[] source) {
        Allocator allocator = Allocator.Instance();
        double[] result = allocator.newDoubleArray(source.length);
        allocator = null;
        ArrayConverter.ByteToDouble(source, result);
        return result;
    }

    public static void ByteToDouble(byte[] array1, double[] array2) {
        if (array1.length != array2.length) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        for (int i = 0; i < array1.length; ++i) {
            array2[i] = array1[i];
        }
    }

    public static int[] ShortToInt(short[] source) {
        Allocator allocator = Allocator.Instance();
        int[] result = allocator.newIntArray(source.length);
        allocator = null;
        ArrayConverter.ShortToInt(source, result);
        return result;
    }

    public static void ShortToInt(short[] array1, int[] array2) {
        if (array1.length != array2.length) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        for (int i = 0; i < array1.length; ++i) {
            array2[i] = array1[i];
        }
    }

    public static byte[] ShortToByte(short[] source) {
        Allocator allocator = Allocator.Instance();
        byte[] result = allocator.newByteArray(source.length);
        allocator = null;
        ArrayConverter.ShortToByte(source, result);
        return result;
    }

    public static void ShortToByte(short[] array1, byte[] array2) {
        if (array1.length != array2.length) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        for (int i = 0; i < array1.length; ++i) {
            array2[i] = (byte)array1[i];
        }
    }

    public static float[] ShortToFloat(short[] source) {
        Allocator allocator = Allocator.Instance();
        float[] result = allocator.newFloatArray(source.length);
        allocator = null;
        ArrayConverter.ShortToFloat(source, result);
        return result;
    }

    public static void ShortToFloat(short[] array1, float[] array2) {
        if (array1.length != array2.length) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        for (int i = 0; i < array1.length; ++i) {
            array2[i] = array1[i];
        }
    }

    public static double[] ShortToDouble(short[] source) {
        Allocator allocator = Allocator.Instance();
        double[] result = allocator.newDoubleArray(source.length);
        allocator = null;
        ArrayConverter.ShortToDouble(source, result);
        return result;
    }

    public static void ShortToDouble(short[] array1, double[] array2) {
        if (array1.length != array2.length) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        for (int i = 0; i < array1.length; ++i) {
            array2[i] = array1[i];
        }
    }
}

