/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.ncml;

import com.google.common.collect.ImmutableList;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import javax.annotation.Nullable;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.client.catalog.Catalog;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.Dimension;
import ucar.nc2.EnumTypedef;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileSubclass;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.DatasetUrl;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasets;
import ucar.nc2.dataset.SequenceDS;
import ucar.nc2.dataset.StructureDS;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.internal.ncml.Aggregation;
import ucar.nc2.internal.ncml.AggregationExisting;
import ucar.nc2.internal.ncml.AggregationNew;
import ucar.nc2.internal.ncml.AggregationOuter;
import ucar.nc2.internal.ncml.AggregationUnion;
import ucar.nc2.util.AliasTranslator;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.DebugFlags;
import ucar.nc2.util.IO;
import ucar.nc2.util.URLnaming;
import ucar.nc2.util.cache.FileFactory;
import ucar.unidata.util.StringUtil2;

public class NcMLReaderNew {
    private static Logger log = LoggerFactory.getLogger(NcMLReaderNew.class);
    private static final Namespace ncNSHttp = Catalog.ncmlNS;
    private static final Namespace ncNSHttps = Catalog.ncmlNSHttps;
    private static boolean debugURL;
    private static boolean debugXML;
    private static boolean showParsedXML;
    private static boolean debugOpen;
    private static boolean debugConstruct;
    private static boolean debugCmd;
    private static boolean debugAggDetail;
    private Namespace ncNS;
    private String location;
    private boolean explicit;
    @Nullable
    private NetcdfFile refFile;
    private Formatter errlog = new Formatter();

    public static void setDebugFlags(DebugFlags debugFlag) {
        debugURL = debugFlag.isSet("NcML/debugURL");
        debugXML = debugFlag.isSet("NcML/debugXML");
        showParsedXML = debugFlag.isSet("NcML/showParsedXML");
        debugCmd = debugFlag.isSet("NcML/debugCmd");
        debugOpen = debugFlag.isSet("NcML/debugOpen");
        debugConstruct = debugFlag.isSet("NcML/debugConstruct");
        debugAggDetail = debugFlag.isSet("NcML/debugAggDetail");
    }

    public static Set<NetcdfDataset.Enhance> parseEnhanceMode(String enhanceMode) {
        if (enhanceMode == null) {
            return null;
        }
        switch (enhanceMode.toLowerCase()) {
            case "all": {
                return NetcdfDataset.getEnhanceAll();
            }
            case "none": {
                return NetcdfDataset.getEnhanceNone();
            }
            case "convertenums": {
                return EnumSet.of(NetcdfDataset.Enhance.ConvertEnums);
            }
            case "convertunsigned": {
                return EnumSet.of(NetcdfDataset.Enhance.ConvertUnsigned);
            }
            case "applyscaleoffset": {
                return EnumSet.of(NetcdfDataset.Enhance.ApplyScaleOffset);
            }
            case "convertmissing": {
                return EnumSet.of(NetcdfDataset.Enhance.ConvertMissing);
            }
            case "coordsystems": {
                return EnumSet.of(NetcdfDataset.Enhance.CoordSystems);
            }
            case "incompletecoordsystems": {
                return EnumSet.of(NetcdfDataset.Enhance.CoordSystems, NetcdfDataset.Enhance.IncompleteCoordSystems);
            }
            case "true": {
                return NetcdfDataset.getEnhanceAll();
            }
            case "scalemissingdefer": {
                return NetcdfDataset.getEnhanceNone();
            }
            case "alldefer": {
                return EnumSet.of(NetcdfDataset.Enhance.ConvertEnums, NetcdfDataset.Enhance.CoordSystems);
            }
            case "scalemissing": {
                return EnumSet.of(NetcdfDataset.Enhance.ConvertUnsigned, NetcdfDataset.Enhance.ApplyScaleOffset, NetcdfDataset.Enhance.ConvertMissing);
            }
        }
        return null;
    }

    public static void wrapNcML(NetcdfDataset.Builder ncDataset, String ncmlLocation, CancelTask cancelTask) throws IOException {
        Document doc;
        try {
            SAXBuilder builder = new SAXBuilder();
            if (debugURL) {
                System.out.println(" NetcdfDataset URL = <" + ncmlLocation + ">");
            }
            doc = builder.build(ncmlLocation);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
        if (debugXML) {
            System.out.println(" SAXBuilder done");
        }
        if (showParsedXML) {
            XMLOutputter xmlOut = new XMLOutputter();
            System.out.println("*** NetcdfDataset/showParsedXML = \n" + xmlOut.outputString(doc) + "\n*******");
        }
        Element netcdfElem = doc.getRootElement();
        NcMLReaderNew reader = new NcMLReaderNew();
        reader.readNetcdf(ncmlLocation, ncDataset, netcdfElem, cancelTask);
        if (debugOpen) {
            System.out.println("***NcMLReader.wrapNcML result= \n" + ncDataset);
        }
    }

    public static void wrapNcMLresource(NetcdfDataset.Builder ncDataset, String ncmlResourceLocation, CancelTask cancelTask) throws IOException {
        ClassLoader cl = ncDataset.getClass().getClassLoader();
        try (InputStream is = cl.getResourceAsStream(ncmlResourceLocation);){
            Document doc;
            if (is == null) {
                throw new FileNotFoundException(ncmlResourceLocation);
            }
            if (debugXML) {
                System.out.println(" NetcdfDataset URL = <" + ncmlResourceLocation + ">");
                try (InputStream is2 = cl.getResourceAsStream(ncmlResourceLocation);){
                    System.out.println(" contents=\n" + IO.readContents(is2));
                }
            }
            try {
                SAXBuilder builder = new SAXBuilder();
                if (debugURL) {
                    System.out.println(" NetcdfDataset URL = <" + ncmlResourceLocation + ">");
                }
                doc = builder.build(is);
            }
            catch (JDOMException e) {
                throw new IOException(e.getMessage());
            }
            if (debugXML) {
                System.out.println(" SAXBuilder done");
            }
            if (showParsedXML) {
                XMLOutputter xmlOut = new XMLOutputter();
                System.out.println("*** NetcdfDataset/showParsedXML = \n" + xmlOut.outputString(doc) + "\n*******");
            }
            Element netcdfElem = doc.getRootElement();
            NcMLReaderNew reader = new NcMLReaderNew();
            reader.readNetcdf(ncmlResourceLocation, ncDataset, netcdfElem, cancelTask);
            if (debugOpen) {
                System.out.println("***NcMLReader.wrapNcML result= \n" + ncDataset);
            }
        }
    }

    public static NetcdfDataset.Builder mergeNcML(NetcdfFile ref, @Nullable Element ncmlElem) throws IOException {
        NetcdfFile.Builder targetDS = new NetcdfDataset(ref.toBuilder()).toBuilder();
        if (ncmlElem != null) {
            NcMLReaderNew reader = new NcMLReaderNew();
            reader.readGroup((NetcdfDataset.Builder)targetDS, null, null, ncmlElem);
        }
        return targetDS;
    }

    public static NetcdfDataset.Builder readNcML(String ncmlLocation, String referencedDatasetUri, CancelTask cancelTask) throws IOException {
        Document doc;
        URL url = new URL(ncmlLocation);
        if (debugURL) {
            System.out.println(" NcMLReader open " + ncmlLocation);
            System.out.println("   URL = " + url);
            System.out.println("   external form = " + url.toExternalForm());
            System.out.println("   protocol = " + url.getProtocol());
            System.out.println("   host = " + url.getHost());
            System.out.println("   path = " + url.getPath());
            System.out.println("  file = " + url.getFile());
        }
        try {
            SAXBuilder builder = new SAXBuilder();
            if (debugURL) {
                System.out.println(" NetcdfDataset URL = <" + url + ">");
            }
            doc = builder.build(url);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
        if (debugXML) {
            System.out.println(" SAXBuilder done");
        }
        if (showParsedXML) {
            XMLOutputter xmlOut = new XMLOutputter();
            System.out.println("*** NetcdfDataset/showParsedXML = \n" + xmlOut.outputString(doc) + "\n*******");
        }
        Element netcdfElem = doc.getRootElement();
        if (referencedDatasetUri == null && (referencedDatasetUri = netcdfElem.getAttributeValue("location")) == null) {
            referencedDatasetUri = netcdfElem.getAttributeValue("url");
        }
        if (referencedDatasetUri != null) {
            referencedDatasetUri = AliasTranslator.translateAlias(referencedDatasetUri);
        }
        NcMLReaderNew reader = new NcMLReaderNew();
        return reader.readNcML(ncmlLocation, referencedDatasetUri, netcdfElem, cancelTask);
    }

    private NetcdfDataset.Builder readNcML(String ncmlLocation, @Nullable String referencedDatasetUri, Element netcdfElem, @Nullable CancelTask cancelTask) throws IOException {
        Element elemE;
        this.ncNS = ncNSHttp;
        if (netcdfElem.getNamespaceURI().startsWith("https")) {
            this.ncNS = ncNSHttps;
        }
        if ((referencedDatasetUri = URLnaming.resolve(ncmlLocation, referencedDatasetUri)) != null && referencedDatasetUri.equals(ncmlLocation)) {
            throw new IllegalArgumentException("NcML location attribute refers to the NcML document itself" + referencedDatasetUri);
        }
        String iospS = netcdfElem.getAttributeValue("iosp");
        String iospParam = netcdfElem.getAttributeValue("iospParam");
        if (iospParam == null) {
            iospParam = netcdfElem.getChild("iospParam", this.ncNS);
        }
        String bufferSizeS = netcdfElem.getAttributeValue("buffer_size");
        int buffer_size = -1;
        if (bufferSizeS != null) {
            buffer_size = Integer.parseInt(bufferSizeS);
        }
        if (referencedDatasetUri != null) {
            if (iospS != null) {
                try {
                    this.refFile = new NetcdfFileSubclass(iospS, iospParam, referencedDatasetUri, buffer_size, cancelTask);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            } else {
                DatasetUrl durl = DatasetUrl.findDatasetUrl(referencedDatasetUri);
                this.refFile = NetcdfDatasets.openFile(durl, buffer_size, cancelTask, null);
            }
        }
        this.explicit = (elemE = netcdfElem.getChild("explicit", this.ncNS)) != null;
        Object builder = NetcdfDataset.builder().setOrgFile(this.refFile);
        if (this.refFile != null && !this.explicit) {
            ((NetcdfDataset.Builder)builder).copyFrom(this.refFile);
        }
        this.readNetcdf(ncmlLocation, (NetcdfDataset.Builder)builder, netcdfElem, cancelTask);
        return builder;
    }

    private void readNetcdf(String ncmlLocation, NetcdfDataset.Builder builder, Element netcdfElem, @Nullable CancelTask cancelTask) throws IOException {
        this.location = ncmlLocation;
        Namespace use = netcdfElem.getNamespace();
        if (!use.equals((Object)ncNSHttp) && !use.equals((Object)ncNSHttps)) {
            String message = String.format("Namespace specified in NcML must be either '%s' or '%s', but was '%s'.", ncNSHttp.getURI(), ncNSHttps.getURI(), use.getURI());
            throw new IllegalArgumentException(message);
        }
        if (ncmlLocation != null) {
            builder.setLocation(ncmlLocation);
        }
        builder.setId(netcdfElem.getAttributeValue("id"));
        builder.setTitle(netcdfElem.getAttributeValue("title"));
        Element aggElem = netcdfElem.getChild("aggregation", this.ncNS);
        if (aggElem != null) {
            Aggregation agg = this.readAgg(aggElem, ncmlLocation, builder, cancelTask);
            builder.setAggregation(agg);
            agg.build(cancelTask);
        }
        this.readGroup(builder, null, null, netcdfElem);
        String errors = this.errlog.toString();
        if (!errors.isEmpty()) {
            throw new IllegalArgumentException("NcML had fatal errors:" + errors);
        }
        Set<NetcdfDataset.Enhance> mode = NcMLReaderNew.parseEnhanceMode(netcdfElem.getAttributeValue("enhance"));
        if (mode != null) {
            builder.setEnhanceMode(mode);
        }
    }

    private Group.Builder readGroup(NetcdfDataset.Builder builder, @Nullable Group.Builder parent, @Nullable Group refParent, Element groupElem) {
        Group.Builder groupBuilder;
        Group refGroup = null;
        if (parent == null) {
            refGroup = this.refFile == null ? null : this.refFile.getRootGroup();
            groupBuilder = builder.rootGroup;
        } else {
            String name = groupElem.getAttributeValue("name");
            if (name == null) {
                this.errlog.format("NcML Group name is required (%s)%n", groupElem);
                return null;
            }
            Object nameInFile = groupElem.getAttributeValue("orgName");
            if (nameInFile == null) {
                nameInFile = name;
            }
            if (refParent != null) {
                refGroup = refParent.findGroup((String)nameInFile);
            }
            if (refGroup == null) {
                groupBuilder = Group.builder(parent).setName(name);
                parent.addGroup(groupBuilder);
                if (debugConstruct) {
                    System.out.println(" add new group = " + name);
                }
            } else {
                String finalName = nameInFile;
                groupBuilder = parent.findGroup(finalName).orElseThrow(() -> new IllegalStateException("Cant find Group " + finalName));
                groupBuilder.setName(name);
            }
        }
        List attList = groupElem.getChildren("attribute", this.ncNS);
        for (Object attElem : attList) {
            this.readAtt(groupBuilder.getAttributeContainer(), refGroup, (Element)attElem);
        }
        List etdList = groupElem.getChildren("enumTypedef", this.ncNS);
        for (Object elem : etdList) {
            this.readEnumTypedef(groupBuilder, (Element)elem);
        }
        List dimList = groupElem.getChildren("dimension", this.ncNS);
        for (Object dimElem : dimList) {
            this.readDim(groupBuilder, refGroup, (Element)dimElem);
        }
        List varList = groupElem.getChildren("variable", this.ncNS);
        for (Object varElem : varList) {
            this.readVariable(groupBuilder, refGroup, (Element)varElem);
        }
        List removeList = groupElem.getChildren("remove", this.ncNS);
        for (Element e : removeList) {
            this.cmdRemove(groupBuilder, e.getAttributeValue("type"), e.getAttributeValue("name"));
        }
        List groupList = groupElem.getChildren("group", this.ncNS);
        for (Element gElem : groupList) {
            this.readGroup(builder, groupBuilder, refGroup, gElem);
        }
        return groupBuilder;
    }

    private void readAtt(AttributeContainer dest, @Nullable AttributeContainer ref, Element attElem) {
        boolean newName;
        String refName = ref == null ? "no reference object" : ref.getName();
        String name = attElem.getAttributeValue("name");
        if (name == null) {
            this.errlog.format("NcML Attribute name is required (%s)%n", attElem);
            return;
        }
        String nameInFile = attElem.getAttributeValue("orgName");
        boolean bl = newName = nameInFile != null && !nameInFile.equals(name);
        if (nameInFile == null) {
            nameInFile = name;
        } else if (null == this.findAttribute(ref, nameInFile)) {
            this.errlog.format("NcML attribute orgName '%s' doesnt exist. att=%s in=%s%n", nameInFile, name, refName);
            return;
        }
        Attribute oldatt = this.findAttribute(ref, nameInFile);
        if (oldatt == null) {
            if (debugConstruct) {
                System.out.println(" add new att = " + name);
            }
            try {
                Array values = NcMLReaderNew.readAttributeValues(attElem);
                dest.addAttribute(new Attribute(name, values));
            }
            catch (RuntimeException e) {
                this.errlog.format("NcML new Attribute Exception: %s att=%s in=%s%n", e.getMessage(), name, refName);
            }
        } else {
            boolean hasValue;
            if (debugConstruct) {
                System.out.println(" modify existing att = " + name);
            }
            boolean bl2 = hasValue = attElem.getAttribute("value") != null;
            if (hasValue) {
                try {
                    Array values = NcMLReaderNew.readAttributeValues(attElem);
                    dest.addAttribute(new Attribute(name, values));
                }
                catch (RuntimeException e) {
                    this.errlog.format("NcML existing Attribute Exception: %s att=%s in=%s%n", e.getMessage(), name, refName);
                    return;
                }
            } else {
                Array oldval = oldatt.getValues();
                if (oldval != null) {
                    dest.addAttribute(Attribute.builder(name).setValues(oldatt.getValues()).build());
                } else {
                    DataType dtype;
                    String unS = attElem.getAttributeValue("isUnsigned");
                    boolean isUnsignedSet = "true".equalsIgnoreCase(unS);
                    String typeS = attElem.getAttributeValue("type");
                    DataType dataType = dtype = typeS == null ? DataType.STRING : DataType.getType(typeS);
                    if (isUnsignedSet) {
                        dtype = dtype.withSignedness(DataType.Signedness.UNSIGNED);
                    }
                    dest.addAttribute(Attribute.builder(name).setDataType(dtype).build());
                }
            }
            if (newName && !this.explicit) {
                dest.remove(oldatt);
                if (debugConstruct) {
                    System.out.println(" remove old att = " + nameInFile);
                }
            }
        }
    }

    private static Array readAttributeValues(Element s2) throws IllegalArgumentException {
        String sep;
        String unS;
        boolean isUnsignedSet;
        DataType dtype;
        String valString = s2.getAttributeValue("value");
        if (valString == null) {
            valString = s2.getTextNormalize();
        }
        if (valString == null) {
            throw new IllegalArgumentException("No value specified");
        }
        String type = s2.getAttributeValue("type");
        DataType dataType = dtype = type == null ? DataType.STRING : DataType.getType(type);
        if (dtype == DataType.CHAR) {
            dtype = DataType.STRING;
        }
        if ((isUnsignedSet = "true".equalsIgnoreCase(unS = s2.getAttributeValue("isUnsigned"))) && dtype.isIntegral() && !dtype.isUnsigned()) {
            dtype = dtype.withSignedness(DataType.Signedness.UNSIGNED);
        }
        if ((sep = s2.getAttributeValue("separator")) == null && dtype == DataType.STRING) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(valString);
            return Array.makeArray(dtype, list);
        }
        if (sep == null) {
            sep = " ";
        }
        ArrayList<String> stringValues = new ArrayList<String>();
        StringTokenizer tokn = new StringTokenizer(valString, sep);
        while (tokn.hasMoreTokens()) {
            stringValues.add(tokn.nextToken());
        }
        return Array.makeArray(dtype, stringValues);
    }

    private Attribute findAttribute(AttributeContainer atts, String name) {
        if (atts == null) {
            return null;
        }
        return atts.findAttribute(name);
    }

    private void readDim(Group.Builder groupBuilder, @Nullable Group refGroup, Element dimElem) {
        Dimension dim;
        String name = dimElem.getAttributeValue("name");
        if (name == null) {
            this.errlog.format("NcML Dimension name is required (%s)%n", dimElem);
            return;
        }
        String nameInFile = dimElem.getAttributeValue("orgName");
        if (nameInFile == null) {
            nameInFile = name;
        }
        Dimension dimension = dim = refGroup == null ? null : refGroup.findDimension(nameInFile);
        if (dim == null) {
            String lengthS = dimElem.getAttributeValue("length");
            if (lengthS == null) {
                this.errlog.format("NcML Dimension length is required (%s)%n", dimElem);
                return;
            }
            String isUnlimitedS = dimElem.getAttributeValue("isUnlimited");
            String isSharedS = dimElem.getAttributeValue("isShared");
            String isVariableLengthS = dimElem.getAttributeValue("isVariableLength");
            boolean isUnlimited = "true".equalsIgnoreCase(isUnlimitedS);
            boolean isVariableLength = "true".equalsIgnoreCase(isVariableLengthS);
            boolean isShared = true;
            if ("false".equalsIgnoreCase(isSharedS)) {
                isShared = false;
            }
            int len = isVariableLength ? Dimension.VLEN.getLength() : Integer.parseInt(lengthS);
            if (debugConstruct) {
                System.out.println(" add new dim = " + name);
            }
            groupBuilder.replaceDimension(Dimension.builder().setName(name).setIsShared(isShared).setIsUnlimited(isUnlimited).setIsVariableLength(isVariableLength).setLength(len).build());
        } else {
            Dimension.Builder newDim = dim.toBuilder();
            newDim.setName(name);
            String lengthS = dimElem.getAttributeValue("length");
            String isUnlimitedS = dimElem.getAttributeValue("isUnlimited");
            String isSharedS = dimElem.getAttributeValue("isShared");
            String isUnknownS = dimElem.getAttributeValue("isVariableLength");
            if (isUnlimitedS != null) {
                newDim.setIsUnlimited(isUnlimitedS.equalsIgnoreCase("true"));
            }
            if (isSharedS != null) {
                newDim.setIsShared(!isSharedS.equalsIgnoreCase("false"));
            }
            if (isUnknownS != null) {
                newDim.setIsVariableLength(isUnknownS.equalsIgnoreCase("true"));
            }
            if (lengthS != null && !dim.isVariableLength()) {
                int len = Integer.parseInt(lengthS);
                newDim.setLength(len);
            }
            if (debugConstruct) {
                System.out.println(" modify existing dim = " + name);
            }
            groupBuilder.removeDimension(name);
            groupBuilder.addDimension(newDim.build());
        }
    }

    private void readEnumTypedef(Group.Builder g2, Element etdElem) {
        String name = etdElem.getAttributeValue("name");
        if (name == null) {
            this.errlog.format("NcML enumTypedef name is required (%s)%n", etdElem);
            return;
        }
        String typeS = etdElem.getAttributeValue("type");
        DataType baseType = typeS == null ? DataType.ENUM1 : DataType.getType(typeS);
        HashMap<Integer, String> map = new HashMap<Integer, String>(100);
        for (Element e : etdElem.getChildren("enum", this.ncNS)) {
            String key = e.getAttributeValue("key");
            String value = e.getTextNormalize();
            if (key == null) {
                this.errlog.format("NcML enumTypedef enum key attribute is required (%s)%n", e);
                continue;
            }
            if (value == null) {
                this.errlog.format("NcML enumTypedef enum value is required (%s)%n", e);
                continue;
            }
            try {
                int keyi = Integer.parseInt(key);
                map.put(keyi, value);
            }
            catch (Exception e2) {
                this.errlog.format("NcML enumTypedef enum key attribute not an integer (%s)%n", e);
            }
        }
        EnumTypedef td = new EnumTypedef(name, map, baseType);
        g2.addEnumTypedef(td);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void readVariable(Group.Builder groupBuilder, @Nullable Group refGroup, Element varElem) {
        String name = varElem.getAttributeValue("name");
        if (name == null) {
            this.errlog.format("NcML Variable name is required (%s)%n", varElem);
            return;
        }
        String nameInFile = Optional.ofNullable(varElem.getAttributeValue("orgName")).orElse(name);
        DataType dtype = null;
        String typeS = varElem.getAttributeValue("type");
        if (typeS != null) {
            dtype = DataType.getType(typeS);
        }
        Variable refv = refGroup == null ? null : refGroup.findVariable(nameInFile);
        Optional<Variable.Builder<?>> addedFromAgg = groupBuilder.findVariable(nameInFile);
        if (refv == null && !addedFromAgg.isPresent()) {
            if (dtype == null) {
                this.errlog.format("NcML Variable dtype is required for new variable (%s)%n", name);
                return;
            }
            if (dtype != DataType.STRUCTURE && dtype != DataType.SEQUENCE) {
                groupBuilder.addVariable(this.readVariableNew(groupBuilder, dtype, varElem));
                return;
            }
            groupBuilder.addVariable(this.readStructureNew(groupBuilder, varElem));
            return;
        }
        if (refv == null) {
            DataType finalDtype = dtype;
            addedFromAgg.ifPresent(agg -> {
                if (agg instanceof VariableDS.Builder) {
                    VariableDS.Builder aggDs = (VariableDS.Builder)agg;
                    aggDs.setOriginalName(nameInFile);
                }
                DataType reallyFinalDtype = finalDtype != null ? finalDtype : agg.dataType;
                this.augmentVariableNew((Variable.Builder)agg, reallyFinalDtype, varElem);
            });
            return;
        }
        if (dtype == null) {
            dtype = refv.getDataType();
        }
        if (dtype != DataType.STRUCTURE && dtype != DataType.SEQUENCE) {
            this.readVariableExisting(groupBuilder, dtype, refv, varElem).ifPresent(groupBuilder::addVariable);
            return;
        }
        this.readStructureExisting(groupBuilder, dtype, (Structure)refv, varElem).ifPresent(groupBuilder::addVariable);
    }

    private Optional<VariableDS.Builder> readVariableExisting(Group.Builder groupBuilder, DataType dtype, Variable refv, Element varElem) {
        boolean isUnsignedSet;
        String dimNames;
        String name = varElem.getAttributeValue("name");
        String typedefS = dtype.isEnum() ? varElem.getAttributeValue("typedef") : null;
        String nameInFile = Optional.ofNullable(varElem.getAttributeValue("orgName")).orElse(name);
        Object v = this.explicit ? VariableDS.builder().setOriginalVariable(refv) : (VariableDS.Builder)groupBuilder.findVariable(nameInFile).orElseThrow(() -> new IllegalStateException("Cant find variable " + nameInFile));
        ((Variable.Builder)((Variable.Builder)v).setName(name)).setDataType(dtype);
        if (typedefS != null) {
            ((Variable.Builder)v).setEnumTypeName(typedefS);
        }
        if ((dimNames = varElem.getAttributeValue("shape")) != null) {
            ImmutableList<Dimension> varDims = groupBuilder.makeDimensionsList(dimNames);
            ((Variable.Builder)v).addDimensions(varDims);
        }
        List attList = varElem.getChildren("attribute", this.ncNS);
        for (Element attElem : attList) {
            this.readAtt(((Variable.Builder)v).getAttributeContainer(), refv, attElem);
        }
        Attribute att = ((Variable.Builder)v).getAttributeContainer().findAttribute("_Unsigned");
        boolean bl = isUnsignedSet = att != null && att.getStringValue().equalsIgnoreCase("true");
        if (isUnsignedSet) {
            dtype = dtype.withSignedness(DataType.Signedness.UNSIGNED);
            ((Variable.Builder)v).setDataType(dtype);
        }
        List removeList = varElem.getChildren("remove", this.ncNS);
        for (Element remElem : removeList) {
            this.cmdRemove((Variable.Builder)v, remElem.getAttributeValue("type"), remElem.getAttributeValue("name"));
        }
        Element valueElem = varElem.getChild("values", this.ncNS);
        if (valueElem != null) {
            this.readValues((Variable.Builder)v, dtype, varElem, valueElem);
        }
        return this.explicit ? Optional.of(v) : Optional.empty();
    }

    private VariableDS.Builder readVariableNew(Group.Builder groupBuilder, DataType dtype, Element varElem) {
        String typedefS;
        Element valueElem;
        String name = varElem.getAttributeValue("name");
        VariableDS.Builder v = (VariableDS.Builder)((VariableDS.Builder)VariableDS.builder().setName(name)).setDataType(dtype);
        String dimNames = varElem.getAttributeValue("shape");
        if (dimNames != null) {
            v.setDimensionsByName(dimNames);
        }
        if ((valueElem = varElem.getChild("values", this.ncNS)) != null) {
            this.readValues(v, dtype, varElem, valueElem);
        }
        List attList = varElem.getChildren("attribute", this.ncNS);
        for (Element attElem : attList) {
            this.readAtt(v.getAttributeContainer(), null, attElem);
        }
        String string = typedefS = dtype.isEnum() ? varElem.getAttributeValue("typedef") : null;
        if (typedefS != null) {
            v.setEnumTypeName(typedefS);
        }
        return v;
    }

    private void augmentVariableNew(Variable.Builder addedFromAgg, DataType dtype, Element varElem) {
        String typedefS;
        Element valueElem;
        String name = varElem.getAttributeValue("name");
        ((Variable.Builder)addedFromAgg.setName(name)).setDataType(dtype);
        String dimNames = varElem.getAttributeValue("shape");
        if (dimNames != null) {
            addedFromAgg.setDimensionsByName(dimNames);
        }
        if ((valueElem = varElem.getChild("values", this.ncNS)) != null) {
            this.readValues(addedFromAgg, dtype, varElem, valueElem);
        }
        List attList = varElem.getChildren("attribute", this.ncNS);
        for (Element attElem : attList) {
            this.readAtt(addedFromAgg.getAttributeContainer(), null, attElem);
        }
        String string = typedefS = dtype.isEnum() ? varElem.getAttributeValue("typedef") : null;
        if (typedefS != null) {
            addedFromAgg.setEnumTypeName(typedefS);
        }
    }

    private Optional<StructureDS.Builder> readStructureExisting(Group.Builder groupBuilder, DataType dtype, Structure refv, Element varElem) {
        String name = varElem.getAttributeValue("name");
        String nameInFile = Optional.ofNullable(varElem.getAttributeValue("orgName")).orElse(name);
        StructureDS.Builder structBuilder = this.explicit ? (dtype == DataType.STRUCTURE ? ((StructureDS.Builder)StructureDS.builder().setName(name)).setOriginalVariable(refv) : ((StructureDS.Builder)SequenceDS.builder().setName(name)).setOriginalVariable(refv)) : (StructureDS.Builder)groupBuilder.findVariable(nameInFile).orElseThrow(() -> new IllegalStateException("Cant find variable " + nameInFile));
        String dimNames = varElem.getAttributeValue("shape");
        if (dimNames != null) {
            ImmutableList<Dimension> varDims = groupBuilder.makeDimensionsList(dimNames);
            structBuilder.addDimensions(varDims);
        }
        List attList = varElem.getChildren("attribute", this.ncNS);
        for (Object attElem : attList) {
            this.readAtt(structBuilder.getAttributeContainer(), refv, (Element)attElem);
        }
        List varList = varElem.getChildren("variable", this.ncNS);
        for (Element vElem : varList) {
            this.readVariableNested(groupBuilder, structBuilder, null, vElem);
        }
        List removeList = varElem.getChildren("remove", this.ncNS);
        for (Element remElem : removeList) {
            this.cmdRemove(structBuilder, remElem.getAttributeValue("type"), remElem.getAttributeValue("name"));
        }
        return this.explicit ? Optional.of(structBuilder) : Optional.empty();
    }

    private StructureDS.Builder readStructureNew(Group.Builder groupBuilder, Element varElem) {
        String name = varElem.getAttributeValue("name");
        String type = varElem.getAttributeValue("type");
        DataType dtype = DataType.getType(type);
        String dimNames = varElem.getAttributeValue("shape");
        if (dimNames == null) {
            dimNames = "";
        }
        ImmutableList<Dimension> varDims = groupBuilder.makeDimensionsList(dimNames);
        StructureDS.Builder structBuilder = dtype == DataType.STRUCTURE ? (StructureDS.Builder)((StructureDS.Builder)StructureDS.builder().setName(name)).addDimensions(varDims) : (StructureDS.Builder)SequenceDS.builder().setName(name);
        List varList = varElem.getChildren("variable", this.ncNS);
        for (Element vElem : varList) {
            this.readVariableNested(groupBuilder, structBuilder, null, vElem);
        }
        List attList = varElem.getChildren("attribute", this.ncNS);
        for (Element attElem : attList) {
            this.readAtt(structBuilder.getAttributeContainer(), null, attElem);
        }
        return structBuilder;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void readVariableNested(Group.Builder groupBuilder, StructureDS.Builder structBuilder, @Nullable Structure refStructure, Element varElem) {
        Variable refv;
        String name = varElem.getAttributeValue("name");
        if (name == null) {
            this.errlog.format("NcML Variable name is required (%s)%n", varElem);
            return;
        }
        String nameInFile = Optional.ofNullable(varElem.getAttributeValue("orgName")).orElse(name);
        DataType dtype = null;
        String typeS = varElem.getAttributeValue("type");
        if (typeS != null) {
            dtype = DataType.getType(typeS);
        }
        Variable variable = refv = refStructure == null ? null : refStructure.findVariable(nameInFile);
        if (refv == null) {
            if (dtype == null) {
                this.errlog.format("NcML Variable dtype is required for new (nested) variable (%s)%n", name);
                return;
            }
            if (dtype != DataType.STRUCTURE && dtype != DataType.SEQUENCE) {
                structBuilder.addMemberVariable(this.readVariableNew(groupBuilder, dtype, varElem));
                return;
            }
            structBuilder.addMemberVariable(this.readStructureNew(groupBuilder, varElem));
            return;
        }
        if (dtype == null) {
            dtype = refv.getDataType();
        }
        if (dtype != DataType.STRUCTURE && dtype != DataType.SEQUENCE) {
            this.readVariableExisting(groupBuilder, dtype, refv, varElem).ifPresent(structBuilder::addMemberVariable);
            return;
        }
        this.readStructureExisting(groupBuilder, dtype, (Structure)refv, varElem).ifPresent(structBuilder::addMemberVariable);
    }

    private void readValues(Variable.Builder v, DataType dtype, Element varElem, Element valuesElem) {
        try {
            int npts;
            String fromAttribute = valuesElem.getAttributeValue("fromAttribute");
            if (fromAttribute != null) {
                Attribute att;
                if (this.refFile == null) {
                    this.errlog.format("NcML fromAttribute '%s' with no referenced Dataset%n", fromAttribute);
                    return;
                }
                int pos = fromAttribute.indexOf(64);
                if (pos > 0) {
                    String varName = fromAttribute.substring(0, pos);
                    String attName = fromAttribute.substring(pos + 1);
                    Variable vFrom = this.refFile.findVariable(varName);
                    if (vFrom == null) {
                        this.errlog.format("Cant find variable %s (%s) %n", fromAttribute, v.shortName);
                        return;
                    }
                    att = vFrom.findAttribute(attName);
                } else {
                    String attName = pos == 0 ? fromAttribute.substring(1) : fromAttribute;
                    att = this.refFile.findAttribute(attName);
                }
                if (att == null) {
                    this.errlog.format("Cant find attribute %s %n", fromAttribute);
                    return;
                }
                Array data = att.getValues();
                v.setCachedData(data, true);
                return;
            }
            String startS = valuesElem.getAttributeValue("start");
            String incrS = valuesElem.getAttributeValue("increment");
            String nptsS = valuesElem.getAttributeValue("npts");
            int n = npts = nptsS == null ? 0 : Integer.parseInt(nptsS);
            if (startS != null && incrS != null) {
                double start = Double.parseDouble(startS);
                double incr = Double.parseDouble(incrS);
                if (npts == 0) {
                    v.setAutoGen(start, incr);
                    if (v.getRank() > 0) {
                        v.setDimensionsByName(v.makeDimensionsString());
                    }
                } else {
                    Array data = Array.makeArray(dtype, npts, start, incr);
                    v.setCachedData(data, true);
                }
                return;
            }
            String values = varElem.getChildText("values", this.ncNS);
            String sep = valuesElem.getAttributeValue("separator");
            if (dtype == DataType.CHAR) {
                int nhave = values.length();
                char[] data = new char[nhave];
                for (int i = 0; i < nhave; ++i) {
                    data[i] = values.charAt(i);
                }
                Array dataArray = Array.factory(DataType.CHAR, new int[]{nhave}, (Object)data);
                v.setCachedData(dataArray, true);
            } else {
                List<String> valList = StringUtil2.getTokens(values, sep);
                Array data = Array.makeArray(dtype, valList);
                v.setCachedData(data, true);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("NCML Reading on " + v.shortName, t);
        }
    }

    private Aggregation readAgg(Element aggElem, String ncmlLocation, NetcdfDataset.Builder builder, CancelTask cancelTask) {
        boolean needMerge;
        Aggregation agg;
        String dimName = aggElem.getAttributeValue("dimName");
        String type = aggElem.getAttributeValue("type");
        String recheck = aggElem.getAttributeValue("recheckEvery");
        if (type.equalsIgnoreCase("joinExisting")) {
            agg = new AggregationExisting(builder, dimName, recheck);
        } else if (type.equalsIgnoreCase("joinNew")) {
            agg = new AggregationNew(builder, dimName, recheck);
        } else if (type.equalsIgnoreCase("union")) {
            agg = new AggregationUnion(builder, dimName, recheck);
        } else {
            throw new IllegalArgumentException("Unsupported aggregation type=" + type);
        }
        if (agg instanceof AggregationOuter) {
            String varName;
            AggregationOuter aggo = (AggregationOuter)agg;
            String timeUnitsChange = aggElem.getAttributeValue("timeUnitsChange");
            if (timeUnitsChange != null) {
                aggo.setTimeUnitsChange(timeUnitsChange.equalsIgnoreCase("true"));
            }
            List list = aggElem.getChildren("variableAgg", this.ncNS);
            for (Element vaggElem : list) {
                varName = vaggElem.getAttributeValue("name");
                aggo.addVariable(varName);
            }
            list = aggElem.getChildren("promoteGlobalAttribute", this.ncNS);
            for (Element gattElem : list) {
                varName = gattElem.getAttributeValue("name");
                String orgName = gattElem.getAttributeValue("orgName");
                aggo.addVariableFromGlobalAttribute(varName, orgName);
            }
            list = aggElem.getChildren("promoteGlobalAttributeCompose", this.ncNS);
            for (Element gattElem : list) {
                varName = gattElem.getAttributeValue("name");
                String format = gattElem.getAttributeValue("format");
                String orgName = gattElem.getAttributeValue("orgName");
                aggo.addVariableFromGlobalAttributeCompose(varName, format, orgName);
            }
            list = aggElem.getChildren("cacheVariable", this.ncNS);
            for (Element gattElem : list) {
                varName = gattElem.getAttributeValue("name");
                aggo.addCacheVariable(varName, null);
            }
        }
        List ncList = aggElem.getChildren("netcdf", this.ncNS);
        for (Object netcdfElemNested : ncList) {
            String location = netcdfElemNested.getAttributeValue("location");
            if (location == null) {
                location = netcdfElemNested.getAttributeValue("url");
            }
            if (location != null) {
                location = AliasTranslator.translateAlias(location);
            }
            String id = netcdfElemNested.getAttributeValue("id");
            String ncoords = netcdfElemNested.getAttributeValue("ncoords");
            String coordValueS = netcdfElemNested.getAttributeValue("coordValue");
            String sectionSpec = netcdfElemNested.getAttributeValue("section");
            NcmlElementReader reader = new NcmlElementReader(ncmlLocation, location, (Element)netcdfElemNested);
            String cacheName = location != null ? location : ncmlLocation;
            cacheName = cacheName + "#" + netcdfElemNested.hashCode();
            String realLocation = URLnaming.resolveFile(ncmlLocation, location);
            agg.addExplicitDataset(cacheName, realLocation, id, ncoords, coordValueS, sectionSpec, reader);
            if (cancelTask != null && cancelTask.isCancel()) {
                return agg;
            }
            if (!debugAggDetail) continue;
            System.out.println(" debugAgg: nested dataset = " + location);
        }
        List dirList = aggElem.getChildren("scan", this.ncNS);
        for (Element scanElem : dirList) {
            String dirLocation = scanElem.getAttributeValue("location");
            if (dirLocation == null) {
                throw new IllegalArgumentException("scan element must have location attribute");
            }
            dirLocation = AliasTranslator.translateAlias(dirLocation);
            String regexpPatternString = scanElem.getAttributeValue("regExp");
            String suffix = scanElem.getAttributeValue("suffix");
            String subdirs = scanElem.getAttributeValue("subdirs");
            String olderS = scanElem.getAttributeValue("olderThan");
            String dateFormatMark = scanElem.getAttributeValue("dateFormatMark");
            Set<NetcdfDataset.Enhance> enhanceMode = NetcdfDataset.parseEnhanceMode(scanElem.getAttributeValue("enhance"));
            dirLocation = URLnaming.resolve(ncmlLocation, dirLocation);
            Element cdElement = scanElem.getChild("crawlableDatasetImpl", this.ncNS);
            agg.addDatasetScan(cdElement, dirLocation, suffix, regexpPatternString, dateFormatMark, enhanceMode, subdirs, olderS);
            if (cancelTask != null && cancelTask.isCancel()) {
                return agg;
            }
            if (!debugAggDetail) continue;
            System.out.println(" debugAgg: nested dirLocation = " + dirLocation);
        }
        Element collElem = aggElem.getChild("collection", this.ncNS);
        if (collElem != null) {
            agg.addCollection(collElem.getAttributeValue("spec"), collElem.getAttributeValue("olderThan"));
        }
        boolean bl = needMerge = !aggElem.getChildren("attribute", this.ncNS).isEmpty();
        if (!needMerge) {
            boolean bl2 = needMerge = !aggElem.getChildren("variable", this.ncNS).isEmpty();
        }
        if (!needMerge) {
            boolean bl3 = needMerge = !aggElem.getChildren("dimension", this.ncNS).isEmpty();
        }
        if (!needMerge) {
            boolean bl4 = needMerge = !aggElem.getChildren("group", this.ncNS).isEmpty();
        }
        if (!needMerge) {
            boolean bl5 = needMerge = !aggElem.getChildren("remove", this.ncNS).isEmpty();
        }
        if (needMerge) {
            agg.setModifications(aggElem);
        }
        return agg;
    }

    private void cmdRemove(Group.Builder g2, String type, String name) {
        boolean err = false;
        switch (type) {
            case "dimension": {
                if (g2.removeDimension(name)) break;
                err = true;
                break;
            }
            case "variable": {
                if (g2.removeVariable(name)) break;
                err = true;
                break;
            }
            case "attribute": {
                if (g2.getAttributeContainer().removeAttribute(name)) break;
                err = true;
            }
        }
        if (err) {
            Formatter f = new Formatter();
            f.format("CMD remove %s CANT find %s location %s%n", type, name, this.location);
            log.info(f.toString());
        }
    }

    private void cmdRemove(Variable.Builder v, String type, String name) {
        Structure.Builder s2;
        boolean err = false;
        if (type.equals("attribute")) {
            if (!v.getAttributeContainer().removeAttribute(name)) {
                err = true;
            }
        } else if (type.equals("variable") && v instanceof Structure.Builder && !(s2 = (Structure.Builder)v).removeMemberVariable(name)) {
            err = true;
        }
        if (err) {
            Formatter f = new Formatter();
            f.format("CMD remove %s CANT find %s location %s%n", type, name, this.location);
            log.info(f.toString());
        }
    }

    private class NcmlElementReader
    implements FileFactory {
        private Element netcdfElem;
        private String ncmlLocation;
        private String location;

        NcmlElementReader(String ncmlLocation, String location, Element netcdfElem) {
            this.ncmlLocation = ncmlLocation;
            this.location = location;
            this.netcdfElem = netcdfElem;
        }

        @Override
        public NetcdfFile open(DatasetUrl cacheName, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
            if (debugAggDetail) {
                System.out.println(" NcmlElementReader open nested dataset " + cacheName);
            }
            NetcdfDataset.Builder result = NcMLReaderNew.this.readNcML(this.ncmlLocation, this.location, this.netcdfElem, cancelTask);
            result.setLocation(this.ncmlLocation + "#" + this.location);
            return ((NetcdfFile.Builder)result).build();
        }
    }
}

