/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;
import loci.common.ByteArrayHandle;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.CoreMetadataList;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.MetadataTools;
import loci.formats.SubResolutionFormatReader;
import loci.formats.codec.Codec;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEG2000Codec;
import loci.formats.codec.ZlibCodec;
import loci.formats.in.DynamicMetadataOptions;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MetadataOptions;
import loci.formats.in.ND2Handler;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.units.quantity.ElectricPotential;
import ome.units.quantity.Frequency;
import ome.units.quantity.Length;
import ome.units.quantity.Temperature;
import ome.units.quantity.Time;
import ome.xml.model.primitives.Color;
import org.xml.sax.helpers.DefaultHandler;

public class NativeND2Reader
extends SubResolutionFormatReader {
    public static final long ND2_MAGIC_BYTES_1 = 3670982154L;
    public static final long ND2_MAGIC_BYTES_2 = 1783636000L;
    private static final int BUFFER_SIZE = 32768;
    public static final String USE_CHUNKMAP_KEY = "nativend2.chunkmap";
    public static final boolean USE_CHUNKMAP_DEFAULT = true;
    private long[][] offsets;
    private boolean isJPEG;
    private Codec codec;
    private boolean isLossless;
    private ArrayList<Double> tsT = new ArrayList();
    private int positionCount = 0;
    private int fieldIndex;
    private long xOffset;
    private long yOffset;
    private long zOffset;
    private long pfsOffset;
    private long pfsStateOffset;
    private ArrayList<Length> posX;
    private ArrayList<Length> posY;
    private ArrayList<Length> posZ;
    private ArrayList<Double> exposureTime = new ArrayList();
    private Map<String, Integer> channelColors;
    private boolean split = false;
    private int lastChannel = 0;
    private int[] colors;
    private Boolean useZ = null;
    private int nXFields;
    private ND2Handler backupHandler;
    private double trueSizeX = 0.0;
    private double trueSizeY = 0.0;
    private Double trueSizeZ = null;
    private ArrayList<String> textChannelNames = new ArrayList();
    private ArrayList<Double> textEmissionWavelengths = new ArrayList();
    private boolean textData = false;
    private Double refractiveIndex = null;
    Boolean imageMetadataLVProcessed = false;
    String imageMetadataLVOrder = "";

    public NativeND2Reader() {
        super("Nikon ND2", new String[]{"nd2", "jp2"});
        this.suffixSufficient = false;
        this.domains = new String[]{"Light Microscopy"};
    }

    public boolean useChunkMap() {
        MetadataOptions options = this.getMetadataOptions();
        if (options instanceof DynamicMetadataOptions) {
            return ((DynamicMetadataOptions)options).getBoolean(USE_CHUNKMAP_KEY, true);
        }
        return true;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 8;
        if (!FormatTools.validStream(stream, 8, false)) {
            return false;
        }
        long magic1 = (long)stream.readInt() & 0xFFFFFFFFL;
        long magic2 = (long)stream.readInt() & 0xFFFFFFFFL;
        return magic1 == 3670982154L || magic2 == 1783636000L;
    }

    @Override
    public byte[][] get8BitLookupTable() {
        if (FormatTools.getBytesPerPixel(this.getPixelType()) != 1 || !this.isIndexed() || this.lastChannel < 0 || this.lastChannel >= this.colors.length) {
            return null;
        }
        int color = this.colors[this.lastChannel];
        if (color == 0) {
            return null;
        }
        byte[][] lut = new byte[3][256];
        int redMax = color & 0xFF;
        int greenMax = (color & 0xFF00) >> 8;
        int blueMax = (color & 0xFF0000) >> 16;
        for (int i = 0; i < 256; ++i) {
            double scale = (double)i / 255.0;
            lut[0][i] = (byte)((double)redMax * scale);
            lut[1][i] = (byte)((double)greenMax * scale);
            lut[2][i] = (byte)((double)blueMax * scale);
        }
        return lut;
    }

    @Override
    public short[][] get16BitLookupTable() {
        if (FormatTools.getBytesPerPixel(this.getPixelType()) != 2 || !this.isIndexed() || this.lastChannel < 0 || this.lastChannel >= this.colors.length) {
            return null;
        }
        int color = this.colors[this.lastChannel];
        if (color == 0) {
            return null;
        }
        short[][] lut = new short[3][65536];
        int redMax = color & 0xFF;
        int greenMax = (color & 0xFF00) >> 8;
        int blueMax = (color & 0xFF0000) >> 16;
        for (int i = 0; i < 65536; ++i) {
            double scale = (double)i / 255.0;
            lut[0][i] = (short)((double)redMax * scale);
            lut[1][i] = (short)((double)greenMax * scale);
            lut[2][i] = (short)((double)blueMax * scale);
        }
        return lut;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        this.lastChannel = this.split ? no % this.getSizeC() : 0;
        int planeIndex = this.split ? no / this.getSizeC() : no;
        this.in.seek(this.offsets[this.getSeries()][planeIndex]);
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        int pixel = bpp * this.getRGBChannelCount();
        if (this.split) {
            pixel *= this.getSizeC();
        }
        int totalPlanes = this.split ? this.getImageCount() / this.getSizeC() : this.getImageCount();
        long maxFP = planeIndex == totalPlanes - 1 ? this.in.length() : this.offsets[this.getSeries()][planeIndex + 1];
        CodecOptions options = new CodecOptions();
        options.littleEndian = this.isLittleEndian();
        options.interleaved = this.isInterleaved();
        options.maxBytes = (int)maxFP;
        int scanlinePad = this.getScanlinePad();
        if (this.isJPEG || this.isLossless) {
            if (this.codec == null) {
                this.codec = this.createCodec(this.isJPEG);
            }
            byte[] t = null;
            try {
                t = this.codec.decompress(this.in, options);
            }
            catch (IOException e) {
                LOGGER.debug("Failed to decompress; plane may be corrupt", e);
                return buf;
            }
            if ((this.getSizeX() + scanlinePad) * this.getSizeY() * pixel > t.length) {
                int rowLength = this.getSizeX() * pixel + scanlinePad * bpp;
                int destLength = w * pixel;
                int p = rowLength * y + x * pixel;
                byte[] pix = new byte[destLength * h2];
                for (int row = 0; row < h2 && p + destLength <= t.length; ++row) {
                    System.arraycopy(t, p, pix, row * destLength, destLength);
                    int skip = pixel * (this.getSizeX() - w - x) + scanlinePad * bpp;
                    p += destLength + skip;
                }
                if (this.split) {
                    pix = ImageTools.splitChannels(pix, this.lastChannel, this.getEffectiveSizeC(), bpp, false, true);
                }
                System.arraycopy(pix, 0, buf, 0, pix.length);
            } else {
                this.copyPixels(x, y, w, h2, bpp, scanlinePad, t, buf, this.split);
            }
            t = null;
        } else if (this.split && (this.getSizeC() <= 4 || scanlinePad == 0) && this.nXFields == 1) {
            byte[] pix = new byte[(this.getSizeX() + scanlinePad) * this.getSizeY() * pixel];
            this.in.read(pix);
            this.copyPixels(x, y, w, h2, bpp, scanlinePad, pix, buf, this.split);
            pix = null;
        } else if (this.split) {
            int rowLength = this.getSizeX() * pixel + scanlinePad * bpp;
            int destLength = w * pixel;
            long skip = (long)rowLength * (long)y;
            this.in.seek(this.in.getFilePointer() + skip);
            byte[] pix = new byte[destLength * h2];
            long pre = (long)x * (long)pixel;
            long post = (long)pixel * (long)(this.getSizeX() - w - x) + (long)(scanlinePad * bpp);
            for (int row = 0; row < h2; ++row) {
                this.in.seek(this.in.getFilePointer() + pre);
                this.in.read(pix, row * destLength, destLength);
                this.in.seek(this.in.getFilePointer() + post);
            }
            pix = ImageTools.splitChannels(pix, this.lastChannel, this.getEffectiveSizeC(), bpp, false, true);
            System.arraycopy(pix, 0, buf, 0, pix.length);
        } else {
            this.readPlane(this.in, x, y, w, h2, scanlinePad, buf);
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.offsets = null;
            this.isLossless = false;
            this.isJPEG = false;
            this.codec = null;
            this.tsT.clear();
            this.fieldIndex = 0;
            this.zOffset = 0L;
            this.yOffset = 0L;
            this.xOffset = 0L;
            this.pfsStateOffset = 0L;
            this.pfsOffset = 0L;
            this.posZ = null;
            this.posY = null;
            this.posX = null;
            this.channelColors = null;
            this.split = false;
            this.nXFields = 0;
            this.backupHandler = null;
            this.trueSizeX = 0.0;
            this.trueSizeY = 0.0;
            this.trueSizeZ = null;
            this.textChannelNames.clear();
            this.textEmissionWavelengths.clear();
            this.useZ = null;
            this.textData = false;
            this.refractiveIndex = null;
            this.exposureTime.clear();
            this.positionCount = 0;
        }
    }

    @Override
    protected ArrayList<String> getAvailableOptions() {
        ArrayList<String> optionsList = super.getAvailableOptions();
        optionsList.add(USE_CHUNKMAP_KEY);
        return optionsList;
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        int i;
        int numBands;
        super.initFile(id);
        this.in = new RandomAccessInputStream(id, 32768);
        boolean useChunkMap = this.useChunkMap();
        LOGGER.debug("Attempting to use chunk map = {}", (Object)useChunkMap);
        this.channelColors = new HashMap<String, Integer>();
        if (this.in.read() == -38 && this.in.read() == -50) {
            int i2;
            int i3;
            int i4;
            int rowSize;
            long sizeY;
            int numSeries;
            LOGGER.info("Searching for blocks");
            this.isJPEG = false;
            this.in.seek(0L);
            this.in.order(true);
            ArrayList<String> imageNames = new ArrayList<String>();
            ArrayList<Long> imageOffsets = new ArrayList<Long>();
            ArrayList<long[]> imageLengths = new ArrayList<long[]>();
            ArrayList<Long> customDataOffsets = new ArrayList<Long>();
            ArrayList<long[]> customDataLengths = new ArrayList<long[]>();
            ArrayList<String> textStrings = new ArrayList<String>();
            ArrayList<Boolean> validDimensions = new ArrayList<Boolean>();
            ByteArrayHandle xml = new ByteArrayHandle();
            StringBuilder name = new StringBuilder();
            int extraZDataCount = 0;
            boolean foundMetadata = false;
            boolean foundAttributes = false;
            boolean useLastText = false;
            int blockCount = 0;
            TreeMap<Long, ChunkMapEntry> allChunkPositions = new TreeMap<Long, ChunkMapEntry>();
            if (useChunkMap) {
                String chunkMapSignature = "ND2 CHUNK MAP SIGNATURE 0000001";
                this.in.seek(this.in.length() - 40L);
                if (!this.in.readString(chunkMapSignature.length()).equals(chunkMapSignature)) {
                    useChunkMap = false;
                    LOGGER.info("ND2 Warning: No chunk map found!");
                } else {
                    this.in.skipBytes(1);
                    long chunkMapPosition = this.in.readLong();
                    this.in.seek(chunkMapPosition);
                    int tmpLenOne = this.in.readInt();
                    int tmpLenTwo = this.in.readInt();
                    long chunkMapLength = this.in.readLong();
                    this.in.seek(chunkMapPosition += (long)(16 + tmpLenTwo));
                    long chunkMapEnd = chunkMapPosition + chunkMapLength;
                    int imageDataCount = 0;
                    int maxImageIndex = -1;
                    while (this.in.getFilePointer() + 1L + 16L < chunkMapEnd) {
                        char b = (char)this.in.readByte();
                        while (b != '!') {
                            name.append(b);
                            b = (char)this.in.readByte();
                        }
                        ChunkMapEntry entry = new ChunkMapEntry();
                        entry.name = name.toString();
                        name.delete(0, name.length());
                        if (entry.name.equals(chunkMapSignature)) break;
                        entry.position = this.in.readLong();
                        entry.length = this.in.readLong();
                        if (entry.name.startsWith("ImageDataSeq|")) {
                            ++imageDataCount;
                            int imageIndex = -1;
                            try {
                                imageIndex = Integer.parseInt(entry.name.substring("ImageDataSeq|".length()));
                                if (imageIndex > maxImageIndex) {
                                    maxImageIndex = imageIndex;
                                }
                            }
                            catch (NumberFormatException e) {
                                LOGGER.trace(entry.name, e);
                            }
                        }
                        allChunkPositions.put(entry.position, entry);
                        if (!LOGGER.isDebugEnabled()) continue;
                        LOGGER.debug("ND2 {}", (Object)entry.toString());
                    }
                    if (imageDataCount != maxImageIndex + 1) {
                        LOGGER.warn("Discarding chunk map; image data count = {}, max index = {}", (Object)imageDataCount, (Object)maxImageIndex);
                        useChunkMap = false;
                    }
                }
                this.in.seek(0L);
            }
            byte[] sigBytes = new byte[]{-38, -50, -66, 10};
            byte[] buf = new byte[32768];
            if (useChunkMap) {
                long checkEvery = this.in.length() / 10L;
                long nextCheck = 0L;
                for (ChunkMapEntry entry : allChunkPositions.values()) {
                    if (!entry.name.startsWith("ImageDataSeq") || entry.position <= nextCheck) continue;
                    this.in.seek(entry.position);
                    this.in.read(buf, 0, sigBytes.length);
                    if (buf[0] != sigBytes[0] || buf[1] != sigBytes[1] || buf[2] != sigBytes[2] || buf[3] != sigBytes[3]) {
                        LOGGER.warn("Broken ND2 File detected! Disabling chunk map processing.");
                        useChunkMap = false;
                        break;
                    }
                    nextCheck = entry.position + checkEvery;
                }
            }
            int chunkmapSkips = 0;
            Boolean currentCountSetted = false;
            int XYCount = 1;
            int timeCount = 1;
            int zCount = 1;
            this.in.seek(0L);
            while (this.in.getFilePointer() < this.in.length() - 1L && this.in.getFilePointer() >= 0L) {
                long endFP;
                int foundIndex = -1;
                this.in.read(buf, 0, sigBytes.length);
                while (foundIndex == -1 && this.in.getFilePointer() < this.in.length()) {
                    int n = this.in.read(buf, sigBytes.length, buf.length - sigBytes.length);
                    for (int i5 = 0; i5 < buf.length - sigBytes.length; ++i5) {
                        for (int j = 0; j < sigBytes.length && buf[i5 + j] == sigBytes[j]; ++j) {
                            if (j != sigBytes.length - 1) continue;
                            foundIndex = i5;
                        }
                        if (foundIndex != -1) break;
                    }
                    if (foundIndex == -1) {
                        buf[0] = buf[buf.length - 4];
                        buf[1] = buf[buf.length - 3];
                        buf[2] = buf[buf.length - 2];
                        buf[3] = buf[buf.length - 1];
                        continue;
                    }
                    if (this.in.getFilePointer() - (long)n + (long)foundIndex >= this.in.length()) continue;
                    this.in.seek(this.in.getFilePointer() - (long)n + (long)foundIndex);
                }
                if (this.in.getFilePointer() > this.in.length() - 24L || foundIndex == -1) break;
                Long helper = this.in.getFilePointer();
                int nameLength = this.in.readInt();
                long dataLength = this.in.readLong();
                String nameAttri = this.in.readString(nameLength).trim();
                Long stop = helper + (dataLength + (long)nameLength);
                boolean seq = false;
                if (nameAttri.contains("MetadataLV") || nameAttri.contains("CalibrationLV") || nameAttri.contains("MetadataSeqLV") && !seq) {
                    if (nameAttri.equals("ImageMetadataLV!")) {
                        this.positionCount = 0;
                    }
                    this.iterateIn(this.in, stop);
                }
                if (nameAttri.contains("MetadataSeqLV")) {
                    seq = true;
                }
                this.in.seek(helper + 12L);
                int len = (int)((long)nameLength + dataLength);
                long fp = this.in.getFilePointer();
                String blockType = this.in.readString(12);
                int percent = (int)(100L * fp / this.in.length());
                LOGGER.info("Parsing block '{}' {}%", (Object)blockType, (Object)percent);
                ++blockCount;
                int skip = len - 12 - nameLength * 2;
                if (skip <= 0) {
                    skip += nameLength * 2;
                }
                if (blockType.endsWith("Calibra")) {
                    long veryStart = this.in.getFilePointer();
                    this.in.skipBytes(12);
                    endFP = this.in.getFilePointer() + (long)len - 24L;
                    while (this.in.read() == 0) {
                    }
                    while (this.in.getFilePointer() < endFP) {
                        int nameLen = this.in.read();
                        if (nameLen == 0) {
                            this.in.seek(this.in.getFilePointer() - 3L);
                            nameLen = this.in.read();
                        }
                        if (nameLen < 0) break;
                        String attributeName = DataTools.stripString(this.in.readString(nameLen * 2));
                        double valueOrLength = this.in.readDouble();
                        if (!attributeName.equals("dCalibration")) continue;
                        if (!(valueOrLength > 0.0)) break;
                        this.addGlobalMeta(attributeName, valueOrLength);
                        if (this.trueSizeX == 0.0) {
                            this.trueSizeX = valueOrLength;
                            break;
                        }
                        if (this.trueSizeY != 0.0) break;
                        this.trueSizeY = valueOrLength;
                        break;
                    }
                    this.in.seek(veryStart);
                }
                if (blockType.startsWith("ImageDataSeq")) {
                    if (foundMetadata && foundAttributes) {
                        imageOffsets.clear();
                        imageNames.clear();
                        imageLengths.clear();
                        customDataOffsets.clear();
                        customDataLengths.clear();
                        foundMetadata = false;
                        foundAttributes = false;
                        extraZDataCount = 0;
                        useLastText = true;
                    }
                    if (useChunkMap && chunkmapSkips == 0) {
                        ChunkMapEntry lastImage = null;
                        long lookupPosition = this.in.getFilePointer() - 28L;
                        Long lookupResult = allChunkPositions.floorKey(lookupPosition);
                        if (lookupResult == null || lookupResult != lookupPosition) {
                            useChunkMap = false;
                            this.in.seek(lookupPosition);
                            continue;
                        }
                        for (ChunkMapEntry entry : allChunkPositions.values()) {
                            if (entry.position + 28L < this.in.getFilePointer() || !entry.name.startsWith("ImageDataSeq")) continue;
                            if (lastImage != null && (chunkmapSkips = (int)((entry.position - lastImage.position) / entry.length - 1L)) > 0) break;
                            lastImage = entry;
                            imageOffsets.add(new Long(entry.position + 16L));
                            int realLength = Math.max(entry.name.length() + 1, nameLength);
                            imageLengths.add(new long[]{realLength, entry.length - (long)nameLength - 16L, this.getSizeX() * this.getSizeY()});
                            imageNames.add(entry.name.substring(12));
                            ++blockCount;
                            percent = (int)(100L * entry.position / this.in.length());
                            LOGGER.info("Parsing block '{}' {}%", (Object)"ImageDataSeq", (Object)percent);
                        }
                        --blockCount;
                        if (lastImage.position + lastImage.length >= this.in.length()) {
                            this.in.seek(lastImage.position + 16L);
                            continue;
                        }
                        this.in.seek(lastImage.position + lastImage.length);
                        continue;
                    }
                    if (chunkmapSkips > 0) {
                        --chunkmapSkips;
                    }
                    LOGGER.debug("Adding non-chunkmap offset {}, nameLength = {}, dataLength = {}", fp, nameLength, dataLength -= 31L);
                    imageOffsets.add(fp);
                    imageLengths.add(new long[]{nameLength, dataLength, this.getSizeX() * this.getSizeY()});
                    char b = (char)this.in.readByte();
                    while (b != '!') {
                        name.append(b);
                        b = (char)this.in.readByte();
                    }
                    imageNames.add(name.toString());
                    name.setLength(0);
                } else if (blockType.startsWith("ImageText")) {
                    foundMetadata = true;
                    this.in.skipBytes(6);
                    while (this.in.read() == 0) {
                    }
                    long startFP = this.in.getFilePointer();
                    this.in.seek(startFP - 1L);
                    int typeByte = this.in.read();
                    if (typeByte > 11) {
                        this.in.seek(startFP - 1L);
                        String textString = DataTools.stripString(this.in.readString((int)dataLength));
                        textStrings.add(textString);
                        validDimensions.add(blockCount > 2);
                        if (!textString.startsWith("<")) {
                            skip = 0;
                        }
                    } else {
                        int charCount = this.in.read();
                        textStrings.add(DataTools.stripString(this.in.readString(charCount * 2)));
                        validDimensions.add(blockCount > 2);
                        int numTextInfos = this.in.readInt();
                        long remainingBytes = this.in.readLong();
                        ArrayList<String> text = this.iterateIn(this.in, startFP + dataLength - 1L, true);
                        StringBuffer b = new StringBuffer();
                        for (int t = 0; t < text.size(); ++t) {
                            b.append(text.get(t));
                            b.append("\n");
                        }
                        textStrings.add(b.toString());
                        validDimensions.add(blockCount > 2);
                        this.in.seek(startFP + dataLength - 1L);
                        skip = 0;
                    }
                } else if (blockType.startsWith("Image") || blockType.startsWith("CustomDataVa")) {
                    if (blockType.equals("ImageAttribu")) {
                        foundAttributes = true;
                        this.in.skipBytes(6);
                        long endFP2 = this.in.getFilePointer() + (long)len - 18L;
                        while (this.in.read() == 0) {
                        }
                        boolean canBeLossless = true;
                        while (this.in.getFilePointer() < endFP2) {
                            int nameLen = this.in.read();
                            if (nameLen == 0) {
                                this.in.seek(this.in.getFilePointer() - 3L);
                                nameLen = this.in.read();
                            }
                            if (nameLen < 0) break;
                            long start = this.in.getFilePointer();
                            String attributeName = DataTools.stripString(this.in.readString(nameLen * 2));
                            if (attributeName.startsWith("xml ") || attributeName.startsWith("ml version") || attributeName.startsWith("l version") || attributeName.startsWith("version")) {
                                if (attributeName.startsWith("xml ")) {
                                    this.in.seek(start - 2L);
                                } else if (attributeName.startsWith("ml version")) {
                                    this.in.seek(start - 3L);
                                } else if (attributeName.startsWith("l version")) {
                                    this.in.seek(start - 4L);
                                } else {
                                    this.in.seek(start - 6L);
                                }
                                attributeName = this.in.readCString();
                                String xmlString = XMLTools.sanitizeXML(attributeName.trim());
                                xmlString = xmlString.substring(0, xmlString.lastIndexOf(">") + 1);
                                if (xmlString.startsWith("<?xml")) {
                                    xmlString = xmlString.substring(xmlString.indexOf(62) + 1);
                                }
                                if (!xmlString.endsWith("</variant>")) {
                                    xmlString = xmlString + "</variant>";
                                }
                                if (this.getDimensionOrder() == null) {
                                    ((CoreMetadata)this.core.get((int)0, (int)0)).dimensionOrder = "";
                                }
                                try {
                                    ND2Handler handler = new ND2Handler(this.core, imageOffsets.size());
                                    XMLTools.parseXML(xmlString, (DefaultHandler)handler);
                                    xmlString = null;
                                    this.core = handler.getCoreMetadataList();
                                    if (this.backupHandler == null) {
                                        this.backupHandler = handler;
                                    }
                                }
                                catch (IOException e) {
                                    LOGGER.debug("Could not parse XML", e);
                                }
                                this.in.seek(this.in.getFilePointer() - 8L);
                                break;
                            }
                            int valueOrLength = this.in.readInt();
                            this.addGlobalMeta(attributeName, valueOrLength);
                            if (attributeName.equals("uiWidth")) {
                                ((CoreMetadata)this.core.get((int)0, (int)0)).sizeX = valueOrLength;
                            } else if (attributeName.equals("uiHeight")) {
                                ((CoreMetadata)this.core.get((int)0, (int)0)).sizeY = valueOrLength;
                            } else if (attributeName.equals("uiComp")) {
                                ((CoreMetadata)this.core.get((int)0, (int)0)).sizeC = valueOrLength;
                            } else if (attributeName.equals("uiBpcInMemory")) {
                                ((CoreMetadata)this.core.get((int)0, (int)0)).pixelType = FormatTools.pixelTypeFromBytes(valueOrLength / 8, false, true);
                            } else if (attributeName.equals("uiBpcSignificant")) {
                                ((CoreMetadata)this.core.get((int)0, (int)0)).bitsPerPixel = valueOrLength;
                            } else if (attributeName.equals("dCompressionParam")) {
                                this.isLossless = valueOrLength >= 0;
                            } else if (attributeName.equals("eCompression")) {
                                canBeLossless = valueOrLength <= 0;
                            } else if (attributeName.equals("SLxImageAttributes")) {
                                int toSkip = valueOrLength - 5;
                                if (toSkip % 2 == 1) {
                                    ++toSkip;
                                }
                                this.in.skipBytes(toSkip);
                            } else if (attributeName.endsWith("Desc")) {
                                this.in.seek(this.in.getFilePointer() - 2L);
                            } else if (attributeName.equals("SLxExperiment")) {
                                this.in.skipBytes(8);
                            } else if (attributeName.equals("wsCameraName")) {
                                this.in.seek(this.in.getFilePointer() - 4L);
                                byte[] b = new byte[2];
                                this.in.read(b);
                                StringBuilder value = new StringBuilder();
                                while (b[0] != 0) {
                                    value.append(b[0]);
                                    this.in.read(b);
                                }
                                this.addGlobalMeta(attributeName, value.toString());
                            } else if (attributeName.equals("uLoopPars")) {
                                int v2 = this.in.readInt();
                                int v3 = this.in.readInt();
                                this.addGlobalMeta(attributeName, valueOrLength + ", " + v2 + ", " + v3);
                            } else if (attributeName.equals("pPeriod")) {
                                this.in.skipBytes(22);
                            } else if (attributeName.equals("dPeriod") || attributeName.equals("dDuration")) {
                                this.in.skipBytes(4);
                            } else if (attributeName.equals("bDurationPref")) {
                                this.in.seek(this.in.getFilePointer() - 3L);
                            }
                            this.in.skipBytes(1);
                        }
                        if (this.in.getFilePointer() > endFP2) {
                            this.in.seek(endFP2);
                        }
                        this.isLossless = this.isLossless && canBeLossless;
                    } else {
                        if (blockType.startsWith("ImageMetadat") && !this.imageMetadataLVProcessed.booleanValue()) {
                            foundMetadata = true;
                            long startFilePointer = this.in.getFilePointer();
                            this.in.skipBytes(6);
                            endFP = this.in.getFilePointer() + (long)len - 18L;
                            while (this.in.read() == 0) {
                            }
                            int eType = 0;
                            Boolean nextExperiment = true;
                            long currentFilePointer = this.in.getFilePointer();
                            while (true) {
                                this.in.seek(currentFilePointer);
                                int nameLen = this.in.read();
                                if (nameLen == 0 || nameLen < 0) {
                                    ++currentFilePointer;
                                    continue;
                                }
                                String attributeName = DataTools.stripString(this.in.readString(nameLen * 2));
                                if (attributeName.length() != nameLen - 1) {
                                    ++currentFilePointer;
                                    continue;
                                }
                                if (attributeName.equals("SLxExperiment")) {
                                    currentFilePointer += (long)(nameLen * 2);
                                    this.imageMetadataLVProcessed = true;
                                    this.imageMetadataLVOrder = "";
                                }
                                if (attributeName.equals("eType")) {
                                    currentFilePointer += (long)(nameLen * 2);
                                    if (nextExperiment.booleanValue()) {
                                        eType = this.in.readInt();
                                    }
                                    nextExperiment = false;
                                } else if (attributeName.equals("uiCount")) {
                                    currentFilePointer += (long)(nameLen * 2);
                                    if (!currentCountSetted.booleanValue()) {
                                        if (eType == 2) {
                                            this.imageMetadataLVOrder = "M" + this.imageMetadataLVOrder;
                                            XYCount = this.in.readInt();
                                        } else if (eType == 1) {
                                            this.imageMetadataLVOrder = "T" + this.imageMetadataLVOrder;
                                            timeCount = this.in.readInt();
                                        }
                                        if (eType == 4) {
                                            this.imageMetadataLVOrder = "Z" + this.imageMetadataLVOrder;
                                            zCount = this.in.readInt();
                                        }
                                        currentCountSetted = true;
                                    }
                                } else if (attributeName.equals("bKeepObject")) {
                                    currentFilePointer += (long)(nameLen * 2);
                                } else if (attributeName.equals("uiRepeatCount")) {
                                    currentFilePointer += (long)(nameLen * 2);
                                } else if (attributeName.equals("vectStimulationConfigurationsSize")) {
                                    currentFilePointer += (long)(nameLen * 2);
                                } else if (attributeName.equals("uiNextLevelCount")) {
                                    currentFilePointer += (long)(nameLen * 2);
                                    int uiNextLevelCount = this.in.readInt();
                                    if (uiNextLevelCount == 0) break;
                                    currentCountSetted = false;
                                    nextExperiment = true;
                                }
                                if (this.in.getFilePointer() > endFP) {
                                    this.in.seek(startFilePointer);
                                    break;
                                }
                                ++currentFilePointer;
                            }
                            if (this.in.getFilePointer() > startFilePointer) {
                                this.in.seek(startFilePointer);
                            }
                        }
                        int length = len - 12;
                        byte[] b = new byte[length];
                        this.in.read(b);
                        int off = 0;
                        for (int j = 0; j < length; ++j) {
                            char c = (char)b[j];
                            if (off == 0 && c == '!' || c == '\u0000') {
                                off = j + 1;
                            }
                            if (!Character.isISOControl(c) && Character.isDefined(c)) continue;
                            b[j] = 32;
                        }
                        if (length - off >= 5 && b[off] == 60 && b[off + 1] == 63 && b[off + 2] == 120 && b[off + 3] == 109 && b[off + 4] == 108) {
                            boolean endBracketFound = false;
                            while (!endBracketFound) {
                                if (b[off++] != 62) continue;
                                endBracketFound = true;
                            }
                            xml.write(b, off, b.length - off);
                        }
                    }
                    skip = 0;
                } else if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
                    int nDoubles = len / 8;
                    int nInts = len / 4;
                    long doubleOffset = fp + (long)(8 * (nDoubles - imageOffsets.size()));
                    long intOffset = fp + (long)(4 * (nInts - imageOffsets.size()));
                    if (nameAttri.startsWith("CustomData|AcqTimesCache")) {
                        customDataOffsets.add(fp);
                        customDataLengths.add(new long[]{nameLength, dataLength});
                    } else if (blockType.startsWith("CustomData|Z")) {
                        if (this.zOffset == 0L) {
                            this.zOffset = doubleOffset;
                        }
                        ++extraZDataCount;
                    } else if (blockType.startsWith("CustomData|X")) {
                        this.xOffset = doubleOffset;
                    } else if (blockType.startsWith("CustomData|Y")) {
                        this.yOffset = doubleOffset;
                    } else if (blockType.startsWith("CustomData|P")) {
                        if (this.pfsOffset == 0L) {
                            this.pfsOffset = intOffset;
                        } else if (this.pfsStateOffset == 0L) {
                            this.pfsStateOffset = intOffset;
                        }
                    }
                }
                if (skip <= 0 || (long)skip + this.in.getFilePointer() > this.in.length()) continue;
                this.in.skipBytes(skip);
            }
            if (currentCountSetted.booleanValue() && this.imageMetadataLVOrder.length() > 0 && (imageOffsets.size() == 0 || timeCount * zCount * XYCount == imageOffsets.size())) {
                this.setDimensions(timeCount, zCount, XYCount);
            } else {
                this.imageMetadataLVProcessed = false;
            }
            int nChannelNames = this.textChannelNames.size();
            for (int i6 = 0; i6 < textStrings.size(); ++i6) {
                this.parseText((String)textStrings.get(i6), imageOffsets.size(), (Boolean)validDimensions.get(i6));
            }
            if (this.textChannelNames.size() > nChannelNames) {
                int diff = this.textChannelNames.size() - nChannelNames;
                while (this.textChannelNames.size() > diff) {
                    this.textChannelNames.remove(0);
                }
            }
            String xmlString = new String(xml.getBytes(), 0, (int)xml.length(), "UTF-8");
            xml = null;
            xmlString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><ND2>" + xmlString + "</ND2>";
            xmlString = XMLTools.sanitizeXML(xmlString);
            ((CoreMetadata)this.core.get((int)0, (int)0)).dimensionOrder = "";
            ND2Handler handler = new ND2Handler(this.core, this.getSizeX() == 0, imageOffsets.size());
            XMLTools.parseXML(xmlString, (DefaultHandler)handler);
            xmlString = null;
            if (handler.getChannelColors().size() > 0) {
                this.channelColors = handler.getChannelColors();
            }
            if (!this.isLossless) {
                this.isLossless = handler.isLossless();
            }
            this.fieldIndex = handler.getFieldIndex();
            this.core = handler.getCoreMetadataList();
            Hashtable<String, Object> globalMetadata = handler.getMetadata();
            this.nXFields = handler.getXFields();
            if (this.nXFields > 6) {
                this.nXFields = 0;
            }
            for (String key : globalMetadata.keySet()) {
                this.addGlobalMeta(key, globalMetadata.get(key));
                if (key.equals("ChannelCount")) {
                    for (int i7 = 0; i7 < this.getSeriesCount(); ++i7) {
                        CoreMetadata ms = (CoreMetadata)this.core.get(i7, 0);
                        if (ms.sizeC != 0) continue;
                        ms.sizeC = Integer.parseInt(globalMetadata.get(key).toString());
                        if (ms.sizeC <= 1) continue;
                        ms.rgb = true;
                    }
                    continue;
                }
                if (!key.equals("uiBpcInMemory")) continue;
                int bpc = Integer.parseInt(globalMetadata.get(key).toString());
                ((CoreMetadata)this.core.get((int)0, (int)0)).pixelType = FormatTools.pixelTypeFromBytes(bpc / 8, false, false);
            }
            int planeCount = this.core.size() * this.getSizeZ() * this.getSizeT();
            if (!this.textData && planeCount < imageOffsets.size() && planeCount > 0 && imageOffsets.size() % (planeCount / this.core.size()) == 0) {
                int seriesCount = imageOffsets.size() / (planeCount / this.core.size());
                this.core = new CoreMetadataList();
                for (int i8 = 0; i8 < seriesCount; ++i8) {
                    this.core.add(handler.getCoreMetadataList().get(0, 0));
                }
            }
            if ((numSeries = this.core.size()) == 0) {
                numSeries = 1;
            } else if (numSeries == 1 && this.positionCount > 1) {
                for (int i9 = 1; i9 < this.positionCount; ++i9) {
                    this.core.add(this.core.get(0, 0));
                }
                numSeries = this.core.size();
            }
            if (this.getSizeZ() == 0) {
                int i10;
                for (i10 = 0; i10 < this.getSeriesCount(); ++i10) {
                    ((CoreMetadata)this.core.get((int)i10, (int)0)).sizeZ = 1;
                }
                if (this.getSizeT() == 0) {
                    for (i10 = 0; i10 < this.getSeriesCount(); ++i10) {
                        ((CoreMetadata)this.core.get((int)i10, (int)0)).sizeT = imageOffsets.size() / this.getSeriesCount();
                    }
                }
            }
            if (this.getSizeT() == 0) {
                for (int i11 = 0; i11 < this.getSeriesCount(); ++i11) {
                    ((CoreMetadata)this.core.get((int)i11, (int)0)).sizeT = 1;
                }
            }
            if (this.getSizeC() == 0) {
                for (int i12 = 0; i12 < this.getSeriesCount(); ++i12) {
                    ((CoreMetadata)this.core.get((int)i12, (int)0)).sizeC = 1;
                }
            }
            if (this.getSizeZ() * this.getSizeT() == imageOffsets.size() && this.core.size() > 1) {
                CoreMetadata ms0 = (CoreMetadata)this.core.get(0, 0);
                this.core = new CoreMetadataList();
                this.core.add(ms0);
            }
            if (this.positionCount != this.getSeriesCount() && (this.getSizeZ() == imageOffsets.size() || extraZDataCount > 1 && this.getSizeZ() == 1 && extraZDataCount == this.getSizeC() || handler.getXPositions().size() == 0 && this.xOffset == 0L && this.getSizeZ() != this.getSeriesCount()) && this.getSeriesCount() > 1) {
                CoreMetadata ms0 = (CoreMetadata)this.core.get(0, 0);
                if (this.getSeriesCount() > ms0.sizeZ) {
                    ms0.sizeZ = this.getSeriesCount();
                }
                this.core = new CoreMetadataList();
                this.core.add(ms0);
            }
            long firstOffset = (Long)imageOffsets.get(0);
            long secondOffset = imageOffsets.size() > 1 ? ((Long)imageOffsets.get(1)).longValue() : this.in.length();
            long availableBytes = secondOffset - firstOffset;
            this.isLossless = true;
            long fp = this.in.getFilePointer();
            long[] firstLengths = (long[])imageLengths.get(0);
            this.in.seek(firstOffset + firstLengths[0] + 8L);
            if (this.codec == null) {
                this.codec = this.createCodec(false);
            }
            try {
                CodecOptions options = new CodecOptions();
                options.littleEndian = this.isLittleEndian();
                options.interleaved = true;
                options.maxBytes = (int)secondOffset;
                byte[] t = this.codec.decompress(this.in, options);
                if (t.length == 2 * this.getSizeX() * this.getSizeY() && this.getPixelType() == 0) {
                    ((CoreMetadata)this.core.get((int)0, (int)0)).pixelType = 3;
                }
                availableBytes = t.length;
            }
            catch (IOException e) {
                this.isLossless = false;
            }
            boolean allEqual = true;
            long offsetDiff = (Long)imageOffsets.get(0) - ((long[])imageLengths.get(0))[1];
            for (int i13 = 1; i13 < imageOffsets.size(); ++i13) {
                long nextOffsetDiff = (Long)imageOffsets.get(i13) - ((long[])imageLengths.get(i13))[1];
                if (((long[])imageLengths.get(i13))[1] == ((long[])imageLengths.get(0))[1] || offsetDiff == nextOffsetDiff) continue;
                allEqual = false;
                break;
            }
            if (!allEqual && !this.isLossless && imageOffsets.size() > 1) {
                int plane = (this.getSizeX() + this.getScanlinePad()) * this.getSizeY();
                boolean fixByteCounts = false;
                if (plane > 0) {
                    for (int i14 = 0; i14 < imageOffsets.size(); ++i14) {
                        long check = ((long[])imageLengths.get(i14))[2];
                        long length = ((long[])imageLengths.get(i14))[1] - 8L;
                        if ((length % (long)plane == 0L || length % (long)(this.getSizeX() * this.getSizeY()) == 0L) && (check <= 0L || (long)plane == check) || (Long)imageOffsets.get(i14) - length == offsetDiff + 8L) continue;
                        if (i14 == 0) {
                            fixByteCounts = true;
                        }
                        imageOffsets.remove(i14);
                        imageLengths.remove(i14);
                        --i14;
                    }
                }
                if (fixByteCounts) {
                    firstOffset = (Long)imageOffsets.get(0);
                    secondOffset = imageOffsets.size() > 1 ? ((Long)imageOffsets.get(1)).longValue() : this.in.length();
                    availableBytes = secondOffset - firstOffset;
                    if (this.isLossless) {
                        firstLengths = (long[])imageLengths.get(0);
                        this.in.seek(firstOffset + firstLengths[0] + 8L);
                        CodecOptions options = new CodecOptions();
                        options.littleEndian = this.isLittleEndian();
                        options.interleaved = true;
                        options.maxBytes = (int)secondOffset;
                        byte[] t = this.codec.decompress(this.in, options);
                        availableBytes = t.length;
                    }
                }
            }
            this.in.seek(fp);
            long planeSize = this.getSizeX() * this.getSizeY() * this.getSizeC() * FormatTools.getBytesPerPixel(this.getPixelType());
            if (availableBytes < planeSize) {
                LOGGER.debug("Correcting SizeC: was {}", (Object)this.getSizeC());
                LOGGER.debug("plane size = {}", (Object)planeSize);
                LOGGER.debug("available bytes = {}", (Object)availableBytes);
                ((CoreMetadata)this.core.get((int)0, (int)0)).sizeC = (int)(availableBytes / (planeSize / (long)this.getSizeC()));
                if (this.getSizeC() == 0) {
                    ((CoreMetadata)this.core.get((int)0, (int)0)).sizeC = 1;
                }
                planeSize = this.getSizeX() * this.getSizeY() * this.getSizeC() * FormatTools.getBytesPerPixel(this.getPixelType());
            }
            if (planeSize > 0L && availableBytes % planeSize != 0L && (availableBytes - 4096L) % planeSize == 0L) {
                availableBytes -= 4096L;
            }
            if (planeSize > 0L && imageOffsets.size() > 1 && availableBytes > DataTools.safeMultiply64(planeSize, 3L)) {
                if (availableBytes < DataTools.safeMultiply64(planeSize, 6L)) {
                    ((CoreMetadata)this.core.get((int)0, (int)0)).sizeC = 3;
                    ((CoreMetadata)this.core.get((int)0, (int)0)).rgb = true;
                    if (this.getPixelType() == 0) {
                        ((CoreMetadata)this.core.get((int)0, (int)0)).pixelType = availableBytes > planeSize * 5L ? 3 : 1;
                    }
                }
            } else if ((planeSize > 0L && availableBytes >= DataTools.safeMultiply64(planeSize, 2L) || this.getSizeC() > 3) && this.getPixelType() == 0) {
                ((CoreMetadata)this.core.get((int)0, (int)0)).pixelType = 3;
                if (this.getSizeC() > 3 && availableBytes % (planeSize *= 2L) != 0L && planeSize > availableBytes) {
                    ((CoreMetadata)this.core.get((int)0, (int)0)).sizeC = 3;
                    ((CoreMetadata)this.core.get((int)0, (int)0)).rgb = true;
                }
            } else if (this.getSizeC() == 2 && this.getPixelType() == 0 && availableBytes >= planeSize * 2L) {
                ((CoreMetadata)this.core.get((int)0, (int)0)).pixelType = 3;
            } else if (this.getPixelType() == 0) {
                ((CoreMetadata)this.core.get((int)0, (int)0)).pixelType = 1;
            }
            if (this.getSizeX() == 0) {
                ((CoreMetadata)this.core.get((int)0, (int)0)).sizeX = (int)Math.sqrt(availableBytes / (long)(this.getSizeC() * FormatTools.getBytesPerPixel(this.getPixelType())));
                ((CoreMetadata)this.core.get((int)0, (int)0)).sizeY = this.getSizeX();
            }
            if ((sizeY = availableBytes / (long)(rowSize = this.getSizeX() * FormatTools.getBytesPerPixel(this.getPixelType()) * this.getSizeC())) < (long)this.getSizeY()) {
                ((CoreMetadata)this.core.get((int)0, (int)0)).sizeY = (int)sizeY;
            }
            if (this.getSizeT() == imageOffsets.size() && this.getSeriesCount() > 1) {
                CoreMetadata firstCore = (CoreMetadata)this.core.get(0, 0);
                this.core = new CoreMetadataList();
                this.core.add(firstCore);
            }
            for (i4 = 0; i4 < this.getSeriesCount(); ++i4) {
                CoreMetadata ms = (CoreMetadata)this.core.get(i4, 0);
                ms.imageCount = this.getSizeZ() * this.getSizeT() * this.getSizeC();
                if (imageOffsets.size() / this.getSeriesCount() < ms.imageCount) {
                    ms.imageCount /= this.getSizeC();
                }
                if (ms.imageCount <= imageOffsets.size() / this.getSeriesCount()) continue;
                int diff = imageOffsets.size() - ms.imageCount;
                if (diff >= 0 && diff < ms.sizeZ && diff < ms.sizeT) {
                    CoreMetadata ms0 = (CoreMetadata)this.core.get(0, 0);
                    this.core = new CoreMetadataList();
                    this.core.add(ms0);
                    numSeries = 1;
                    break;
                }
                if (imageOffsets.size() % ms.sizeT == 0) {
                    ms.imageCount = imageOffsets.size() / this.getSeriesCount();
                    ms.sizeZ = ms.imageCount / ms.sizeT;
                    ms.dimensionOrder = "CZT";
                    continue;
                }
                ms.imageCount = imageOffsets.size() / this.getSeriesCount();
                ms.sizeZ = 1;
                ms.sizeT = ms.imageCount;
            }
            if (numSeries * this.getImageCount() == 1 && imageOffsets.size() > 1) {
                for (i4 = 0; i4 < this.getSeriesCount(); ++i4) {
                    ((CoreMetadata)this.core.get((int)i4, (int)0)).imageCount = imageOffsets.size() / this.getSeriesCount();
                    ((CoreMetadata)this.core.get((int)i4, (int)0)).sizeZ = this.getImageCount();
                    ((CoreMetadata)this.core.get((int)i4, (int)0)).sizeT = 1;
                }
            }
            if (this.getSizeZ() * this.getSizeT() * (this.split ? 1 : this.getSizeC()) < imageOffsets.size() / this.getSeriesCount()) {
                int diff;
                this.split = this.getSizeC() > 1;
                int count = imageOffsets.size() / this.getSeriesCount();
                if (!this.split && count >= this.getSizeC()) {
                    count /= this.getSizeC();
                }
                if ((diff = count - this.getSizeZ() * this.getSizeT()) == this.getSizeZ()) {
                    ++((CoreMetadata)this.core.get((int)0, (int)0)).sizeT;
                } else if (this.getSizeT() > this.getSizeZ()) {
                    ((CoreMetadata)this.core.get((int)0, (int)0)).sizeZ = 1;
                    ((CoreMetadata)this.core.get((int)0, (int)0)).sizeT = count;
                } else {
                    ((CoreMetadata)this.core.get((int)0, (int)0)).sizeT = 1;
                    ((CoreMetadata)this.core.get((int)0, (int)0)).sizeZ = count;
                }
                if (this.useZ != null && !this.useZ.booleanValue()) {
                    CoreMetadata original = (CoreMetadata)this.core.get(0, 0);
                    int nSeries = imageOffsets.size() / (this.getSizeZ() * this.getSizeT());
                    for (i3 = 1; i3 < nSeries; ++i3) {
                        this.core.add(original);
                    }
                    numSeries = this.core.size();
                }
                if (this.getSizeZ() * this.getSizeT() * (this.split ? 1 : this.getSizeC()) < imageOffsets.size() / this.getSeriesCount() && this.getSizeC() > 4) {
                    ((CoreMetadata)this.core.get((int)0, (int)0)).sizeZ = 1;
                    ((CoreMetadata)this.core.get((int)0, (int)0)).sizeT = imageOffsets.size() / this.getSeriesCount();
                }
                ((CoreMetadata)this.core.get((int)0, (int)0)).imageCount = this.getSizeZ() * this.getSizeT() * this.getSizeC();
            }
            if (this.getDimensionOrder().equals("T")) {
                this.fieldIndex = 0;
            } else if (this.getDimensionOrder().equals("ZT") && this.fieldIndex == 2) {
                --this.fieldIndex;
            }
            if (this.getSizeC() > 1 && this.getDimensionOrder().indexOf(67) == -1) {
                ((CoreMetadata)this.core.get((int)0, (int)0)).dimensionOrder = "C" + this.getDimensionOrder();
                ++this.fieldIndex;
            }
            ((CoreMetadata)this.core.get((int)0, (int)0)).dimensionOrder = "XY" + this.getDimensionOrder();
            if (this.getDimensionOrder().indexOf(90) == -1) {
                ((CoreMetadata)this.core.get((int)0, (int)0)).dimensionOrder = ((CoreMetadata)this.core.get((int)0, (int)0)).dimensionOrder + 'Z';
            }
            if (this.getDimensionOrder().indexOf(67) == -1) {
                ((CoreMetadata)this.core.get((int)0, (int)0)).dimensionOrder = ((CoreMetadata)this.core.get((int)0, (int)0)).dimensionOrder + 'C';
            }
            if (this.getDimensionOrder().indexOf(84) == -1) {
                ((CoreMetadata)this.core.get((int)0, (int)0)).dimensionOrder = ((CoreMetadata)this.core.get((int)0, (int)0)).dimensionOrder + 'T';
            }
            if (this.getSizeZ() == 0) {
                ((CoreMetadata)this.core.get((int)0, (int)0)).sizeZ = 1;
            }
            if (this.getSizeT() == 0) {
                ((CoreMetadata)this.core.get((int)0, (int)0)).sizeT = 1;
            }
            if (this.getSizeC() == 0) {
                ((CoreMetadata)this.core.get((int)0, (int)0)).sizeC = 1;
            }
            ((CoreMetadata)this.core.get((int)0, (int)0)).imageCount = this.getSizeZ() * this.getSizeT();
            if (!this.isRGB()) {
                ((CoreMetadata)this.core.get((int)0, (int)0)).imageCount *= this.getSizeC();
            }
            this.posX = handler.getXPositions();
            this.posY = handler.getYPositions();
            this.posZ = handler.getZPositions();
            int uniqueX = 0;
            int uniqueY = 0;
            int uniqueZ = 0;
            if (this.posX.size() == 0 && this.xOffset != 0L) {
                this.in.seek(this.xOffset);
                for (int i15 = 0; i15 < imageOffsets.size(); ++i15) {
                    Double number = this.in.readDouble();
                    Length x = new Length(number, UNITS.REFERENCEFRAME);
                    if (!this.posX.contains(x)) {
                        ++uniqueX;
                    }
                    this.posX.add(x);
                }
            }
            if (this.posY.size() == 0 && this.yOffset != 0L) {
                this.in.seek(this.yOffset);
                for (int i16 = 0; i16 < imageOffsets.size(); ++i16) {
                    Double number = this.in.readDouble();
                    Length y = new Length(number, UNITS.REFERENCEFRAME);
                    if (!this.posY.contains(y)) {
                        ++uniqueY;
                    }
                    this.posY.add(y);
                }
            }
            if (this.posZ.size() == 0 && this.zOffset != 0L) {
                this.in.seek(this.zOffset);
                for (int i17 = 0; i17 < imageOffsets.size(); ++i17) {
                    Double number = this.in.readDouble();
                    Length z = new Length(number, UNITS.REFERENCEFRAME);
                    if (!this.posZ.contains(z)) {
                        boolean unique = true;
                        for (int q = 0; q < this.posZ.size(); ++q) {
                            double z2;
                            double z1 = z.value(UNITS.REFERENCEFRAME).doubleValue();
                            if (!(Math.abs(z1 - (z2 = this.posZ.get(q).value(UNITS.REFERENCEFRAME).doubleValue())) <= 0.05)) continue;
                            unique = false;
                            break;
                        }
                        if (unique) {
                            ++uniqueZ;
                        }
                    }
                    this.posZ.add(z);
                }
            }
            if (this.pfsOffset != 0L) {
                this.in.seek(this.pfsOffset);
                for (int i18 = 0; i18 < imageOffsets.size(); ++i18) {
                    this.addGlobalMetaList("PFS Offset", this.in.readInt());
                }
            }
            if (this.pfsStateOffset != 0L) {
                this.in.seek(this.pfsStateOffset);
                for (int i19 = 0; i19 < imageOffsets.size(); ++i19) {
                    this.addGlobalMetaList("PFS Status", this.in.readInt());
                }
            }
            if (this.core.size() == 1 && (uniqueX == this.getSizeT() && uniqueY == this.getSizeT() || uniqueZ == this.getSizeT())) {
                int count = this.getSizeT();
                ((CoreMetadata)this.core.get((int)0, (int)0)).imageCount /= count;
                ((CoreMetadata)this.core.get((int)0, (int)0)).sizeT = 1;
                for (i3 = 1; i3 < count; ++i3) {
                    this.core.add(this.core.get(0, 0));
                }
                numSeries = this.core.size();
            }
            if (numSeries > 1 && (this.getImageCount() == imageOffsets.size() && this.getSizeC() == 1 || this.getImageCount() == imageOffsets.size() * this.getSizeC())) {
                CoreMetadata first = (CoreMetadata)this.core.get(0, 0);
                this.core.clear();
                this.core.add(first);
                numSeries = 1;
            }
            this.offsets = new long[numSeries][this.getImageCount()];
            int[] lengths = new int[4];
            if (!this.imageMetadataLVProcessed.booleanValue()) {
                int nextChar = 2;
                for (int i20 = 0; i20 < lengths.length; ++i20) {
                    if (i20 == this.fieldIndex) {
                        lengths[i20] = this.core.size();
                        continue;
                    }
                    int axis = this.getDimensionOrder().charAt(nextChar++);
                    if (axis == 90) {
                        lengths[i20] = this.getSizeZ();
                        continue;
                    }
                    if (axis == 67) {
                        lengths[i20] = 1;
                        continue;
                    }
                    if (axis != 84) continue;
                    lengths[i20] = this.getSizeT();
                }
            } else {
                int currPos = 1;
                lengths[0] = 1;
                lengths[1] = 1;
                lengths[2] = 1;
                lengths[3] = 1;
                for (char c : this.imageMetadataLVOrder.toCharArray()) {
                    if (c == 'Z') {
                        lengths[currPos] = this.getSizeZ();
                    } else if (c == 'M') {
                        this.fieldIndex = currPos;
                        lengths[currPos] = this.core.size();
                    } else if (c == 'T') {
                        lengths[currPos] = this.getSizeT();
                    } else {
                        --currPos;
                    }
                    ++currPos;
                }
                if (!this.imageMetadataLVOrder.contains("M")) {
                    this.fieldIndex = 3;
                }
            }
            int[] zctLengths = new int[4];
            System.arraycopy(lengths, 0, zctLengths, 0, lengths.length);
            zctLengths[this.fieldIndex] = 1;
            boolean oneIndexed = false;
            for (int i21 = 0; i21 < imageOffsets.size(); ++i21) {
                String imageName;
                int ndx;
                long offset = (Long)imageOffsets.get(i21);
                long[] p = (long[])imageLengths.get(i21);
                long length = p[0] + p[1];
                if (this.getSizeC() == 0) {
                    int sizeC = (int)(length / (long)(this.getSizeX() * this.getSizeY() * FormatTools.getBytesPerPixel(this.getPixelType())));
                    for (int q = 0; q < this.getSeriesCount(); ++q) {
                        ((CoreMetadata)this.core.get((int)q, (int)0)).sizeC = sizeC;
                    }
                }
                if ((ndx = Integer.parseInt((imageName = (String)imageNames.get(i21)).replaceAll("\\D", ""))) == 1 && i21 == 0) {
                    oneIndexed = true;
                }
                if (oneIndexed) {
                    --ndx;
                }
                int[] pos = FormatTools.rasterToPosition(lengths, ndx);
                int seriesIndex = pos[this.fieldIndex];
                pos[this.fieldIndex] = 0;
                int plane = FormatTools.positionToRaster(zctLengths, pos);
                if (seriesIndex >= this.offsets.length || plane >= this.offsets[seriesIndex].length) continue;
                this.offsets[seriesIndex][plane] = offset + p[0] + 8L;
            }
            ArrayList<long[]> tmpOffsets = new ArrayList<long[]>();
            for (i2 = 0; i2 < this.offsets.length; ++i2) {
                if (this.offsets[i2].length <= 0 || this.offsets[i2][0] <= 0L) continue;
                tmpOffsets.add(this.offsets[i2]);
            }
            this.offsets = new long[tmpOffsets.size()][];
            for (i2 = 0; i2 < tmpOffsets.size(); ++i2) {
                this.offsets[i2] = (long[])tmpOffsets.get(i2);
            }
            if (this.offsets.length != this.getSeriesCount()) {
                int x = this.getSizeX();
                int y = this.getSizeY();
                int c = this.getSizeC();
                int pixelType = this.getPixelType();
                int bitsPerPixel = this.getBitsPerPixel();
                boolean rgb = this.isRGB();
                String order = this.getDimensionOrder();
                this.core = new CoreMetadataList();
                for (int i22 = 0; i22 < this.offsets.length; ++i22) {
                    CoreMetadata ms = new CoreMetadata();
                    this.core.add(ms);
                    ms.sizeX = x;
                    ms.sizeY = y;
                    ms.sizeC = c == 0 ? 1 : c;
                    ms.pixelType = pixelType;
                    ms.bitsPerPixel = bitsPerPixel;
                    ms.rgb = rgb;
                    ms.sizeZ = 1;
                    ms.dimensionOrder = order;
                    int invalid = 0;
                    for (int q = 0; q < this.offsets[i22].length; ++q) {
                        if (this.offsets[i22][q] != 0L) continue;
                        ++invalid;
                    }
                    ms.imageCount = this.offsets[i22].length - invalid;
                    ms.sizeT = ms.imageCount / (rgb ? 1 : ms.sizeC);
                    if (ms.sizeT != 0) continue;
                    ms.sizeT = 1;
                }
            } else {
                for (i2 = 0; i2 < this.getSeriesCount(); ++i2) {
                    CoreMetadata ms = (CoreMetadata)this.core.get(i2, 0);
                    ms.sizeX = this.getSizeX();
                    ms.sizeY = this.getSizeY();
                    ms.sizeC = this.getSizeC() == 0 ? 1 : this.getSizeC();
                    ms.sizeZ = this.getSizeZ() == 0 ? 1 : this.getSizeZ();
                    ms.sizeT = this.getSizeT() == 0 ? 1 : this.getSizeT();
                    ms.imageCount = this.getImageCount();
                    ms.pixelType = this.getPixelType();
                    ms.bitsPerPixel = this.getBitsPerPixel();
                    ms.dimensionOrder = this.getDimensionOrder();
                }
            }
            boolean hasColor = false;
            for (String ch : this.channelColors.keySet()) {
                Integer color = this.channelColors.get(ch);
                if (color == 0xFFFFFF || color == 0) continue;
                hasColor = true;
                break;
            }
            this.split = this.getSizeC() > 1;
            for (int i23 = 0; i23 < this.getSeriesCount(); ++i23) {
                CoreMetadata ms = (CoreMetadata)this.core.get(i23, 0);
                ms.rgb = false;
                ms.littleEndian = true;
                ms.interleaved = false;
                ms.indexed = this.channelColors.size() > 0 && hasColor;
                ms.falseColor = true;
                ms.metadataComplete = true;
                ms.imageCount = ms.sizeZ * ms.sizeT * ms.sizeC;
            }
            if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM && customDataOffsets.size() > 0) {
                this.in.seek((Long)customDataOffsets.get(0));
                long[] p = (long[])customDataLengths.get(0);
                long len = p[0] + p[1];
                int timestampBytes = imageOffsets.size() * 8;
                this.in.seek(this.in.getFilePointer() + (len - (long)timestampBytes));
                for (int series = 0; series < this.getSeriesCount(); ++series) {
                    this.setSeries(series);
                    int count = this.split ? this.getImageCount() / this.getSizeC() : this.getImageCount();
                    for (int plane = 0; plane < count; ++plane) {
                        double time = this.in.readDouble() / 1000.0;
                        this.tsT.add(time);
                        this.addSeriesMetaList("timestamp", time);
                    }
                }
                this.setSeries(0);
            }
            this.populateMetadataStore(handler);
            return;
        }
        this.in.seek(0L);
        this.isJPEG = true;
        LOGGER.info("Calculating image offsets");
        ArrayList<Long> vs = new ArrayList<Long>();
        long pos = this.in.getFilePointer();
        boolean lastBoxFound = false;
        int length = 0;
        int box = 0;
        int x = 0;
        int y = 0;
        int c = 0;
        int type = 0;
        while (!lastBoxFound) {
            pos = this.in.getFilePointer();
            long nextPos = pos + (long)(length = this.in.readInt());
            if (nextPos < 0L || nextPos >= this.in.length() || length == 0) {
                lastBoxFound = true;
            }
            box = this.in.readInt();
            pos = this.in.getFilePointer();
            length -= 8;
            if (box == 1785737827) {
                vs.add(pos);
            } else if (box == 1785737832) {
                this.in.skipBytes(4);
                String s2 = this.in.readString(4);
                if (s2.equals("ihdr")) {
                    y = this.in.readInt();
                    x = this.in.readInt();
                    c = this.in.readShort();
                    type = this.in.readInt();
                    type = type == 252117248 || type == 0xF070000 ? 3 : 1;
                }
            }
            if (lastBoxFound || box == 1785737832) continue;
            this.in.skipBytes(length);
        }
        LOGGER.info("Finding XML metadata");
        this.in.seek((Long)vs.get(vs.size() - 1));
        boolean found = false;
        long off = -1L;
        byte[] buf = new byte[8192];
        block64: while (!found && this.in.getFilePointer() < this.in.length()) {
            int read = 0;
            if (this.in.getFilePointer() == ((Long)vs.get(vs.size() - 1)).longValue()) {
                read = this.in.read(buf);
            } else {
                System.arraycopy(buf, buf.length - 10, buf, 0, 10);
                read = this.in.read(buf, 10, buf.length - 10);
            }
            if (read == buf.length) {
                read -= 10;
            }
            for (int i24 = 0; i24 < read + 9; ++i24) {
                if (buf[i24] != -1 || buf[i24 + 1] != -39) continue;
                found = true;
                off = this.in.getFilePointer() - (long)(read + 10) + (long)i24;
                i24 = buf.length;
                continue block64;
            }
        }
        buf = null;
        LOGGER.info("Parsing XML");
        ArrayList<Object> zs = new ArrayList();
        ArrayList<Object> ts = new ArrayList();
        int numSeries = 0;
        ND2Handler handler = null;
        if (off > 0L && off < this.in.length() - 5L && this.in.length() - off - 5L > 14L) {
            this.in.seek(off + 4L);
            StringBuilder sb = new StringBuilder();
            sb.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><NIKON>");
            String s3 = null;
            int blockLength = 0;
            while (this.in.getFilePointer() < this.in.length() && (blockLength = this.in.readShort()) >= 2) {
                int closedBracket;
                if ((long)(blockLength -= 2) + this.in.getFilePointer() >= this.in.length()) {
                    blockLength = (int)(this.in.length() - this.in.getFilePointer());
                }
                s3 = this.in.readString(blockLength);
                int openBracket = (s3 = s3.replaceAll("<!--.+?>", "")).indexOf(60);
                if (openBracket == -1 || (closedBracket = s3.lastIndexOf(">") + 1) < openBracket || (s3 = s3.substring(openBracket, closedBracket).trim()).indexOf("CalibrationSeq") != -1 || s3.indexOf("VCAL") != -1 || s3.indexOf("jp2cLUNK") != -1) continue;
                sb.append(s3);
            }
            s3 = null;
            sb.append("</NIKON>");
            LOGGER.info("Finished assembling XML string");
            int offset = 0;
            int len = sb.length();
            for (int i25 = 0; i25 < len; ++i25) {
                char ch = sb.charAt(i25);
                if (offset == 0 && ch == '!') {
                    offset = i25 + 1;
                }
                if (!Character.isISOControl(ch) && Character.isDefined(ch)) continue;
                sb.setCharAt(i25, ' ');
            }
            ((CoreMetadata)this.core.get((int)0, (int)0)).dimensionOrder = "";
            if (len - offset < offset) {
                offset = 0;
            }
            String xml = sb.substring(offset, len);
            sb = null;
            handler = new ND2Handler(this.core, vs.size());
            try {
                xml = XMLTools.sanitizeXML(xml);
                XMLTools.parseXML(xml, (DefaultHandler)handler);
            }
            catch (IOException ch) {
                // empty catch block
            }
            xml = null;
            this.isLossless = handler.isLossless();
            this.fieldIndex = handler.getFieldIndex();
            zs = handler.getZSections();
            ts = handler.getTimepoints();
            numSeries = handler.getSeriesCount();
            this.core = handler.getCoreMetadataList();
            Hashtable<String, Object> globalMetadata = handler.getMetadata();
            for (Map.Entry entry : globalMetadata.entrySet()) {
                this.addGlobalMeta((String)entry.getKey(), entry.getValue());
            }
        }
        LOGGER.info("Populating metadata");
        ((CoreMetadata)this.core.get((int)0, (int)0)).pixelType = 1;
        this.offsets = new long[1][2];
        this.offsets[0][0] = (Long)vs.get(0);
        if (this.offsets[0].length > 1 && vs.size() > 1) {
            this.offsets[0][1] = (Long)vs.get(1);
        }
        this.in.seek(this.offsets[0][0]);
        if (this.getSizeC() == 0) {
            ((CoreMetadata)this.core.get((int)0, (int)0)).sizeC = 1;
        }
        int n = c = (numBands = c) > 1 ? numBands : this.getSizeC();
        if (numBands == 1 && this.getImageCount() == 1) {
            c = 1;
        }
        for (i = 0; i < this.getSeriesCount(); ++i) {
            CoreMetadata ms = (CoreMetadata)this.core.get(i, 0);
            ms.sizeC = c;
            ms.rgb = numBands > 1;
            ms.pixelType = type;
        }
        if (this.getDimensionOrder() == null) {
            ((CoreMetadata)this.core.get((int)0, (int)0)).dimensionOrder = "";
        }
        if (this.getSizeC() > 1) {
            ((CoreMetadata)this.core.get((int)0, (int)0)).dimensionOrder = this.getDimensionOrder().replaceAll("C", "");
            ((CoreMetadata)this.core.get((int)0, (int)0)).dimensionOrder = "C" + this.getDimensionOrder();
            ++this.fieldIndex;
        }
        if (this.getDimensionOrder().indexOf(90) == -1) {
            ((CoreMetadata)this.core.get((int)0, (int)0)).dimensionOrder = ((CoreMetadata)this.core.get((int)0, (int)0)).dimensionOrder + 'Z';
        }
        if (this.getDimensionOrder().indexOf(67) == -1) {
            ((CoreMetadata)this.core.get((int)0, (int)0)).dimensionOrder = ((CoreMetadata)this.core.get((int)0, (int)0)).dimensionOrder + 'C';
        }
        if (this.getDimensionOrder().indexOf(84) == -1) {
            ((CoreMetadata)this.core.get((int)0, (int)0)).dimensionOrder = ((CoreMetadata)this.core.get((int)0, (int)0)).dimensionOrder + 'T';
        }
        ((CoreMetadata)this.core.get((int)0, (int)0)).dimensionOrder = "XY" + this.getDimensionOrder();
        if (this.getImageCount() == 0) {
            int channels;
            ((CoreMetadata)this.core.get((int)0, (int)0)).imageCount = vs.size();
            ((CoreMetadata)this.core.get((int)0, (int)0)).sizeZ = Math.max(zs.size(), 1);
            ((CoreMetadata)this.core.get((int)0, (int)0)).sizeT = Math.max(ts.size(), 1);
            int n2 = channels = this.isRGB() ? 1 : this.getSizeC();
            if (channels * this.getSizeZ() * this.getSizeT() != this.getImageCount()) {
                ((CoreMetadata)this.core.get((int)0, (int)0)).sizeZ = 1;
                ((CoreMetadata)this.core.get((int)0, (int)0)).sizeT = this.getImageCount() / channels;
                ((CoreMetadata)this.core.get((int)0, (int)0)).imageCount = this.getSizeZ() * this.getSizeT() * channels;
            }
        }
        if (this.getSizeZ() == 0) {
            ((CoreMetadata)this.core.get((int)0, (int)0)).sizeZ = 1;
        }
        if (this.getSizeT() == 0) {
            ((CoreMetadata)this.core.get((int)0, (int)0)).sizeT = 1;
        }
        for (i = 0; i < this.getSeriesCount(); ++i) {
            CoreMetadata ms = (CoreMetadata)this.core.get(i, 0);
            ms.sizeZ = this.getSizeZ();
            ms.sizeT = this.getSizeT();
            ms.imageCount = this.getSizeZ() * this.getSizeT() * (this.isRGB() ? 1 : this.getSizeC());
            ms.dimensionOrder = this.getDimensionOrder();
            ms.sizeX = x;
            ms.sizeY = y;
            ms.interleaved = false;
            ms.littleEndian = false;
            ms.metadataComplete = true;
        }
        int nplanes = this.getSizeZ() * this.getEffectiveSizeC();
        if (numSeries == 0) {
            numSeries = 1;
        }
        if (numSeries * nplanes * this.getSizeT() > vs.size()) {
            numSeries = vs.size() / (nplanes * this.getSizeT());
        }
        this.offsets = new long[numSeries][this.getImageCount()];
        for (int i26 = 0; i26 < this.getSizeT(); ++i26) {
            for (int j = 0; j < numSeries; ++j) {
                for (int q = 0; q < nplanes; ++q) {
                    this.offsets[j][i26 * nplanes + q] = (Long)vs.remove(0);
                }
            }
        }
        this.populateMetadataStore(handler);
    }

    private ArrayList<String> iterateIn(RandomAccessInputStream in, Long stop) {
        return this.iterateIn(in, stop, false);
    }

    private ArrayList<String> iterateIn(RandomAccessInputStream in, Long stop, boolean minimal) {
        Double zHigh = null;
        Double zLow = null;
        ArrayList<String> textInfos = new ArrayList<String>();
        try {
            Integer currentColor = null;
            block15: while (in.getFilePointer() < stop) {
                Object value;
                long startOffset = in.getFilePointer();
                int type = in.read();
                int letters = in.read();
                String name = DataTools.stripString(in.readString(letters * 2));
                switch (type) {
                    case 1: {
                        value = in.readBoolean();
                        break;
                    }
                    case 2: {
                        value = in.readInt();
                        break;
                    }
                    case 3: {
                        value = in.readInt();
                        break;
                    }
                    case 4: {
                        value = in.readLong();
                        break;
                    }
                    case 5: {
                        value = in.readLong();
                        break;
                    }
                    case 6: {
                        value = in.readDouble();
                        break;
                    }
                    case 7: {
                        value = in.readLong();
                        break;
                    }
                    case 8: {
                        char currentChar = '\u0000';
                        StringBuilder resultString = new StringBuilder();
                        while ((currentChar = in.readChar()) != '\u0000') {
                            resultString.append(currentChar);
                        }
                        value = resultString.toString();
                        if (!name.startsWith("TextInfoItem")) break;
                        textInfos.add((String)value);
                        break;
                    }
                    case 9: {
                        long length = in.readLong();
                        if (length + in.getFilePointer() > stop) {
                            in.seek(stop);
                            continue block15;
                        }
                        value = "ByteArray";
                        if (length > 2L) {
                            this.iterateIn(in, stop);
                            break;
                        }
                        in.skipBytes(length);
                        break;
                    }
                    case 10: {
                        int numberOfItems = in.readInt();
                        Long off = in.readLong() - in.getFilePointer() - 4L - 2L - (long)(letters * 2);
                        value = "LEVEL";
                        this.iterateIn(in, off + in.getFilePointer());
                        if (off < 0L) break;
                        in.seek(off + in.getFilePointer() + (long)(numberOfItems * 8));
                        value = in.readLong();
                        break;
                    }
                    case 11: {
                        int numberOfItems = in.readInt();
                        Long off = in.readLong();
                        value = "LEVEL";
                        long endOffset = off + startOffset;
                        this.iterateIn(in, endOffset);
                        in.seek(endOffset + (long)(numberOfItems * 8));
                        break;
                    }
                    default: {
                        continue block15;
                    }
                }
                if (minimal) continue;
                if ((name = name.trim()).equals("bUseZ")) {
                    this.useZ = new Boolean(value.toString());
                } else if (name.equals("sDescription")) {
                    if (currentColor != null) {
                        this.textChannelNames.add(value.toString());
                        this.channelColors.put(value.toString(), currentColor);
                    }
                } else if (name.equals("uiColor")) {
                    currentColor = (Integer)value;
                } else if (name.equals("dExposureTime")) {
                    if ((Double)value > 0.0) {
                        this.exposureTime.add((Double)value / 1000.0);
                    }
                } else if (name.equals("EmWavelength")) {
                    Double wave = Double.parseDouble(value.toString());
                    this.textEmissionWavelengths.add(wave);
                } else if (name.equals("dZStep")) {
                    this.trueSizeZ = new Double(value.toString());
                } else if (name.equals("dZHigh")) {
                    zHigh = DataTools.parseDouble(value.toString());
                } else if (name.equals("dZLow")) {
                    zLow = DataTools.parseDouble(value.toString());
                } else if (name.equals("dPosX")) {
                    ++this.positionCount;
                }
                if (type == 11 || type == 10 || type == 9) continue;
                this.addGlobalMeta(name, value);
            }
        }
        catch (Exception e) {
            LOGGER.debug("", e);
        }
        if (zHigh != null && zLow != null && this.trueSizeZ != null && this.trueSizeZ > 0.0) {
            ((CoreMetadata)this.core.get((int)0, (int)0)).sizeZ = (int)Math.ceil(Math.abs(zHigh - zLow) / this.trueSizeZ) + 1;
        }
        return textInfos;
    }

    private void populateMetadataStore(ND2Handler handler) throws FormatException {
        Double mag;
        Double na;
        int i;
        int i2;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, true);
        String filename = new Location(this.getCurrentFile()).getName();
        if (handler != null) {
            ArrayList<String> posNames = handler.getPositionNames();
            int nameWidth = String.valueOf(this.getSeriesCount()).length();
            for (i2 = 0; i2 < this.getSeriesCount(); ++i2) {
                String seriesSuffix = String.format("(series %0" + nameWidth + "d)", i2 + 1);
                String suffix = i2 < posNames.size() && !posNames.get(i2).equals("") ? posNames.get(i2) : seriesSuffix;
                String name = filename + " " + suffix;
                store.setImageName(name.trim(), i2);
            }
        }
        this.colors = new int[this.getEffectiveSizeC()];
        ArrayList<String> channelNames = null;
        if (handler != null) {
            channelNames = handler.getChannelNames();
            if (channelNames.size() < this.getEffectiveSizeC() && this.backupHandler != null) {
                channelNames = this.backupHandler.getChannelNames();
            }
            if (channelNames.size() < this.getEffectiveSizeC()) {
                channelNames = this.textChannelNames;
            }
            for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                if (c >= channelNames.size()) continue;
                String channelName = channelNames.get(c);
                Integer channelColor = this.channelColors.get(channelName);
                this.colors[c] = channelColor == null ? 0 : channelColor;
            }
        }
        if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM) {
            return;
        }
        String instrumentID = MetadataTools.createLSID("Instrument", 0);
        store.setInstrumentID(instrumentID, 0);
        for (i2 = 0; i2 < this.getSeriesCount(); ++i2) {
            store.setImageInstrumentRef(instrumentID, i2);
            for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                int red = this.colors[c] & 0xFF;
                int green = (this.colors[c] & 0xFF00) >> 8;
                int blue = (this.colors[c] & 0xFF0000) >> 16;
                if (red == 0 && green == 0 && blue == 0) continue;
                store.setChannelColor(new Color(red, green, blue, 255), i2, c);
            }
        }
        if (handler != null) {
            for (i2 = 0; i2 < this.getSeriesCount(); ++i2) {
                Length size;
                double sizeX = handler.getPixelSizeX();
                double sizeY = handler.getPixelSizeY();
                double sizeZ = handler.getPixelSizeZ();
                if (this.trueSizeX > 0.0) {
                    store.setPixelsPhysicalSizeX(FormatTools.getPhysicalSizeX(this.trueSizeX), i2);
                } else {
                    size = FormatTools.getPhysicalSizeX(sizeX);
                    if (size != null) {
                        store.setPixelsPhysicalSizeX(size, i2);
                    }
                }
                if (this.trueSizeY > 0.0) {
                    store.setPixelsPhysicalSizeY(FormatTools.getPhysicalSizeY(this.trueSizeY), i2);
                } else if (this.trueSizeX > 0.0) {
                    store.setPixelsPhysicalSizeY(FormatTools.getPhysicalSizeY(this.trueSizeX), i2);
                } else {
                    size = FormatTools.getPhysicalSizeY(sizeY);
                    if (size == null) {
                        size = FormatTools.getPhysicalSizeY(sizeX);
                    }
                    if (size != null) {
                        store.setPixelsPhysicalSizeY(size, i2);
                    }
                }
                if (this.trueSizeZ != null && this.trueSizeZ > 0.0) {
                    store.setPixelsPhysicalSizeZ(FormatTools.getPhysicalSizeZ(this.trueSizeZ), i2);
                    continue;
                }
                size = FormatTools.getPhysicalSizeZ(sizeZ);
                if (size == null) continue;
                store.setPixelsPhysicalSizeZ(size, i2);
            }
        }
        for (Double time : this.exposureTime) {
            this.addGlobalMetaList("Exposure time (text)", time);
        }
        if (handler != null && handler.getExposureTimes().size() > 0) {
            for (Double time : handler.getExposureTimes()) {
                this.addGlobalMetaList("Exposure time (primary XML)", time);
            }
            if (this.backupHandler != null) {
                for (Double time : this.backupHandler.getExposureTimes()) {
                    this.addGlobalMetaList("Exposure time (secondary XML)", time);
                }
            }
            if (this.exposureTime.size() == 0 || handler.getExposureTimes().size() == 1 || this.exposureTime.size() % this.getSizeC() != 0) {
                this.exposureTime = handler.getExposureTimes();
                if (this.backupHandler != null && this.backupHandler.getExposureTimes().size() > this.exposureTime.size()) {
                    this.exposureTime = this.backupHandler.getExposureTimes();
                }
            } else if (this.backupHandler == null || this.backupHandler.getExposureTimes().size() == 0) {
                this.exposureTime = handler.getExposureTimes();
            } else if (this.backupHandler != null && this.backupHandler.getExposureTimes().size() == this.exposureTime.size()) {
                this.exposureTime = this.backupHandler.getExposureTimes();
            }
        }
        int zcPlanes = this.getImageCount() / ((this.split ? this.getSizeC() : 1) * this.getSizeT());
        for (int i3 = 0; i3 < this.getSeriesCount(); ++i3) {
            if (this.tsT.size() > 0) {
                this.setSeries(i3);
                for (int n = 0; n < this.getImageCount(); ++n) {
                    int[] coords = this.getZCTCoords(n);
                    int stampIndex = this.getIndex(coords[0], this.split ? 0 : coords[1], 0);
                    stampIndex += (coords[2] * this.getSeriesCount() + i3) * zcPlanes;
                    if (this.tsT.size() == this.getImageCount()) {
                        stampIndex = n;
                    } else if (this.tsT.size() == this.getSizeZ()) {
                        stampIndex = coords[0];
                    }
                    if (stampIndex < this.tsT.size()) {
                        double stamp = this.tsT.get(stampIndex);
                        store.setPlaneDeltaT(new Time(stamp, UNITS.SECOND), i3, n);
                    }
                    int index = i3 * this.getSizeC() + coords[1];
                    if (this.exposureTime.size() >= this.getSizeC() && this.exposureTime.size() < this.getSizeC() * this.getSeriesCount()) {
                        index = coords[1];
                    } else if (this.exposureTime.size() == 1) {
                        index = 0;
                    }
                    if (this.exposureTime == null || index >= this.exposureTime.size() || this.exposureTime.get(index) == null) continue;
                    store.setPlaneExposureTime(new Time(this.exposureTime.get(index), UNITS.SECOND), i3, n);
                }
            }
            if (handler != null) {
                if (this.posX == null) {
                    this.posX = handler.getXPositions();
                }
                if (this.posY == null) {
                    this.posY = handler.getYPositions();
                }
                if (this.posZ == null) {
                    this.posZ = handler.getZPositions();
                }
            }
            String pos = "for position";
            for (int n = 0; n < this.getImageCount(); ++n) {
                String key;
                int[] coords = this.getZCTCoords(n);
                int index = coords[0];
                index += (coords[2] * this.getSeriesCount() + i3) * zcPlanes;
                if (this.posX != null) {
                    if (index >= this.posX.size()) {
                        index = i3;
                    }
                    if (index < this.posX.size()) {
                        key = "X position ";
                        store.setPlanePositionX(this.posX.get(index), i3, n);
                        this.addSeriesMetaList(key, this.posX.get(index));
                        this.addGlobalMetaList(key + pos, this.posX.get(index));
                    }
                }
                if (this.posY != null && index < this.posY.size()) {
                    key = "Y position ";
                    store.setPlanePositionY(this.posY.get(index), i3, n);
                    this.addSeriesMetaList(key, this.posY.get(index));
                    this.addGlobalMetaList(key + pos, this.posY.get(index));
                }
                if (this.posZ == null || index >= this.posZ.size()) continue;
                store.setPlanePositionZ(this.posZ.get(index), i3, n);
                key = "Z position " + pos + ", plane";
                this.addSeriesMetaList(key, this.posZ.get(index));
                this.addGlobalMetaList(key, this.posZ.get(index));
            }
        }
        if (handler == null) {
            this.setSeries(0);
            return;
        }
        String detectorID = MetadataTools.createLSID("Detector", 0, 0);
        store.setDetectorID(detectorID, 0, 0);
        store.setDetectorModel(handler.getCameraModel(), 0, 0);
        store.setDetectorType(MetadataTools.getDetectorType("Other"), 0, 0);
        ArrayList<String> modality = handler.getModalities();
        ArrayList<String> binning = handler.getBinnings();
        ArrayList<Double> speed = handler.getSpeeds();
        ArrayList<Double> gain = handler.getGains();
        ArrayList<Double> temperature = handler.getTemperatures();
        ArrayList<Double> exWave = handler.getExcitationWavelengths();
        ArrayList<Double> emWave = handler.getEmissionWavelengths();
        ArrayList<Integer> power = handler.getPowers();
        ArrayList<Hashtable<String, String>> rois = handler.getROIs();
        if (this.backupHandler != null) {
            if (emWave.size() == 0) {
                emWave = this.backupHandler.getEmissionWavelengths();
            }
            if (exWave.size() == 0) {
                exWave = this.backupHandler.getExcitationWavelengths();
            }
        }
        for (i = 0; i < this.getSeriesCount(); ++i) {
            for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                Length excitation;
                int index = c;
                Double pinholeSize = handler.getPinholeSize();
                if (pinholeSize != null) {
                    store.setChannelPinholeSize(new Length(pinholeSize, UNITS.MICROMETER), i, c);
                }
                if (index < channelNames.size()) {
                    String channelName = channelNames.get(index);
                    store.setChannelName(channelName, i, c);
                } else if (channelNames.size() >= this.getEffectiveSizeC()) {
                    store.setChannelName(channelNames.get(c), i, c);
                }
                if (index < modality.size()) {
                    store.setChannelAcquisitionMode(MetadataTools.getAcquisitionMode(modality.get(index)), i, c);
                }
                if (index < emWave.size() || index < this.textEmissionWavelengths.size()) {
                    Double value = index < emWave.size() ? emWave.get(index) : this.textEmissionWavelengths.get(index);
                    Length emission = FormatTools.getEmissionWavelength(value);
                    if (emission != null) {
                        store.setChannelEmissionWavelength(emission, i, c);
                    }
                } else if (emWave.size() > 0 || this.textEmissionWavelengths.size() > 0) {
                    store.setChannelColor(new Color(255, 255, 255, 255), i, c);
                }
                if (index < exWave.size() && (excitation = FormatTools.getExcitationWavelength(exWave.get(index))) != null) {
                    store.setChannelExcitationWavelength(excitation, i, c);
                }
                if (index < binning.size()) {
                    store.setDetectorSettingsBinning(MetadataTools.getBinning(binning.get(index)), i, c);
                }
                if (index < gain.size()) {
                    store.setDetectorSettingsGain(gain.get(index), i, c);
                }
                if (index < speed.size()) {
                    store.setDetectorSettingsReadOutRate(new Frequency(speed.get(index), UNITS.HERTZ), i, c);
                }
                store.setDetectorSettingsID(detectorID, i, c);
            }
        }
        for (i = 0; i < this.getSeriesCount(); ++i) {
            if (i * this.getSizeC() >= temperature.size()) continue;
            Double temp = temperature.get(i * this.getSizeC());
            store.setImagingEnvironmentTemperature(new Temperature(temp, UNITS.CELSIUS), i);
        }
        Double voltage = handler.getVoltage();
        if (voltage != null) {
            store.setDetectorSettingsVoltage(new ElectricPotential(voltage, UNITS.VOLT), 0, 0);
        }
        if ((na = handler.getNumericalAperture()) != null) {
            store.setObjectiveLensNA(na, 0, 0);
        }
        if ((mag = handler.getMagnification()) != null) {
            store.setObjectiveCalibratedMagnification(mag, 0, 0);
        }
        store.setObjectiveModel(handler.getObjectiveModel(), 0, 0);
        String immersion = handler.getImmersion();
        if (immersion == null) {
            immersion = "Other";
        }
        store.setObjectiveImmersion(MetadataTools.getImmersion(immersion), 0, 0);
        String correction = handler.getCorrection();
        if (correction == null || correction.length() == 0) {
            correction = "Other";
        }
        store.setObjectiveCorrection(MetadataTools.getCorrection(correction), 0, 0);
        String objectiveID = MetadataTools.createLSID("Objective", 0, 0);
        store.setObjectiveID(objectiveID, 0, 0);
        if (this.refractiveIndex == null) {
            this.refractiveIndex = handler.getRefractiveIndex();
        }
        for (int i4 = 0; i4 < this.getSeriesCount(); ++i4) {
            store.setObjectiveSettingsID(objectiveID, i4);
            if (this.refractiveIndex == null) continue;
            store.setObjectiveSettingsRefractiveIndex(this.refractiveIndex, i4);
        }
        this.setSeries(0);
        if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.NO_OVERLAYS) {
            return;
        }
        handler.populateROIs(store);
    }

    private Codec createCodec(boolean isJPEG) {
        return isJPEG ? new JPEG2000Codec() : new ZlibCodec();
    }

    private void copyPixels(int x, int y, int w, int h2, int bpp, int scanlinePad, byte[] pix, byte[] buf, boolean split) throws IOException {
        if (split) {
            pix = ImageTools.splitChannels(pix, this.lastChannel, this.getEffectiveSizeC(), bpp, false, true);
        }
        RandomAccessInputStream s2 = new RandomAccessInputStream(pix);
        this.readPlane(s2, x, y, w, h2, scanlinePad, buf);
        s2.close();
    }

    public static String sanitizeControl(String s2) {
        char[] c = s2.toCharArray();
        for (int i = 0; i < s2.length(); ++i) {
            if (!Character.isISOControl(c[i]) && Character.isDefined(c[i])) continue;
            c[i] = 32;
        }
        return new String(c);
    }

    private int getScanlinePad() {
        if (this.getSizeX() % 2 == 0) {
            return 0;
        }
        if (this.getSizeC() % 2 == 0) {
            return 0;
        }
        return 1;
    }

    private void parseText(String textString, int offsetCount, boolean useDimensions) {
        try {
            ND2Handler handler = new ND2Handler(this.core, offsetCount);
            String xmlString = XMLTools.sanitizeXML(textString);
            int start = xmlString.indexOf(60);
            int end = xmlString.lastIndexOf(">");
            if (start >= 0 && end >= 0 && end >= start) {
                xmlString = xmlString.substring(start, end + 1);
            }
            XMLTools.parseXML(xmlString, (DefaultHandler)handler);
            xmlString = null;
            textString = null;
            this.core = handler.getCoreMetadataList();
            if (this.backupHandler == null || this.backupHandler.getChannelNames().size() == 0) {
                this.backupHandler = handler;
            }
            Hashtable<String, Object> globalMetadata = handler.getMetadata();
            for (Map.Entry entry : globalMetadata.entrySet()) {
                this.addGlobalMeta((String)entry.getKey(), entry.getValue());
            }
        }
        catch (IOException e) {
            LOGGER.debug("Could not parse XML", e);
            String[] lines = textString.split("\n");
            ND2Handler handler = new ND2Handler(this.core, offsetCount);
            handler.imageMetadataLVExists = this.imageMetadataLVProcessed;
            for (String line : lines) {
                int separator = line.indexOf(58);
                if (separator < 0) continue;
                String key = line.substring(0, separator).trim();
                String value = line.substring(separator + 1).trim();
                if (useDimensions) {
                    handler.parseKeyAndValue(key, value, null);
                }
                if (!handler.isDimensions(key)) continue;
                this.textData = true;
            }
            if (useDimensions) {
                this.core = handler.getCoreMetadataList();
                if (this.backupHandler == null || this.backupHandler.getChannelNames().size() == 0) {
                    this.backupHandler = handler;
                }
            }
            if (((CoreMetadata)this.core.get((int)0, (int)0)).sizeZ == 0 && this.getSizeT() != offsetCount) {
                ((CoreMetadata)this.core.get((int)0, (int)0)).sizeT = 0;
            }
            textString = NativeND2Reader.sanitizeControl(textString);
            lines = textString.split(" ");
            for (int i = 0; i < lines.length; ++i) {
                StringBuilder sb = new StringBuilder(lines[i++]);
                while ((sb.length() == 0 || sb.charAt(sb.length() - 1) != ':') && sb.indexOf("_") < 0 && i < lines.length) {
                    sb.append(" ");
                    sb.append(lines[i++]);
                    if (i < lines.length) continue;
                }
                if (i >= lines.length) break;
                String key = sb.toString();
                sb.setLength(0);
                sb.append(lines[i++]);
                while (i < lines.length && lines[i].trim().length() > 0) {
                    sb.append(' ');
                    sb.append(lines[i++]);
                    if (i < lines.length) continue;
                }
                key = key.trim();
                key = key.substring(0, key.length() - 1);
                String value = sb.toString().trim();
                if (key.startsWith("- Step")) {
                    int end = key.indexOf(" ", 8);
                    if (end < 0) {
                        end = key.length();
                    }
                    if (end >= 8) {
                        value = key.substring(8, end);
                        key = key.substring(0, 8);
                    }
                    if (this.trueSizeZ == null) {
                        this.trueSizeZ = DataTools.parseDouble(value);
                    }
                } else if (key.equals("Name")) {
                    this.textChannelNames.add(value);
                } else if (key.startsWith("Line:")) {
                    if (value.endsWith("Active")) {
                        Double wavelength;
                        int first = key.lastIndexOf(":") + 1;
                        int last = key.lastIndexOf(";");
                        if (last - first < 0) {
                            last = first + key.substring(first).indexOf(32);
                        }
                        if ((wavelength = Double.valueOf(DataTools.parseDouble(key.substring(first, last).trim()) + 20.0)) != null) {
                            this.textEmissionWavelengths.add(wavelength);
                        }
                    }
                } else if (key.equals("Refractive Index")) {
                    this.refractiveIndex = DataTools.parseDouble(value);
                }
                if (this.metadata.containsKey(key)) {
                    Object oldValue = this.metadata.get(key);
                    this.metadata.put(key + " #1", oldValue);
                    this.metadata.put(key + " #2", value);
                    this.metadata.remove(key);
                    continue;
                }
                if (this.metadata.containsKey(key + " #1")) {
                    int index = 1;
                    while (this.metadata.containsKey(key + " #" + index)) {
                        ++index;
                    }
                    this.metadata.put(key + " #" + index, value);
                    continue;
                }
                this.metadata.put(key, value);
            }
        }
    }

    private void setDimensions(int numT, int numZ, int numSeries) {
        CoreMetadata ms0 = (CoreMetadata)this.core.get(0, 0);
        ms0.sizeT = numT;
        ms0.sizeZ = numZ;
        if (numSeries > 1) {
            int x = ms0.sizeX;
            int y = ms0.sizeY;
            int z = ms0.sizeZ;
            int tSize = ms0.sizeT;
            int c = ms0.sizeC;
            String order = ms0.dimensionOrder;
            this.core = new CoreMetadataList();
            for (int i = 0; i < numSeries; ++i) {
                CoreMetadata ms = new CoreMetadata();
                this.core.add(ms);
                ms.sizeX = x;
                ms.sizeY = y;
                ms.sizeZ = z == 0 ? 1 : z;
                ms.sizeC = c == 0 ? 1 : c;
                ms.sizeT = tSize == 0 ? 1 : tSize;
                ms.dimensionOrder = order;
            }
            ms0 = (CoreMetadata)this.core.get(0, 0);
        }
        ms0.imageCount = ms0.sizeZ * ms0.sizeC * ms0.sizeT;
    }

    static class ChunkMapEntry {
        public String name;
        public long position;
        public long length;

        ChunkMapEntry() {
        }

        public String toString() {
            return String.format("ChunkMapEntry<%s@%d(%d)>", this.name, this.position, this.length);
        }
    }
}

