/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.webp;

import com.twelvemonkeys.imageio.plugins.webp.WebPImageReader;
import com.twelvemonkeys.imageio.plugins.webp.WebPProviderInfo;
import com.twelvemonkeys.imageio.spi.ImageReaderSpiBase;
import com.twelvemonkeys.imageio.spi.ReaderWriterProviderInfo;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public final class WebPImageReaderSpi
extends ImageReaderSpiBase {
    public WebPImageReaderSpi() {
        super((ReaderWriterProviderInfo)new WebPProviderInfo());
    }

    public boolean canDecodeInput(Object object) throws IOException {
        return object instanceof ImageInputStream && WebPImageReaderSpi.canDecode((ImageInputStream)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canDecode(ImageInputStream imageInputStream) throws IOException {
        ByteOrder byteOrder = imageInputStream.getByteOrder();
        imageInputStream.mark();
        try {
            imageInputStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            if (imageInputStream.readInt() != 1179011410) {
                boolean bl = false;
                return bl;
            }
            imageInputStream.readInt();
            if (imageInputStream.readInt() != 1346520407) {
                boolean bl = false;
                return bl;
            }
            int n = imageInputStream.readInt();
            switch (n) {
                case 1480085590: {
                    boolean bl = WebPImageReaderSpi.containsSupportedChunk(imageInputStream, n);
                    return bl;
                }
                case 540561494: {
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            imageInputStream.setByteOrder(byteOrder);
            imageInputStream.reset();
        }
    }

    private static boolean containsSupportedChunk(ImageInputStream imageInputStream, int n) throws IOException {
        try {
            while (n != 1278758998 && n != 1213221953) {
                long l = imageInputStream.readUnsignedInt();
                imageInputStream.seek(imageInputStream.getStreamPosition() + l);
                n = imageInputStream.readInt();
                if (n == 1179471425) {
                    imageInputStream.seek(imageInputStream.getStreamPosition() + 4L + 16L);
                    n = imageInputStream.readInt();
                }
                if (n != 540561494) continue;
                return true;
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return false;
    }

    public ImageReader createReaderInstance(Object object) {
        return new WebPImageReader((ImageReaderSpi)((Object)this));
    }

    public String getDescription(Locale locale) {
        return "Google WebP File Format (WebP) Reader";
    }
}

