/*
 * Decompiled with CFR 0.152.
 */
package imagescience.utility;

import ij.IJ;
import ij.ImageJ;
import ij.gui.ProgressBar;
import java.awt.Graphics;
import java.awt.Panel;
import javax.swing.JLabel;

public class Progressor {
    private long step = 0L;
    private long steps = 0L;
    private long update = 0L;
    private long updates = 20L;
    private double min = 0.0;
    private double max = 1.0;
    private double percent = 0.0;
    private boolean display = false;
    private boolean enforce = false;
    private String status = null;
    private Progressor parent = null;

    public void updates(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Number of updates less than 0");
        }
        this.updates = l;
    }

    public long updates() {
        return this.updates;
    }

    public void steps(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Number of steps less than 0");
        }
        this.steps = l;
    }

    public long steps() {
        return this.steps;
    }

    public void step() {
        this.set(this.step + 1L);
    }

    public void step(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Number of steps less than 0");
        }
        this.set(this.step + l);
    }

    public void set(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Set value less than 0");
        }
        this.step = l;
        if (this.steps > 0L) {
            this.percent = (double)this.step / (double)this.steps;
            long l2 = (long)(this.percent * (double)this.updates);
            if (l2 > this.update) {
                this.update = l2;
                this.progress();
            }
        }
    }

    public void min(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Minimum progress value less than 0");
        }
        if (d > this.max) {
            throw new IllegalArgumentException("Minimum larger than maximum progress value");
        }
        this.min = d;
    }

    public double min() {
        if (this.parent != null) {
            double d = this.parent.min();
            double d2 = this.parent.max();
            return d + this.min * (d2 - d);
        }
        return this.min;
    }

    public void max(double d) {
        if (d > 1.0) {
            throw new IllegalArgumentException("Maximum progress value larger than 1");
        }
        if (d < this.min) {
            throw new IllegalArgumentException("Maximum less than minimum progress value");
        }
        this.max = d;
    }

    public double max() {
        if (this.parent != null) {
            double d = this.parent.min();
            double d2 = this.parent.max();
            return d + this.max * (d2 - d);
        }
        return this.max;
    }

    public void range(double d, double d2) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Minimum progress value less than 0");
        }
        if (d2 > 1.0) {
            throw new IllegalArgumentException("Maximum progress value larger than 1");
        }
        if (d > d2) {
            throw new IllegalArgumentException("Minimum larger than maximum progress value");
        }
        this.min = d;
        this.max = d2;
    }

    public void start() {
        this.step = 0L;
        this.update = 0L;
        this.percent = 0.0;
        this.progress();
    }

    public void stop() {
        this.percent = 1.0;
        this.progress();
    }

    private void progress() {
        ImageJ imageJ;
        if (this.display() && (imageJ = IJ.getInstance()) != null) {
            String string = this.status();
            double d = this.min();
            double d2 = this.max();
            double d3 = d + this.percent * (d2 - d);
            if (string == null || d3 >= 1.0) {
                string = "";
            }
            IJ.showStatus((String)string);
            IJ.showProgress((double)d3);
            if (this.enforce()) {
                Panel panel = imageJ.getStatusBar();
                JLabel jLabel = (JLabel)panel.getComponent(0);
                jLabel.setOpaque(true);
                jLabel.paintImmediately(jLabel.getBounds());
                ProgressBar progressBar = (ProgressBar)panel.getComponent(1);
                Graphics graphics = progressBar.getGraphics();
                if (graphics != null) {
                    progressBar.paint(graphics);
                }
            }
        }
    }

    public boolean display() {
        if (this.parent != null) {
            return this.parent.display();
        }
        return this.display;
    }

    public void display(boolean bl) {
        this.display = bl;
    }

    public boolean enforce() {
        if (this.parent != null) {
            return this.parent.enforce();
        }
        return this.enforce;
    }

    public void enforce(boolean bl) {
        this.enforce = bl;
    }

    public void parent(Progressor progressor) {
        this.parent = progressor;
    }

    public Progressor parent() {
        return this.parent;
    }

    public void status(String string) {
        this.status = string;
    }

    public String status() {
        String string;
        if (this.parent != null && (string = this.parent.status()) != null) {
            return string;
        }
        return this.status;
    }
}

