/*
 * Decompiled with CFR 0.152.
 */
package imagescience.utility;

import i5d.Image5D;
import i5d.cal.ChannelCalibration;
import i5d.cal.ChannelDisplayProperties;
import ij.ImagePlus;
import ij.ImageStack;
import ij.LookUpTable;
import ij.measure.Calibration;
import ij.process.ImageProcessor;
import java.awt.image.ColorModel;

public class I5DResource {
    public static final int GRAY = 0;
    public static final int COLOR = 1;
    public static final int OVERLAY = 2;
    public static final int TILED = 3;

    public static void mode(ImagePlus imagePlus, int n) {
        if (!(imagePlus instanceof Image5D)) {
            throw new IllegalArgumentException("Image is not an Image5D object");
        }
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException("Displaying mode is invalid");
        }
        Image5D image5D = (Image5D)imagePlus;
        image5D.setDisplayMode(n);
    }

    public static Calibration density(ImagePlus imagePlus, int n) {
        if (!(imagePlus instanceof Image5D)) {
            throw new IllegalArgumentException("Image is not an Image5D object");
        }
        Image5D image5D = (Image5D)imagePlus;
        image5D.storeCurrentChannelProperties();
        ChannelCalibration channelCalibration = image5D.getChannelCalibration(n);
        Calibration calibration = new Calibration();
        calibration.setFunction(channelCalibration.getFunction(), channelCalibration.getCoefficients(), channelCalibration.getValueUnit(), channelCalibration.isZeroClip());
        return calibration;
    }

    public static boolean instance(ImagePlus imagePlus) {
        return imagePlus instanceof Image5D;
    }

    public static int position(ImagePlus imagePlus, int n) {
        if (!(imagePlus instanceof Image5D)) {
            throw new IllegalArgumentException("Image is not an Image5D object");
        }
        Image5D image5D = (Image5D)imagePlus;
        return image5D.getCurrentPosition(n);
    }

    public static void position(ImagePlus imagePlus, int n, int n2) {
        if (!(imagePlus instanceof Image5D)) {
            throw new IllegalArgumentException("Image is not an Image5D object");
        }
        Image5D image5D = (Image5D)imagePlus;
        image5D.setCurrentPosition(n, n2);
    }

    public static void position(ImagePlus imagePlus, int n, int n2, int n3, int n4, int n5) {
        if (!(imagePlus instanceof Image5D)) {
            throw new IllegalArgumentException("Image is not an Image5D object");
        }
        Image5D image5D = (Image5D)imagePlus;
        image5D.setCurrentPosition(n, n2, n3, n4, n5);
    }

    public static ImageProcessor processor(ImagePlus imagePlus, int n) {
        if (!(imagePlus instanceof Image5D)) {
            throw new IllegalArgumentException("Image is not an Image5D object");
        }
        Image5D image5D = (Image5D)imagePlus;
        return image5D.getProcessor(n);
    }

    public static ImagePlus convert(ImagePlus imagePlus, boolean bl) {
        if (imagePlus instanceof Image5D) {
            return imagePlus;
        }
        int n = imagePlus.getWidth();
        int n2 = imagePlus.getHeight();
        int n3 = imagePlus.getNChannels();
        int n4 = imagePlus.getNSlices();
        int n5 = imagePlus.getNFrames();
        Image5D image5D = new Image5D(imagePlus.getTitle(), imagePlus.getType(), n, n2, n3, n4, n5, false);
        Object[] objectArray = imagePlus.getImageStack().getImageArray();
        int[] nArray = new int[]{0, 0, 0, 0, 0};
        for (int i = 0; i < n5; ++i) {
            nArray[4] = i;
            int n6 = i * n4 * n3;
            for (int j = 0; j < n4; ++j) {
                nArray[3] = j;
                int n7 = j * n3;
                for (int k = 0; k < n3; ++k) {
                    nArray[2] = k;
                    image5D.setCurrentPosition(nArray);
                    image5D.setPixels(objectArray[n6 + n7 + k]);
                }
            }
        }
        nArray[4] = 0;
        nArray[3] = 0;
        nArray[2] = 0;
        image5D.setCurrentPosition(nArray);
        if (bl) {
            image5D.setCalibration(imagePlus.getCalibration());
            image5D.storeCurrentChannelProperties();
            ChannelCalibration channelCalibration = image5D.getChannelCalibration(1);
            ImageProcessor imageProcessor = imagePlus.getProcessor();
            ColorModel colorModel = imageProcessor.getColorModel();
            for (int i = 1; i <= n3; ++i) {
                image5D.setChannelCalibration(i, channelCalibration.copy());
                ChannelDisplayProperties channelDisplayProperties = image5D.getChannelDisplayProperties(i);
                channelDisplayProperties.setMinValue(imageProcessor.getMin());
                channelDisplayProperties.setMaxValue(imageProcessor.getMax());
                channelDisplayProperties.setColorModel(colorModel);
            }
            image5D.restoreCurrentChannelProperties();
        }
        image5D.setDefaultChannelNames();
        return image5D;
    }

    public static void minmax(ImagePlus imagePlus, double d, double d2) {
        if (!(imagePlus instanceof Image5D)) {
            throw new IllegalArgumentException("Image is not an Image5D object");
        }
        Image5D image5D = (Image5D)imagePlus;
        int n = image5D.getNChannels();
        for (int i = 1; i <= n; ++i) {
            ChannelDisplayProperties channelDisplayProperties = image5D.getChannelDisplayProperties(i);
            channelDisplayProperties.setMinValue(d);
            channelDisplayProperties.setMaxValue(d2);
            image5D.restoreChannelProperties(i);
        }
        image5D.restoreCurrentChannelProperties();
    }

    public static void transfer(ImagePlus imagePlus, ImagePlus imagePlus2) {
        int n;
        if (!(imagePlus instanceof Image5D)) {
            throw new IllegalArgumentException("Source is not an Image5D object");
        }
        Image5D image5D = (Image5D)imagePlus;
        if (!(imagePlus2 instanceof Image5D)) {
            throw new IllegalArgumentException("Destination is not an Image5D object");
        }
        Image5D image5D2 = (Image5D)imagePlus2;
        int n2 = image5D.getNChannels();
        if (n2 != (n = image5D2.getNChannels())) {
            throw new IllegalArgumentException("Source and destination have different numbers of channels");
        }
        image5D.storeCurrentChannelProperties();
        for (int i = 1; i <= n2; ++i) {
            image5D2.setChannelDisplayProperties(i, image5D.getChannelDisplayProperties(i).copy());
            image5D2.setChannelCalibration(i, image5D.getChannelCalibration(i).copy());
            image5D2.restoreChannelProperties(i);
        }
        image5D2.restoreCurrentChannelProperties();
        image5D2.setDisplayMode(image5D.getDisplayMode());
    }

    public static void transfer(ImagePlus imagePlus, ImagePlus imagePlus2, int[][] nArray) {
        if (!(imagePlus instanceof Image5D)) {
            throw new IllegalArgumentException("Source is not an Image5D object");
        }
        Image5D image5D = (Image5D)imagePlus;
        if (!(imagePlus2 instanceof Image5D)) {
            throw new IllegalArgumentException("Destination is not an Image5D object");
        }
        Image5D image5D2 = (Image5D)imagePlus2;
        int[] nArray2 = nArray[1];
        int[] nArray3 = nArray[0];
        int n = nArray3.length;
        if (nArray2.length != n) {
            throw new IllegalArgumentException("Source and destination channel index arrays have different lengths");
        }
        image5D.storeCurrentChannelProperties();
        for (int i = 0; i < n; ++i) {
            image5D2.setChannelDisplayProperties(nArray2[i], image5D.getChannelDisplayProperties(nArray3[i]).copy());
            image5D2.setChannelCalibration(nArray2[i], image5D.getChannelCalibration(nArray3[i]).copy());
            image5D2.restoreChannelProperties(nArray2[i]);
        }
        image5D2.restoreCurrentChannelProperties();
        image5D2.setDisplayMode(image5D.getDisplayMode());
    }

    public static void transfer(ImagePlus imagePlus, ImagePlus imagePlus2, int n) {
        if (!(imagePlus instanceof Image5D)) {
            throw new IllegalArgumentException("Source is not an Image5D object");
        }
        Image5D image5D = (Image5D)imagePlus;
        ChannelCalibration channelCalibration = image5D.getChannelCalibration(n);
        Calibration calibration = imagePlus2.getCalibration();
        calibration.setFunction(channelCalibration.getFunction(), channelCalibration.getCoefficients(), channelCalibration.getValueUnit(), channelCalibration.isZeroClip());
        ChannelDisplayProperties channelDisplayProperties = image5D.getChannelDisplayProperties(n);
        ImageProcessor imageProcessor = imagePlus2.getProcessor();
        ImageStack imageStack = imagePlus2.getStack();
        if (channelDisplayProperties.isDisplayedGray() || image5D.isDisplayAllGray()) {
            ColorModel colorModel = LookUpTable.createGrayscaleColorModel((boolean)false);
            imageProcessor.setColorModel(colorModel);
            imageStack.setColorModel(colorModel);
        } else {
            imageProcessor.setColorModel(channelDisplayProperties.getColorModel());
            imageStack.setColorModel(channelDisplayProperties.getColorModel());
        }
        imageProcessor.setMinAndMax(channelDisplayProperties.getMinValue(), channelDisplayProperties.getMaxValue());
        if (channelDisplayProperties.getMinThreshold() != -808080.0) {
            imageProcessor.setThreshold(channelDisplayProperties.getMinThreshold(), channelDisplayProperties.getMaxThreshold(), channelDisplayProperties.getLutUpdateMode());
        }
    }

    public static void nodensity(ImagePlus imagePlus) {
        if (!(imagePlus instanceof Image5D)) {
            throw new IllegalArgumentException("Image is not an Image5D object");
        }
        Image5D image5D = (Image5D)imagePlus;
        int n = image5D.getNChannels();
        for (int i = 1; i <= n; ++i) {
            image5D.getChannelCalibration(i).disableDensityCalibration();
        }
        image5D.restoreCurrentChannelProperties();
    }

    public static void nocolor(ImagePlus imagePlus) {
        if (!(imagePlus instanceof Image5D)) {
            throw new IllegalArgumentException("Image is not an Image5D object");
        }
        Image5D image5D = (Image5D)imagePlus;
        int n = image5D.getNChannels();
        ColorModel colorModel = LookUpTable.createGrayscaleColorModel((boolean)false);
        for (int i = 1; i <= n; ++i) {
            image5D.getChannelDisplayProperties(i).setColorModel(colorModel);
            image5D.restoreChannelProperties(i);
        }
        image5D.restoreCurrentChannelProperties();
    }
}

