/*
 * Decompiled with CFR 0.152.
 */
package imagescience.utility;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class Formatter {
    private final DecimalFormat edf = new DecimalFormat("0.#E0", new DecimalFormatSymbols(Locale.US));
    private final DecimalFormat ndf = new DecimalFormat("0.#", new DecimalFormatSymbols(Locale.US));
    private int dfdecs = 1;
    private double dflobo = 0.1;
    private double limit = 1.0E-10;
    private String nan = "NaN";
    private String inf = "Inf";

    public void chop(double d) {
        this.limit = d < 0.0 ? -d : d;
    }

    public void decs(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Number of decimals less than 0");
        }
        if (n > 10) {
            throw new IllegalArgumentException("Number of decimals larger than 10");
        }
        if (this.dfdecs != n) {
            this.dfdecs = n;
            this.dflobo = 1.0 / Math.pow(10.0, this.dfdecs);
            StringBuffer stringBuffer = new StringBuffer("0");
            if (this.dfdecs > 0) {
                stringBuffer.append(".");
            }
            for (int i = 0; i < this.dfdecs; ++i) {
                stringBuffer.append("#");
            }
            String string = stringBuffer.toString();
            this.edf.applyPattern(string + "E0");
            this.ndf.applyPattern(string);
        }
    }

    public void nan(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.nan = string;
    }

    public void inf(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.inf = string;
    }

    public String d2s(double d) {
        double d2;
        if (Double.isNaN(d)) {
            return this.nan;
        }
        if (Double.isInfinite(d)) {
            return d < 0.0 ? "-" + this.inf : "+" + this.inf;
        }
        long l = Math.round(d);
        if ((double)l == d) {
            return String.valueOf(l);
        }
        double d3 = d2 = d < 0.0 ? -d : d;
        if (d2 < this.limit) {
            return "0";
        }
        String string = this.nan;
        string = d2 < this.dflobo || d2 > 1.0E7 ? this.edf.format(d) : this.ndf.format(d);
        return string;
    }
}

