/*
 * Decompiled with CFR 0.152.
 */
package imagescience.utility;

public class FMath {
    private static final double[] LNGAMMAC = new double[]{76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
    private static final double INVSQRT2PI = 1.0 / Math.sqrt(Math.PI * 2);
    private static final double ACC = 40.0;
    private static final double BIGNO = 1.0E10;
    private static final double BIGNI = 1.0E-10;
    private static final int MAXBIT = 30;

    public static int floor(double d) {
        if (d >= 0.0 || d == (double)((int)d)) {
            return (int)d;
        }
        return (int)(d - 1.0);
    }

    public static int ceil(double d) {
        if (d <= 0.0 || d == (double)((int)d)) {
            return (int)d;
        }
        return (int)(d + 1.0);
    }

    public static int round(double d) {
        double d2 = d + 0.5;
        if (d2 >= 0.0 || d2 == (double)((int)d2)) {
            return (int)d2;
        }
        return (int)(d2 - 1.0);
    }

    public static double clip(double d, double d2, double d3) {
        return d >= d3 ? d3 : (d <= d2 ? d2 : d);
    }

    public static double min(double d, double d2) {
        return d < d2 ? d : d2;
    }

    public static double min(double d, double d2, double d3, double d4) {
        double d5;
        double d6 = FMath.min(d, d2);
        return d6 < (d5 = FMath.min(d3, d4)) ? d6 : d5;
    }

    public static double min(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9;
        double d10 = FMath.min(d, d2, d3, d4);
        return d10 < (d9 = FMath.min(d5, d6, d7, d8)) ? d10 : d9;
    }

    public static double max(double d, double d2) {
        return d > d2 ? d : d2;
    }

    public static double max(double d, double d2, double d3, double d4) {
        double d5;
        double d6 = FMath.max(d, d2);
        return d6 > (d5 = FMath.max(d3, d4)) ? d6 : d5;
    }

    public static double max(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9;
        double d10 = FMath.max(d, d2, d3, d4);
        return d10 > (d9 = FMath.max(d5, d6, d7, d8)) ? d10 : d9;
    }

    public static double lngamma(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("Input value less than or equal to 0");
        }
        double d2 = d;
        double d3 = d + 5.5;
        d3 -= (d + 0.5) * Math.log(d3);
        double d4 = 1.000000000190015;
        for (int i = 0; i <= 5; ++i) {
            d4 += LNGAMMAC[i] / (d2 += 1.0);
        }
        return -d3 + Math.log(2.5066282746310007 * d4 / d);
    }

    public static double bspline(double d, int n, int n2) {
        int n3;
        if (n < 0) {
            throw new IllegalArgumentException("B-spline degree less than 0");
        }
        if (n2 < 0 || n2 > n) {
            throw new IllegalArgumentException("B-spline derivative order out of range");
        }
        double d2 = d + 0.5 * (double)(n + 1);
        if (d2 < 0.0 || d2 >= (double)(n + 1)) {
            return 0.0;
        }
        double[] dArray = new double[n + 1];
        for (n3 = 0; n3 <= n; ++n3) {
            dArray[n3] = d2 >= (double)n3 && d2 < (double)(n3 + 1) ? 1.0 : 0.0;
        }
        n3 = n - n2;
        int n4 = 1;
        int n5 = 2;
        int n6 = n - 1;
        while (n4 <= n3) {
            for (int i = 0; i <= n6; ++i) {
                dArray[i] = ((d2 - (double)i) * dArray[i] - (d2 - (double)i - (double)n5) * dArray[i + 1]) / (double)n4;
            }
            ++n4;
            ++n5;
            --n6;
        }
        n4 = n3 + 1;
        n5 = n - n3 - 1;
        while (n4 <= n) {
            for (n6 = 0; n6 <= n5; ++n6) {
                dArray[n6] = dArray[n6] - dArray[n6 + 1];
            }
            ++n4;
            --n5;
        }
        return dArray[0];
    }

    public static double gauss(double d, double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("Standard deviation less than or equal to 0");
        }
        return INVSQRT2PI * Math.exp(-d * d / (2.0 * d2 * d2)) / d2;
    }

    public static double sinc(double d) {
        if (d == 0.0) {
            return 1.0;
        }
        return Math.sin(d) / d;
    }

    public static double besselj0(double d) {
        double d2;
        double d3 = Math.abs(d);
        if (d2 < 8.0) {
            double d4 = d * d;
            double d5 = 5.7568490574E10 + d4 * (-1.3362590354E10 + d4 * (6.516196407E8 + d4 * (-1.121442418E7 + d4 * (77392.33017 + d4 * -184.9052456))));
            double d6 = 5.7568490411E10 + d4 * (1.029532985E9 + d4 * (9494680.718 + d4 * (59272.64853 + d4 * (267.8532712 + d4 * 1.0))));
            return d5 / d6;
        }
        double d7 = 8.0 / d3;
        double d8 = d7 * d7;
        double d9 = d3 - 0.785398164;
        double d10 = 1.0 + d8 * (-0.001098628627 + d8 * (2.734510407E-5 + d8 * (-2.073370639E-6 + d8 * 2.093887211E-7)));
        double d11 = -0.01562499995 + d8 * (1.430488765E-4 + d8 * (-6.911147651E-6 + d8 * (7.621095161E-7 - d8 * 9.34945152E-8)));
        return Math.sqrt(0.636619772 / d3) * (Math.cos(d9) * d10 - d7 * Math.sin(d9) * d11);
    }

    public static double besselj1(double d) {
        double d2;
        double d3 = Math.abs(d);
        if (d2 < 8.0) {
            double d4 = d * d;
            double d5 = d * (7.2362614232E10 + d4 * (-7.895059235E9 + d4 * (2.423968531E8 + d4 * (-2972611.439 + d4 * (15704.4826 + d4 * -30.16036606)))));
            double d6 = 1.44725228442E11 + d4 * (2.300535178E9 + d4 * (1.858330474E7 + d4 * (99447.43394 + d4 * (376.9991397 + d4 * 1.0))));
            return d5 / d6;
        }
        double d7 = 8.0 / d3;
        double d8 = d7 * d7;
        double d9 = d3 - 2.356194491;
        double d10 = 1.0 + d8 * (0.00183105 + d8 * (-3.516396496E-5 + d8 * (2.457520174E-6 + d8 * -2.40337019E-7)));
        double d11 = 0.04687499995 + d8 * (-2.002690873E-4 + d8 * (8.449199096E-6 + d8 * (-8.8228987E-7 + d8 * 1.05787412E-7)));
        d10 = Math.sqrt(0.636619772 / d3) * (Math.cos(d9) * d10 - d7 * Math.sin(d9) * d11);
        if (d < 0.0) {
            return -d10;
        }
        return d10;
    }

    public static double besselj(int n, double d) {
        double d2;
        if (n < 0) {
            throw new IllegalArgumentException("Order value less than 0");
        }
        if (n == 0) {
            return FMath.besselj0(d);
        }
        if (n == 1) {
            return FMath.besselj1(d);
        }
        if (d == 0.0) {
            return 0.0;
        }
        double d3 = Math.abs(d);
        if (d3 > (double)n) {
            double d4 = 2.0 / d3;
            double d5 = FMath.besselj0(d3);
            d2 = FMath.besselj1(d3);
            for (int i = 1; i < n; ++i) {
                double d6 = (double)i * d4 * d2 - d5;
                d5 = d2;
                d2 = d6;
            }
        } else {
            double d7 = 2.0 / d3;
            int n2 = 2 * ((n + (int)Math.sqrt(40.0 * (double)n)) / 2);
            boolean bl = false;
            double d8 = 0.0;
            d2 = 0.0;
            double d9 = 0.0;
            double d10 = 1.0;
            for (int i = n2; i > 0; --i) {
                double d11 = (double)i * d7 * d10 - d9;
                d9 = d10;
                d10 = d11;
                if (Math.abs(d10) > 1.0E10) {
                    d10 *= 1.0E-10;
                    d9 *= 1.0E-10;
                    d2 *= 1.0E-10;
                    d8 *= 1.0E-10;
                }
                if (bl) {
                    d8 += d10;
                }
                boolean bl2 = bl = !bl;
                if (i != n) continue;
                d2 = d9;
            }
            d8 = 2.0 * d8 - d10;
            d2 /= d8;
        }
        return d < 0.0 && (n & 1) == 1 ? -d2 : d2;
    }

    public static double lommelu(int n, int n2, double d, double d2) {
        if (n < 0) {
            throw new IllegalArgumentException("Order value less than 0");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("Number of terms less than or equal to 0");
        }
        if (d2 == 0.0) {
            throw new IllegalArgumentException("Second input value is 0");
        }
        double d3 = d * d / (d2 * d2);
        double d4 = Math.pow(d / d2, n);
        double d5 = 0.0;
        int n3 = 1;
        for (int i = 0; i < n2; ++i) {
            d5 += (double)n3 * d4 * FMath.besselj(n + 2 * i, d2);
            d4 *= d3;
            n3 *= -1;
        }
        return d5;
    }

    public static double lommelv(int n, int n2, double d, double d2) {
        if (n < 0) {
            throw new IllegalArgumentException("Order value less than 0");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("Number of terms less than or equal to 0");
        }
        if (d == 0.0) {
            throw new IllegalArgumentException("First input value is 0");
        }
        double d3 = d2 * d2 / (d * d);
        double d4 = Math.pow(d2 / d, n);
        double d5 = 0.0;
        int n3 = 1;
        for (int i = 0; i < n2; ++i) {
            d5 += (double)n3 * d4 * FMath.besselj(n + 2 * i, d2);
            d4 *= d3;
            n3 *= -1;
        }
        return d5;
    }

    public static boolean power2(int n) {
        int n2 = 0;
        int n3 = 1;
        while (n2 <= 30) {
            if (n == n3) {
                return true;
            }
            ++n2;
            n3 <<= 1;
        }
        return false;
    }
}

