/*
 * Decompiled with CFR 0.152.
 */
package imagescience.transform;

import imagescience.shape.Point;

public class Transform {
    public double axx;
    public double axy;
    public double axz;
    public double axt;
    public double ayx;
    public double ayy;
    public double ayz;
    public double ayt;
    public double azx;
    public double azy;
    public double azz;
    public double azt;

    public Transform() {
        this.reset();
    }

    public Transform(Transform transform) {
        this.set(transform);
    }

    public Transform(double[][] dArray) {
        this.set(dArray);
    }

    public Transform(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        this.set(d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12);
    }

    public Transform duplicate() {
        Transform transform = new Transform();
        transform.axx = this.axx;
        transform.axy = this.axy;
        transform.axz = this.axz;
        transform.axt = this.axt;
        transform.ayx = this.ayx;
        transform.ayy = this.ayy;
        transform.ayz = this.ayz;
        transform.ayt = this.ayt;
        transform.azx = this.azx;
        transform.azy = this.azy;
        transform.azz = this.azz;
        transform.azt = this.azt;
        return transform;
    }

    public boolean equals(Transform transform) {
        if (transform == null) {
            return false;
        }
        return this.axx == transform.axx && this.axy == transform.axy && this.axz == transform.axz && this.axt == transform.axt && this.ayx == transform.ayx && this.ayy == transform.ayy && this.ayz == transform.ayz && this.ayt == transform.ayt && this.azx == transform.azx && this.azy == transform.azy && this.azz == transform.azz && this.azt == transform.azt;
    }

    public boolean identity() {
        return this.axx == 1.0 && this.axy == 0.0 && this.axz == 0.0 && this.axt == 0.0 && this.ayx == 0.0 && this.ayy == 1.0 && this.ayz == 0.0 && this.ayt == 0.0 && this.azx == 0.0 && this.azy == 0.0 && this.azz == 1.0 && this.azt == 0.0;
    }

    public void reset() {
        this.axx = 1.0;
        this.axy = 0.0;
        this.axz = 0.0;
        this.axt = 0.0;
        this.ayx = 0.0;
        this.ayy = 1.0;
        this.ayz = 0.0;
        this.ayt = 0.0;
        this.azx = 0.0;
        this.azy = 0.0;
        this.azz = 1.0;
        this.azt = 0.0;
    }

    public double determinant() {
        return this.axx * (this.ayy * this.azz - this.ayz * this.azy) + this.axy * (this.ayz * this.azx - this.ayx * this.azz) + this.axz * (this.ayx * this.azy - this.ayy * this.azx);
    }

    public void invert() {
        double d = this.determinant();
        if (d == 0.0) {
            throw new IllegalStateException("Non-invertible transformation matrix");
        }
        double d2 = (this.ayy * this.azz - this.ayz * this.azy) / d;
        double d3 = (this.axz * this.azy - this.axy * this.azz) / d;
        double d4 = (this.axy * this.ayz - this.axz * this.ayy) / d;
        double d5 = (this.axy * (this.azz * this.ayt - this.ayz * this.azt) + this.axz * (this.ayy * this.azt - this.azy * this.ayt) + this.axt * (this.ayz * this.azy - this.ayy * this.azz)) / d;
        double d6 = (this.ayz * this.azx - this.ayx * this.azz) / d;
        double d7 = (this.axx * this.azz - this.axz * this.azx) / d;
        double d8 = (this.axz * this.ayx - this.axx * this.ayz) / d;
        double d9 = (this.axx * (this.ayz * this.azt - this.azz * this.ayt) + this.axz * (this.azx * this.ayt - this.ayx * this.azt) + this.axt * (this.ayx * this.azz - this.ayz * this.azx)) / d;
        double d10 = (this.ayx * this.azy - this.ayy * this.azx) / d;
        double d11 = (this.axy * this.azx - this.axx * this.azy) / d;
        double d12 = (this.axx * this.ayy - this.axy * this.ayx) / d;
        double d13 = (this.axx * (this.azy * this.ayt - this.ayy * this.azt) + this.axy * (this.ayx * this.azt - this.azx * this.ayt) + this.axt * (this.ayy * this.azx - this.ayx * this.azy)) / d;
        this.axx = d2;
        this.axy = d3;
        this.axz = d4;
        this.axt = d5;
        this.ayx = d6;
        this.ayy = d7;
        this.ayz = d8;
        this.ayt = d9;
        this.azx = d10;
        this.azy = d11;
        this.azz = d12;
        this.azt = d13;
    }

    public void transform(Transform transform) {
        double d = transform.axx * this.axx + transform.axy * this.ayx + transform.axz * this.azx;
        double d2 = transform.axx * this.axy + transform.axy * this.ayy + transform.axz * this.azy;
        double d3 = transform.axx * this.axz + transform.axy * this.ayz + transform.axz * this.azz;
        double d4 = transform.axx * this.axt + transform.axy * this.ayt + transform.axz * this.azt + transform.axt;
        double d5 = transform.ayx * this.axx + transform.ayy * this.ayx + transform.ayz * this.azx;
        double d6 = transform.ayx * this.axy + transform.ayy * this.ayy + transform.ayz * this.azy;
        double d7 = transform.ayx * this.axz + transform.ayy * this.ayz + transform.ayz * this.azz;
        double d8 = transform.ayx * this.axt + transform.ayy * this.ayt + transform.ayz * this.azt + transform.ayt;
        double d9 = transform.azx * this.axx + transform.azy * this.ayx + transform.azz * this.azx;
        double d10 = transform.azx * this.axy + transform.azy * this.ayy + transform.azz * this.azy;
        double d11 = transform.azx * this.axz + transform.azy * this.ayz + transform.azz * this.azz;
        double d12 = transform.azx * this.axt + transform.azy * this.ayt + transform.azz * this.azt + transform.azt;
        this.axx = d;
        this.axy = d2;
        this.axz = d3;
        this.axt = d4;
        this.ayx = d5;
        this.ayy = d6;
        this.ayz = d7;
        this.ayt = d8;
        this.azx = d9;
        this.azy = d10;
        this.azz = d11;
        this.azt = d12;
    }

    public void transform(Point point) {
        double d = this.axx * point.x + this.axy * point.y + this.axz * point.z + this.axt;
        double d2 = this.ayx * point.x + this.ayy * point.y + this.ayz * point.z + this.ayt;
        double d3 = this.azx * point.x + this.azy * point.y + this.azz * point.z + this.azt;
        point.x = d;
        point.y = d2;
        point.z = d3;
    }

    public void rotate(double d, int n) {
        double d2 = d * Math.PI / 180.0;
        double d3 = Math.cos(d2);
        double d4 = Math.sin(d2);
        switch (n) {
            case 1: {
                double d5 = this.ayx * d3 - this.azx * d4;
                double d6 = this.ayy * d3 - this.azy * d4;
                double d7 = this.ayz * d3 - this.azz * d4;
                double d8 = this.ayt * d3 - this.azt * d4;
                double d9 = this.azx * d3 + this.ayx * d4;
                double d10 = this.azy * d3 + this.ayy * d4;
                double d11 = this.azz * d3 + this.ayz * d4;
                double d12 = this.azt * d3 + this.ayt * d4;
                this.ayx = d5;
                this.ayy = d6;
                this.ayz = d7;
                this.ayt = d8;
                this.azx = d9;
                this.azy = d10;
                this.azz = d11;
                this.azt = d12;
                break;
            }
            case 2: {
                double d13 = this.axx * d3 + this.azx * d4;
                double d14 = this.axy * d3 + this.azy * d4;
                double d15 = this.axz * d3 + this.azz * d4;
                double d16 = this.axt * d3 + this.azt * d4;
                double d17 = this.azx * d3 - this.axx * d4;
                double d18 = this.azy * d3 - this.axy * d4;
                double d19 = this.azz * d3 - this.axz * d4;
                double d20 = this.azt * d3 - this.axt * d4;
                this.axx = d13;
                this.axy = d14;
                this.axz = d15;
                this.axt = d16;
                this.azx = d17;
                this.azy = d18;
                this.azz = d19;
                this.azt = d20;
                break;
            }
            case 4: {
                double d21 = this.axx * d3 - this.ayx * d4;
                double d22 = this.axy * d3 - this.ayy * d4;
                double d23 = this.axz * d3 - this.ayz * d4;
                double d24 = this.axt * d3 - this.ayt * d4;
                double d25 = this.ayx * d3 + this.axx * d4;
                double d26 = this.ayy * d3 + this.axy * d4;
                double d27 = this.ayz * d3 + this.axz * d4;
                double d28 = this.ayt * d3 + this.axt * d4;
                this.axx = d21;
                this.axy = d22;
                this.axz = d23;
                this.axt = d24;
                this.ayx = d25;
                this.ayy = d26;
                this.ayz = d27;
                this.ayt = d28;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid rotation axis.");
            }
        }
    }

    public void scale(double d, int n) {
        switch (n) {
            case 1: {
                this.axx *= d;
                this.axy *= d;
                this.axz *= d;
                this.axt *= d;
                break;
            }
            case 2: {
                this.ayx *= d;
                this.ayy *= d;
                this.ayz *= d;
                this.ayt *= d;
                break;
            }
            case 4: {
                this.azx *= d;
                this.azy *= d;
                this.azz *= d;
                this.azt *= d;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid scaling axis.");
            }
        }
    }

    public void shear(double d, int n, int n2) {
        block0 : switch (n) {
            case 1: {
                switch (n2) {
                    case 1: {
                        this.scale(d, 1);
                        break block0;
                    }
                    case 2: {
                        this.axx += this.ayx * d;
                        this.axy += this.ayy * d;
                        this.axz += this.ayz * d;
                        this.axt += this.ayt * d;
                        break block0;
                    }
                    case 4: {
                        this.axx += this.azx * d;
                        this.axy += this.azy * d;
                        this.axz += this.azz * d;
                        this.axt += this.azt * d;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Invalid driving axis.");
            }
            case 2: {
                switch (n2) {
                    case 1: {
                        this.ayx += this.axx * d;
                        this.ayy += this.axy * d;
                        this.ayz += this.axz * d;
                        this.ayt += this.axt * d;
                        break block0;
                    }
                    case 2: {
                        this.scale(d, 2);
                        break block0;
                    }
                    case 4: {
                        this.ayx += this.azx * d;
                        this.ayy += this.azy * d;
                        this.ayz += this.azz * d;
                        this.ayt += this.azt * d;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Invalid driving axis.");
            }
            case 4: {
                switch (n2) {
                    case 1: {
                        this.azx += this.axx * d;
                        this.azy += this.axy * d;
                        this.azz += this.axz * d;
                        this.azt += this.axt * d;
                        break block0;
                    }
                    case 2: {
                        this.azx += this.ayx * d;
                        this.azy += this.ayy * d;
                        this.azz += this.ayz * d;
                        this.azt += this.ayt * d;
                        break block0;
                    }
                    case 4: {
                        this.scale(d, 4);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Invalid driving axis.");
            }
            default: {
                throw new IllegalArgumentException("Invalid shearing axis.");
            }
        }
    }

    public void translate(double d, int n) {
        switch (n) {
            case 1: {
                this.axt += d;
                break;
            }
            case 2: {
                this.ayt += d;
                break;
            }
            case 4: {
                this.azt += d;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid translation axis.");
            }
        }
    }

    public void set(Transform transform) {
        this.axx = transform.axx;
        this.axy = transform.axy;
        this.axz = transform.axz;
        this.axt = transform.axt;
        this.ayx = transform.ayx;
        this.ayy = transform.ayy;
        this.ayz = transform.ayz;
        this.ayt = transform.ayt;
        this.azx = transform.azx;
        this.azy = transform.azy;
        this.azz = transform.azz;
        this.azt = transform.azt;
    }

    public void set(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        this.axx = d;
        this.axy = d2;
        this.axz = d3;
        this.axt = d4;
        this.ayx = d5;
        this.ayy = d6;
        this.ayz = d7;
        this.ayt = d8;
        this.azx = d9;
        this.azy = d10;
        this.azz = d11;
        this.azt = d12;
    }

    public void set(double[][] dArray) {
        if (dArray.length != 4) {
            throw new IllegalArgumentException("Array does not contain 4 rows");
        }
        for (int i = 0; i < 4; ++i) {
            if (dArray[i].length == 4) continue;
            throw new IllegalArgumentException("Row " + i + " of the array does not contain 4 columns");
        }
        this.axx = dArray[0][0];
        this.axy = dArray[0][1];
        this.axz = dArray[0][2];
        this.axt = dArray[0][3];
        this.ayx = dArray[1][0];
        this.ayy = dArray[1][1];
        this.ayz = dArray[1][2];
        this.ayt = dArray[1][3];
        this.azx = dArray[2][0];
        this.azy = dArray[2][1];
        this.azz = dArray[2][2];
        this.azt = dArray[2][3];
    }

    public void set(int n, int n2, double d) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("Row index out of bounds");
        }
        if (n2 < 0 || n2 > 3) {
            throw new IllegalArgumentException("Column index out of bounds");
        }
        int n3 = n * 10 + n2;
        switch (n3) {
            case 0: {
                this.axx = d;
                break;
            }
            case 1: {
                this.axy = d;
                break;
            }
            case 2: {
                this.axz = d;
                break;
            }
            case 3: {
                this.axt = d;
                break;
            }
            case 10: {
                this.ayx = d;
                break;
            }
            case 11: {
                this.ayy = d;
                break;
            }
            case 12: {
                this.ayz = d;
                break;
            }
            case 13: {
                this.ayt = d;
                break;
            }
            case 20: {
                this.azx = d;
                break;
            }
            case 21: {
                this.azy = d;
                break;
            }
            case 22: {
                this.azz = d;
                break;
            }
            case 23: {
                this.azt = d;
            }
        }
    }

    public double[][] get() {
        double[][] dArray = new double[4][4];
        dArray[0][0] = this.axx;
        dArray[0][1] = this.axy;
        dArray[0][2] = this.axz;
        dArray[0][3] = this.axt;
        dArray[1][0] = this.ayx;
        dArray[1][1] = this.ayy;
        dArray[1][2] = this.ayz;
        dArray[1][3] = this.ayt;
        dArray[2][0] = this.azx;
        dArray[2][1] = this.azy;
        dArray[2][2] = this.azz;
        dArray[2][3] = this.azt;
        dArray[3][0] = 0.0;
        dArray[3][1] = 0.0;
        dArray[3][2] = 0.0;
        dArray[3][3] = 1.0;
        return dArray;
    }

    public double get(int n, int n2) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("Row index out of bounds");
        }
        if (n2 < 0 || n2 > 3) {
            throw new IllegalArgumentException("Column index out of bounds");
        }
        int n3 = n * 10 + n2;
        switch (n3) {
            case 0: {
                return this.axx;
            }
            case 1: {
                return this.axy;
            }
            case 2: {
                return this.axz;
            }
            case 3: {
                return this.axt;
            }
            case 10: {
                return this.ayx;
            }
            case 11: {
                return this.ayy;
            }
            case 12: {
                return this.ayz;
            }
            case 13: {
                return this.ayt;
            }
            case 20: {
                return this.azx;
            }
            case 21: {
                return this.azy;
            }
            case 22: {
                return this.azz;
            }
            case 23: {
                return this.azt;
            }
            case 30: {
                return 0.0;
            }
            case 31: {
                return 0.0;
            }
            case 32: {
                return 0.0;
            }
            case 33: {
                return 1.0;
            }
        }
        return 0.0;
    }

    public String string() {
        return this.string("[  ", "   ", "  ]\n");
    }

    public String string(String string, String string2, String string3) {
        String string4;
        String string5;
        String string6 = string;
        if (string6 == null) {
            string6 = "";
        }
        if ((string5 = string2) == null) {
            string5 = "";
        }
        if ((string4 = string3) == null) {
            string4 = "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string6 + this.axx + string5 + this.axy + string5 + this.axz + string5 + this.axt + string4);
        stringBuffer.append(string6 + this.ayx + string5 + this.ayy + string5 + this.ayz + string5 + this.ayt + string4);
        stringBuffer.append(string6 + this.azx + string5 + this.azy + string5 + this.azz + string5 + this.azt + string4);
        stringBuffer.append(string6 + "0.0" + string5 + "0.0" + string5 + "0.0" + string5 + "1.0" + string4);
        return stringBuffer.toString();
    }
}

